/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.twod;

public enum QRCodeErrorCorrection {
    L(1, 7, "Low"),
    M(2, 15, "Medium"),
    Q(3, 25, "Quartile"),
    H(4, 30, "High");

    private final int myID;
    private final int myRedundancy;
    private final String myDescription;
    private static final QRCodeErrorCorrection[] cachedValues;

    private QRCodeErrorCorrection(int id, int redundancy, String description) {
        this.myID = id;
        this.myRedundancy = redundancy;
        this.myDescription = description;
    }

    public static QRCodeErrorCorrection valueOf(int id) {
        if (id > 0 && id < 5) {
            return cachedValues[id - 1];
        }
        throw new IllegalArgumentException("Invalid QR Code error correction ID: " + id);
    }

    public int getID() {
        return this.myID;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public int getRedundancy() {
        return this.myRedundancy;
    }

    static {
        cachedValues = QRCodeErrorCorrection.values();
    }
}

