/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.twod;

public class PDF417Size {
    public static final int ROWS_MIN = 3;
    public static final int ROWS_MAX = 90;
    public static final int COLS_MIN = 1;
    public static final int COLS_MAX = 30;
    public final int cols;
    public final int rows;

    public PDF417Size(int cols, int rows) {
        if (cols != 0 && (cols < 1 || cols > 30)) {
            throw new IllegalArgumentException("Invalid PDF417 column count: " + cols);
        }
        if (rows != 0 && (rows < 3 || rows > 90)) {
            throw new IllegalArgumentException("Invalid PDF417 row count: " + rows);
        }
        this.cols = cols;
        this.rows = rows;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PDF417Size) {
            PDF417Size other = (PDF417Size)obj;
            return this.cols == other.cols && this.rows == other.rows;
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.cols + this.rows;
    }

    public String toString() {
        return this.getClass().getName() + "[cols=" + this.cols + ",rows=" + this.rows + "]";
    }
}

