/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.twod;

public enum PDF417ErrorCorrection {
    EC0(0),
    EC1(1),
    EC2(2),
    EC3(3),
    EC4(4),
    EC5(5),
    EC6(6),
    EC7(7),
    EC8(8);

    private final int myLevelNumber;
    private static final PDF417ErrorCorrection[] cachedValues;

    private PDF417ErrorCorrection(int levelNumber) {
        this.myLevelNumber = levelNumber;
    }

    public static PDF417ErrorCorrection valueOf(int levelNumber) {
        if (levelNumber < 0 || levelNumber > 8) {
            throw new IllegalArgumentException("Invalid PDF417 error correction level: " + levelNumber);
        }
        return cachedValues[levelNumber];
    }

    public int getLevelNumber() {
        return this.myLevelNumber;
    }

    public int getErrorCorrectionCodewords() {
        return 2 << this.myLevelNumber;
    }

    static {
        cachedValues = PDF417ErrorCorrection.values();
    }
}

