/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.twod;

public enum DataMatrixSize {
    AUTO(0, 0, 0),
    S01(1, 10, 10),
    S02(2, 12, 12),
    S03(3, 14, 14),
    S04(4, 16, 16),
    S05(5, 18, 8),
    S06(6, 18, 18),
    S07(7, 20, 20),
    S08(8, 22, 22),
    S09(9, 24, 24),
    S10(10, 26, 12),
    S11(11, 26, 26),
    S12(12, 32, 8),
    S13(13, 32, 32),
    S14(14, 36, 12),
    S15(15, 36, 16),
    S16(16, 36, 36),
    S17(17, 40, 40),
    S18(18, 44, 44),
    S19(19, 48, 16),
    S20(20, 48, 48),
    S21(21, 52, 52),
    S22(22, 64, 64),
    S23(23, 72, 72),
    S24(24, 80, 80),
    S25(25, 88, 88),
    S26(26, 96, 96),
    S27(27, 104, 104),
    S28(28, 120, 120),
    S29(29, 132, 132),
    S30(30, 144, 144);

    private final int myID;
    private final int myWidth;
    private final int myHeight;
    private static final DataMatrixSize[] cachedValues;

    private DataMatrixSize(int id, int width, int height) {
        this.myID = id;
        this.myWidth = width;
        this.myHeight = height;
    }

    public static DataMatrixSize valueOf(int id) {
        if (id < 0 || id > 30) {
            throw new IllegalArgumentException("Invalid DataMatrix size ID: " + id);
        }
        return cachedValues[id];
    }

    public int getID() {
        return this.myID;
    }

    public int getWidth() {
        return this.myWidth;
    }

    public int getHeight() {
        return this.myHeight;
    }

    public boolean isSquare() {
        return this.myID > 0 && this.myWidth == this.myHeight;
    }

    public boolean isRectangle() {
        return this.myID > 0 && this.myWidth != this.myHeight;
    }

    static {
        cachedValues = DataMatrixSize.values();
    }
}

