/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.twod;

public enum AztecSize {
    AUTO(0, 0),
    COMPACT01(-1, 15),
    COMPACT02(-2, 19),
    COMPACT03(-3, 23),
    COMPACT04(-4, 27),
    NORMAL01(1, 19),
    NORMAL02(2, 23),
    NORMAL03(3, 27),
    NORMAL04(4, 31),
    NORMAL05(5, 37),
    NORMAL06(6, 41),
    NORMAL07(7, 45),
    NORMAL08(8, 49),
    NORMAL09(9, 53),
    NORMAL10(10, 57),
    NORMAL11(11, 61),
    NORMAL12(12, 67),
    NORMAL13(13, 71),
    NORMAL14(14, 75),
    NORMAL15(15, 79),
    NORMAL16(16, 83),
    NORMAL17(17, 87),
    NORMAL18(18, 91),
    NORMAL19(19, 95),
    NORMAL20(20, 101),
    NORMAL21(21, 105),
    NORMAL22(22, 109),
    NORMAL23(23, 113),
    NORMAL24(24, 117),
    NORMAL25(25, 121),
    NORMAL26(26, 125),
    NORMAL27(27, 131),
    NORMAL28(28, 135),
    NORMAL29(29, 139),
    NORMAL30(30, 143),
    NORMAL31(31, 147),
    NORMAL32(32, 151);

    private final int myLayerCount;
    private final int mySize;
    private static final AztecSize[] cachedValues;

    private AztecSize(int layerCount, int size) {
        this.myLayerCount = layerCount;
        this.mySize = size;
    }

    public static AztecSize valueOf(int layerCount) {
        if (layerCount < -4 || layerCount > 32) {
            throw new IllegalArgumentException("Invalid Aztec layer count: " + layerCount);
        }
        if (layerCount > 0) {
            return cachedValues[layerCount + 4];
        }
        return cachedValues[-layerCount];
    }

    public int getLayerCount() {
        return this.myLayerCount;
    }

    public int getSize() {
        return this.mySize;
    }

    public boolean isNormal() {
        return this.myLayerCount > 0;
    }

    public boolean isCompact() {
        return this.myLayerCount < 0;
    }

    static {
        cachedValues = AztecSize.values();
    }
}

