/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.Barcode;
import de.vwsoft.barcodelib4j.oned.BarcodeException;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class UPCEANFamily
extends Barcode {
    private static final int[] BARS = new int[]{13, 25, 19, 61, 35, 49, 47, 59, 55, 11};
    private static final int[] ADDON5_PARITIES = new int[]{24, 20, 18, 17, 12, 6, 3, 10, 9, 5};
    private static final int ADDON_RIGHT_QUIET_ZONE = 5;
    private String myAddOn;
    private int[] myTestBar;
    transient String myNumberPart1;
    transient String myNumberPart2;
    transient String myNumberPart3;
    transient String myNumberPart4;

    UPCEANFamily() {
    }

    abstract String getBarLengthPattern();

    @Override
    public void setAddOn(String addOnNumber) throws BarcodeException {
        if (addOnNumber != null) {
            if (addOnNumber.isEmpty()) {
                throw new BarcodeException(305, "Add-On number must not be empty", "Add-On-Nummer darf nicht leer sein", new Object[0]);
            }
            if (addOnNumber.length() != 2 && addOnNumber.length() != 5) {
                throw new BarcodeException(310, "Add-On number length must be either 2 or 5; Provided: %s", "L\u00e4nge der Add-On-Nummer muss entweder 2 oder 5 sein; Aktuell: %s", addOnNumber.length());
            }
            if (UPCEANFamily.findNonDigitPosition(addOnNumber) >= 0) {
                throw new BarcodeException(315, "Add-On number must consist only of digits", "Add-On-Nummer darf nur aus Ziffern bestehen", new Object[0]);
            }
        }
        this.myAddOn = addOnNumber;
        this.invalidateDrawing();
    }

    @Override
    public String getAddOn() {
        return this.myAddOn;
    }

    @Override
    public boolean supportsAddOn() {
        return true;
    }

    @Override
    public boolean supportsCustomText() {
        return false;
    }

    @Override
    public boolean supportsTextOnTop() {
        return false;
    }

    public void setTestBar(int[] params) {
        this.myTestBar = params != null && params.length == 3 ? Arrays.copyOf(params, params.length) : null;
    }

    @Override
    CharSequence encode() {
        StringBuilder sb = new StringBuilder(165);
        sb.append("0".repeat(this.getQuietZoneLeft()));
        sb.append("101");
        this.encodeLeftPart(sb);
        sb.append("01010");
        this.encodeRightPart(sb);
        sb.append("101");
        sb.append("0".repeat(this.getQuietZoneRight()));
        this.encodeAddOn(sb);
        return sb;
    }

    void encodeLeftPart(StringBuilder sb) {
    }

    void encodeRightPart(StringBuilder sb) {
    }

    void encodeAddOn(StringBuilder sb) {
        if (this.myAddOn != null) {
            sb.append("1011");
            if (this.myAddOn.length() == 2) {
                int m = Integer.parseInt(this.myAddOn) % 4;
                sb.append(m < 2 ? UPCEANFamily.encodeA(this.myAddOn.charAt(0) - 48) : UPCEANFamily.encodeB(this.myAddOn.charAt(0) - 48));
                sb.append("01");
                sb.append(m % 2 == 0 ? UPCEANFamily.encodeA(this.myAddOn.charAt(1) - 48) : UPCEANFamily.encodeB(this.myAddOn.charAt(1) - 48));
            } else {
                int m = 0;
                for (int i = 4; i >= 0; --i) {
                    m += (i % 2 == 0 ? 3 : 9) * (this.myAddOn.charAt(i) - 48);
                }
                int parity = ADDON5_PARITIES[m % 10];
                for (int i = 4; i >= 0; --i) {
                    sb.append((parity >> i & 1) == 0 ? UPCEANFamily.encodeA(this.myAddOn.charAt(4 - i) - 48) : UPCEANFamily.encodeB(this.myAddOn.charAt(4 - i) - 48));
                    if (i == 0) continue;
                    sb.append("01");
                }
            }
            sb.append("0".repeat(5));
        }
    }

    @Override
    public void draw(Graphics2D g2d, double x, double y, double w, double h, double barWidthCorrection) {
        if (this.myBars == null) {
            this.prepareDrawing();
        }
        String barLengthPattern = this.getBarLengthPattern();
        double widthOfASingleBar = w / (double)this.myBarsCount;
        int leftQuietZone = this.getQuietZoneLeft();
        double fontHeight = 0.0;
        if (this.myIsTextVisible) {
            Font font = this.myFont != null ? this.myFont : g2d.getFont();
            float fontSize = font.getSize2D();
            if (this.myIsFontSizeAdjusted) {
                fontSize = 0.0f;
                double m = (double)(this.myNumberPart2.length() * 7) * widthOfASingleBar;
                do {
                    g2d.setFont(font.deriveFont(fontSize += 0.1f));
                } while (g2d.getFontMetrics().getStringBounds(this.myNumberPart2, g2d).getWidth() < m);
                fontSize -= 0.1f;
            }
            if (fontSize > 0.0f) {
                g2d.setFont(font.deriveFont(fontSize));
                FontMetrics fm = g2d.getFontMetrics();
                double ascent = fm.getLineMetrics(this.myNumberPart2, g2d).getAscent();
                double descent = widthOfASingleBar * 1.5;
                fontHeight = ascent + descent + this.myTextOffset;
                float fy = (float)(y + h - descent);
                int numberOfBars = this.myBarsCount;
                if (this.myAddOn != null) {
                    int numberOfAddOnBars = this.myAddOn.length() == 2 ? 20 : 47;
                    g2d.drawString(this.myAddOn, (float)(x + widthOfASingleBar * (double)(numberOfBars -= numberOfAddOnBars + 5) + ((double)numberOfAddOnBars * widthOfASingleBar - fm.getStringBounds(this.myAddOn, g2d).getWidth()) / 2.0), (float)(y + this.myTextOffset + ascent));
                }
                if (this.myNumberPart1 != null) {
                    g2d.drawString(this.myNumberPart1, (float)x, fy);
                }
                double part2Pos = (double)barLengthPattern.indexOf(48) + 0.5;
                g2d.drawString(this.myNumberPart2, (float)(x + widthOfASingleBar * ((double)leftQuietZone + part2Pos) + ((double)(this.myNumberPart2.length() * 7) * widthOfASingleBar - fm.getStringBounds(this.myNumberPart2, g2d).getWidth()) / 2.0), fy);
                if (this.myNumberPart3 != null) {
                    double part3Pos = (double)barLengthPattern.indexOf(49, 30) + 4.5;
                    g2d.drawString(this.myNumberPart3, (float)(x + widthOfASingleBar * ((double)leftQuietZone + part3Pos) + ((double)(this.myNumberPart3.length() * 7) * widthOfASingleBar - fm.getStringBounds(this.myNumberPart3, g2d).getWidth()) / 2.0), fy);
                }
                if (this.myNumberPart4 != null) {
                    g2d.drawString(this.myNumberPart4, (float)(x + widthOfASingleBar * (double)numberOfBars - fm.getStringBounds(this.myNumberPart4, g2d).getWidth()), fy);
                }
            }
            if (this.myText != null) {
                int overhang = 5;
                double textWidth = 105.0 * widthOfASingleBar;
                Font font2 = new Font("SansSerif", 0, 1);
                float fontSize2 = 0.0f;
                do {
                    g2d.setFont(font2.deriveFont(fontSize2 += 0.1f));
                } while (g2d.getFontMetrics().getStringBounds(this.myText, g2d).getWidth() < textWidth);
                if ((fontSize2 -= 0.1f) > 0.0f) {
                    g2d.setFont(font2.deriveFont(fontSize2));
                    FontMetrics fm = g2d.getFontMetrics();
                    g2d.drawString(this.myText, (float)(x + widthOfASingleBar * (double)(leftQuietZone - 5) + (textWidth - fm.getStringBounds(this.myText, g2d).getWidth()) / 2.0), (float)(y - (double)fm.getLineMetrics(this.myText, g2d).getDescent()));
                }
            }
        }
        double nonGuardBarHeight = h - fontHeight;
        double guardBarHeight = !this.myIsTextVisible ? nonGuardBarHeight : nonGuardBarHeight + widthOfASingleBar * 5.0;
        double addOnBarY = y + fontHeight;
        double addOnBarHeight = guardBarHeight - fontHeight;
        double xShifted = x - barWidthCorrection;
        double bwcTwice = barWidthCorrection * 2.0;
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, y, 0.0, 0.0);
        for (int i = 0; i != this.myBars.length; i += 2) {
            rect.x = xShifted + widthOfASingleBar * (double)this.myBars[i];
            rect.width = widthOfASingleBar * (double)this.myBars[i + 1] + bwcTwice;
            switch (barLengthPattern.charAt(this.myBars[i] - leftQuietZone)) {
                case '0': {
                    rect.height = nonGuardBarHeight;
                    break;
                }
                case '1': {
                    rect.height = guardBarHeight;
                    break;
                }
                default: {
                    rect.height = addOnBarHeight;
                    rect.y = addOnBarY;
                }
            }
            g2d.fill(rect);
        }
        if (this.myTestBar != null) {
            int addOnPos = barLengthPattern.indexOf(50, 51);
            rect.x = xShifted + widthOfASingleBar * (double)(leftQuietZone - this.myTestBar[2]);
            rect.y = y + widthOfASingleBar * (double)this.myTestBar[1];
            rect.width = widthOfASingleBar * (double)(addOnPos + 2 * this.myTestBar[2]) + bwcTwice;
            rect.height = widthOfASingleBar * (double)this.myTestBar[0];
            g2d.fill(rect);
        }
    }

    static String encodeA(int digit) {
        String s = Integer.toBinaryString(BARS[digit]);
        return "0".repeat(7 - s.length()) + s;
    }

    static String encodeB(int digit) {
        return new StringBuilder(UPCEANFamily.encodeC(digit)).reverse().toString();
    }

    static String encodeC(int digit) {
        StringBuilder sb = new StringBuilder(7);
        for (int i = 6; i != 0; --i) {
            sb.append(BARS[digit] >> i & 1 ^ 1);
        }
        return sb.append('0').toString();
    }

    final void setContentISxN(String content, boolean autoComplete, String typeName) throws BarcodeException {
        int numberOfTokens;
        ArrayList<String> tokens = new ArrayList<String>(5);
        StringBuilder sb = new StringBuilder(7);
        int len = ((String)content).length();
        for (int i = 0; i != len; ++i) {
            char c = ((String)content).charAt(i);
            if (UPCEANFamily.isDigit(c)) {
                sb.append(c);
                continue;
            }
            if (c == '-') {
                if (tokens.size() == 4) {
                    throw new BarcodeException(110, "Number has more than 5 segments", "Nummer besteht aus mehr als 5 Teilen", new Object[0]);
                }
                tokens.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            throw new BarcodeException(110, "Invalid character at position %s", "Ung\u00fcltiges Zeichen an Position %s", i);
        }
        if (sb.length() != 0) {
            tokens.add(sb.toString());
        }
        if (!((numberOfTokens = tokens.size()) == 5 || autoComplete && numberOfTokens == 4)) {
            throw new BarcodeException(110, "Incorrect number of segments: %s", "Falsche Anzahl an Teilen: %s", numberOfTokens);
        }
        String isxnPrefix = (String)tokens.get(0);
        String isxnGroup = (String)tokens.get(1);
        String isxnPublisher = (String)tokens.get(2);
        String isxnItem = (String)tokens.get(3);
        if (isxnGroup.length() > 5 || isxnPublisher.length() > 7 || isxnItem.length() > 6) {
            throw new BarcodeException(110, "Some segments have incorrect length", "Einige Teile haben inkorrekte L\u00e4nge", new Object[0]);
        }
        String ean13 = isxnPrefix + isxnGroup + isxnPublisher + isxnItem;
        if (ean13.length() != 12) {
            throw new BarcodeException(125, "Expected number of digits excluding check digit: 12; Provided: %s", "Erwartete Anzahl der Ziffern ohne Pr\u00fcfziffer: 12; Aktuell: %s", ean13.length());
        }
        if (numberOfTokens == 5) {
            String checkDigit = (String)tokens.get(4);
            if (checkDigit.length() != 1) {
                throw new BarcodeException(205, "Check digit must be one character; Provided: %s", "Pr\u00fcfziffer muss einstellig sein; Aktuell: %s", checkDigit.length());
            }
            ean13 = ean13 + checkDigit;
            UPCEANFamily.validateModulo10(ean13);
        } else {
            int checkDigit = UPCEANFamily.calculateModulo10(ean13);
            ean13 = ean13 + checkDigit;
            if (((String)content).charAt(((String)content).length() - 1) != '-') {
                content = (String)content + "-";
            }
            content = (String)content + checkDigit;
        }
        this.myContent = ean13;
        this.myText = typeName + " " + (String)content;
        this.invalidateDrawing();
    }
}

