/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.BarcodeException;
import de.vwsoft.barcodelib4j.oned.UPCEANFamily;

public class ImplUPCE
extends UPCEANFamily {
    private static final String BAR_LENGTH_PATTERN = "1".repeat(3) + "0".repeat(42) + "1".repeat(6) + "2".repeat(54);
    private static final int[] CHARSET_PATTERN = new int[]{56, 52, 50, 49, 44, 38, 35, 42, 41, 37};

    ImplUPCE() {
        try {
            this.setContent("12345670", false, false);
        }
        catch (BarcodeException barcodeException) {
            // empty catch block
        }
    }

    @Override
    String getBarLengthPattern() {
        return BAR_LENGTH_PATTERN;
    }

    @Override
    int getQuietZoneLeft() {
        return 9;
    }

    @Override
    int getQuietZoneRight() {
        return 7;
    }

    @Override
    public void setContent(String content, boolean autoComplete, boolean appendOptionalChecksum) throws BarcodeException {
        ImplUPCE.validateNotEmpty((CharSequence)content);
        ImplUPCE.validateDigits((CharSequence)content);
        char firstDigit = ((String)content).charAt(0);
        if (firstDigit != '0' && firstDigit != '1') {
            throw new BarcodeException(110, "Number must start with 0 or 1; Provided: %s", "Nummer muss mit 0 oder 1 beginnen; Aktuell: %s", Character.valueOf(firstDigit));
        }
        if (autoComplete && ((String)content).length() == 7) {
            content = (String)content + ImplUPCE.calculateModulo10(ImplUPCE.convertToUPCA((String)content));
        } else {
            ImplUPCE.validateFixedLength((CharSequence)content, 8);
            ImplUPCE.validateModulo10(ImplUPCE.convertToUPCA((String)content));
        }
        this.myContent = content;
        this.invalidateDrawing();
    }

    private static String convertToUPCA(String upce) {
        StringBuilder sb = new StringBuilder(12);
        sb.append(upce.charAt(0));
        char lastChar = upce.charAt(6);
        if (lastChar < '3') {
            sb.append(upce, 1, 3).append(lastChar).append("0000").append(upce, 3, 6);
        } else if (lastChar == '3') {
            sb.append(upce, 1, 4).append("00000").append(upce, 4, 6);
        } else if (lastChar == '4') {
            sb.append(upce, 1, 5).append("00000").append(upce.charAt(5));
        } else {
            sb.append(upce, 1, 6).append("0000").append(lastChar);
        }
        if (upce.length() == 8) {
            sb.append(upce.charAt(7));
        }
        return sb.toString();
    }

    @Override
    CharSequence encode() {
        StringBuilder sb = new StringBuilder(119);
        sb.append("0".repeat(this.getQuietZoneLeft()));
        sb.append("101");
        int firstDigit = this.myContent.charAt(0) - 48;
        int pattern = CHARSET_PATTERN[this.myContent.charAt(7) - 48];
        for (int i = 1; i < 7; ++i) {
            int digit = this.myContent.charAt(i) - 48;
            sb.append((pattern >> 6 - i & 1) == firstDigit ? ImplUPCE.encodeA(digit) : ImplUPCE.encodeB(digit));
        }
        sb.append("010101");
        sb.append("0".repeat(this.getQuietZoneRight()));
        this.encodeAddOn(sb);
        return sb;
    }

    @Override
    void prepareDrawing() {
        this.myNumberPart1 = this.myContent.substring(0, 1);
        this.myNumberPart2 = this.myContent.substring(1, 7);
        this.myNumberPart4 = this.myContent.substring(7, 8);
        super.prepareDrawing();
    }
}

