/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.BarcodeException;
import de.vwsoft.barcodelib4j.oned.UPCEANFamily;

public class ImplUPCA
extends UPCEANFamily {
    private static final String BAR_LENGTH_PATTERN = "1".repeat(10) + "0".repeat(35) + "1".repeat(5) + "0".repeat(35) + "1".repeat(10) + "2".repeat(56);

    ImplUPCA() {
        try {
            this.setContent("123456789012", false, false);
        }
        catch (BarcodeException barcodeException) {
            // empty catch block
        }
    }

    @Override
    String getBarLengthPattern() {
        return BAR_LENGTH_PATTERN;
    }

    @Override
    int getQuietZoneLeft() {
        return 9;
    }

    @Override
    int getQuietZoneRight() {
        return 9;
    }

    @Override
    public void setContent(String content, boolean autoComplete, boolean appendOptionalChecksum) throws BarcodeException {
        ImplUPCA.validateNotEmpty((CharSequence)content);
        ImplUPCA.validateDigits((CharSequence)content);
        if (autoComplete && ((String)content).length() == 11) {
            content = (String)content + ImplUPCA.calculateModulo10((CharSequence)content);
        } else {
            ImplUPCA.validateFixedLength((CharSequence)content, 12);
            ImplUPCA.validateModulo10((CharSequence)content);
        }
        this.myContent = content;
        this.invalidateDrawing();
    }

    @Override
    void encodeLeftPart(StringBuilder sb) {
        for (int i = 0; i != 6; ++i) {
            sb.append(ImplUPCA.encodeA(this.myContent.charAt(i) - 48));
        }
    }

    @Override
    void encodeRightPart(StringBuilder sb) {
        for (int i = 6; i != 12; ++i) {
            sb.append(ImplUPCA.encodeC(this.myContent.charAt(i) - 48));
        }
    }

    @Override
    void prepareDrawing() {
        this.myNumberPart1 = this.myContent.substring(0, 1);
        this.myNumberPart2 = this.myContent.substring(1, 6);
        this.myNumberPart3 = this.myContent.substring(6, 11);
        this.myNumberPart4 = this.myContent.substring(11, 12);
        super.prepareDrawing();
    }
}

