/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.BarcodeException;
import de.vwsoft.barcodelib4j.oned.ImplCode39;

public class ImplPZN8
extends ImplCode39 {
    ImplPZN8() {
        super("12345678");
    }

    @Override
    public boolean supportsOptionalChecksum() {
        return false;
    }

    @Override
    public void setOptionalChecksumVisible(boolean visible) {
    }

    @Override
    public boolean isOptionalChecksumVisible() {
        return false;
    }

    @Override
    public void setContent(String content, boolean autoComplete, boolean appendOptionalChecksum) throws BarcodeException {
        ImplPZN8.validateNotEmpty((CharSequence)content);
        ImplPZN8.validateDigits((CharSequence)content);
        if (autoComplete && ((String)content).length() == 7) {
            int checksum = this.calculateChecksum((String)content);
            if (checksum == 10) {
                throw new BarcodeException(205, "Invalid PZN8: Checksum cannot be 10", "Ung\u00fcltige PZN8: Pr\u00fcfziffer darf nicht 10 sein", new Object[0]);
            }
            content = (String)content + checksum;
        } else {
            ImplPZN8.validateFixedLength((CharSequence)content, 8);
            ImplPZN8.validateCheckDigit(((String)content).charAt(7) - 48, this.calculateChecksum((String)content));
        }
        this.myContent = "-" + (String)content;
        this.updateHumanReadableText();
        this.invalidateDrawing();
    }

    private int calculateChecksum(String content) {
        int sum = 0;
        for (int i = 6; i >= 0; --i) {
            sum += (i + 1) * (content.charAt(i) - 48);
        }
        return sum % 11;
    }

    @Override
    void updateHumanReadableText() {
        this.myText = "PZN " + this.myContent;
    }
}

