/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.Barcode;
import de.vwsoft.barcodelib4j.oned.BarcodeException;

public class ImplITF
extends Barcode {
    private static final int[] BARS = new int[]{6, 17, 9, 24, 5, 20, 12, 3, 18, 10};
    private String myOptionalChecksum;
    private boolean myIsOptionalChecksumVisible;

    ImplITF() {
        try {
            this.setContent("1234567890", false, false);
        }
        catch (BarcodeException barcodeException) {
            // empty catch block
        }
    }

    @Override
    CharSequence encode() {
        Object content = this.myContent;
        if (this.myOptionalChecksum != null) {
            content = (String)content + this.myOptionalChecksum;
        }
        int contentLength = ((String)content).length();
        String[] bars = new String[]{"1".repeat(this.myRatio.y), "1".repeat(this.myRatio.x)};
        String[] spaces = new String[]{"0".repeat(this.myRatio.y), "0".repeat(this.myRatio.x)};
        int leftQuietZone = this.getQuietZoneLeft() * this.myRatio.y;
        int rightQuietZone = this.getQuietZoneRight() * this.myRatio.y;
        StringBuilder sb = new StringBuilder(this.myRatio.y * 6 + leftQuietZone + rightQuietZone + this.myRatio.x + (2 * this.myRatio.x + 3 * this.myRatio.y) * contentLength);
        sb.append("0".repeat(leftQuietZone));
        sb.append(bars[0]).append(spaces[0]).append(bars[0]).append(spaces[0]);
        for (int i = 0; i < contentLength; i += 2) {
            int firstPartOfPair = BARS[((String)content).charAt(i) - 48];
            int secondPartOfPair = BARS[((String)content).charAt(i + 1) - 48];
            for (int j = 4; j >= 0; --j) {
                sb.append(bars[firstPartOfPair >> j & 1]);
                sb.append(spaces[secondPartOfPair >> j & 1]);
            }
        }
        sb.append(bars[1]).append(spaces[0]).append(bars[0]);
        sb.append("0".repeat(rightQuietZone));
        return sb;
    }

    @Override
    double calculateModuleFactor() {
        int len = this.myContent.length();
        if (this.myOptionalChecksum != null) {
            ++len;
        }
        double ratio = (double)this.myRatio.x / (double)this.myRatio.y;
        return (double)len * (2.0 * ratio + 3.0) + ratio + 6.0 + (double)this.getQuietZoneLeft() + (double)this.getQuietZoneRight();
    }

    @Override
    public void setContent(String content, boolean autoComplete, boolean appendOptionalChecksum) throws BarcodeException {
        ImplITF.validateNotEmpty((CharSequence)content);
        ImplITF.validateDigits((CharSequence)content);
        if (((String)content).length() % 2 != 0 ^ appendOptionalChecksum) {
            if (autoComplete) {
                content = "0" + (String)content;
            } else {
                ImplITF.throwContentLengthNotEven(((String)content).length());
            }
        }
        this.myContent = content;
        this.myOptionalChecksum = appendOptionalChecksum ? "" + ImplITF.calculateModulo10(this.myContent) : null;
        this.updateHumanReadableText();
        this.invalidateDrawing();
    }

    private void updateHumanReadableText() {
        this.myText = this.myContent;
        if (this.myOptionalChecksum != null && this.myIsOptionalChecksumVisible) {
            this.myText = this.myText + this.myOptionalChecksum;
        }
    }

    @Override
    public boolean supportsRatio() {
        return true;
    }

    @Override
    public boolean supportsOptionalChecksum() {
        return true;
    }

    @Override
    public void setOptionalChecksumVisible(boolean visible) {
        this.myIsOptionalChecksumVisible = visible;
        this.updateHumanReadableText();
    }

    @Override
    public boolean isOptionalChecksumVisible() {
        return this.myIsOptionalChecksumVisible;
    }
}

