/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.BarcodeException;
import de.vwsoft.barcodelib4j.oned.UPCEANFamily;

public class ImplEAN8
extends UPCEANFamily {
    private static final String BAR_LENGTH_PATTERN = "1".repeat(3) + "0".repeat(28) + "1".repeat(5) + "0".repeat(28) + "1".repeat(3) + "2".repeat(54);

    ImplEAN8() {
        try {
            this.setContent("12345670", false, false);
        }
        catch (BarcodeException barcodeException) {
            // empty catch block
        }
    }

    @Override
    String getBarLengthPattern() {
        return BAR_LENGTH_PATTERN;
    }

    @Override
    int getQuietZoneLeft() {
        return 7;
    }

    @Override
    int getQuietZoneRight() {
        return 7;
    }

    @Override
    public void setContent(String content, boolean autoComplete, boolean appendOptionalChecksum) throws BarcodeException {
        ImplEAN8.validateNotEmpty((CharSequence)content);
        ImplEAN8.validateDigits((CharSequence)content);
        if (autoComplete && ((String)content).length() == 7) {
            content = (String)content + ImplEAN8.calculateModulo10((CharSequence)content);
        } else {
            ImplEAN8.validateFixedLength((CharSequence)content, 8);
            ImplEAN8.validateModulo10((CharSequence)content);
        }
        this.myContent = content;
        this.invalidateDrawing();
    }

    @Override
    void encodeLeftPart(StringBuilder sb) {
        for (int i = 0; i < 4; ++i) {
            sb.append(ImplEAN8.encodeA(this.myContent.charAt(i) - 48));
        }
    }

    @Override
    void encodeRightPart(StringBuilder sb) {
        for (int i = 4; i < 8; ++i) {
            sb.append(ImplEAN8.encodeC(this.myContent.charAt(i) - 48));
        }
    }

    @Override
    void prepareDrawing() {
        this.myNumberPart2 = this.myContent.substring(0, 4);
        this.myNumberPart3 = this.myContent.substring(4, 8);
        super.prepareDrawing();
    }
}

