/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.BarcodeException;
import de.vwsoft.barcodelib4j.oned.UPCEANFamily;

public class ImplEAN13
extends UPCEANFamily {
    private static final String BAR_LENGTH_PATTERN = "1".repeat(3) + "0".repeat(42) + "1".repeat(5) + "0".repeat(42) + "1".repeat(3) + "2".repeat(54);
    private static final int[] CHARSET_PATTERN = new int[]{0, 11, 13, 14, 19, 25, 28, 21, 22, 26};

    ImplEAN13() {
        this("1234567890128");
    }

    ImplEAN13(String content) {
        try {
            this.setContent(content, false, false);
        }
        catch (BarcodeException barcodeException) {
            // empty catch block
        }
    }

    @Override
    String getBarLengthPattern() {
        return BAR_LENGTH_PATTERN;
    }

    @Override
    int getQuietZoneLeft() {
        return 11;
    }

    @Override
    int getQuietZoneRight() {
        return 7;
    }

    @Override
    public void setContent(String content, boolean autoComplete, boolean appendOptionalChecksum) throws BarcodeException {
        ImplEAN13.validateNotEmpty((CharSequence)content);
        ImplEAN13.validateDigits((CharSequence)content);
        if (autoComplete && ((String)content).length() == 12) {
            content = (String)content + ImplEAN13.calculateModulo10((CharSequence)content);
        } else {
            ImplEAN13.validateFixedLength((CharSequence)content, 13);
            ImplEAN13.validateModulo10((CharSequence)content);
        }
        this.myContent = content;
        this.invalidateDrawing();
    }

    @Override
    void encodeLeftPart(StringBuilder sb) {
        int pattern = CHARSET_PATTERN[this.myContent.charAt(0) - 48];
        for (int i = 1; i < 7; ++i) {
            sb.append((pattern & 1 << 6 - i) == 0 ? ImplEAN13.encodeA(this.myContent.charAt(i) - 48) : ImplEAN13.encodeB(this.myContent.charAt(i) - 48));
        }
    }

    @Override
    void encodeRightPart(StringBuilder sb) {
        for (int i = 7; i < 13; ++i) {
            sb.append(ImplEAN13.encodeC(this.myContent.charAt(i) - 48));
        }
    }

    @Override
    void prepareDrawing() {
        this.myNumberPart1 = this.myContent.substring(0, 1);
        this.myNumberPart2 = this.myContent.substring(1, 7);
        this.myNumberPart3 = this.myContent.substring(7, 13);
        super.prepareDrawing();
    }
}

