/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.Barcode;
import de.vwsoft.barcodelib4j.oned.BarcodeException;

public class ImplCode93
extends Barcode {
    private static final String CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*";
    private static final int[] BARS = new int[]{276, 328, 324, 322, 296, 292, 290, 336, 274, 266, 424, 420, 418, 404, 402, 394, 360, 356, 354, 308, 282, 344, 332, 326, 300, 278, 436, 434, 428, 422, 406, 410, 364, 358, 310, 314, 302, 468, 466, 458, 366, 374, 430, 294, 474, 470, 306, 350};

    ImplCode93() {
        this("CODE 93");
    }

    ImplCode93(String content) {
        try {
            this.setContent(content, false, false);
        }
        catch (BarcodeException barcodeException) {
            // empty catch block
        }
    }

    @Override
    CharSequence encode() {
        StringBuilder sb = new StringBuilder(this.myContent.length() + 1 + 1 + 2);
        sb.append('*').append(this.myContent).append(ImplCode93.calculateChecksum(this.myContent)).append('*');
        String value = sb.toString();
        int len = value.length();
        int leftQuietZone = this.getQuietZoneLeft();
        int rightQuietZone = this.getQuietZoneRight();
        sb = new StringBuilder(9 * len + 1 + leftQuietZone + rightQuietZone);
        sb.append("0".repeat(leftQuietZone));
        for (int i = 0; i < len; ++i) {
            sb.append(Integer.toBinaryString(BARS[CHARS.indexOf(value.charAt(i))]));
        }
        sb.append('1');
        sb.append("0".repeat(rightQuietZone));
        return sb;
    }

    @Override
    public void setContent(String content, boolean autoComplete, boolean appendOptionalChecksum) throws BarcodeException {
        ImplCode93.validateNotEmpty(content);
        if (autoComplete) {
            content = content.toUpperCase();
        }
        String validChars = CHARS.substring(0, 43);
        int len = content.length();
        for (int i = 0; i != len; ++i) {
            if (validChars.indexOf(content.charAt(i)) >= 0) continue;
            ImplCode93.throwInvalidCharacter(i);
        }
        this.myContent = content;
        this.invalidateDrawing();
    }

    private static String calculateChecksum(String content) {
        int sum = 0;
        int count = 0;
        for (int i = content.length() - 1; i >= 0; --i) {
            sum += ++count * CHARS.indexOf(content.charAt(i));
            if (count != 20) continue;
            count = 0;
        }
        char checkCharacterC = CHARS.charAt(sum % 47);
        sum = CHARS.indexOf(checkCharacterC);
        count = 1;
        for (int i = content.length() - 1; i >= 0; --i) {
            sum += ++count * CHARS.indexOf(content.charAt(i));
            if (count != 15) continue;
            count = 0;
        }
        char checkCharacterK = CHARS.charAt(sum % 47);
        return "" + checkCharacterC + checkCharacterK;
    }
}

