/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.BarcodeException;
import de.vwsoft.barcodelib4j.oned.ImplCode39;

public class ImplCode39E
extends ImplCode39 {
    private static final String[] CHARS_EXT = new String[]{"%U", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J", "$K", "$L", "$M", "$N", "$O", "$P", "$Q", "$R", "$S", "$T", "$U", "$V", "$W", "$X", "$Y", "$Z", "%A", "%B", "%C", "%D", "%E", " ", "/A", "/B", "/C", "/D", "/E", "/F", "/G", "/H", "/I", "/J", "/K", "/L", "-", ".", "/O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "/Z", "%F", "%G", "%H", "%I", "%J", "%V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "%K", "%L", "%M", "%N", "%O", "%W", "+A", "+B", "+C", "+D", "+E", "+F", "+G", "+H", "+I", "+J", "+K", "+L", "+M", "+N", "+O", "+P", "+Q", "+R", "+S", "+T", "+U", "+V", "+W", "+X", "+Y", "+Z", "%P", "%Q", "%R", "%S", "%T"};
    private transient String myContentASCII;

    ImplCode39E() {
        super("Code 39 Ext");
    }

    @Override
    public boolean supportsAutoCompletion() {
        return false;
    }

    @Override
    public void setContent(String content, boolean autoComplete, boolean appendOptionalChecksum) throws BarcodeException {
        ImplCode39E.validateNotEmpty(content);
        ImplCode39E.validateASCII(content);
        int len = content.length();
        StringBuilder sb = new StringBuilder(len << 1);
        for (int i = 0; i < len; ++i) {
            sb.append(CHARS_EXT[content.charAt(i)]);
        }
        this.myContent = sb.toString();
        this.myContentASCII = content;
        this.myOptionalChecksum = appendOptionalChecksum ? ImplCode39E.calculateOptionalChecksum(this.myContent) : null;
        this.updateHumanReadableText();
        this.invalidateDrawing();
    }

    @Override
    void updateHumanReadableText() {
        this.myText = this.myContentASCII;
        if (this.myOptionalChecksum != null && this.myIsOptionalChecksumVisible) {
            this.myText = this.myText + this.myOptionalChecksum;
        }
    }
}

