/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.Barcode;
import de.vwsoft.barcodelib4j.oned.BarcodeException;

public class ImplCode39
extends Barcode {
    private static final String CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*";
    private static final int[] BARS = new int[]{52, 289, 97, 352, 49, 304, 112, 37, 292, 100, 265, 73, 328, 25, 280, 88, 13, 268, 76, 28, 259, 67, 322, 19, 274, 82, 7, 262, 70, 22, 385, 193, 448, 145, 400, 208, 133, 388, 196, 168, 162, 138, 42, 148};
    String myOptionalChecksum;
    boolean myIsOptionalChecksumVisible;

    ImplCode39() {
        this("CODE 39");
    }

    ImplCode39(String content) {
        try {
            this.setContent(content, false, false);
        }
        catch (BarcodeException barcodeException) {
            // empty catch block
        }
    }

    @Override
    public boolean supportsRatio() {
        return true;
    }

    @Override
    public boolean supportsOptionalChecksum() {
        return true;
    }

    @Override
    public void setOptionalChecksumVisible(boolean visible) {
        this.myIsOptionalChecksumVisible = visible;
        this.updateHumanReadableText();
    }

    @Override
    public boolean isOptionalChecksumVisible() {
        return this.myIsOptionalChecksumVisible;
    }

    @Override
    CharSequence encode() {
        Object content = this.myContent;
        if (this.myOptionalChecksum != null) {
            content = (String)content + this.myOptionalChecksum;
        }
        content = "*" + (String)content + "*";
        String[] narr = new String[]{"1".repeat(this.myRatio.y), "0".repeat(this.myRatio.y)};
        String[] wide = new String[]{"1".repeat(this.myRatio.x), "0".repeat(this.myRatio.x)};
        int leftQuietZone = this.getQuietZoneLeft() * this.myRatio.y;
        int rightQuietZone = this.getQuietZoneRight() * this.myRatio.y;
        StringBuilder sb = new StringBuilder((3 * this.myRatio.x + 7 * this.myRatio.y) * ((String)content).length() + leftQuietZone + rightQuietZone);
        sb.append("0".repeat(leftQuietZone));
        int k = ((String)content).length() - 1;
        for (int i = 0; i <= k; ++i) {
            int barMask = BARS[CHARS.indexOf(((String)content).charAt(i))];
            for (int j = 0; j < 9; ++j) {
                sb.append((barMask & 1 << 8 - j) == 0 ? narr[j % 2] : wide[j % 2]);
            }
            if (i >= k) continue;
            sb.append(narr[1]);
        }
        sb.append("0".repeat(rightQuietZone));
        return sb;
    }

    @Override
    double calculateModuleFactor() {
        int len = this.myContent.length() + (this.myOptionalChecksum != null ? 3 : 2);
        return (double)(7 * len) + (double)(3 * len) * (double)this.myRatio.x / (double)this.myRatio.y - 1.0 + (double)this.getQuietZoneLeft() + (double)this.getQuietZoneRight();
    }

    @Override
    public void setContent(String content, boolean autoComplete, boolean appendOptionalChecksum) throws BarcodeException {
        ImplCode39.validateNotEmpty(content);
        if (autoComplete) {
            content = content.toUpperCase();
        }
        int len = content.length();
        for (int i = 0; i != len; ++i) {
            char c = content.charAt(i);
            if (c != '*' && CHARS.indexOf(c) >= 0) continue;
            ImplCode39.throwInvalidCharacter(i);
        }
        this.myContent = content;
        this.myOptionalChecksum = appendOptionalChecksum ? ImplCode39.calculateOptionalChecksum(this.myContent) : null;
        this.updateHumanReadableText();
        this.invalidateDrawing();
    }

    static String calculateOptionalChecksum(String content) {
        int sum = 0;
        for (int i = content.length() - 1; i >= 0; --i) {
            sum += CHARS.indexOf(content.charAt(i));
        }
        return "" + CHARS.charAt(sum % 43);
    }

    void updateHumanReadableText() {
        this.myText = this.myContent;
        if (this.myOptionalChecksum != null && this.myIsOptionalChecksumVisible) {
            this.myText = this.myText + this.myOptionalChecksum;
        }
    }
}

