/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.Barcode;
import de.vwsoft.barcodelib4j.oned.BarcodeException;

public class ImplCode128
extends Barcode {
    public static final char FNC1 = '\ufff1';
    public static final char FNC2 = '\ufff2';
    public static final char FNC3 = '\ufff3';
    public static final char FNC4 = '\ufff4';
    static final int CODESET_ALL = 0;
    static final int CODESET_A = 101;
    static final int CODESET_B = 100;
    static final int CODESET_C = 99;
    private static final int[] BARS = new int[]{1740, 1644, 1638, 1176, 1164, 1100, 1224, 1220, 1124, 1608, 1604, 1572, 1436, 1244, 1230, 1484, 1260, 1254, 1650, 1628, 1614, 1764, 1652, 1902, 1868, 1836, 1830, 1892, 1844, 1842, 1752, 1734, 1590, 1304, 1112, 1094, 1416, 1128, 1122, 1672, 1576, 1570, 1464, 1422, 1134, 1496, 1478, 1142, 1910, 1678, 1582, 1768, 1762, 1774, 1880, 1862, 1814, 1896, 1890, 1818, 1914, 1602, 1930, 1328, 1292, 1200, 1158, 1068, 1062, 1424, 1412, 1232, 1218, 1076, 1074, 1554, 1616, 1978, 1556, 1146, 1340, 1212, 1182, 1508, 1268, 1266, 1956, 1940, 1938, 1758, 1782, 1974, 1400, 1310, 1118, 1512, 1506, 1960, 1954, 1502, 1518, 1886, 1966, 1668, 1680, 1692};
    private static final int CODE_START_A = 103;
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_A = 101;
    private static final int CODE_FNC_4_B = 100;
    private static final int SETC_ONE_DIGIT = 1;
    private static final int SETC_TWO_DIGITS = 2;
    private static final int SETC_FNC_1 = 3;
    private static final int SETC_UNCODABLE = 4;
    private final int myCodeSet;

    ImplCode128() {
        this("Code 128", 0);
    }

    ImplCode128(String content, int codeSet) {
        this.myCodeSet = codeSet;
        try {
            this.setContent(content, false, false);
        }
        catch (BarcodeException barcodeException) {
            // empty catch block
        }
    }

    @Override
    public boolean supportsAutoCompletion() {
        return this.myCodeSet == 101 || this.myCodeSet == 99;
    }

    @Override
    CharSequence encode() {
        int len = this.myContent.length();
        int leftQuietZone = this.getQuietZoneLeft();
        int rightQuietZone = this.getQuietZoneRight();
        StringBuilder sb = new StringBuilder(len * 15 + leftQuietZone + rightQuietZone);
        sb.append("0".repeat(leftQuietZone));
        int checkSum = 0;
        int checkSumWeight = 1;
        int codeSet = 0;
        int idx = 0;
        while (idx < len) {
            int barsIdx;
            int newCodeSet;
            int n = newCodeSet = this.myCodeSet == 0 ? ImplCode128.chooseCodeSet(this.myContent, idx, codeSet) : this.myCodeSet;
            if (newCodeSet == codeSet) {
                char c = this.myContent.charAt(idx);
                if (c == '\ufff1') {
                    barsIdx = 102;
                } else if (c == '\ufff2') {
                    barsIdx = 97;
                } else if (c == '\ufff3') {
                    barsIdx = 96;
                } else if (c == '\ufff4') {
                    barsIdx = codeSet == 101 ? 101 : 100;
                } else if (codeSet == 101) {
                    barsIdx = c - 32;
                    if (barsIdx < 0) {
                        barsIdx += 96;
                    }
                } else if (codeSet == 100) {
                    barsIdx = c - 32;
                } else {
                    barsIdx = Integer.parseInt(this.myContent.substring(idx, idx + 2));
                    ++idx;
                }
                ++idx;
            } else {
                barsIdx = codeSet == 0 ? (newCodeSet == 101 ? 103 : (newCodeSet == 100 ? 104 : 105)) : newCodeSet;
                codeSet = newCodeSet;
            }
            sb.append(Integer.toBinaryString(BARS[barsIdx]));
            checkSum += barsIdx * checkSumWeight;
            if (idx == 0) continue;
            ++checkSumWeight;
        }
        sb.append(Integer.toBinaryString(BARS[checkSum % 103]));
        sb.append("1100011101011");
        sb.append("0".repeat(rightQuietZone));
        return sb;
    }

    private static int chooseCodeSet(String content, int idx, int oldCodeSet) {
        int forward = ImplCode128.chooseSetCType(content, idx);
        if (forward == 1) {
            return 100;
        }
        if (forward == 4) {
            char c;
            if (idx < content.length() && ((c = content.charAt(idx)) < ' ' || oldCodeSet == 101 && c < '`')) {
                return 101;
            }
            return 100;
        }
        if (oldCodeSet == 99) {
            return 99;
        }
        if (oldCodeSet == 100) {
            if (forward == 3) {
                return 100;
            }
            forward = ImplCode128.chooseSetCType(content, idx + 2);
            if (forward == 4 || forward == 1) {
                return 100;
            }
            if (forward == 3) {
                return ImplCode128.chooseSetCType(content, idx + 3) == 2 ? 99 : 100;
            }
            int index = idx + 4;
            while ((forward = ImplCode128.chooseSetCType(content, index)) == 2) {
                index += 2;
            }
            return forward == 1 ? 100 : 99;
        }
        if (forward == 3) {
            forward = ImplCode128.chooseSetCType(content, idx + 1);
        }
        return forward == 2 ? 99 : 100;
    }

    private static int chooseSetCType(String content, int idx) {
        int last = content.length();
        if (idx >= last) {
            return 4;
        }
        char c = content.charAt(idx);
        if (c == '\ufff1') {
            return 3;
        }
        if (!ImplCode128.isDigit(c)) {
            return 4;
        }
        if (idx + 1 >= last) {
            return 1;
        }
        return ImplCode128.isDigit(content.charAt(idx + 1)) ? 2 : 1;
    }

    @Override
    public void setContent(String content, boolean autoComplete, boolean appendOptionalChecksum) throws BarcodeException {
        ImplCode128.validateNotEmpty((CharSequence)content);
        int len = ((String)content).length();
        if (this.myCodeSet == 99) {
            ImplCode128.validateDigits((CharSequence)content);
            if (len % 2 != 0) {
                if (autoComplete) {
                    content = "0" + (String)content;
                } else {
                    ImplCode128.throwContentLengthNotEven(len);
                }
            }
        } else {
            if (this.myCodeSet == 101 && autoComplete) {
                content = ((String)content).toUpperCase();
            }
            StringBuilder sb = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                char c = ((String)content).charAt(i);
                if (c != '\ufff1' && c != '\ufff2' && c != '\ufff3' && c != '\ufff4' && (this.myCodeSet == 101 && c > '_' || this.myCodeSet == 100 && c < ' ' || c > '\u007f')) {
                    ImplCode128.throwInvalidCharacter(i);
                }
                sb.append(c < ' ' || c > '\u007f' ? (char)' ' : c);
            }
            this.myText = sb.toString();
        }
        this.myContent = content;
        this.invalidateDrawing();
    }
}

