/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.Barcode;
import de.vwsoft.barcodelib4j.oned.BarcodeException;

public class ImplCode11
extends Barcode {
    private static final String CHARS = "0123456789-";
    private static final int[] BARS = new int[]{1, 17, 9, 24, 5, 20, 12, 3, 18, 16, 4};
    private String myOptionalChecksum;
    private boolean myIsOptionalChecksumVisible;

    ImplCode11() {
        try {
            this.setContent("1234-5678", false, false);
        }
        catch (BarcodeException barcodeException) {
            // empty catch block
        }
    }

    @Override
    public boolean supportsRatio() {
        return true;
    }

    @Override
    public boolean supportsAutoCompletion() {
        return false;
    }

    @Override
    public boolean supportsOptionalChecksum() {
        return true;
    }

    @Override
    public void setOptionalChecksumVisible(boolean visible) {
        this.myIsOptionalChecksumVisible = visible;
        this.updateHumanReadableText();
    }

    @Override
    public boolean isOptionalChecksumVisible() {
        return this.myIsOptionalChecksumVisible;
    }

    @Override
    CharSequence encode() {
        String content = this.myOptionalChecksum != null ? this.myContent + this.myOptionalChecksum : this.myContent;
        int len = content.length();
        String[] bars = new String[]{"1".repeat(this.myRatio.y), "1".repeat(this.myRatio.x)};
        String[] spaces = new String[]{"0".repeat(this.myRatio.y), "0".repeat(this.myRatio.x)};
        String startAndStop = bars[0] + spaces[0] + bars[1] + spaces[1] + bars[0];
        int leftQuietZone = this.getQuietZoneLeft() * this.myRatio.y;
        int rightQuietZone = this.getQuietZoneRight() * this.myRatio.y;
        StringBuilder sb = new StringBuilder(this.myRatio.x * 4 + this.myRatio.y * 6 + len * ((this.myRatio.x << 1) + (this.myRatio.y << 2)) + this.myRatio.y + leftQuietZone + rightQuietZone);
        sb.append("0".repeat(leftQuietZone));
        sb.append(startAndStop);
        sb.append(spaces[0]);
        for (int i = 0; i < len; ++i) {
            int n = BARS[CHARS.indexOf(content.charAt(i))];
            sb.append(bars[n >> 4 & 1]);
            sb.append(spaces[n >> 3 & 1]);
            sb.append(bars[n >> 2 & 1]);
            sb.append(spaces[n >> 1 & 1]);
            sb.append(bars[n & 1]);
            sb.append(spaces[0]);
        }
        sb.append(startAndStop);
        sb.append("0".repeat(rightQuietZone));
        return sb;
    }

    @Override
    double calculateModuleFactor() {
        Object content = this.myContent;
        if (this.myOptionalChecksum != null) {
            content = (String)content + this.myOptionalChecksum;
        }
        int narrowBarCount = 3 + (((String)content).length() + 1) + 3;
        int wideBarCount = 4;
        for (int i = ((String)content).length() - 1; i >= 0; --i) {
            int n = BARS[CHARS.indexOf(((String)content).charAt(i))];
            for (int j = 4; j >= 0; --j) {
                if ((n >> j & 1) == 0) {
                    ++narrowBarCount;
                    continue;
                }
                ++wideBarCount;
            }
        }
        return (double)narrowBarCount + (double)wideBarCount * (double)this.myRatio.x / (double)this.myRatio.y + (double)this.getQuietZoneLeft() + (double)this.getQuietZoneRight();
    }

    @Override
    public void setContent(String content, boolean autoComplete, boolean appendOptionalChecksum) throws BarcodeException {
        ImplCode11.validateNotEmpty(content);
        int len = content.length();
        for (int i = 0; i != len; ++i) {
            if (CHARS.indexOf(content.charAt(i)) >= 0) continue;
            ImplCode11.throwInvalidCharacter(i);
        }
        this.myContent = content;
        this.myOptionalChecksum = appendOptionalChecksum ? ImplCode11.calculateOptionalChecksum(this.myContent) : null;
        this.updateHumanReadableText();
        this.invalidateDrawing();
    }

    private static String calculateOptionalChecksum(String content) {
        int sum = 0;
        int count = 0;
        for (int i = content.length() - 1; i >= 0; --i) {
            sum += ++count * CHARS.indexOf(content.charAt(i));
            if (count != 10) continue;
            count = 0;
        }
        char checkCharacterC = CHARS.charAt(sum % 11);
        sum = CHARS.indexOf(checkCharacterC);
        count = 1;
        for (int i = content.length() - 1; i >= 0; --i) {
            sum += ++count * CHARS.indexOf(content.charAt(i));
            if (count != 9) continue;
            count = 0;
        }
        char checkCharacterK = CHARS.charAt(sum % 11);
        return "" + checkCharacterC + checkCharacterK;
    }

    private void updateHumanReadableText() {
        this.myText = this.myContent;
        if (this.myOptionalChecksum != null && this.myIsOptionalChecksumVisible) {
            this.myText = this.myText + this.myOptionalChecksum;
        }
    }
}

