/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.Barcode;
import de.vwsoft.barcodelib4j.oned.BarcodeException;

public class ImplCodabar
extends Barcode {
    private static final String CHARS = "0123456789-$:/.+ABCD";
    private static final int[] BARS = new int[]{3, 6, 9, 96, 18, 66, 33, 36, 48, 72, 12, 24, 69, 81, 84, 21, 26, 41, 11, 14};

    ImplCodabar() {
        try {
            this.setContent("A12345678A", false, false);
        }
        catch (BarcodeException barcodeException) {
            // empty catch block
        }
    }

    @Override
    public boolean supportsRatio() {
        return true;
    }

    @Override
    CharSequence encode() {
        String[] bars = new String[]{"1".repeat(this.myRatio.y), "1".repeat(this.myRatio.x)};
        String[] spaces = new String[]{"0".repeat(this.myRatio.y), "0".repeat(this.myRatio.x)};
        int leftQuietZone = this.getQuietZoneLeft() * this.myRatio.y;
        int rightQuietZone = this.getQuietZoneRight() * this.myRatio.y;
        int len = this.myContent.length();
        StringBuilder sb = new StringBuilder(len * (3 * this.myRatio.x + 5 * this.myRatio.y) + leftQuietZone + rightQuietZone);
        sb.append("0".repeat(leftQuietZone));
        for (int i = 0; i < len; ++i) {
            int n = BARS[CHARS.indexOf(this.myContent.charAt(i))];
            int j = 6;
            while (j > 0) {
                sb.append(bars[n >> j-- & 1]);
                sb.append(spaces[n >> j-- & 1]);
            }
            sb.append(bars[n & 1]);
            if (i >= len - 1) continue;
            sb.append(spaces[0]);
        }
        sb.append("0".repeat(rightQuietZone));
        return sb;
    }

    @Override
    double calculateModuleFactor() {
        int narrowBarCount = this.myContent.length() - 1;
        int wideBarCount = 0;
        for (int i = narrowBarCount; i >= 0; --i) {
            int n = BARS[CHARS.indexOf(this.myContent.charAt(i))];
            for (int j = 6; j >= 0; --j) {
                if ((n >> j & 1) == 0) {
                    ++narrowBarCount;
                    continue;
                }
                ++wideBarCount;
            }
        }
        return (double)narrowBarCount + (double)wideBarCount * (double)this.myRatio.x / (double)this.myRatio.y + (double)this.getQuietZoneLeft() + (double)this.getQuietZoneRight();
    }

    @Override
    public void setContent(String content, boolean autoComplete, boolean appendOptionalChecksum) throws BarcodeException {
        ImplCodabar.validateNotEmpty((CharSequence)content);
        char startChar = Character.toUpperCase(((String)content).charAt(0));
        if (this.isStartOrStopChar(startChar)) {
            content = startChar + ((String)content).substring(1);
        } else if (autoComplete) {
            content = "A" + (String)content;
        } else {
            throw new BarcodeException(110, "Value must start with 'A', 'B', 'C' or 'D'", "Wert muss mit 'A', 'B', 'C' oder 'D' beginnen", new Object[0]);
        }
        char stopChar = Character.toUpperCase(((String)content).charAt(((String)content).length() - 1));
        if (this.isStartOrStopChar(stopChar)) {
            content = ((String)content).substring(0, ((String)content).length() - 1) + stopChar;
        } else if (autoComplete) {
            content = (String)content + "A";
        } else {
            throw new BarcodeException(110, "Value must end with 'A', 'B', 'C' or 'D'", "Wert muss mit 'A', 'B', 'C' oder 'D' enden", new Object[0]);
        }
        ImplCodabar.validateNotEmpty(((String)content).substring(Math.min(2, ((String)content).length())));
        String validChars = CHARS.substring(0, 16);
        int j = ((String)content).length() - 1;
        for (int i = 1; i != j; ++i) {
            if (validChars.indexOf(((String)content).charAt(i)) >= 0) continue;
            ImplCodabar.throwInvalidCharacter(i);
        }
        this.myContent = content;
        this.invalidateDrawing();
    }

    private boolean isStartOrStopChar(char c) {
        return c == 'A' || c == 'B' || c == 'C' || c == 'D';
    }
}

