/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.Barcode;
import de.vwsoft.barcodelib4j.oned.BarcodeException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.Map;
import java.util.regex.Pattern;

public class GS1Validator {
    public static char CHECKSUM_PLACEHOLDER = (char)35;
    private static final int L_FNC1 = -1;
    private static final int L_BRACKET = -2;
    private static final AI[] APP_IDS = new AI[]{new AI("00", 18, "_d{18}"), new AI("01", 14, "_d{14}"), new AI("02", 14, "_d{14}"), new AI("10", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("11", 6), new AI("12", 6), new AI("13", 6), new AI("15", 6), new AI("16", 6), new AI("17", 6), new AI("20", 2, "_d{2}"), new AI("21", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("22", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("235", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,28}"), new AI("240", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,30}"), new AI("241", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,30}"), new AI("242", -2, "_d{0,6}"), new AI("243", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("250", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,30}"), new AI("251", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,30}"), new AI("253", -1, "_d{13})([_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,17}"), new AI("254", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("255", -2, "_d{13})(_d{0,12}"), new AI("30", -2, "_d{0,8}"), new AI("310", 5, 6, "_d{6}"), new AI("311", 5, 6, "_d{6}"), new AI("312", 5, 6, "_d{6}"), new AI("313", 5, 6, "_d{6}"), new AI("314", 5, 6, "_d{6}"), new AI("315", 5, 6, "_d{6}"), new AI("316", 5, 6, "_d{6}"), new AI("320", 5, 6, "_d{6}"), new AI("321", 5, 6, "_d{6}"), new AI("322", 5, 6, "_d{6}"), new AI("323", 5, 6, "_d{6}"), new AI("324", 5, 6, "_d{6}"), new AI("325", 5, 6, "_d{6}"), new AI("326", 5, 6, "_d{6}"), new AI("327", 5, 6, "_d{6}"), new AI("328", 5, 6, "_d{6}"), new AI("329", 5, 6, "_d{6}"), new AI("330", 5, 6, "_d{6}"), new AI("331", 5, 6, "_d{6}"), new AI("332", 5, 6, "_d{6}"), new AI("333", 5, 6, "_d{6}"), new AI("334", 5, 6, "_d{6}"), new AI("335", 5, 6, "_d{6}"), new AI("336", 5, 6, "_d{6}"), new AI("337", 5, 6, "_d{6}"), new AI("340", 5, 6, "_d{6}"), new AI("341", 5, 6, "_d{6}"), new AI("342", 5, 6, "_d{6}"), new AI("343", 5, 6, "_d{6}"), new AI("344", 5, 6, "_d{6}"), new AI("345", 5, 6, "_d{6}"), new AI("346", 5, 6, "_d{6}"), new AI("347", 5, 6, "_d{6}"), new AI("348", 5, 6, "_d{6}"), new AI("349", 5, 6, "_d{6}"), new AI("350", 5, 6, "_d{6}"), new AI("351", 5, 6, "_d{6}"), new AI("352", 5, 6, "_d{6}"), new AI("353", 5, 6, "_d{6}"), new AI("354", 5, 6, "_d{6}"), new AI("355", 5, 6, "_d{6}"), new AI("356", 5, 6, "_d{6}"), new AI("357", 5, 6, "_d{6}"), new AI("360", 5, 6, "_d{6}"), new AI("361", 5, 6, "_d{6}"), new AI("362", 5, 6, "_d{6}"), new AI("363", 5, 6, "_d{6}"), new AI("364", 5, 6, "_d{6}"), new AI("365", 5, 6, "_d{6}"), new AI("366", 5, 6, "_d{6}"), new AI("367", 5, 6, "_d{6}"), new AI("368", 5, 6, "_d{6}"), new AI("369", 5, 6, "_d{6}"), new AI("37", -2, "_d{0,8}"), new AI("390", 9, -2, "_d{0,15}"), new AI("391", 9, -2, "_d{3})(_d{0,15}"), new AI("392", 9, -2, "_d{0,15}"), new AI("393", 9, -2, "_d{3})(_d{0,15}"), new AI("394", 3, 4, "_d{4}"), new AI("400", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,30}"), new AI("401", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,30}"), new AI("402", 17, "_d{17}"), new AI("403", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,30}"), new AI("410", 13, "_d{13}"), new AI("411", 13, "_d{13}"), new AI("412", 13, "_d{13}"), new AI("413", 13, "_d{13}"), new AI("414", 13, "_d{13}"), new AI("415", 13, "_d{13}"), new AI("416", 13, "_d{13}"), new AI("417", 13, "_d{13}"), new AI("420", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("421", -1, "_d{3})([_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,9}"), new AI("422", 3, "_d{3}"), new AI("423", -2, "_d{3})(_d{0,12}"), new AI("424", 3, "_d{3}"), new AI("425", -2, "_d{3})(_d{0,12}"), new AI("426", 3, "_d{3}"), new AI("427", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,3}"), new AI("7001", 13, "_d{13}"), new AI("7002", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,30}"), new AI("7003", 10), new AI("7004", -2, "_d{0,4}"), new AI("7005", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,12}"), new AI("7006", 6), new AI("7007", -2, "_d{6,12}"), new AI("7008", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,3}"), new AI("7009", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,10}"), new AI("7010", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,2}"), new AI("7020", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("7021", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("7022", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("7023", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,30}"), new AI("703", 9, -1, "_d{3})([_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,27}"), new AI("7040", 4, "_d[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{3}"), new AI("710", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("711", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("712", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("713", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("714", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("723", 9, -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{2,30}"), new AI("7240", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("8001", 14, "_d{14}"), new AI("8002", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("8003", -1, "_d{14})([_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,16}"), new AI("8004", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,30}"), new AI("8005", 6, "_d{6}"), new AI("8006", -2, "_d{14})(_d{2})(_d{2}"), new AI("8007", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,34}"), new AI("8008", -2), new AI("8009", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,50}"), new AI("8010", -2, "[_x23_x2D_x2F_x30-_x39_x41-_x5A]{0,30}"), new AI("8011", -2, "_d{0,12}"), new AI("8012", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,20}"), new AI("8013", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,30}"), new AI("8017", 18, "_d{18}"), new AI("8018", 18, "_d{18}"), new AI("8019", -2, "_d{0,10}"), new AI("8020", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,25}"), new AI("8026", -2, "_d{14})(_d{2})(_d{2}"), new AI("8110", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,70}"), new AI("8111", 4, "_d{4}"), new AI("8112", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,70}"), new AI("8200", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,70}"), new AI("90", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,30}"), new AI("91", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,90}"), new AI("92", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,90}"), new AI("93", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,90}"), new AI("94", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,90}"), new AI("95", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,90}"), new AI("96", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,90}"), new AI("97", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,90}"), new AI("98", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,90}"), new AI("99", -1, "[_x21-_x22_x25-_x2F_x30-_x39_x41-_x5A_x5F_x61-_x7A]{0,90}")};
    private final String myContent;
    private final String myText;

    public GS1Validator(String content, char fnc1Char) throws BarcodeException {
        int len = content.length();
        StringBuilder sbContent = new StringBuilder(len);
        StringBuilder sbText = new StringBuilder(len);
        int idx = 0;
        while (true) {
            int k;
            boolean embraced;
            if (idx != len && content.charAt(idx) == fnc1Char) {
                ++idx;
                continue;
            }
            if (idx == len) break;
            AI ai = null;
            boolean bl = embraced = content.charAt(idx) == '(';
            if (embraced) {
                ++idx;
            }
            for (AI nextAI : APP_IDS) {
                Object s = nextAI.appId;
                if (!((String)s).regionMatches(0, content, idx, ((String)s).length())) continue;
                idx += ((String)s).length();
                if (nextAI.maxY > 0) {
                    int n;
                    int n2 = n = idx < len ? content.charAt(idx) - 48 : -1;
                    if (n < 0 || n > nextAI.maxY) {
                        throw new BarcodeException(110, "'n' in AI %sn at position %s must be between 0 and %s", "'n' in AI %sn an Position %s muss zwischen 0 und %s liegen", s, idx, nextAI.maxY);
                    }
                    s = (String)s + n;
                    ++idx;
                }
                if (embraced) {
                    if (idx == len || content.charAt(idx) != ')') {
                        throw new BarcodeException(110, "Closing bracket is missing at position %s", "Schlie\u00dfende Klammer fehlt an Position %s", idx);
                    }
                    ++idx;
                }
                sbContent.append((String)s);
                sbText.append('(').append((String)s).append(')');
                ai = nextAI;
                break;
            }
            if (ai == null) {
                throw new BarcodeException(110, "No valid AI found at position %s", "Kein g\u00fcltiger AI an Position %s gefunden", idx);
            }
            if (ai.delimiter > 0) {
                k = Math.min(idx + ai.delimiter, len);
            } else {
                int n;
                k = content.indexOf(fnc1Char, idx);
                if (ai.delimiter == -2 && (n = content.indexOf(40, idx)) > 0) {
                    int n3 = k = k > 0 ? Math.min(k, n) : n;
                }
                if (k < 0) {
                    k = len;
                }
            }
            Object data = content.substring(idx, k);
            if (ai.delimiter > 0 && ai.delimiter != ((String)data).length()) {
                throw new BarcodeException(125, "Value of AI %s must consist of %s characters; Provided: %s", "Wert von AI %s muss aus %s Zeichen bestehen; Aktuell: %s", ai.appId, ai.delimiter, ((String)data).length());
            }
            if (ai == APP_IDS[0] || ai == APP_IDS[1] || ai == APP_IDS[2]) {
                if (((String)data).charAt(ai.delimiter - 1) == CHECKSUM_PLACEHOLDER) {
                    data = ((String)data).substring(0, ai.delimiter - 1);
                    GS1Validator.validateDigits((String)data, ai);
                    data = (String)data + Barcode.calculateModulo10((CharSequence)data);
                } else {
                    GS1Validator.validateDigits((String)data, ai);
                    Barcode.validateModulo10((CharSequence)data);
                }
            } else if (!ai.matches((String)data)) {
                if (ai.isYYMMDD()) {
                    throw new BarcodeException(110, "Value of AI %s is not a real date in YYMMDD format", "Wert von AI %s ist kein reales Datum im Format JJMMTT", ai.appId);
                }
                throw new BarcodeException(110, "Value of AI %s does not conform to its schema", "Wert von AI %s entspricht nicht dessen Schema", ai.appId);
            }
            sbContent.append((String)data);
            sbText.append((String)data);
            if (k == len) break;
            idx = k;
            if (ai.delimiter >= 0) continue;
            sbContent.append(fnc1Char);
        }
        for (int i = sbContent.length() - 1; i >= 0; --i) {
            if (sbContent.charAt(i) == fnc1Char) continue;
            sbContent.setLength(i + 1);
            break;
        }
        Barcode.validateNotEmpty(sbContent);
        this.myContent = sbContent.toString();
        this.myText = sbText.toString();
    }

    private static void validateDigits(String value, AI ai) throws BarcodeException {
        if (Barcode.findNonDigitPosition(value) >= 0) {
            throw new BarcodeException(115, "Value of AI %s may contain only digits and an optional checksum placeholder", "Wert von AI %s darf nur Ziffern und einen optionalen Pr\u00fcfziffer-Platzhalter enthalten", ai.appId);
        }
    }

    public String getContent() {
        return this.myContent;
    }

    public String getText() {
        return this.myText;
    }

    private static class AI {
        private static Map<Integer, DateTimeFormatter> dateTimeFormatters = Map.of(6, new DateTimeFormatterBuilder().parseStrict().appendPattern("uuMMdd").toFormatter().withResolverStyle(ResolverStyle.STRICT), 10, new DateTimeFormatterBuilder().parseStrict().appendPattern("uuMMddHHmm").toFormatter().withResolverStyle(ResolverStyle.STRICT), 8008, new DateTimeFormatterBuilder().parseStrict().appendPattern("uuMMddHH").optionalStart().appendPattern("mm").optionalStart().appendPattern("ss").optionalEnd().optionalEnd().toFormatter().withResolverStyle(ResolverStyle.STRICT));
        String appId;
        int maxY;
        int delimiter;
        Pattern pattern;

        AI(String appId, int maxY, int delimiter, String regex) {
            this.appId = appId;
            this.maxY = maxY;
            this.delimiter = delimiter;
            StringBuilder sb = new StringBuilder(regex.length() + 2).append('(').append(regex).append(')');
            for (int i = regex.length(); i != 0; --i) {
                if (sb.charAt(i) != '_') continue;
                sb.setCharAt(i, '\\');
            }
            this.pattern = Pattern.compile(sb.toString());
        }

        AI(String appId, int delimiter, String regex) {
            this(appId, 0, delimiter, regex);
        }

        AI(String appId, int delimiter) {
            this.appId = appId;
            this.delimiter = delimiter;
        }

        boolean isYYMMDD() {
            return this.pattern == null && this.delimiter == 6;
        }

        boolean matches(String data) {
            if (this.pattern != null) {
                return this.pattern.matcher(data).matches();
            }
            try {
                dateTimeFormatters.get(this.delimiter > 0 ? this.delimiter : Integer.parseInt(this.appId)).parse(data);
                return true;
            }
            catch (DateTimeParseException e) {
                return false;
            }
        }
    }
}

