/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.Barcode;
import de.vwsoft.barcodelib4j.oned.ImplCodabar;
import de.vwsoft.barcodelib4j.oned.ImplCode11;
import de.vwsoft.barcodelib4j.oned.ImplCode128;
import de.vwsoft.barcodelib4j.oned.ImplCode128A;
import de.vwsoft.barcodelib4j.oned.ImplCode128B;
import de.vwsoft.barcodelib4j.oned.ImplCode128C;
import de.vwsoft.barcodelib4j.oned.ImplCode39;
import de.vwsoft.barcodelib4j.oned.ImplCode39E;
import de.vwsoft.barcodelib4j.oned.ImplCode93;
import de.vwsoft.barcodelib4j.oned.ImplCode93E;
import de.vwsoft.barcodelib4j.oned.ImplEAN128;
import de.vwsoft.barcodelib4j.oned.ImplEAN13;
import de.vwsoft.barcodelib4j.oned.ImplEAN14;
import de.vwsoft.barcodelib4j.oned.ImplEAN8;
import de.vwsoft.barcodelib4j.oned.ImplISBN13;
import de.vwsoft.barcodelib4j.oned.ImplISMN;
import de.vwsoft.barcodelib4j.oned.ImplITF;
import de.vwsoft.barcodelib4j.oned.ImplPZN;
import de.vwsoft.barcodelib4j.oned.ImplPZN8;
import de.vwsoft.barcodelib4j.oned.ImplSSCC18;
import de.vwsoft.barcodelib4j.oned.ImplUPCA;
import de.vwsoft.barcodelib4j.oned.ImplUPCE;

public enum BarcodeType {
    CODABAR("Codabar", 7),
    CODE11("Code 11", 12),
    CODE128("Code 128", 6),
    CODE128A("Code 128 A", 20),
    CODE128B("Code 128 B", 8),
    CODE128C("Code 128 C", 9),
    CODE39("Code 39", 5),
    CODE39E("Code 39 Extended", 13),
    CODE93("Code 93", 10),
    CODE93E("Code 93 Extended", 11),
    EAN13("EAN-13 (GTIN-13)", 1),
    EAN14("EAN-14 (GTIN-14)", 18),
    EAN8("EAN-8 (GTIN-8)", 2),
    EAN128("GS1-128 (UCC/EAN-128)", 17),
    ITF("Interleaved 2 of 5", 4),
    ISBN13("ISBN-13", 15),
    ISMN("ISMN", 21),
    PZN("PZN", 14),
    PZN8("PZN8", 16),
    SSCC18("SSCC-18 (NVE/EAN-18)", 19),
    UPCA("UPC-A", 3),
    UPCE("UPC-E", 22);

    private final String myTypeName;
    private final int myID;
    private static final BarcodeType[] cachedValues;

    private BarcodeType(String name, int id) {
        this.myTypeName = name;
        this.myID = id;
    }

    Barcode newInstance() {
        Barcode bc = null;
        switch (this) {
            case CODABAR: {
                bc = new ImplCodabar();
                break;
            }
            case CODE11: {
                bc = new ImplCode11();
                break;
            }
            case CODE128: {
                bc = new ImplCode128();
                break;
            }
            case CODE128A: {
                bc = new ImplCode128A();
                break;
            }
            case CODE128B: {
                bc = new ImplCode128B();
                break;
            }
            case CODE128C: {
                bc = new ImplCode128C();
                break;
            }
            case CODE39: {
                bc = new ImplCode39();
                break;
            }
            case CODE39E: {
                bc = new ImplCode39E();
                break;
            }
            case CODE93: {
                bc = new ImplCode93();
                break;
            }
            case CODE93E: {
                bc = new ImplCode93E();
                break;
            }
            case EAN13: {
                bc = new ImplEAN13();
                break;
            }
            case EAN14: {
                bc = new ImplEAN14();
                break;
            }
            case EAN8: {
                bc = new ImplEAN8();
                break;
            }
            case EAN128: {
                bc = new ImplEAN128();
                break;
            }
            case ITF: {
                bc = new ImplITF();
                break;
            }
            case ISBN13: {
                bc = new ImplISBN13();
                break;
            }
            case ISMN: {
                bc = new ImplISMN();
                break;
            }
            case PZN: {
                bc = new ImplPZN();
                break;
            }
            case PZN8: {
                bc = new ImplPZN8();
                break;
            }
            case SSCC18: {
                bc = new ImplSSCC18();
                break;
            }
            case UPCA: {
                bc = new ImplUPCA();
                break;
            }
            case UPCE: {
                bc = new ImplUPCE();
            }
        }
        return bc;
    }

    public static BarcodeType valueOf(int id) {
        for (BarcodeType type : cachedValues) {
            if (type.getID() != id) continue;
            return type;
        }
        throw new IllegalArgumentException("Invalid barcode type ID: " + id);
    }

    public int getID() {
        return this.myID;
    }

    public String getTypeName() {
        return this.myTypeName;
    }

    public String getTypeNameShort() {
        int pos = this.myTypeName.indexOf(40);
        return pos > 0 ? this.myTypeName.substring(0, pos - 1) : this.myTypeName;
    }

    public String toString() {
        return this.myTypeName;
    }

    static {
        cachedValues = BarcodeType.values();
    }
}

