/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import java.util.Locale;

public class BarcodeException
extends Exception {
    public static final int CONTENT_EMPTY = 105;
    public static final int CONTENT_INVALID = 110;
    public static final int CONTENT_NOT_DIGITS = 115;
    public static final int CONTENT_NOT_ASCII = 120;
    public static final int CONTENT_LENGTH_INVALID = 125;
    public static final int CONTENT_LENGTH_NOT_EVEN = 130;
    public static final int CHECKSUM_INVALID = 205;
    public static final int ADDON_EMPTY = 305;
    public static final int ADDON_LENGTH_INVALID = 310;
    public static final int ADDON_NOT_DIGITS = 315;
    private final int myID;
    private final String myMessageDE;

    public BarcodeException(int id, String message, String messageDE, Object ... inserts) {
        super(BarcodeException.fillInserts(message, inserts));
        this.myMessageDE = BarcodeException.fillInserts(messageDE, inserts);
        this.myID = id;
    }

    private static String fillInserts(String message, Object[] inserts) {
        for (Object o : inserts) {
            message = message.replaceFirst("%s", o.toString());
        }
        return message;
    }

    public int getID() {
        return this.myID;
    }

    @Override
    public String getLocalizedMessage() {
        return "de".equals(Locale.getDefault().getLanguage()) ? this.myMessageDE : this.getMessage();
    }

    public boolean isContentRelated() {
        return this.myID >= 100 && this.myID < 200;
    }

    public boolean isChecksumRelated() {
        return this.myID >= 200 && this.myID < 300;
    }

    public boolean isAddOnRelated() {
        return this.myID >= 300 && this.myID < 400;
    }
}

