/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.oned;

import de.vwsoft.barcodelib4j.oned.BarcodeException;
import de.vwsoft.barcodelib4j.oned.BarcodeType;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Objects;

public abstract class Barcode
implements Cloneable {
    static final float FONT_SIZE_INCREMENT = 0.1f;
    static Point DEFAULT_WIDE_NARROW_RATIO = new Point(5, 2);
    String myContent;
    String myText;
    boolean myIsTextVisible = true;
    boolean myIsTextOnTop;
    double myTextOffset;
    Font myFont;
    boolean myIsFontSizeAdjusted;
    Point myRatio = DEFAULT_WIDE_NARROW_RATIO;
    transient int[] myBars;
    transient int myBarsCount;
    transient double myModuleFactor;

    Barcode() {
    }

    public static Barcode newInstance(BarcodeType type) {
        return type.newInstance();
    }

    public static Barcode newInstance(BarcodeType type, String content, boolean autoComplete, boolean appendOptionalChecksum) throws BarcodeException {
        Barcode bc = type.newInstance();
        bc.setContent(content, autoComplete, appendOptionalChecksum);
        return bc;
    }

    abstract CharSequence encode();

    public abstract void setContent(String var1, boolean var2, boolean var3) throws BarcodeException;

    public String getContent() {
        return this.myContent;
    }

    public boolean supportsCustomText() {
        return true;
    }

    public void setCustomText(String text) {
        Objects.requireNonNull(text, "Custom text cannot be null");
        if (text.isEmpty()) {
            throw new IllegalArgumentException("Custom text cannot be empty");
        }
        if (this.supportsCustomText()) {
            this.myText = text;
        }
    }

    public String getText() {
        return this.myText != null ? this.myText : this.myContent;
    }

    public boolean supportsAddOn() {
        return false;
    }

    public void setAddOn(String addOnNumber) throws BarcodeException {
    }

    public String getAddOn() {
        return null;
    }

    public void setTextVisible(boolean visible) {
        this.myIsTextVisible = visible;
    }

    public boolean isTextVisible() {
        return this.myIsTextVisible;
    }

    public boolean supportsTextOnTop() {
        return true;
    }

    public void setTextOnTop(boolean onTop) {
        if (this.supportsTextOnTop()) {
            this.myIsTextOnTop = onTop;
        }
    }

    public boolean isTextOnTop() {
        return this.myIsTextOnTop;
    }

    public void setTextOffset(double offset) {
        this.myTextOffset = offset;
    }

    public double getTextOffset() {
        return this.myTextOffset;
    }

    public void setFont(Font font) {
        this.myFont = font;
    }

    public Font getFont() {
        return this.myFont;
    }

    public void setFontSizeAdjusted(boolean b) {
        this.myIsFontSizeAdjusted = b;
    }

    public boolean isFontSizeAdjusted() {
        return this.myIsFontSizeAdjusted;
    }

    public boolean supportsAutoCompletion() {
        return true;
    }

    public boolean supportsOptionalChecksum() {
        return false;
    }

    public void setOptionalChecksumVisible(boolean visible) {
    }

    public boolean isOptionalChecksumVisible() {
        return false;
    }

    public boolean supportsRatio() {
        return false;
    }

    public void setRatio(float ratio) {
        if (this.supportsRatio()) {
            int narrLen = 10;
            int wideLen = Math.round(ratio * 10.0f);
            for (int i = 10; i > 1; --i) {
                if (narrLen % i != 0 || wideLen % i != 0) continue;
                narrLen /= i;
                wideLen /= i;
                break;
            }
            this.myRatio = new Point(wideLen, narrLen);
            this.invalidateDrawing();
        }
    }

    public float getRatio() {
        return (float)this.myRatio.x / (float)this.myRatio.y;
    }

    int getQuietZoneLeft() {
        return 10;
    }

    int getQuietZoneRight() {
        return 10;
    }

    double calculateModuleFactor() {
        return this.myBarsCount;
    }

    void invalidateDrawing() {
        this.myBars = null;
    }

    void prepareDrawing() {
        CharSequence barsBinary = this.encode();
        int barsBinaryLength = barsBinary.length();
        ArrayList<Integer> barCoords = new ArrayList<Integer>(120);
        int positionCounter = 0;
        int widthCounter = 0;
        char barOrSpace = barsBinary.charAt(0);
        for (int i = 0; i < barsBinaryLength; ++i) {
            char c = barsBinary.charAt(i);
            if (c != barOrSpace) {
                if (c == '0') {
                    barCoords.add(positionCounter);
                    barCoords.add(widthCounter);
                }
                barOrSpace = c;
                positionCounter += widthCounter;
                widthCounter = 1;
                continue;
            }
            ++widthCounter;
        }
        if (barsBinary.charAt(barsBinaryLength - 1) == '1') {
            barCoords.add(positionCounter);
            barCoords.add(widthCounter);
        }
        int[] bars = new int[barCoords.size()];
        for (int i = bars.length - 1; i >= 0; --i) {
            bars[i] = (Integer)barCoords.get(i);
        }
        this.myBars = bars;
        this.myBarsCount = barsBinaryLength;
        this.myModuleFactor = this.calculateModuleFactor();
    }

    public void draw(Graphics2D g2d, double x, double y, double w, double h, double dotSize, double moduleSize, double barWidthCorrection) {
        if (this.myBars == null) {
            this.prepareDrawing();
        }
        if (moduleSize > 0.0) {
            if (dotSize > 0.0) {
                moduleSize = (double)((int)(moduleSize / dotSize)) * dotSize;
            }
            double d = moduleSize * this.myModuleFactor;
            x += (w - d) / 2.0;
            w = d;
        } else if (dotSize > 0.0) {
            double d = w / this.myModuleFactor;
            d = w * (double)((int)(d / dotSize)) * dotSize / d;
            x += (w - d) / 2.0;
            w = d;
        }
        this.draw(g2d, x, y, w, h, barWidthCorrection);
    }

    public void draw(Graphics2D g2d, double x, double y, double w, double h) {
        this.draw(g2d, x, y, w, h, 0.0);
    }

    public void draw(Graphics2D g2d, double x, double y, double w, double h, double barWidthCorrection) {
        if (this.myBars == null) {
            this.prepareDrawing();
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, y, 0.0, h);
        if (this.myIsTextVisible) {
            String text = this.getText();
            double moduleWidth = w / this.myModuleFactor;
            double leftQuietZone = moduleWidth * (double)this.getQuietZoneLeft();
            double symbolWidth = w - leftQuietZone - moduleWidth * (double)this.getQuietZoneRight();
            Font font = this.myFont != null ? this.myFont : g2d.getFont();
            float fontSize = font.getSize2D();
            if (this.myIsFontSizeAdjusted) {
                fontSize = 0.0f;
                do {
                    g2d.setFont(font.deriveFont(fontSize += 0.1f));
                } while (g2d.getFontMetrics().getStringBounds(text, g2d).getWidth() < symbolWidth);
                fontSize -= 0.1f;
            }
            if (fontSize > 0.0f) {
                double yPos;
                g2d.setFont(font.deriveFont(fontSize));
                FontMetrics fm = g2d.getFontMetrics();
                LineMetrics lm = fm.getLineMetrics(text, g2d);
                double offset = (double)lm.getHeight() + this.myTextOffset;
                if (this.supportsTextOnTop() && this.myIsTextOnTop) {
                    yPos = lm.getAscent();
                    rect.y += offset;
                } else {
                    yPos = h - (double)lm.getDescent();
                }
                rect.height -= offset;
                g2d.drawString(text, (float)(x + leftQuietZone + (symbolWidth - fm.getStringBounds(text, g2d).getWidth()) / 2.0), (float)(y + yPos));
            }
        }
        double barWidth = w / (double)this.myBarsCount;
        double xShifted = x - barWidthCorrection;
        double bwcTwice = barWidthCorrection * 2.0;
        for (int i = this.myBars.length - 1; i > 0; i -= 2) {
            rect.x = xShifted + barWidth * (double)this.myBars[i - 1];
            rect.width = barWidth * (double)this.myBars[i] + bwcTwice;
            g2d.fill(rect);
        }
    }

    public Barcode clone() {
        try {
            return (Barcode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("Unexpected: Clone not supported", e);
        }
    }

    static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    static int findNonDigitPosition(CharSequence value) {
        int len = value.length();
        for (int i = 0; i != len; ++i) {
            if (Barcode.isDigit(value.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    static void validateNotEmpty(CharSequence content) throws BarcodeException {
        if (content.length() == 0) {
            throw new BarcodeException(105, "Content is empty", "Inhalt ist leer", new Object[0]);
        }
    }

    static void validateDigits(CharSequence content) throws BarcodeException {
        int pos = Barcode.findNonDigitPosition(content);
        if (pos >= 0) {
            throw new BarcodeException(115, "Character at position %s is not a digit", "Zeichen an Position %s ist keine Ziffer", pos);
        }
    }

    static void validateFixedLength(CharSequence content, int length) throws BarcodeException {
        if (content.length() != length) {
            throw new BarcodeException(125, "Expected character count: %s; Provided: %s", "Erwartete Zeichenanzahl: %s; Aktuell: %s", length, content.length());
        }
    }

    static void validateASCII(CharSequence content) throws BarcodeException {
        int len = content.length();
        for (int i = 0; i != len; ++i) {
            if (content.charAt(i) <= '\u007f') continue;
            throw new BarcodeException(120, "Character at position %s is not ASCII", "Zeichen an Position %s ist kein ASCII", i);
        }
    }

    static void validateModulo10(CharSequence contentWithCheckDigit) throws BarcodeException {
        int idx = contentWithCheckDigit.length() - 1;
        Barcode.validateCheckDigit(contentWithCheckDigit.charAt(idx) - 48, Barcode.calculateModulo10(contentWithCheckDigit.subSequence(0, idx)));
    }

    static void validateCheckDigit(int inputCheckDigit, int validCheckDigit) throws BarcodeException {
        if (inputCheckDigit != validCheckDigit) {
            throw new BarcodeException(205, "Expected check digit: %s; Provided: %s", "Erwartete Pr\u00fcfziffer: %s; Aktuell: %s", validCheckDigit, inputCheckDigit);
        }
    }

    static int calculateModulo10(CharSequence contentWithoutCheckDigit) {
        int len = contentWithoutCheckDigit.length() - 1;
        int sum = 0;
        for (int i = len; i >= 0; --i) {
            int k = contentWithoutCheckDigit.charAt(len - i) - 48;
            sum += i % 2 == 0 ? k * 3 : k;
        }
        return (sum = 10 - sum % 10) == 10 ? 0 : sum;
    }

    static void throwInvalidCharacter(int position) throws BarcodeException {
        throw new BarcodeException(110, "Invalid character at position %s", "Ung\u00fcltiges Zeichen an Position %s", position);
    }

    static void throwContentLengthNotEven(int length) throws BarcodeException {
        throw new BarcodeException(130, "Character count is not even: %s", "Zeichenanzahl ist nicht gerade: %s", length);
    }
}

