/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.image;

public enum ImageTransform {
    ROTATE_0(0),
    ROTATE_90(1),
    ROTATE_180(2),
    ROTATE_270(3),
    ROTATE_0_FLIP(4),
    ROTATE_90_FLIP(5),
    ROTATE_180_FLIP(6),
    ROTATE_270_FLIP(7);

    private final int myID;
    private static final ImageTransform[] cachedValues;

    private ImageTransform(int id) {
        this.myID = id;
    }

    public static ImageTransform valueOf(int id) {
        if (id < 0 || id > 7) {
            throw new IllegalArgumentException("Invalid image transform ID: " + id);
        }
        return cachedValues[id];
    }

    public int getID() {
        return this.myID;
    }

    public boolean isFlat() {
        return this == ROTATE_0 || this == ROTATE_180 || this == ROTATE_0_FLIP || this == ROTATE_180_FLIP;
    }

    public boolean hasFlip() {
        return this == ROTATE_0_FLIP || this == ROTATE_90_FLIP || this == ROTATE_180_FLIP || this == ROTATE_270_FLIP;
    }

    static {
        cachedValues = ImageTransform.values();
    }
}

