/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.image;

public enum ImageFormat {
    PDF(1),
    EPS(2),
    SVG(3),
    PNG(4),
    BMP(5),
    JPG(6);

    private final int myID;
    private static final ImageFormat[] cachedValues;

    private ImageFormat(int id) {
        this.myID = id;
    }

    public static ImageFormat valueOf(int id) {
        if (id < 1 || id > 6) {
            throw new IllegalArgumentException("Invalid image format ID: " + id);
        }
        return cachedValues[id - 1];
    }

    public int getID() {
        return this.myID;
    }

    public boolean isRasterFormat() {
        return this == PNG || this == BMP || this == JPG;
    }

    public boolean supportsTransparency() {
        return this == PDF || this == EPS || this == SVG || this == PNG;
    }

    public boolean supportsCMYK() {
        return this == PDF || this == EPS;
    }

    static {
        cachedValues = ImageFormat.values();
    }
}

