/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.image;

import java.awt.Color;

public class CompoundColor
extends Color {
    public static final CompoundColor CC_BLACK = new CompoundColor(0, 100);
    public static final CompoundColor CC_WHITE = new CompoundColor(0xFFFFFF, 0);
    private final int myCMYKColor;

    public CompoundColor(int r, int g, int b, int c, int m, int y, int k) {
        super(r, g, b, 255);
        CompoundColor.testColorValueRange(c, m, y, k);
        this.myCMYKColor = CompoundColor.toInteger(c, m, y, k);
    }

    public CompoundColor(int rgb, int cmyk) {
        super(rgb);
        this.myCMYKColor = CompoundColor.testColorValueRange(cmyk);
    }

    public CompoundColor(long rgbAndCmyk) {
        super((int)(rgbAndCmyk >> 32));
        this.myCMYKColor = CompoundColor.testColorValueRange((int)rgbAndCmyk);
    }

    public CompoundColor(int r, int g, int b) {
        super(r, g, b, 255);
        this.myCMYKColor = CompoundColor.toCMYK(r, g, b);
    }

    public CompoundColor(int c, int m, int y, int k) {
        super(CompoundColor.toRGB(c, m, y, k), true);
        CompoundColor.testColorValueRange(c, m, y, k);
        this.myCMYKColor = CompoundColor.toInteger(c, m, y, k);
    }

    public CompoundColor(Color rgbColor) {
        super(rgbColor.getRGB());
        this.myCMYKColor = CompoundColor.toCMYK(rgbColor.getRGB());
    }

    public CompoundColor(int value, boolean isRGB) {
        super(isRGB ? value : CompoundColor.toRGB(value));
        this.myCMYKColor = isRGB ? CompoundColor.toCMYK(value) : CompoundColor.testColorValueRange(value);
    }

    public long getRGBandCMYK() {
        return (long)this.getRGB() << 32 | (long)this.myCMYKColor;
    }

    public int getCMYK() {
        return this.myCMYKColor;
    }

    public int getCyan() {
        return this.myCMYKColor >> 24;
    }

    public int getMagenta() {
        return this.myCMYKColor >> 16 & 0xFF;
    }

    public int getYellow() {
        return this.myCMYKColor >> 8 & 0xFF;
    }

    public int getKey() {
        return this.myCMYKColor & 0xFF;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.getRGBandCMYK());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CompoundColor) {
            CompoundColor cc = (CompoundColor)obj;
            return cc.getRGB() == this.getRGB() && cc.getCMYK() == this.getCMYK();
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + "][c=" + this.getCyan() + ",m=" + this.getMagenta() + ",y=" + this.getYellow() + ",k=" + this.getKey() + "]";
    }

    private static void testColorValueRange(int c, int m, int y, int k) {
        Object badComponentString = "";
        if (c < 0 || c > 100) {
            badComponentString = (String)badComponentString + " Cyan";
        }
        if (m < 0 || m > 100) {
            badComponentString = (String)badComponentString + " Magenta";
        }
        if (y < 0 || y > 100) {
            badComponentString = (String)badComponentString + " Yellow";
        }
        if (k < 0 || k > 100) {
            badComponentString = (String)badComponentString + " Black";
        }
        if (!((String)badComponentString).isEmpty()) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + (String)badComponentString);
        }
    }

    private static int testColorValueRange(int cmykColor) {
        CompoundColor.testColorValueRange(cmykColor >> 24, cmykColor >> 16 & 0xFF, cmykColor >> 8 & 0xFF, cmykColor & 0xFF);
        return cmykColor;
    }

    private static int toCMYK(int r, int g, int b) {
        float c = (float)(255 - r) / 2.55f;
        float m = (float)(255 - g) / 2.55f;
        float y = (float)(255 - b) / 2.55f;
        float k = Math.min(c, Math.min(m, y));
        float tmp = (100.0f - k) / 100.0f;
        if (tmp > 0.0f) {
            c = (c - k) / tmp;
            m = (m - k) / tmp;
            y = (y - k) / tmp;
        } else {
            y = 0.0f;
            m = 0.0f;
            c = 0.0f;
        }
        return CompoundColor.toInteger(Math.round(c), Math.round(m), Math.round(y), Math.round(k));
    }

    private static int toCMYK(int rgb) {
        return CompoundColor.toCMYK(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    private static int toRGB(int c, int m, int y, int k) {
        float oneMinusK = 1.0f - (float)k / 100.0f;
        int r = Math.round(255.0f * (1.0f - (float)c / 100.0f) * oneMinusK);
        int g = Math.round(255.0f * (1.0f - (float)m / 100.0f) * oneMinusK);
        int b = Math.round(255.0f * (1.0f - (float)y / 100.0f) * oneMinusK);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static int toRGB(int cmyk) {
        return CompoundColor.toRGB(cmyk >> 24, cmyk >> 16 & 0xFF, cmyk >> 8 & 0xFF, cmyk & 0xFF);
    }

    private static int toInteger(int c, int m, int y, int k) {
        return c << 24 | m << 16 | y << 8 | k;
    }
}

