/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.image;

import de.vwsoft.barcodelib4j.image.CompoundColor;
import de.vwsoft.barcodelib4j.image.ImageColorModel;
import de.vwsoft.barcodelib4j.image.ImageFormat;
import de.vwsoft.barcodelib4j.image.ImageTransform;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.w3c.dom.NodeList;

public class BarExporter {
    private final DecimalFormat myDecimalFormat = new DecimalFormat("#.######", new DecimalFormatSymbols(Locale.US));
    private final BarcodeGraphics2D myGraphics2D = new BarcodeGraphics2D();
    private final Point2D.Double mySize;
    private String myTitle;
    private String myCreator;
    private boolean myIsOpaque = true;
    private CompoundColor myForeground = CompoundColor.CC_BLACK;
    private CompoundColor myBackground = CompoundColor.CC_WHITE;
    private ImageTransform myTransform = ImageTransform.ROTATE_0;
    private int myTiffRes;

    public BarExporter(double widthMM, double heightMM) {
        if (widthMM <= 0.0 || heightMM <= 0.0) {
            throw new IllegalArgumentException("Width and height must be greater than 0");
        }
        this.mySize = new Point2D.Double(widthMM, heightMM);
    }

    public Graphics2D getGraphics2D() {
        return this.myGraphics2D;
    }

    public void setTitle(String title) {
        this.myTitle = title == null || title.isBlank() ? null : title;
    }

    public void setCreator(String creator) {
        this.myCreator = creator == null || creator.isBlank() ? null : creator;
    }

    public void setOpaque(boolean opaque) {
        this.myIsOpaque = opaque;
    }

    public void setForeground(CompoundColor color) {
        this.myForeground = Objects.requireNonNull(color, "Foreground must not be null");
    }

    public void setBackground(CompoundColor color) {
        this.myBackground = Objects.requireNonNull(color, "Background must not be null");
    }

    public void setTransform(ImageTransform transform) {
        this.myTransform = Objects.requireNonNull(transform, "Transform must not be null");
    }

    public void setTiffResolution(int dpiRes) {
        if (dpiRes < 0) {
            throw new IllegalArgumentException("TIFF resolution must be >= 0");
        }
        this.myTiffRes = dpiRes;
    }

    public void write(OutputStream out, ImageFormat format, ImageColorModel colorModel, int dpiResX, int dpiResY) throws IOException {
        if (format == ImageFormat.PDF) {
            this.writePDF(out, colorModel);
        } else if (format == ImageFormat.EPS) {
            this.writeEPS(out, colorModel);
        } else if (format == ImageFormat.SVG) {
            this.writeSVG(out);
        } else {
            if (dpiResX <= 0 || dpiResY <= 0) {
                throw new IllegalArgumentException("Resolution must be > 0 for raster formats");
            }
            BufferedImage img = this.createBufferedImage(dpiResX, dpiResY, format, this.myForeground, this.myBackground);
            if (format == ImageFormat.PNG) {
                BarExporter.toPNG(img, out, dpiResX, dpiResY);
            } else if (format == ImageFormat.BMP) {
                BarExporter.toBMP(img, out, dpiResX, dpiResY);
            } else {
                BarExporter.toJPG(img, out, dpiResX, dpiResY, 1.0f);
            }
        }
    }

    public void writePNG(OutputStream out, int dpiResX, int dpiResY) throws IOException {
        this.write(out, ImageFormat.PNG, ImageColorModel.RGB, dpiResX, dpiResY);
    }

    public void writeBMP(OutputStream out, int dpiResX, int dpiResY) throws IOException {
        this.write(out, ImageFormat.BMP, ImageColorModel.RGB, dpiResX, dpiResY);
    }

    public void writeJPG(OutputStream out, int dpiResX, int dpiResY) throws IOException {
        this.write(out, ImageFormat.JPG, ImageColorModel.RGB, dpiResX, dpiResY);
    }

    public void writePDF(OutputStream out, ImageColorModel colorModel) throws IOException {
        try {
            String packageName = "com.lowagie.text.";
            try {
                Class.forName(packageName + "Document");
            }
            catch (ClassNotFoundException e) {
                packageName = "org.openpdf.text.";
            }
            Class<?> documentClass = Class.forName(packageName + "Document");
            Class<?> rectangleClass = Class.forName(packageName + "Rectangle");
            Class<?> byteBufferClass = Class.forName(packageName + "pdf.ByteBuffer");
            Class<?> cmykColorClass = Class.forName(packageName + "pdf.CMYKColor");
            Class<?> fontMapperClass = Class.forName(packageName + "pdf.FontMapper");
            Class<?> pdfActionClass = Class.forName(packageName + "pdf.PdfAction");
            Class<?> pdfContentByteClass = Class.forName(packageName + "pdf.PdfContentByte");
            Class<?> pdfDestinationClass = Class.forName(packageName + "pdf.PdfDestination");
            Class<?> pdfGraphics2DClass = Class.forName(packageName + "pdf.PdfGraphics2D");
            Class<?> pdfNameClass = Class.forName(packageName + "pdf.PdfName");
            Class<?> pdfObjectClass = Class.forName(packageName + "pdf.PdfObject");
            Class<?> pdfStreamClass = Class.forName(packageName + "pdf.PdfStream");
            Class<?> pdfWriterClass = Class.forName(packageName + "pdf.PdfWriter");
            Field highPrecisionField = byteBufferClass.getField("HIGH_PRECISION");
            boolean oldPrecision = highPrecisionField.getBoolean(null);
            highPrecisionField.setBoolean(null, true);
            double scale = 2.834645669291339;
            Point2D.Double size = this.getEffectiveSize();
            Point2D.Float docSize = new Point2D.Float((float)(size.x * 2.834645669291339), (float)(size.y * 2.834645669291339));
            Object rect = rectangleClass.getConstructor(Float.TYPE, Float.TYPE).newInstance(Float.valueOf(docSize.x), Float.valueOf(docSize.y));
            if (this.myIsOpaque) {
                rectangleClass.getMethod("setBackgroundColor", Color.class).invoke(rect, this.getColorForPDF(this.myBackground, colorModel, cmykColorClass));
            }
            Object doc = documentClass.getConstructor(rectangleClass).newInstance(rect);
            Object writer = pdfWriterClass.getMethod("getInstance", documentClass, OutputStream.class).invoke(null, doc, out);
            pdfWriterClass.getMethod("setCompressionLevel", Integer.TYPE).invoke(writer, pdfStreamClass.getField("BEST_COMPRESSION").getInt(null));
            pdfWriterClass.getMethod("setPDFXConformance", Integer.TYPE).invoke(writer, colorModel == ImageColorModel.CMYK ? pdfWriterClass.getField("PDFX1A2001").getInt(null) : pdfWriterClass.getField("PDFX32002").getInt(null));
            documentClass.getMethod("open", new Class[0]).invoke(doc, new Object[0]);
            if (this.myTitle != null) {
                documentClass.getMethod("addTitle", String.class).invoke(doc, this.myTitle);
            }
            if (this.myCreator != null) {
                documentClass.getMethod("addCreator", String.class).invoke(doc, this.myCreator);
                documentClass.getMethod("addProducer", String.class).invoke(doc, this.myCreator);
            }
            documentClass.getMethod("addSubject", String.class).invoke(doc, colorModel == ImageColorModel.CMYK ? "PDF/X-1a:2001, CMYK colors" : "PDF/X-3:2002, RGB colors");
            Object g2d = pdfGraphics2DClass.getConstructor(pdfContentByteClass, Float.TYPE, Float.TYPE, fontMapperClass, Boolean.TYPE, Boolean.TYPE, Float.TYPE).newInstance(pdfWriterClass.getMethod("getDirectContent", new Class[0]).invoke(writer, new Object[0]), Float.valueOf(docSize.x), Float.valueOf(docSize.y), null, true, false, Float.valueOf(1.0f));
            AffineTransform at = AffineTransform.getScaleInstance(2.834645669291339, 2.834645669291339);
            at.concatenate(this.createTransform());
            pdfGraphics2DClass.getMethod("setTransform", AffineTransform.class).invoke(g2d, at);
            pdfGraphics2DClass.getMethod("setColor", Color.class).invoke(g2d, this.getColorForPDF(this.myForeground, colorModel, cmykColorClass));
            pdfGraphics2DClass.getMethod("fill", Shape.class).invoke(g2d, this.myGraphics2D.getAllShapes());
            pdfGraphics2DClass.getMethod("dispose", new Class[0]).invoke(g2d, new Object[0]);
            pdfWriterClass.getMethod("addViewerPreference", pdfNameClass, pdfObjectClass).invoke(writer, pdfNameClass.getField("PRINTSCALING").get(null), pdfNameClass.getField("NONE").get(null));
            Object pdfDest = pdfDestinationClass.getConstructor(Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE).newInstance(pdfDestinationClass.getField("XYZ").getInt(null), Float.valueOf(0.0f), Float.valueOf(docSize.y), Float.valueOf(1.0f));
            pdfWriterClass.getMethod("setOpenAction", pdfActionClass).invoke(writer, pdfActionClass.getMethod("gotoLocalPage", Integer.TYPE, pdfDestinationClass, pdfWriterClass).invoke(null, 1, pdfDest, writer));
            documentClass.getMethod("close", new Class[0]).invoke(doc, new Object[0]);
            pdfWriterClass.getMethod("close", new Class[0]).invoke(writer, new Object[0]);
            highPrecisionField.setBoolean(null, oldPrecision);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("OpenPDF library not available, please add it to your classpath", e);
        }
        catch (ReflectiveOperationException e) {
            throw new IOException("Error accessing OpenPDF library via reflection", e);
        }
    }

    private Color getColorForPDF(CompoundColor c, ImageColorModel colorModel, Class<?> cmykColorClass) throws ReflectiveOperationException {
        return colorModel == ImageColorModel.RGB ? c : (Color)cmykColorClass.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE).newInstance(Float.valueOf((float)c.getCyan() / 100.0f), Float.valueOf((float)c.getMagenta() / 100.0f), Float.valueOf((float)c.getYellow() / 100.0f), Float.valueOf((float)c.getKey() / 100.0f));
    }

    public void writeEPS(OutputStream out, ImageColorModel colorModel) throws IOException {
        if (this.myTiffRes == 0) {
            this.writePureEPS(out, colorModel);
            return;
        }
        ByteArrayOutputStream epsArray = new ByteArrayOutputStream(10000);
        this.writePureEPS(epsArray, colorModel);
        ByteArrayOutputStream tiffArray = new ByteArrayOutputStream(10000);
        BufferedImage img = this.createBufferedImage(this.myTiffRes, this.myTiffRes, null, this.myForeground, this.myBackground);
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("tiff").next();
        ImageWriteParam param = imageWriter.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionType("LZW");
        MemoryCacheImageOutputStream mc = new MemoryCacheImageOutputStream(tiffArray);
        imageWriter.setOutput(mc);
        imageWriter.write(null, new IIOImage(img, null, null), param);
        mc.flush();
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeInt(-976170042);
        dos.writeInt(Integer.reverseBytes(30 + tiffArray.size()));
        dos.writeInt(Integer.reverseBytes(epsArray.size()));
        dos.writeInt(0);
        dos.writeInt(0);
        dos.writeInt(Integer.reverseBytes(30));
        dos.writeInt(Integer.reverseBytes(tiffArray.size()));
        dos.writeShort(65535);
        tiffArray.writeTo(dos);
        epsArray.writeTo(dos);
    }

    private void writePureEPS(OutputStream out, ImageColorModel colorModel) throws IOException {
        double scale = 2.834645669291339;
        Point2D.Double size = this.getEffectiveSize();
        Point2D.Double pageSize = new Point2D.Double(size.x * 2.834645669291339, size.y * 2.834645669291339);
        String br = "\n";
        StringBuilder sb = new StringBuilder(10000);
        this.apd(sb, "%!PS-Adobe-3.0 EPSF-3.0", "\n");
        if (this.myTitle != null) {
            this.apd(sb, "%%Title: ", this.myTitle, "\n");
        }
        if (this.myCreator != null) {
            this.apd(sb, "%%Creator: ", this.myCreator, "\n");
        }
        this.apd(sb, "%%HiResBoundingBox: 0 0 ", pageSize.x, Character.valueOf(' '), pageSize.y, "\n", "\n");
        this.apd(sb, "/m {moveto} bind def", "\n");
        this.apd(sb, "/l {lineto} bind def", "\n");
        this.apd(sb, "/c {curveto} bind def", "\n");
        this.apd(sb, "/z {closepath} bind def", "\n", "\n");
        if (this.myIsOpaque) {
            this.apd(sb, this.getColorCommandForEPS(this.myBackground, colorModel), "\n");
            this.apd(sb, "0 0 ", pageSize.x, Character.valueOf(' '), pageSize.y, " rectfill", "\n", "\n");
        }
        this.apd(sb, this.getColorCommandForEPS(this.myForeground, colorModel), "\n");
        double[] d = new double[6];
        double[] lastPoint = new double[2];
        double[] controlPoint = new double[4];
        AffineTransform at = AffineTransform.getTranslateInstance(0.0, pageSize.y);
        at.scale(2.834645669291339, -2.834645669291339);
        at.concatenate(this.createTransform());
        PathIterator pathIterator = this.myGraphics2D.getAllShapes().getPathIterator(at);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(d)) {
                case 0: {
                    this.apd(sb, d[0], Character.valueOf(' '), d[1], " m", "\n");
                    lastPoint[0] = d[0];
                    lastPoint[1] = d[1];
                    break;
                }
                case 1: {
                    this.apd(sb, d[0], Character.valueOf(' '), d[1], " l", "\n");
                    lastPoint[0] = d[0];
                    lastPoint[1] = d[1];
                    break;
                }
                case 2: {
                    controlPoint[0] = d[0] + (lastPoint[0] - d[0]) / 3.0;
                    controlPoint[1] = d[1] + (lastPoint[1] - d[1]) / 3.0;
                    controlPoint[2] = d[0] + (d[2] - d[0]) / 3.0;
                    controlPoint[3] = d[1] + (d[3] - d[1]) / 3.0;
                    this.apd(sb, controlPoint[0], Character.valueOf(' '), controlPoint[1], Character.valueOf(' '), controlPoint[2], Character.valueOf(' '), controlPoint[3], Character.valueOf(' '), d[2], Character.valueOf(' '), d[3], " c", "\n");
                    lastPoint[0] = d[2];
                    lastPoint[1] = d[3];
                    break;
                }
                case 3: {
                    this.apd(sb, d[0], Character.valueOf(' '), d[1], Character.valueOf(' '), d[2], Character.valueOf(' '), d[3], Character.valueOf(' '), d[4], Character.valueOf(' '), d[5], " c", "\n");
                    lastPoint[0] = d[4];
                    lastPoint[1] = d[5];
                    break;
                }
                case 4: {
                    this.apd(sb, Character.valueOf('z'), "\n");
                }
            }
            pathIterator.next();
        }
        this.apd(sb, "fill", "\n");
        out.write(sb.toString().getBytes(StandardCharsets.US_ASCII));
    }

    private String getColorCommandForEPS(CompoundColor c, ImageColorModel colorModel) {
        return colorModel == ImageColorModel.RGB ? this.myDecimalFormat.format((double)c.getRed() / 255.0) + " " + this.myDecimalFormat.format((double)c.getGreen() / 255.0) + " " + this.myDecimalFormat.format((double)c.getBlue() / 255.0) + " setrgbcolor" : this.myDecimalFormat.format((double)c.getCyan() / 100.0) + " " + this.myDecimalFormat.format((double)c.getMagenta() / 100.0) + " " + this.myDecimalFormat.format((double)c.getYellow() / 100.0) + " " + this.myDecimalFormat.format((double)c.getKey() / 100.0) + " setcmykcolor";
    }

    public void writeSVG(OutputStream out) throws IOException {
        String br = "\n";
        StringBuilder sb = new StringBuilder(10000);
        Point2D.Double size = this.getEffectiveSize();
        this.apd(sb, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "\n");
        this.apd(sb, "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"", size.x, "mm\" height=\"", size.y, "mm\" viewBox=\"0 0 ", size.x, Character.valueOf(' '), size.y, "\">", "\n");
        if (this.myTitle != null) {
            this.apd(sb, "<title>", BarExporter.escapeXML(this.myTitle), "</title>", "\n");
        }
        this.apd(sb, "<g>", "\n");
        this.apd(sb, "<rect ", this.myIsOpaque ? "fill=\"" + BarExporter.getColorForSVG(this.myBackground) : "opacity=\"0", "\" width=\"", size.x, "\" height=\"", size.y, "\"/>", "\n");
        this.apd(sb, "<path fill=\"", BarExporter.getColorForSVG(this.myForeground), "\" d=\"");
        double[] d = new double[6];
        PathIterator pathIterator = this.myGraphics2D.getAllShapes().getPathIterator(this.createTransform());
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(d)) {
                case 0: {
                    this.apd(sb, Character.valueOf('M'), d[0], Character.valueOf(','), d[1]);
                    break;
                }
                case 1: {
                    this.apd(sb, Character.valueOf('L'), d[0], Character.valueOf(','), d[1]);
                    break;
                }
                case 2: {
                    this.apd(sb, Character.valueOf('Q'), d[0], Character.valueOf(','), d[1], Character.valueOf(' '), d[2], Character.valueOf(','), d[3]);
                    break;
                }
                case 3: {
                    this.apd(sb, Character.valueOf('C'), d[0], Character.valueOf(','), d[1], Character.valueOf(' '), d[2], Character.valueOf(','), d[3], Character.valueOf(' '), d[4], Character.valueOf(','), d[5]);
                    break;
                }
                case 4: {
                    this.apd(sb, Character.valueOf('Z'));
                }
            }
            pathIterator.next();
        }
        this.apd(sb, "\"/>", "\n");
        this.apd(sb, "</g>", "\n");
        this.apd(sb, "</svg>", "\n");
        out.write(sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    private static String escapeXML(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 10);
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static String getColorForSVG(Color c) {
        return String.format("#%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue());
    }

    private void apd(StringBuilder sb, Object ... tokens) {
        for (Object t : tokens) {
            if (t instanceof Double) {
                sb.append(this.myDecimalFormat.format(t));
                continue;
            }
            sb.append(t);
        }
    }

    private AffineTransform createTransform() {
        AffineTransform at = new AffineTransform();
        if (this.myTransform == ImageTransform.ROTATE_90) {
            at.rotate(-1.5707963267948966);
            at.translate(-this.mySize.x, 0.0);
        } else if (this.myTransform == ImageTransform.ROTATE_180) {
            at.rotate(Math.PI);
            at.translate(-this.mySize.x, -this.mySize.y);
        } else if (this.myTransform == ImageTransform.ROTATE_270) {
            at.rotate(1.5707963267948966);
            at.translate(0.0, -this.mySize.y);
        } else if (this.myTransform == ImageTransform.ROTATE_0_FLIP) {
            at.scale(-1.0, 1.0);
            at.translate(-this.mySize.x, 0.0);
        } else if (this.myTransform == ImageTransform.ROTATE_90_FLIP) {
            at.scale(1.0, -1.0);
            at.rotate(-1.5707963267948966);
        } else if (this.myTransform == ImageTransform.ROTATE_180_FLIP) {
            at.scale(-1.0, 1.0);
            at.rotate(-Math.PI);
            at.translate(0.0, -this.mySize.y);
        } else if (this.myTransform == ImageTransform.ROTATE_270_FLIP) {
            at.scale(1.0, -1.0);
            at.rotate(1.5707963267948966);
            at.translate(-this.mySize.x, -this.mySize.y);
        }
        return at;
    }

    private Point2D.Double getEffectiveSize() {
        return this.myTransform.isFlat() ? this.mySize : new Point2D.Double(this.mySize.y, this.mySize.x);
    }

    private BufferedImage createBufferedImage(int dpiResX, int dpiResY, ImageFormat format, Color fgColor, Color bgColor) {
        boolean ensureTransparency;
        double resolutionMmX = (double)dpiResX / 25.4;
        double resolutionMmY = (double)dpiResY / 25.4;
        Point2D.Double size = this.getEffectiveSize();
        int pxlWidth = Math.round((float)(size.x * resolutionMmX + 0.5));
        int pxlHeight = Math.round((float)(size.y * resolutionMmY + 0.5));
        boolean bl = ensureTransparency = !this.myIsOpaque && (format == ImageFormat.PNG || format == null);
        BufferedImage bi = ensureTransparency ? new BufferedImage(pxlWidth, pxlHeight, 2) : (format == ImageFormat.JPG && fgColor.getRed() == fgColor.getGreen() && fgColor.getGreen() == fgColor.getBlue() && bgColor.getRed() == bgColor.getGreen() && bgColor.getGreen() == bgColor.getBlue() ? new BufferedImage(pxlWidth, pxlHeight, 10) : new BufferedImage(pxlWidth, pxlHeight, 1));
        Graphics2D g2d = bi.createGraphics();
        if (!ensureTransparency) {
            g2d.setColor(bgColor);
            g2d.fillRect(0, 0, pxlWidth, pxlHeight);
        }
        AffineTransform at = AffineTransform.getScaleInstance(resolutionMmX, resolutionMmY);
        at.concatenate(this.createTransform());
        g2d.setTransform(at);
        g2d.setColor(fgColor);
        g2d.fill(this.myGraphics2D.getBarsShapes());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.fill(this.myGraphics2D.getTextShapes());
        g2d.dispose();
        return bi;
    }

    private static void toPNG(RenderedImage img, OutputStream out, int dpiResX, int dpiResY) throws IOException {
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("png").next();
        IIOMetadata iiomd = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(img), imageWriter.getDefaultWriteParam());
        if (dpiResX > 0 && dpiResY > 0) {
            String formatName = "javax_imageio_png_1.0";
            IIOMetadataNode rootNode = (IIOMetadataNode)iiomd.getAsTree(formatName);
            IIOMetadataNode pHYSNode = BarExporter.ensureChildNode(rootNode, "pHYs");
            pHYSNode.setAttribute("unitSpecifier", "meter");
            pHYSNode.setAttribute("pixelsPerUnitXAxis", Long.toString(Math.round((double)dpiResX / 0.0254)));
            pHYSNode.setAttribute("pixelsPerUnitYAxis", Long.toString(Math.round((double)dpiResY / 0.0254)));
            try {
                iiomd.setFromTree(formatName, rootNode);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                // empty catch block
            }
        }
        imageWriter.setOutput(new MemoryCacheImageOutputStream(out));
        imageWriter.write(new IIOImage(img, null, iiomd));
    }

    private static void toBMP(RenderedImage img, OutputStream out, final int dpiResX, final int dpiResY) throws IOException {
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("bmp").next();
        ImageWriteParam param = imageWriter.getDefaultWriteParam();
        IIOMetadata iiomd = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(img), param);
        DataOutputStream dos = new DataOutputStream(out){
            ByteArrayOutputStream baos;
            {
                super(arg0);
                this.baos = new ByteArrayOutputStream(50);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (this.baos != null) {
                    this.baos.write(b, off, len);
                    if (this.baos.size() >= 38) {
                        b = this.baos.toByteArray();
                        super.write(b, 0, 38);
                        super.writeInt(Integer.reverseBytes(Math.round((float)dpiResX / 0.0254f)));
                        super.writeInt(Integer.reverseBytes(Math.round((float)dpiResY / 0.0254f)));
                        if (b.length > 46) {
                            super.write(b, 46, b.length - 46);
                        }
                        this.baos = null;
                    }
                } else {
                    super.write(b, off, len);
                }
            }
        };
        imageWriter.setOutput(new MemoryCacheImageOutputStream(dos));
        imageWriter.write(new IIOImage(img, null, iiomd));
    }

    private static void toJPG(RenderedImage img, OutputStream out, int dpiResX, int dpiResY, float quality) throws IOException {
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam param = imageWriter.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionQuality(quality);
        IIOMetadata iiomd = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(img), param);
        if (dpiResX > 0 && dpiResX <= 65535 && dpiResY > 0 && dpiResY <= 65535) {
            String formatName = "javax_imageio_jpeg_image_1.0";
            IIOMetadataNode rootNode = (IIOMetadataNode)iiomd.getAsTree(formatName);
            IIOMetadataNode node = BarExporter.ensureChildNode(BarExporter.ensureChildNode(rootNode, "JPEGvariety"), "app0JFIF");
            node.setAttribute("resUnits", "1");
            node.setAttribute("Xdensity", Integer.toString(dpiResX));
            node.setAttribute("Ydensity", Integer.toString(dpiResY));
            try {
                iiomd.setFromTree(formatName, rootNode);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                // empty catch block
            }
        }
        imageWriter.setOutput(new MemoryCacheImageOutputStream(out));
        imageWriter.write(new IIOImage(img, null, iiomd));
    }

    private static IIOMetadataNode ensureChildNode(IIOMetadataNode parentNode, String nodeName) {
        NodeList nodeList = parentNode.getElementsByTagName(nodeName);
        if (nodeList.getLength() == 0) {
            IIOMetadataNode node = new IIOMetadataNode(nodeName);
            parentNode.appendChild(node);
            return node;
        }
        return (IIOMetadataNode)nodeList.item(0);
    }

    private static class BarcodeGraphics2D
    extends Graphics2D {
        Graphics2D fontG2D = new BufferedImage(1, 1, 10).createGraphics();
        Area barsShapes = new Area();
        Area textShapes = new Area();

        BarcodeGraphics2D() {
            this.fontG2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }

        Area getBarsShapes() {
            return this.barsShapes;
        }

        Area getTextShapes() {
            return this.textShapes;
        }

        Area getAllShapes() {
            Area a = new Area();
            a.add(this.barsShapes);
            a.add(this.textShapes);
            return a;
        }

        @Override
        public void fill(Shape shape) {
            this.barsShapes.add(new Area(shape));
        }

        @Override
        public void drawString(String text, float x, float y) {
            FontRenderContext rc = this.getFontRenderContext();
            char[] c = text.toCharArray();
            GlyphVector gv = this.getFont().layoutGlyphVector(rc, c, 0, c.length, 0);
            this.textShapes.add(new Area(gv.getOutline(x, y)));
        }

        @Override
        public void setFont(Font font) {
            this.fontG2D.setFont(font);
        }

        @Override
        public Font getFont() {
            return this.fontG2D.getFont();
        }

        @Override
        public FontMetrics getFontMetrics(Font f) {
            return this.fontG2D.getFontMetrics();
        }

        @Override
        public FontRenderContext getFontRenderContext() {
            return this.fontG2D.getFontRenderContext();
        }

        @Override
        public void dispose() {
            this.fontG2D.dispose();
        }

        private static <T> T u() {
            throw new UnsupportedOperationException("Method not supported by Graphics2D implementation");
        }

        @Override
        public void addRenderingHints(Map<?, ?> hints) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void clearRect(int x, int y, int width, int height) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void clip(Shape s) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void clipRect(int x, int y, int width, int height) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void copyArea(int x, int y, int width, int height, int dx, int dy) {
            BarcodeGraphics2D.u();
        }

        @Override
        public Graphics create() {
            return (Graphics)BarcodeGraphics2D.u();
        }

        @Override
        public void draw(Shape s) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void drawGlyphVector(GlyphVector g, float x, float y) {
            BarcodeGraphics2D.u();
        }

        @Override
        public boolean drawImage(Image i, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver o) {
            return (Boolean)BarcodeGraphics2D.u();
        }

        @Override
        public boolean drawImage(Image i, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
            return (Boolean)BarcodeGraphics2D.u();
        }

        @Override
        public boolean drawImage(Image i, int x, int y, Color bgrClr, ImageObserver o) {
            return (Boolean)BarcodeGraphics2D.u();
        }

        @Override
        public boolean drawImage(Image i, int x, int y, int w, int h, ImageObserver o) {
            return (Boolean)BarcodeGraphics2D.u();
        }

        @Override
        public boolean drawImage(Image i, int x, int y, ImageObserver observer) {
            return (Boolean)BarcodeGraphics2D.u();
        }

        @Override
        public boolean drawImage(Image i, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
            return (Boolean)BarcodeGraphics2D.u();
        }

        @Override
        public void drawImage(BufferedImage i, BufferedImageOp op, int x, int y) {
            BarcodeGraphics2D.u();
        }

        @Override
        public boolean drawImage(Image i, AffineTransform at, ImageObserver obs) {
            return (Boolean)BarcodeGraphics2D.u();
        }

        @Override
        public void drawLine(int x1, int y1, int x2, int y2) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void drawOval(int x, int y, int width, int height) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void drawRenderableImage(RenderableImage i, AffineTransform xform) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void drawRenderedImage(RenderedImage i, AffineTransform xform) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void drawRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void drawString(AttributedCharacterIterator iterator, float x, float y) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void drawString(AttributedCharacterIterator iterator, int x, int y) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void drawString(String str, int x, int y) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void fillOval(int x, int y, int width, int height) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void fillRect(int x, int y, int width, int height) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void fillRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight) {
            BarcodeGraphics2D.u();
        }

        @Override
        public Color getBackground() {
            return (Color)BarcodeGraphics2D.u();
        }

        @Override
        public GraphicsConfiguration getDeviceConfiguration() {
            return (GraphicsConfiguration)BarcodeGraphics2D.u();
        }

        @Override
        public Shape getClip() {
            return (Shape)BarcodeGraphics2D.u();
        }

        @Override
        public Rectangle getClipBounds() {
            return (Rectangle)BarcodeGraphics2D.u();
        }

        @Override
        public Color getColor() {
            return (Color)BarcodeGraphics2D.u();
        }

        @Override
        public Composite getComposite() {
            return (Composite)BarcodeGraphics2D.u();
        }

        @Override
        public Paint getPaint() {
            return (Paint)BarcodeGraphics2D.u();
        }

        @Override
        public Object getRenderingHint(RenderingHints.Key hintKey) {
            return BarcodeGraphics2D.u();
        }

        @Override
        public RenderingHints getRenderingHints() {
            return (RenderingHints)BarcodeGraphics2D.u();
        }

        @Override
        public Stroke getStroke() {
            return (Stroke)BarcodeGraphics2D.u();
        }

        @Override
        public AffineTransform getTransform() {
            return (AffineTransform)BarcodeGraphics2D.u();
        }

        @Override
        public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
            return (Boolean)BarcodeGraphics2D.u();
        }

        @Override
        public void rotate(double theta, double x, double y) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void rotate(double theta) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void scale(double sx, double sy) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void setBackground(Color c) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void setClip(int x, int y, int width, int height) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void setClip(Shape clip) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void setColor(Color c) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void setComposite(Composite comp) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void setPaint(Paint paint) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void setPaintMode() {
            BarcodeGraphics2D.u();
        }

        @Override
        public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void setRenderingHints(Map<?, ?> hints) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void setStroke(Stroke s) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void setTransform(AffineTransform Tx) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void setXORMode(Color c1) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void shear(double shx, double shy) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void transform(AffineTransform Tx) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void translate(int x, int y) {
            BarcodeGraphics2D.u();
        }

        @Override
        public void translate(double tx, double ty) {
            BarcodeGraphics2D.u();
        }
    }
}

