package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;
import org.bridj.ann.Ptr;

/**
 * -------------------------------------------------------------------------*<br>
 * PixComp: compressed pix *<br>
 * -------------------------------------------------------------------------<br>
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\pix.h:570</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class PixComp extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * width in pixels<br>
     * C type : l_int32
     */
    @Field(0)
    public int w() {
        return this.io.getIntField(this, 0);
    }

    /**
     * width in pixels<br>
     * C type : l_int32
     */
    @Field(0)
    public PixComp w(int w) {
        this.io.setIntField(this, 0, w);
        return this;
    }

    /**
     * height in pixels<br>
     * C type : l_int32
     */
    @Field(1)
    public int h() {
        return this.io.getIntField(this, 1);
    }

    /**
     * height in pixels<br>
     * C type : l_int32
     */
    @Field(1)
    public PixComp h(int h) {
        this.io.setIntField(this, 1, h);
        return this;
    }

    /**
     * depth in bits<br>
     * C type : l_int32
     */
    @Field(2)
    public int d() {
        return this.io.getIntField(this, 2);
    }

    /**
     * depth in bits<br>
     * C type : l_int32
     */
    @Field(2)
    public PixComp d(int d) {
        this.io.setIntField(this, 2, d);
        return this;
    }

    /**
     * image res (ppi) in x direction<br>
     * C type : l_int32
     */
    @Field(3)
    public int xres() {
        return this.io.getIntField(this, 3);
    }

    /**
     * image res (ppi) in x direction<br>
     * C type : l_int32
     */
    @Field(3)
    public PixComp xres(int xres) {
        this.io.setIntField(this, 3, xres);
        return this;
    }

    /**
     * image res (ppi) in y direction<br>
     * C type : l_int32
     */
    @Field(4)
    public int yres() {
        return this.io.getIntField(this, 4);
    }

    /**
     * image res (ppi) in y direction<br>
     * C type : l_int32
     */
    @Field(4)
    public PixComp yres(int yres) {
        this.io.setIntField(this, 4, yres);
        return this;
    }

    /**
     * compressed format (IFF_TIFF_G4,<br>
     * C type : l_int32
     */
    @Field(5)
    public int comptype() {
        return this.io.getIntField(this, 5);
    }

    /**
     * compressed format (IFF_TIFF_G4,<br>
     * C type : l_int32
     */
    @Field(5)
    public PixComp comptype(int comptype) {
        this.io.setIntField(this, 5, comptype);
        return this;
    }

    /**
     * text string associated with pix<br>
     * C type : char*
     */
    @Field(6)
    public Pointer<Byte> text() {
        return this.io.getPointerField(this, 6);
    }

    /**
     * text string associated with pix<br>
     * C type : char*
     */
    @Field(6)
    public PixComp text(Pointer<Byte> text) {
        this.io.setPointerField(this, 6, text);
        return this;
    }

    /**
     * flag (1 for cmap, 0 otherwise)<br>
     * C type : l_int32
     */
    @Field(7)
    public int cmapflag() {
        return this.io.getIntField(this, 7);
    }

    /**
     * flag (1 for cmap, 0 otherwise)<br>
     * C type : l_int32
     */
    @Field(7)
    public PixComp cmapflag(int cmapflag) {
        this.io.setIntField(this, 7, cmapflag);
        return this;
    }

    /**
     * the compressed image data<br>
     * C type : l_uint8*
     */
    @Field(8)
    public Pointer<Byte> data() {
        return this.io.getPointerField(this, 8);
    }

    /**
     * the compressed image data<br>
     * C type : l_uint8*
     */
    @Field(8)
    public PixComp data(Pointer<Byte> data) {
        this.io.setPointerField(this, 8, data);
        return this;
    }

    /** size of the data array */
    @Ptr
    @Field(9)
    public long size() {
        return this.io.getSizeTField(this, 9);
    }

    /** size of the data array */
    @Ptr
    @Field(9)
    public PixComp size(long size) {
        this.io.setSizeTField(this, 9, size);
        return this;
    }

    public PixComp() {
        super();
    }

    public PixComp(Pointer pointer) {
        super(pointer);
    }
}
