package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * heap.h<br>
 * Expandable priority queue configured as a heap for arbitrary void* data<br>
 * The L_Heap is used to implement a priority queue. The elements<br>
 * in the heap are ordered in either increasing or decreasing key value.<br>
 * The key is a float field 'keyval' that is required to be<br>
 * contained in the elements of the queue.<br>
 * <br>
 * The heap is a simple binary tree with the following constraints:<br>
 * - the key of each node is >= the keys of the two children<br>
 * - the tree is complete, meaning that each level (1, 2, 4, ...)<br>
 * is filled and the last level is filled from left to right<br>
 * The tree structure is implicit in the queue array, with the<br>
 * array elements numbered as a breadth-first search of the tree<br>
 * from left to right. It is thus guaranteed that the largest<br>
 * (or smallest) key belongs to the first element in the array.<br>
 * Heap sort is used to sort the array. Once an array has been<br>
 * sorted as a heap, it is convenient to use it as a priority queue,<br>
 * because the min (or max) elements are always at the root of<br>
 * the tree (element 0), and once removed, the heap can be<br>
 * resorted in not more than log[n] steps, where n is the number<br>
 * of elements on the heap. Likewise, if an arbitrary element is<br>
 * added to the end of the array A, the sorted heap can be restored<br>
 * in not more than log[n] steps.<br>
 * A L_Heap differs from a L_Queue in that the elements in the former<br>
 * are sorted by a key. Internally, the array is maintained<br>
 * as a queue, with a pointer to the end of the array. The<br>
 * head of the array always remains at array[0]. The array is<br>
 * maintained (sorted) as a heap. When an item is removed from<br>
 * the head, the last item takes its place (thus reducing the<br>
 * array length by 1), and this is followed by array element<br>
 * swaps to restore the heap property. When an item is added,<br>
 * it goes at the end of the array, and is swapped up to restore<br>
 * the heap. If the ptr array is full, adding another item causes<br>
 * the ptr array size to double.<br>
 * <br>
 * For further implementation details, see heap.c.<br>
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\heap.h:74</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class L_Heap extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * size of allocated ptr array<br>
     * C type : l_int32
     */
    @Field(0)
    public int nalloc() {
        return this.io.getIntField(this, 0);
    }

    /**
     * size of allocated ptr array<br>
     * C type : l_int32
     */
    @Field(0)
    public L_Heap nalloc(int nalloc) {
        this.io.setIntField(this, 0, nalloc);
        return this;
    }

    /**
     * number of elements stored in the heap<br>
     * C type : l_int32
     */
    @Field(1)
    public int n() {
        return this.io.getIntField(this, 1);
    }

    /**
     * number of elements stored in the heap<br>
     * C type : l_int32
     */
    @Field(1)
    public L_Heap n(int n) {
        this.io.setIntField(this, 1, n);
        return this;
    }

    /**
     * ptr array<br>
     * C type : void**
     */
    @Field(2)
    public Pointer<Pointer<?>> array() {
        return this.io.getPointerField(this, 2);
    }

    /**
     * ptr array<br>
     * C type : void**
     */
    @Field(2)
    public L_Heap array(Pointer<Pointer<?>> array) {
        this.io.setPointerField(this, 2, array);
        return this;
    }

    /**
     * L_SORT_INCREASING or L_SORT_DECREASING<br>
     * C type : l_int32
     */
    @Field(3)
    public int direction() {
        return this.io.getIntField(this, 3);
    }

    /**
     * L_SORT_INCREASING or L_SORT_DECREASING<br>
     * C type : l_int32
     */
    @Field(3)
    public L_Heap direction(int direction) {
        this.io.setIntField(this, 3, direction);
        return this;
    }

    public L_Heap() {
        super();
    }

    public L_Heap(Pointer pointer) {
        super(pointer);
    }
}
