package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * -------------------------------------------------------------------------*<br>
 * Pix accumulator container *<br>
 * -------------------------------------------------------------------------<br>
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\pix.h:489</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class Pixacc extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * array width<br>
     * C type : l_int32
     */
    @Field(0)
    public int w() {
        return this.io.getIntField(this, 0);
    }

    /**
     * array width<br>
     * C type : l_int32
     */
    @Field(0)
    public Pixacc w(int w) {
        this.io.setIntField(this, 0, w);
        return this;
    }

    /**
     * array height<br>
     * C type : l_int32
     */
    @Field(1)
    public int h() {
        return this.io.getIntField(this, 1);
    }

    /**
     * array height<br>
     * C type : l_int32
     */
    @Field(1)
    public Pixacc h(int h) {
        this.io.setIntField(this, 1, h);
        return this;
    }

    /**
     * used to allow negative<br>
     * C type : l_int32
     */
    @Field(2)
    public int offset() {
        return this.io.getIntField(this, 2);
    }

    /**
     * used to allow negative<br>
     * C type : l_int32
     */
    @Field(2)
    public Pixacc offset(int offset) {
        this.io.setIntField(this, 2, offset);
        return this;
    }

    /**
     * the 32 bit accumulator pix<br>
     * C type : Pix*
     */
    @Field(3)
    public Pointer<Pix> pix() {
        return this.io.getPointerField(this, 3);
    }

    /**
     * the 32 bit accumulator pix<br>
     * C type : Pix*
     */
    @Field(3)
    public Pixacc pix(Pointer<Pix> pix) {
        this.io.setPointerField(this, 3, pix);
        return this;
    }

    public Pixacc() {
        super();
    }

    public Pixacc(Pointer pointer) {
        super(pointer);
    }
}
