package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * queue.h<br>
 * Expandable pointer queue for arbitrary void* data.<br>
 * The L_Queue is a fifo that implements a queue of void* pointers.<br>
 * It can be used to hold a queue of any type of struct.<br>
 * Internally, it maintains two counters:<br>
 * nhead: location of head (in ptrs) from the beginning<br>
 * of the array.<br>
 * nelem: number of ptr elements stored in the queue.<br>
 * The element at the head of the queue, which is the next to<br>
 * be removed, is array[nhead]. The location at the tail of the<br>
 * queue to which the next element will be added is<br>
 * array[nhead + nelem].<br>
 * <br>
 * As items are added to the queue, nelem increases.<br>
 * As items are removed, nhead increases and nelem decreases.<br>
 * Any time the tail reaches the end of the allocated array,<br>
 * all the pointers are shifted to the left, so that the head<br>
 * is at the beginning of the array.<br>
 * If the array becomes more than 3/4 full, it doubles in size.<br>
 * The auxiliary stack can be used in a wrapper for re-using<br>
 * items popped from the queue. It is not made by default.<br>
 * For further implementation details, see queue.c.<br>
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\queue.h:61</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class L_Queue extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * size of allocated ptr array<br>
     * C type : l_int32
     */
    @Field(0)
    public int nalloc() {
        return this.io.getIntField(this, 0);
    }

    /**
     * size of allocated ptr array<br>
     * C type : l_int32
     */
    @Field(0)
    public L_Queue nalloc(int nalloc) {
        this.io.setIntField(this, 0, nalloc);
        return this;
    }

    /**
     * location of head (in ptrs) from the<br>
     * C type : l_int32
     */
    @Field(1)
    public int nhead() {
        return this.io.getIntField(this, 1);
    }

    /**
     * location of head (in ptrs) from the<br>
     * C type : l_int32
     */
    @Field(1)
    public L_Queue nhead(int nhead) {
        this.io.setIntField(this, 1, nhead);
        return this;
    }

    /**
     * number of elements stored in the queue<br>
     * C type : l_int32
     */
    @Field(2)
    public int nelem() {
        return this.io.getIntField(this, 2);
    }

    /**
     * number of elements stored in the queue<br>
     * C type : l_int32
     */
    @Field(2)
    public L_Queue nelem(int nelem) {
        this.io.setIntField(this, 2, nelem);
        return this;
    }

    /**
     * ptr array<br>
     * C type : void**
     */
    @Field(3)
    public Pointer<Pointer<?>> array() {
        return this.io.getPointerField(this, 3);
    }

    /**
     * ptr array<br>
     * C type : void**
     */
    @Field(3)
    public L_Queue array(Pointer<Pointer<?>> array) {
        this.io.setPointerField(this, 3, array);
        return this;
    }

    /**
     * auxiliary stack<br>
     * C type : L_Stack*
     */
    @Field(4)
    public Pointer<L_Stack> stack() {
        return this.io.getPointerField(this, 4);
    }

    /**
     * auxiliary stack<br>
     * C type : L_Stack*
     */
    @Field(4)
    public L_Queue stack(Pointer<L_Stack> stack) {
        this.io.setPointerField(this, 4, stack);
        return this;
    }

    public L_Queue() {
        super();
    }

    public L_Queue(Pointer pointer) {
        super(pointer);
    }
}
