package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\jbclass.h:43</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class JbClasser extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * input page image file names<br>
     * C type : Sarray*
     */
    @Field(0)
    public Pointer<Sarray> safiles() {
        return this.io.getPointerField(this, 0);
    }

    /**
     * input page image file names<br>
     * C type : Sarray*
     */
    @Field(0)
    public JbClasser safiles(Pointer<Sarray> safiles) {
        this.io.setPointerField(this, 0, safiles);
        return this;
    }

    /**
     * JB_RANKHAUS, JB_CORRELATION<br>
     * C type : l_int32
     */
    @Field(1)
    public int method() {
        return this.io.getIntField(this, 1);
    }

    /**
     * JB_RANKHAUS, JB_CORRELATION<br>
     * C type : l_int32
     */
    @Field(1)
    public JbClasser method(int method) {
        this.io.setIntField(this, 1, method);
        return this;
    }

    /**
     * JB_CONN_COMPS, JB_CHARACTERS or<br>
     * C type : l_int32
     */
    @Field(2)
    public int components() {
        return this.io.getIntField(this, 2);
    }

    /**
     * JB_CONN_COMPS, JB_CHARACTERS or<br>
     * C type : l_int32
     */
    @Field(2)
    public JbClasser components(int components) {
        this.io.setIntField(this, 2, components);
        return this;
    }

    /**
     * max component width allowed<br>
     * C type : l_int32
     */
    @Field(3)
    public int maxwidth() {
        return this.io.getIntField(this, 3);
    }

    /**
     * max component width allowed<br>
     * C type : l_int32
     */
    @Field(3)
    public JbClasser maxwidth(int maxwidth) {
        this.io.setIntField(this, 3, maxwidth);
        return this;
    }

    /**
     * max component height allowed<br>
     * C type : l_int32
     */
    @Field(4)
    public int maxheight() {
        return this.io.getIntField(this, 4);
    }

    /**
     * max component height allowed<br>
     * C type : l_int32
     */
    @Field(4)
    public JbClasser maxheight(int maxheight) {
        this.io.setIntField(this, 4, maxheight);
        return this;
    }

    /**
     * number of pages already processed<br>
     * C type : l_int32
     */
    @Field(5)
    public int npages() {
        return this.io.getIntField(this, 5);
    }

    /**
     * number of pages already processed<br>
     * C type : l_int32
     */
    @Field(5)
    public JbClasser npages(int npages) {
        this.io.setIntField(this, 5, npages);
        return this;
    }

    /**
     * number of components already processed<br>
     * C type : l_int32
     */
    @Field(6)
    public int baseindex() {
        return this.io.getIntField(this, 6);
    }

    /**
     * number of components already processed<br>
     * C type : l_int32
     */
    @Field(6)
    public JbClasser baseindex(int baseindex) {
        this.io.setIntField(this, 6, baseindex);
        return this;
    }

    /**
     * number of components on each page<br>
     * C type : Numa*
     */
    @Field(7)
    public Pointer<Numa> nacomps() {
        return this.io.getPointerField(this, 7);
    }

    /**
     * number of components on each page<br>
     * C type : Numa*
     */
    @Field(7)
    public JbClasser nacomps(Pointer<Numa> nacomps) {
        this.io.setPointerField(this, 7, nacomps);
        return this;
    }

    /**
     * size of square struct element for haus<br>
     * C type : l_int32
     */
    @Field(8)
    public int sizehaus() {
        return this.io.getIntField(this, 8);
    }

    /**
     * size of square struct element for haus<br>
     * C type : l_int32
     */
    @Field(8)
    public JbClasser sizehaus(int sizehaus) {
        this.io.setIntField(this, 8, sizehaus);
        return this;
    }

    /**
     * rank val of haus match, each way<br>
     * C type : l_float32
     */
    @Field(9)
    public float rankhaus() {
        return this.io.getFloatField(this, 9);
    }

    /**
     * rank val of haus match, each way<br>
     * C type : l_float32
     */
    @Field(9)
    public JbClasser rankhaus(float rankhaus) {
        this.io.setFloatField(this, 9, rankhaus);
        return this;
    }

    /**
     * thresh value for correlation score<br>
     * C type : l_float32
     */
    @Field(10)
    public float thresh() {
        return this.io.getFloatField(this, 10);
    }

    /**
     * thresh value for correlation score<br>
     * C type : l_float32
     */
    @Field(10)
    public JbClasser thresh(float thresh) {
        this.io.setFloatField(this, 10, thresh);
        return this;
    }

    /**
     * corrects thresh value for heaver<br>
     * C type : l_float32
     */
    @Field(11)
    public float weightfactor() {
        return this.io.getFloatField(this, 11);
    }

    /**
     * corrects thresh value for heaver<br>
     * C type : l_float32
     */
    @Field(11)
    public JbClasser weightfactor(float weightfactor) {
        this.io.setFloatField(this, 11, weightfactor);
        return this;
    }

    /**
     * w * h of each template, without extra<br>
     * C type : Numa*
     */
    @Field(12)
    public Pointer<Numa> naarea() {
        return this.io.getPointerField(this, 12);
    }

    /**
     * w * h of each template, without extra<br>
     * C type : Numa*
     */
    @Field(12)
    public JbClasser naarea(Pointer<Numa> naarea) {
        this.io.setPointerField(this, 12, naarea);
        return this;
    }

    /**
     * max width of original src images<br>
     * C type : l_int32
     */
    @Field(13)
    public int w() {
        return this.io.getIntField(this, 13);
    }

    /**
     * max width of original src images<br>
     * C type : l_int32
     */
    @Field(13)
    public JbClasser w(int w) {
        this.io.setIntField(this, 13, w);
        return this;
    }

    /**
     * max height of original src images<br>
     * C type : l_int32
     */
    @Field(14)
    public int h() {
        return this.io.getIntField(this, 14);
    }

    /**
     * max height of original src images<br>
     * C type : l_int32
     */
    @Field(14)
    public JbClasser h(int h) {
        this.io.setIntField(this, 14, h);
        return this;
    }

    /**
     * current number of classes<br>
     * C type : l_int32
     */
    @Field(15)
    public int nclass() {
        return this.io.getIntField(this, 15);
    }

    /**
     * current number of classes<br>
     * C type : l_int32
     */
    @Field(15)
    public JbClasser nclass(int nclass) {
        this.io.setIntField(this, 15, nclass);
        return this;
    }

    /**
     * If zero, pixaa isn't filled<br>
     * C type : l_int32
     */
    @Field(16)
    public int keep_pixaa() {
        return this.io.getIntField(this, 16);
    }

    /**
     * If zero, pixaa isn't filled<br>
     * C type : l_int32
     */
    @Field(16)
    public JbClasser keep_pixaa(int keep_pixaa) {
        this.io.setIntField(this, 16, keep_pixaa);
        return this;
    }

    /**
     * instances for each class; unbordered<br>
     * C type : Pixaa*
     */
    @Field(17)
    public Pointer<Pixaa> pixaa() {
        return this.io.getPointerField(this, 17);
    }

    /**
     * instances for each class; unbordered<br>
     * C type : Pixaa*
     */
    @Field(17)
    public JbClasser pixaa(Pointer<Pixaa> pixaa) {
        this.io.setPointerField(this, 17, pixaa);
        return this;
    }

    /**
     * templates for each class; bordered<br>
     * C type : Pixa*
     */
    @Field(18)
    public Pointer<Pixa> pixat() {
        return this.io.getPointerField(this, 18);
    }

    /**
     * templates for each class; bordered<br>
     * C type : Pixa*
     */
    @Field(18)
    public JbClasser pixat(Pointer<Pixa> pixat) {
        this.io.setPointerField(this, 18, pixat);
        return this;
    }

    /**
     * templates for each class; bordered<br>
     * C type : Pixa*
     */
    @Field(19)
    public Pointer<Pixa> pixatd() {
        return this.io.getPointerField(this, 19);
    }

    /**
     * templates for each class; bordered<br>
     * C type : Pixa*
     */
    @Field(19)
    public JbClasser pixatd(Pointer<Pixa> pixatd) {
        this.io.setPointerField(this, 19, pixatd);
        return this;
    }

    /**
     * Hash table to find templates by size<br>
     * C type : NumaHash*
     */
    @Field(20)
    public Pointer<NumaHash> nahash() {
        return this.io.getPointerField(this, 20);
    }

    /**
     * Hash table to find templates by size<br>
     * C type : NumaHash*
     */
    @Field(20)
    public JbClasser nahash(Pointer<NumaHash> nahash) {
        this.io.setPointerField(this, 20, nahash);
        return this;
    }

    /**
     * fg areas of undilated templates;<br>
     * C type : Numa*
     */
    @Field(21)
    public Pointer<Numa> nafgt() {
        return this.io.getPointerField(this, 21);
    }

    /**
     * fg areas of undilated templates;<br>
     * C type : Numa*
     */
    @Field(21)
    public JbClasser nafgt(Pointer<Numa> nafgt) {
        this.io.setPointerField(this, 21, nafgt);
        return this;
    }

    /**
     * centroids of all bordered cc<br>
     * C type : Pta*
     */
    @Field(22)
    public Pointer<Pta> ptac() {
        return this.io.getPointerField(this, 22);
    }

    /**
     * centroids of all bordered cc<br>
     * C type : Pta*
     */
    @Field(22)
    public JbClasser ptac(Pointer<Pta> ptac) {
        this.io.setPointerField(this, 22, ptac);
        return this;
    }

    /**
     * centroids of all bordered template cc<br>
     * C type : Pta*
     */
    @Field(23)
    public Pointer<Pta> ptact() {
        return this.io.getPointerField(this, 23);
    }

    /**
     * centroids of all bordered template cc<br>
     * C type : Pta*
     */
    @Field(23)
    public JbClasser ptact(Pointer<Pta> ptact) {
        this.io.setPointerField(this, 23, ptact);
        return this;
    }

    /**
     * array of class ids for each component<br>
     * C type : Numa*
     */
    @Field(24)
    public Pointer<Numa> naclass() {
        return this.io.getPointerField(this, 24);
    }

    /**
     * array of class ids for each component<br>
     * C type : Numa*
     */
    @Field(24)
    public JbClasser naclass(Pointer<Numa> naclass) {
        this.io.setPointerField(this, 24, naclass);
        return this;
    }

    /**
     * array of page nums for each component<br>
     * C type : Numa*
     */
    @Field(25)
    public Pointer<Numa> napage() {
        return this.io.getPointerField(this, 25);
    }

    /**
     * array of page nums for each component<br>
     * C type : Numa*
     */
    @Field(25)
    public JbClasser napage(Pointer<Numa> napage) {
        this.io.setPointerField(this, 25, napage);
        return this;
    }

    /**
     * array of UL corners at which the<br>
     * C type : Pta*
     */
    @Field(26)
    public Pointer<Pta> ptaul() {
        return this.io.getPointerField(this, 26);
    }

    /**
     * array of UL corners at which the<br>
     * C type : Pta*
     */
    @Field(26)
    public JbClasser ptaul(Pointer<Pta> ptaul) {
        this.io.setPointerField(this, 26, ptaul);
        return this;
    }

    /**
     * similar to ptaul, but for LL corners<br>
     * C type : Pta*
     */
    @Field(27)
    public Pointer<Pta> ptall() {
        return this.io.getPointerField(this, 27);
    }

    /**
     * similar to ptaul, but for LL corners<br>
     * C type : Pta*
     */
    @Field(27)
    public JbClasser ptall(Pointer<Pta> ptall) {
        this.io.setPointerField(this, 27, ptall);
        return this;
    }

    public JbClasser() {
        super();
    }

    public JbClasser(Pointer pointer) {
        super(pointer);
    }
}
