package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * list.h<br>
 * Cell for double-linked lists<br>
 * This allows composition of a list of cells with <br>
 * prev, next and data pointers. Generic data<br>
 * structures hang on the list cell data pointers.<br>
 * The list is not circular because that would add much<br>
 * complexity in traversing the list under general<br>
 * conditions where list cells can be added and removed.<br>
 * The only disadvantage of not having the head point to<br>
 * the last cell is that the list must be traversed to<br>
 * find its tail. However, this traversal is fast, and<br>
 * the listRemoveFromTail() function updates the tail<br>
 * so there is no searching overhead with repeated use.<br>
 * The list macros are used to run through a list, and their<br>
 * use is encouraged. They are invoked, e.g., as<br>
 * DLLIST *head, *elem;<br>
 * ...<br>
 * L_BEGIN_LIST_FORWARD(head, elem)<br>
 * <do something with elem and/or elem->data ><br>
 * L_END_LIST<br>
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\list.h:60</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class DoubleLinkedList extends StructObject {
    static {
        BridJ.register();
    }

    /** C type : DoubleLinkedList* */
    @Field(0)
    public Pointer<DoubleLinkedList> prev() {
        return this.io.getPointerField(this, 0);
    }

    /** C type : DoubleLinkedList* */
    @Field(0)
    public DoubleLinkedList prev(Pointer<DoubleLinkedList> prev) {
        this.io.setPointerField(this, 0, prev);
        return this;
    }

    /** C type : DoubleLinkedList* */
    @Field(1)
    public Pointer<DoubleLinkedList> next() {
        return this.io.getPointerField(this, 1);
    }

    /** C type : DoubleLinkedList* */
    @Field(1)
    public DoubleLinkedList next(Pointer<DoubleLinkedList> next) {
        this.io.setPointerField(this, 1, next);
        return this;
    }

    /** C type : void* */
    @Field(2)
    public Pointer<?> data() {
        return this.io.getPointerField(this, 2);
    }

    /** C type : void* */
    @Field(2)
    public DoubleLinkedList data(Pointer<?> data) {
        this.io.setPointerField(this, 2, data);
        return this;
    }

    public DoubleLinkedList() {
        super();
    }

    public DoubleLinkedList(Pointer pointer) {
        super(pointer);
    }
}
