/*
 * Decompiled with CFR 0.152.
 */
package de.vorb.leptonica.util;

import de.vorb.leptonica.LibLept;
import de.vorb.leptonica.Pix;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import org.bridj.Pointer;

public class PixConversions {
    private PixConversions() {
    }

    public static Pointer<Pix> img2pix(BufferedImage img) {
        int spp;
        int depth;
        int width = img.getWidth();
        int height = img.getHeight();
        switch (img.getType()) {
            case 12: {
                depth = 1;
                spp = 1;
                break;
            }
            case 10: {
                depth = 8;
                spp = 1;
                break;
            }
            default: {
                ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
                BufferedImage gray = new BufferedImage(img.getWidth(), img.getHeight(), 10);
                op.filter(img, gray);
                img = gray;
                depth = 8;
                spp = 1;
            }
        }
        Pointer<Pix> ppix = LibLept.pixCreate(width, height, depth);
        LibLept.pixSetSpp(ppix, spp);
        int wpl = (width * depth + 31) / 32;
        LibLept.pixSetWpl(ppix, wpl);
        DataBufferByte dataBuf = (DataBufferByte)img.getData().getDataBuffer();
        ByteBuffer bytes = ByteBuffer.wrap(dataBuf.getData());
        Pointer<Integer> pixData = LibLept.pixGetData(ppix);
        PixConversions.setBytesToPix(pixData, bytes, width, height, depth, wpl);
        return ppix;
    }

    private static void setBytesToPix(Pointer<Integer> pixData, ByteBuffer bytes, int width, int height, int depth, int wpl) {
        switch (depth) {
            case 1: {
                boolean notMisaligned = width % 32 == 0;
                int misalignment = notMisaligned ? 0 : (width % 32 + 7) / 8;
                int bulkSize = notMisaligned ? wpl * 4 : (wpl - 1) * 4;
                byte[] bulk = new byte[bulkSize];
                int y = 0;
                while (y < height) {
                    bytes.get(bulk);
                    for (int b = 0; b < bulkSize; b += 4) {
                        byte b0 = bulk[b];
                        byte b1 = bulk[b + 1];
                        bulk[b] = ~bulk[b + 3];
                        bulk[b + 1] = ~bulk[b + 2];
                        bulk[b + 2] = ~b1;
                        bulk[b + 3] = ~b0;
                    }
                    pixData.setBytes(bulk);
                    if (!notMisaligned) {
                        Pointer lastIntOfLine = pixData.next((long)(bulkSize / 4));
                        for (int b = misalignment; b > 0; --b) {
                            lastIntOfLine.setByteAtIndex((long)b, ~bytes.get());
                        }
                    }
                    ++y;
                    pixData = pixData.next((long)wpl);
                }
                break;
            }
            case 8: {
                int bulkSize = wpl * 4;
                byte[] bulk = new byte[bulkSize];
                int y = 0;
                while (y < height) {
                    bytes.get(bulk);
                    for (int b = 0; b < bulkSize; b += 4) {
                        byte b0 = bulk[b];
                        byte b1 = bulk[b + 1];
                        bulk[b] = bulk[b + 3];
                        bulk[b + 1] = bulk[b + 2];
                        bulk[b + 2] = b1;
                        bulk[b + 3] = b0;
                    }
                    pixData.setBytes(bulk);
                    ++y;
                    pixData = pixData.next((long)wpl);
                }
                break;
            }
            default: {
                byte[] bulk = new byte[]{};
            }
        }
    }

    public static BufferedImage pix2img(Pointer<Pix> ppix) {
        ColorModel cm;
        Pix pix = (Pix)((Object)ppix.get());
        byte[] buf = PixConversions.convertPixToBytes(pix.data(), pix.w(), pix.h(), pix.d(), pix.wpl());
        DataBufferByte dataBuf = new DataBufferByte(buf, buf.length);
        WritableRaster raster = Raster.createPackedRaster(dataBuf, pix.w(), pix.h(), pix.d(), new Point(0, 0));
        switch (pix.d()) {
            case 1: {
                byte[] arr = new byte[]{-1, 0};
                cm = new IndexColorModel(1, 2, arr, arr, arr);
                break;
            }
            case 8: {
                ColorSpace cs = ColorSpace.getInstance(1003);
                int[] nBits = new int[]{8};
                cm = new ComponentColorModel(cs, nBits, false, true, 1, 3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Only binary and grayscale images allowed.");
            }
        }
        return new BufferedImage(cm, raster, false, new Hashtable());
    }

    private static byte[] convertPixToBytes(Pointer<Integer> pixData, int width, int height, int depth, int wpl) {
        int bufSize = wpl * height * 4;
        byte[] bufData = new byte[bufSize];
        ByteBuffer buf = ByteBuffer.wrap(bufData);
        boolean notMisaligned = width % 32 == 0;
        int misalignment = notMisaligned ? 0 : (width % 32 + 7) / 8;
        int bulkSize = notMisaligned ? wpl * 4 : (wpl - 1) * 4;
        int y = 0;
        while (y < height) {
            byte[] bulk = pixData.getBytes(bulkSize);
            for (int b = 0; b < bulkSize; b += 4) {
                byte b0 = bulk[b];
                byte b1 = bulk[b + 1];
                bulk[b] = bulk[b + 3];
                bulk[b + 1] = bulk[b + 2];
                bulk[b + 2] = b1;
                bulk[b + 3] = b0;
            }
            buf.put(bulk, 0, bulkSize);
            if (!notMisaligned) {
                byte[] lastIntOfLine = pixData.next((long)(wpl - 1)).getBytes(4);
                for (int b = misalignment; b > 0; --b) {
                    buf.put(lastIntOfLine[b]);
                }
            }
            ++y;
            pixData = pixData.next((long)wpl);
        }
        return bufData;
    }
}

