package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\array.h:78</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class Numa2d extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * number of rows allocated for ptr array<br>
     * C type : l_int32
     */
    @Field(0)
    public int nrows() {
        return this.io.getIntField(this, 0);
    }

    /**
     * number of rows allocated for ptr array<br>
     * C type : l_int32
     */
    @Field(0)
    public Numa2d nrows(int nrows) {
        this.io.setIntField(this, 0, nrows);
        return this;
    }

    /**
     * number of cols allocated for ptr array<br>
     * C type : l_int32
     */
    @Field(1)
    public int ncols() {
        return this.io.getIntField(this, 1);
    }

    /**
     * number of cols allocated for ptr array<br>
     * C type : l_int32
     */
    @Field(1)
    public Numa2d ncols(int ncols) {
        this.io.setIntField(this, 1, ncols);
        return this;
    }

    /**
     * initial size of each numa that is made<br>
     * C type : l_int32
     */
    @Field(2)
    public int initsize() {
        return this.io.getIntField(this, 2);
    }

    /**
     * initial size of each numa that is made<br>
     * C type : l_int32
     */
    @Field(2)
    public Numa2d initsize(int initsize) {
        this.io.setIntField(this, 2, initsize);
        return this;
    }

    /**
     * 2D array of Numa<br>
     * C type : Numa***
     */
    @Field(3)
    public Pointer<Pointer<Pointer<Numa>>> numa() {
        return this.io.getPointerField(this, 3);
    }

    /**
     * 2D array of Numa<br>
     * C type : Numa***
     */
    @Field(3)
    public Numa2d numa(Pointer<Pointer<Pointer<Numa>>> numa) {
        this.io.setPointerField(this, 3, numa);
        return this;
    }

    public Numa2d() {
        super();
    }

    public Numa2d(Pointer pointer) {
        super(pointer);
    }
}
