package de.vorb.leptonica;

import java.util.Collections;
import java.util.Iterator;

import org.bridj.BridJ;
import org.bridj.CRuntime;
import org.bridj.FlagSet;
import org.bridj.IntValuedEnum;
import org.bridj.LastError;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.ann.Library;
import org.bridj.ann.Name;
import org.bridj.ann.Ptr;
import org.bridj.ann.Runtime;
import org.bridj.util.DefaultParameterizedType;

/**
 * Wrapper for library <b>leptonica</b><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
@Runtime(CRuntime.class)
public class LibLept {
    static {
        BridJ.register();
    }

    public static final int L_NOT_FOUND = 0;
    public static final int L_FOUND = 1;
    /** Get the severity from the environment */
    public static final int L_SEVERITY_EXTERNAL = 0;
    /** Lowest severity: print all messages */
    public static final int L_SEVERITY_ALL = 1;
    /** Print debugging and higher messages */
    public static final int L_SEVERITY_DEBUG = 2;
    /** Print informational and higher messages */
    public static final int L_SEVERITY_INFO = 3;
    /** Print warning and higher messages */
    public static final int L_SEVERITY_WARNING = 4;
    /** Print error and higher messages */
    public static final int L_SEVERITY_ERROR = 5;
    /** Highest severity: print no messages */
    public static final int L_SEVERITY_NONE = 6;
    /** linear */
    public static final int L_LINEAR_INTERP = 1;
    /** quadratic */
    public static final int L_QUADRATIC_INTERP = 2;
    /** extended with same value */
    public static final int L_CONTINUED_BORDER = 1;
    /** extended with constant normal derivative */
    public static final int L_SLOPE_BORDER = 2;
    /** mirrored */
    public static final int L_MIRRORED_BORDER = 3;
    /** convert to integer */
    public static final int L_INTEGER_VALUE = 1;
    /** convert to float */
    public static final int L_FLOAT_VALUE = 2;
    /** null the pointer only */
    public static final int L_NO_COMPACTION = 1;
    /** compact the array */
    public static final int L_COMPACTION = 2;
    /** choose based on number of holes */
    public static final int L_AUTO_DOWNSHIFT = 0;
    /** downshifts min # of ptrs below insert */
    public static final int L_MIN_DOWNSHIFT = 1;
    /** downshifts all ptrs below insert */
    public static final int L_FULL_DOWNSHIFT = 2;
    /** ptr to L_Ptra; caller can inspect only */
    public static final int L_HANDLE_ONLY = 0;
    /** caller owns; destroy or save in L_Ptraa */
    public static final int L_REMOVE = 1;
    /** tab or space at beginning of line */
    public static final int SPLIT_ON_LEADING_WHITE = 1;
    /** newline with optional white space */
    public static final int SPLIT_ON_BLANK_LINE = 2;
    /** leading white space or newline */
    public static final int SPLIT_ON_BOTH = 3;
    public static final int CCB_LOCAL_COORDS = 1;
    public static final int CCB_GLOBAL_COORDS = 2;
    public static final int CCB_SAVE_ALL_PTS = 1;
    public static final int CCB_SAVE_TURNING_PTS = 2;

    /**
     * gplot.h<br>
     * Data structures and parameters for generating gnuplot files<br>
     * enum values<br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\gplot.h:39</i>
     */
    public enum GPLOT_STYLE implements IntValuedEnum<GPLOT_STYLE> {
        GPLOT_LINES(0),
        GPLOT_POINTS(1),
        GPLOT_IMPULSES(2),
        GPLOT_LINESPOINTS(3),
        GPLOT_DOTS(4);
        GPLOT_STYLE(long value) {
            this.value = value;
        }

        public final long value;

        public long value() {
            return this.value;
        }

        public Iterator<GPLOT_STYLE> iterator() {
            return Collections.singleton(this).iterator();
        }

        public static IntValuedEnum<GPLOT_STYLE> fromValue(int value) {
            return FlagSet.fromValue(value, values());
        }
    };

    /**
     * enum values<br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\gplot.h:48</i>
     */
    public enum GPLOT_OUTPUT implements IntValuedEnum<GPLOT_OUTPUT> {
        GPLOT_NONE(0),
        GPLOT_PNG(1),
        GPLOT_PS(2),
        GPLOT_EPS(3),
        GPLOT_X11(4),
        GPLOT_LATEX(5);
        GPLOT_OUTPUT(long value) {
            this.value = value;
        }

        public final long value;

        public long value() {
            return this.value;
        }

        public Iterator<GPLOT_OUTPUT> iterator() {
            return Collections.singleton(this).iterator();
        }

        public static IntValuedEnum<GPLOT_OUTPUT> fromValue(int value) {
            return FlagSet.fromValue(value, values());
        }
    };

    /**
     * enum values<br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\gplot.h:57</i>
     */
    public enum GPLOT_SCALING implements IntValuedEnum<GPLOT_SCALING> {
        /** default */
        GPLOT_LINEAR_SCALE(0),
        GPLOT_LOG_SCALE_X(1),
        GPLOT_LOG_SCALE_Y(2),
        GPLOT_LOG_SCALE_X_Y(3);
        GPLOT_SCALING(long value) {
            this.value = value;
        }

        public final long value;

        public long value() {
            return this.value;
        }

        public Iterator<GPLOT_SCALING> iterator() {
            return Collections.singleton(this).iterator();
        }

        public static IntValuedEnum<GPLOT_SCALING> fromValue(int value) {
            return FlagSet.fromValue(value, values());
        }
    };

    public static final int IFF_UNKNOWN = 0;
    public static final int IFF_BMP = 1;
    public static final int IFF_JFIF_JPEG = 2;
    public static final int IFF_PNG = 3;
    public static final int IFF_TIFF = 4;
    public static final int IFF_TIFF_PACKBITS = 5;
    public static final int IFF_TIFF_RLE = 6;
    public static final int IFF_TIFF_G3 = 7;
    public static final int IFF_TIFF_G4 = 8;
    public static final int IFF_TIFF_LZW = 9;
    public static final int IFF_TIFF_ZIP = 10;
    public static final int IFF_PNM = 11;
    public static final int IFF_PS = 12;
    public static final int IFF_GIF = 13;
    public static final int IFF_JP2 = 14;
    public static final int IFF_WEBP = 15;
    public static final int IFF_LPDF = 16;
    public static final int IFF_DEFAULT = 17;
    public static final int IFF_SPIX = 18;
    public static final int BMP_ID = 0x4d42;
    /** MM - for 'motorola' */
    public static final int TIFF_BIGEND_ID = 0x4d4d;
    /** II - for 'intel' */
    public static final int TIFF_LITTLEEND_ID = 0x4949;
    /** only want grayscale information */
    public static final int L_HINT_GRAY = 1;
    /** use dct encoding: 8 and 32 bpp, no cmap */
    public static final int L_JPEG_ENCODE = 1;
    /** use ccitt g4 fax encoding: 1 bpp */
    public static final int L_G4_ENCODE = 2;
    /** use flate encoding: any depth, cmap ok */
    public static final int L_FLATE_ENCODE = 3;
    /** use jp2k encoding: 8 and 32 bpp, no cmap */
    public static final int L_JP2K_ENCODE = 4;
    /** first image to be used */
    public static final int L_FIRST_IMAGE = 1;
    /** intermediate image; not first or last */
    public static final int L_NEXT_IMAGE = 2;
    /** last image to be used */
    public static final int L_LAST_IMAGE = 3;
    public static final int JB_RANKHAUS = 0;
    public static final int JB_CORRELATION = 1;
    public static final int JB_CONN_COMPS = 0;
    public static final int JB_CHARACTERS = 1;
    public static final int JB_WORDS = 2;
    public static final int SYMMETRIC_MORPH_BC = 0;
    public static final int ASYMMETRIC_MORPH_BC = 1;
    public static final int SEL_DONT_CARE = 0;
    public static final int SEL_HIT = 1;
    public static final int SEL_MISS = 2;
    public static final int L_RUN_OFF = 0;
    public static final int L_RUN_ON = 1;
    public static final int L_HORIZ = 1;
    public static final int L_VERT = 2;
    public static final int L_BOTH_DIRECTIONS = 3;
    public static final int L_MORPH_DILATE = 1;
    public static final int L_MORPH_ERODE = 2;
    public static final int L_MORPH_OPEN = 3;
    public static final int L_MORPH_CLOSE = 4;
    public static final int L_MORPH_HMT = 5;
    public static final int L_LINEAR_SCALE = 1;
    public static final int L_LOG_SCALE = 2;
    public static final int L_TOPHAT_WHITE = 0;
    public static final int L_TOPHAT_BLACK = 1;
    public static final int L_ARITH_ADD = 1;
    public static final int L_ARITH_SUBTRACT = 2;
    /** on numas only */
    public static final int L_ARITH_MULTIPLY = 3;
    /** on numas only */
    public static final int L_ARITH_DIVIDE = 4;
    /** on numas only */
    public static final int L_UNION = 5;
    /** on numas only */
    public static final int L_INTERSECTION = 6;
    /** on numas only */
    public static final int L_SUBTRACTION = 7;
    /** on numas only */
    public static final int L_EXCLUSIVE_OR = 8;
    /** useful in a downscaling "erosion" */
    public static final int L_CHOOSE_MIN = 1;
    /** useful in a downscaling "dilation" */
    public static final int L_CHOOSE_MAX = 2;
    /** useful in a downscaling contrast */
    public static final int L_CHOOSE_MAX_MIN_DIFF = 3;
    /** assume bg outside image */
    public static final int L_BOUNDARY_BG = 1;
    /** assume fg outside image */
    public static final int L_BOUNDARY_FG = 2;
    public static final int L_COMPARE_XOR = 1;
    public static final int L_COMPARE_SUBTRACT = 2;
    public static final int L_COMPARE_ABS_DIFF = 3;
    public static final int L_MAX_DIFF_FROM_AVERAGE_2 = 1;
    public static final int L_MAX_MIN_DIFF_FROM_2 = 2;
    public static final int L_MAX_DIFF = 3;
    public static final int COLOR_RED = 0;
    public static final int COLOR_GREEN = 1;
    public static final int COLOR_BLUE = 2;
    public static final int L_ALPHA_CHANNEL = 3;
    public static final int REMOVE_CMAP_TO_BINARY = 0;
    public static final int REMOVE_CMAP_TO_GRAYSCALE = 1;
    public static final int REMOVE_CMAP_TO_FULL_COLOR = 2;
    public static final int REMOVE_CMAP_WITH_ALPHA = 3;
    public static final int REMOVE_CMAP_BASED_ON_SRC = 4;
    /** stuff it in; no copy, clone or copy-clone */
    public static final int L_INSERT = 0;
    /** make/use a copy of the object */
    public static final int L_COPY = 1;
    /** make/use clone (ref count) of the object */
    public static final int L_CLONE = 2;
    /** make a new object and fill with with clones */
    public static final int L_COPY_CLONE = 3;
    /** use shell sort */
    public static final int L_SHELL_SORT = 1;
    /** use bin sort */
    public static final int L_BIN_SORT = 2;
    /** sort in increasing order */
    public static final int L_SORT_INCREASING = 1;
    /** sort in decreasing order */
    public static final int L_SORT_DECREASING = 2;
    /** sort box or c.c. by left edge location */
    public static final int L_SORT_BY_X = 1;
    /** sort box or c.c. by top edge location */
    public static final int L_SORT_BY_Y = 2;
    /** sort box or c.c. by right edge location */
    public static final int L_SORT_BY_RIGHT = 3;
    /** sort box or c.c. by bot edge location */
    public static final int L_SORT_BY_BOT = 4;
    /** sort box or c.c. by width */
    public static final int L_SORT_BY_WIDTH = 5;
    /** sort box or c.c. by height */
    public static final int L_SORT_BY_HEIGHT = 6;
    /** sort box or c.c. by min dimension */
    public static final int L_SORT_BY_MIN_DIMENSION = 7;
    /** sort box or c.c. by max dimension */
    public static final int L_SORT_BY_MAX_DIMENSION = 8;
    /** sort box or c.c. by perimeter */
    public static final int L_SORT_BY_PERIMETER = 9;
    /** sort box or c.c. by area */
    public static final int L_SORT_BY_AREA = 10;
    /** sort box or c.c. by width/height ratio */
    public static final int L_SORT_BY_ASPECT_RATIO = 11;
    /** add some of src inverse to itself */
    public static final int L_BLEND_WITH_INVERSE = 1;
    /** shift src colors towards white */
    public static final int L_BLEND_TO_WHITE = 2;
    /** shift src colors towards black */
    public static final int L_BLEND_TO_BLACK = 3;
    /** blend src directly with blender */
    public static final int L_BLEND_GRAY = 4;
    /** add amount of src inverse to itself, */
    public static final int L_BLEND_GRAY_WITH_INVERSE = 5;
    /** colorize non-black pixels */
    public static final int L_PAINT_LIGHT = 1;
    /** colorize non-white pixels */
    public static final int L_PAINT_DARK = 2;
    /** set all bits in each pixel to 1 */
    public static final int L_SET_PIXELS = 1;
    /** set all bits in each pixel to 0 */
    public static final int L_CLEAR_PIXELS = 2;
    /** flip all bits in each pixel */
    public static final int L_FLIP_PIXELS = 3;
    /** width must satisfy constraint */
    public static final int L_SELECT_WIDTH = 1;
    /** height must satisfy constraint */
    public static final int L_SELECT_HEIGHT = 2;
    /** either width or height can satisfy */
    public static final int L_SELECT_IF_EITHER = 3;
    /** both width and height must satisfy */
    public static final int L_SELECT_IF_BOTH = 4;
    /** save if value is less than threshold */
    public static final int L_SELECT_IF_LT = 1;
    /** save if value is more than threshold */
    public static final int L_SELECT_IF_GT = 2;
    /** save if value is <= to the threshold */
    public static final int L_SELECT_IF_LTE = 3;
    /** save if value is >= to the threshold */
    public static final int L_SELECT_IF_GTE = 4;
    /** use red component */
    public static final int L_SELECT_RED = 1;
    /** use green component */
    public static final int L_SELECT_GREEN = 2;
    /** use blue component */
    public static final int L_SELECT_BLUE = 3;
    /** use min color component */
    public static final int L_SELECT_MIN = 4;
    /** use max color component */
    public static final int L_SELECT_MAX = 5;
    /** use LSB */
    public static final int L_LS_BYTE = 0;
    /** use MSB */
    public static final int L_MS_BYTE = 1;
    /** use max(val, 255) */
    public static final int L_CLIP_TO_255 = 2;
    /** use area map rotation, if possible */
    public static final int L_ROTATE_AREA_MAP = 1;
    /** use shear rotation */
    public static final int L_ROTATE_SHEAR = 2;
    /** use sampling */
    public static final int L_ROTATE_SAMPLING = 3;
    /** bring in white pixels from the outside */
    public static final int L_BRING_IN_WHITE = 1;
    /** bring in black pixels from the outside */
    public static final int L_BRING_IN_BLACK = 2;
    /** shear image about UL corner */
    public static final int L_SHEAR_ABOUT_CORNER = 1;
    /** shear image about center */
    public static final int L_SHEAR_ABOUT_CENTER = 2;
    /** translate, scale, rotate */
    public static final int L_TR_SC_RO = 1;
    /** scale, rotate, translate */
    public static final int L_SC_RO_TR = 2;
    /** rotate, translate, scale */
    public static final int L_RO_TR_SC = 3;
    /** translate, rotate, scale */
    public static final int L_TR_RO_SC = 4;
    /** rotate, scale, translate */
    public static final int L_RO_SC_TR = 5;
    /** scale, translate, rotate */
    public static final int L_SC_TR_RO = 6;
    /** fill white pixels (e.g, in fg map) */
    public static final int L_FILL_WHITE = 1;
    /** fill black pixels (e.g., in bg map) */
    public static final int L_FILL_BLACK = 2;
    /** set pixels to white */
    public static final int L_SET_WHITE = 1;
    /** set pixels to black */
    public static final int L_SET_BLACK = 2;
    /** get white pixel value */
    public static final int L_GET_WHITE_VAL = 1;
    /** get black pixel value */
    public static final int L_GET_BLACK_VAL = 2;
    /** white pixels are 0xff or 0xffff; black are 0 */
    public static final int L_WHITE_IS_MAX = 1;
    /** black pixels are 0xff or 0xffff; white are 0 */
    public static final int L_BLACK_IS_MAX = 2;
    /** dist to black with no prop; 1 bpp */
    public static final int DEFAULT_CLIP_LOWER_1 = 10;
    /** dist to black with no prop; 1 bpp */
    public static final int DEFAULT_CLIP_UPPER_1 = 10;
    /** dist to black with no prop; 2 bpp */
    public static final int DEFAULT_CLIP_LOWER_2 = 5;
    /** dist to black with no prop; 2 bpp */
    public static final int DEFAULT_CLIP_UPPER_2 = 5;
    /** L1 distance (e.g., in color space) */
    public static final int L_MANHATTAN_DISTANCE = 1;
    /** L2 distance */
    public static final int L_EUCLIDEAN_DISTANCE = 2;
    /** average of abs values */
    public static final int L_MEAN_ABSVAL = 1;
    /** median value of set */
    public static final int L_MEDIAN_VAL = 2;
    /** mode value of set */
    public static final int L_MODE_VAL = 3;
    /** mode count of set */
    public static final int L_MODE_COUNT = 4;
    /** rms of values */
    public static final int L_ROOT_MEAN_SQUARE = 5;
    /** standard deviation from mean */
    public static final int L_STANDARD_DEVIATION = 6;
    /** variance of values */
    public static final int L_VARIANCE = 7;
    /** select 'n' consecutive */
    public static final int L_CHOOSE_CONSECUTIVE = 1;
    /** select at intervals of 'n' */
    public static final int L_CHOOSE_SKIP_BY = 2;
    /** low confidence on text orientation */
    public static final int L_TEXT_ORIENT_UNKNOWN = 0;
    /** portrait, text rightside-up */
    public static final int L_TEXT_ORIENT_UP = 1;
    /** landscape, text up to left */
    public static final int L_TEXT_ORIENT_LEFT = 2;
    /** portrait, text upside-down */
    public static final int L_TEXT_ORIENT_DOWN = 3;
    /** landscape, text up to right */
    public static final int L_TEXT_ORIENT_RIGHT = 4;
    /** filters for horizontal edges */
    public static final int L_HORIZONTAL_EDGES = 0;
    /** filters for vertical edges */
    public static final int L_VERTICAL_EDGES = 1;
    /** filters for all edges */
    public static final int L_ALL_EDGES = 2;
    /** horizontal line */
    public static final int L_HORIZONTAL_LINE = 0;
    /** 45 degree line with positive slope */
    public static final int L_POS_SLOPE_LINE = 1;
    /** vertical line */
    public static final int L_VERTICAL_LINE = 2;
    /** 45 degree line with negative slope */
    public static final int L_NEG_SLOPE_LINE = 3;
    /** neither horizontal nor vertical */
    public static final int L_OBLIQUE_LINE = 4;
    /** scan from left */
    public static final int L_FROM_LEFT = 0;
    /** scan from right */
    public static final int L_FROM_RIGHT = 1;
    /** scan from top */
    public static final int L_FROM_TOP = 2;
    /** scan from bottom */
    public static final int L_FROM_BOT = 3;
    /** scan in negative direction */
    public static final int L_SCAN_NEGATIVE = 4;
    /** scan in positive direction */
    public static final int L_SCAN_POSITIVE = 5;
    /** scan in both directions */
    public static final int L_SCAN_BOTH = 6;
    /** do not adjust */
    public static final int L_ADJUST_SKIP = 0;
    /** adjust left edge */
    public static final int L_ADJUST_LEFT = 1;
    /** adjust right edge */
    public static final int L_ADJUST_RIGHT = 2;
    /** adjust both left and right edges */
    public static final int L_ADJUST_LEFT_AND_RIGHT = 3;
    /** adjust top edge */
    public static final int L_ADJUST_TOP = 4;
    /** adjust bottom edge */
    public static final int L_ADJUST_BOT = 5;
    /** adjust both top and bottom edges */
    public static final int L_ADJUST_TOP_AND_BOT = 6;
    /** choose the min median value */
    public static final int L_ADJUST_CHOOSE_MIN = 7;
    /** choose the max median value */
    public static final int L_ADJUST_CHOOSE_MAX = 8;
    /** set left side to a given value */
    public static final int L_SET_LEFT = 9;
    /** set right side to a given value */
    public static final int L_SET_RIGHT = 10;
    /** set top side to a given value */
    public static final int L_SET_TOP = 11;
    /** set bottom side to a given value */
    public static final int L_SET_BOT = 12;
    /** get left side location */
    public static final int L_GET_LEFT = 13;
    /** get right side location */
    public static final int L_GET_RIGHT = 14;
    /** get top side location */
    public static final int L_GET_TOP = 15;
    /** get bottom side location */
    public static final int L_GET_BOT = 16;
    /** resize to bounding region; remove smaller */
    public static final int L_COMBINE = 1;
    /** only remove smaller */
    public static final int L_REMOVE_SMALL = 2;
    /** increasing stretch or contraction to left */
    public static final int L_WARP_TO_LEFT = 1;
    /** increasing stretch or contraction to right */
    public static final int L_WARP_TO_RIGHT = 2;
    /** stretch or contraction grows linearly */
    public static final int L_LINEAR_WARP = 1;
    /** stretch or contraction grows quadratically */
    public static final int L_QUADRATIC_WARP = 2;
    /** linear interpolation from src pixels */
    public static final int L_INTERPOLATED = 1;
    /** nearest src pixel sampling only */
    public static final int L_SAMPLED = 2;
    /** thin foreground of 1 bpp image */
    public static final int L_THIN_FG = 1;
    /** thin background of 1 bpp image */
    public static final int L_THIN_BG = 2;
    /** determine runlengths of horizontal runs */
    public static final int L_HORIZONTAL_RUNS = 0;
    /** determine runlengths of vertical runs */
    public static final int L_VERTICAL_RUNS = 1;
    /** Sobel edge filter */
    public static final int L_SOBEL_EDGE = 1;
    /** Two-sided edge filter */
    public static final int L_TWO_SIDED_EDGE = 2;
    /** Clip negative values to 0 */
    public static final int L_CLIP_TO_ZERO = 1;
    /** Convert to positive using L_ABS() */
    public static final int L_TAKE_ABSVAL = 2;
    /** sensor order left-to-right RGB */
    public static final int L_SUBPIXEL_ORDER_RGB = 1;
    /** sensor order left-to-right BGR */
    public static final int L_SUBPIXEL_ORDER_BGR = 2;
    /** sensor order top-to-bottom RGB */
    public static final int L_SUBPIXEL_ORDER_VRGB = 3;
    /** sensor order top-to-bottom BGR */
    public static final int L_SUBPIXEL_ORDER_VBGR = 4;
    /** Choose values less than zero */
    public static final int L_LESS_THAN_ZERO = 1;
    /** Choose values equal to zero */
    public static final int L_EQUAL_TO_ZERO = 2;
    /** Choose values greater than zero */
    public static final int L_GREATER_THAN_ZERO = 3;
    /** Use hue-saturation histogram */
    public static final int L_HS_HISTO = 1;
    /** Use hue-value histogram */
    public static final int L_HV_HISTO = 2;
    /** Use saturation-value histogram */
    public static final int L_SV_HISTO = 3;
    /** Use hue-saturation histogram */
    public static final int L_INCLUDE_REGION = 1;
    /** Use hue-value histogram */
    public static final int L_EXCLUDE_REGION = 2;
    /** Add text above the image */
    public static final int L_ADD_ABOVE = 1;
    /** Add text below the image */
    public static final int L_ADD_BELOW = 2;
    /** Add text to the left of the image */
    public static final int L_ADD_LEFT = 3;
    /** Add text to the right of the image */
    public static final int L_ADD_RIGHT = 4;
    /** Add text over the top of the image */
    public static final int L_ADD_AT_TOP = 5;
    /** Add text over the bottom of the image */
    public static final int L_ADD_AT_BOT = 6;
    /** Add text over left side of the image */
    public static final int L_ADD_AT_LEFT = 7;
    /** Add text over right side of the image */
    public static final int L_ADD_AT_RIGHT = 8;
    /** Use xzgv with pixDisplay() */
    public static final int L_DISPLAY_WITH_XZGV = 1;
    /** Use xli with pixDisplay() */
    public static final int L_DISPLAY_WITH_XLI = 2;
    /** Use xv with pixDisplay() */
    public static final int L_DISPLAY_WITH_XV = 3;
    /** Use irfvanview (win) with pixDisplay() */
    public static final int L_DISPLAY_WITH_IV = 4;
    /** Use open (apple) with pixDisplay() */
    public static final int L_DISPLAY_WITH_OPEN = 5;
    /** Write full resolution chroma */
    public static final int L_NO_CHROMA_SAMPLING_JPEG = 1;
    /** select the unscaled bitmaps */
    public static final int L_SELECT_UNSCALED = 0;
    /** select the scaled bitmaps */
    public static final int L_SELECT_SCALED = 1;
    /** select both unscaled and scaled */
    public static final int L_SELECT_BOTH = 2;
    /** form template from class average */
    public static final int L_USE_AVERAGE = 0;
    /** match against all elements of each class */
    public static final int L_USE_ALL = 1;
    /** character set type is not specified */
    public static final int L_UNKNOWN = 0;
    /** 10 digits */
    public static final int L_ARABIC_NUMERALS = 1;
    /** 7 lower-case letters (i,v,x,l,c,d,m) */
    public static final int L_LC_ROMAN_NUMERALS = 2;
    /** 7 upper-case letters (I,V,X,L,C,D,M) */
    public static final int L_UC_ROMAN_NUMERALS = 3;
    /** 26 lower-case letters */
    public static final int L_LC_ALPHA = 4;
    /** 26 upper-case letters */
    public static final int L_UC_ALPHA = 5;
    public static final int L_REG_GENERATE = 0;
    public static final int L_REG_COMPARE = 1;
    public static final int L_REG_DISPLAY = 2;
    public static final int L_SUDOKU_INIT = 0;
    public static final int L_SUDOKU_STATE = 1;
    /**
     * -------------------------------------------------------------------------
     * *<br>
     * Standard size of border added around images for special processing *<br>
     * -------------------------------------------------------------------------<br>
     * pixels, not bits
     */
    public static final int ADDED_BORDER = 32;
    public static final int L_RED_SHIFT = 8 * (4 - 1 - (int) (LibLept.COLOR_RED));
    public static final int L_GREEN_SHIFT = 8 * (4 - 1 - (int) (LibLept.COLOR_GREEN));
    public static final int L_BLUE_SHIFT = 8 * (4 - 1 - (int) (LibLept.COLOR_BLUE));
    public static final int L_ALPHA_SHIFT = 8 * (4 - 1 - (int) (LibLept.L_ALPHA_CHANNEL));
    /**
     * Notes:<br>
     * (1) These numbers are ad-hoc, but they do add up to 1.<br>
     * Unlike, for example, the weighting factor for conversion<br>
     * of RGB to luminance, or more specifically to Y in the<br>
     * YUV colorspace. Those numbers come from the<br>
     * International Telecommunications Union, via ITU-R.
     */
    public static final float L_RED_WEIGHT = 0.3f;
    public static final float L_GREEN_WEIGHT = 0.5f;
    public static final float L_BLUE_WEIGHT = 0.2f;
    /** copyflag value in sarrayGetString() */
    public static final int L_NOCOPY = 0;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int PIX_DST = (int) (0xa << 1);
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int HAVE_FMEMOPEN = (int) 0;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int PIX_XOR = (int) ((0xc << 1) ^ (0xa << 1));
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int HAVE_LIBZ = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\jbclass.h</i>
     */
    public static final String JB_DATA_EXT = (String) ".data";
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\gplot.h</i>
     */
    public static final int NUM_GPLOT_STYLES = (int) 5;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int PIXA_VERSION_NUMBER = (int) 2;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int HAVE_LIBJPEG = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int USE_BMPIO = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int USE_JP2KIO = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int PIX_PAINT = (int) ((0xc << 1) | (0xa << 1));
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h</i>
     */
    public static final int LIBLEPT_MINOR_VERSION = (int) 70;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int NULL = (int) 0;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\morph.h</i>
     */
    public static final int SEL_VERSION_NUMBER = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int HAVE_LIBPNG = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\recog.h</i>
     */
    public static final int RECOG_VERSION_NUMBER = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int PIX_SET = (int) (0xf << 1);
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\gplot.h</i>
     */
    public static final int NUM_GPLOT_OUTPUTS = (int) 6;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int USE_PSIO = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\array.h</i>
     */
    public static final int NUMA_VERSION_NUMBER = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\gplot.h</i>
     */
    public static final int GPLOT_VERSION_NUMBER = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int FALSE = (int) 0;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int BOXAA_VERSION_NUMBER = (int) 3;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int USE_PDFIO = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\array.h</i>
     */
    public static final int SARRAY_VERSION_NUMBER = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\dewarp.h</i>
     */
    public static final int DEWARP_VERSION_NUMBER = (int) 3;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int HAVE_LIBTIFF = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\jbclass.h</i>
     */
    public static final String JB_TEMPLATE_EXT = (String) ".templates.png";
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int PIXAA_VERSION_NUMBER = (int) 2;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int PIXACOMP_VERSION_NUMBER = (int) 2;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int UNDEF = (int) -1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int HAVE_LIBGIF = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int PIX_MASK = (int) ((0xc << 1) & (0xa << 1));
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int PIX_SUBTRACT = (int) ((0xa << 1) & ((0xc << 1) ^ 0x1e));
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int USE_PNMIO = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int PIX_SRC = (int) (0xc << 1);
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int DPIX_VERSION_NUMBER = (int) 2;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\array.h</i>
     */
    public static final int DNA_VERSION_NUMBER = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int PTA_VERSION_NUMBER = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int TRUE = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\morph.h</i>
     */
    public static final int KERNEL_VERSION_NUMBER = (int) 2;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int HAVE_LIBWEBP = (int) 0;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int PIX_CLR = (int) (0x0 << 1);
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h</i>
     */
    public static final int LIBLEPT_MAJOR_VERSION = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\environ.h</i>
     */
    public static final int HAVE_LIBUNGIF = (int) 0;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int BOXA_VERSION_NUMBER = (int) 2;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\arrayaccess.h</i>
     */
    public static final int USE_INLINE_ACCESSORS = (int) 1;
    /**
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\pix.h</i>
     */
    public static final int FPIX_VERSION_NUMBER = (int) 2;

    /**
     * Original signature :
     * <code>PIX* pixBackgroundNormSimple(PIX*, PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:41</i>
     */
    public static Pointer<Pix> pixBackgroundNormSimple(Pointer<Pix> pixs,
            Pointer<Pix> pixim, Pointer<Pix> pixg) {
        return (Pointer) Pointer.pointerToAddress(
                pixBackgroundNormSimple(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixim), Pointer.getPeer(pixg)),
                Pix.class);
    }

    @Ptr
    protected native static long pixBackgroundNormSimple(@Ptr long pixs,
            @Ptr long pixim, @Ptr long pixg);

    /**
     * Original signature :
     * <code>PIX* pixBackgroundNorm(PIX*, PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:42</i>
     */
    public static Pointer<Pix> pixBackgroundNorm(Pointer<Pix> pixs,
            Pointer<Pix> pixim, Pointer<Pix> pixg, int sx, int sy, int thresh,
            int mincount, int bgval, int smoothx, int smoothy) {
        return (Pointer) Pointer.pointerToAddress(
                pixBackgroundNorm(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixim), Pointer.getPeer(pixg), sx, sy,
                        thresh, mincount, bgval, smoothx, smoothy), Pix.class);
    }

    @Ptr
    protected native static long pixBackgroundNorm(@Ptr long pixs,
            @Ptr long pixim, @Ptr long pixg, int sx, int sy, int thresh,
            int mincount, int bgval, int smoothx, int smoothy);

    /**
     * Original signature :
     * <code>PIX* pixBackgroundNormMorph(PIX*, PIX*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:43</i>
     */
    public static Pointer<Pix> pixBackgroundNormMorph(Pointer<Pix> pixs,
            Pointer<Pix> pixim, int reduction, int size, int bgval) {
        return (Pointer) Pointer.pointerToAddress(
                pixBackgroundNormMorph(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixim), reduction, size, bgval),
                Pix.class);
    }

    @Ptr
    protected native static long pixBackgroundNormMorph(@Ptr long pixs,
            @Ptr long pixim, int reduction, int size, int bgval);

    /**
     * Original signature :
     * <code>l_int32 pixBackgroundNormGrayArray(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:44</i>
     */
    public static int pixBackgroundNormGrayArray(Pointer<Pix> pixs,
            Pointer<Pix> pixim, int sx, int sy, int thresh, int mincount,
            int bgval, int smoothx, int smoothy, Pointer<Pointer<Pix>> ppixd) {
        return pixBackgroundNormGrayArray(Pointer.getPeer(pixs),
                Pointer.getPeer(pixim), sx, sy, thresh, mincount, bgval,
                smoothx, smoothy, Pointer.getPeer(ppixd));
    }

    protected native static int pixBackgroundNormGrayArray(@Ptr long pixs,
            @Ptr long pixim, int sx, int sy, int thresh, int mincount,
            int bgval, int smoothx, int smoothy, @Ptr long ppixd);

    /**
     * Original signature :
     * <code>l_int32 pixBackgroundNormRGBArrays(PIX*, PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, PIX**, PIX**, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:45</i>
     */
    public static int pixBackgroundNormRGBArrays(Pointer<Pix> pixs,
            Pointer<Pix> pixim, Pointer<Pix> pixg, int sx, int sy, int thresh,
            int mincount, int bgval, int smoothx, int smoothy,
            Pointer<Pointer<Pix>> ppixr, Pointer<Pointer<Pix>> ppixg,
            Pointer<Pointer<Pix>> ppixb) {
        return pixBackgroundNormRGBArrays(Pointer.getPeer(pixs),
                Pointer.getPeer(pixim), Pointer.getPeer(pixg), sx, sy, thresh,
                mincount, bgval, smoothx, smoothy, Pointer.getPeer(ppixr),
                Pointer.getPeer(ppixg), Pointer.getPeer(ppixb));
    }

    protected native static int pixBackgroundNormRGBArrays(@Ptr long pixs,
            @Ptr long pixim, @Ptr long pixg, int sx, int sy, int thresh,
            int mincount, int bgval, int smoothx, int smoothy, @Ptr long ppixr,
            @Ptr long ppixg, @Ptr long ppixb);

    /**
     * Original signature :
     * <code>l_int32 pixBackgroundNormGrayArrayMorph(PIX*, PIX*, l_int32, l_int32, l_int32, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:46</i>
     */
    public static int pixBackgroundNormGrayArrayMorph(Pointer<Pix> pixs,
            Pointer<Pix> pixim, int reduction, int size, int bgval,
            Pointer<Pointer<Pix>> ppixd) {
        return pixBackgroundNormGrayArrayMorph(Pointer.getPeer(pixs),
                Pointer.getPeer(pixim), reduction, size, bgval,
                Pointer.getPeer(ppixd));
    }

    protected native static int pixBackgroundNormGrayArrayMorph(@Ptr long pixs,
            @Ptr long pixim, int reduction, int size, int bgval, @Ptr long ppixd);

    /**
     * Original signature :
     * <code>l_int32 pixBackgroundNormRGBArraysMorph(PIX*, PIX*, l_int32, l_int32, l_int32, PIX**, PIX**, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:47</i>
     */
    public static int pixBackgroundNormRGBArraysMorph(Pointer<Pix> pixs,
            Pointer<Pix> pixim, int reduction, int size, int bgval,
            Pointer<Pointer<Pix>> ppixr, Pointer<Pointer<Pix>> ppixg,
            Pointer<Pointer<Pix>> ppixb) {
        return pixBackgroundNormRGBArraysMorph(Pointer.getPeer(pixs),
                Pointer.getPeer(pixim), reduction, size, bgval,
                Pointer.getPeer(ppixr), Pointer.getPeer(ppixg),
                Pointer.getPeer(ppixb));
    }

    protected native static int pixBackgroundNormRGBArraysMorph(@Ptr long pixs,
            @Ptr long pixim, int reduction, int size, int bgval,
            @Ptr long ppixr, @Ptr long ppixg, @Ptr long ppixb);

    /**
     * Original signature :
     * <code>l_int32 pixGetBackgroundGrayMap(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:48</i>
     */
    public static int pixGetBackgroundGrayMap(Pointer<Pix> pixs,
            Pointer<Pix> pixim, int sx, int sy, int thresh, int mincount,
            Pointer<Pointer<Pix>> ppixd) {
        return pixGetBackgroundGrayMap(Pointer.getPeer(pixs),
                Pointer.getPeer(pixim), sx, sy, thresh, mincount,
                Pointer.getPeer(ppixd));
    }

    protected native static int pixGetBackgroundGrayMap(@Ptr long pixs,
            @Ptr long pixim, int sx, int sy, int thresh, int mincount,
            @Ptr long ppixd);

    /**
     * Original signature :
     * <code>l_int32 pixGetBackgroundRGBMap(PIX*, PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, PIX**, PIX**, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:49</i>
     */
    public static int pixGetBackgroundRGBMap(Pointer<Pix> pixs,
            Pointer<Pix> pixim, Pointer<Pix> pixg, int sx, int sy, int thresh,
            int mincount, Pointer<Pointer<Pix>> ppixmr,
            Pointer<Pointer<Pix>> ppixmg, Pointer<Pointer<Pix>> ppixmb) {
        return pixGetBackgroundRGBMap(Pointer.getPeer(pixs),
                Pointer.getPeer(pixim), Pointer.getPeer(pixg), sx, sy, thresh,
                mincount, Pointer.getPeer(ppixmr), Pointer.getPeer(ppixmg),
                Pointer.getPeer(ppixmb));
    }

    protected native static int pixGetBackgroundRGBMap(@Ptr long pixs,
            @Ptr long pixim, @Ptr long pixg, int sx, int sy, int thresh,
            int mincount, @Ptr long ppixmr, @Ptr long ppixmg, @Ptr long ppixmb);

    /**
     * Original signature :
     * <code>l_int32 pixGetBackgroundGrayMapMorph(PIX*, PIX*, l_int32, l_int32, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:50</i>
     */
    public static int pixGetBackgroundGrayMapMorph(Pointer<Pix> pixs,
            Pointer<Pix> pixim, int reduction, int size,
            Pointer<Pointer<Pix>> ppixm) {
        return pixGetBackgroundGrayMapMorph(Pointer.getPeer(pixs),
                Pointer.getPeer(pixim), reduction, size, Pointer.getPeer(ppixm));
    }

    protected native static int pixGetBackgroundGrayMapMorph(@Ptr long pixs,
            @Ptr long pixim, int reduction, int size, @Ptr long ppixm);

    /**
     * Original signature :
     * <code>l_int32 pixGetBackgroundRGBMapMorph(PIX*, PIX*, l_int32, l_int32, PIX**, PIX**, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:51</i>
     */
    public static int pixGetBackgroundRGBMapMorph(Pointer<Pix> pixs,
            Pointer<Pix> pixim, int reduction, int size,
            Pointer<Pointer<Pix>> ppixmr, Pointer<Pointer<Pix>> ppixmg,
            Pointer<Pointer<Pix>> ppixmb) {
        return pixGetBackgroundRGBMapMorph(Pointer.getPeer(pixs),
                Pointer.getPeer(pixim), reduction, size,
                Pointer.getPeer(ppixmr), Pointer.getPeer(ppixmg),
                Pointer.getPeer(ppixmb));
    }

    protected native static int pixGetBackgroundRGBMapMorph(@Ptr long pixs,
            @Ptr long pixim, int reduction, int size, @Ptr long ppixmr,
            @Ptr long ppixmg, @Ptr long ppixmb);

    /**
     * Original signature :
     * <code>l_int32 pixFillMapHoles(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:52</i>
     */
    public static int pixFillMapHoles(Pointer<Pix> pix, int nx, int ny,
            int filltype) {
        return pixFillMapHoles(Pointer.getPeer(pix), nx, ny, filltype);
    }

    protected native static int pixFillMapHoles(@Ptr long pix, int nx, int ny,
            int filltype);

    /**
     * Original signature :
     * <code>PIX* pixExtendByReplication(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:53</i>
     */
    public static Pointer<Pix> pixExtendByReplication(Pointer<Pix> pixs,
            int addw, int addh) {
        return Pointer.pointerToAddress(
                pixExtendByReplication(Pointer.getPeer(pixs), addw, addh),
                Pix.class);
    }

    @Ptr
    protected native static long pixExtendByReplication(@Ptr long pixs,
            int addw, int addh);

    /**
     * Original signature :
     * <code>l_int32 pixSmoothConnectedRegions(PIX*, PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:54</i>
     */
    public static int pixSmoothConnectedRegions(Pointer<Pix> pixs,
            Pointer<Pix> pixm, int factor) {
        return pixSmoothConnectedRegions(Pointer.getPeer(pixs),
                Pointer.getPeer(pixm), factor);
    }

    protected native static int pixSmoothConnectedRegions(@Ptr long pixs,
            @Ptr long pixm, int factor);

    /**
     * Original signature :
     * <code>PIX* pixGetInvBackgroundMap(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:55</i>
     */
    public static Pointer<Pix> pixGetInvBackgroundMap(Pointer<Pix> pixs,
            int bgval, int smoothx, int smoothy) {
        return Pointer.pointerToAddress(
                pixGetInvBackgroundMap(Pointer.getPeer(pixs), bgval, smoothx,
                        smoothy), Pix.class);
    }

    @Ptr
    protected native static long pixGetInvBackgroundMap(@Ptr long pixs,
            int bgval, int smoothx, int smoothy);

    /**
     * Original signature :
     * <code>PIX* pixApplyInvBackgroundGrayMap(PIX*, PIX*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:56</i>
     */
    public static Pointer<Pix> pixApplyInvBackgroundGrayMap(Pointer<Pix> pixs,
            Pointer<Pix> pixm, int sx, int sy) {
        return Pointer.pointerToAddress(
                pixApplyInvBackgroundGrayMap(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixm), sx, sy), Pix.class);
    }

    @Ptr
    protected native static long pixApplyInvBackgroundGrayMap(@Ptr long pixs,
            @Ptr long pixm, int sx, int sy);

    /**
     * Original signature :
     * <code>PIX* pixApplyInvBackgroundRGBMap(PIX*, PIX*, PIX*, PIX*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:57</i>
     */
    public static Pointer<Pix> pixApplyInvBackgroundRGBMap(Pointer<Pix> pixs,
            Pointer<Pix> pixmr, Pointer<Pix> pixmg, Pointer<Pix> pixmb, int sx,
            int sy) {
        return Pointer.pointerToAddress(
                pixApplyInvBackgroundRGBMap(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixmr), Pointer.getPeer(pixmg),
                        Pointer.getPeer(pixmb), sx, sy), Pix.class);
    }

    @Ptr
    protected native static long pixApplyInvBackgroundRGBMap(@Ptr long pixs,
            @Ptr long pixmr, @Ptr long pixmg, @Ptr long pixmb, int sx, int sy);

    /**
     * Original signature :
     * <code>PIX* pixApplyVariableGrayMap(PIX*, PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:58</i>
     */
    public static Pointer<Pix> pixApplyVariableGrayMap(Pointer<Pix> pixs,
            Pointer<Pix> pixg, int target) {
        return Pointer.pointerToAddress(
                pixApplyVariableGrayMap(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixg), target), Pix.class);
    }

    @Ptr
    protected native static long pixApplyVariableGrayMap(@Ptr long pixs,
            @Ptr long pixg, int target);

    /**
     * Original signature :
     * <code>PIX* pixGlobalNormRGB(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:59</i>
     */
    public static Pointer<Pix> pixGlobalNormRGB(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int rval, int gval, int bval, int mapval) {
        return Pointer.pointerToAddress(
                pixGlobalNormRGB(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        rval, gval, bval, mapval), Pix.class);
    }

    @Ptr
    protected native static long pixGlobalNormRGB(@Ptr long pixd,
            @Ptr long pixs, int rval, int gval, int bval, int mapval);

    /**
     * Original signature :
     * <code>PIX* pixGlobalNormNoSatRGB(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:60</i>
     */
    public static Pointer<Pix> pixGlobalNormNoSatRGB(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int rval, int gval, int bval, int factor,
            float rank) {
        return Pointer.pointerToAddress(
                pixGlobalNormNoSatRGB(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), rval, gval, bval, factor, rank),
                Pix.class);
    }

    @Ptr
    protected native static long pixGlobalNormNoSatRGB(@Ptr long pixd,
            @Ptr long pixs, int rval, int gval, int bval, int factor, float rank);

    /**
     * Original signature :
     * <code>l_int32 pixThresholdSpreadNorm(PIX*, l_int32, l_int32, l_int32, l_int32, l_float32, l_int32, l_int32, l_int32, PIX**, PIX**, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:61</i>
     */
    public static int pixThresholdSpreadNorm(Pointer<Pix> pixs, int filtertype,
            int edgethresh, int smoothx, int smoothy, float gamma, int minval,
            int maxval, int targetthresh, Pointer<Pointer<Pix>> ppixth,
            Pointer<Pointer<Pix>> ppixb, Pointer<Pointer<Pix>> ppixd) {
        return pixThresholdSpreadNorm(Pointer.getPeer(pixs), filtertype,
                edgethresh, smoothx, smoothy, gamma, minval, maxval,
                targetthresh, Pointer.getPeer(ppixth), Pointer.getPeer(ppixb),
                Pointer.getPeer(ppixd));
    }

    protected native static int pixThresholdSpreadNorm(@Ptr long pixs,
            int filtertype, int edgethresh, int smoothx, int smoothy,
            float gamma, int minval, int maxval, int targetthresh,
            @Ptr long ppixth, @Ptr long ppixb, @Ptr long ppixd);

    /**
     * Original signature :
     * <code>PIX* pixBackgroundNormFlex(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:62</i>
     */
    public static Pointer<Pix> pixBackgroundNormFlex(Pointer<Pix> pixs, int sx,
            int sy, int smoothx, int smoothy, int delta) {
        return Pointer.pointerToAddress(
                pixBackgroundNormFlex(Pointer.getPeer(pixs), sx, sy, smoothx,
                        smoothy, delta), Pix.class);
    }

    @Ptr
    protected native static long pixBackgroundNormFlex(@Ptr long pixs, int sx,
            int sy, int smoothx, int smoothy, int delta);

    /**
     * Original signature :
     * <code>PIX* pixContrastNorm(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:63</i>
     */
    public static Pointer<Pix> pixContrastNorm(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int sx, int sy, int mindiff, int smoothx,
            int smoothy) {
        return Pointer.pointerToAddress(
                pixContrastNorm(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        sx, sy, mindiff, smoothx, smoothy), Pix.class);
    }

    @Ptr
    protected native static long pixContrastNorm(@Ptr long pixd,
            @Ptr long pixs, int sx, int sy, int mindiff, int smoothx,
            int smoothy);

    /**
     * Original signature :
     * <code>l_int32 pixMinMaxTiles(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, PIX**, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:64</i>
     */
    public static int pixMinMaxTiles(Pointer<Pix> pixs, int sx, int sy,
            int mindiff, int smoothx, int smoothy,
            Pointer<Pointer<Pix>> ppixmin, Pointer<Pointer<Pix>> ppixmax) {
        return pixMinMaxTiles(Pointer.getPeer(pixs), sx, sy, mindiff, smoothx,
                smoothy, Pointer.getPeer(ppixmin), Pointer.getPeer(ppixmax));
    }

    protected native static int pixMinMaxTiles(@Ptr long pixs, int sx, int sy,
            int mindiff, int smoothx, int smoothy, @Ptr long ppixmin,
            @Ptr long ppixmax);

    /**
     * Original signature :
     * <code>l_int32 pixSetLowContrast(PIX*, PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:65</i>
     */
    public static int pixSetLowContrast(Pointer<Pix> pixs1, Pointer<Pix> pixs2,
            int mindiff) {
        return pixSetLowContrast(Pointer.getPeer(pixs1),
                Pointer.getPeer(pixs2), mindiff);
    }

    protected native static int pixSetLowContrast(@Ptr long pixs1,
            @Ptr long pixs2, int mindiff);

    /**
     * Original signature :
     * <code>PIX* pixLinearTRCTiled(PIX*, PIX*, l_int32, l_int32, PIX*, PIX*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:66</i>
     */
    public static Pointer<Pix> pixLinearTRCTiled(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int sx, int sy, Pointer<Pix> pixmin,
            Pointer<Pix> pixmax) {
        return (Pointer) Pointer.pointerToAddress(
                pixLinearTRCTiled(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        sx, sy, Pointer.getPeer(pixmin),
                        Pointer.getPeer(pixmax)), Pix.class);
    }

    @Ptr
    protected native static long pixLinearTRCTiled(@Ptr long pixd,
            @Ptr long pixs, int sx, int sy, @Ptr long pixmin, @Ptr long pixmax);

    /**
     * Original signature :
     * <code>PIX* pixAffineSampledPta(PIX*, PTA*, PTA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:67</i>
     */
    public static Pointer<Pix> pixAffineSampledPta(Pointer<Pix> pixs,
            Pointer<Pta> ptad, Pointer<Pta> ptas, int incolor) {
        return (Pointer) Pointer.pointerToAddress(
                pixAffineSampledPta(Pointer.getPeer(pixs),
                        Pointer.getPeer(ptad), Pointer.getPeer(ptas), incolor),
                Pix.class);
    }

    @Ptr
    protected native static long pixAffineSampledPta(@Ptr long pixs,
            @Ptr long ptad, @Ptr long ptas, int incolor);

    /**
     * Original signature :
     * <code>PIX* pixAffineSampled(PIX*, l_float32*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:68</i>
     */
    public static Pointer<Pix> pixAffineSampled(Pointer<Pix> pixs,
            Pointer<Float> vc, int incolor) {
        return (Pointer) Pointer.pointerToAddress(
                pixAffineSampled(Pointer.getPeer(pixs), Pointer.getPeer(vc),
                        incolor), Pix.class);
    }

    @Ptr
    protected native static long pixAffineSampled(@Ptr long pixs, @Ptr long vc,
            int incolor);

    /**
     * Original signature :
     * <code>PIX* pixAffinePta(PIX*, PTA*, PTA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:69</i>
     */
    public static Pointer<Pix> pixAffinePta(Pointer<Pix> pixs,
            Pointer<Pta> ptad, Pointer<Pta> ptas, int incolor) {
        return (Pointer) Pointer.pointerToAddress(
                pixAffinePta(Pointer.getPeer(pixs), Pointer.getPeer(ptad),
                        Pointer.getPeer(ptas), incolor), Pix.class);
    }

    @Ptr
    protected native static long pixAffinePta(@Ptr long pixs, @Ptr long ptad,
            @Ptr long ptas, int incolor);

    /**
     * Original signature :
     * <code>PIX* pixAffine(PIX*, l_float32*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:70</i>
     */
    public static Pointer<Pix> pixAffine(Pointer<Pix> pixs, Pointer<Float> vc,
            int incolor) {
        return (Pointer) Pointer.pointerToAddress(
                pixAffine(Pointer.getPeer(pixs), Pointer.getPeer(vc), incolor),
                Pix.class);
    }

    @Ptr
    protected native static long pixAffine(@Ptr long pixs, @Ptr long vc,
            int incolor);

    /**
     * Original signature :
     * <code>PIX* pixAffinePtaColor(PIX*, PTA*, PTA*, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:71</i>
     */
    public static Pointer<Pix> pixAffinePtaColor(Pointer<Pix> pixs,
            Pointer<Pta> ptad, Pointer<Pta> ptas, int colorval) {
        return (Pointer) Pointer.pointerToAddress(
                pixAffinePtaColor(Pointer.getPeer(pixs), Pointer.getPeer(ptad),
                        Pointer.getPeer(ptas), colorval), Pix.class);
    }

    @Ptr
    protected native static long pixAffinePtaColor(@Ptr long pixs,
            @Ptr long ptad, @Ptr long ptas, int colorval);

    /**
     * Original signature :
     * <code>PIX* pixAffineColor(PIX*, l_float32*, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:72</i>
     */
    public static Pointer<Pix> pixAffineColor(Pointer<Pix> pixs,
            Pointer<Float> vc, int colorval) {
        return (Pointer) Pointer.pointerToAddress(
                pixAffineColor(Pointer.getPeer(pixs), Pointer.getPeer(vc),
                        colorval), Pix.class);
    }

    @Ptr
    protected native static long pixAffineColor(@Ptr long pixs, @Ptr long vc,
            int colorval);

    /**
     * Original signature :
     * <code>PIX* pixAffinePtaGray(PIX*, PTA*, PTA*, l_uint8)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:73</i>
     */
    public static Pointer<Pix> pixAffinePtaGray(Pointer<Pix> pixs,
            Pointer<Pta> ptad, Pointer<Pta> ptas, byte grayval) {
        return (Pointer) Pointer.pointerToAddress(
                pixAffinePtaGray(Pointer.getPeer(pixs), Pointer.getPeer(ptad),
                        Pointer.getPeer(ptas), grayval), Pix.class);
    }

    @Ptr
    protected native static long pixAffinePtaGray(@Ptr long pixs,
            @Ptr long ptad, @Ptr long ptas, byte grayval);

    /**
     * Original signature :
     * <code>PIX* pixAffineGray(PIX*, l_float32*, l_uint8)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:74</i>
     */
    public static Pointer<Pix> pixAffineGray(Pointer<Pix> pixs,
            Pointer<Float> vc, byte grayval) {
        return (Pointer) Pointer.pointerToAddress(
                pixAffineGray(Pointer.getPeer(pixs), Pointer.getPeer(vc),
                        grayval), Pix.class);
    }

    @Ptr
    protected native static long pixAffineGray(@Ptr long pixs, @Ptr long vc,
            byte grayval);

    /**
     * Original signature :
     * <code>PIX* pixAffinePtaWithAlpha(PIX*, PTA*, PTA*, PIX*, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:75</i>
     */
    public static Pointer<Pix> pixAffinePtaWithAlpha(Pointer<Pix> pixs,
            Pointer<Pta> ptad, Pointer<Pta> ptas, Pointer<Pix> pixg,
            float fract, int border) {
        return (Pointer) Pointer.pointerToAddress(
                pixAffinePtaWithAlpha(Pointer.getPeer(pixs),
                        Pointer.getPeer(ptad), Pointer.getPeer(ptas),
                        Pointer.getPeer(pixg), fract, border), Pix.class);
    }

    @Ptr
    protected native static long pixAffinePtaWithAlpha(@Ptr long pixs,
            @Ptr long ptad, @Ptr long ptas, @Ptr long pixg, float fract,
            int border);

    /**
     * Original signature :
     * <code>l_int32 getAffineXformCoeffs(PTA*, PTA*, l_float32**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:76</i>
     */
    public static int getAffineXformCoeffs(Pointer<Pta> ptas,
            Pointer<Pta> ptad, Pointer<Pointer<Float>> pvc) {
        return getAffineXformCoeffs(Pointer.getPeer(ptas),
                Pointer.getPeer(ptad), Pointer.getPeer(pvc));
    }

    protected native static int getAffineXformCoeffs(@Ptr long ptas,
            @Ptr long ptad, @Ptr long pvc);

    /**
     * Original signature :
     * <code>l_int32 affineInvertXform(l_float32*, l_float32**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:77</i>
     */
    public static int affineInvertXform(Pointer<Float> vc,
            Pointer<Pointer<Float>> pvci) {
        return affineInvertXform(Pointer.getPeer(vc), Pointer.getPeer(pvci));
    }

    protected native static int affineInvertXform(@Ptr long vc, @Ptr long pvci) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 affineXformSampledPt(l_float32*, l_int32, l_int32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:78</i>
     */
    public static int affineXformSampledPt(Pointer<Float> vc, int x, int y,
            Pointer<Integer> pxp, Pointer<Integer> pyp) {
        return affineXformSampledPt(Pointer.getPeer(vc), x, y,
                Pointer.getPeer(pxp), Pointer.getPeer(pyp));
    }

    protected native static int affineXformSampledPt(@Ptr long vc, int x,
            int y, @Ptr long pxp, @Ptr long pyp);

    /**
     * Original signature :
     * <code>l_int32 affineXformPt(l_float32*, l_int32, l_int32, l_float32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:79</i>
     */
    public static int affineXformPt(Pointer<Float> vc, int x, int y,
            Pointer<Float> pxp, Pointer<Float> pyp) {
        return affineXformPt(Pointer.getPeer(vc), x, y, Pointer.getPeer(pxp),
                Pointer.getPeer(pyp));
    }

    protected native static int affineXformPt(@Ptr long vc, int x, int y,
            @Ptr long pxp, @Ptr long pyp);

    /**
     * Original signature :
     * <code>l_int32 linearInterpolatePixelColor(l_uint32*, l_int32, l_int32, l_int32, l_float32, l_float32, l_uint32, l_uint32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:80</i>
     */
    public static int linearInterpolatePixelColor(Pointer<Integer> datas,
            int wpls, int w, int h, float x, float y, int colorval,
            Pointer<Integer> pval) {
        return linearInterpolatePixelColor(Pointer.getPeer(datas), wpls, w, h,
                x, y, colorval, Pointer.getPeer(pval));
    }

    protected native static int linearInterpolatePixelColor(@Ptr long datas,
            int wpls, int w, int h, float x, float y, int colorval,
            @Ptr long pval);

    /**
     * Original signature :
     * <code>l_int32 linearInterpolatePixelGray(l_uint32*, l_int32, l_int32, l_int32, l_float32, l_float32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:81</i>
     */
    public static int linearInterpolatePixelGray(Pointer<Integer> datas,
            int wpls, int w, int h, float x, float y, int grayval,
            Pointer<Integer> pval) {
        return linearInterpolatePixelGray(Pointer.getPeer(datas), wpls, w, h,
                x, y, grayval, Pointer.getPeer(pval));
    }

    protected native static int linearInterpolatePixelGray(@Ptr long datas,
            int wpls, int w, int h, float x, float y, int grayval,
            @Ptr long pval);

    /**
     * Original signature :
     * <code>l_int32 gaussjordan(l_float32**, l_float32*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:82</i>
     */
    public static int gaussjordan(Pointer<Pointer<Float>> a, Pointer<Float> b,
            int n) {
        return gaussjordan(Pointer.getPeer(a), Pointer.getPeer(b), n);
    }

    protected native static int gaussjordan(@Ptr long a, @Ptr long b, int n) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixAffineSequential(PIX*, PTA*, PTA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:83</i>
     */
    public static Pointer<Pix> pixAffineSequential(Pointer<Pix> pixs,
            Pointer<Pta> ptad, Pointer<Pta> ptas, int bw, int bh) {
        return (Pointer) Pointer.pointerToAddress(
                pixAffineSequential(Pointer.getPeer(pixs),
                        Pointer.getPeer(ptad), Pointer.getPeer(ptas), bw, bh),
                Pix.class);
    }

    @Ptr
    protected native static long pixAffineSequential(@Ptr long pixs,
            @Ptr long ptad, @Ptr long ptas, int bw, int bh);

    /**
     * Original signature :
     * <code>l_float32* createMatrix2dTranslate(l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:84</i>
     */
    public static Pointer<Float> createMatrix2dTranslate(float transx,
            float transy) {
        return (Pointer) Pointer.pointerToAddress(
                createMatrix2dTranslate$2(transx, transy), Float.class);
    }

    @Ptr
    @Name("createMatrix2dTranslate")
    protected native static long createMatrix2dTranslate$2(float transx,
            float transy);

    /**
     * Original signature :
     * <code>l_float32* createMatrix2dScale(l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:85</i>
     */
    public static Pointer<Float> createMatrix2dScale(float scalex, float scaley) {
        return (Pointer) Pointer.pointerToAddress(
                createMatrix2dScale$2(scalex, scaley), Float.class);
    }

    @Ptr
    @Name("createMatrix2dScale")
    protected native static long createMatrix2dScale$2(float scalex,
            float scaley);

    /**
     * Original signature :
     * <code>l_float32* createMatrix2dRotate(l_float32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:86</i>
     */
    public static Pointer<Float> createMatrix2dRotate(float xc, float yc,
            float angle) {
        return (Pointer) Pointer.pointerToAddress(
                createMatrix2dRotate$2(xc, yc, angle), Float.class);
    }

    @Ptr
    @Name("createMatrix2dRotate")
    protected native static long createMatrix2dRotate$2(float xc, float yc,
            float angle);

    /**
     * Original signature :
     * <code>PTA* ptaTranslate(PTA*, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:87</i>
     */
    public static Pointer<Pta> ptaTranslate(Pointer<Pta> ptas, float transx,
            float transy) {
        return (Pointer) Pointer.pointerToAddress(
                ptaTranslate(Pointer.getPeer(ptas), transx, transy), Pta.class);
    }

    @Ptr
    protected native static long ptaTranslate(@Ptr long ptas, float transx,
            float transy);

    /**
     * Original signature :
     * <code>PTA* ptaScale(PTA*, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:88</i>
     */
    public static Pointer<Pta> ptaScale(Pointer<Pta> ptas, float scalex,
            float scaley) {
        return (Pointer) Pointer.pointerToAddress(
                ptaScale(Pointer.getPeer(ptas), scalex, scaley), Pta.class);
    }

    @Ptr
    protected native static long ptaScale(@Ptr long ptas, float scalex,
            float scaley);

    /**
     * Original signature :
     * <code>PTA* ptaRotate(PTA*, l_float32, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:89</i>
     */
    public static Pointer<Pta> ptaRotate(Pointer<Pta> ptas, float xc, float yc,
            float angle) {
        return (Pointer) Pointer.pointerToAddress(
                ptaRotate(Pointer.getPeer(ptas), xc, yc, angle), Pta.class);
    }

    @Ptr
    protected native static long ptaRotate(@Ptr long ptas, float xc, float yc,
            float angle);

    /**
     * Original signature :
     * <code>BOXA* boxaTranslate(BOXA*, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:90</i>
     */
    public static Pointer<Boxa> boxaTranslate(Pointer<Boxa> boxas,
            float transx, float transy) {
        return (Pointer) Pointer.pointerToAddress(
                boxaTranslate(Pointer.getPeer(boxas), transx, transy),
                Boxa.class);
    }

    @Ptr
    protected native static long boxaTranslate(@Ptr long boxas, float transx,
            float transy);

    /**
     * Original signature :
     * <code>BOXA* boxaScale(BOXA*, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:91</i>
     */
    public static Pointer<Boxa> boxaScale(Pointer<Boxa> boxas, float scalex,
            float scaley) {
        return (Pointer) Pointer.pointerToAddress(
                boxaScale(Pointer.getPeer(boxas), scalex, scaley), Boxa.class);
    }

    @Ptr
    protected native static long boxaScale(@Ptr long boxas, float scalex,
            float scaley);

    /**
     * Original signature :
     * <code>BOXA* boxaRotate(BOXA*, l_float32, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:92</i>
     */
    public static Pointer<Boxa> boxaRotate(Pointer<Boxa> boxas, float xc,
            float yc, float angle) {
        return (Pointer) Pointer.pointerToAddress(
                boxaRotate(Pointer.getPeer(boxas), xc, yc, angle), Boxa.class);
    }

    @Ptr
    protected native static long boxaRotate(@Ptr long boxas, float xc,
            float yc, float angle);

    /**
     * Original signature :
     * <code>PTA* ptaAffineTransform(PTA*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:93</i>
     */
    public static Pointer<Pta> ptaAffineTransform(Pointer<Pta> ptas,
            Pointer<Float> mat) {
        return (Pointer) Pointer.pointerToAddress(
                ptaAffineTransform(Pointer.getPeer(ptas), Pointer.getPeer(mat)),
                Pta.class);
    }

    @Ptr
    protected native static long ptaAffineTransform(@Ptr long ptas,
            @Ptr long mat);

    /**
     * Original signature :
     * <code>BOXA* boxaAffineTransform(BOXA*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:94</i>
     */
    public static Pointer<Boxa> boxaAffineTransform(Pointer<Boxa> boxas,
            Pointer<Float> mat) {
        return (Pointer) Pointer.pointerToAddress(
                boxaAffineTransform(Pointer.getPeer(boxas),
                        Pointer.getPeer(mat)), Boxa.class);
    }

    @Ptr
    protected native static long boxaAffineTransform(@Ptr long boxas,
            @Ptr long mat);

    /**
     * Original signature :
     * <code>l_int32 l_productMatVec(l_float32*, l_float32*, l_float32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:95</i>
     */
    public static int l_productMatVec(Pointer<Float> mat, Pointer<Float> vecs,
            Pointer<Float> vecd, int size) {
        return l_productMatVec(Pointer.getPeer(mat), Pointer.getPeer(vecs),
                Pointer.getPeer(vecd), size);
    }

    protected native static int l_productMatVec(@Ptr long mat, @Ptr long vecs,
            @Ptr long vecd, int size);

    /**
     * Original signature :
     * <code>l_int32 l_productMat2(l_float32*, l_float32*, l_float32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:96</i>
     */
    public static int l_productMat2(Pointer<Float> mat1, Pointer<Float> mat2,
            Pointer<Float> matd, int size) {
        return l_productMat2(Pointer.getPeer(mat1), Pointer.getPeer(mat2),
                Pointer.getPeer(matd), size);
    }

    protected native static int l_productMat2(@Ptr long mat1, @Ptr long mat2,
            @Ptr long matd, int size);

    /**
     * Original signature :
     * <code>l_int32 l_productMat3(l_float32*, l_float32*, l_float32*, l_float32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:97</i>
     */
    public static int l_productMat3(Pointer<Float> mat1, Pointer<Float> mat2,
            Pointer<Float> mat3, Pointer<Float> matd, int size) {
        return l_productMat3(Pointer.getPeer(mat1), Pointer.getPeer(mat2),
                Pointer.getPeer(mat3), Pointer.getPeer(matd), size);
    }

    protected native static int l_productMat3(@Ptr long mat1, @Ptr long mat2,
            @Ptr long mat3, @Ptr long matd, int size);

    /**
     * Original signature :
     * <code>l_int32 l_productMat4(l_float32*, l_float32*, l_float32*, l_float32*, l_float32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:98</i>
     */
    public static int l_productMat4(Pointer<Float> mat1, Pointer<Float> mat2,
            Pointer<Float> mat3, Pointer<Float> mat4, Pointer<Float> matd,
            int size) {
        return l_productMat4(Pointer.getPeer(mat1), Pointer.getPeer(mat2),
                Pointer.getPeer(mat3), Pointer.getPeer(mat4),
                Pointer.getPeer(matd), size);
    }

    protected native static int l_productMat4(@Ptr long mat1, @Ptr long mat2,
            @Ptr long mat3, @Ptr long mat4, @Ptr long matd, int size);

    /**
     * Original signature : <code>l_int32 l_getDataBit(void*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:99</i>
     */
    public static int l_getDataBit(Pointer<?> line, int n) {
        return l_getDataBit(Pointer.getPeer(line), n);
    }

    protected native static int l_getDataBit(@Ptr long line, int n) throws LastError;

    /**
     * Original signature : <code>void l_setDataBit(void*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:100</i>
     */
    public static void l_setDataBit(Pointer<?> line, int n) {
        l_setDataBit(Pointer.getPeer(line), n);
    }

    protected native static void l_setDataBit(@Ptr long line, int n) throws LastError;

    /**
     * Original signature : <code>void l_clearDataBit(void*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:101</i>
     */
    public static void l_clearDataBit(Pointer<?> line, int n) {
        l_clearDataBit(Pointer.getPeer(line), n);
    }

    protected native static void l_clearDataBit(@Ptr long line, int n) throws LastError;

    /**
     * Original signature :
     * <code>void l_setDataBitVal(void*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:102</i>
     */
    public static void l_setDataBitVal(Pointer<?> line, int n, int val) {
        l_setDataBitVal(Pointer.getPeer(line), n, val);
    }

    protected native static void l_setDataBitVal(@Ptr long line, int n, int val) throws LastError;

    /**
     * Original signature : <code>l_int32 l_getDataDibit(void*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:103</i>
     */
    public static int l_getDataDibit(Pointer<?> line, int n) {
        return l_getDataDibit(Pointer.getPeer(line), n);
    }

    protected native static int l_getDataDibit(@Ptr long line, int n) throws LastError;

    /**
     * Original signature :
     * <code>void l_setDataDibit(void*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:104</i>
     */
    public static void l_setDataDibit(Pointer<?> line, int n, int val) {
        l_setDataDibit(Pointer.getPeer(line), n, val);
    }

    protected native static void l_setDataDibit(@Ptr long line, int n, int val) throws LastError;

    /**
     * Original signature : <code>void l_clearDataDibit(void*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:105</i>
     */
    public static void l_clearDataDibit(Pointer<?> line, int n) {
        l_clearDataDibit(Pointer.getPeer(line), n);
    }

    protected native static void l_clearDataDibit(@Ptr long line, int n) throws LastError;

    /**
     * Original signature : <code>l_int32 l_getDataQbit(void*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:106</i>
     */
    public static int l_getDataQbit(Pointer<?> line, int n) {
        return l_getDataQbit(Pointer.getPeer(line), n);
    }

    protected native static int l_getDataQbit(@Ptr long line, int n) throws LastError;

    /**
     * Original signature :
     * <code>void l_setDataQbit(void*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:107</i>
     */
    public static void l_setDataQbit(Pointer<?> line, int n, int val) {
        l_setDataQbit(Pointer.getPeer(line), n, val);
    }

    protected native static void l_setDataQbit(@Ptr long line, int n, int val) throws LastError;

    /**
     * Original signature : <code>void l_clearDataQbit(void*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:108</i>
     */
    public static void l_clearDataQbit(Pointer<?> line, int n) {
        l_clearDataQbit(Pointer.getPeer(line), n);
    }

    protected native static void l_clearDataQbit(@Ptr long line, int n) throws LastError;

    /**
     * Original signature : <code>l_int32 l_getDataByte(void*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:109</i>
     */
    public static int l_getDataByte(Pointer<?> line, int n) {
        return l_getDataByte(Pointer.getPeer(line), n);
    }

    protected native static int l_getDataByte(@Ptr long line, int n) throws LastError;

    /**
     * Original signature :
     * <code>void l_setDataByte(void*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:110</i>
     */
    public static void l_setDataByte(Pointer<?> line, int n, int val) {
        l_setDataByte(Pointer.getPeer(line), n, val);
    }

    protected native static void l_setDataByte(@Ptr long line, int n, int val) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_getDataTwoBytes(void*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:111</i>
     */
    public static int l_getDataTwoBytes(Pointer<?> line, int n) {
        return l_getDataTwoBytes(Pointer.getPeer(line), n);
    }

    protected native static int l_getDataTwoBytes(@Ptr long line, int n) throws LastError;

    /**
     * Original signature :
     * <code>void l_setDataTwoBytes(void*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:112</i>
     */
    public static void l_setDataTwoBytes(Pointer<?> line, int n, int val) {
        l_setDataTwoBytes(Pointer.getPeer(line), n, val);
    }

    protected native static void l_setDataTwoBytes(@Ptr long line, int n,
            int val);

    /**
     * Original signature :
     * <code>l_int32 l_getDataFourBytes(void*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:113</i>
     */
    public static int l_getDataFourBytes(Pointer<?> line, int n) {
        return l_getDataFourBytes(Pointer.getPeer(line), n);
    }

    protected native static int l_getDataFourBytes(@Ptr long line, int n) throws LastError;

    /**
     * Original signature :
     * <code>void l_setDataFourBytes(void*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:114</i>
     */
    public static void l_setDataFourBytes(Pointer<?> line, int n, int val) {
        l_setDataFourBytes(Pointer.getPeer(line), n, val);
    }

    protected native static void l_setDataFourBytes(@Ptr long line, int n,
            int val);

    /**
     * Original signature :
     * <code>char* barcodeDispatchDecoder(char*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:115</i>
     */
    public static Pointer<Byte> barcodeDispatchDecoder(Pointer<Byte> barstr,
            int format, int debugflag) {
        return (Pointer) Pointer.pointerToAddress(
                barcodeDispatchDecoder(Pointer.getPeer(barstr), format,
                        debugflag), Byte.class);
    }

    @Ptr
    protected native static long barcodeDispatchDecoder(@Ptr long barstr,
            int format, int debugflag);

    /**
     * Original signature :
     * <code>l_int32 barcodeFormatIsSupported(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:116</i>
     */
    public static native int barcodeFormatIsSupported(int format) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* pixFindBaselines(PIX*, PTA**, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:117</i>
     */
    public static Pointer<Numa> pixFindBaselines(Pointer<Pix> pixs,
            Pointer<Pointer<Pta>> ppta, int debug) {
        return (Pointer) Pointer.pointerToAddress(
                pixFindBaselines(Pointer.getPeer(pixs), Pointer.getPeer(ppta),
                        debug), Numa.class);
    }

    @Ptr
    protected native static long pixFindBaselines(@Ptr long pixs,
            @Ptr long ppta, int debug);

    /**
     * Original signature :
     * <code>PIX* pixDeskewLocal(PIX*, l_int32, l_int32, l_int32, l_float32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:118</i>
     */
    public static Pointer<Pix> pixDeskewLocal(Pointer<Pix> pixs, int nslices,
            int redsweep, int redsearch, float sweeprange, float sweepdelta,
            float minbsdelta) {
        return (Pointer) Pointer.pointerToAddress(
                pixDeskewLocal(Pointer.getPeer(pixs), nslices, redsweep,
                        redsearch, sweeprange, sweepdelta, minbsdelta),
                Pix.class);
    }

    @Ptr
    protected native static long pixDeskewLocal(@Ptr long pixs, int nslices,
            int redsweep, int redsearch, float sweeprange, float sweepdelta,
            float minbsdelta);

    /**
     * Original signature :
     * <code>l_int32 pixGetLocalSkewTransform(PIX*, l_int32, l_int32, l_int32, l_float32, l_float32, l_float32, PTA**, PTA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:119</i>
     */
    public static int pixGetLocalSkewTransform(Pointer<Pix> pixs, int nslices,
            int redsweep, int redsearch, float sweeprange, float sweepdelta,
            float minbsdelta, Pointer<Pointer<Pta>> pptas,
            Pointer<Pointer<Pta>> pptad) {
        return pixGetLocalSkewTransform(Pointer.getPeer(pixs), nslices,
                redsweep, redsearch, sweeprange, sweepdelta, minbsdelta,
                Pointer.getPeer(pptas), Pointer.getPeer(pptad));
    }

    protected native static int pixGetLocalSkewTransform(@Ptr long pixs,
            int nslices, int redsweep, int redsearch, float sweeprange,
            float sweepdelta, float minbsdelta, @Ptr long pptas, @Ptr long pptad);

    /**
     * Original signature :
     * <code>NUMA* pixGetLocalSkewAngles(PIX*, l_int32, l_int32, l_int32, l_float32, l_float32, l_float32, l_float32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:120</i>
     */
    public static Pointer<Numa> pixGetLocalSkewAngles(Pointer<Pix> pixs,
            int nslices, int redsweep, int redsearch, float sweeprange,
            float sweepdelta, float minbsdelta, Pointer<Float> pa,
            Pointer<Float> pb) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetLocalSkewAngles(Pointer.getPeer(pixs), nslices, redsweep,
                        redsearch, sweeprange, sweepdelta, minbsdelta,
                        Pointer.getPeer(pa), Pointer.getPeer(pb)), Numa.class);
    }

    @Ptr
    protected native static long pixGetLocalSkewAngles(@Ptr long pixs,
            int nslices, int redsweep, int redsearch, float sweeprange,
            float sweepdelta, float minbsdelta, @Ptr long pa, @Ptr long pb);

    /**
     * Original signature :
     * <code>BBUFFER* bbufferCreate(l_uint8*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:121</i>
     */
    public static Pointer<ByteBuffer> bbufferCreate(Pointer<Byte> indata,
            int nalloc) {
        return (Pointer) Pointer.pointerToAddress(
                bbufferCreate(Pointer.getPeer(indata), nalloc),
                ByteBuffer.class);
    }

    @Ptr
    protected native static long bbufferCreate(@Ptr long indata, int nalloc) throws LastError;

    /**
     * Original signature : <code>void bbufferDestroy(BBUFFER**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:122</i>
     */
    public static void bbufferDestroy(Pointer<Pointer<ByteBuffer>> pbb) {
        bbufferDestroy(Pointer.getPeer(pbb));
    }

    protected native static void bbufferDestroy(@Ptr long pbb) throws LastError;

    /**
     * Original signature :
     * <code>l_uint8* bbufferDestroyAndSaveData(BBUFFER**, size_t*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:123</i>
     */
    public static Pointer<Byte> bbufferDestroyAndSaveData(
            Pointer<Pointer<ByteBuffer>> pbb, Pointer<SizeT> pnbytes) {
        return (Pointer) Pointer.pointerToAddress(
                bbufferDestroyAndSaveData(Pointer.getPeer(pbb),
                        Pointer.getPeer(pnbytes)), Byte.class);
    }

    @Ptr
    protected native static long bbufferDestroyAndSaveData(@Ptr long pbb,
            @Ptr long pnbytes);

    /**
     * Original signature :
     * <code>l_int32 bbufferRead(BBUFFER*, l_uint8*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:124</i>
     */
    public static int bbufferRead(Pointer<ByteBuffer> bb, Pointer<Byte> src,
            int nbytes) {
        return bbufferRead(Pointer.getPeer(bb), Pointer.getPeer(src), nbytes);
    }

    protected native static int bbufferRead(@Ptr long bb, @Ptr long src,
            int nbytes);

    /**
     * Original signature :
     * <code>l_int32 bbufferReadStream(BBUFFER*, FILE*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:125</i>
     */
    public static int bbufferReadStream(Pointer<ByteBuffer> bb,
            Pointer<FILE> fp, int nbytes) {
        return bbufferReadStream(Pointer.getPeer(bb), Pointer.getPeer(fp),
                nbytes);
    }

    protected native static int bbufferReadStream(@Ptr long bb, @Ptr long fp,
            int nbytes);

    /**
     * Original signature :
     * <code>l_int32 bbufferWrite(BBUFFER*, l_uint8*, size_t, size_t*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:126</i>
     */
    public static int bbufferWrite(Pointer<ByteBuffer> bb, Pointer<Byte> dest,
            @Ptr long nbytes, Pointer<SizeT> pnout) {
        return bbufferWrite(Pointer.getPeer(bb), Pointer.getPeer(dest), nbytes,
                Pointer.getPeer(pnout));
    }

    protected native static int bbufferWrite(@Ptr long bb, @Ptr long dest,
            @Ptr long nbytes, @Ptr long pnout);

    /**
     * Original signature :
     * <code>l_int32 bbufferWriteStream(BBUFFER*, FILE*, size_t, size_t*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:127</i>
     */
    public static int bbufferWriteStream(Pointer<ByteBuffer> bb,
            Pointer<FILE> fp, @Ptr long nbytes,
            Pointer<SizeT> pnout) {
        return bbufferWriteStream(Pointer.getPeer(bb), Pointer.getPeer(fp),
                nbytes, Pointer.getPeer(pnout));
    }

    protected native static int bbufferWriteStream(@Ptr long bb, @Ptr long fp,
            @Ptr long nbytes, @Ptr long pnout);

    /**
     * Original signature :
     * <code>l_int32 bbufferBytesToWrite(BBUFFER*, size_t*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:128</i>
     */
    public static int bbufferBytesToWrite(Pointer<ByteBuffer> bb,
            Pointer<SizeT> pnbytes) {
        return bbufferBytesToWrite(Pointer.getPeer(bb),
                Pointer.getPeer(pnbytes));
    }

    protected native static int bbufferBytesToWrite(@Ptr long bb,
            @Ptr long pnbytes);

    /**
     * Original signature :
     * <code>l_int32 bbufferReadStdin(l_uint8**, size_t*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:129</i>
     */
    public static int bbufferReadStdin(Pointer<Pointer<Byte>> pdata,
            Pointer<SizeT> pnbytes) {
        return bbufferReadStdin(Pointer.getPeer(pdata),
                Pointer.getPeer(pnbytes));
    }

    protected native static int bbufferReadStdin(@Ptr long pdata,
            @Ptr long pnbytes);

    /**
     * Original signature :
     * <code>PIX* pixBilateral(PIX*, l_float32, l_float32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:130</i>
     */
    public static Pointer<Pix> pixBilateral(Pointer<Pix> pixs,
            float spatial_stdev, float range_stdev, int ncomps, int reduction) {
        return (Pointer) Pointer.pointerToAddress(
                pixBilateral(Pointer.getPeer(pixs), spatial_stdev, range_stdev,
                        ncomps, reduction), Pix.class);
    }

    @Ptr
    protected native static long pixBilateral(@Ptr long pixs,
            float spatial_stdev, float range_stdev, int ncomps, int reduction);

    /**
     * Original signature :
     * <code>PIX* pixBilateralGray(PIX*, l_float32, l_float32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:131</i>
     */
    public static Pointer<Pix> pixBilateralGray(Pointer<Pix> pixs,
            float spatial_stdev, float range_stdev, int ncomps, int reduction) {
        return (Pointer) Pointer.pointerToAddress(
                pixBilateralGray(Pointer.getPeer(pixs), spatial_stdev,
                        range_stdev, ncomps, reduction), Pix.class);
    }

    @Ptr
    protected native static long pixBilateralGray(@Ptr long pixs,
            float spatial_stdev, float range_stdev, int ncomps, int reduction);

    /**
     * Original signature :
     * <code>PIX* pixBilateralExact(PIX*, L_KERNEL*, L_KERNEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:132</i>
     */
    public static Pointer<Pix> pixBilateralExact(Pointer<Pix> pixs,
            Pointer<L_Kernel> spatial_kel, Pointer<L_Kernel> range_kel) {
        return (Pointer) Pointer.pointerToAddress(
                pixBilateralExact(Pointer.getPeer(pixs),
                        Pointer.getPeer(spatial_kel),
                        Pointer.getPeer(range_kel)), Pix.class);
    }

    @Ptr
    protected native static long pixBilateralExact(@Ptr long pixs,
            @Ptr long spatial_kel, @Ptr long range_kel);

    /**
     * Original signature :
     * <code>PIX* pixBilateralGrayExact(PIX*, L_KERNEL*, L_KERNEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:133</i>
     */
    public static Pointer<Pix> pixBilateralGrayExact(Pointer<Pix> pixs,
            Pointer<L_Kernel> spatial_kel, Pointer<L_Kernel> range_kel) {
        return (Pointer) Pointer.pointerToAddress(
                pixBilateralGrayExact(Pointer.getPeer(pixs),
                        Pointer.getPeer(spatial_kel),
                        Pointer.getPeer(range_kel)), Pix.class);
    }

    @Ptr
    protected native static long pixBilateralGrayExact(@Ptr long pixs,
            @Ptr long spatial_kel, @Ptr long range_kel);

    /**
     * Original signature :
     * <code>PIX* pixBlockBilateralExact(PIX*, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:134</i>
     */
    public static Pointer<Pix> pixBlockBilateralExact(Pointer<Pix> pixs,
            float spatial_stdev, float range_stdev) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlockBilateralExact(Pointer.getPeer(pixs), spatial_stdev,
                        range_stdev), Pix.class);
    }

    @Ptr
    protected native static long pixBlockBilateralExact(@Ptr long pixs,
            float spatial_stdev, float range_stdev);

    /**
     * Original signature : <code>L_KERNEL* makeRangeKernel(l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:135</i>
     */
    public static Pointer<L_Kernel> makeRangeKernel(float range_stdev) {
        return (Pointer) Pointer.pointerToAddress(
                makeRangeKernel$2(range_stdev), L_Kernel.class);
    }

    @Ptr
    @Name("makeRangeKernel")
    protected native static long makeRangeKernel$2(float range_stdev) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixBilinearSampledPta(PIX*, PTA*, PTA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:136</i>
     */
    public static Pointer<Pix> pixBilinearSampledPta(Pointer<Pix> pixs,
            Pointer<Pta> ptad, Pointer<Pta> ptas, int incolor) {
        return (Pointer) Pointer.pointerToAddress(
                pixBilinearSampledPta(Pointer.getPeer(pixs),
                        Pointer.getPeer(ptad), Pointer.getPeer(ptas), incolor),
                Pix.class);
    }

    @Ptr
    protected native static long pixBilinearSampledPta(@Ptr long pixs,
            @Ptr long ptad, @Ptr long ptas, int incolor);

    /**
     * Original signature :
     * <code>PIX* pixBilinearSampled(PIX*, l_float32*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:137</i>
     */
    public static Pointer<Pix> pixBilinearSampled(Pointer<Pix> pixs,
            Pointer<Float> vc, int incolor) {
        return (Pointer) Pointer.pointerToAddress(
                pixBilinearSampled(Pointer.getPeer(pixs), Pointer.getPeer(vc),
                        incolor), Pix.class);
    }

    @Ptr
    protected native static long pixBilinearSampled(@Ptr long pixs,
            @Ptr long vc, int incolor);

    /**
     * Original signature :
     * <code>PIX* pixBilinearPta(PIX*, PTA*, PTA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:138</i>
     */
    public static Pointer<Pix> pixBilinearPta(Pointer<Pix> pixs,
            Pointer<Pta> ptad, Pointer<Pta> ptas, int incolor) {
        return (Pointer) Pointer.pointerToAddress(
                pixBilinearPta(Pointer.getPeer(pixs), Pointer.getPeer(ptad),
                        Pointer.getPeer(ptas), incolor), Pix.class);
    }

    @Ptr
    protected native static long pixBilinearPta(@Ptr long pixs, @Ptr long ptad,
            @Ptr long ptas, int incolor);

    /**
     * Original signature :
     * <code>PIX* pixBilinear(PIX*, l_float32*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:139</i>
     */
    public static Pointer<Pix> pixBilinear(Pointer<Pix> pixs,
            Pointer<Float> vc, int incolor) {
        return (Pointer) Pointer.pointerToAddress(
                pixBilinear(Pointer.getPeer(pixs), Pointer.getPeer(vc), incolor),
                Pix.class);
    }

    @Ptr
    protected native static long pixBilinear(@Ptr long pixs, @Ptr long vc,
            int incolor);

    /**
     * Original signature :
     * <code>PIX* pixBilinearPtaColor(PIX*, PTA*, PTA*, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:140</i>
     */
    public static Pointer<Pix> pixBilinearPtaColor(Pointer<Pix> pixs,
            Pointer<Pta> ptad, Pointer<Pta> ptas, int colorval) {
        return (Pointer) Pointer.pointerToAddress(
                pixBilinearPtaColor(Pointer.getPeer(pixs),
                        Pointer.getPeer(ptad), Pointer.getPeer(ptas), colorval),
                Pix.class);
    }

    @Ptr
    protected native static long pixBilinearPtaColor(@Ptr long pixs,
            @Ptr long ptad, @Ptr long ptas, int colorval);

    /**
     * Original signature :
     * <code>PIX* pixBilinearColor(PIX*, l_float32*, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:141</i>
     */
    public static Pointer<Pix> pixBilinearColor(Pointer<Pix> pixs,
            Pointer<Float> vc, int colorval) {
        return (Pointer) Pointer.pointerToAddress(
                pixBilinearColor(Pointer.getPeer(pixs), Pointer.getPeer(vc),
                        colorval), Pix.class);
    }

    @Ptr
    protected native static long pixBilinearColor(@Ptr long pixs, @Ptr long vc,
            int colorval);

    /**
     * Original signature :
     * <code>PIX* pixBilinearPtaGray(PIX*, PTA*, PTA*, l_uint8)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:142</i>
     */
    public static Pointer<Pix> pixBilinearPtaGray(Pointer<Pix> pixs,
            Pointer<Pta> ptad, Pointer<Pta> ptas, byte grayval) {
        return (Pointer) Pointer.pointerToAddress(
                pixBilinearPtaGray(Pointer.getPeer(pixs),
                        Pointer.getPeer(ptad), Pointer.getPeer(ptas), grayval),
                Pix.class);
    }

    @Ptr
    protected native static long pixBilinearPtaGray(@Ptr long pixs,
            @Ptr long ptad, @Ptr long ptas, byte grayval);

    /**
     * Original signature :
     * <code>PIX* pixBilinearGray(PIX*, l_float32*, l_uint8)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:143</i>
     */
    public static Pointer<Pix> pixBilinearGray(Pointer<Pix> pixs,
            Pointer<Float> vc, byte grayval) {
        return (Pointer) Pointer.pointerToAddress(
                pixBilinearGray(Pointer.getPeer(pixs), Pointer.getPeer(vc),
                        grayval), Pix.class);
    }

    @Ptr
    protected native static long pixBilinearGray(@Ptr long pixs, @Ptr long vc,
            byte grayval);

    /**
     * Original signature :
     * <code>PIX* pixBilinearPtaWithAlpha(PIX*, PTA*, PTA*, PIX*, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:144</i>
     */
    public static Pointer<Pix> pixBilinearPtaWithAlpha(Pointer<Pix> pixs,
            Pointer<Pta> ptad, Pointer<Pta> ptas, Pointer<Pix> pixg,
            float fract, int border) {
        return (Pointer) Pointer.pointerToAddress(
                pixBilinearPtaWithAlpha(Pointer.getPeer(pixs),
                        Pointer.getPeer(ptad), Pointer.getPeer(ptas),
                        Pointer.getPeer(pixg), fract, border), Pix.class);
    }

    @Ptr
    protected native static long pixBilinearPtaWithAlpha(@Ptr long pixs,
            @Ptr long ptad, @Ptr long ptas, @Ptr long pixg, float fract,
            int border);

    /**
     * Original signature :
     * <code>l_int32 getBilinearXformCoeffs(PTA*, PTA*, l_float32**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:145</i>
     */
    public static int getBilinearXformCoeffs(Pointer<Pta> ptas,
            Pointer<Pta> ptad, Pointer<Pointer<Float>> pvc) {
        return getBilinearXformCoeffs(Pointer.getPeer(ptas),
                Pointer.getPeer(ptad), Pointer.getPeer(pvc));
    }

    protected native static int getBilinearXformCoeffs(@Ptr long ptas,
            @Ptr long ptad, @Ptr long pvc);

    /**
     * Original signature :
     * <code>l_int32 bilinearXformSampledPt(l_float32*, l_int32, l_int32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:146</i>
     */
    public static int bilinearXformSampledPt(Pointer<Float> vc, int x, int y,
            Pointer<Integer> pxp, Pointer<Integer> pyp) {
        return bilinearXformSampledPt(Pointer.getPeer(vc), x, y,
                Pointer.getPeer(pxp), Pointer.getPeer(pyp));
    }

    protected native static int bilinearXformSampledPt(@Ptr long vc, int x,
            int y, @Ptr long pxp, @Ptr long pyp);

    /**
     * Original signature :
     * <code>l_int32 bilinearXformPt(l_float32*, l_int32, l_int32, l_float32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:147</i>
     */
    public static int bilinearXformPt(Pointer<Float> vc, int x, int y,
            Pointer<Float> pxp, Pointer<Float> pyp) {
        return bilinearXformPt(Pointer.getPeer(vc), x, y, Pointer.getPeer(pxp),
                Pointer.getPeer(pyp));
    }

    protected native static int bilinearXformPt(@Ptr long vc, int x, int y,
            @Ptr long pxp, @Ptr long pyp);

    /**
     * Original signature :
     * <code>l_int32 pixOtsuAdaptiveThreshold(PIX*, l_int32, l_int32, l_int32, l_int32, l_float32, PIX**, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:148</i>
     */
    public static int pixOtsuAdaptiveThreshold(Pointer<Pix> pixs, int sx,
            int sy, int smoothx, int smoothy, float scorefract,
            Pointer<Pointer<Pix>> ppixth, Pointer<Pointer<Pix>> ppixd) {
        return pixOtsuAdaptiveThreshold(Pointer.getPeer(pixs), sx, sy, smoothx,
                smoothy, scorefract, Pointer.getPeer(ppixth),
                Pointer.getPeer(ppixd));
    }

    protected native static int pixOtsuAdaptiveThreshold(@Ptr long pixs,
            int sx, int sy, int smoothx, int smoothy, float scorefract,
            @Ptr long ppixth, @Ptr long ppixd);

    /**
     * Original signature :
     * <code>PIX* pixOtsuThreshOnBackgroundNorm(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_float32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:149</i>
     */
    public static Pointer<Pix> pixOtsuThreshOnBackgroundNorm(Pointer<Pix> pixs,
            Pointer<Pix> pixim, int sx, int sy, int thresh, int mincount,
            int bgval, int smoothx, int smoothy, float scorefract,
            Pointer<Integer> pthresh) {
        return (Pointer) Pointer.pointerToAddress(
                pixOtsuThreshOnBackgroundNorm(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixim), sx, sy, thresh, mincount,
                        bgval, smoothx, smoothy, scorefract,
                        Pointer.getPeer(pthresh)), Pix.class);
    }

    @Ptr
    protected native static long pixOtsuThreshOnBackgroundNorm(@Ptr long pixs,
            @Ptr long pixim, int sx, int sy, int thresh, int mincount,
            int bgval, int smoothx, int smoothy, float scorefract,
            @Ptr long pthresh);

    /**
     * Original signature :
     * <code>PIX* pixMaskedThreshOnBackgroundNorm(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_float32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:150</i>
     */
    public static Pointer<Pix> pixMaskedThreshOnBackgroundNorm(
            Pointer<Pix> pixs, Pointer<Pix> pixim, int sx, int sy, int thresh,
            int mincount, int smoothx, int smoothy, float scorefract,
            Pointer<Integer> pthresh) {
        return (Pointer) Pointer.pointerToAddress(
                pixMaskedThreshOnBackgroundNorm(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixim), sx, sy, thresh, mincount,
                        smoothx, smoothy, scorefract, Pointer.getPeer(pthresh)),
                Pix.class);
    }

    @Ptr
    protected native static long pixMaskedThreshOnBackgroundNorm(
            @Ptr long pixs, @Ptr long pixim, int sx, int sy, int thresh,
            int mincount, int smoothx, int smoothy, float scorefract,
            @Ptr long pthresh);

    /**
     * Original signature :
     * <code>l_int32 pixSauvolaBinarizeTiled(PIX*, l_int32, l_float32, l_int32, l_int32, PIX**, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:151</i>
     */
    public static int pixSauvolaBinarizeTiled(Pointer<Pix> pixs, int whsize,
            float factor, int nx, int ny, Pointer<Pointer<Pix>> ppixth,
            Pointer<Pointer<Pix>> ppixd) {
        return pixSauvolaBinarizeTiled(Pointer.getPeer(pixs), whsize, factor,
                nx, ny, Pointer.getPeer(ppixth), Pointer.getPeer(ppixd));
    }

    protected native static int pixSauvolaBinarizeTiled(@Ptr long pixs,
            int whsize, float factor, int nx, int ny, @Ptr long ppixth,
            @Ptr long ppixd);

    /**
     * Original signature :
     * <code>l_int32 pixSauvolaBinarize(PIX*, l_int32, l_float32, l_int32, PIX**, PIX**, PIX**, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:152</i>
     */
    public static int pixSauvolaBinarize(Pointer<Pix> pixs, int whsize,
            float factor, int addborder, Pointer<Pointer<Pix>> ppixm,
            Pointer<Pointer<Pix>> ppixsd, Pointer<Pointer<Pix>> ppixth,
            Pointer<Pointer<Pix>> ppixd) {
        return pixSauvolaBinarize(Pointer.getPeer(pixs), whsize, factor,
                addborder, Pointer.getPeer(ppixm), Pointer.getPeer(ppixsd),
                Pointer.getPeer(ppixth), Pointer.getPeer(ppixd));
    }

    protected native static int pixSauvolaBinarize(@Ptr long pixs, int whsize,
            float factor, int addborder, @Ptr long ppixm, @Ptr long ppixsd,
            @Ptr long ppixth, @Ptr long ppixd);

    /**
     * Original signature :
     * <code>PIX* pixSauvolaGetThreshold(PIX*, PIX*, l_float32, PIX**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:153</i>
     */
    public static Pointer<Pix> pixSauvolaGetThreshold(Pointer<Pix> pixm,
            Pointer<Pix> pixms, float factor, Pointer<Pointer<Pix>> ppixsd) {
        return (Pointer) Pointer.pointerToAddress(
                pixSauvolaGetThreshold(Pointer.getPeer(pixm),
                        Pointer.getPeer(pixms), factor, Pointer.getPeer(ppixsd)),
                Pix.class);
    }

    @Ptr
    protected native static long pixSauvolaGetThreshold(@Ptr long pixm,
            @Ptr long pixms, float factor, @Ptr long ppixsd);

    /**
     * Original signature :
     * <code>PIX* pixApplyLocalThreshold(PIX*, PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:154</i>
     */
    public static Pointer<Pix> pixApplyLocalThreshold(Pointer<Pix> pixs,
            Pointer<Pix> pixth, int redfactor) {
        return (Pointer) Pointer.pointerToAddress(
                pixApplyLocalThreshold(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixth), redfactor), Pix.class);
    }

    @Ptr
    protected native static long pixApplyLocalThreshold(@Ptr long pixs,
            @Ptr long pixth, int redfactor);

    /**
     * Original signature :
     * <code>PIX* pixExpandBinaryReplicate(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:155</i>
     */
    public static Pointer<Pix> pixExpandBinaryReplicate(Pointer<Pix> pixs,
            int factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixExpandBinaryReplicate(Pointer.getPeer(pixs), factor),
                Pix.class);
    }

    @Ptr
    protected native static long pixExpandBinaryReplicate(@Ptr long pixs,
            int factor);

    /**
     * Original signature :
     * <code>PIX* pixExpandBinaryPower2(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:156</i>
     */
    public static Pointer<Pix> pixExpandBinaryPower2(Pointer<Pix> pixs,
            int factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixExpandBinaryPower2(Pointer.getPeer(pixs), factor), Pix.class);
    }

    @Ptr
    protected native static long pixExpandBinaryPower2(@Ptr long pixs,
            int factor);

    /**
     * Original signature : <code>PIX* pixReduceBinary2(PIX*, l_uint8*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:157</i>
     */
    public static Pointer<Pix> pixReduceBinary2(Pointer<Pix> pixs,
            Pointer<Byte> intab) {
        return (Pointer) Pointer.pointerToAddress(
                pixReduceBinary2(Pointer.getPeer(pixs), Pointer.getPeer(intab)),
                Pix.class);
    }

    @Ptr
    protected native static long pixReduceBinary2(@Ptr long pixs,
            @Ptr long intab);

    /**
     * Original signature :
     * <code>PIX* pixReduceRankBinaryCascade(PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:158</i>
     */
    public static Pointer<Pix> pixReduceRankBinaryCascade(Pointer<Pix> pixs,
            int level1, int level2, int level3, int level4) {
        return (Pointer) Pointer.pointerToAddress(
                pixReduceRankBinaryCascade(Pointer.getPeer(pixs), level1,
                        level2, level3, level4), Pix.class);
    }

    @Ptr
    protected native static long pixReduceRankBinaryCascade(@Ptr long pixs,
            int level1, int level2, int level3, int level4);

    /**
     * Original signature :
     * <code>PIX* pixReduceRankBinary2(PIX*, l_int32, l_uint8*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:159</i>
     */
    public static Pointer<Pix> pixReduceRankBinary2(Pointer<Pix> pixs,
            int level, Pointer<Byte> intab) {
        return (Pointer) Pointer.pointerToAddress(
                pixReduceRankBinary2(Pointer.getPeer(pixs), level,
                        Pointer.getPeer(intab)), Pix.class);
    }

    @Ptr
    protected native static long pixReduceRankBinary2(@Ptr long pixs,
            int level, @Ptr long intab);

    /**
     * Original signature : <code>l_uint8* makeSubsampleTab2x()</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:160</i>
     */
    public static Pointer<Byte> makeSubsampleTab2x() {
        return (Pointer) Pointer.pointerToAddress(makeSubsampleTab2x$2(),
                Byte.class);
    }

    @Ptr
    @Name("makeSubsampleTab2x")
    protected native static long makeSubsampleTab2x$2() throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixBlend(PIX*, PIX*, l_int32, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:161</i>
     */
    public static Pointer<Pix> pixBlend(Pointer<Pix> pixs1, Pointer<Pix> pixs2,
            int x, int y, float fract) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlend(Pointer.getPeer(pixs1), Pointer.getPeer(pixs2), x, y,
                        fract), Pix.class);
    }

    @Ptr
    protected native static long pixBlend(@Ptr long pixs1, @Ptr long pixs2,
            int x, int y, float fract);

    /**
     * Original signature :
     * <code>PIX* pixBlendMask(PIX*, PIX*, PIX*, l_int32, l_int32, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:162</i>
     */
    public static Pointer<Pix> pixBlendMask(Pointer<Pix> pixd,
            Pointer<Pix> pixs1, Pointer<Pix> pixs2, int x, int y, float fract,
            int type) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlendMask(Pointer.getPeer(pixd), Pointer.getPeer(pixs1),
                        Pointer.getPeer(pixs2), x, y, fract, type), Pix.class);
    }

    @Ptr
    protected native static long pixBlendMask(@Ptr long pixd, @Ptr long pixs1,
            @Ptr long pixs2, int x, int y, float fract, int type);

    /**
     * Original signature :
     * <code>PIX* pixBlendGray(PIX*, PIX*, PIX*, l_int32, l_int32, l_float32, l_int32, l_int32, l_uint32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:163</i>
     */
    public static Pointer<Pix> pixBlendGray(Pointer<Pix> pixd,
            Pointer<Pix> pixs1, Pointer<Pix> pixs2, int x, int y, float fract,
            int type, int transparent, int transpix) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlendGray(Pointer.getPeer(pixd), Pointer.getPeer(pixs1),
                        Pointer.getPeer(pixs2), x, y, fract, type, transparent,
                        transpix), Pix.class);
    }

    @Ptr
    protected native static long pixBlendGray(@Ptr long pixd, @Ptr long pixs1,
            @Ptr long pixs2, int x, int y, float fract, int type,
            int transparent, int transpix);

    /**
     * Original signature :
     * <code>PIX* pixBlendGrayInverse(PIX*, PIX*, PIX*, l_int32, l_int32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:164</i>
     */
    public static Pointer<Pix> pixBlendGrayInverse(Pointer<Pix> pixd,
            Pointer<Pix> pixs1, Pointer<Pix> pixs2, int x, int y, float fract) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlendGrayInverse(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs1), Pointer.getPeer(pixs2), x, y,
                        fract), Pix.class);
    }

    @Ptr
    protected native static long pixBlendGrayInverse(@Ptr long pixd,
            @Ptr long pixs1, @Ptr long pixs2, int x, int y, float fract);

    /**
     * Original signature :
     * <code>PIX* pixBlendColor(PIX*, PIX*, PIX*, l_int32, l_int32, l_float32, l_int32, l_uint32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:165</i>
     */
    public static Pointer<Pix> pixBlendColor(Pointer<Pix> pixd,
            Pointer<Pix> pixs1, Pointer<Pix> pixs2, int x, int y, float fract,
            int transparent, int transpix) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlendColor(Pointer.getPeer(pixd), Pointer.getPeer(pixs1),
                        Pointer.getPeer(pixs2), x, y, fract, transparent,
                        transpix), Pix.class);
    }

    @Ptr
    protected native static long pixBlendColor(@Ptr long pixd, @Ptr long pixs1,
            @Ptr long pixs2, int x, int y, float fract, int transparent,
            int transpix);

    /**
     * Original signature :
     * <code>PIX* pixBlendColorByChannel(PIX*, PIX*, PIX*, l_int32, l_int32, l_float32, l_float32, l_float32, l_int32, l_uint32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:166</i>
     */
    public static Pointer<Pix> pixBlendColorByChannel(Pointer<Pix> pixd,
            Pointer<Pix> pixs1, Pointer<Pix> pixs2, int x, int y, float rfract,
            float gfract, float bfract, int transparent, int transpix) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlendColorByChannel(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs1), Pointer.getPeer(pixs2), x, y,
                        rfract, gfract, bfract, transparent, transpix),
                Pix.class);
    }

    @Ptr
    protected native static long pixBlendColorByChannel(@Ptr long pixd,
            @Ptr long pixs1, @Ptr long pixs2, int x, int y, float rfract,
            float gfract, float bfract, int transparent, int transpix);

    /**
     * Original signature :
     * <code>PIX* pixBlendGrayAdapt(PIX*, PIX*, PIX*, l_int32, l_int32, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:167</i>
     */
    public static Pointer<Pix> pixBlendGrayAdapt(Pointer<Pix> pixd,
            Pointer<Pix> pixs1, Pointer<Pix> pixs2, int x, int y, float fract,
            int shift) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlendGrayAdapt(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs1), Pointer.getPeer(pixs2), x, y,
                        fract, shift), Pix.class);
    }

    @Ptr
    protected native static long pixBlendGrayAdapt(@Ptr long pixd,
            @Ptr long pixs1, @Ptr long pixs2, int x, int y, float fract,
            int shift);

    /**
     * Original signature :
     * <code>PIX* pixFadeWithGray(PIX*, PIX*, l_float32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:168</i>
     */
    public static Pointer<Pix> pixFadeWithGray(Pointer<Pix> pixs,
            Pointer<Pix> pixb, float factor, int type) {
        return (Pointer) Pointer.pointerToAddress(
                pixFadeWithGray(Pointer.getPeer(pixs), Pointer.getPeer(pixb),
                        factor, type), Pix.class);
    }

    @Ptr
    protected native static long pixFadeWithGray(@Ptr long pixs,
            @Ptr long pixb, float factor, int type);

    /**
     * Original signature :
     * <code>PIX* pixBlendHardLight(PIX*, PIX*, PIX*, l_int32, l_int32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:169</i>
     */
    public static Pointer<Pix> pixBlendHardLight(Pointer<Pix> pixd,
            Pointer<Pix> pixs1, Pointer<Pix> pixs2, int x, int y, float fract) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlendHardLight(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs1), Pointer.getPeer(pixs2), x, y,
                        fract), Pix.class);
    }

    @Ptr
    protected native static long pixBlendHardLight(@Ptr long pixd,
            @Ptr long pixs1, @Ptr long pixs2, int x, int y, float fract);

    /**
     * Original signature :
     * <code>l_int32 pixBlendCmap(PIX*, PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:170</i>
     */
    public static int pixBlendCmap(Pointer<Pix> pixs, Pointer<Pix> pixb, int x,
            int y, int sindex) {
        return pixBlendCmap(Pointer.getPeer(pixs), Pointer.getPeer(pixb), x, y,
                sindex);
    }

    protected native static int pixBlendCmap(@Ptr long pixs, @Ptr long pixb,
            int x, int y, int sindex);

    /**
     * Original signature :
     * <code>PIX* pixBlendWithGrayMask(PIX*, PIX*, PIX*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:171</i>
     */
    public static Pointer<Pix> pixBlendWithGrayMask(Pointer<Pix> pixs1,
            Pointer<Pix> pixs2, Pointer<Pix> pixg, int x, int y) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlendWithGrayMask(Pointer.getPeer(pixs1),
                        Pointer.getPeer(pixs2), Pointer.getPeer(pixg), x, y),
                Pix.class);
    }

    @Ptr
    protected native static long pixBlendWithGrayMask(@Ptr long pixs1,
            @Ptr long pixs2, @Ptr long pixg, int x, int y);

    /**
     * Original signature :
     * <code>PIX* pixBlendBackgroundToColor(PIX*, PIX*, BOX*, l_uint32, l_float32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:172</i>
     */
    public static Pointer<Pix> pixBlendBackgroundToColor(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<Box> box, int color, float gamma,
            int minval, int maxval) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlendBackgroundToColor(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), Pointer.getPeer(box), color,
                        gamma, minval, maxval), Pix.class);
    }

    @Ptr
    protected native static long pixBlendBackgroundToColor(@Ptr long pixd,
            @Ptr long pixs, @Ptr long box, int color, float gamma, int minval,
            int maxval);

    /**
     * Original signature :
     * <code>PIX* pixMultiplyByColor(PIX*, PIX*, BOX*, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:173</i>
     */
    public static Pointer<Pix> pixMultiplyByColor(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<Box> box, int color) {
        return (Pointer) Pointer.pointerToAddress(
                pixMultiplyByColor(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), Pointer.getPeer(box), color),
                Pix.class);
    }

    @Ptr
    protected native static long pixMultiplyByColor(@Ptr long pixd,
            @Ptr long pixs, @Ptr long box, int color);

    /**
     * Original signature :
     * <code>PIX* pixAlphaBlendUniform(PIX*, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:174</i>
     */
    public static Pointer<Pix> pixAlphaBlendUniform(Pointer<Pix> pixs, int color) {
        return (Pointer) Pointer.pointerToAddress(
                pixAlphaBlendUniform(Pointer.getPeer(pixs), color), Pix.class);
    }

    @Ptr
    protected native static long pixAlphaBlendUniform(@Ptr long pixs, int color) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixAddAlphaToBlend(PIX*, l_float32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:175</i>
     */
    public static Pointer<Pix> pixAddAlphaToBlend(Pointer<Pix> pixs,
            float fract, int invert) {
        return (Pointer) Pointer.pointerToAddress(
                pixAddAlphaToBlend(Pointer.getPeer(pixs), fract, invert),
                Pix.class);
    }

    @Ptr
    protected native static long pixAddAlphaToBlend(@Ptr long pixs,
            float fract, int invert);

    /**
     * Original signature : <code>PIX* pixSetAlphaOverWhite(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:176</i>
     */
    public static Pointer<Pix> pixSetAlphaOverWhite(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixSetAlphaOverWhite(Pointer.getPeer(pixs)), Pix.class);
    }

    @Ptr
    protected native static long pixSetAlphaOverWhite(@Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>L_BMF* bmfCreate(const char*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:177</i>
     */
    public static Pointer<L_Bmf> bmfCreate(Pointer<Byte> dir, int size) {
        return (Pointer) Pointer.pointerToAddress(
                bmfCreate(Pointer.getPeer(dir), size), L_Bmf.class);
    }

    @Ptr
    protected native static long bmfCreate(@Ptr long dir, int size) throws LastError;

    /**
     * Original signature : <code>void bmfDestroy(L_BMF**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:178</i>
     */
    public static void bmfDestroy(Pointer<Pointer<L_Bmf>> pbmf) {
        bmfDestroy(Pointer.getPeer(pbmf));
    }

    protected native static void bmfDestroy(@Ptr long pbmf) throws LastError;

    /**
     * Original signature : <code>PIX* bmfGetPix(L_BMF*, char)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:179</i>
     */
    public static Pointer<Pix> bmfGetPix(Pointer<L_Bmf> bmf, byte chr) {
        return (Pointer) Pointer.pointerToAddress(
                bmfGetPix(Pointer.getPeer(bmf), chr), Pix.class);
    }

    @Ptr
    protected native static long bmfGetPix(@Ptr long bmf, byte chr) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 bmfGetWidth(L_BMF*, char, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:180</i>
     */
    public static int bmfGetWidth(Pointer<L_Bmf> bmf, byte chr,
            Pointer<Integer> pw) {
        return bmfGetWidth(Pointer.getPeer(bmf), chr, Pointer.getPeer(pw));
    }

    protected native static int bmfGetWidth(@Ptr long bmf, byte chr,
            @Ptr long pw);

    /**
     * Original signature :
     * <code>l_int32 bmfGetBaseline(L_BMF*, char, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:181</i>
     */
    public static int bmfGetBaseline(Pointer<L_Bmf> bmf, byte chr,
            Pointer<Integer> pbaseline) {
        return bmfGetBaseline(Pointer.getPeer(bmf), chr,
                Pointer.getPeer(pbaseline));
    }

    protected native static int bmfGetBaseline(@Ptr long bmf, byte chr,
            @Ptr long pbaseline);

    /**
     * Original signature :
     * <code>PIXA* pixaGetFont(const char*, l_int32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:182</i>
     */
    public static Pointer<Pixa> pixaGetFont(Pointer<Byte> dir, int size,
            Pointer<Integer> pbl0, Pointer<Integer> pbl1, Pointer<Integer> pbl2) {
        return (Pointer) Pointer.pointerToAddress(
                pixaGetFont(Pointer.getPeer(dir), size, Pointer.getPeer(pbl0),
                        Pointer.getPeer(pbl1), Pointer.getPeer(pbl2)),
                Pixa.class);
    }

    @Ptr
    protected native static long pixaGetFont(@Ptr long dir, int size,
            @Ptr long pbl0, @Ptr long pbl1, @Ptr long pbl2);

    /**
     * Original signature :
     * <code>l_int32 pixaSaveFont(const char*, const char*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:183</i>
     */
    public static int pixaSaveFont(Pointer<Byte> indir, Pointer<Byte> outdir,
            int size) {
        return pixaSaveFont(Pointer.getPeer(indir), Pointer.getPeer(outdir),
                size);
    }

    protected native static int pixaSaveFont(@Ptr long indir, @Ptr long outdir,
            int size);

    /**
     * Original signature :
     * <code>PIXA* pixaGenerateFont(const char*, l_int32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:184</i>
     */
    public static Pointer<Pixa> pixaGenerateFont(Pointer<Byte> dir, int size,
            Pointer<Integer> pbl0, Pointer<Integer> pbl1, Pointer<Integer> pbl2) {
        return (Pointer) Pointer.pointerToAddress(
                pixaGenerateFont(Pointer.getPeer(dir), size,
                        Pointer.getPeer(pbl0), Pointer.getPeer(pbl1),
                        Pointer.getPeer(pbl2)), Pixa.class);
    }

    @Ptr
    protected native static long pixaGenerateFont(@Ptr long dir, int size,
            @Ptr long pbl0, @Ptr long pbl1, @Ptr long pbl2);

    /**
     * Original signature : <code>PIX* pixReadStreamBmp(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:185</i>
     */
    public static Pointer<Pix> pixReadStreamBmp(
            Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                pixReadStreamBmp(Pointer.getPeer(fp)), Pix.class);
    }

    @Ptr
    protected native static long pixReadStreamBmp(@Ptr long fp) throws LastError;

    /**
     * Original signature : <code>l_int32 pixWriteStreamBmp(FILE*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:186</i>
     */
    public static int pixWriteStreamBmp(Pointer<FILE> fp,
            Pointer<Pix> pix) {
        return pixWriteStreamBmp(Pointer.getPeer(fp), Pointer.getPeer(pix));
    }

    protected native static int pixWriteStreamBmp(@Ptr long fp, @Ptr long pix) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixReadMemBmp(const l_uint8*, size_t)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:187</i>
     */
    public static Pointer<Pix> pixReadMemBmp(Pointer<Byte> cdata, @Ptr long size) {
        return (Pointer) Pointer.pointerToAddress(
                pixReadMemBmp(Pointer.getPeer(cdata), size), Pix.class);
    }

    @Ptr
    protected native static long pixReadMemBmp(@Ptr long cdata, @Ptr long size) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixWriteMemBmp(l_uint8**, size_t*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:188</i>
     */
    public static int pixWriteMemBmp(Pointer<Pointer<Byte>> pdata,
            Pointer<SizeT> psize, Pointer<Pix> pix) {
        return pixWriteMemBmp(Pointer.getPeer(pdata), Pointer.getPeer(psize),
                Pointer.getPeer(pix));
    }

    protected native static int pixWriteMemBmp(@Ptr long pdata,
            @Ptr long psize, @Ptr long pix);

    /**
     * Original signature :
     * <code>BOX* boxCreate(l_int32, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:189</i>
     */
    public static Pointer<Box> boxCreate(int x, int y, int w, int h) {
        return (Pointer) Pointer.pointerToAddress(boxCreate$2(x, y, w, h),
                Box.class);
    }

    @Ptr
    @Name("boxCreate")
    protected native static long boxCreate$2(int x, int y, int w, int h) throws LastError;

    /**
     * Original signature :
     * <code>BOX* boxCreateValid(l_int32, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:190</i>
     */
    public static Pointer<Box> boxCreateValid(int x, int y, int w, int h) {
        return (Pointer) Pointer.pointerToAddress(boxCreateValid$2(x, y, w, h),
                Box.class);
    }

    @Ptr
    @Name("boxCreateValid")
    protected native static long boxCreateValid$2(int x, int y, int w, int h) throws LastError;

    /**
     * Original signature : <code>BOX* boxCopy(BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:191</i>
     */
    public static Pointer<Box> boxCopy(Pointer<Box> box) {
        return (Pointer) Pointer.pointerToAddress(
                boxCopy(Pointer.getPeer(box)), Box.class);
    }

    @Ptr
    protected native static long boxCopy(@Ptr long box) throws LastError;

    /**
     * Original signature : <code>BOX* boxClone(BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:192</i>
     */
    public static Pointer<Box> boxClone(Pointer<Box> box) {
        return (Pointer) Pointer.pointerToAddress(
                boxClone(Pointer.getPeer(box)), Box.class);
    }

    @Ptr
    protected native static long boxClone(@Ptr long box) throws LastError;

    /**
     * Original signature : <code>void boxDestroy(BOX**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:193</i>
     */
    public static void boxDestroy(Pointer<Pointer<Box>> pbox) {
        boxDestroy(Pointer.getPeer(pbox));
    }

    protected native static void boxDestroy(@Ptr long pbox) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxGetGeometry(BOX*, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:194</i>
     */
    public static int boxGetGeometry(Pointer<Box> box, Pointer<Integer> px,
            Pointer<Integer> py, Pointer<Integer> pw, Pointer<Integer> ph) {
        return boxGetGeometry(Pointer.getPeer(box), Pointer.getPeer(px),
                Pointer.getPeer(py), Pointer.getPeer(pw), Pointer.getPeer(ph));
    }

    protected native static int boxGetGeometry(@Ptr long box, @Ptr long px,
            @Ptr long py, @Ptr long pw, @Ptr long ph);

    /**
     * Original signature :
     * <code>l_int32 boxSetGeometry(BOX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:195</i>
     */
    public static int boxSetGeometry(Pointer<Box> box, int x, int y, int w,
            int h) {
        return boxSetGeometry(Pointer.getPeer(box), x, y, w, h);
    }

    protected native static int boxSetGeometry(@Ptr long box, int x, int y,
            int w, int h);

    /**
     * Original signature :
     * <code>l_int32 boxGetSideLocation(BOX*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:196</i>
     */
    public static int boxGetSideLocation(Pointer<Box> box, int side,
            Pointer<Integer> ploc) {
        return boxGetSideLocation(Pointer.getPeer(box), side,
                Pointer.getPeer(ploc));
    }

    protected native static int boxGetSideLocation(@Ptr long box, int side,
            @Ptr long ploc);

    /**
     * Original signature : <code>l_int32 boxGetRefcount(BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:197</i>
     */
    public static int boxGetRefcount(Pointer<Box> box) {
        return boxGetRefcount(Pointer.getPeer(box));
    }

    protected native static int boxGetRefcount(@Ptr long box) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxChangeRefcount(BOX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:198</i>
     */
    public static int boxChangeRefcount(Pointer<Box> box, int delta) {
        return boxChangeRefcount(Pointer.getPeer(box), delta);
    }

    protected native static int boxChangeRefcount(@Ptr long box, int delta) throws LastError;

    /**
     * Original signature : <code>l_int32 boxIsValid(BOX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:199</i>
     */
    public static int boxIsValid(Pointer<Box> box, Pointer<Integer> pvalid) {
        return boxIsValid(Pointer.getPeer(box), Pointer.getPeer(pvalid));
    }

    protected native static int boxIsValid(@Ptr long box, @Ptr long pvalid) throws LastError;

    /**
     * Original signature : <code>BOXA* boxaCreate(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:200</i>
     */
    public static Pointer<Boxa> boxaCreate(int n) {
        return (Pointer) Pointer.pointerToAddress(boxaCreate$2(n), Boxa.class);
    }

    @Ptr
    @Name("boxaCreate")
    protected native static long boxaCreate$2(int n) throws LastError;

    /**
     * Original signature : <code>BOXA* boxaCopy(BOXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:201</i>
     */
    public static Pointer<Boxa> boxaCopy(Pointer<Boxa> boxa, int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxaCopy(Pointer.getPeer(boxa), copyflag), Boxa.class);
    }

    @Ptr
    protected native static long boxaCopy(@Ptr long boxa, int copyflag) throws LastError;

    /**
     * Original signature : <code>void boxaDestroy(BOXA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:202</i>
     */
    public static void boxaDestroy(Pointer<Pointer<Boxa>> pboxa) {
        boxaDestroy(Pointer.getPeer(pboxa));
    }

    protected native static void boxaDestroy(@Ptr long pboxa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxaAddBox(BOXA*, BOX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:203</i>
     */
    public static int boxaAddBox(Pointer<Boxa> boxa, Pointer<Box> box,
            int copyflag) {
        return boxaAddBox(Pointer.getPeer(boxa), Pointer.getPeer(box), copyflag);
    }

    protected native static int boxaAddBox(@Ptr long boxa, @Ptr long box,
            int copyflag);

    /**
     * Original signature : <code>l_int32 boxaExtendArray(BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:204</i>
     */
    public static int boxaExtendArray(Pointer<Boxa> boxa) {
        return boxaExtendArray(Pointer.getPeer(boxa));
    }

    protected native static int boxaExtendArray(@Ptr long boxa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxaExtendArrayToSize(BOXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:205</i>
     */
    public static int boxaExtendArrayToSize(Pointer<Boxa> boxa, int size) {
        return boxaExtendArrayToSize(Pointer.getPeer(boxa), size);
    }

    protected native static int boxaExtendArrayToSize(@Ptr long boxa, int size) throws LastError;

    /**
     * Original signature : <code>l_int32 boxaGetCount(BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:206</i>
     */
    public static int boxaGetCount(Pointer<Boxa> boxa) {
        return boxaGetCount(Pointer.getPeer(boxa));
    }

    protected native static int boxaGetCount(@Ptr long boxa) throws LastError;

    /**
     * Original signature : <code>l_int32 boxaGetValidCount(BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:207</i>
     */
    public static int boxaGetValidCount(Pointer<Boxa> boxa) {
        return boxaGetValidCount(Pointer.getPeer(boxa));
    }

    protected native static int boxaGetValidCount(@Ptr long boxa) throws LastError;

    /**
     * Original signature :
     * <code>BOX* boxaGetBox(BOXA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:208</i>
     */
    public static Pointer<Box> boxaGetBox(Pointer<Boxa> boxa, int index,
            int accessflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxaGetBox(Pointer.getPeer(boxa), index, accessflag), Box.class);
    }

    @Ptr
    protected native static long boxaGetBox(@Ptr long boxa, int index,
            int accessflag);

    /**
     * Original signature :
     * <code>BOX* boxaGetValidBox(BOXA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:209</i>
     */
    public static Pointer<Box> boxaGetValidBox(Pointer<Boxa> boxa, int index,
            int accessflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxaGetValidBox(Pointer.getPeer(boxa), index, accessflag),
                Box.class);
    }

    @Ptr
    protected native static long boxaGetValidBox(@Ptr long boxa, int index,
            int accessflag);

    /**
     * Original signature :
     * <code>l_int32 boxaGetBoxGeometry(BOXA*, l_int32, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:210</i>
     */
    public static int boxaGetBoxGeometry(Pointer<Boxa> boxa, int index,
            Pointer<Integer> px, Pointer<Integer> py, Pointer<Integer> pw,
            Pointer<Integer> ph) {
        return boxaGetBoxGeometry(Pointer.getPeer(boxa), index,
                Pointer.getPeer(px), Pointer.getPeer(py), Pointer.getPeer(pw),
                Pointer.getPeer(ph));
    }

    protected native static int boxaGetBoxGeometry(@Ptr long boxa, int index,
            @Ptr long px, @Ptr long py, @Ptr long pw, @Ptr long ph);

    /**
     * Original signature : <code>l_int32 boxaIsFull(BOXA*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:211</i>
     */
    public static int boxaIsFull(Pointer<Boxa> boxa, Pointer<Integer> pfull) {
        return boxaIsFull(Pointer.getPeer(boxa), Pointer.getPeer(pfull));
    }

    protected native static int boxaIsFull(@Ptr long boxa, @Ptr long pfull) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxaReplaceBox(BOXA*, l_int32, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:212</i>
     */
    public static int boxaReplaceBox(Pointer<Boxa> boxa, int index,
            Pointer<Box> box) {
        return boxaReplaceBox(Pointer.getPeer(boxa), index,
                Pointer.getPeer(box));
    }

    protected native static int boxaReplaceBox(@Ptr long boxa, int index,
            @Ptr long box);

    /**
     * Original signature :
     * <code>l_int32 boxaInsertBox(BOXA*, l_int32, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:213</i>
     */
    public static int boxaInsertBox(Pointer<Boxa> boxa, int index,
            Pointer<Box> box) {
        return boxaInsertBox(Pointer.getPeer(boxa), index, Pointer.getPeer(box));
    }

    protected native static int boxaInsertBox(@Ptr long boxa, int index,
            @Ptr long box);

    /**
     * Original signature : <code>l_int32 boxaRemoveBox(BOXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:214</i>
     */
    public static int boxaRemoveBox(Pointer<Boxa> boxa, int index) {
        return boxaRemoveBox(Pointer.getPeer(boxa), index);
    }

    protected native static int boxaRemoveBox(@Ptr long boxa, int index) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxaRemoveBoxAndSave(BOXA*, l_int32, BOX**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:215</i>
     */
    public static int boxaRemoveBoxAndSave(Pointer<Boxa> boxa, int index,
            Pointer<Pointer<Box>> pbox) {
        return boxaRemoveBoxAndSave(Pointer.getPeer(boxa), index,
                Pointer.getPeer(pbox));
    }

    protected native static int boxaRemoveBoxAndSave(@Ptr long boxa, int index,
            @Ptr long pbox);

    /**
     * Original signature : <code>l_int32 boxaInitFull(BOXA*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:216</i>
     */
    public static int boxaInitFull(Pointer<Boxa> boxa, Pointer<Box> box) {
        return boxaInitFull(Pointer.getPeer(boxa), Pointer.getPeer(box));
    }

    protected native static int boxaInitFull(@Ptr long boxa, @Ptr long box) throws LastError;

    /**
     * Original signature : <code>l_int32 boxaClear(BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:217</i>
     */
    public static int boxaClear(Pointer<Boxa> boxa) {
        return boxaClear(Pointer.getPeer(boxa));
    }

    protected native static int boxaClear(@Ptr long boxa) throws LastError;

    /**
     * Original signature : <code>BOXAA* boxaaCreate(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:218</i>
     */
    public static Pointer<Boxaa> boxaaCreate(int n) {
        return (Pointer) Pointer.pointerToAddress(boxaaCreate$2(n), Boxaa.class);
    }

    @Ptr
    @Name("boxaaCreate")
    protected native static long boxaaCreate$2(int n) throws LastError;

    /**
     * Original signature : <code>BOXAA* boxaaCopy(BOXAA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:219</i>
     */
    public static Pointer<Boxaa> boxaaCopy(Pointer<Boxaa> baas, int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxaaCopy(Pointer.getPeer(baas), copyflag), Boxaa.class);
    }

    @Ptr
    protected native static long boxaaCopy(@Ptr long baas, int copyflag) throws LastError;

    /**
     * Original signature : <code>void boxaaDestroy(BOXAA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:220</i>
     */
    public static void boxaaDestroy(Pointer<Pointer<Boxaa>> pbaa) {
        boxaaDestroy(Pointer.getPeer(pbaa));
    }

    protected native static void boxaaDestroy(@Ptr long pbaa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxaaAddBoxa(BOXAA*, BOXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:221</i>
     */
    public static int boxaaAddBoxa(Pointer<Boxaa> baa, Pointer<Boxa> ba,
            int copyflag) {
        return boxaaAddBoxa(Pointer.getPeer(baa), Pointer.getPeer(ba), copyflag);
    }

    protected native static int boxaaAddBoxa(@Ptr long baa, @Ptr long ba,
            int copyflag);

    /**
     * Original signature : <code>l_int32 boxaaExtendArray(BOXAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:222</i>
     */
    public static int boxaaExtendArray(Pointer<Boxaa> baa) {
        return boxaaExtendArray(Pointer.getPeer(baa));
    }

    protected native static int boxaaExtendArray(@Ptr long baa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxaaExtendArrayToSize(BOXAA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:223</i>
     */
    public static int boxaaExtendArrayToSize(Pointer<Boxaa> baa, int size) {
        return boxaaExtendArrayToSize(Pointer.getPeer(baa), size);
    }

    protected native static int boxaaExtendArrayToSize(@Ptr long baa, int size) throws LastError;

    /**
     * Original signature : <code>l_int32 boxaaGetCount(BOXAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:224</i>
     */
    public static int boxaaGetCount(Pointer<Boxaa> baa) {
        return boxaaGetCount(Pointer.getPeer(baa));
    }

    protected native static int boxaaGetCount(@Ptr long baa) throws LastError;

    /**
     * Original signature : <code>l_int32 boxaaGetBoxCount(BOXAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:225</i>
     */
    public static int boxaaGetBoxCount(Pointer<Boxaa> baa) {
        return boxaaGetBoxCount(Pointer.getPeer(baa));
    }

    protected native static int boxaaGetBoxCount(@Ptr long baa) throws LastError;

    /**
     * Original signature :
     * <code>BOXA* boxaaGetBoxa(BOXAA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:226</i>
     */
    public static Pointer<Boxa> boxaaGetBoxa(Pointer<Boxaa> baa, int index,
            int accessflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxaaGetBoxa(Pointer.getPeer(baa), index, accessflag),
                Boxa.class);
    }

    @Ptr
    protected native static long boxaaGetBoxa(@Ptr long baa, int index,
            int accessflag);

    /**
     * Original signature :
     * <code>BOX* boxaaGetBox(BOXAA*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:227</i>
     */
    public static Pointer<Box> boxaaGetBox(Pointer<Boxaa> baa, int iboxa,
            int ibox, int accessflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxaaGetBox(Pointer.getPeer(baa), iboxa, ibox, accessflag),
                Box.class);
    }

    @Ptr
    protected native static long boxaaGetBox(@Ptr long baa, int iboxa,
            int ibox, int accessflag);

    /**
     * Original signature : <code>l_int32 boxaaInitFull(BOXAA*, BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:228</i>
     */
    public static int boxaaInitFull(Pointer<Boxaa> baa, Pointer<Boxa> boxa) {
        return boxaaInitFull(Pointer.getPeer(baa), Pointer.getPeer(boxa));
    }

    protected native static int boxaaInitFull(@Ptr long baa, @Ptr long boxa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxaaExtendWithInit(BOXAA*, l_int32, BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:229</i>
     */
    public static int boxaaExtendWithInit(Pointer<Boxaa> baa, int maxindex,
            Pointer<Boxa> boxa) {
        return boxaaExtendWithInit(Pointer.getPeer(baa), maxindex,
                Pointer.getPeer(boxa));
    }

    protected native static int boxaaExtendWithInit(@Ptr long baa,
            int maxindex, @Ptr long boxa);

    /**
     * Original signature :
     * <code>l_int32 boxaaReplaceBoxa(BOXAA*, l_int32, BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:230</i>
     */
    public static int boxaaReplaceBoxa(Pointer<Boxaa> baa, int index,
            Pointer<Boxa> boxa) {
        return boxaaReplaceBoxa(Pointer.getPeer(baa), index,
                Pointer.getPeer(boxa));
    }

    protected native static int boxaaReplaceBoxa(@Ptr long baa, int index,
            @Ptr long boxa);

    /**
     * Original signature :
     * <code>l_int32 boxaaInsertBoxa(BOXAA*, l_int32, BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:231</i>
     */
    public static int boxaaInsertBoxa(Pointer<Boxaa> baa, int index,
            Pointer<Boxa> boxa) {
        return boxaaInsertBoxa(Pointer.getPeer(baa), index,
                Pointer.getPeer(boxa));
    }

    protected native static int boxaaInsertBoxa(@Ptr long baa, int index,
            @Ptr long boxa);

    /**
     * Original signature :
     * <code>l_int32 boxaaRemoveBoxa(BOXAA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:232</i>
     */
    public static int boxaaRemoveBoxa(Pointer<Boxaa> baa, int index) {
        return boxaaRemoveBoxa(Pointer.getPeer(baa), index);
    }

    protected native static int boxaaRemoveBoxa(@Ptr long baa, int index) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxaaAddBox(BOXAA*, l_int32, BOX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:233</i>
     */
    public static int boxaaAddBox(Pointer<Boxaa> baa, int index,
            Pointer<Box> box, int accessflag) {
        return boxaaAddBox(Pointer.getPeer(baa), index, Pointer.getPeer(box),
                accessflag);
    }

    protected native static int boxaaAddBox(@Ptr long baa, int index,
            @Ptr long box, int accessflag);

    /**
     * Original signature :
     * <code>BOXAA* boxaaReadFromFiles(const char*, const char*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:234</i>
     */
    public static Pointer<Boxaa> boxaaReadFromFiles(Pointer<Byte> dirname,
            Pointer<Byte> substr, int first, int nfiles) {
        return (Pointer) Pointer.pointerToAddress(
                boxaaReadFromFiles(Pointer.getPeer(dirname),
                        Pointer.getPeer(substr), first, nfiles), Boxaa.class);
    }

    @Ptr
    protected native static long boxaaReadFromFiles(@Ptr long dirname,
            @Ptr long substr, int first, int nfiles);

    /**
     * Original signature : <code>BOXAA* boxaaRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:235</i>
     */
    public static Pointer<Boxaa> boxaaRead(Pointer<Byte> filename) {
        return (Pointer) Pointer.pointerToAddress(
                boxaaRead(Pointer.getPeer(filename)), Boxaa.class);
    }

    @Ptr
    protected native static long boxaaRead(@Ptr long filename) throws LastError;

    /**
     * Original signature : <code>BOXAA* boxaaReadStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:236</i>
     */
    public static Pointer<Boxaa> boxaaReadStream(
            Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                boxaaReadStream(Pointer.getPeer(fp)), Boxaa.class);
    }

    @Ptr
    protected native static long boxaaReadStream(@Ptr long fp) throws LastError;

    /**
     * Original signature : <code>l_int32 boxaaWrite(const char*, BOXAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:237</i>
     */
    public static int boxaaWrite(Pointer<Byte> filename, Pointer<Boxaa> baa) {
        return boxaaWrite(Pointer.getPeer(filename), Pointer.getPeer(baa));
    }

    protected native static int boxaaWrite(@Ptr long filename, @Ptr long baa) throws LastError;

    /**
     * Original signature : <code>l_int32 boxaaWriteStream(FILE*, BOXAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:238</i>
     */
    public static int boxaaWriteStream(Pointer<FILE> fp,
            Pointer<Boxaa> baa) {
        return boxaaWriteStream(Pointer.getPeer(fp), Pointer.getPeer(baa));
    }

    protected native static int boxaaWriteStream(@Ptr long fp, @Ptr long baa) throws LastError;

    /**
     * Original signature : <code>BOXA* boxaRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:239</i>
     */
    public static Pointer<Boxa> boxaRead(Pointer<Byte> filename) {
        return (Pointer) Pointer.pointerToAddress(
                boxaRead(Pointer.getPeer(filename)), Boxa.class);
    }

    @Ptr
    protected native static long boxaRead(@Ptr long filename) throws LastError;

    /**
     * Original signature : <code>BOXA* boxaReadStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:240</i>
     */
    public static Pointer<Boxa> boxaReadStream(Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                boxaReadStream(Pointer.getPeer(fp)), Boxa.class);
    }

    @Ptr
    protected native static long boxaReadStream(@Ptr long fp) throws LastError;

    /**
     * Original signature :
     * <code>BOXA* boxaReadMem(const l_uint8*, size_t)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:241</i>
     */
    public static Pointer<Boxa> boxaReadMem(Pointer<Byte> data, @Ptr long size) {
        return (Pointer) Pointer.pointerToAddress(
                boxaReadMem(Pointer.getPeer(data), size), Boxa.class);
    }

    @Ptr
    protected native static long boxaReadMem(@Ptr long data, @Ptr long size) throws LastError;

    /**
     * Original signature : <code>l_int32 boxaWrite(const char*, BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:242</i>
     */
    public static int boxaWrite(Pointer<Byte> filename, Pointer<Boxa> boxa) {
        return boxaWrite(Pointer.getPeer(filename), Pointer.getPeer(boxa));
    }

    protected native static int boxaWrite(@Ptr long filename, @Ptr long boxa) throws LastError;

    /**
     * Original signature : <code>l_int32 boxaWriteStream(FILE*, BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:243</i>
     */
    public static int boxaWriteStream(Pointer<FILE> fp,
            Pointer<Boxa> boxa) {
        return boxaWriteStream(Pointer.getPeer(fp), Pointer.getPeer(boxa));
    }

    protected native static int boxaWriteStream(@Ptr long fp, @Ptr long boxa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxaWriteMem(l_uint8**, size_t*, BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:244</i>
     */
    public static int boxaWriteMem(Pointer<Pointer<Byte>> pdata,
            Pointer<SizeT> psize, Pointer<Boxa> boxa) {
        return boxaWriteMem(Pointer.getPeer(pdata), Pointer.getPeer(psize),
                Pointer.getPeer(boxa));
    }

    protected native static int boxaWriteMem(@Ptr long pdata, @Ptr long psize,
            @Ptr long boxa);

    /**
     * Original signature : <code>l_int32 boxPrintStreamInfo(FILE*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:245</i>
     */
    public static int boxPrintStreamInfo(Pointer<FILE> fp,
            Pointer<Box> box) {
        return boxPrintStreamInfo(Pointer.getPeer(fp), Pointer.getPeer(box));
    }

    protected native static int boxPrintStreamInfo(@Ptr long fp, @Ptr long box) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxContains(BOX*, BOX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:246</i>
     */
    public static int boxContains(Pointer<Box> box1, Pointer<Box> box2,
            Pointer<Integer> presult) {
        return boxContains(Pointer.getPeer(box1), Pointer.getPeer(box2),
                Pointer.getPeer(presult));
    }

    protected native static int boxContains(@Ptr long box1, @Ptr long box2,
            @Ptr long presult);

    /**
     * Original signature :
     * <code>l_int32 boxIntersects(BOX*, BOX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:247</i>
     */
    public static int boxIntersects(Pointer<Box> box1, Pointer<Box> box2,
            Pointer<Integer> presult) {
        return boxIntersects(Pointer.getPeer(box1), Pointer.getPeer(box2),
                Pointer.getPeer(presult));
    }

    protected native static int boxIntersects(@Ptr long box1, @Ptr long box2,
            @Ptr long presult);

    /**
     * Original signature : <code>BOXA* boxaContainedInBox(BOXA*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:248</i>
     */
    public static Pointer<Boxa> boxaContainedInBox(Pointer<Boxa> boxas,
            Pointer<Box> box) {
        return (Pointer) Pointer.pointerToAddress(
                boxaContainedInBox(Pointer.getPeer(boxas), Pointer.getPeer(box)),
                Boxa.class);
    }

    @Ptr
    protected native static long boxaContainedInBox(@Ptr long boxas,
            @Ptr long box);

    /**
     * Original signature : <code>BOXA* boxaIntersectsBox(BOXA*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:249</i>
     */
    public static Pointer<Boxa> boxaIntersectsBox(Pointer<Boxa> boxas,
            Pointer<Box> box) {
        return (Pointer) Pointer.pointerToAddress(
                boxaIntersectsBox(Pointer.getPeer(boxas), Pointer.getPeer(box)),
                Boxa.class);
    }

    @Ptr
    protected native static long boxaIntersectsBox(@Ptr long boxas,
            @Ptr long box);

    /**
     * Original signature : <code>BOXA* boxaClipToBox(BOXA*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:250</i>
     */
    public static Pointer<Boxa> boxaClipToBox(Pointer<Boxa> boxas,
            Pointer<Box> box) {
        return (Pointer) Pointer.pointerToAddress(
                boxaClipToBox(Pointer.getPeer(boxas), Pointer.getPeer(box)),
                Boxa.class);
    }

    @Ptr
    protected native static long boxaClipToBox(@Ptr long boxas, @Ptr long box) throws LastError;

    /**
     * Original signature : <code>BOXA* boxaCombineOverlaps(BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:251</i>
     */
    public static Pointer<Boxa> boxaCombineOverlaps(Pointer<Boxa> boxas) {
        return (Pointer) Pointer.pointerToAddress(
                boxaCombineOverlaps(Pointer.getPeer(boxas)), Boxa.class);
    }

    @Ptr
    protected native static long boxaCombineOverlaps(@Ptr long boxas) throws LastError;

    /**
     * Original signature : <code>BOX* boxOverlapRegion(BOX*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:252</i>
     */
    public static Pointer<Box> boxOverlapRegion(Pointer<Box> box1,
            Pointer<Box> box2) {
        return (Pointer) Pointer.pointerToAddress(
                boxOverlapRegion(Pointer.getPeer(box1), Pointer.getPeer(box2)),
                Box.class);
    }

    @Ptr
    protected native static long boxOverlapRegion(@Ptr long box1, @Ptr long box2) throws LastError;

    /**
     * Original signature : <code>BOX* boxBoundingRegion(BOX*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:253</i>
     */
    public static Pointer<Box> boxBoundingRegion(Pointer<Box> box1,
            Pointer<Box> box2) {
        return (Pointer) Pointer.pointerToAddress(
                boxBoundingRegion(Pointer.getPeer(box1), Pointer.getPeer(box2)),
                Box.class);
    }

    @Ptr
    protected native static long boxBoundingRegion(@Ptr long box1,
            @Ptr long box2);

    /**
     * Original signature :
     * <code>l_int32 boxOverlapFraction(BOX*, BOX*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:254</i>
     */
    public static int boxOverlapFraction(Pointer<Box> box1, Pointer<Box> box2,
            Pointer<Float> pfract) {
        return boxOverlapFraction(Pointer.getPeer(box1), Pointer.getPeer(box2),
                Pointer.getPeer(pfract));
    }

    protected native static int boxOverlapFraction(@Ptr long box1,
            @Ptr long box2, @Ptr long pfract);

    /**
     * Original signature :
     * <code>l_int32 boxOverlapArea(BOX*, BOX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:255</i>
     */
    public static int boxOverlapArea(Pointer<Box> box1, Pointer<Box> box2,
            Pointer<Integer> parea) {
        return boxOverlapArea(Pointer.getPeer(box1), Pointer.getPeer(box2),
                Pointer.getPeer(parea));
    }

    protected native static int boxOverlapArea(@Ptr long box1, @Ptr long box2,
            @Ptr long parea);

    /**
     * Original signature :
     * <code>BOXA* boxaHandleOverlaps(BOXA*, l_int32, l_int32, l_float32, l_float32, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:256</i>
     */
    public static Pointer<Boxa> boxaHandleOverlaps(Pointer<Boxa> boxas, int op,
            int range, float min_overlap, float max_ratio,
            Pointer<Pointer<Numa>> pnamap) {
        return (Pointer) Pointer.pointerToAddress(
                boxaHandleOverlaps(Pointer.getPeer(boxas), op, range,
                        min_overlap, max_ratio, Pointer.getPeer(pnamap)),
                Boxa.class);
    }

    @Ptr
    protected native static long boxaHandleOverlaps(@Ptr long boxas, int op,
            int range, float min_overlap, float max_ratio, @Ptr long pnamap);

    /**
     * Original signature :
     * <code>l_int32 boxSeparationDistance(BOX*, BOX*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:257</i>
     */
    public static int boxSeparationDistance(Pointer<Box> box1,
            Pointer<Box> box2, Pointer<Integer> ph_sep, Pointer<Integer> pv_sep) {
        return boxSeparationDistance(Pointer.getPeer(box1),
                Pointer.getPeer(box2), Pointer.getPeer(ph_sep),
                Pointer.getPeer(pv_sep));
    }

    protected native static int boxSeparationDistance(@Ptr long box1,
            @Ptr long box2, @Ptr long ph_sep, @Ptr long pv_sep);

    /**
     * Original signature :
     * <code>l_int32 boxContainsPt(BOX*, l_float32, l_float32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:258</i>
     */
    public static int boxContainsPt(Pointer<Box> box, float x, float y,
            Pointer<Integer> pcontains) {
        return boxContainsPt(Pointer.getPeer(box), x, y,
                Pointer.getPeer(pcontains));
    }

    protected native static int boxContainsPt(@Ptr long box, float x, float y,
            @Ptr long pcontains);

    /**
     * Original signature :
     * <code>BOX* boxaGetNearestToPt(BOXA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:259</i>
     */
    public static Pointer<Box> boxaGetNearestToPt(Pointer<Boxa> boxa, int x,
            int y) {
        return (Pointer) Pointer.pointerToAddress(
                boxaGetNearestToPt(Pointer.getPeer(boxa), x, y), Box.class);
    }

    @Ptr
    protected native static long boxaGetNearestToPt(@Ptr long boxa, int x, int y) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxGetCenter(BOX*, l_float32*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:260</i>
     */
    public static int boxGetCenter(Pointer<Box> box, Pointer<Float> pcx,
            Pointer<Float> pcy) {
        return boxGetCenter(Pointer.getPeer(box), Pointer.getPeer(pcx),
                Pointer.getPeer(pcy));
    }

    protected native static int boxGetCenter(@Ptr long box, @Ptr long pcx,
            @Ptr long pcy);

    /**
     * Original signature :
     * <code>l_int32 boxIntersectByLine(BOX*, l_int32, l_int32, l_float32, l_int32*, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:261</i>
     */
    public static int boxIntersectByLine(Pointer<Box> box, int x, int y,
            float slope, Pointer<Integer> px1, Pointer<Integer> py1,
            Pointer<Integer> px2, Pointer<Integer> py2, Pointer<Integer> pn) {
        return boxIntersectByLine(Pointer.getPeer(box), x, y, slope,
                Pointer.getPeer(px1), Pointer.getPeer(py1),
                Pointer.getPeer(px2), Pointer.getPeer(py2), Pointer.getPeer(pn));
    }

    protected native static int boxIntersectByLine(@Ptr long box, int x, int y,
            float slope, @Ptr long px1, @Ptr long py1, @Ptr long px2,
            @Ptr long py2, @Ptr long pn);

    /**
     * Original signature :
     * <code>BOX* boxClipToRectangle(BOX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:262</i>
     */
    public static Pointer<Box> boxClipToRectangle(Pointer<Box> box, int wi,
            int hi) {
        return (Pointer) Pointer.pointerToAddress(
                boxClipToRectangle(Pointer.getPeer(box), wi, hi), Box.class);
    }

    @Ptr
    protected native static long boxClipToRectangle(@Ptr long box, int wi,
            int hi);

    /**
     * Original signature :
     * <code>l_int32 boxClipToRectangleParams(BOX*, l_int32, l_int32, l_int32*, l_int32*, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:263</i>
     */
    public static int boxClipToRectangleParams(Pointer<Box> box, int w, int h,
            Pointer<Integer> pxstart, Pointer<Integer> pystart,
            Pointer<Integer> pxend, Pointer<Integer> pyend,
            Pointer<Integer> pbw, Pointer<Integer> pbh) {
        return boxClipToRectangleParams(Pointer.getPeer(box), w, h,
                Pointer.getPeer(pxstart), Pointer.getPeer(pystart),
                Pointer.getPeer(pxend), Pointer.getPeer(pyend),
                Pointer.getPeer(pbw), Pointer.getPeer(pbh));
    }

    protected native static int boxClipToRectangleParams(@Ptr long box, int w,
            int h, @Ptr long pxstart, @Ptr long pystart, @Ptr long pxend,
            @Ptr long pyend, @Ptr long pbw, @Ptr long pbh);

    /**
     * Original signature :
     * <code>BOX* boxRelocateOneSide(BOX*, BOX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:264</i>
     */
    public static Pointer<Box> boxRelocateOneSide(Pointer<Box> boxd,
            Pointer<Box> boxs, int loc, int sideflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxRelocateOneSide(Pointer.getPeer(boxd),
                        Pointer.getPeer(boxs), loc, sideflag), Box.class);
    }

    @Ptr
    protected native static long boxRelocateOneSide(@Ptr long boxd,
            @Ptr long boxs, int loc, int sideflag);

    /**
     * Original signature :
     * <code>BOX* boxAdjustSides(BOX*, BOX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:265</i>
     */
    public static Pointer<Box> boxAdjustSides(Pointer<Box> boxd,
            Pointer<Box> boxs, int delleft, int delright, int deltop, int delbot) {
        return (Pointer) Pointer.pointerToAddress(
                boxAdjustSides(Pointer.getPeer(boxd), Pointer.getPeer(boxs),
                        delleft, delright, deltop, delbot), Box.class);
    }

    @Ptr
    protected native static long boxAdjustSides(@Ptr long boxd, @Ptr long boxs,
            int delleft, int delright, int deltop, int delbot);

    /**
     * Original signature :
     * <code>BOXA* boxaSetSide(BOXA*, BOXA*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:266</i>
     */
    public static Pointer<Boxa> boxaSetSide(Pointer<Boxa> boxad,
            Pointer<Boxa> boxas, int side, int val, int thresh) {
        return (Pointer) Pointer.pointerToAddress(
                boxaSetSide(Pointer.getPeer(boxad), Pointer.getPeer(boxas),
                        side, val, thresh), Boxa.class);
    }

    @Ptr
    protected native static long boxaSetSide(@Ptr long boxad, @Ptr long boxas,
            int side, int val, int thresh);

    /**
     * Original signature :
     * <code>BOXA* boxaAdjustWidthToTarget(BOXA*, BOXA*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:267</i>
     */
    public static Pointer<Boxa> boxaAdjustWidthToTarget(Pointer<Boxa> boxad,
            Pointer<Boxa> boxas, int sides, int target, int thresh) {
        return (Pointer) Pointer.pointerToAddress(
                boxaAdjustWidthToTarget(Pointer.getPeer(boxad),
                        Pointer.getPeer(boxas), sides, target, thresh),
                Boxa.class);
    }

    @Ptr
    protected native static long boxaAdjustWidthToTarget(@Ptr long boxad,
            @Ptr long boxas, int sides, int target, int thresh);

    /**
     * Original signature :
     * <code>BOXA* boxaAdjustHeightToTarget(BOXA*, BOXA*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:268</i>
     */
    public static Pointer<Boxa> boxaAdjustHeightToTarget(Pointer<Boxa> boxad,
            Pointer<Boxa> boxas, int sides, int target, int thresh) {
        return (Pointer) Pointer.pointerToAddress(
                boxaAdjustHeightToTarget(Pointer.getPeer(boxad),
                        Pointer.getPeer(boxas), sides, target, thresh),
                Boxa.class);
    }

    @Ptr
    protected native static long boxaAdjustHeightToTarget(@Ptr long boxad,
            @Ptr long boxas, int sides, int target, int thresh);

    /**
     * Original signature : <code>l_int32 boxEqual(BOX*, BOX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:269</i>
     */
    public static int boxEqual(Pointer<Box> box1, Pointer<Box> box2,
            Pointer<Integer> psame) {
        return boxEqual(Pointer.getPeer(box1), Pointer.getPeer(box2),
                Pointer.getPeer(psame));
    }

    protected native static int boxEqual(@Ptr long box1, @Ptr long box2,
            @Ptr long psame);

    /**
     * Original signature :
     * <code>l_int32 boxaEqual(BOXA*, BOXA*, l_int32, NUMA**, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:270</i>
     */
    public static int boxaEqual(Pointer<Boxa> boxa1, Pointer<Boxa> boxa2,
            int maxdist, Pointer<Pointer<Numa>> pnaindex, Pointer<Integer> psame) {
        return boxaEqual(Pointer.getPeer(boxa1), Pointer.getPeer(boxa2),
                maxdist, Pointer.getPeer(pnaindex), Pointer.getPeer(psame));
    }

    protected native static int boxaEqual(@Ptr long boxa1, @Ptr long boxa2,
            int maxdist, @Ptr long pnaindex, @Ptr long psame);

    /**
     * Original signature :
     * <code>l_int32 boxSimilar(BOX*, BOX*, l_int32, l_int32, l_int32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:271</i>
     */
    public static int boxSimilar(Pointer<Box> box1, Pointer<Box> box2,
            int leftdiff, int rightdiff, int topdiff, int botdiff,
            Pointer<Integer> psimilar) {
        return boxSimilar(Pointer.getPeer(box1), Pointer.getPeer(box2),
                leftdiff, rightdiff, topdiff, botdiff,
                Pointer.getPeer(psimilar));
    }

    protected native static int boxSimilar(@Ptr long box1, @Ptr long box2,
            int leftdiff, int rightdiff, int topdiff, int botdiff,
            @Ptr long psimilar);

    /**
     * Original signature :
     * <code>l_int32 boxaSimilar(BOXA*, BOXA*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:272</i>
     */
    public static int boxaSimilar(Pointer<Boxa> boxa1, Pointer<Boxa> boxa2,
            int leftdiff, int rightdiff, int topdiff, int botdiff,
            int debugflag, Pointer<Integer> psimilar) {
        return boxaSimilar(Pointer.getPeer(boxa1), Pointer.getPeer(boxa2),
                leftdiff, rightdiff, topdiff, botdiff, debugflag,
                Pointer.getPeer(psimilar));
    }

    protected native static int boxaSimilar(@Ptr long boxa1, @Ptr long boxa2,
            int leftdiff, int rightdiff, int topdiff, int botdiff,
            int debugflag, @Ptr long psimilar);

    /**
     * Original signature :
     * <code>l_int32 boxaJoin(BOXA*, BOXA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:273</i>
     */
    public static int boxaJoin(Pointer<Boxa> boxad, Pointer<Boxa> boxas,
            int istart, int iend) {
        return boxaJoin(Pointer.getPeer(boxad), Pointer.getPeer(boxas), istart,
                iend);
    }

    protected native static int boxaJoin(@Ptr long boxad, @Ptr long boxas,
            int istart, int iend);

    /**
     * Original signature :
     * <code>l_int32 boxaaJoin(BOXAA*, BOXAA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:274</i>
     */
    public static int boxaaJoin(Pointer<Boxaa> baad, Pointer<Boxaa> baas,
            int istart, int iend) {
        return boxaaJoin(Pointer.getPeer(baad), Pointer.getPeer(baas), istart,
                iend);
    }

    protected native static int boxaaJoin(@Ptr long baad, @Ptr long baas,
            int istart, int iend);

    /**
     * Original signature :
     * <code>l_int32 boxaSplitEvenOdd(BOXA*, l_int32, BOXA**, BOXA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:275</i>
     */
    public static int boxaSplitEvenOdd(Pointer<Boxa> boxa, int fillflag,
            Pointer<Pointer<Boxa>> pboxae, Pointer<Pointer<Boxa>> pboxao) {
        return boxaSplitEvenOdd(Pointer.getPeer(boxa), fillflag,
                Pointer.getPeer(pboxae), Pointer.getPeer(pboxao));
    }

    protected native static int boxaSplitEvenOdd(@Ptr long boxa, int fillflag,
            @Ptr long pboxae, @Ptr long pboxao);

    /**
     * Original signature :
     * <code>BOXA* boxaMergeEvenOdd(BOXA*, BOXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:276</i>
     */
    public static Pointer<Boxa> boxaMergeEvenOdd(Pointer<Boxa> boxae,
            Pointer<Boxa> boxao, int fillflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxaMergeEvenOdd(Pointer.getPeer(boxae),
                        Pointer.getPeer(boxao), fillflag), Boxa.class);
    }

    @Ptr
    protected native static long boxaMergeEvenOdd(@Ptr long boxae,
            @Ptr long boxao, int fillflag);

    /**
     * Original signature :
     * <code>BOXA* boxaTransform(BOXA*, l_int32, l_int32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:277</i>
     */
    public static Pointer<Boxa> boxaTransform(Pointer<Boxa> boxas, int shiftx,
            int shifty, float scalex, float scaley) {
        return (Pointer) Pointer.pointerToAddress(
                boxaTransform(Pointer.getPeer(boxas), shiftx, shifty, scalex,
                        scaley), Boxa.class);
    }

    @Ptr
    protected native static long boxaTransform(@Ptr long boxas, int shiftx,
            int shifty, float scalex, float scaley);

    /**
     * Original signature :
     * <code>BOX* boxTransform(BOX*, l_int32, l_int32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:278</i>
     */
    public static Pointer<Box> boxTransform(Pointer<Box> box, int shiftx,
            int shifty, float scalex, float scaley) {
        return (Pointer) Pointer.pointerToAddress(
                boxTransform(Pointer.getPeer(box), shiftx, shifty, scalex,
                        scaley), Box.class);
    }

    @Ptr
    protected native static long boxTransform(@Ptr long box, int shiftx,
            int shifty, float scalex, float scaley);

    /**
     * Original signature :
     * <code>BOXA* boxaTransformOrdered(BOXA*, l_int32, l_int32, l_float32, l_float32, l_int32, l_int32, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:279</i>
     */
    public static Pointer<Boxa> boxaTransformOrdered(Pointer<Boxa> boxas,
            int shiftx, int shifty, float scalex, float scaley, int xcen,
            int ycen, float angle, int order) {
        return (Pointer) Pointer.pointerToAddress(
                boxaTransformOrdered(Pointer.getPeer(boxas), shiftx, shifty,
                        scalex, scaley, xcen, ycen, angle, order), Boxa.class);
    }

    @Ptr
    protected native static long boxaTransformOrdered(@Ptr long boxas,
            int shiftx, int shifty, float scalex, float scaley, int xcen,
            int ycen, float angle, int order);

    /**
     * Original signature :
     * <code>BOX* boxTransformOrdered(BOX*, l_int32, l_int32, l_float32, l_float32, l_int32, l_int32, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:280</i>
     */
    public static Pointer<Box> boxTransformOrdered(Pointer<Box> boxs,
            int shiftx, int shifty, float scalex, float scaley, int xcen,
            int ycen, float angle, int order) {
        return (Pointer) Pointer.pointerToAddress(
                boxTransformOrdered(Pointer.getPeer(boxs), shiftx, shifty,
                        scalex, scaley, xcen, ycen, angle, order), Box.class);
    }

    @Ptr
    protected native static long boxTransformOrdered(@Ptr long boxs,
            int shiftx, int shifty, float scalex, float scaley, int xcen,
            int ycen, float angle, int order);

    /**
     * Original signature :
     * <code>BOXA* boxaRotateOrth(BOXA*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:281</i>
     */
    public static Pointer<Boxa> boxaRotateOrth(Pointer<Boxa> boxas, int w,
            int h, int rotation) {
        return (Pointer) Pointer.pointerToAddress(
                boxaRotateOrth(Pointer.getPeer(boxas), w, h, rotation),
                Boxa.class);
    }

    @Ptr
    protected native static long boxaRotateOrth(@Ptr long boxas, int w, int h,
            int rotation);

    /**
     * Original signature :
     * <code>BOX* boxRotateOrth(BOX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:282</i>
     */
    public static Pointer<Box> boxRotateOrth(Pointer<Box> box, int w, int h,
            int rotation) {
        return (Pointer) Pointer.pointerToAddress(
                boxRotateOrth(Pointer.getPeer(box), w, h, rotation), Box.class);
    }

    @Ptr
    protected native static long boxRotateOrth(@Ptr long box, int w, int h,
            int rotation);

    /**
     * Original signature :
     * <code>BOXA* boxaSort(BOXA*, l_int32, l_int32, NUMA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:283</i>
     */
    public static Pointer<Boxa> boxaSort(Pointer<Boxa> boxas, int sorttype,
            int sortorder, Pointer<Pointer<Numa>> pnaindex) {
        return (Pointer) Pointer.pointerToAddress(
                boxaSort(Pointer.getPeer(boxas), sorttype, sortorder,
                        Pointer.getPeer(pnaindex)), Boxa.class);
    }

    @Ptr
    protected native static long boxaSort(@Ptr long boxas, int sorttype,
            int sortorder, @Ptr long pnaindex);

    /**
     * Original signature :
     * <code>BOXA* boxaBinSort(BOXA*, l_int32, l_int32, NUMA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:284</i>
     */
    public static Pointer<Boxa> boxaBinSort(Pointer<Boxa> boxas, int sorttype,
            int sortorder, Pointer<Pointer<Numa>> pnaindex) {
        return (Pointer) Pointer.pointerToAddress(
                boxaBinSort(Pointer.getPeer(boxas), sorttype, sortorder,
                        Pointer.getPeer(pnaindex)), Boxa.class);
    }

    @Ptr
    protected native static long boxaBinSort(@Ptr long boxas, int sorttype,
            int sortorder, @Ptr long pnaindex);

    /**
     * Original signature : <code>BOXA* boxaSortByIndex(BOXA*, NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:285</i>
     */
    public static Pointer<Boxa> boxaSortByIndex(Pointer<Boxa> boxas,
            Pointer<Numa> naindex) {
        return (Pointer) Pointer.pointerToAddress(
                boxaSortByIndex(Pointer.getPeer(boxas),
                        Pointer.getPeer(naindex)), Boxa.class);
    }

    @Ptr
    protected native static long boxaSortByIndex(@Ptr long boxas,
            @Ptr long naindex);

    /**
     * Original signature :
     * <code>BOXAA* boxaSort2d(BOXA*, NUMAA**, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:286</i>
     */
    public static Pointer<Boxaa> boxaSort2d(Pointer<Boxa> boxas,
            Pointer<Pointer<Numaa>> pnaad, int delta1, int delta2, int minh1) {
        return (Pointer) Pointer.pointerToAddress(
                boxaSort2d(Pointer.getPeer(boxas), Pointer.getPeer(pnaad),
                        delta1, delta2, minh1), Boxaa.class);
    }

    @Ptr
    protected native static long boxaSort2d(@Ptr long boxas, @Ptr long pnaad,
            int delta1, int delta2, int minh1);

    /**
     * Original signature : <code>BOXAA* boxaSort2dByIndex(BOXA*, NUMAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:287</i>
     */
    public static Pointer<Boxaa> boxaSort2dByIndex(Pointer<Boxa> boxas,
            Pointer<Numaa> naa) {
        return (Pointer) Pointer.pointerToAddress(
                boxaSort2dByIndex(Pointer.getPeer(boxas), Pointer.getPeer(naa)),
                Boxaa.class);
    }

    @Ptr
    protected native static long boxaSort2dByIndex(@Ptr long boxas,
            @Ptr long naa);

    /**
     * Original signature :
     * <code>l_int32 boxaExtractAsNuma(BOXA*, NUMA**, NUMA**, NUMA**, NUMA**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:288</i>
     */
    public static int boxaExtractAsNuma(Pointer<Boxa> boxa,
            Pointer<Pointer<Numa>> pnax, Pointer<Pointer<Numa>> pnay,
            Pointer<Pointer<Numa>> pnaw, Pointer<Pointer<Numa>> pnah,
            int keepinvalid) {
        return boxaExtractAsNuma(Pointer.getPeer(boxa), Pointer.getPeer(pnax),
                Pointer.getPeer(pnay), Pointer.getPeer(pnaw),
                Pointer.getPeer(pnah), keepinvalid);
    }

    protected native static int boxaExtractAsNuma(@Ptr long boxa,
            @Ptr long pnax, @Ptr long pnay, @Ptr long pnaw, @Ptr long pnah,
            int keepinvalid);

    /**
     * Original signature :
     * <code>l_int32 boxaExtractAsPta(BOXA*, PTA**, PTA**, PTA**, PTA**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:289</i>
     */
    public static int boxaExtractAsPta(Pointer<Boxa> boxa,
            Pointer<Pointer<Pta>> pptal, Pointer<Pointer<Pta>> pptat,
            Pointer<Pointer<Pta>> pptar, Pointer<Pointer<Pta>> pptab,
            int keepinvalid) {
        return boxaExtractAsPta(Pointer.getPeer(boxa), Pointer.getPeer(pptal),
                Pointer.getPeer(pptat), Pointer.getPeer(pptar),
                Pointer.getPeer(pptab), keepinvalid);
    }

    protected native static int boxaExtractAsPta(@Ptr long boxa,
            @Ptr long pptal, @Ptr long pptat, @Ptr long pptar, @Ptr long pptab,
            int keepinvalid);

    /**
     * Original signature : <code>BOX* boxaGetRankSize(BOXA*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:290</i>
     */
    public static Pointer<Box> boxaGetRankSize(Pointer<Boxa> boxa, float fract) {
        return (Pointer) Pointer.pointerToAddress(
                boxaGetRankSize(Pointer.getPeer(boxa), fract), Box.class);
    }

    @Ptr
    protected native static long boxaGetRankSize(@Ptr long boxa, float fract) throws LastError;

    /**
     * Original signature : <code>BOX* boxaGetMedian(BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:291</i>
     */
    public static Pointer<Box> boxaGetMedian(Pointer<Boxa> boxa) {
        return (Pointer) Pointer.pointerToAddress(
                boxaGetMedian(Pointer.getPeer(boxa)), Box.class);
    }

    @Ptr
    protected native static long boxaGetMedian(@Ptr long boxa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 boxaaGetExtent(BOXAA*, l_int32*, l_int32*, BOX**, BOXA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:292</i>
     */
    public static int boxaaGetExtent(Pointer<Boxaa> baa, Pointer<Integer> pw,
            Pointer<Integer> ph, Pointer<Pointer<Box>> pbox,
            Pointer<Pointer<Boxa>> pboxa) {
        return boxaaGetExtent(Pointer.getPeer(baa), Pointer.getPeer(pw),
                Pointer.getPeer(ph), Pointer.getPeer(pbox),
                Pointer.getPeer(pboxa));
    }

    protected native static int boxaaGetExtent(@Ptr long baa, @Ptr long pw,
            @Ptr long ph, @Ptr long pbox, @Ptr long pboxa);

    /**
     * Original signature :
     * <code>BOXA* boxaaFlattenToBoxa(BOXAA*, NUMA**, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:293</i>
     */
    public static Pointer<Boxa> boxaaFlattenToBoxa(Pointer<Boxaa> baa,
            Pointer<Pointer<Numa>> pnaindex, int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxaaFlattenToBoxa(Pointer.getPeer(baa),
                        Pointer.getPeer(pnaindex), copyflag), Boxa.class);
    }

    @Ptr
    protected native static long boxaaFlattenToBoxa(@Ptr long baa,
            @Ptr long pnaindex, int copyflag);

    /**
     * Original signature :
     * <code>BOXA* boxaaFlattenAligned(BOXAA*, l_int32, BOX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:294</i>
     */
    public static Pointer<Boxa> boxaaFlattenAligned(Pointer<Boxaa> baa,
            int num, Pointer<Box> fillerbox, int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxaaFlattenAligned(Pointer.getPeer(baa), num,
                        Pointer.getPeer(fillerbox), copyflag), Boxa.class);
    }

    @Ptr
    protected native static long boxaaFlattenAligned(@Ptr long baa, int num,
            @Ptr long fillerbox, int copyflag);

    /**
     * Original signature :
     * <code>BOXAA* boxaEncapsulateAligned(BOXA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:295</i>
     */
    public static Pointer<Boxaa> boxaEncapsulateAligned(Pointer<Boxa> boxa,
            int num, int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxaEncapsulateAligned(Pointer.getPeer(boxa), num, copyflag),
                Boxaa.class);
    }

    @Ptr
    protected native static long boxaEncapsulateAligned(@Ptr long boxa,
            int num, int copyflag);

    /**
     * Original signature :
     * <code>l_int32 boxaaAlignBox(BOXAA*, BOX*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:296</i>
     */
    public static int boxaaAlignBox(Pointer<Boxaa> baa, Pointer<Box> box,
            int delta, Pointer<Integer> pindex) {
        return boxaaAlignBox(Pointer.getPeer(baa), Pointer.getPeer(box), delta,
                Pointer.getPeer(pindex));
    }

    protected native static int boxaaAlignBox(@Ptr long baa, @Ptr long box,
            int delta, @Ptr long pindex);

    /**
     * Original signature :
     * <code>PIX* pixMaskConnComp(PIX*, l_int32, BOXA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:297</i>
     */
    public static Pointer<Pix> pixMaskConnComp(Pointer<Pix> pixs,
            int connectivity, Pointer<Pointer<Boxa>> pboxa) {
        return (Pointer) Pointer.pointerToAddress(
                pixMaskConnComp(Pointer.getPeer(pixs), connectivity,
                        Pointer.getPeer(pboxa)), Pix.class);
    }

    @Ptr
    protected native static long pixMaskConnComp(@Ptr long pixs,
            int connectivity, @Ptr long pboxa);

    /**
     * Original signature :
     * <code>PIX* pixMaskBoxa(PIX*, PIX*, BOXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:298</i>
     */
    public static Pointer<Pix> pixMaskBoxa(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<Boxa> boxa, int op) {
        return (Pointer) Pointer.pointerToAddress(
                pixMaskBoxa(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        Pointer.getPeer(boxa), op), Pix.class);
    }

    @Ptr
    protected native static long pixMaskBoxa(@Ptr long pixd, @Ptr long pixs,
            @Ptr long boxa, int op);

    /**
     * Original signature :
     * <code>PIX* pixPaintBoxa(PIX*, BOXA*, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:299</i>
     */
    public static Pointer<Pix> pixPaintBoxa(Pointer<Pix> pixs,
            Pointer<Boxa> boxa, int val) {
        return (Pointer) Pointer.pointerToAddress(
                pixPaintBoxa(Pointer.getPeer(pixs), Pointer.getPeer(boxa), val),
                Pix.class);
    }

    @Ptr
    protected native static long pixPaintBoxa(@Ptr long pixs, @Ptr long boxa,
            int val);

    /**
     * Original signature :
     * <code>PIX* pixSetBlackOrWhiteBoxa(PIX*, BOXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:300</i>
     */
    public static Pointer<Pix> pixSetBlackOrWhiteBoxa(Pointer<Pix> pixs,
            Pointer<Boxa> boxa, int op) {
        return (Pointer) Pointer.pointerToAddress(
                pixSetBlackOrWhiteBoxa(Pointer.getPeer(pixs),
                        Pointer.getPeer(boxa), op), Pix.class);
    }

    @Ptr
    protected native static long pixSetBlackOrWhiteBoxa(@Ptr long pixs,
            @Ptr long boxa, int op);

    /**
     * Original signature : <code>PIX* pixPaintBoxaRandom(PIX*, BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:301</i>
     */
    public static Pointer<Pix> pixPaintBoxaRandom(Pointer<Pix> pixs,
            Pointer<Boxa> boxa) {
        return (Pointer) Pointer.pointerToAddress(
                pixPaintBoxaRandom(Pointer.getPeer(pixs), Pointer.getPeer(boxa)),
                Pix.class);
    }

    @Ptr
    protected native static long pixPaintBoxaRandom(@Ptr long pixs,
            @Ptr long boxa);

    /**
     * Original signature :
     * <code>PIX* pixBlendBoxaRandom(PIX*, BOXA*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:302</i>
     */
    public static Pointer<Pix> pixBlendBoxaRandom(Pointer<Pix> pixs,
            Pointer<Boxa> boxa, float fract) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlendBoxaRandom(Pointer.getPeer(pixs),
                        Pointer.getPeer(boxa), fract), Pix.class);
    }

    @Ptr
    protected native static long pixBlendBoxaRandom(@Ptr long pixs,
            @Ptr long boxa, float fract);

    /**
     * Original signature :
     * <code>PIX* pixDrawBoxa(PIX*, BOXA*, l_int32, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:303</i>
     */
    public static Pointer<Pix> pixDrawBoxa(Pointer<Pix> pixs,
            Pointer<Boxa> boxa, int width, int val) {
        return (Pointer) Pointer.pointerToAddress(
                pixDrawBoxa(Pointer.getPeer(pixs), Pointer.getPeer(boxa),
                        width, val), Pix.class);
    }

    @Ptr
    protected native static long pixDrawBoxa(@Ptr long pixs, @Ptr long boxa,
            int width, int val);

    /**
     * Original signature :
     * <code>PIX* pixDrawBoxaRandom(PIX*, BOXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:304</i>
     */
    public static Pointer<Pix> pixDrawBoxaRandom(Pointer<Pix> pixs,
            Pointer<Boxa> boxa, int width) {
        return (Pointer) Pointer.pointerToAddress(
                pixDrawBoxaRandom(Pointer.getPeer(pixs), Pointer.getPeer(boxa),
                        width), Pix.class);
    }

    @Ptr
    protected native static long pixDrawBoxaRandom(@Ptr long pixs,
            @Ptr long boxa, int width);

    /**
     * Original signature :
     * <code>PIX* boxaaDisplay(BOXAA*, l_int32, l_int32, l_uint32, l_uint32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:305</i>
     */
    public static Pointer<Pix> boxaaDisplay(Pointer<Boxaa> baa, int linewba,
            int linewb, int colorba, int colorb, int w, int h) {
        return (Pointer) Pointer.pointerToAddress(
                boxaaDisplay(Pointer.getPeer(baa), linewba, linewb, colorba,
                        colorb, w, h), Pix.class);
    }

    @Ptr
    protected native static long boxaaDisplay(@Ptr long baa, int linewba,
            int linewb, int colorba, int colorb, int w, int h);

    /**
     * Original signature :
     * <code>BOXA* pixSplitIntoBoxa(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:306</i>
     */
    public static Pointer<Boxa> pixSplitIntoBoxa(Pointer<Pix> pixs, int minsum,
            int skipdist, int delta, int maxbg, int maxcomps, int remainder) {
        return (Pointer) Pointer.pointerToAddress(
                pixSplitIntoBoxa(Pointer.getPeer(pixs), minsum, skipdist,
                        delta, maxbg, maxcomps, remainder), Boxa.class);
    }

    @Ptr
    protected native static long pixSplitIntoBoxa(@Ptr long pixs, int minsum,
            int skipdist, int delta, int maxbg, int maxcomps, int remainder);

    /**
     * Original signature :
     * <code>BOXA* pixSplitComponentIntoBoxa(PIX*, BOX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:307</i>
     */
    public static Pointer<Boxa> pixSplitComponentIntoBoxa(Pointer<Pix> pix,
            Pointer<Box> box, int minsum, int skipdist, int delta, int maxbg,
            int maxcomps, int remainder) {
        return (Pointer) Pointer.pointerToAddress(
                pixSplitComponentIntoBoxa(Pointer.getPeer(pix),
                        Pointer.getPeer(box), minsum, skipdist, delta, maxbg,
                        maxcomps, remainder), Boxa.class);
    }

    @Ptr
    protected native static long pixSplitComponentIntoBoxa(@Ptr long pix,
            @Ptr long box, int minsum, int skipdist, int delta, int maxbg,
            int maxcomps, int remainder);

    /**
     * Original signature :
     * <code>l_int32 boxaCompareRegions(BOXA*, BOXA*, l_int32, l_int32*, l_float32*, l_float32*, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:308</i>
     */
    public static int boxaCompareRegions(Pointer<Boxa> boxa1,
            Pointer<Boxa> boxa2, int areathresh, Pointer<Integer> pnsame,
            Pointer<Float> pdiffarea, Pointer<Float> pdiffxor,
            Pointer<Pointer<Pix>> ppixdb) {
        return boxaCompareRegions(Pointer.getPeer(boxa1),
                Pointer.getPeer(boxa2), areathresh, Pointer.getPeer(pnsame),
                Pointer.getPeer(pdiffarea), Pointer.getPeer(pdiffxor),
                Pointer.getPeer(ppixdb));
    }

    protected native static int boxaCompareRegions(@Ptr long boxa1,
            @Ptr long boxa2, int areathresh, @Ptr long pnsame,
            @Ptr long pdiffarea, @Ptr long pdiffxor, @Ptr long ppixdb);

    /**
     * Original signature :
     * <code>BOXA* boxaSelectRange(BOXA*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:309</i>
     */
    public static Pointer<Boxa> boxaSelectRange(Pointer<Boxa> boxas, int first,
            int last, int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxaSelectRange(Pointer.getPeer(boxas), first, last, copyflag),
                Boxa.class);
    }

    @Ptr
    protected native static long boxaSelectRange(@Ptr long boxas, int first,
            int last, int copyflag);

    /**
     * Original signature :
     * <code>BOXAA* boxaaSelectRange(BOXAA*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:310</i>
     */
    public static Pointer<Boxaa> boxaaSelectRange(Pointer<Boxaa> baas,
            int first, int last, int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxaaSelectRange(Pointer.getPeer(baas), first, last, copyflag),
                Boxaa.class);
    }

    @Ptr
    protected native static long boxaaSelectRange(@Ptr long baas, int first,
            int last, int copyflag);

    /**
     * Original signature :
     * <code>BOXA* boxaSelectBySize(BOXA*, l_int32, l_int32, l_int32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:311</i>
     */
    public static Pointer<Boxa> boxaSelectBySize(Pointer<Boxa> boxas,
            int width, int height, int type, int relation,
            Pointer<Integer> pchanged) {
        return (Pointer) Pointer.pointerToAddress(
                boxaSelectBySize(Pointer.getPeer(boxas), width, height, type,
                        relation, Pointer.getPeer(pchanged)), Boxa.class);
    }

    @Ptr
    protected native static long boxaSelectBySize(@Ptr long boxas, int width,
            int height, int type, int relation, @Ptr long pchanged);

    /**
     * Original signature :
     * <code>NUMA* boxaMakeSizeIndicator(BOXA*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:312</i>
     */
    public static Pointer<Numa> boxaMakeSizeIndicator(Pointer<Boxa> boxa,
            int width, int height, int type, int relation) {
        return (Pointer) Pointer.pointerToAddress(
                boxaMakeSizeIndicator(Pointer.getPeer(boxa), width, height,
                        type, relation), Numa.class);
    }

    @Ptr
    protected native static long boxaMakeSizeIndicator(@Ptr long boxa,
            int width, int height, int type, int relation);

    /**
     * Original signature :
     * <code>BOXA* boxaSelectByArea(BOXA*, l_int32, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:313</i>
     */
    public static Pointer<Boxa> boxaSelectByArea(Pointer<Boxa> boxas, int area,
            int relation, Pointer<Integer> pchanged) {
        return (Pointer) Pointer.pointerToAddress(
                boxaSelectByArea(Pointer.getPeer(boxas), area, relation,
                        Pointer.getPeer(pchanged)), Boxa.class);
    }

    @Ptr
    protected native static long boxaSelectByArea(@Ptr long boxas, int area,
            int relation, @Ptr long pchanged);

    /**
     * Original signature :
     * <code>NUMA* boxaMakeAreaIndicator(BOXA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:314</i>
     */
    public static Pointer<Numa> boxaMakeAreaIndicator(Pointer<Boxa> boxa,
            int area, int relation) {
        return (Pointer) Pointer.pointerToAddress(
                boxaMakeAreaIndicator(Pointer.getPeer(boxa), area, relation),
                Numa.class);
    }

    @Ptr
    protected native static long boxaMakeAreaIndicator(@Ptr long boxa,
            int area, int relation);

    /**
     * Original signature :
     * <code>BOXA* boxaSelectWithIndicator(BOXA*, NUMA*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:315</i>
     */
    public static Pointer<Boxa> boxaSelectWithIndicator(Pointer<Boxa> boxas,
            Pointer<Numa> na, Pointer<Integer> pchanged) {
        return (Pointer) Pointer.pointerToAddress(
                boxaSelectWithIndicator(Pointer.getPeer(boxas),
                        Pointer.getPeer(na), Pointer.getPeer(pchanged)),
                Boxa.class);
    }

    @Ptr
    protected native static long boxaSelectWithIndicator(@Ptr long boxas,
            @Ptr long na, @Ptr long pchanged);

    /**
     * Original signature : <code>BOXA* boxaPermutePseudorandom(BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:316</i>
     */
    public static Pointer<Boxa> boxaPermutePseudorandom(Pointer<Boxa> boxas) {
        return (Pointer) Pointer.pointerToAddress(
                boxaPermutePseudorandom(Pointer.getPeer(boxas)), Boxa.class);
    }

    @Ptr
    protected native static long boxaPermutePseudorandom(@Ptr long boxas) throws LastError;

    /**
     * Original signature : <code>BOXA* boxaPermuteRandom(BOXA*, BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:317</i>
     */
    public static Pointer<Boxa> boxaPermuteRandom(Pointer<Boxa> boxad,
            Pointer<Boxa> boxas) {
        return (Pointer) Pointer.pointerToAddress(
                boxaPermuteRandom(Pointer.getPeer(boxad),
                        Pointer.getPeer(boxas)), Boxa.class);
    }

    @Ptr
    protected native static long boxaPermuteRandom(@Ptr long boxad,
            @Ptr long boxas);

    /**
     * Original signature :
     * <code>l_int32 boxaSwapBoxes(BOXA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:318</i>
     */
    public static int boxaSwapBoxes(Pointer<Boxa> boxa, int i, int j) {
        return boxaSwapBoxes(Pointer.getPeer(boxa), i, j);
    }

    protected native static int boxaSwapBoxes(@Ptr long boxa, int i, int j) throws LastError;

    /**
     * Original signature : <code>PTA* boxaConvertToPta(BOXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:319</i>
     */
    public static Pointer<Pta> boxaConvertToPta(Pointer<Boxa> boxa, int ncorners) {
        return (Pointer) Pointer.pointerToAddress(
                boxaConvertToPta(Pointer.getPeer(boxa), ncorners), Pta.class);
    }

    @Ptr
    protected native static long boxaConvertToPta(@Ptr long boxa, int ncorners) throws LastError;

    /**
     * Original signature : <code>BOXA* ptaConvertToBoxa(PTA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:320</i>
     */
    public static Pointer<Boxa> ptaConvertToBoxa(Pointer<Pta> pta, int ncorners) {
        return (Pointer) Pointer.pointerToAddress(
                ptaConvertToBoxa(Pointer.getPeer(pta), ncorners), Boxa.class);
    }

    @Ptr
    protected native static long ptaConvertToBoxa(@Ptr long pta, int ncorners) throws LastError;

    /**
     * Original signature :
     * <code>BOXA* boxaSmoothSequence(BOXA*, l_float32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:321</i>
     */
    public static Pointer<Boxa> boxaSmoothSequence(Pointer<Boxa> boxas,
            float factor, int max_error, int debug) {
        return (Pointer) Pointer.pointerToAddress(
                boxaSmoothSequence(Pointer.getPeer(boxas), factor, max_error,
                        debug), Boxa.class);
    }

    @Ptr
    protected native static long boxaSmoothSequence(@Ptr long boxas,
            float factor, int max_error, int debug);

    /**
     * Original signature :
     * <code>BOXA* boxaLinearFit(BOXA*, l_float32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:322</i>
     */
    public static Pointer<Boxa> boxaLinearFit(Pointer<Boxa> boxas,
            float factor, int max_error, int debug) {
        return (Pointer) Pointer.pointerToAddress(
                boxaLinearFit(Pointer.getPeer(boxas), factor, max_error, debug),
                Boxa.class);
    }

    @Ptr
    protected native static long boxaLinearFit(@Ptr long boxas, float factor,
            int max_error, int debug);

    /**
     * Original signature :
     * <code>BOXA* boxaConstrainSize(BOXA*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:323</i>
     */
    public static Pointer<Boxa> boxaConstrainSize(Pointer<Boxa> boxas,
            int width, int widthflag, int height, int heightflag) {
        return (Pointer) Pointer.pointerToAddress(
                boxaConstrainSize(Pointer.getPeer(boxas), width, widthflag,
                        height, heightflag), Boxa.class);
    }

    @Ptr
    protected native static long boxaConstrainSize(@Ptr long boxas, int width,
            int widthflag, int height, int heightflag);

    /**
     * Original signature :
     * <code>BOXA* boxaReconcileEvenOddHeight(BOXA*, l_int32, l_int32, l_int32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:324</i>
     */
    public static Pointer<Boxa> boxaReconcileEvenOddHeight(Pointer<Boxa> boxas,
            int sides, int delh, int op, float factor) {
        return (Pointer) Pointer.pointerToAddress(
                boxaReconcileEvenOddHeight(Pointer.getPeer(boxas), sides, delh,
                        op, factor), Boxa.class);
    }

    @Ptr
    protected native static long boxaReconcileEvenOddHeight(@Ptr long boxas,
            int sides, int delh, int op, float factor);

    /**
     * Original signature :
     * <code>l_int32 boxaPlotSides(BOXA*, const char*, NUMA**, NUMA**, NUMA**, NUMA**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:325</i>
     */
    public static int boxaPlotSides(Pointer<Boxa> boxa, Pointer<Byte> plotname,
            Pointer<Pointer<Numa>> pnal, Pointer<Pointer<Numa>> pnat,
            Pointer<Pointer<Numa>> pnar, Pointer<Pointer<Numa>> pnab,
            int outformat) {
        return boxaPlotSides(Pointer.getPeer(boxa), Pointer.getPeer(plotname),
                Pointer.getPeer(pnal), Pointer.getPeer(pnat),
                Pointer.getPeer(pnar), Pointer.getPeer(pnab), outformat);
    }

    protected native static int boxaPlotSides(@Ptr long boxa,
            @Ptr long plotname, @Ptr long pnal, @Ptr long pnat, @Ptr long pnar,
            @Ptr long pnab, int outformat);

    /**
     * Original signature :
     * <code>l_int32 boxaGetExtent(BOXA*, l_int32*, l_int32*, BOX**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:326</i>
     */
    public static int boxaGetExtent(Pointer<Boxa> boxa, Pointer<Integer> pw,
            Pointer<Integer> ph, Pointer<Pointer<Box>> pbox) {
        return boxaGetExtent(Pointer.getPeer(boxa), Pointer.getPeer(pw),
                Pointer.getPeer(ph), Pointer.getPeer(pbox));
    }

    protected native static int boxaGetExtent(@Ptr long boxa, @Ptr long pw,
            @Ptr long ph, @Ptr long pbox);

    /**
     * Original signature :
     * <code>l_int32 boxaGetCoverage(BOXA*, l_int32, l_int32, l_int32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:327</i>
     */
    public static int boxaGetCoverage(Pointer<Boxa> boxa, int wc, int hc,
            int exactflag, Pointer<Float> pfract) {
        return boxaGetCoverage(Pointer.getPeer(boxa), wc, hc, exactflag,
                Pointer.getPeer(pfract));
    }

    protected native static int boxaGetCoverage(@Ptr long boxa, int wc, int hc,
            int exactflag, @Ptr long pfract);

    /**
     * Original signature :
     * <code>l_int32 boxaaSizeRange(BOXAA*, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:328</i>
     */
    public static int boxaaSizeRange(Pointer<Boxaa> baa,
            Pointer<Integer> pminw, Pointer<Integer> pminh,
            Pointer<Integer> pmaxw, Pointer<Integer> pmaxh) {
        return boxaaSizeRange(Pointer.getPeer(baa), Pointer.getPeer(pminw),
                Pointer.getPeer(pminh), Pointer.getPeer(pmaxw),
                Pointer.getPeer(pmaxh));
    }

    protected native static int boxaaSizeRange(@Ptr long baa, @Ptr long pminw,
            @Ptr long pminh, @Ptr long pmaxw, @Ptr long pmaxh);

    /**
     * Original signature :
     * <code>l_int32 boxaSizeRange(BOXA*, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:329</i>
     */
    public static int boxaSizeRange(Pointer<Boxa> boxa, Pointer<Integer> pminw,
            Pointer<Integer> pminh, Pointer<Integer> pmaxw,
            Pointer<Integer> pmaxh) {
        return boxaSizeRange(Pointer.getPeer(boxa), Pointer.getPeer(pminw),
                Pointer.getPeer(pminh), Pointer.getPeer(pmaxw),
                Pointer.getPeer(pmaxh));
    }

    protected native static int boxaSizeRange(@Ptr long boxa, @Ptr long pminw,
            @Ptr long pminh, @Ptr long pmaxw, @Ptr long pmaxh);

    /**
     * Original signature :
     * <code>l_int32 boxaLocationRange(BOXA*, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:330</i>
     */
    public static int boxaLocationRange(Pointer<Boxa> boxa,
            Pointer<Integer> pminx, Pointer<Integer> pminy,
            Pointer<Integer> pmaxx, Pointer<Integer> pmaxy) {
        return boxaLocationRange(Pointer.getPeer(boxa), Pointer.getPeer(pminx),
                Pointer.getPeer(pminy), Pointer.getPeer(pmaxx),
                Pointer.getPeer(pmaxy));
    }

    protected native static int boxaLocationRange(@Ptr long boxa,
            @Ptr long pminx, @Ptr long pminy, @Ptr long pmaxx, @Ptr long pmaxy);

    /**
     * Original signature : <code>l_int32 boxaGetArea(BOXA*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:331</i>
     */
    public static int boxaGetArea(Pointer<Boxa> boxa, Pointer<Integer> parea) {
        return boxaGetArea(Pointer.getPeer(boxa), Pointer.getPeer(parea));
    }

    protected native static int boxaGetArea(@Ptr long boxa, @Ptr long parea) throws LastError;

    /**
     * Original signature :
     * <code>PIX* boxaDisplayTiled(BOXA*, PIXA*, l_int32, l_int32, l_float32, l_int32, l_int32, l_int32, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:332</i>
     */
    public static Pointer<Pix> boxaDisplayTiled(Pointer<Boxa> boxa,
            Pointer<Pixa> pixa, int maxwidth, int linewidth, float scalefactor,
            int background, int spacing, int border, Pointer<Byte> fontdir) {
        return (Pointer) Pointer.pointerToAddress(
                boxaDisplayTiled(Pointer.getPeer(boxa), Pointer.getPeer(pixa),
                        maxwidth, linewidth, scalefactor, background, spacing,
                        border, Pointer.getPeer(fontdir)), Pix.class);
    }

    @Ptr
    protected native static long boxaDisplayTiled(@Ptr long boxa,
            @Ptr long pixa, int maxwidth, int linewidth, float scalefactor,
            int background, int spacing, int border, @Ptr long fontdir);

    /**
     * Original signature : <code>L_BYTEA* l_byteaCreate(size_t)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:333</i>
     */
    public static Pointer<L_Bytea> l_byteaCreate(@Ptr long nbytes) {
        return (Pointer) Pointer.pointerToAddress(l_byteaCreate$2(nbytes),
                L_Bytea.class);
    }

    @Ptr
    @Name("l_byteaCreate")
    protected native static long l_byteaCreate$2(@Ptr long nbytes) throws LastError;

    /**
     * Original signature :
     * <code>L_BYTEA* l_byteaInitFromMem(l_uint8*, size_t)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:334</i>
     */
    public static Pointer<L_Bytea> l_byteaInitFromMem(Pointer<Byte> data,
            @Ptr long size) {
        return (Pointer) Pointer.pointerToAddress(
                l_byteaInitFromMem(Pointer.getPeer(data), size), L_Bytea.class);
    }

    @Ptr
    protected native static long l_byteaInitFromMem(@Ptr long data,
            @Ptr long size);

    /**
     * Original signature :
     * <code>L_BYTEA* l_byteaInitFromFile(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:335</i>
     */
    public static Pointer<L_Bytea> l_byteaInitFromFile(Pointer<Byte> fname) {
        return (Pointer) Pointer.pointerToAddress(
                l_byteaInitFromFile(Pointer.getPeer(fname)), L_Bytea.class);
    }

    @Ptr
    protected native static long l_byteaInitFromFile(@Ptr long fname) throws LastError;

    /**
     * Original signature : <code>L_BYTEA* l_byteaInitFromStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:336</i>
     */
    public static Pointer<L_Bytea> l_byteaInitFromStream(
            Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                l_byteaInitFromStream(Pointer.getPeer(fp)), L_Bytea.class);
    }

    @Ptr
    protected native static long l_byteaInitFromStream(@Ptr long fp) throws LastError;

    /**
     * Original signature : <code>L_BYTEA* l_byteaCopy(L_BYTEA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:337</i>
     */
    public static Pointer<L_Bytea> l_byteaCopy(Pointer<L_Bytea> bas,
            int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                l_byteaCopy(Pointer.getPeer(bas), copyflag), L_Bytea.class);
    }

    @Ptr
    protected native static long l_byteaCopy(@Ptr long bas, int copyflag) throws LastError;

    /**
     * Original signature : <code>void l_byteaDestroy(L_BYTEA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:338</i>
     */
    public static void l_byteaDestroy(Pointer<Pointer<L_Bytea>> pba) {
        l_byteaDestroy(Pointer.getPeer(pba));
    }

    protected native static void l_byteaDestroy(@Ptr long pba) throws LastError;

    /**
     * Original signature : <code>size_t l_byteaGetSize(L_BYTEA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:339</i>
     */
    @Ptr
    public static long l_byteaGetSize(Pointer<L_Bytea> ba) {
        return l_byteaGetSize(Pointer.getPeer(ba));
    }

    @Ptr
    protected native static long l_byteaGetSize(@Ptr long ba) throws LastError;

    /**
     * Original signature :
     * <code>l_uint8* l_byteaGetData(L_BYTEA*, size_t*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:340</i>
     */
    public static Pointer<Byte> l_byteaGetData(Pointer<L_Bytea> ba,
            Pointer<SizeT> psize) {
        return (Pointer) Pointer.pointerToAddress(
                l_byteaGetData(Pointer.getPeer(ba), Pointer.getPeer(psize)),
                Byte.class);
    }

    @Ptr
    protected native static long l_byteaGetData(@Ptr long ba, @Ptr long psize) throws LastError;

    /**
     * Original signature :
     * <code>l_uint8* l_byteaCopyData(L_BYTEA*, size_t*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:341</i>
     */
    public static Pointer<Byte> l_byteaCopyData(Pointer<L_Bytea> ba,
            Pointer<SizeT> psize) {
        return (Pointer) Pointer.pointerToAddress(
                l_byteaCopyData(Pointer.getPeer(ba), Pointer.getPeer(psize)),
                Byte.class);
    }

    @Ptr
    protected native static long l_byteaCopyData(@Ptr long ba, @Ptr long psize) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_byteaAppendData(L_BYTEA*, l_uint8*, size_t)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:342</i>
     */
    public static int l_byteaAppendData(Pointer<L_Bytea> ba,
            Pointer<Byte> newdata, @Ptr long newbytes) {
        return l_byteaAppendData(Pointer.getPeer(ba), Pointer.getPeer(newdata),
                newbytes);
    }

    protected native static int l_byteaAppendData(@Ptr long ba,
            @Ptr long newdata, @Ptr long newbytes);

    /**
     * Original signature :
     * <code>l_int32 l_byteaAppendString(L_BYTEA*, char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:343</i>
     */
    public static int l_byteaAppendString(Pointer<L_Bytea> ba, Pointer<Byte> str) {
        return l_byteaAppendString(Pointer.getPeer(ba), Pointer.getPeer(str));
    }

    protected native static int l_byteaAppendString(@Ptr long ba, @Ptr long str) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_byteaJoin(L_BYTEA*, L_BYTEA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:344</i>
     */
    public static int l_byteaJoin(Pointer<L_Bytea> ba1,
            Pointer<Pointer<L_Bytea>> pba2) {
        return l_byteaJoin(Pointer.getPeer(ba1), Pointer.getPeer(pba2));
    }

    protected native static int l_byteaJoin(@Ptr long ba1, @Ptr long pba2) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_byteaSplit(L_BYTEA*, size_t, L_BYTEA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:345</i>
     */
    public static int l_byteaSplit(Pointer<L_Bytea> ba1, @Ptr long splitloc,
            Pointer<Pointer<L_Bytea>> pba2) {
        return l_byteaSplit(Pointer.getPeer(ba1), splitloc,
                Pointer.getPeer(pba2));
    }

    protected native static int l_byteaSplit(@Ptr long ba1, @Ptr long splitloc,
            @Ptr long pba2);

    /**
     * Original signature :
     * <code>l_int32 l_byteaFindEachSequence(L_BYTEA*, l_uint8*, l_int32, L_DNA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:346</i>
     */
    public static int l_byteaFindEachSequence(Pointer<L_Bytea> ba,
            Pointer<Byte> sequence, int seqlen, Pointer<Pointer<L_Dna>> pda) {
        return l_byteaFindEachSequence(Pointer.getPeer(ba),
                Pointer.getPeer(sequence), seqlen, Pointer.getPeer(pda));
    }

    protected native static int l_byteaFindEachSequence(@Ptr long ba,
            @Ptr long sequence, int seqlen, @Ptr long pda);

    /**
     * Original signature :
     * <code>l_int32 l_byteaWrite(const char*, L_BYTEA*, size_t, size_t)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:347</i>
     */
    public static int l_byteaWrite(Pointer<Byte> fname, Pointer<L_Bytea> ba,
            @Ptr long startloc, @Ptr long endloc) {
        return l_byteaWrite(Pointer.getPeer(fname), Pointer.getPeer(ba),
                startloc, endloc);
    }

    protected native static int l_byteaWrite(@Ptr long fname, @Ptr long ba,
            @Ptr long startloc, @Ptr long endloc);

    /**
     * Original signature :
     * <code>l_int32 l_byteaWriteStream(FILE*, L_BYTEA*, size_t, size_t)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:348</i>
     */
    public static int l_byteaWriteStream(Pointer<FILE> fp,
            Pointer<L_Bytea> ba, @Ptr long startloc, @Ptr long endloc) {
        return l_byteaWriteStream(Pointer.getPeer(fp), Pointer.getPeer(ba),
                startloc, endloc);
    }

    protected native static int l_byteaWriteStream(@Ptr long fp, @Ptr long ba,
            @Ptr long startloc, @Ptr long endloc);

    /**
     * Original signature : <code>CCBORDA* ccbaCreate(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:349</i>
     */
    public static Pointer<CCBorda> ccbaCreate(Pointer<Pix> pixs, int n) {
        return (Pointer) Pointer.pointerToAddress(
                ccbaCreate(Pointer.getPeer(pixs), n), CCBorda.class);
    }

    @Ptr
    protected native static long ccbaCreate(@Ptr long pixs, int n) throws LastError;

    /**
     * Original signature : <code>void ccbaDestroy(CCBORDA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:350</i>
     */
    public static void ccbaDestroy(Pointer<Pointer<CCBorda>> pccba) {
        ccbaDestroy(Pointer.getPeer(pccba));
    }

    protected native static void ccbaDestroy(@Ptr long pccba) throws LastError;

    /**
     * Original signature : <code>CCBORD* ccbCreate(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:351</i>
     */
    public static Pointer<CCBord> ccbCreate(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                ccbCreate(Pointer.getPeer(pixs)), CCBord.class);
    }

    @Ptr
    protected native static long ccbCreate(@Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>void ccbDestroy(CCBORD**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:352</i>
     */
    public static void ccbDestroy(Pointer<Pointer<CCBord>> pccb) {
        ccbDestroy(Pointer.getPeer(pccb));
    }

    protected native static void ccbDestroy(@Ptr long pccb) throws LastError;

    /**
     * Original signature : <code>l_int32 ccbaAddCcb(CCBORDA*, CCBORD*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:353</i>
     */
    public static int ccbaAddCcb(Pointer<CCBorda> ccba, Pointer<CCBord> ccb) {
        return ccbaAddCcb(Pointer.getPeer(ccba), Pointer.getPeer(ccb));
    }

    protected native static int ccbaAddCcb(@Ptr long ccba, @Ptr long ccb) throws LastError;

    /**
     * Original signature : <code>l_int32 ccbaGetCount(CCBORDA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:354</i>
     */
    public static int ccbaGetCount(Pointer<CCBorda> ccba) {
        return ccbaGetCount(Pointer.getPeer(ccba));
    }

    protected native static int ccbaGetCount(@Ptr long ccba) throws LastError;

    /**
     * Original signature : <code>CCBORD* ccbaGetCcb(CCBORDA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:355</i>
     */
    public static Pointer<CCBord> ccbaGetCcb(Pointer<CCBorda> ccba, int index) {
        return (Pointer) Pointer.pointerToAddress(
                ccbaGetCcb(Pointer.getPeer(ccba), index), CCBord.class);
    }

    @Ptr
    protected native static long ccbaGetCcb(@Ptr long ccba, int index) throws LastError;

    /**
     * Original signature : <code>CCBORDA* pixGetAllCCBorders(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:356</i>
     */
    public static Pointer<CCBorda> pixGetAllCCBorders(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetAllCCBorders(Pointer.getPeer(pixs)), CCBorda.class);
    }

    @Ptr
    protected native static long pixGetAllCCBorders(@Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>CCBORD* pixGetCCBorders(PIX*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:357</i>
     */
    public static Pointer<CCBord> pixGetCCBorders(Pointer<Pix> pixs,
            Pointer<Box> box) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetCCBorders(Pointer.getPeer(pixs), Pointer.getPeer(box)),
                CCBord.class);
    }

    @Ptr
    protected native static long pixGetCCBorders(@Ptr long pixs, @Ptr long box) throws LastError;

    /**
     * Original signature : <code>PTAA* pixGetOuterBordersPtaa(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:358</i>
     */
    public static Pointer<Ptaa> pixGetOuterBordersPtaa(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetOuterBordersPtaa(Pointer.getPeer(pixs)), Ptaa.class);
    }

    @Ptr
    protected native static long pixGetOuterBordersPtaa(@Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>PTA* pixGetOuterBorderPta(PIX*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:359</i>
     */
    public static Pointer<Pta> pixGetOuterBorderPta(Pointer<Pix> pixs,
            Pointer<Box> box) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetOuterBorderPta(Pointer.getPeer(pixs),
                        Pointer.getPeer(box)), Pta.class);
    }

    @Ptr
    protected native static long pixGetOuterBorderPta(@Ptr long pixs,
            @Ptr long box);

    /**
     * Original signature :
     * <code>l_int32 pixGetOuterBorder(CCBORD*, PIX*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:360</i>
     */
    public static int pixGetOuterBorder(Pointer<CCBord> ccb, Pointer<Pix> pixs,
            Pointer<Box> box) {
        return pixGetOuterBorder(Pointer.getPeer(ccb), Pointer.getPeer(pixs),
                Pointer.getPeer(box));
    }

    protected native static int pixGetOuterBorder(@Ptr long ccb,
            @Ptr long pixs, @Ptr long box);

    /**
     * Original signature :
     * <code>l_int32 pixGetHoleBorder(CCBORD*, PIX*, BOX*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:361</i>
     */
    public static int pixGetHoleBorder(Pointer<CCBord> ccb, Pointer<Pix> pixs,
            Pointer<Box> box, int xs, int ys) {
        return pixGetHoleBorder(Pointer.getPeer(ccb), Pointer.getPeer(pixs),
                Pointer.getPeer(box), xs, ys);
    }

    protected native static int pixGetHoleBorder(@Ptr long ccb, @Ptr long pixs,
            @Ptr long box, int xs, int ys);

    /**
     * Original signature :
     * <code>l_int32 findNextBorderPixel(l_int32, l_int32, l_uint32*, l_int32, l_int32, l_int32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:362</i>
     */
    public static int findNextBorderPixel(int w, int h, Pointer<Integer> data,
            int wpl, int px, int py, Pointer<Integer> pqpos,
            Pointer<Integer> pnpx, Pointer<Integer> pnpy) {
        return findNextBorderPixel(w, h, Pointer.getPeer(data), wpl, px, py,
                Pointer.getPeer(pqpos), Pointer.getPeer(pnpx),
                Pointer.getPeer(pnpy));
    }

    protected native static int findNextBorderPixel(int w, int h,
            @Ptr long data, int wpl, int px, int py, @Ptr long pqpos,
            @Ptr long pnpx, @Ptr long pnpy);

    /**
     * Original signature :
     * <code>void locateOutsideSeedPixel(l_int32, l_int32, l_int32, l_int32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:363</i>
     */
    public static void locateOutsideSeedPixel(int fpx, int fpy, int spx,
            int spy, Pointer<Integer> pxs, Pointer<Integer> pys) {
        locateOutsideSeedPixel(fpx, fpy, spx, spy, Pointer.getPeer(pxs),
                Pointer.getPeer(pys));
    }

    protected native static void locateOutsideSeedPixel(int fpx, int fpy,
            int spx, int spy, @Ptr long pxs, @Ptr long pys);

    /**
     * Original signature :
     * <code>l_int32 ccbaGenerateGlobalLocs(CCBORDA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:364</i>
     */
    public static int ccbaGenerateGlobalLocs(Pointer<CCBorda> ccba) {
        return ccbaGenerateGlobalLocs(Pointer.getPeer(ccba));
    }

    protected native static int ccbaGenerateGlobalLocs(@Ptr long ccba) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 ccbaGenerateStepChains(CCBORDA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:365</i>
     */
    public static int ccbaGenerateStepChains(Pointer<CCBorda> ccba) {
        return ccbaGenerateStepChains(Pointer.getPeer(ccba));
    }

    protected native static int ccbaGenerateStepChains(@Ptr long ccba) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 ccbaStepChainsToPixCoords(CCBORDA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:366</i>
     */
    public static int ccbaStepChainsToPixCoords(Pointer<CCBorda> ccba,
            int coordtype) {
        return ccbaStepChainsToPixCoords(Pointer.getPeer(ccba), coordtype);
    }

    protected native static int ccbaStepChainsToPixCoords(@Ptr long ccba,
            int coordtype);

    /**
     * Original signature :
     * <code>l_int32 ccbaGenerateSPGlobalLocs(CCBORDA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:367</i>
     */
    public static int ccbaGenerateSPGlobalLocs(Pointer<CCBorda> ccba,
            int ptsflag) {
        return ccbaGenerateSPGlobalLocs(Pointer.getPeer(ccba), ptsflag);
    }

    protected native static int ccbaGenerateSPGlobalLocs(@Ptr long ccba,
            int ptsflag);

    /**
     * Original signature :
     * <code>l_int32 ccbaGenerateSinglePath(CCBORDA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:368</i>
     */
    public static int ccbaGenerateSinglePath(Pointer<CCBorda> ccba) {
        return ccbaGenerateSinglePath(Pointer.getPeer(ccba));
    }

    protected native static int ccbaGenerateSinglePath(@Ptr long ccba) throws LastError;

    /**
     * Original signature :
     * <code>PTA* getCutPathForHole(PIX*, PTA*, BOX*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:369</i>
     */
    public static Pointer<Pta> getCutPathForHole(Pointer<Pix> pix,
            Pointer<Pta> pta, Pointer<Box> boxinner, Pointer<Integer> pdir,
            Pointer<Integer> plen) {
        return (Pointer) Pointer.pointerToAddress(
                getCutPathForHole(Pointer.getPeer(pix), Pointer.getPeer(pta),
                        Pointer.getPeer(boxinner), Pointer.getPeer(pdir),
                        Pointer.getPeer(plen)), Pta.class);
    }

    @Ptr
    protected native static long getCutPathForHole(@Ptr long pix,
            @Ptr long pta, @Ptr long boxinner, @Ptr long pdir, @Ptr long plen);

    /**
     * Original signature : <code>PIX* ccbaDisplayBorder(CCBORDA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:370</i>
     */
    public static Pointer<Pix> ccbaDisplayBorder(Pointer<CCBorda> ccba) {
        return (Pointer) Pointer.pointerToAddress(
                ccbaDisplayBorder(Pointer.getPeer(ccba)), Pix.class);
    }

    @Ptr
    protected native static long ccbaDisplayBorder(@Ptr long ccba) throws LastError;

    /**
     * Original signature : <code>PIX* ccbaDisplaySPBorder(CCBORDA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:371</i>
     */
    public static Pointer<Pix> ccbaDisplaySPBorder(Pointer<CCBorda> ccba) {
        return (Pointer) Pointer.pointerToAddress(
                ccbaDisplaySPBorder(Pointer.getPeer(ccba)), Pix.class);
    }

    @Ptr
    protected native static long ccbaDisplaySPBorder(@Ptr long ccba) throws LastError;

    /**
     * Original signature : <code>PIX* ccbaDisplayImage1(CCBORDA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:372</i>
     */
    public static Pointer<Pix> ccbaDisplayImage1(Pointer<CCBorda> ccba) {
        return (Pointer) Pointer.pointerToAddress(
                ccbaDisplayImage1(Pointer.getPeer(ccba)), Pix.class);
    }

    @Ptr
    protected native static long ccbaDisplayImage1(@Ptr long ccba) throws LastError;

    /**
     * Original signature : <code>PIX* ccbaDisplayImage2(CCBORDA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:373</i>
     */
    public static Pointer<Pix> ccbaDisplayImage2(Pointer<CCBorda> ccba) {
        return (Pointer) Pointer.pointerToAddress(
                ccbaDisplayImage2(Pointer.getPeer(ccba)), Pix.class);
    }

    @Ptr
    protected native static long ccbaDisplayImage2(@Ptr long ccba) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 ccbaWrite(const char*, CCBORDA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:374</i>
     */
    public static int ccbaWrite(Pointer<Byte> filename, Pointer<CCBorda> ccba) {
        return ccbaWrite(Pointer.getPeer(filename), Pointer.getPeer(ccba));
    }

    protected native static int ccbaWrite(@Ptr long filename, @Ptr long ccba) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 ccbaWriteStream(FILE*, CCBORDA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:375</i>
     */
    public static int ccbaWriteStream(Pointer<FILE> fp,
            Pointer<CCBorda> ccba) {
        return ccbaWriteStream(Pointer.getPeer(fp), Pointer.getPeer(ccba));
    }

    protected native static int ccbaWriteStream(@Ptr long fp, @Ptr long ccba) throws LastError;

    /**
     * Original signature : <code>CCBORDA* ccbaRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:376</i>
     */
    public static Pointer<CCBorda> ccbaRead(Pointer<Byte> filename) {
        return (Pointer) Pointer.pointerToAddress(
                ccbaRead(Pointer.getPeer(filename)), CCBorda.class);
    }

    @Ptr
    protected native static long ccbaRead(@Ptr long filename) throws LastError;

    /**
     * Original signature : <code>CCBORDA* ccbaReadStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:377</i>
     */
    public static Pointer<CCBorda> ccbaReadStream(
            Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                ccbaReadStream(Pointer.getPeer(fp)), CCBorda.class);
    }

    @Ptr
    protected native static long ccbaReadStream(@Ptr long fp) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 ccbaWriteSVG(const char*, CCBORDA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:378</i>
     */
    public static int ccbaWriteSVG(Pointer<Byte> filename, Pointer<CCBorda> ccba) {
        return ccbaWriteSVG(Pointer.getPeer(filename), Pointer.getPeer(ccba));
    }

    protected native static int ccbaWriteSVG(@Ptr long filename, @Ptr long ccba) throws LastError;

    /**
     * Original signature :
     * <code>char* ccbaWriteSVGString(const char*, CCBORDA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:379</i>
     */
    public static Pointer<Byte> ccbaWriteSVGString(Pointer<Byte> filename,
            Pointer<CCBorda> ccba) {
        return (Pointer) Pointer.pointerToAddress(
                ccbaWriteSVGString(Pointer.getPeer(filename),
                        Pointer.getPeer(ccba)), Byte.class);
    }

    @Ptr
    protected native static long ccbaWriteSVGString(@Ptr long filename,
            @Ptr long ccba);

    /**
     * Original signature :
     * <code>PIX* pixThin(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:380</i>
     */
    public static Pointer<Pix> pixThin(Pointer<Pix> pixs, int type,
            int connectivity, int maxiters) {
        return (Pointer) Pointer.pointerToAddress(
                pixThin(Pointer.getPeer(pixs), type, connectivity, maxiters),
                Pix.class);
    }

    @Ptr
    protected native static long pixThin(@Ptr long pixs, int type,
            int connectivity, int maxiters);

    /**
     * Original signature :
     * <code>PIX* pixThinGeneral(PIX*, l_int32, SELA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:381</i>
     */
    public static Pointer<Pix> pixThinGeneral(Pointer<Pix> pixs, int type,
            Pointer<Sela> sela, int maxiters) {
        return (Pointer) Pointer.pointerToAddress(
                pixThinGeneral(Pointer.getPeer(pixs), type,
                        Pointer.getPeer(sela), maxiters), Pix.class);
    }

    @Ptr
    protected native static long pixThinGeneral(@Ptr long pixs, int type,
            @Ptr long sela, int maxiters);

    /**
     * Original signature :
     * <code>PIX* pixThinExamples(PIX*, l_int32, l_int32, l_int32, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:382</i>
     */
    public static Pointer<Pix> pixThinExamples(Pointer<Pix> pixs, int type,
            int index, int maxiters, Pointer<Byte> selfile) {
        return (Pointer) Pointer.pointerToAddress(
                pixThinExamples(Pointer.getPeer(pixs), type, index, maxiters,
                        Pointer.getPeer(selfile)), Pix.class);
    }

    @Ptr
    protected native static long pixThinExamples(@Ptr long pixs, int type,
            int index, int maxiters, @Ptr long selfile);

    /**
     * Original signature :
     * <code>l_int32 jbCorrelation(const char*, l_float32, l_float32, l_int32, const char*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:383</i>
     */
    public static int jbCorrelation(Pointer<Byte> dirin, float thresh,
            float weight, int components, Pointer<Byte> rootname,
            int firstpage, int npages, int renderflag) {
        return jbCorrelation(Pointer.getPeer(dirin), thresh, weight,
                components, Pointer.getPeer(rootname), firstpage, npages,
                renderflag);
    }

    protected native static int jbCorrelation(@Ptr long dirin, float thresh,
            float weight, int components, @Ptr long rootname, int firstpage,
            int npages, int renderflag);

    /**
     * Original signature :
     * <code>l_int32 jbRankHaus(const char*, l_int32, l_float32, l_int32, const char*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:384</i>
     */
    public static int jbRankHaus(Pointer<Byte> dirin, int size, float rank,
            int components, Pointer<Byte> rootname, int firstpage, int npages,
            int renderflag) {
        return jbRankHaus(Pointer.getPeer(dirin), size, rank, components,
                Pointer.getPeer(rootname), firstpage, npages, renderflag);
    }

    protected native static int jbRankHaus(@Ptr long dirin, int size,
            float rank, int components, @Ptr long rootname, int firstpage,
            int npages, int renderflag);

    /**
     * Original signature :
     * <code>JBCLASSER* jbWordsInTextlines(const char*, l_int32, l_int32, l_int32, l_float32, l_float32, NUMA**, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:385</i>
     */
    public static Pointer<JbClasser> jbWordsInTextlines(Pointer<Byte> dirin,
            int reduction, int maxwidth, int maxheight, float thresh,
            float weight, Pointer<Pointer<Numa>> pnatl, int firstpage,
            int npages) {
        return (Pointer) Pointer.pointerToAddress(
                jbWordsInTextlines(Pointer.getPeer(dirin), reduction, maxwidth,
                        maxheight, thresh, weight, Pointer.getPeer(pnatl),
                        firstpage, npages), JbClasser.class);
    }

    @Ptr
    protected native static long jbWordsInTextlines(@Ptr long dirin,
            int reduction, int maxwidth, int maxheight, float thresh,
            float weight, @Ptr long pnatl, int firstpage, int npages);

    /**
     * Original signature :
     * <code>l_int32 pixGetWordsInTextlines(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, BOXA**, PIXA**, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:386</i>
     */
    public static int pixGetWordsInTextlines(Pointer<Pix> pixs, int reduction,
            int minwidth, int minheight, int maxwidth, int maxheight,
            Pointer<Pointer<Boxa>> pboxad, Pointer<Pointer<Pixa>> ppixad,
            Pointer<Pointer<Numa>> pnai) {
        return pixGetWordsInTextlines(Pointer.getPeer(pixs), reduction,
                minwidth, minheight, maxwidth, maxheight,
                Pointer.getPeer(pboxad), Pointer.getPeer(ppixad),
                Pointer.getPeer(pnai));
    }

    protected native static int pixGetWordsInTextlines(@Ptr long pixs,
            int reduction, int minwidth, int minheight, int maxwidth,
            int maxheight, @Ptr long pboxad, @Ptr long ppixad, @Ptr long pnai);

    /**
     * Original signature :
     * <code>l_int32 pixGetWordBoxesInTextlines(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, BOXA**, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:387</i>
     */
    public static int pixGetWordBoxesInTextlines(Pointer<Pix> pixs,
            int reduction, int minwidth, int minheight, int maxwidth,
            int maxheight, Pointer<Pointer<Boxa>> pboxad,
            Pointer<Pointer<Numa>> pnai) {
        return pixGetWordBoxesInTextlines(Pointer.getPeer(pixs), reduction,
                minwidth, minheight, maxwidth, maxheight,
                Pointer.getPeer(pboxad), Pointer.getPeer(pnai));
    }

    protected native static int pixGetWordBoxesInTextlines(@Ptr long pixs,
            int reduction, int minwidth, int minheight, int maxwidth,
            int maxheight, @Ptr long pboxad, @Ptr long pnai);

    /**
     * Original signature :
     * <code>NUMAA* boxaExtractSortedPattern(BOXA*, NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:388</i>
     */
    public static Pointer<Numaa> boxaExtractSortedPattern(Pointer<Boxa> boxa,
            Pointer<Numa> na) {
        return (Pointer) Pointer.pointerToAddress(
                boxaExtractSortedPattern(Pointer.getPeer(boxa),
                        Pointer.getPeer(na)), Numaa.class);
    }

    @Ptr
    protected native static long boxaExtractSortedPattern(@Ptr long boxa,
            @Ptr long na);

    /**
     * Original signature :
     * <code>l_int32 numaaCompareImagesByBoxes(NUMAA*, NUMAA*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:389</i>
     */
    public static int numaaCompareImagesByBoxes(Pointer<Numaa> naa1,
            Pointer<Numaa> naa2, int nperline, int nreq, int maxshiftx,
            int maxshifty, int delx, int dely, Pointer<Integer> psame,
            int debugflag) {
        return numaaCompareImagesByBoxes(Pointer.getPeer(naa1),
                Pointer.getPeer(naa2), nperline, nreq, maxshiftx, maxshifty,
                delx, dely, Pointer.getPeer(psame), debugflag);
    }

    protected native static int numaaCompareImagesByBoxes(@Ptr long naa1,
            @Ptr long naa2, int nperline, int nreq, int maxshiftx,
            int maxshifty, int delx, int dely, @Ptr long psame, int debugflag);

    /**
     * Original signature :
     * <code>l_int32 pixColorContent(PIX*, l_int32, l_int32, l_int32, l_int32, PIX**, PIX**, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:390</i>
     */
    public static int pixColorContent(Pointer<Pix> pixs, int rwhite,
            int gwhite, int bwhite, int mingray, Pointer<Pointer<Pix>> ppixr,
            Pointer<Pointer<Pix>> ppixg, Pointer<Pointer<Pix>> ppixb) {
        return pixColorContent(Pointer.getPeer(pixs), rwhite, gwhite, bwhite,
                mingray, Pointer.getPeer(ppixr), Pointer.getPeer(ppixg),
                Pointer.getPeer(ppixb));
    }

    protected native static int pixColorContent(@Ptr long pixs, int rwhite,
            int gwhite, int bwhite, int mingray, @Ptr long ppixr,
            @Ptr long ppixg, @Ptr long ppixb);

    /**
     * Original signature :
     * <code>PIX* pixColorMagnitude(PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:391</i>
     */
    public static Pointer<Pix> pixColorMagnitude(Pointer<Pix> pixs, int rwhite,
            int gwhite, int bwhite, int type) {
        return (Pointer) Pointer.pointerToAddress(
                pixColorMagnitude(Pointer.getPeer(pixs), rwhite, gwhite,
                        bwhite, type), Pix.class);
    }

    @Ptr
    protected native static long pixColorMagnitude(@Ptr long pixs, int rwhite,
            int gwhite, int bwhite, int type);

    /**
     * Original signature :
     * <code>PIX* pixMaskOverColorPixels(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:392</i>
     */
    public static Pointer<Pix> pixMaskOverColorPixels(Pointer<Pix> pixs,
            int threshdiff, int mindist) {
        return (Pointer) Pointer.pointerToAddress(
                pixMaskOverColorPixels(Pointer.getPeer(pixs), threshdiff,
                        mindist), Pix.class);
    }

    @Ptr
    protected native static long pixMaskOverColorPixels(@Ptr long pixs,
            int threshdiff, int mindist);

    /**
     * Original signature :
     * <code>l_int32 pixColorFraction(PIX*, l_int32, l_int32, l_int32, l_int32, l_float32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:393</i>
     */
    public static int pixColorFraction(Pointer<Pix> pixs, int darkthresh,
            int lightthresh, int diffthresh, int factor,
            Pointer<Float> ppixfract, Pointer<Float> pcolorfract) {
        return pixColorFraction(Pointer.getPeer(pixs), darkthresh, lightthresh,
                diffthresh, factor, Pointer.getPeer(ppixfract),
                Pointer.getPeer(pcolorfract));
    }

    protected native static int pixColorFraction(@Ptr long pixs,
            int darkthresh, int lightthresh, int diffthresh, int factor,
            @Ptr long ppixfract, @Ptr long pcolorfract);

    /**
     * Original signature :
     * <code>l_int32 pixNumSignificantGrayColors(PIX*, l_int32, l_int32, l_float32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:394</i>
     */
    public static int pixNumSignificantGrayColors(Pointer<Pix> pixs,
            int darkthresh, int lightthresh, float minfract, int factor,
            Pointer<Integer> pncolors) {
        return pixNumSignificantGrayColors(Pointer.getPeer(pixs), darkthresh,
                lightthresh, minfract, factor, Pointer.getPeer(pncolors));
    }

    protected native static int pixNumSignificantGrayColors(@Ptr long pixs,
            int darkthresh, int lightthresh, float minfract, int factor,
            @Ptr long pncolors);

    /**
     * Original signature :
     * <code>l_int32 pixColorsForQuantization(PIX*, l_int32, l_int32*, l_int32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:395</i>
     */
    public static int pixColorsForQuantization(Pointer<Pix> pixs, int thresh,
            Pointer<Integer> pncolors, Pointer<Integer> piscolor, int debug) {
        return pixColorsForQuantization(Pointer.getPeer(pixs), thresh,
                Pointer.getPeer(pncolors), Pointer.getPeer(piscolor), debug);
    }

    protected native static int pixColorsForQuantization(@Ptr long pixs,
            int thresh, @Ptr long pncolors, @Ptr long piscolor, int debug);

    /**
     * Original signature :
     * <code>l_int32 pixNumColors(PIX*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:396</i>
     */
    public static int pixNumColors(Pointer<Pix> pixs, int factor,
            Pointer<Integer> pncolors) {
        return pixNumColors(Pointer.getPeer(pixs), factor,
                Pointer.getPeer(pncolors));
    }

    protected native static int pixNumColors(@Ptr long pixs, int factor,
            @Ptr long pncolors);

    /**
     * Original signature :
     * <code>l_int32 pixGetMostPopulatedColors(PIX*, l_int32, l_int32, l_int32, l_uint32**, PIXCMAP**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:397</i>
     */
    public static int pixGetMostPopulatedColors(Pointer<Pix> pixs, int sigbits,
            int factor, int ncolors, Pointer<Pointer<Integer>> parray,
            Pointer<Pointer<PixColormap>> pcmap) {
        return pixGetMostPopulatedColors(Pointer.getPeer(pixs), sigbits,
                factor, ncolors, Pointer.getPeer(parray),
                Pointer.getPeer(pcmap));
    }

    protected native static int pixGetMostPopulatedColors(@Ptr long pixs,
            int sigbits, int factor, int ncolors, @Ptr long parray,
            @Ptr long pcmap);

    /**
     * Original signature :
     * <code>PIX* pixSimpleColorQuantize(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:398</i>
     */
    public static Pointer<Pix> pixSimpleColorQuantize(Pointer<Pix> pixs,
            int sigbits, int factor, int ncolors) {
        return (Pointer) Pointer.pointerToAddress(
                pixSimpleColorQuantize(Pointer.getPeer(pixs), sigbits, factor,
                        ncolors), Pix.class);
    }

    @Ptr
    protected native static long pixSimpleColorQuantize(@Ptr long pixs,
            int sigbits, int factor, int ncolors);

    /**
     * Original signature :
     * <code>NUMA* pixGetRGBHistogram(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:399</i>
     */
    public static Pointer<Numa> pixGetRGBHistogram(Pointer<Pix> pixs,
            int sigbits, int factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetRGBHistogram(Pointer.getPeer(pixs), sigbits, factor),
                Numa.class);
    }

    @Ptr
    protected native static long pixGetRGBHistogram(@Ptr long pixs,
            int sigbits, int factor);

    /**
     * Original signature :
     * <code>l_int32 makeRGBIndexTables(l_uint32**, l_uint32**, l_uint32**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:400</i>
     */
    public static int makeRGBIndexTables(Pointer<Pointer<Integer>> prtab,
            Pointer<Pointer<Integer>> pgtab, Pointer<Pointer<Integer>> pbtab,
            int sigbits) {
        return makeRGBIndexTables(Pointer.getPeer(prtab),
                Pointer.getPeer(pgtab), Pointer.getPeer(pbtab), sigbits);
    }

    protected native static int makeRGBIndexTables(@Ptr long prtab,
            @Ptr long pgtab, @Ptr long pbtab, int sigbits);

    /**
     * Original signature :
     * <code>l_int32 getRGBFromIndex(l_uint32, l_int32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:401</i>
     */
    public static int getRGBFromIndex(int index, int sigbits,
            Pointer<Integer> prval, Pointer<Integer> pgval,
            Pointer<Integer> pbval) {
        return getRGBFromIndex(index, sigbits, Pointer.getPeer(prval),
                Pointer.getPeer(pgval), Pointer.getPeer(pbval));
    }

    protected native static int getRGBFromIndex(int index, int sigbits,
            @Ptr long prval, @Ptr long pgval, @Ptr long pbval);

    /**
     * Original signature :
     * <code>PIX* pixColorGrayRegions(PIX*, BOXA*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:402</i>
     */
    public static Pointer<Pix> pixColorGrayRegions(Pointer<Pix> pixs,
            Pointer<Boxa> boxa, int type, int thresh, int rval, int gval,
            int bval) {
        return (Pointer) Pointer.pointerToAddress(
                pixColorGrayRegions(Pointer.getPeer(pixs),
                        Pointer.getPeer(boxa), type, thresh, rval, gval, bval),
                Pix.class);
    }

    @Ptr
    protected native static long pixColorGrayRegions(@Ptr long pixs,
            @Ptr long boxa, int type, int thresh, int rval, int gval, int bval);

    /**
     * Original signature :
     * <code>l_int32 pixColorGray(PIX*, BOX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:403</i>
     */
    public static int pixColorGray(Pointer<Pix> pixs, Pointer<Box> box,
            int type, int thresh, int rval, int gval, int bval) {
        return pixColorGray(Pointer.getPeer(pixs), Pointer.getPeer(box), type,
                thresh, rval, gval, bval);
    }

    protected native static int pixColorGray(@Ptr long pixs, @Ptr long box,
            int type, int thresh, int rval, int gval, int bval);

    /**
     * Original signature :
     * <code>PIX* pixSnapColor(PIX*, PIX*, l_uint32, l_uint32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:404</i>
     */
    public static Pointer<Pix> pixSnapColor(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int srcval, int dstval, int diff) {
        return (Pointer) Pointer.pointerToAddress(
                pixSnapColor(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        srcval, dstval, diff), Pix.class);
    }

    @Ptr
    protected native static long pixSnapColor(@Ptr long pixd, @Ptr long pixs,
            int srcval, int dstval, int diff);

    /**
     * Original signature :
     * <code>PIX* pixSnapColorCmap(PIX*, PIX*, l_uint32, l_uint32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:405</i>
     */
    public static Pointer<Pix> pixSnapColorCmap(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int srcval, int dstval, int diff) {
        return (Pointer) Pointer.pointerToAddress(
                pixSnapColorCmap(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        srcval, dstval, diff), Pix.class);
    }

    @Ptr
    protected native static long pixSnapColorCmap(@Ptr long pixd,
            @Ptr long pixs, int srcval, int dstval, int diff);

    /**
     * Original signature :
     * <code>PIX* pixLinearMapToTargetColor(PIX*, PIX*, l_uint32, l_uint32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:406</i>
     */
    public static Pointer<Pix> pixLinearMapToTargetColor(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int srcval, int dstval) {
        return (Pointer) Pointer.pointerToAddress(
                pixLinearMapToTargetColor(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), srcval, dstval), Pix.class);
    }

    @Ptr
    protected native static long pixLinearMapToTargetColor(@Ptr long pixd,
            @Ptr long pixs, int srcval, int dstval);

    /**
     * Original signature :
     * <code>l_int32 pixelLinearMapToTargetColor(l_uint32, l_uint32, l_uint32, l_uint32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:407</i>
     */
    public static int pixelLinearMapToTargetColor(int scolor, int srcmap,
            int dstmap, Pointer<Integer> pdcolor) {
        return pixelLinearMapToTargetColor(scolor, srcmap, dstmap,
                Pointer.getPeer(pdcolor));
    }

    protected native static int pixelLinearMapToTargetColor(int scolor,
            int srcmap, int dstmap, @Ptr long pdcolor);

    /**
     * Original signature :
     * <code>PIX* pixShiftByComponent(PIX*, PIX*, l_uint32, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:408</i>
     */
    public static Pointer<Pix> pixShiftByComponent(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int srcval, int dstval) {
        return (Pointer) Pointer.pointerToAddress(
                pixShiftByComponent(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), srcval, dstval), Pix.class);
    }

    @Ptr
    protected native static long pixShiftByComponent(@Ptr long pixd,
            @Ptr long pixs, int srcval, int dstval);

    /**
     * Original signature :
     * <code>l_int32 pixelShiftByComponent(l_int32, l_int32, l_int32, l_uint32, l_uint32, l_uint32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:409</i>
     */
    public static int pixelShiftByComponent(int rval, int gval, int bval,
            int srcval, int dstval, Pointer<Integer> ppixel) {
        return pixelShiftByComponent(rval, gval, bval, srcval, dstval,
                Pointer.getPeer(ppixel));
    }

    protected native static int pixelShiftByComponent(int rval, int gval,
            int bval, int srcval, int dstval, @Ptr long ppixel);

    /**
     * Original signature :
     * <code>l_int32 pixelFractionalShift(l_int32, l_int32, l_int32, l_float32, l_uint32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:410</i>
     */
    public static int pixelFractionalShift(int rval, int gval, int bval,
            float fraction, Pointer<Integer> ppixel) {
        return pixelFractionalShift(rval, gval, bval, fraction,
                Pointer.getPeer(ppixel));
    }

    protected native static int pixelFractionalShift(int rval, int gval,
            int bval, float fraction, @Ptr long ppixel);

    /**
     * Original signature : <code>PIXCMAP* pixcmapCreate(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:411</i>
     */
    public static Pointer<PixColormap> pixcmapCreate(int depth) {
        return (Pointer) Pointer.pointerToAddress(pixcmapCreate$2(depth),
                PixColormap.class);
    }

    @Ptr
    @Name("pixcmapCreate")
    protected native static long pixcmapCreate$2(int depth) throws LastError;

    /**
     * Original signature :
     * <code>PIXCMAP* pixcmapCreateRandom(l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:412</i>
     */
    public static Pointer<PixColormap> pixcmapCreateRandom(int depth,
            int hasblack, int haswhite) {
        return (Pointer) Pointer.pointerToAddress(
                pixcmapCreateRandom$2(depth, hasblack, haswhite),
                PixColormap.class);
    }

    @Ptr
    @Name("pixcmapCreateRandom")
    protected native static long pixcmapCreateRandom$2(int depth, int hasblack,
            int haswhite);

    /**
     * Original signature :
     * <code>PIXCMAP* pixcmapCreateLinear(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:413</i>
     */
    public static Pointer<PixColormap> pixcmapCreateLinear(int d, int nlevels) {
        return (Pointer) Pointer.pointerToAddress(
                pixcmapCreateLinear$2(d, nlevels), PixColormap.class);
    }

    @Ptr
    @Name("pixcmapCreateLinear")
    protected native static long pixcmapCreateLinear$2(int d, int nlevels) throws LastError;

    /**
     * Original signature : <code>PIXCMAP* pixcmapCopy(PIXCMAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:414</i>
     */
    public static Pointer<PixColormap> pixcmapCopy(Pointer<PixColormap> cmaps) {
        return (Pointer) Pointer.pointerToAddress(
                pixcmapCopy(Pointer.getPeer(cmaps)), PixColormap.class);
    }

    @Ptr
    protected native static long pixcmapCopy(@Ptr long cmaps) throws LastError;

    /**
     * Original signature : <code>void pixcmapDestroy(PIXCMAP**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:415</i>
     */
    public static void pixcmapDestroy(Pointer<Pointer<PixColormap>> pcmap) {
        pixcmapDestroy(Pointer.getPeer(pcmap));
    }

    protected native static void pixcmapDestroy(@Ptr long pcmap) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixcmapAddColor(PIXCMAP*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:416</i>
     */
    public static int pixcmapAddColor(Pointer<PixColormap> cmap, int rval,
            int gval, int bval) {
        return pixcmapAddColor(Pointer.getPeer(cmap), rval, gval, bval);
    }

    protected native static int pixcmapAddColor(@Ptr long cmap, int rval,
            int gval, int bval);

    /**
     * Original signature :
     * <code>l_int32 pixcmapAddRGBA(PIXCMAP*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:417</i>
     */
    public static int pixcmapAddRGBA(Pointer<PixColormap> cmap, int rval,
            int gval, int bval, int aval) {
        return pixcmapAddRGBA(Pointer.getPeer(cmap), rval, gval, bval, aval);
    }

    protected native static int pixcmapAddRGBA(@Ptr long cmap, int rval,
            int gval, int bval, int aval);

    /**
     * Original signature :
     * <code>l_int32 pixcmapAddNewColor(PIXCMAP*, l_int32, l_int32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:418</i>
     */
    public static int pixcmapAddNewColor(Pointer<PixColormap> cmap, int rval,
            int gval, int bval, Pointer<Integer> pindex) {
        return pixcmapAddNewColor(Pointer.getPeer(cmap), rval, gval, bval,
                Pointer.getPeer(pindex));
    }

    protected native static int pixcmapAddNewColor(@Ptr long cmap, int rval,
            int gval, int bval, @Ptr long pindex);

    /**
     * Original signature :
     * <code>l_int32 pixcmapAddNearestColor(PIXCMAP*, l_int32, l_int32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:419</i>
     */
    public static int pixcmapAddNearestColor(Pointer<PixColormap> cmap,
            int rval, int gval, int bval, Pointer<Integer> pindex) {
        return pixcmapAddNearestColor(Pointer.getPeer(cmap), rval, gval, bval,
                Pointer.getPeer(pindex));
    }

    protected native static int pixcmapAddNearestColor(@Ptr long cmap,
            int rval, int gval, int bval, @Ptr long pindex);

    /**
     * Original signature :
     * <code>l_int32 pixcmapUsableColor(PIXCMAP*, l_int32, l_int32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:420</i>
     */
    public static int pixcmapUsableColor(Pointer<PixColormap> cmap, int rval,
            int gval, int bval, Pointer<Integer> pusable) {
        return pixcmapUsableColor(Pointer.getPeer(cmap), rval, gval, bval,
                Pointer.getPeer(pusable));
    }

    protected native static int pixcmapUsableColor(@Ptr long cmap, int rval,
            int gval, int bval, @Ptr long pusable);

    /**
     * Original signature :
     * <code>l_int32 pixcmapAddBlackOrWhite(PIXCMAP*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:421</i>
     */
    public static int pixcmapAddBlackOrWhite(Pointer<PixColormap> cmap,
            int color, Pointer<Integer> pindex) {
        return pixcmapAddBlackOrWhite(Pointer.getPeer(cmap), color,
                Pointer.getPeer(pindex));
    }

    protected native static int pixcmapAddBlackOrWhite(@Ptr long cmap,
            int color, @Ptr long pindex);

    /**
     * Original signature :
     * <code>l_int32 pixcmapSetBlackAndWhite(PIXCMAP*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:422</i>
     */
    public static int pixcmapSetBlackAndWhite(Pointer<PixColormap> cmap,
            int setblack, int setwhite) {
        return pixcmapSetBlackAndWhite(Pointer.getPeer(cmap), setblack,
                setwhite);
    }

    protected native static int pixcmapSetBlackAndWhite(@Ptr long cmap,
            int setblack, int setwhite);

    /**
     * Original signature : <code>l_int32 pixcmapGetCount(PIXCMAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:423</i>
     */
    public static int pixcmapGetCount(Pointer<PixColormap> cmap) {
        return pixcmapGetCount(Pointer.getPeer(cmap));
    }

    protected native static int pixcmapGetCount(@Ptr long cmap) throws LastError;

    /**
     * Original signature : <code>l_int32 pixcmapGetFreeCount(PIXCMAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:424</i>
     */
    public static int pixcmapGetFreeCount(Pointer<PixColormap> cmap) {
        return pixcmapGetFreeCount(Pointer.getPeer(cmap));
    }

    protected native static int pixcmapGetFreeCount(@Ptr long cmap) throws LastError;

    /**
     * Original signature : <code>l_int32 pixcmapGetDepth(PIXCMAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:425</i>
     */
    public static int pixcmapGetDepth(Pointer<PixColormap> cmap) {
        return pixcmapGetDepth(Pointer.getPeer(cmap));
    }

    protected native static int pixcmapGetDepth(@Ptr long cmap) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixcmapGetMinDepth(PIXCMAP*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:426</i>
     */
    public static int pixcmapGetMinDepth(Pointer<PixColormap> cmap,
            Pointer<Integer> pmindepth) {
        return pixcmapGetMinDepth(Pointer.getPeer(cmap),
                Pointer.getPeer(pmindepth));
    }

    protected native static int pixcmapGetMinDepth(@Ptr long cmap,
            @Ptr long pmindepth);

    /**
     * Original signature : <code>l_int32 pixcmapClear(PIXCMAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:427</i>
     */
    public static int pixcmapClear(Pointer<PixColormap> cmap) {
        return pixcmapClear(Pointer.getPeer(cmap));
    }

    protected native static int pixcmapClear(@Ptr long cmap) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixcmapGetColor(PIXCMAP*, l_int32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:428</i>
     */
    public static int pixcmapGetColor(Pointer<PixColormap> cmap, int index,
            Pointer<Integer> prval, Pointer<Integer> pgval,
            Pointer<Integer> pbval) {
        return pixcmapGetColor(Pointer.getPeer(cmap), index,
                Pointer.getPeer(prval), Pointer.getPeer(pgval),
                Pointer.getPeer(pbval));
    }

    protected native static int pixcmapGetColor(@Ptr long cmap, int index,
            @Ptr long prval, @Ptr long pgval, @Ptr long pbval);

    /**
     * Original signature :
     * <code>l_int32 pixcmapGetColor32(PIXCMAP*, l_int32, l_uint32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:429</i>
     */
    public static int pixcmapGetColor32(Pointer<PixColormap> cmap, int index,
            Pointer<Integer> pval32) {
        return pixcmapGetColor32(Pointer.getPeer(cmap), index,
                Pointer.getPeer(pval32));
    }

    protected native static int pixcmapGetColor32(@Ptr long cmap, int index,
            @Ptr long pval32);

    /**
     * Original signature :
     * <code>l_int32 pixcmapGetRGBA(PIXCMAP*, l_int32, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:430</i>
     */
    public static int pixcmapGetRGBA(Pointer<PixColormap> cmap, int index,
            Pointer<Integer> prval, Pointer<Integer> pgval,
            Pointer<Integer> pbval, Pointer<Integer> paval) {
        return pixcmapGetRGBA(Pointer.getPeer(cmap), index,
                Pointer.getPeer(prval), Pointer.getPeer(pgval),
                Pointer.getPeer(pbval), Pointer.getPeer(paval));
    }

    protected native static int pixcmapGetRGBA(@Ptr long cmap, int index,
            @Ptr long prval, @Ptr long pgval, @Ptr long pbval, @Ptr long paval);

    /**
     * Original signature :
     * <code>l_int32 pixcmapGetRGBA32(PIXCMAP*, l_int32, l_uint32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:431</i>
     */
    public static int pixcmapGetRGBA32(Pointer<PixColormap> cmap, int index,
            Pointer<Integer> pval32) {
        return pixcmapGetRGBA32(Pointer.getPeer(cmap), index,
                Pointer.getPeer(pval32));
    }

    protected native static int pixcmapGetRGBA32(@Ptr long cmap, int index,
            @Ptr long pval32);

    /**
     * Original signature :
     * <code>l_int32 pixcmapResetColor(PIXCMAP*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:432</i>
     */
    public static int pixcmapResetColor(Pointer<PixColormap> cmap, int index,
            int rval, int gval, int bval) {
        return pixcmapResetColor(Pointer.getPeer(cmap), index, rval, gval, bval);
    }

    protected native static int pixcmapResetColor(@Ptr long cmap, int index,
            int rval, int gval, int bval);

    /**
     * Original signature :
     * <code>l_int32 pixcmapGetIndex(PIXCMAP*, l_int32, l_int32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:433</i>
     */
    public static int pixcmapGetIndex(Pointer<PixColormap> cmap, int rval,
            int gval, int bval, Pointer<Integer> pindex) {
        return pixcmapGetIndex(Pointer.getPeer(cmap), rval, gval, bval,
                Pointer.getPeer(pindex));
    }

    protected native static int pixcmapGetIndex(@Ptr long cmap, int rval,
            int gval, int bval, @Ptr long pindex);

    /**
     * Original signature :
     * <code>l_int32 pixcmapHasColor(PIXCMAP*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:434</i>
     */
    public static int pixcmapHasColor(Pointer<PixColormap> cmap,
            Pointer<Integer> pcolor) {
        return pixcmapHasColor(Pointer.getPeer(cmap), Pointer.getPeer(pcolor));
    }

    protected native static int pixcmapHasColor(@Ptr long cmap, @Ptr long pcolor) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixcmapIsOpaque(PIXCMAP*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:435</i>
     */
    public static int pixcmapIsOpaque(Pointer<PixColormap> cmap,
            Pointer<Integer> popaque) {
        return pixcmapIsOpaque(Pointer.getPeer(cmap), Pointer.getPeer(popaque));
    }

    protected native static int pixcmapIsOpaque(@Ptr long cmap,
            @Ptr long popaque);

    /**
     * Original signature :
     * <code>l_int32 pixcmapCountGrayColors(PIXCMAP*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:436</i>
     */
    public static int pixcmapCountGrayColors(Pointer<PixColormap> cmap,
            Pointer<Integer> pngray) {
        return pixcmapCountGrayColors(Pointer.getPeer(cmap),
                Pointer.getPeer(pngray));
    }

    protected native static int pixcmapCountGrayColors(@Ptr long cmap,
            @Ptr long pngray);

    /**
     * Original signature :
     * <code>l_int32 pixcmapGetRankIntensity(PIXCMAP*, l_float32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:437</i>
     */
    public static int pixcmapGetRankIntensity(Pointer<PixColormap> cmap,
            float rankval, Pointer<Integer> pindex) {
        return pixcmapGetRankIntensity(Pointer.getPeer(cmap), rankval,
                Pointer.getPeer(pindex));
    }

    protected native static int pixcmapGetRankIntensity(@Ptr long cmap,
            float rankval, @Ptr long pindex);

    /**
     * Original signature :
     * <code>l_int32 pixcmapGetNearestIndex(PIXCMAP*, l_int32, l_int32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:438</i>
     */
    public static int pixcmapGetNearestIndex(Pointer<PixColormap> cmap,
            int rval, int gval, int bval, Pointer<Integer> pindex) {
        return pixcmapGetNearestIndex(Pointer.getPeer(cmap), rval, gval, bval,
                Pointer.getPeer(pindex));
    }

    protected native static int pixcmapGetNearestIndex(@Ptr long cmap,
            int rval, int gval, int bval, @Ptr long pindex);

    /**
     * Original signature :
     * <code>l_int32 pixcmapGetNearestGrayIndex(PIXCMAP*, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:439</i>
     */
    public static int pixcmapGetNearestGrayIndex(Pointer<PixColormap> cmap,
            int val, Pointer<Integer> pindex) {
        return pixcmapGetNearestGrayIndex(Pointer.getPeer(cmap), val,
                Pointer.getPeer(pindex));
    }

    protected native static int pixcmapGetNearestGrayIndex(@Ptr long cmap,
            int val, @Ptr long pindex);

    /**
     * Original signature :
     * <code>l_int32 pixcmapGetComponentRange(PIXCMAP*, l_int32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:440</i>
     */
    public static int pixcmapGetComponentRange(Pointer<PixColormap> cmap,
            int color, Pointer<Integer> pminval, Pointer<Integer> pmaxval) {
        return pixcmapGetComponentRange(Pointer.getPeer(cmap), color,
                Pointer.getPeer(pminval), Pointer.getPeer(pmaxval));
    }

    protected native static int pixcmapGetComponentRange(@Ptr long cmap,
            int color, @Ptr long pminval, @Ptr long pmaxval);

    /**
     * Original signature :
     * <code>l_int32 pixcmapGetExtremeValue(PIXCMAP*, l_int32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:441</i>
     */
    public static int pixcmapGetExtremeValue(Pointer<PixColormap> cmap,
            int type, Pointer<Integer> prval, Pointer<Integer> pgval,
            Pointer<Integer> pbval) {
        return pixcmapGetExtremeValue(Pointer.getPeer(cmap), type,
                Pointer.getPeer(prval), Pointer.getPeer(pgval),
                Pointer.getPeer(pbval));
    }

    protected native static int pixcmapGetExtremeValue(@Ptr long cmap,
            int type, @Ptr long prval, @Ptr long pgval, @Ptr long pbval);

    /**
     * Original signature : <code>PIXCMAP* pixcmapGrayToColor(l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:442</i>
     */
    public static Pointer<PixColormap> pixcmapGrayToColor(int color) {
        return (Pointer) Pointer.pointerToAddress(pixcmapGrayToColor$2(color),
                PixColormap.class);
    }

    @Ptr
    @Name("pixcmapGrayToColor")
    protected native static long pixcmapGrayToColor$2(int color) throws LastError;

    /**
     * Original signature :
     * <code>PIXCMAP* pixcmapColorToGray(PIXCMAP*, l_float32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:443</i>
     */
    public static Pointer<PixColormap> pixcmapColorToGray(
            Pointer<PixColormap> cmaps, float rwt, float gwt, float bwt) {
        return (Pointer) Pointer.pointerToAddress(
                pixcmapColorToGray(Pointer.getPeer(cmaps), rwt, gwt, bwt),
                PixColormap.class);
    }

    @Ptr
    protected native static long pixcmapColorToGray(@Ptr long cmaps, float rwt,
            float gwt, float bwt);

    /**
     * Original signature : <code>PIXCMAP* pixcmapReadStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:444</i>
     */
    public static Pointer<PixColormap> pixcmapReadStream(
            Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                pixcmapReadStream(Pointer.getPeer(fp)), PixColormap.class);
    }

    @Ptr
    protected native static long pixcmapReadStream(@Ptr long fp) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixcmapWriteStream(FILE*, PIXCMAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:445</i>
     */
    public static int pixcmapWriteStream(Pointer<FILE> fp,
            Pointer<PixColormap> cmap) {
        return pixcmapWriteStream(Pointer.getPeer(fp), Pointer.getPeer(cmap));
    }

    protected native static int pixcmapWriteStream(@Ptr long fp, @Ptr long cmap) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixcmapToArrays(PIXCMAP*, l_int32**, l_int32**, l_int32**, l_int32**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:446</i>
     */
    public static int pixcmapToArrays(Pointer<PixColormap> cmap,
            Pointer<Pointer<Integer>> prmap, Pointer<Pointer<Integer>> pgmap,
            Pointer<Pointer<Integer>> pbmap, Pointer<Pointer<Integer>> pamap) {
        return pixcmapToArrays(Pointer.getPeer(cmap), Pointer.getPeer(prmap),
                Pointer.getPeer(pgmap), Pointer.getPeer(pbmap),
                Pointer.getPeer(pamap));
    }

    protected native static int pixcmapToArrays(@Ptr long cmap,
            @Ptr long prmap, @Ptr long pgmap, @Ptr long pbmap, @Ptr long pamap);

    /**
     * Original signature :
     * <code>l_int32 pixcmapToRGBTable(PIXCMAP*, l_uint32**, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:447</i>
     */
    public static int pixcmapToRGBTable(Pointer<PixColormap> cmap,
            Pointer<Pointer<Integer>> ptab, Pointer<Integer> pncolors) {
        return pixcmapToRGBTable(Pointer.getPeer(cmap), Pointer.getPeer(ptab),
                Pointer.getPeer(pncolors));
    }

    protected native static int pixcmapToRGBTable(@Ptr long cmap,
            @Ptr long ptab, @Ptr long pncolors);

    /**
     * Original signature :
     * <code>l_int32 pixcmapSerializeToMemory(PIXCMAP*, l_int32, l_int32*, l_uint8**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:448</i>
     */
    public static int pixcmapSerializeToMemory(Pointer<PixColormap> cmap,
            int cpc, Pointer<Integer> pncolors, Pointer<Pointer<Byte>> pdata) {
        return pixcmapSerializeToMemory(Pointer.getPeer(cmap), cpc,
                Pointer.getPeer(pncolors), Pointer.getPeer(pdata));
    }

    protected native static int pixcmapSerializeToMemory(@Ptr long cmap,
            int cpc, @Ptr long pncolors, @Ptr long pdata);

    /**
     * Original signature :
     * <code>PIXCMAP* pixcmapDeserializeFromMemory(l_uint8*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:449</i>
     */
    public static Pointer<PixColormap> pixcmapDeserializeFromMemory(
            Pointer<Byte> data, int cpc, int ncolors) {
        return (Pointer) Pointer.pointerToAddress(
                pixcmapDeserializeFromMemory(Pointer.getPeer(data), cpc,
                        ncolors), PixColormap.class);
    }

    @Ptr
    protected native static long pixcmapDeserializeFromMemory(@Ptr long data,
            int cpc, int ncolors);

    /**
     * Original signature :
     * <code>char* pixcmapConvertToHex(l_uint8*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:450</i>
     */
    public static Pointer<Byte> pixcmapConvertToHex(Pointer<Byte> data,
            int ncolors) {
        return (Pointer) Pointer.pointerToAddress(
                pixcmapConvertToHex(Pointer.getPeer(data), ncolors), Byte.class);
    }

    @Ptr
    protected native static long pixcmapConvertToHex(@Ptr long data, int ncolors) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixcmapGammaTRC(PIXCMAP*, l_float32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:451</i>
     */
    public static int pixcmapGammaTRC(Pointer<PixColormap> cmap, float gamma,
            int minval, int maxval) {
        return pixcmapGammaTRC(Pointer.getPeer(cmap), gamma, minval, maxval);
    }

    protected native static int pixcmapGammaTRC(@Ptr long cmap, float gamma,
            int minval, int maxval);

    /**
     * Original signature :
     * <code>l_int32 pixcmapContrastTRC(PIXCMAP*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:452</i>
     */
    public static int pixcmapContrastTRC(Pointer<PixColormap> cmap, float factor) {
        return pixcmapContrastTRC(Pointer.getPeer(cmap), factor);
    }

    protected native static int pixcmapContrastTRC(@Ptr long cmap, float factor) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixcmapShiftIntensity(PIXCMAP*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:453</i>
     */
    public static int pixcmapShiftIntensity(Pointer<PixColormap> cmap,
            float fraction) {
        return pixcmapShiftIntensity(Pointer.getPeer(cmap), fraction);
    }

    protected native static int pixcmapShiftIntensity(@Ptr long cmap,
            float fraction);

    /**
     * Original signature :
     * <code>l_int32 pixcmapShiftByComponent(PIXCMAP*, l_uint32, l_uint32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:454</i>
     */
    public static int pixcmapShiftByComponent(Pointer<PixColormap> cmap,
            int srcval, int dstval) {
        return pixcmapShiftByComponent(Pointer.getPeer(cmap), srcval, dstval);
    }

    protected native static int pixcmapShiftByComponent(@Ptr long cmap,
            int srcval, int dstval);

    /**
     * Original signature :
     * <code>PIX* pixColorMorph(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:455</i>
     */
    public static Pointer<Pix> pixColorMorph(Pointer<Pix> pixs, int type,
            int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixColorMorph(Pointer.getPeer(pixs), type, hsize, vsize),
                Pix.class);
    }

    @Ptr
    protected native static long pixColorMorph(@Ptr long pixs, int type,
            int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixOctreeColorQuant(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:456</i>
     */
    public static Pointer<Pix> pixOctreeColorQuant(Pointer<Pix> pixs,
            int colors, int ditherflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixOctreeColorQuant(Pointer.getPeer(pixs), colors, ditherflag),
                Pix.class);
    }

    @Ptr
    protected native static long pixOctreeColorQuant(@Ptr long pixs,
            int colors, int ditherflag);

    /**
     * Original signature :
     * <code>PIX* pixOctreeColorQuantGeneral(PIX*, l_int32, l_int32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:457</i>
     */
    public static Pointer<Pix> pixOctreeColorQuantGeneral(Pointer<Pix> pixs,
            int colors, int ditherflag, float validthresh, float colorthresh) {
        return (Pointer) Pointer.pointerToAddress(
                pixOctreeColorQuantGeneral(Pointer.getPeer(pixs), colors,
                        ditherflag, validthresh, colorthresh), Pix.class);
    }

    @Ptr
    protected native static long pixOctreeColorQuantGeneral(@Ptr long pixs,
            int colors, int ditherflag, float validthresh, float colorthresh);

    /**
     * Original signature :
     * <code>l_int32 makeRGBToIndexTables(l_uint32**, l_uint32**, l_uint32**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:458</i>
     */
    public static int makeRGBToIndexTables(Pointer<Pointer<Integer>> prtab,
            Pointer<Pointer<Integer>> pgtab, Pointer<Pointer<Integer>> pbtab,
            int cqlevels) {
        return makeRGBToIndexTables(Pointer.getPeer(prtab),
                Pointer.getPeer(pgtab), Pointer.getPeer(pbtab), cqlevels);
    }

    protected native static int makeRGBToIndexTables(@Ptr long prtab,
            @Ptr long pgtab, @Ptr long pbtab, int cqlevels);

    /**
     * Original signature :
     * <code>void getOctcubeIndexFromRGB(l_int32, l_int32, l_int32, l_uint32*, l_uint32*, l_uint32*, l_uint32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:459</i>
     */
    public static void getOctcubeIndexFromRGB(int rval, int gval, int bval,
            Pointer<Integer> rtab, Pointer<Integer> gtab,
            Pointer<Integer> btab, Pointer<Integer> pindex) {
        getOctcubeIndexFromRGB(rval, gval, bval, Pointer.getPeer(rtab),
                Pointer.getPeer(gtab), Pointer.getPeer(btab),
                Pointer.getPeer(pindex));
    }

    protected native static void getOctcubeIndexFromRGB(int rval, int gval,
            int bval, @Ptr long rtab, @Ptr long gtab, @Ptr long btab,
            @Ptr long pindex);

    /**
     * Original signature :
     * <code>PIX* pixOctreeQuantByPopulation(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:460</i>
     */
    public static Pointer<Pix> pixOctreeQuantByPopulation(Pointer<Pix> pixs,
            int level, int ditherflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixOctreeQuantByPopulation(Pointer.getPeer(pixs), level,
                        ditherflag), Pix.class);
    }

    @Ptr
    protected native static long pixOctreeQuantByPopulation(@Ptr long pixs,
            int level, int ditherflag);

    /**
     * Original signature :
     * <code>PIX* pixOctreeQuantNumColors(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:461</i>
     */
    public static Pointer<Pix> pixOctreeQuantNumColors(Pointer<Pix> pixs,
            int maxcolors, int subsample) {
        return (Pointer) Pointer.pointerToAddress(
                pixOctreeQuantNumColors(Pointer.getPeer(pixs), maxcolors,
                        subsample), Pix.class);
    }

    @Ptr
    protected native static long pixOctreeQuantNumColors(@Ptr long pixs,
            int maxcolors, int subsample);

    /**
     * Original signature :
     * <code>PIX* pixOctcubeQuantMixedWithGray(PIX*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:462</i>
     */
    public static Pointer<Pix> pixOctcubeQuantMixedWithGray(Pointer<Pix> pixs,
            int depth, int graylevels, int delta) {
        return (Pointer) Pointer.pointerToAddress(
                pixOctcubeQuantMixedWithGray(Pointer.getPeer(pixs), depth,
                        graylevels, delta), Pix.class);
    }

    @Ptr
    protected native static long pixOctcubeQuantMixedWithGray(@Ptr long pixs,
            int depth, int graylevels, int delta);

    /**
     * Original signature :
     * <code>PIX* pixFixedOctcubeQuant256(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:463</i>
     */
    public static Pointer<Pix> pixFixedOctcubeQuant256(Pointer<Pix> pixs,
            int ditherflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixFixedOctcubeQuant256(Pointer.getPeer(pixs), ditherflag),
                Pix.class);
    }

    @Ptr
    protected native static long pixFixedOctcubeQuant256(@Ptr long pixs,
            int ditherflag);

    /**
     * Original signature :
     * <code>PIX* pixFewColorsOctcubeQuant1(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:464</i>
     */
    public static Pointer<Pix> pixFewColorsOctcubeQuant1(Pointer<Pix> pixs,
            int level) {
        return (Pointer) Pointer.pointerToAddress(
                pixFewColorsOctcubeQuant1(Pointer.getPeer(pixs), level),
                Pix.class);
    }

    @Ptr
    protected native static long pixFewColorsOctcubeQuant1(@Ptr long pixs,
            int level);

    /**
     * Original signature :
     * <code>PIX* pixFewColorsOctcubeQuant2(PIX*, l_int32, NUMA*, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:465</i>
     */
    public static Pointer<Pix> pixFewColorsOctcubeQuant2(Pointer<Pix> pixs,
            int level, Pointer<Numa> na, int ncolors, Pointer<Integer> pnerrors) {
        return (Pointer) Pointer.pointerToAddress(
                pixFewColorsOctcubeQuant2(Pointer.getPeer(pixs), level,
                        Pointer.getPeer(na), ncolors, Pointer.getPeer(pnerrors)),
                Pix.class);
    }

    @Ptr
    protected native static long pixFewColorsOctcubeQuant2(@Ptr long pixs,
            int level, @Ptr long na, int ncolors, @Ptr long pnerrors);

    /**
     * Original signature :
     * <code>PIX* pixFewColorsOctcubeQuantMixed(PIX*, l_int32, l_int32, l_int32, l_int32, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:466</i>
     */
    public static Pointer<Pix> pixFewColorsOctcubeQuantMixed(Pointer<Pix> pixs,
            int level, int darkthresh, int lightthresh, int diffthresh,
            float minfract, int maxspan) {
        return (Pointer) Pointer.pointerToAddress(
                pixFewColorsOctcubeQuantMixed(Pointer.getPeer(pixs), level,
                        darkthresh, lightthresh, diffthresh, minfract, maxspan),
                Pix.class);
    }

    @Ptr
    protected native static long pixFewColorsOctcubeQuantMixed(@Ptr long pixs,
            int level, int darkthresh, int lightthresh, int diffthresh,
            float minfract, int maxspan);

    /**
     * Original signature :
     * <code>PIX* pixFixedOctcubeQuantGenRGB(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:467</i>
     */
    public static Pointer<Pix> pixFixedOctcubeQuantGenRGB(Pointer<Pix> pixs,
            int level) {
        return (Pointer) Pointer.pointerToAddress(
                pixFixedOctcubeQuantGenRGB(Pointer.getPeer(pixs), level),
                Pix.class);
    }

    @Ptr
    protected native static long pixFixedOctcubeQuantGenRGB(@Ptr long pixs,
            int level);

    /**
     * Original signature :
     * <code>PIX* pixQuantFromCmap(PIX*, PIXCMAP*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:468</i>
     */
    public static Pointer<Pix> pixQuantFromCmap(Pointer<Pix> pixs,
            Pointer<PixColormap> cmap, int mindepth, int level, int metric) {
        return (Pointer) Pointer.pointerToAddress(
                pixQuantFromCmap(Pointer.getPeer(pixs), Pointer.getPeer(cmap),
                        mindepth, level, metric), Pix.class);
    }

    @Ptr
    protected native static long pixQuantFromCmap(@Ptr long pixs,
            @Ptr long cmap, int mindepth, int level, int metric);

    /**
     * Original signature :
     * <code>PIX* pixOctcubeQuantFromCmap(PIX*, PIXCMAP*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:469</i>
     */
    public static Pointer<Pix> pixOctcubeQuantFromCmap(Pointer<Pix> pixs,
            Pointer<PixColormap> cmap, int mindepth, int level, int metric) {
        return (Pointer) Pointer.pointerToAddress(
                pixOctcubeQuantFromCmap(Pointer.getPeer(pixs),
                        Pointer.getPeer(cmap), mindepth, level, metric),
                Pix.class);
    }

    @Ptr
    protected native static long pixOctcubeQuantFromCmap(@Ptr long pixs,
            @Ptr long cmap, int mindepth, int level, int metric);

    /**
     * Original signature :
     * <code>PIX* pixOctcubeQuantFromCmapLUT(PIX*, PIXCMAP*, l_int32, l_int32*, l_uint32*, l_uint32*, l_uint32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:470</i>
     */
    public static Pointer<Pix> pixOctcubeQuantFromCmapLUT(Pointer<Pix> pixs,
            Pointer<PixColormap> cmap, int mindepth, Pointer<Integer> cmaptab,
            Pointer<Integer> rtab, Pointer<Integer> gtab, Pointer<Integer> btab) {
        return (Pointer) Pointer.pointerToAddress(
                pixOctcubeQuantFromCmapLUT(Pointer.getPeer(pixs),
                        Pointer.getPeer(cmap), mindepth,
                        Pointer.getPeer(cmaptab), Pointer.getPeer(rtab),
                        Pointer.getPeer(gtab), Pointer.getPeer(btab)),
                Pix.class);
    }

    @Ptr
    protected native static long pixOctcubeQuantFromCmapLUT(@Ptr long pixs,
            @Ptr long cmap, int mindepth, @Ptr long cmaptab, @Ptr long rtab,
            @Ptr long gtab, @Ptr long btab);

    /**
     * Original signature :
     * <code>NUMA* pixOctcubeHistogram(PIX*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:471</i>
     */
    public static Pointer<Numa> pixOctcubeHistogram(Pointer<Pix> pixs,
            int level, Pointer<Integer> pncolors) {
        return (Pointer) Pointer.pointerToAddress(
                pixOctcubeHistogram(Pointer.getPeer(pixs), level,
                        Pointer.getPeer(pncolors)), Numa.class);
    }

    @Ptr
    protected native static long pixOctcubeHistogram(@Ptr long pixs, int level,
            @Ptr long pncolors);

    /**
     * Original signature :
     * <code>l_int32* pixcmapToOctcubeLUT(PIXCMAP*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:472</i>
     */
    public static Pointer<Integer> pixcmapToOctcubeLUT(
            Pointer<PixColormap> cmap, int level, int metric) {
        return (Pointer) Pointer.pointerToAddress(
                pixcmapToOctcubeLUT(Pointer.getPeer(cmap), level, metric),
                Integer.class);
    }

    @Ptr
    protected native static long pixcmapToOctcubeLUT(@Ptr long cmap, int level,
            int metric);

    /**
     * Original signature : <code>l_int32 pixRemoveUnusedColors(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:473</i>
     */
    public static int pixRemoveUnusedColors(Pointer<Pix> pixs) {
        return pixRemoveUnusedColors(Pointer.getPeer(pixs));
    }

    protected native static int pixRemoveUnusedColors(@Ptr long pixs) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixNumberOccupiedOctcubes(PIX*, l_int32, l_int32, l_float32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:474</i>
     */
    public static int pixNumberOccupiedOctcubes(Pointer<Pix> pix, int level,
            int mincount, float minfract, Pointer<Integer> pncolors) {
        return pixNumberOccupiedOctcubes(Pointer.getPeer(pix), level, mincount,
                minfract, Pointer.getPeer(pncolors));
    }

    protected native static int pixNumberOccupiedOctcubes(@Ptr long pix,
            int level, int mincount, float minfract, @Ptr long pncolors);

    /**
     * Original signature : <code>PIX* pixMedianCutQuant(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:475</i>
     */
    public static Pointer<Pix> pixMedianCutQuant(Pointer<Pix> pixs,
            int ditherflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixMedianCutQuant(Pointer.getPeer(pixs), ditherflag), Pix.class);
    }

    @Ptr
    protected native static long pixMedianCutQuant(@Ptr long pixs,
            int ditherflag);

    /**
     * Original signature :
     * <code>PIX* pixMedianCutQuantGeneral(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:476</i>
     */
    public static Pointer<Pix> pixMedianCutQuantGeneral(Pointer<Pix> pixs,
            int ditherflag, int outdepth, int maxcolors, int sigbits,
            int maxsub, int checkbw) {
        return (Pointer) Pointer.pointerToAddress(
                pixMedianCutQuantGeneral(Pointer.getPeer(pixs), ditherflag,
                        outdepth, maxcolors, sigbits, maxsub, checkbw),
                Pix.class);
    }

    @Ptr
    protected native static long pixMedianCutQuantGeneral(@Ptr long pixs,
            int ditherflag, int outdepth, int maxcolors, int sigbits,
            int maxsub, int checkbw);

    /**
     * Original signature :
     * <code>PIX* pixMedianCutQuantMixed(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:477</i>
     */
    public static Pointer<Pix> pixMedianCutQuantMixed(Pointer<Pix> pixs,
            int ncolor, int ngray, int darkthresh, int lightthresh,
            int diffthresh) {
        return (Pointer) Pointer.pointerToAddress(
                pixMedianCutQuantMixed(Pointer.getPeer(pixs), ncolor, ngray,
                        darkthresh, lightthresh, diffthresh), Pix.class);
    }

    @Ptr
    protected native static long pixMedianCutQuantMixed(@Ptr long pixs,
            int ncolor, int ngray, int darkthresh, int lightthresh,
            int diffthresh);

    /**
     * Original signature :
     * <code>PIX* pixFewColorsMedianCutQuantMixed(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:478</i>
     */
    public static Pointer<Pix> pixFewColorsMedianCutQuantMixed(
            Pointer<Pix> pixs, int ncolor, int ngray, int maxncolors,
            int darkthresh, int lightthresh, int diffthresh) {
        return (Pointer) Pointer.pointerToAddress(
                pixFewColorsMedianCutQuantMixed(Pointer.getPeer(pixs), ncolor,
                        ngray, maxncolors, darkthresh, lightthresh, diffthresh),
                Pix.class);
    }

    @Ptr
    protected native static long pixFewColorsMedianCutQuantMixed(
            @Ptr long pixs, int ncolor, int ngray, int maxncolors,
            int darkthresh, int lightthresh, int diffthresh);

    /**
     * Original signature :
     * <code>l_int32* pixMedianCutHisto(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:479</i>
     */
    public static Pointer<Integer> pixMedianCutHisto(Pointer<Pix> pixs,
            int sigbits, int subsample) {
        return (Pointer) Pointer.pointerToAddress(
                pixMedianCutHisto(Pointer.getPeer(pixs), sigbits, subsample),
                Integer.class);
    }

    @Ptr
    protected native static long pixMedianCutHisto(@Ptr long pixs, int sigbits,
            int subsample);

    /**
     * Original signature :
     * <code>PIX* pixColorSegment(PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:480</i>
     */
    public static Pointer<Pix> pixColorSegment(Pointer<Pix> pixs, int maxdist,
            int maxcolors, int selsize, int finalcolors) {
        return (Pointer) Pointer.pointerToAddress(
                pixColorSegment(Pointer.getPeer(pixs), maxdist, maxcolors,
                        selsize, finalcolors), Pix.class);
    }

    @Ptr
    protected native static long pixColorSegment(@Ptr long pixs, int maxdist,
            int maxcolors, int selsize, int finalcolors);

    /**
     * Original signature :
     * <code>PIX* pixColorSegmentCluster(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:481</i>
     */
    public static Pointer<Pix> pixColorSegmentCluster(Pointer<Pix> pixs,
            int maxdist, int maxcolors) {
        return (Pointer) Pointer.pointerToAddress(
                pixColorSegmentCluster(Pointer.getPeer(pixs), maxdist,
                        maxcolors), Pix.class);
    }

    @Ptr
    protected native static long pixColorSegmentCluster(@Ptr long pixs,
            int maxdist, int maxcolors);

    /**
     * Original signature :
     * <code>l_int32 pixAssignToNearestColor(PIX*, PIX*, PIX*, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:482</i>
     */
    public static int pixAssignToNearestColor(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<Pix> pixm, int level,
            Pointer<Integer> countarray) {
        return pixAssignToNearestColor(Pointer.getPeer(pixd),
                Pointer.getPeer(pixs), Pointer.getPeer(pixm), level,
                Pointer.getPeer(countarray));
    }

    protected native static int pixAssignToNearestColor(@Ptr long pixd,
            @Ptr long pixs, @Ptr long pixm, int level, @Ptr long countarray);

    /**
     * Original signature :
     * <code>l_int32 pixColorSegmentClean(PIX*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:483</i>
     */
    public static int pixColorSegmentClean(Pointer<Pix> pixs, int selsize,
            Pointer<Integer> countarray) {
        return pixColorSegmentClean(Pointer.getPeer(pixs), selsize,
                Pointer.getPeer(countarray));
    }

    protected native static int pixColorSegmentClean(@Ptr long pixs,
            int selsize, @Ptr long countarray);

    /**
     * Original signature :
     * <code>l_int32 pixColorSegmentRemoveColors(PIX*, PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:484</i>
     */
    public static int pixColorSegmentRemoveColors(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int finalcolors) {
        return pixColorSegmentRemoveColors(Pointer.getPeer(pixd),
                Pointer.getPeer(pixs), finalcolors);
    }

    protected native static int pixColorSegmentRemoveColors(@Ptr long pixd,
            @Ptr long pixs, int finalcolors);

    /**
     * Original signature : <code>PIX* pixConvertRGBToHSV(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:485</i>
     */
    public static Pointer<Pix> pixConvertRGBToHSV(Pointer<Pix> pixd,
            Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvertRGBToHSV(Pointer.getPeer(pixd), Pointer.getPeer(pixs)),
                Pix.class);
    }

    @Ptr
    protected native static long pixConvertRGBToHSV(@Ptr long pixd,
            @Ptr long pixs);

    /**
     * Original signature : <code>PIX* pixConvertHSVToRGB(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:486</i>
     */
    public static Pointer<Pix> pixConvertHSVToRGB(Pointer<Pix> pixd,
            Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvertHSVToRGB(Pointer.getPeer(pixd), Pointer.getPeer(pixs)),
                Pix.class);
    }

    @Ptr
    protected native static long pixConvertHSVToRGB(@Ptr long pixd,
            @Ptr long pixs);

    /**
     * Original signature :
     * <code>l_int32 convertRGBToHSV(l_int32, l_int32, l_int32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:487</i>
     */
    public static int convertRGBToHSV(int rval, int gval, int bval,
            Pointer<Integer> phval, Pointer<Integer> psval,
            Pointer<Integer> pvval) {
        return convertRGBToHSV(rval, gval, bval, Pointer.getPeer(phval),
                Pointer.getPeer(psval), Pointer.getPeer(pvval));
    }

    protected native static int convertRGBToHSV(int rval, int gval, int bval,
            @Ptr long phval, @Ptr long psval, @Ptr long pvval);

    /**
     * Original signature :
     * <code>l_int32 convertHSVToRGB(l_int32, l_int32, l_int32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:488</i>
     */
    public static int convertHSVToRGB(int hval, int sval, int vval,
            Pointer<Integer> prval, Pointer<Integer> pgval,
            Pointer<Integer> pbval) {
        return convertHSVToRGB(hval, sval, vval, Pointer.getPeer(prval),
                Pointer.getPeer(pgval), Pointer.getPeer(pbval));
    }

    protected native static int convertHSVToRGB(int hval, int sval, int vval,
            @Ptr long prval, @Ptr long pgval, @Ptr long pbval);

    /**
     * Original signature :
     * <code>l_int32 pixcmapConvertRGBToHSV(PIXCMAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:489</i>
     */
    public static int pixcmapConvertRGBToHSV(Pointer<PixColormap> cmap) {
        return pixcmapConvertRGBToHSV(Pointer.getPeer(cmap));
    }

    protected native static int pixcmapConvertRGBToHSV(@Ptr long cmap) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixcmapConvertHSVToRGB(PIXCMAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:490</i>
     */
    public static int pixcmapConvertHSVToRGB(Pointer<PixColormap> cmap) {
        return pixcmapConvertHSVToRGB(Pointer.getPeer(cmap));
    }

    protected native static int pixcmapConvertHSVToRGB(@Ptr long cmap) throws LastError;

    /**
     * Original signature : <code>PIX* pixConvertRGBToHue(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:491</i>
     */
    public static Pointer<Pix> pixConvertRGBToHue(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvertRGBToHue(Pointer.getPeer(pixs)), Pix.class);
    }

    @Ptr
    protected native static long pixConvertRGBToHue(@Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>PIX* pixConvertRGBToSaturation(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:492</i>
     */
    public static Pointer<Pix> pixConvertRGBToSaturation(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvertRGBToSaturation(Pointer.getPeer(pixs)), Pix.class);
    }

    @Ptr
    protected native static long pixConvertRGBToSaturation(@Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>PIX* pixConvertRGBToValue(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:493</i>
     */
    public static Pointer<Pix> pixConvertRGBToValue(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvertRGBToValue(Pointer.getPeer(pixs)), Pix.class);
    }

    @Ptr
    protected native static long pixConvertRGBToValue(@Ptr long pixs) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixMakeRangeMaskHS(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:494</i>
     */
    public static Pointer<Pix> pixMakeRangeMaskHS(Pointer<Pix> pixs,
            int huecenter, int huehw, int satcenter, int sathw, int regionflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixMakeRangeMaskHS(Pointer.getPeer(pixs), huecenter, huehw,
                        satcenter, sathw, regionflag), Pix.class);
    }

    @Ptr
    protected native static long pixMakeRangeMaskHS(@Ptr long pixs,
            int huecenter, int huehw, int satcenter, int sathw, int regionflag);

    /**
     * Original signature :
     * <code>PIX* pixMakeRangeMaskHV(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:495</i>
     */
    public static Pointer<Pix> pixMakeRangeMaskHV(Pointer<Pix> pixs,
            int huecenter, int huehw, int valcenter, int valhw, int regionflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixMakeRangeMaskHV(Pointer.getPeer(pixs), huecenter, huehw,
                        valcenter, valhw, regionflag), Pix.class);
    }

    @Ptr
    protected native static long pixMakeRangeMaskHV(@Ptr long pixs,
            int huecenter, int huehw, int valcenter, int valhw, int regionflag);

    /**
     * Original signature :
     * <code>PIX* pixMakeRangeMaskSV(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:496</i>
     */
    public static Pointer<Pix> pixMakeRangeMaskSV(Pointer<Pix> pixs,
            int satcenter, int sathw, int valcenter, int valhw, int regionflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixMakeRangeMaskSV(Pointer.getPeer(pixs), satcenter, sathw,
                        valcenter, valhw, regionflag), Pix.class);
    }

    @Ptr
    protected native static long pixMakeRangeMaskSV(@Ptr long pixs,
            int satcenter, int sathw, int valcenter, int valhw, int regionflag);

    /**
     * Original signature :
     * <code>PIX* pixMakeHistoHS(PIX*, l_int32, NUMA**, NUMA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:497</i>
     */
    public static Pointer<Pix> pixMakeHistoHS(Pointer<Pix> pixs, int factor,
            Pointer<Pointer<Numa>> pnahue, Pointer<Pointer<Numa>> pnasat) {
        return (Pointer) Pointer.pointerToAddress(
                pixMakeHistoHS(Pointer.getPeer(pixs), factor,
                        Pointer.getPeer(pnahue), Pointer.getPeer(pnasat)),
                Pix.class);
    }

    @Ptr
    protected native static long pixMakeHistoHS(@Ptr long pixs, int factor,
            @Ptr long pnahue, @Ptr long pnasat);

    /**
     * Original signature :
     * <code>PIX* pixMakeHistoHV(PIX*, l_int32, NUMA**, NUMA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:498</i>
     */
    public static Pointer<Pix> pixMakeHistoHV(Pointer<Pix> pixs, int factor,
            Pointer<Pointer<Numa>> pnahue, Pointer<Pointer<Numa>> pnaval) {
        return (Pointer) Pointer.pointerToAddress(
                pixMakeHistoHV(Pointer.getPeer(pixs), factor,
                        Pointer.getPeer(pnahue), Pointer.getPeer(pnaval)),
                Pix.class);
    }

    @Ptr
    protected native static long pixMakeHistoHV(@Ptr long pixs, int factor,
            @Ptr long pnahue, @Ptr long pnaval);

    /**
     * Original signature :
     * <code>PIX* pixMakeHistoSV(PIX*, l_int32, NUMA**, NUMA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:499</i>
     */
    public static Pointer<Pix> pixMakeHistoSV(Pointer<Pix> pixs, int factor,
            Pointer<Pointer<Numa>> pnasat, Pointer<Pointer<Numa>> pnaval) {
        return (Pointer) Pointer.pointerToAddress(
                pixMakeHistoSV(Pointer.getPeer(pixs), factor,
                        Pointer.getPeer(pnasat), Pointer.getPeer(pnaval)),
                Pix.class);
    }

    @Ptr
    protected native static long pixMakeHistoSV(@Ptr long pixs, int factor,
            @Ptr long pnasat, @Ptr long pnaval);

    /**
     * Original signature :
     * <code>l_int32 pixFindHistoPeaksHSV(PIX*, l_int32, l_int32, l_int32, l_int32, l_float32, PTA**, NUMA**, PIXA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:500</i>
     */
    public static int pixFindHistoPeaksHSV(Pointer<Pix> pixs, int type,
            int width, int height, int npeaks, float erasefactor,
            Pointer<Pointer<Pta>> ppta, Pointer<Pointer<Numa>> pnatot,
            Pointer<Pointer<Pixa>> ppixa) {
        return pixFindHistoPeaksHSV(Pointer.getPeer(pixs), type, width, height,
                npeaks, erasefactor, Pointer.getPeer(ppta),
                Pointer.getPeer(pnatot), Pointer.getPeer(ppixa));
    }

    protected native static int pixFindHistoPeaksHSV(@Ptr long pixs, int type,
            int width, int height, int npeaks, float erasefactor,
            @Ptr long ppta, @Ptr long pnatot, @Ptr long ppixa);

    /**
     * Original signature :
     * <code>PIX* displayHSVColorRange(l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:501</i>
     */
    public static Pointer<Pix> displayHSVColorRange(int hval, int sval,
            int vval, int huehw, int sathw, int nsamp, int factor) {
        return (Pointer) Pointer.pointerToAddress(
                displayHSVColorRange$2(hval, sval, vval, huehw, sathw, nsamp,
                        factor), Pix.class);
    }

    @Ptr
    @Name("displayHSVColorRange")
    protected native static long displayHSVColorRange$2(int hval, int sval,
            int vval, int huehw, int sathw, int nsamp, int factor);

    /**
     * Original signature : <code>PIX* pixConvertRGBToYUV(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:502</i>
     */
    public static Pointer<Pix> pixConvertRGBToYUV(Pointer<Pix> pixd,
            Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvertRGBToYUV(Pointer.getPeer(pixd), Pointer.getPeer(pixs)),
                Pix.class);
    }

    @Ptr
    protected native static long pixConvertRGBToYUV(@Ptr long pixd,
            @Ptr long pixs);

    /**
     * Original signature : <code>PIX* pixConvertYUVToRGB(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:503</i>
     */
    public static Pointer<Pix> pixConvertYUVToRGB(Pointer<Pix> pixd,
            Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvertYUVToRGB(Pointer.getPeer(pixd), Pointer.getPeer(pixs)),
                Pix.class);
    }

    @Ptr
    protected native static long pixConvertYUVToRGB(@Ptr long pixd,
            @Ptr long pixs);

    /**
     * Original signature :
     * <code>l_int32 convertRGBToYUV(l_int32, l_int32, l_int32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:504</i>
     */
    public static int convertRGBToYUV(int rval, int gval, int bval,
            Pointer<Integer> pyval, Pointer<Integer> puval,
            Pointer<Integer> pvval) {
        return convertRGBToYUV(rval, gval, bval, Pointer.getPeer(pyval),
                Pointer.getPeer(puval), Pointer.getPeer(pvval));
    }

    protected native static int convertRGBToYUV(int rval, int gval, int bval,
            @Ptr long pyval, @Ptr long puval, @Ptr long pvval);

    /**
     * Original signature :
     * <code>l_int32 convertYUVToRGB(l_int32, l_int32, l_int32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:505</i>
     */
    public static int convertYUVToRGB(int yval, int uval, int vval,
            Pointer<Integer> prval, Pointer<Integer> pgval,
            Pointer<Integer> pbval) {
        return convertYUVToRGB(yval, uval, vval, Pointer.getPeer(prval),
                Pointer.getPeer(pgval), Pointer.getPeer(pbval));
    }

    protected native static int convertYUVToRGB(int yval, int uval, int vval,
            @Ptr long prval, @Ptr long pgval, @Ptr long pbval);

    /**
     * Original signature :
     * <code>l_int32 pixcmapConvertRGBToYUV(PIXCMAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:506</i>
     */
    public static int pixcmapConvertRGBToYUV(Pointer<PixColormap> cmap) {
        return pixcmapConvertRGBToYUV(Pointer.getPeer(cmap));
    }

    protected native static int pixcmapConvertRGBToYUV(@Ptr long cmap) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixcmapConvertYUVToRGB(PIXCMAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:507</i>
     */
    public static int pixcmapConvertYUVToRGB(Pointer<PixColormap> cmap) {
        return pixcmapConvertYUVToRGB(Pointer.getPeer(cmap));
    }

    protected native static int pixcmapConvertYUVToRGB(@Ptr long cmap) throws LastError;

    /**
     * Original signature : <code>l_int32 pixEqual(PIX*, PIX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:508</i>
     */
    public static int pixEqual(Pointer<Pix> pix1, Pointer<Pix> pix2,
            Pointer<Integer> psame) {
        return pixEqual(Pointer.getPeer(pix1), Pointer.getPeer(pix2),
                Pointer.getPeer(psame));
    }

    protected native static int pixEqual(@Ptr long pix1, @Ptr long pix2,
            @Ptr long psame);

    /**
     * Original signature :
     * <code>l_int32 pixEqualWithAlpha(PIX*, PIX*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:509</i>
     */
    public static int pixEqualWithAlpha(Pointer<Pix> pix1, Pointer<Pix> pix2,
            int use_alpha, Pointer<Integer> psame) {
        return pixEqualWithAlpha(Pointer.getPeer(pix1), Pointer.getPeer(pix2),
                use_alpha, Pointer.getPeer(psame));
    }

    protected native static int pixEqualWithAlpha(@Ptr long pix1,
            @Ptr long pix2, int use_alpha, @Ptr long psame);

    /**
     * Original signature :
     * <code>l_int32 pixEqualWithCmap(PIX*, PIX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:510</i>
     */
    public static int pixEqualWithCmap(Pointer<Pix> pix1, Pointer<Pix> pix2,
            Pointer<Integer> psame) {
        return pixEqualWithCmap(Pointer.getPeer(pix1), Pointer.getPeer(pix2),
                Pointer.getPeer(psame));
    }

    protected native static int pixEqualWithCmap(@Ptr long pix1,
            @Ptr long pix2, @Ptr long psame);

    /**
     * Original signature :
     * <code>l_int32 pixUsesCmapColor(PIX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:511</i>
     */
    public static int pixUsesCmapColor(Pointer<Pix> pixs,
            Pointer<Integer> pcolor) {
        return pixUsesCmapColor(Pointer.getPeer(pixs), Pointer.getPeer(pcolor));
    }

    protected native static int pixUsesCmapColor(@Ptr long pixs,
            @Ptr long pcolor);

    /**
     * Original signature :
     * <code>l_int32 pixCorrelationBinary(PIX*, PIX*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:512</i>
     */
    public static int pixCorrelationBinary(Pointer<Pix> pix1,
            Pointer<Pix> pix2, Pointer<Float> pval) {
        return pixCorrelationBinary(Pointer.getPeer(pix1),
                Pointer.getPeer(pix2), Pointer.getPeer(pval));
    }

    protected native static int pixCorrelationBinary(@Ptr long pix1,
            @Ptr long pix2, @Ptr long pval);

    /**
     * Original signature : <code>PIX* pixDisplayDiffBinary(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:513</i>
     */
    public static Pointer<Pix> pixDisplayDiffBinary(Pointer<Pix> pix1,
            Pointer<Pix> pix2) {
        return (Pointer) Pointer.pointerToAddress(
                pixDisplayDiffBinary(Pointer.getPeer(pix1),
                        Pointer.getPeer(pix2)), Pix.class);
    }

    @Ptr
    protected native static long pixDisplayDiffBinary(@Ptr long pix1,
            @Ptr long pix2);

    /**
     * Original signature :
     * <code>l_int32 pixCompareBinary(PIX*, PIX*, l_int32, l_float32*, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:514</i>
     */
    public static int pixCompareBinary(Pointer<Pix> pix1, Pointer<Pix> pix2,
            int comptype, Pointer<Float> pfract, Pointer<Pointer<Pix>> ppixdiff) {
        return pixCompareBinary(Pointer.getPeer(pix1), Pointer.getPeer(pix2),
                comptype, Pointer.getPeer(pfract), Pointer.getPeer(ppixdiff));
    }

    protected native static int pixCompareBinary(@Ptr long pix1,
            @Ptr long pix2, int comptype, @Ptr long pfract, @Ptr long ppixdiff);

    /**
     * Original signature :
     * <code>l_int32 pixCompareGrayOrRGB(PIX*, PIX*, l_int32, l_int32, l_int32*, l_float32*, l_float32*, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:515</i>
     */
    public static int pixCompareGrayOrRGB(Pointer<Pix> pix1, Pointer<Pix> pix2,
            int comptype, int plottype, Pointer<Integer> psame,
            Pointer<Float> pdiff, Pointer<Float> prmsdiff,
            Pointer<Pointer<Pix>> ppixdiff) {
        return pixCompareGrayOrRGB(Pointer.getPeer(pix1),
                Pointer.getPeer(pix2), comptype, plottype,
                Pointer.getPeer(psame), Pointer.getPeer(pdiff),
                Pointer.getPeer(prmsdiff), Pointer.getPeer(ppixdiff));
    }

    protected native static int pixCompareGrayOrRGB(@Ptr long pix1,
            @Ptr long pix2, int comptype, int plottype, @Ptr long psame,
            @Ptr long pdiff, @Ptr long prmsdiff, @Ptr long ppixdiff);

    /**
     * Original signature :
     * <code>l_int32 pixCompareGray(PIX*, PIX*, l_int32, l_int32, l_int32*, l_float32*, l_float32*, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:516</i>
     */
    public static int pixCompareGray(Pointer<Pix> pix1, Pointer<Pix> pix2,
            int comptype, int plottype, Pointer<Integer> psame,
            Pointer<Float> pdiff, Pointer<Float> prmsdiff,
            Pointer<Pointer<Pix>> ppixdiff) {
        return pixCompareGray(Pointer.getPeer(pix1), Pointer.getPeer(pix2),
                comptype, plottype, Pointer.getPeer(psame),
                Pointer.getPeer(pdiff), Pointer.getPeer(prmsdiff),
                Pointer.getPeer(ppixdiff));
    }

    protected native static int pixCompareGray(@Ptr long pix1, @Ptr long pix2,
            int comptype, int plottype, @Ptr long psame, @Ptr long pdiff,
            @Ptr long prmsdiff, @Ptr long ppixdiff);

    /**
     * Original signature :
     * <code>l_int32 pixCompareRGB(PIX*, PIX*, l_int32, l_int32, l_int32*, l_float32*, l_float32*, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:517</i>
     */
    public static int pixCompareRGB(Pointer<Pix> pix1, Pointer<Pix> pix2,
            int comptype, int plottype, Pointer<Integer> psame,
            Pointer<Float> pdiff, Pointer<Float> prmsdiff,
            Pointer<Pointer<Pix>> ppixdiff) {
        return pixCompareRGB(Pointer.getPeer(pix1), Pointer.getPeer(pix2),
                comptype, plottype, Pointer.getPeer(psame),
                Pointer.getPeer(pdiff), Pointer.getPeer(prmsdiff),
                Pointer.getPeer(ppixdiff));
    }

    protected native static int pixCompareRGB(@Ptr long pix1, @Ptr long pix2,
            int comptype, int plottype, @Ptr long psame, @Ptr long pdiff,
            @Ptr long prmsdiff, @Ptr long ppixdiff);

    /**
     * Original signature :
     * <code>l_int32 pixCompareTiled(PIX*, PIX*, l_int32, l_int32, l_int32, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:518</i>
     */
    public static int pixCompareTiled(Pointer<Pix> pix1, Pointer<Pix> pix2,
            int sx, int sy, int type, Pointer<Pointer<Pix>> ppixdiff) {
        return pixCompareTiled(Pointer.getPeer(pix1), Pointer.getPeer(pix2),
                sx, sy, type, Pointer.getPeer(ppixdiff));
    }

    protected native static int pixCompareTiled(@Ptr long pix1, @Ptr long pix2,
            int sx, int sy, int type, @Ptr long ppixdiff);

    /**
     * Original signature :
     * <code>NUMA* pixCompareRankDifference(PIX*, PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:519</i>
     */
    public static Pointer<Numa> pixCompareRankDifference(Pointer<Pix> pix1,
            Pointer<Pix> pix2, int factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixCompareRankDifference(Pointer.getPeer(pix1),
                        Pointer.getPeer(pix2), factor), Numa.class);
    }

    @Ptr
    protected native static long pixCompareRankDifference(@Ptr long pix1,
            @Ptr long pix2, int factor);

    /**
     * Original signature :
     * <code>l_int32 pixTestForSimilarity(PIX*, PIX*, l_int32, l_int32, l_float32, l_float32, l_int32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:520</i>
     */
    public static int pixTestForSimilarity(Pointer<Pix> pix1,
            Pointer<Pix> pix2, int factor, int mindiff, float maxfract,
            float maxave, Pointer<Integer> psimilar, int printstats) {
        return pixTestForSimilarity(Pointer.getPeer(pix1),
                Pointer.getPeer(pix2), factor, mindiff, maxfract, maxave,
                Pointer.getPeer(psimilar), printstats);
    }

    protected native static int pixTestForSimilarity(@Ptr long pix1,
            @Ptr long pix2, int factor, int mindiff, float maxfract,
            float maxave, @Ptr long psimilar, int printstats);

    /**
     * Original signature :
     * <code>l_int32 pixGetDifferenceStats(PIX*, PIX*, l_int32, l_int32, l_float32*, l_float32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:521</i>
     */
    public static int pixGetDifferenceStats(Pointer<Pix> pix1,
            Pointer<Pix> pix2, int factor, int mindiff,
            Pointer<Float> pfractdiff, Pointer<Float> pavediff, int printstats) {
        return pixGetDifferenceStats(Pointer.getPeer(pix1),
                Pointer.getPeer(pix2), factor, mindiff,
                Pointer.getPeer(pfractdiff), Pointer.getPeer(pavediff),
                printstats);
    }

    protected native static int pixGetDifferenceStats(@Ptr long pix1,
            @Ptr long pix2, int factor, int mindiff, @Ptr long pfractdiff,
            @Ptr long pavediff, int printstats);

    /**
     * Original signature :
     * <code>NUMA* pixGetDifferenceHistogram(PIX*, PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:522</i>
     */
    public static Pointer<Numa> pixGetDifferenceHistogram(Pointer<Pix> pix1,
            Pointer<Pix> pix2, int factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetDifferenceHistogram(Pointer.getPeer(pix1),
                        Pointer.getPeer(pix2), factor), Numa.class);
    }

    @Ptr
    protected native static long pixGetDifferenceHistogram(@Ptr long pix1,
            @Ptr long pix2, int factor);

    /**
     * Original signature :
     * <code>l_int32 pixGetPerceptualDiff(PIX*, PIX*, l_int32, l_int32, l_int32, l_float32*, PIX**, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:523</i>
     */
    public static int pixGetPerceptualDiff(Pointer<Pix> pixs1,
            Pointer<Pix> pixs2, int sampling, int dilation, int mindiff,
            Pointer<Float> pfract, Pointer<Pointer<Pix>> ppixdiff1,
            Pointer<Pointer<Pix>> ppixdiff2) {
        return pixGetPerceptualDiff(Pointer.getPeer(pixs1),
                Pointer.getPeer(pixs2), sampling, dilation, mindiff,
                Pointer.getPeer(pfract), Pointer.getPeer(ppixdiff1),
                Pointer.getPeer(ppixdiff2));
    }

    protected native static int pixGetPerceptualDiff(@Ptr long pixs1,
            @Ptr long pixs2, int sampling, int dilation, int mindiff,
            @Ptr long pfract, @Ptr long ppixdiff1, @Ptr long ppixdiff2);

    /**
     * Original signature :
     * <code>l_int32 pixGetPSNR(PIX*, PIX*, l_int32, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:524</i>
     */
    public static int pixGetPSNR(Pointer<Pix> pix1, Pointer<Pix> pix2,
            int factor, Pointer<Float> ppsnr) {
        return pixGetPSNR(Pointer.getPeer(pix1), Pointer.getPeer(pix2), factor,
                Pointer.getPeer(ppsnr));
    }

    protected native static int pixGetPSNR(@Ptr long pix1, @Ptr long pix2,
            int factor, @Ptr long ppsnr);

    /**
     * Original signature :
     * <code>l_int32 pixCompareWithTranslation(PIX*, PIX*, l_int32, l_int32*, l_int32*, l_float32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:525</i>
     */
    public static int pixCompareWithTranslation(Pointer<Pix> pix1,
            Pointer<Pix> pix2, int thresh, Pointer<Integer> pdelx,
            Pointer<Integer> pdely, Pointer<Float> pscore, int debugflag) {
        return pixCompareWithTranslation(Pointer.getPeer(pix1),
                Pointer.getPeer(pix2), thresh, Pointer.getPeer(pdelx),
                Pointer.getPeer(pdely), Pointer.getPeer(pscore), debugflag);
    }

    protected native static int pixCompareWithTranslation(@Ptr long pix1,
            @Ptr long pix2, int thresh, @Ptr long pdelx, @Ptr long pdely,
            @Ptr long pscore, int debugflag);

    /**
     * Original signature :
     * <code>l_int32 pixBestCorrelation(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32*, l_int32*, l_int32*, l_float32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:526</i>
     */
    public static int pixBestCorrelation(Pointer<Pix> pix1, Pointer<Pix> pix2,
            int area1, int area2, int etransx, int etransy, int maxshift,
            Pointer<Integer> tab8, Pointer<Integer> pdelx,
            Pointer<Integer> pdely, Pointer<Float> pscore, int debugflag) {
        return pixBestCorrelation(Pointer.getPeer(pix1), Pointer.getPeer(pix2),
                area1, area2, etransx, etransy, maxshift,
                Pointer.getPeer(tab8), Pointer.getPeer(pdelx),
                Pointer.getPeer(pdely), Pointer.getPeer(pscore), debugflag);
    }

    protected native static int pixBestCorrelation(@Ptr long pix1,
            @Ptr long pix2, int area1, int area2, int etransx, int etransy,
            int maxshift, @Ptr long tab8, @Ptr long pdelx, @Ptr long pdely,
            @Ptr long pscore, int debugflag);

    /**
     * Original signature :
     * <code>BOXA* pixConnComp(PIX*, PIXA**, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:527</i>
     */
    public static Pointer<Boxa> pixConnComp(Pointer<Pix> pixs,
            Pointer<Pointer<Pixa>> ppixa, int connectivity) {
        return (Pointer) Pointer.pointerToAddress(
                pixConnComp(Pointer.getPeer(pixs), Pointer.getPeer(ppixa),
                        connectivity), Boxa.class);
    }

    @Ptr
    protected native static long pixConnComp(@Ptr long pixs, @Ptr long ppixa,
            int connectivity);

    /**
     * Original signature :
     * <code>BOXA* pixConnCompPixa(PIX*, PIXA**, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:528</i>
     */
    public static Pointer<Boxa> pixConnCompPixa(Pointer<Pix> pixs,
            Pointer<Pointer<Pixa>> ppixa, int connectivity) {
        return (Pointer) Pointer.pointerToAddress(
                pixConnCompPixa(Pointer.getPeer(pixs), Pointer.getPeer(ppixa),
                        connectivity), Boxa.class);
    }

    @Ptr
    protected native static long pixConnCompPixa(@Ptr long pixs,
            @Ptr long ppixa, int connectivity);

    /**
     * Original signature : <code>BOXA* pixConnCompBB(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:529</i>
     */
    public static Pointer<Boxa> pixConnCompBB(Pointer<Pix> pixs,
            int connectivity) {
        return (Pointer) Pointer.pointerToAddress(
                pixConnCompBB(Pointer.getPeer(pixs), connectivity), Boxa.class);
    }

    @Ptr
    protected native static long pixConnCompBB(@Ptr long pixs, int connectivity) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixCountConnComp(PIX*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:530</i>
     */
    public static int pixCountConnComp(Pointer<Pix> pixs, int connectivity,
            Pointer<Integer> pcount) {
        return pixCountConnComp(Pointer.getPeer(pixs), connectivity,
                Pointer.getPeer(pcount));
    }

    protected native static int pixCountConnComp(@Ptr long pixs,
            int connectivity, @Ptr long pcount);

    /**
     * Original signature :
     * <code>l_int32 nextOnPixelInRaster(PIX*, l_int32, l_int32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:531</i>
     */
    public static int nextOnPixelInRaster(Pointer<Pix> pixs, int xstart,
            int ystart, Pointer<Integer> px, Pointer<Integer> py) {
        return nextOnPixelInRaster(Pointer.getPeer(pixs), xstart, ystart,
                Pointer.getPeer(px), Pointer.getPeer(py));
    }

    protected native static int nextOnPixelInRaster(@Ptr long pixs, int xstart,
            int ystart, @Ptr long px, @Ptr long py);

    /**
     * Original signature :
     * <code>l_int32 nextOnPixelInRasterLow(l_uint32*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:532</i>
     */
    public static int nextOnPixelInRasterLow(Pointer<Integer> data, int w,
            int h, int wpl, int xstart, int ystart, Pointer<Integer> px,
            Pointer<Integer> py) {
        return nextOnPixelInRasterLow(Pointer.getPeer(data), w, h, wpl, xstart,
                ystart, Pointer.getPeer(px), Pointer.getPeer(py));
    }

    protected native static int nextOnPixelInRasterLow(@Ptr long data, int w,
            int h, int wpl, int xstart, int ystart, @Ptr long px, @Ptr long py);

    /**
     * Original signature :
     * <code>BOX* pixSeedfillBB(PIX*, L_STACK*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:533</i>
     */
    public static Pointer<Box> pixSeedfillBB(Pointer<Pix> pixs,
            Pointer<L_Stack> stack, int x, int y, int connectivity) {
        return (Pointer) Pointer.pointerToAddress(
                pixSeedfillBB(Pointer.getPeer(pixs), Pointer.getPeer(stack), x,
                        y, connectivity), Box.class);
    }

    @Ptr
    protected native static long pixSeedfillBB(@Ptr long pixs, @Ptr long stack,
            int x, int y, int connectivity);

    /**
     * Original signature :
     * <code>BOX* pixSeedfill4BB(PIX*, L_STACK*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:534</i>
     */
    public static Pointer<Box> pixSeedfill4BB(Pointer<Pix> pixs,
            Pointer<L_Stack> stack, int x, int y) {
        return (Pointer) Pointer.pointerToAddress(
                pixSeedfill4BB(Pointer.getPeer(pixs), Pointer.getPeer(stack),
                        x, y), Box.class);
    }

    @Ptr
    protected native static long pixSeedfill4BB(@Ptr long pixs,
            @Ptr long stack, int x, int y);

    /**
     * Original signature :
     * <code>BOX* pixSeedfill8BB(PIX*, L_STACK*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:535</i>
     */
    public static Pointer<Box> pixSeedfill8BB(Pointer<Pix> pixs,
            Pointer<L_Stack> stack, int x, int y) {
        return (Pointer) Pointer.pointerToAddress(
                pixSeedfill8BB(Pointer.getPeer(pixs), Pointer.getPeer(stack),
                        x, y), Box.class);
    }

    @Ptr
    protected native static long pixSeedfill8BB(@Ptr long pixs,
            @Ptr long stack, int x, int y);

    /**
     * Original signature :
     * <code>l_int32 pixSeedfill(PIX*, L_STACK*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:536</i>
     */
    public static int pixSeedfill(Pointer<Pix> pixs, Pointer<L_Stack> stack,
            int x, int y, int connectivity) {
        return pixSeedfill(Pointer.getPeer(pixs), Pointer.getPeer(stack), x, y,
                connectivity);
    }

    protected native static int pixSeedfill(@Ptr long pixs, @Ptr long stack,
            int x, int y, int connectivity);

    /**
     * Original signature :
     * <code>l_int32 pixSeedfill4(PIX*, L_STACK*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:537</i>
     */
    public static int pixSeedfill4(Pointer<Pix> pixs, Pointer<L_Stack> stack,
            int x, int y) {
        return pixSeedfill4(Pointer.getPeer(pixs), Pointer.getPeer(stack), x, y);
    }

    protected native static int pixSeedfill4(@Ptr long pixs, @Ptr long stack,
            int x, int y);

    /**
     * Original signature :
     * <code>l_int32 pixSeedfill8(PIX*, L_STACK*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:538</i>
     */
    public static int pixSeedfill8(Pointer<Pix> pixs, Pointer<L_Stack> stack,
            int x, int y) {
        return pixSeedfill8(Pointer.getPeer(pixs), Pointer.getPeer(stack), x, y);
    }

    protected native static int pixSeedfill8(@Ptr long pixs, @Ptr long stack,
            int x, int y);

    /**
     * Original signature :
     * <code>l_int32 convertFilesTo1bpp(const char*, const char*, l_int32, l_int32, l_int32, l_int32, const char*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:539</i>
     */
    public static int convertFilesTo1bpp(Pointer<Byte> dirin,
            Pointer<Byte> substr, int upscaling, int thresh, int firstpage,
            int npages, Pointer<Byte> dirout, int outformat) {
        return convertFilesTo1bpp(Pointer.getPeer(dirin),
                Pointer.getPeer(substr), upscaling, thresh, firstpage, npages,
                Pointer.getPeer(dirout), outformat);
    }

    protected native static int convertFilesTo1bpp(@Ptr long dirin,
            @Ptr long substr, int upscaling, int thresh, int firstpage,
            int npages, @Ptr long dirout, int outformat);

    /**
     * Original signature :
     * <code>PIX* pixBlockconv(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:540</i>
     */
    public static Pointer<Pix> pixBlockconv(Pointer<Pix> pix, int wc, int hc) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlockconv(Pointer.getPeer(pix), wc, hc), Pix.class);
    }

    @Ptr
    protected native static long pixBlockconv(@Ptr long pix, int wc, int hc) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixBlockconvGray(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:541</i>
     */
    public static Pointer<Pix> pixBlockconvGray(Pointer<Pix> pixs,
            Pointer<Pix> pixacc, int wc, int hc) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlockconvGray(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixacc), wc, hc), Pix.class);
    }

    @Ptr
    protected native static long pixBlockconvGray(@Ptr long pixs,
            @Ptr long pixacc, int wc, int hc);

    /**
     * Original signature : <code>PIX* pixBlockconvAccum(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:542</i>
     */
    public static Pointer<Pix> pixBlockconvAccum(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlockconvAccum(Pointer.getPeer(pixs)), Pix.class);
    }

    @Ptr
    protected native static long pixBlockconvAccum(@Ptr long pixs) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixBlockconvGrayUnnormalized(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:543</i>
     */
    public static Pointer<Pix> pixBlockconvGrayUnnormalized(Pointer<Pix> pixs,
            int wc, int hc) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlockconvGrayUnnormalized(Pointer.getPeer(pixs), wc, hc),
                Pix.class);
    }

    @Ptr
    protected native static long pixBlockconvGrayUnnormalized(@Ptr long pixs,
            int wc, int hc);

    /**
     * Original signature :
     * <code>PIX* pixBlockconvTiled(PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:544</i>
     */
    public static Pointer<Pix> pixBlockconvTiled(Pointer<Pix> pix, int wc,
            int hc, int nx, int ny) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlockconvTiled(Pointer.getPeer(pix), wc, hc, nx, ny),
                Pix.class);
    }

    @Ptr
    protected native static long pixBlockconvTiled(@Ptr long pix, int wc,
            int hc, int nx, int ny);

    /**
     * Original signature :
     * <code>PIX* pixBlockconvGrayTile(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:545</i>
     */
    public static Pointer<Pix> pixBlockconvGrayTile(Pointer<Pix> pixs,
            Pointer<Pix> pixacc, int wc, int hc) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlockconvGrayTile(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixacc), wc, hc), Pix.class);
    }

    @Ptr
    protected native static long pixBlockconvGrayTile(@Ptr long pixs,
            @Ptr long pixacc, int wc, int hc);

    /**
     * Original signature :
     * <code>l_int32 pixWindowedStats(PIX*, l_int32, l_int32, l_int32, PIX**, PIX**, FPIX**, FPIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:546</i>
     */
    public static int pixWindowedStats(Pointer<Pix> pixs, int wc, int hc,
            int hasborder, Pointer<Pointer<Pix>> ppixm,
            Pointer<Pointer<Pix>> ppixms, Pointer<Pointer<FPix>> pfpixv,
            Pointer<Pointer<FPix>> pfpixrv) {
        return pixWindowedStats(Pointer.getPeer(pixs), wc, hc, hasborder,
                Pointer.getPeer(ppixm), Pointer.getPeer(ppixms),
                Pointer.getPeer(pfpixv), Pointer.getPeer(pfpixrv));
    }

    protected native static int pixWindowedStats(@Ptr long pixs, int wc,
            int hc, int hasborder, @Ptr long ppixm, @Ptr long ppixms,
            @Ptr long pfpixv, @Ptr long pfpixrv);

    /**
     * Original signature :
     * <code>PIX* pixWindowedMean(PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:547</i>
     */
    public static Pointer<Pix> pixWindowedMean(Pointer<Pix> pixs, int wc,
            int hc, int hasborder, int normflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixWindowedMean(Pointer.getPeer(pixs), wc, hc, hasborder,
                        normflag), Pix.class);
    }

    @Ptr
    protected native static long pixWindowedMean(@Ptr long pixs, int wc,
            int hc, int hasborder, int normflag);

    /**
     * Original signature :
     * <code>PIX* pixWindowedMeanSquare(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:548</i>
     */
    public static Pointer<Pix> pixWindowedMeanSquare(Pointer<Pix> pixs, int wc,
            int hc, int hasborder) {
        return (Pointer) Pointer.pointerToAddress(
                pixWindowedMeanSquare(Pointer.getPeer(pixs), wc, hc, hasborder),
                Pix.class);
    }

    @Ptr
    protected native static long pixWindowedMeanSquare(@Ptr long pixs, int wc,
            int hc, int hasborder);

    /**
     * Original signature :
     * <code>l_int32 pixWindowedVariance(PIX*, PIX*, FPIX**, FPIX**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:549</i>
     */
    public static int pixWindowedVariance(Pointer<Pix> pixm,
            Pointer<Pix> pixms, Pointer<Pointer<FPix>> pfpixv,
            Pointer<Pointer<FPix>> pfpixrv) {
        return pixWindowedVariance(Pointer.getPeer(pixm),
                Pointer.getPeer(pixms), Pointer.getPeer(pfpixv),
                Pointer.getPeer(pfpixrv));
    }

    protected native static int pixWindowedVariance(@Ptr long pixm,
            @Ptr long pixms, @Ptr long pfpixv, @Ptr long pfpixrv);

    /**
     * Original signature : <code>DPIX* pixMeanSquareAccum(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:550</i>
     */
    public static Pointer<DPix> pixMeanSquareAccum(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixMeanSquareAccum(Pointer.getPeer(pixs)), DPix.class);
    }

    @Ptr
    protected native static long pixMeanSquareAccum(@Ptr long pixs) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixBlockrank(PIX*, PIX*, l_int32, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:551</i>
     */
    public static Pointer<Pix> pixBlockrank(Pointer<Pix> pixs,
            Pointer<Pix> pixacc, int wc, int hc, float rank) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlockrank(Pointer.getPeer(pixs), Pointer.getPeer(pixacc),
                        wc, hc, rank), Pix.class);
    }

    @Ptr
    protected native static long pixBlockrank(@Ptr long pixs, @Ptr long pixacc,
            int wc, int hc, float rank);

    /**
     * Original signature :
     * <code>PIX* pixBlocksum(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:552</i>
     */
    public static Pointer<Pix> pixBlocksum(Pointer<Pix> pixs,
            Pointer<Pix> pixacc, int wc, int hc) {
        return (Pointer) Pointer.pointerToAddress(
                pixBlocksum(Pointer.getPeer(pixs), Pointer.getPeer(pixacc), wc,
                        hc), Pix.class);
    }

    @Ptr
    protected native static long pixBlocksum(@Ptr long pixs, @Ptr long pixacc,
            int wc, int hc);

    /**
     * Original signature :
     * <code>PIX* pixCensusTransform(PIX*, l_int32, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:553</i>
     */
    public static Pointer<Pix> pixCensusTransform(Pointer<Pix> pixs,
            int halfsize, Pointer<Pix> pixacc) {
        return (Pointer) Pointer.pointerToAddress(
                pixCensusTransform(Pointer.getPeer(pixs), halfsize,
                        Pointer.getPeer(pixacc)), Pix.class);
    }

    @Ptr
    protected native static long pixCensusTransform(@Ptr long pixs,
            int halfsize, @Ptr long pixacc);

    /**
     * Original signature :
     * <code>PIX* pixConvolve(PIX*, L_KERNEL*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:554</i>
     */
    public static Pointer<Pix> pixConvolve(Pointer<Pix> pixs,
            Pointer<L_Kernel> kel, int outdepth, int normflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvolve(Pointer.getPeer(pixs), Pointer.getPeer(kel),
                        outdepth, normflag), Pix.class);
    }

    @Ptr
    protected native static long pixConvolve(@Ptr long pixs, @Ptr long kel,
            int outdepth, int normflag);

    /**
     * Original signature :
     * <code>PIX* pixConvolveSep(PIX*, L_KERNEL*, L_KERNEL*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:555</i>
     */
    public static Pointer<Pix> pixConvolveSep(Pointer<Pix> pixs,
            Pointer<L_Kernel> kelx, Pointer<L_Kernel> kely, int outdepth,
            int normflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvolveSep(Pointer.getPeer(pixs), Pointer.getPeer(kelx),
                        Pointer.getPeer(kely), outdepth, normflag), Pix.class);
    }

    @Ptr
    protected native static long pixConvolveSep(@Ptr long pixs, @Ptr long kelx,
            @Ptr long kely, int outdepth, int normflag);

    /**
     * Original signature : <code>PIX* pixConvolveRGB(PIX*, L_KERNEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:556</i>
     */
    public static Pointer<Pix> pixConvolveRGB(Pointer<Pix> pixs,
            Pointer<L_Kernel> kel) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvolveRGB(Pointer.getPeer(pixs), Pointer.getPeer(kel)),
                Pix.class);
    }

    @Ptr
    protected native static long pixConvolveRGB(@Ptr long pixs, @Ptr long kel) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixConvolveRGBSep(PIX*, L_KERNEL*, L_KERNEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:557</i>
     */
    public static Pointer<Pix> pixConvolveRGBSep(Pointer<Pix> pixs,
            Pointer<L_Kernel> kelx, Pointer<L_Kernel> kely) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvolveRGBSep(Pointer.getPeer(pixs), Pointer.getPeer(kelx),
                        Pointer.getPeer(kely)), Pix.class);
    }

    @Ptr
    protected native static long pixConvolveRGBSep(@Ptr long pixs,
            @Ptr long kelx, @Ptr long kely);

    /**
     * Original signature :
     * <code>FPIX* fpixConvolve(FPIX*, L_KERNEL*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:558</i>
     */
    public static Pointer<FPix> fpixConvolve(Pointer<FPix> fpixs,
            Pointer<L_Kernel> kel, int normflag) {
        return (Pointer) Pointer.pointerToAddress(
                fpixConvolve(Pointer.getPeer(fpixs), Pointer.getPeer(kel),
                        normflag), FPix.class);
    }

    @Ptr
    protected native static long fpixConvolve(@Ptr long fpixs, @Ptr long kel,
            int normflag);

    /**
     * Original signature :
     * <code>FPIX* fpixConvolveSep(FPIX*, L_KERNEL*, L_KERNEL*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:559</i>
     */
    public static Pointer<FPix> fpixConvolveSep(Pointer<FPix> fpixs,
            Pointer<L_Kernel> kelx, Pointer<L_Kernel> kely, int normflag) {
        return (Pointer) Pointer.pointerToAddress(
                fpixConvolveSep(Pointer.getPeer(fpixs), Pointer.getPeer(kelx),
                        Pointer.getPeer(kely), normflag), FPix.class);
    }

    @Ptr
    protected native static long fpixConvolveSep(@Ptr long fpixs,
            @Ptr long kelx, @Ptr long kely, int normflag);

    /**
     * Original signature :
     * <code>PIX* pixConvolveWithBias(PIX*, L_KERNEL*, L_KERNEL*, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:560</i>
     */
    public static Pointer<Pix> pixConvolveWithBias(Pointer<Pix> pixs,
            Pointer<L_Kernel> kel1, Pointer<L_Kernel> kel2, int force8,
            Pointer<Integer> pbias) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvolveWithBias(Pointer.getPeer(pixs),
                        Pointer.getPeer(kel1), Pointer.getPeer(kel2), force8,
                        Pointer.getPeer(pbias)), Pix.class);
    }

    @Ptr
    protected native static long pixConvolveWithBias(@Ptr long pixs,
            @Ptr long kel1, @Ptr long kel2, int force8, @Ptr long pbias);

    /**
     * Original signature :
     * <code>void l_setConvolveSampling(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:561</i>
     */
    public static native void l_setConvolveSampling(int xfact, int yfact) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixAddGaussianNoise(PIX*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:562</i>
     */
    public static Pointer<Pix> pixAddGaussianNoise(Pointer<Pix> pixs,
            float stdev) {
        return (Pointer) Pointer.pointerToAddress(
                pixAddGaussianNoise(Pointer.getPeer(pixs), stdev), Pix.class);
    }

    @Ptr
    protected native static long pixAddGaussianNoise(@Ptr long pixs, float stdev) throws LastError;

    /**
     * Original signature : <code>l_float32 gaussDistribSampling()</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:563</i>
     */
    public static native float gaussDistribSampling() throws LastError;

    /**
     * Original signature :
     * <code>void blockconvLow(l_uint32*, l_int32, l_int32, l_int32, l_uint32*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:564</i>
     */
    public static void blockconvLow(Pointer<Integer> data, int w, int h,
            int wpl, Pointer<Integer> dataa, int wpla, int wc, int hc) {
        blockconvLow(Pointer.getPeer(data), w, h, wpl, Pointer.getPeer(dataa),
                wpla, wc, hc);
    }

    protected native static void blockconvLow(@Ptr long data, int w, int h,
            int wpl, @Ptr long dataa, int wpla, int wc, int hc);

    /**
     * Original signature :
     * <code>void blockconvAccumLow(l_uint32*, l_int32, l_int32, l_int32, l_uint32*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:565</i>
     */
    public static void blockconvAccumLow(Pointer<Integer> datad, int w, int h,
            int wpld, Pointer<Integer> datas, int d, int wpls) {
        blockconvAccumLow(Pointer.getPeer(datad), w, h, wpld,
                Pointer.getPeer(datas), d, wpls);
    }

    protected native static void blockconvAccumLow(@Ptr long datad, int w,
            int h, int wpld, @Ptr long datas, int d, int wpls);

    /**
     * Original signature :
     * <code>void blocksumLow(l_uint32*, l_int32, l_int32, l_int32, l_uint32*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:566</i>
     */
    public static void blocksumLow(Pointer<Integer> datad, int w, int h,
            int wpl, Pointer<Integer> dataa, int wpla, int wc, int hc) {
        blocksumLow(Pointer.getPeer(datad), w, h, wpl, Pointer.getPeer(dataa),
                wpla, wc, hc);
    }

    protected native static void blocksumLow(@Ptr long datad, int w, int h,
            int wpl, @Ptr long dataa, int wpla, int wc, int hc);

    /**
     * Original signature :
     * <code>l_int32 pixCorrelationScore(PIX*, PIX*, l_int32, l_int32, l_float32, l_float32, l_int32, l_int32, l_int32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:567</i>
     */
    public static int pixCorrelationScore(Pointer<Pix> pix1, Pointer<Pix> pix2,
            int area1, int area2, float delx, float dely, int maxdiffw,
            int maxdiffh, Pointer<Integer> tab, Pointer<Float> pscore) {
        return pixCorrelationScore(Pointer.getPeer(pix1),
                Pointer.getPeer(pix2), area1, area2, delx, dely, maxdiffw,
                maxdiffh, Pointer.getPeer(tab), Pointer.getPeer(pscore));
    }

    protected native static int pixCorrelationScore(@Ptr long pix1,
            @Ptr long pix2, int area1, int area2, float delx, float dely,
            int maxdiffw, int maxdiffh, @Ptr long tab, @Ptr long pscore);

    /**
     * Original signature :
     * <code>l_int32 pixCorrelationScoreThresholded(PIX*, PIX*, l_int32, l_int32, l_float32, l_float32, l_int32, l_int32, l_int32*, l_int32*, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:568</i>
     */
    public static int pixCorrelationScoreThresholded(Pointer<Pix> pix1,
            Pointer<Pix> pix2, int area1, int area2, float delx, float dely,
            int maxdiffw, int maxdiffh, Pointer<Integer> tab,
            Pointer<Integer> downcount, float score_threshold) {
        return pixCorrelationScoreThresholded(Pointer.getPeer(pix1),
                Pointer.getPeer(pix2), area1, area2, delx, dely, maxdiffw,
                maxdiffh, Pointer.getPeer(tab), Pointer.getPeer(downcount),
                score_threshold);
    }

    protected native static int pixCorrelationScoreThresholded(@Ptr long pix1,
            @Ptr long pix2, int area1, int area2, float delx, float dely,
            int maxdiffw, int maxdiffh, @Ptr long tab, @Ptr long downcount,
            float score_threshold);

    /**
     * Original signature :
     * <code>l_int32 pixCorrelationScoreSimple(PIX*, PIX*, l_int32, l_int32, l_float32, l_float32, l_int32, l_int32, l_int32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:569</i>
     */
    public static int pixCorrelationScoreSimple(Pointer<Pix> pix1,
            Pointer<Pix> pix2, int area1, int area2, float delx, float dely,
            int maxdiffw, int maxdiffh, Pointer<Integer> tab,
            Pointer<Float> pscore) {
        return pixCorrelationScoreSimple(Pointer.getPeer(pix1),
                Pointer.getPeer(pix2), area1, area2, delx, dely, maxdiffw,
                maxdiffh, Pointer.getPeer(tab), Pointer.getPeer(pscore));
    }

    protected native static int pixCorrelationScoreSimple(@Ptr long pix1,
            @Ptr long pix2, int area1, int area2, float delx, float dely,
            int maxdiffw, int maxdiffh, @Ptr long tab, @Ptr long pscore);

    /**
     * Original signature :
     * <code>l_int32 pixCorrelationScoreShifted(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, l_int32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:570</i>
     */
    public static int pixCorrelationScoreShifted(Pointer<Pix> pix1,
            Pointer<Pix> pix2, int area1, int area2, int delx, int dely,
            Pointer<Integer> tab, Pointer<Float> pscore) {
        return pixCorrelationScoreShifted(Pointer.getPeer(pix1),
                Pointer.getPeer(pix2), area1, area2, delx, dely,
                Pointer.getPeer(tab), Pointer.getPeer(pscore));
    }

    protected native static int pixCorrelationScoreShifted(@Ptr long pix1,
            @Ptr long pix2, int area1, int area2, int delx, int dely,
            @Ptr long tab, @Ptr long pscore);

    /**
     * Original signature : <code>L_DEWARP* dewarpCreate(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:571</i>
     */
    public static Pointer<L_Dewarp> dewarpCreate(Pointer<Pix> pixs, int pageno) {
        return (Pointer) Pointer.pointerToAddress(
                dewarpCreate(Pointer.getPeer(pixs), pageno), L_Dewarp.class);
    }

    @Ptr
    protected native static long dewarpCreate(@Ptr long pixs, int pageno) throws LastError;

    /**
     * Original signature :
     * <code>L_DEWARP* dewarpCreateRef(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:572</i>
     */
    public static Pointer<L_Dewarp> dewarpCreateRef(int pageno, int refpage) {
        return (Pointer) Pointer.pointerToAddress(
                dewarpCreateRef$2(pageno, refpage), L_Dewarp.class);
    }

    @Ptr
    @Name("dewarpCreateRef")
    protected native static long dewarpCreateRef$2(int pageno, int refpage) throws LastError;

    /**
     * Original signature : <code>void dewarpDestroy(L_DEWARP**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:573</i>
     */
    public static void dewarpDestroy(Pointer<Pointer<L_Dewarp>> pdew) {
        dewarpDestroy(Pointer.getPeer(pdew));
    }

    protected native static void dewarpDestroy(@Ptr long pdew) throws LastError;

    /**
     * Original signature :
     * <code>L_DEWARPA* dewarpaCreate(l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:574</i>
     */
    public static Pointer<L_Dewarpa> dewarpaCreate(int nptrs, int sampling,
            int redfactor, int minlines, int maxdist) {
        return (Pointer) Pointer.pointerToAddress(
                dewarpaCreate$2(nptrs, sampling, redfactor, minlines, maxdist),
                L_Dewarpa.class);
    }

    @Ptr
    @Name("dewarpaCreate")
    protected native static long dewarpaCreate$2(int nptrs, int sampling,
            int redfactor, int minlines, int maxdist);

    /**
     * Original signature :
     * <code>L_DEWARPA* dewarpaCreateFromPixacomp(PIXAC*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:575</i>
     */
    public static Pointer<L_Dewarpa> dewarpaCreateFromPixacomp(
            Pointer<PixaComp> pixac, int useboth, int sampling, int minlines,
            int maxdist) {
        return (Pointer) Pointer.pointerToAddress(
                dewarpaCreateFromPixacomp(Pointer.getPeer(pixac), useboth,
                        sampling, minlines, maxdist), L_Dewarpa.class);
    }

    @Ptr
    protected native static long dewarpaCreateFromPixacomp(@Ptr long pixac,
            int useboth, int sampling, int minlines, int maxdist);

    /**
     * Original signature : <code>void dewarpaDestroy(L_DEWARPA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:576</i>
     */
    public static void dewarpaDestroy(Pointer<Pointer<L_Dewarpa>> pdewa) {
        dewarpaDestroy(Pointer.getPeer(pdewa));
    }

    protected native static void dewarpaDestroy(@Ptr long pdewa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dewarpaDestroyDewarp(L_DEWARPA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:577</i>
     */
    public static int dewarpaDestroyDewarp(Pointer<L_Dewarpa> dewa, int pageno) {
        return dewarpaDestroyDewarp(Pointer.getPeer(dewa), pageno);
    }

    protected native static int dewarpaDestroyDewarp(@Ptr long dewa, int pageno) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dewarpaInsertDewarp(L_DEWARPA*, L_DEWARP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:578</i>
     */
    public static int dewarpaInsertDewarp(Pointer<L_Dewarpa> dewa,
            Pointer<L_Dewarp> dew) {
        return dewarpaInsertDewarp(Pointer.getPeer(dewa), Pointer.getPeer(dew));
    }

    protected native static int dewarpaInsertDewarp(@Ptr long dewa,
            @Ptr long dew);

    /**
     * Original signature :
     * <code>L_DEWARP* dewarpaGetDewarp(L_DEWARPA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:579</i>
     */
    public static Pointer<L_Dewarp> dewarpaGetDewarp(Pointer<L_Dewarpa> dewa,
            int index) {
        return (Pointer) Pointer.pointerToAddress(
                dewarpaGetDewarp(Pointer.getPeer(dewa), index), L_Dewarp.class);
    }

    @Ptr
    protected native static long dewarpaGetDewarp(@Ptr long dewa, int index) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dewarpaSetCurvatures(L_DEWARPA*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:580</i>
     */
    public static int dewarpaSetCurvatures(Pointer<L_Dewarpa> dewa,
            int max_linecurv, int min_diff_linecurv, int max_diff_linecurv,
            int max_edgecurv, int max_diff_edgecurv) {
        return dewarpaSetCurvatures(Pointer.getPeer(dewa), max_linecurv,
                min_diff_linecurv, max_diff_linecurv, max_edgecurv,
                max_diff_edgecurv);
    }

    protected native static int dewarpaSetCurvatures(@Ptr long dewa,
            int max_linecurv, int min_diff_linecurv, int max_diff_linecurv,
            int max_edgecurv, int max_diff_edgecurv);

    /**
     * Original signature :
     * <code>l_int32 dewarpaUseBothArrays(L_DEWARPA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:581</i>
     */
    public static int dewarpaUseBothArrays(Pointer<L_Dewarpa> dewa, int useboth) {
        return dewarpaUseBothArrays(Pointer.getPeer(dewa), useboth);
    }

    protected native static int dewarpaUseBothArrays(@Ptr long dewa, int useboth) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dewarpaSetMaxDistance(L_DEWARPA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:582</i>
     */
    public static int dewarpaSetMaxDistance(Pointer<L_Dewarpa> dewa, int maxdist) {
        return dewarpaSetMaxDistance(Pointer.getPeer(dewa), maxdist);
    }

    protected native static int dewarpaSetMaxDistance(@Ptr long dewa,
            int maxdist);

    /**
     * Original signature : <code>L_DEWARP* dewarpRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:583</i>
     */
    public static Pointer<L_Dewarp> dewarpRead(Pointer<Byte> filename) {
        return (Pointer) Pointer.pointerToAddress(
                dewarpRead(Pointer.getPeer(filename)), L_Dewarp.class);
    }

    @Ptr
    protected native static long dewarpRead(@Ptr long filename) throws LastError;

    /**
     * Original signature : <code>L_DEWARP* dewarpReadStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:584</i>
     */
    public static Pointer<L_Dewarp> dewarpReadStream(
            Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                dewarpReadStream(Pointer.getPeer(fp)), L_Dewarp.class);
    }

    @Ptr
    protected native static long dewarpReadStream(@Ptr long fp) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dewarpWrite(const char*, L_DEWARP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:585</i>
     */
    public static int dewarpWrite(Pointer<Byte> filename, Pointer<L_Dewarp> dew) {
        return dewarpWrite(Pointer.getPeer(filename), Pointer.getPeer(dew));
    }

    protected native static int dewarpWrite(@Ptr long filename, @Ptr long dew) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dewarpWriteStream(FILE*, L_DEWARP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:586</i>
     */
    public static int dewarpWriteStream(Pointer<FILE> fp,
            Pointer<L_Dewarp> dew) {
        return dewarpWriteStream(Pointer.getPeer(fp), Pointer.getPeer(dew));
    }

    protected native static int dewarpWriteStream(@Ptr long fp, @Ptr long dew) throws LastError;

    /**
     * Original signature : <code>L_DEWARPA* dewarpaRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:587</i>
     */
    public static Pointer<L_Dewarpa> dewarpaRead(Pointer<Byte> filename) {
        return (Pointer) Pointer.pointerToAddress(
                dewarpaRead(Pointer.getPeer(filename)), L_Dewarpa.class);
    }

    @Ptr
    protected native static long dewarpaRead(@Ptr long filename) throws LastError;

    /**
     * Original signature : <code>L_DEWARPA* dewarpaReadStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:588</i>
     */
    public static Pointer<L_Dewarpa> dewarpaReadStream(
            Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                dewarpaReadStream(Pointer.getPeer(fp)), L_Dewarpa.class);
    }

    @Ptr
    protected native static long dewarpaReadStream(@Ptr long fp) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dewarpaWrite(const char*, L_DEWARPA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:589</i>
     */
    public static int dewarpaWrite(Pointer<Byte> filename,
            Pointer<L_Dewarpa> dewa) {
        return dewarpaWrite(Pointer.getPeer(filename), Pointer.getPeer(dewa));
    }

    protected native static int dewarpaWrite(@Ptr long filename, @Ptr long dewa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dewarpaWriteStream(FILE*, L_DEWARPA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:590</i>
     */
    public static int dewarpaWriteStream(Pointer<FILE> fp,
            Pointer<L_Dewarpa> dewa) {
        return dewarpaWriteStream(Pointer.getPeer(fp), Pointer.getPeer(dewa));
    }

    protected native static int dewarpaWriteStream(@Ptr long fp, @Ptr long dewa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dewarpBuildPageModel(L_DEWARP*, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:591</i>
     */
    public static int dewarpBuildPageModel(Pointer<L_Dewarp> dew,
            Pointer<Byte> debugfile) {
        return dewarpBuildPageModel(Pointer.getPeer(dew),
                Pointer.getPeer(debugfile));
    }

    protected native static int dewarpBuildPageModel(@Ptr long dew,
            @Ptr long debugfile);

    /**
     * Original signature :
     * <code>l_int32 dewarpFindVertDisparity(L_DEWARP*, PTAA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:592</i>
     */
    public static int dewarpFindVertDisparity(Pointer<L_Dewarp> dew,
            Pointer<Ptaa> ptaa, int rotflag) {
        return dewarpFindVertDisparity(Pointer.getPeer(dew),
                Pointer.getPeer(ptaa), rotflag);
    }

    protected native static int dewarpFindVertDisparity(@Ptr long dew,
            @Ptr long ptaa, int rotflag);

    /**
     * Original signature :
     * <code>l_int32 dewarpFindHorizDisparity(L_DEWARP*, PTAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:593</i>
     */
    public static int dewarpFindHorizDisparity(Pointer<L_Dewarp> dew,
            Pointer<Ptaa> ptaa) {
        return dewarpFindHorizDisparity(Pointer.getPeer(dew),
                Pointer.getPeer(ptaa));
    }

    protected native static int dewarpFindHorizDisparity(@Ptr long dew,
            @Ptr long ptaa);

    /**
     * Original signature :
     * <code>PTAA* dewarpGetTextlineCenters(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:594</i>
     */
    public static Pointer<Ptaa> dewarpGetTextlineCenters(Pointer<Pix> pixs,
            int debugflag) {
        return (Pointer) Pointer.pointerToAddress(
                dewarpGetTextlineCenters(Pointer.getPeer(pixs), debugflag),
                Ptaa.class);
    }

    @Ptr
    protected native static long dewarpGetTextlineCenters(@Ptr long pixs,
            int debugflag);

    /**
     * Original signature :
     * <code>PTAA* dewarpRemoveShortLines(PIX*, PTAA*, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:595</i>
     */
    public static Pointer<Ptaa> dewarpRemoveShortLines(Pointer<Pix> pixs,
            Pointer<Ptaa> ptaas, float fract, int debugflag) {
        return (Pointer) Pointer.pointerToAddress(
                dewarpRemoveShortLines(Pointer.getPeer(pixs),
                        Pointer.getPeer(ptaas), fract, debugflag), Ptaa.class);
    }

    @Ptr
    protected native static long dewarpRemoveShortLines(@Ptr long pixs,
            @Ptr long ptaas, float fract, int debugflag);

    /**
     * Original signature :
     * <code>l_int32 dewarpBuildLineModel(L_DEWARP*, l_int32, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:596</i>
     */
    public static int dewarpBuildLineModel(Pointer<L_Dewarp> dew, int opensize,
            Pointer<Byte> debugfile) {
        return dewarpBuildLineModel(Pointer.getPeer(dew), opensize,
                Pointer.getPeer(debugfile));
    }

    protected native static int dewarpBuildLineModel(@Ptr long dew,
            int opensize, @Ptr long debugfile);

    /**
     * Original signature :
     * <code>l_int32 dewarpaModelStatus(L_DEWARPA*, l_int32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:597</i>
     */
    public static int dewarpaModelStatus(Pointer<L_Dewarpa> dewa, int pageno,
            Pointer<Integer> pvsuccess, Pointer<Integer> phsuccess) {
        return dewarpaModelStatus(Pointer.getPeer(dewa), pageno,
                Pointer.getPeer(pvsuccess), Pointer.getPeer(phsuccess));
    }

    protected native static int dewarpaModelStatus(@Ptr long dewa, int pageno,
            @Ptr long pvsuccess, @Ptr long phsuccess);

    /**
     * Original signature :
     * <code>l_int32 dewarpaApplyDisparity(L_DEWARPA*, l_int32, PIX*, l_int32, l_int32, l_int32, PIX**, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:598</i>
     */
    public static int dewarpaApplyDisparity(Pointer<L_Dewarpa> dewa,
            int pageno, Pointer<Pix> pixs, int grayin, int x, int y,
            Pointer<Pointer<Pix>> ppixd, Pointer<Byte> debugfile) {
        return dewarpaApplyDisparity(Pointer.getPeer(dewa), pageno,
                Pointer.getPeer(pixs), grayin, x, y, Pointer.getPeer(ppixd),
                Pointer.getPeer(debugfile));
    }

    protected native static int dewarpaApplyDisparity(@Ptr long dewa,
            int pageno, @Ptr long pixs, int grayin, int x, int y,
            @Ptr long ppixd, @Ptr long debugfile);

    /**
     * Original signature : <code>l_int32 dewarpMinimize(L_DEWARP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:599</i>
     */
    public static int dewarpMinimize(Pointer<L_Dewarp> dew) {
        return dewarpMinimize(Pointer.getPeer(dew));
    }

    protected native static int dewarpMinimize(@Ptr long dew) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dewarpPopulateFullRes(L_DEWARP*, PIX*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:600</i>
     */
    public static int dewarpPopulateFullRes(Pointer<L_Dewarp> dew,
            Pointer<Pix> pix, int x, int y) {
        return dewarpPopulateFullRes(Pointer.getPeer(dew),
                Pointer.getPeer(pix), x, y);
    }

    protected native static int dewarpPopulateFullRes(@Ptr long dew,
            @Ptr long pix, int x, int y);

    /**
     * Original signature :
     * <code>l_int32 dewarpSinglePage(PIX*, l_int32, l_int32, l_int32, PIX**, L_DEWARPA**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:601</i>
     */
    public static int dewarpSinglePage(Pointer<Pix> pixs, int thresh,
            int adaptive, int both, Pointer<Pointer<Pix>> ppixd,
            Pointer<Pointer<L_Dewarpa>> pdewa, int debug) {
        return dewarpSinglePage(Pointer.getPeer(pixs), thresh, adaptive, both,
                Pointer.getPeer(ppixd), Pointer.getPeer(pdewa), debug);
    }

    protected native static int dewarpSinglePage(@Ptr long pixs, int thresh,
            int adaptive, int both, @Ptr long ppixd, @Ptr long pdewa, int debug);

    /**
     * Original signature : <code>l_int32 dewarpaListPages(L_DEWARPA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:602</i>
     */
    public static int dewarpaListPages(Pointer<L_Dewarpa> dewa) {
        return dewarpaListPages(Pointer.getPeer(dewa));
    }

    protected native static int dewarpaListPages(@Ptr long dewa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dewarpaSetValidModels(L_DEWARPA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:603</i>
     */
    public static int dewarpaSetValidModels(Pointer<L_Dewarpa> dewa,
            int notests, int debug) {
        return dewarpaSetValidModels(Pointer.getPeer(dewa), notests, debug);
    }

    protected native static int dewarpaSetValidModels(@Ptr long dewa,
            int notests, int debug);

    /**
     * Original signature :
     * <code>l_int32 dewarpaInsertRefModels(L_DEWARPA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:604</i>
     */
    public static int dewarpaInsertRefModels(Pointer<L_Dewarpa> dewa,
            int notests, int debug) {
        return dewarpaInsertRefModels(Pointer.getPeer(dewa), notests, debug);
    }

    protected native static int dewarpaInsertRefModels(@Ptr long dewa,
            int notests, int debug);

    /**
     * Original signature :
     * <code>l_int32 dewarpaStripRefModels(L_DEWARPA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:605</i>
     */
    public static int dewarpaStripRefModels(Pointer<L_Dewarpa> dewa) {
        return dewarpaStripRefModels(Pointer.getPeer(dewa));
    }

    protected native static int dewarpaStripRefModels(@Ptr long dewa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dewarpaRestoreModels(L_DEWARPA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:606</i>
     */
    public static int dewarpaRestoreModels(Pointer<L_Dewarpa> dewa) {
        return dewarpaRestoreModels(Pointer.getPeer(dewa));
    }

    protected native static int dewarpaRestoreModels(@Ptr long dewa) throws LastError;

    /**
     * Original signature : <code>l_int32 dewarpaInfo(FILE*, L_DEWARPA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:607</i>
     */
    public static int dewarpaInfo(Pointer<FILE> fp,
            Pointer<L_Dewarpa> dewa) {
        return dewarpaInfo(Pointer.getPeer(fp), Pointer.getPeer(dewa));
    }

    protected native static int dewarpaInfo(@Ptr long fp, @Ptr long dewa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dewarpaModelStats(L_DEWARPA*, l_int32*, l_int32*, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:608</i>
     */
    public static int dewarpaModelStats(Pointer<L_Dewarpa> dewa,
            Pointer<Integer> pnnone, Pointer<Integer> pnvsuccess,
            Pointer<Integer> pnvvalid, Pointer<Integer> pnhsuccess,
            Pointer<Integer> pnhvalid, Pointer<Integer> pnref) {
        return dewarpaModelStats(Pointer.getPeer(dewa),
                Pointer.getPeer(pnnone), Pointer.getPeer(pnvsuccess),
                Pointer.getPeer(pnvvalid), Pointer.getPeer(pnhsuccess),
                Pointer.getPeer(pnhvalid), Pointer.getPeer(pnref));
    }

    protected native static int dewarpaModelStats(@Ptr long dewa,
            @Ptr long pnnone, @Ptr long pnvsuccess, @Ptr long pnvvalid,
            @Ptr long pnhsuccess, @Ptr long pnhvalid, @Ptr long pnref);

    /**
     * Original signature :
     * <code>l_int32 dewarpaShowArrays(L_DEWARPA*, l_float32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:609</i>
     */
    public static int dewarpaShowArrays(Pointer<L_Dewarpa> dewa,
            float scalefact, int first, int last) {
        return dewarpaShowArrays(Pointer.getPeer(dewa), scalefact, first, last);
    }

    protected native static int dewarpaShowArrays(@Ptr long dewa,
            float scalefact, int first, int last);

    /**
     * Original signature :
     * <code>l_int32 dewarpDebug(L_DEWARP*, const char*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:610</i>
     */
    public static int dewarpDebug(Pointer<L_Dewarp> dew, Pointer<Byte> subdir,
            int index) {
        return dewarpDebug(Pointer.getPeer(dew), Pointer.getPeer(subdir), index);
    }

    protected native static int dewarpDebug(@Ptr long dew, @Ptr long subdir,
            int index);

    /**
     * Original signature :
     * <code>l_int32 dewarpShowResults(L_DEWARPA*, SARRAY*, BOXA*, l_int32, l_int32, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:611</i>
     */
    public static int dewarpShowResults(Pointer<L_Dewarpa> dewa,
            Pointer<Sarray> sa, Pointer<Boxa> boxa, int firstpage,
            int lastpage, Pointer<Byte> pdfout) {
        return dewarpShowResults(Pointer.getPeer(dewa), Pointer.getPeer(sa),
                Pointer.getPeer(boxa), firstpage, lastpage,
                Pointer.getPeer(pdfout));
    }

    protected native static int dewarpShowResults(@Ptr long dewa, @Ptr long sa,
            @Ptr long boxa, int firstpage, int lastpage, @Ptr long pdfout);

    /**
     * Original signature : <code>L_DNA* l_dnaCreate(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:612</i>
     */
    public static Pointer<L_Dna> l_dnaCreate(int n) {
        return (Pointer) Pointer.pointerToAddress(l_dnaCreate$2(n), L_Dna.class);
    }

    @Ptr
    @Name("l_dnaCreate")
    protected native static long l_dnaCreate$2(int n) throws LastError;

    /**
     * Original signature :
     * <code>L_DNA* l_dnaCreateFromIArray(l_int32*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:613</i>
     */
    public static Pointer<L_Dna> l_dnaCreateFromIArray(Pointer<Integer> iarray,
            int size) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaCreateFromIArray(Pointer.getPeer(iarray), size),
                L_Dna.class);
    }

    @Ptr
    protected native static long l_dnaCreateFromIArray(@Ptr long iarray,
            int size);

    /**
     * Original signature :
     * <code>L_DNA* l_dnaCreateFromDArray(l_float64*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:614</i>
     */
    public static Pointer<L_Dna> l_dnaCreateFromDArray(Pointer<Double> darray,
            int size, int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaCreateFromDArray(Pointer.getPeer(darray), size, copyflag),
                L_Dna.class);
    }

    @Ptr
    protected native static long l_dnaCreateFromDArray(@Ptr long darray,
            int size, int copyflag);

    /**
     * Original signature :
     * <code>L_DNA* l_dnaMakeSequence(l_float64, l_float64, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:615</i>
     */
    public static Pointer<L_Dna> l_dnaMakeSequence(double startval,
            double increment, int size) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaMakeSequence$2(startval, increment, size), L_Dna.class);
    }

    @Ptr
    @Name("l_dnaMakeSequence")
    protected native static long l_dnaMakeSequence$2(double startval,
            double increment, int size);

    /**
     * Original signature : <code>void l_dnaDestroy(L_DNA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:616</i>
     */
    public static void l_dnaDestroy(Pointer<Pointer<L_Dna>> pda) {
        l_dnaDestroy(Pointer.getPeer(pda));
    }

    protected native static void l_dnaDestroy(@Ptr long pda) throws LastError;

    /**
     * Original signature : <code>L_DNA* l_dnaCopy(L_DNA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:617</i>
     */
    public static Pointer<L_Dna> l_dnaCopy(Pointer<L_Dna> da) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaCopy(Pointer.getPeer(da)), L_Dna.class);
    }

    @Ptr
    protected native static long l_dnaCopy(@Ptr long da) throws LastError;

    /**
     * Original signature : <code>L_DNA* l_dnaClone(L_DNA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:618</i>
     */
    public static Pointer<L_Dna> l_dnaClone(Pointer<L_Dna> da) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaClone(Pointer.getPeer(da)), L_Dna.class);
    }

    @Ptr
    protected native static long l_dnaClone(@Ptr long da) throws LastError;

    /**
     * Original signature : <code>l_int32 l_dnaEmpty(L_DNA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:619</i>
     */
    public static int l_dnaEmpty(Pointer<L_Dna> da) {
        return l_dnaEmpty(Pointer.getPeer(da));
    }

    protected native static int l_dnaEmpty(@Ptr long da) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_dnaAddNumber(L_DNA*, l_float64)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:620</i>
     */
    public static int l_dnaAddNumber(Pointer<L_Dna> da, double val) {
        return l_dnaAddNumber(Pointer.getPeer(da), val);
    }

    protected native static int l_dnaAddNumber(@Ptr long da, double val) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_dnaInsertNumber(L_DNA*, l_int32, l_float64)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:621</i>
     */
    public static int l_dnaInsertNumber(Pointer<L_Dna> da, int index, double val) {
        return l_dnaInsertNumber(Pointer.getPeer(da), index, val);
    }

    protected native static int l_dnaInsertNumber(@Ptr long da, int index,
            double val);

    /**
     * Original signature :
     * <code>l_int32 l_dnaRemoveNumber(L_DNA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:622</i>
     */
    public static int l_dnaRemoveNumber(Pointer<L_Dna> da, int index) {
        return l_dnaRemoveNumber(Pointer.getPeer(da), index);
    }

    protected native static int l_dnaRemoveNumber(@Ptr long da, int index) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_dnaReplaceNumber(L_DNA*, l_int32, l_float64)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:623</i>
     */
    public static int l_dnaReplaceNumber(Pointer<L_Dna> da, int index,
            double val) {
        return l_dnaReplaceNumber(Pointer.getPeer(da), index, val);
    }

    protected native static int l_dnaReplaceNumber(@Ptr long da, int index,
            double val);

    /**
     * Original signature : <code>l_int32 l_dnaGetCount(L_DNA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:624</i>
     */
    public static int l_dnaGetCount(Pointer<L_Dna> da) {
        return l_dnaGetCount(Pointer.getPeer(da));
    }

    protected native static int l_dnaGetCount(@Ptr long da) throws LastError;

    /**
     * Original signature : <code>l_int32 l_dnaSetCount(L_DNA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:625</i>
     */
    public static int l_dnaSetCount(Pointer<L_Dna> da, int newcount) {
        return l_dnaSetCount(Pointer.getPeer(da), newcount);
    }

    protected native static int l_dnaSetCount(@Ptr long da, int newcount) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_dnaGetDValue(L_DNA*, l_int32, l_float64*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:626</i>
     */
    public static int l_dnaGetDValue(Pointer<L_Dna> da, int index,
            Pointer<Double> pval) {
        return l_dnaGetDValue(Pointer.getPeer(da), index, Pointer.getPeer(pval));
    }

    protected native static int l_dnaGetDValue(@Ptr long da, int index,
            @Ptr long pval);

    /**
     * Original signature :
     * <code>l_int32 l_dnaGetIValue(L_DNA*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:627</i>
     */
    public static int l_dnaGetIValue(Pointer<L_Dna> da, int index,
            Pointer<Integer> pival) {
        return l_dnaGetIValue(Pointer.getPeer(da), index,
                Pointer.getPeer(pival));
    }

    protected native static int l_dnaGetIValue(@Ptr long da, int index,
            @Ptr long pival);

    /**
     * Original signature :
     * <code>l_int32 l_dnaSetValue(L_DNA*, l_int32, l_float64)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:628</i>
     */
    public static int l_dnaSetValue(Pointer<L_Dna> da, int index, double val) {
        return l_dnaSetValue(Pointer.getPeer(da), index, val);
    }

    protected native static int l_dnaSetValue(@Ptr long da, int index,
            double val);

    /**
     * Original signature :
     * <code>l_int32 l_dnaShiftValue(L_DNA*, l_int32, l_float64)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:629</i>
     */
    public static int l_dnaShiftValue(Pointer<L_Dna> da, int index, double diff) {
        return l_dnaShiftValue(Pointer.getPeer(da), index, diff);
    }

    protected native static int l_dnaShiftValue(@Ptr long da, int index,
            double diff);

    /**
     * Original signature : <code>l_int32* l_dnaGetIArray(L_DNA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:630</i>
     */
    public static Pointer<Integer> l_dnaGetIArray(Pointer<L_Dna> da) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaGetIArray(Pointer.getPeer(da)), Integer.class);
    }

    @Ptr
    protected native static long l_dnaGetIArray(@Ptr long da) throws LastError;

    /**
     * Original signature :
     * <code>l_float64* l_dnaGetDArray(L_DNA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:631</i>
     */
    public static Pointer<Double> l_dnaGetDArray(Pointer<L_Dna> da, int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaGetDArray(Pointer.getPeer(da), copyflag), Double.class);
    }

    @Ptr
    protected native static long l_dnaGetDArray(@Ptr long da, int copyflag) throws LastError;

    /**
     * Original signature : <code>l_int32 l_dnaGetRefcount(L_DNA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:632</i>
     */
    public static int l_dnaGetRefcount(Pointer<L_Dna> da) {
        return l_dnaGetRefcount(Pointer.getPeer(da));
    }

    protected native static int l_dnaGetRefcount(@Ptr long da) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_dnaChangeRefcount(L_DNA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:633</i>
     */
    public static int l_dnaChangeRefcount(Pointer<L_Dna> da, int delta) {
        return l_dnaChangeRefcount(Pointer.getPeer(da), delta);
    }

    protected native static int l_dnaChangeRefcount(@Ptr long da, int delta) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_dnaGetParameters(L_DNA*, l_float64*, l_float64*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:634</i>
     */
    public static int l_dnaGetParameters(Pointer<L_Dna> da,
            Pointer<Double> pstartx, Pointer<Double> pdelx) {
        return l_dnaGetParameters(Pointer.getPeer(da),
                Pointer.getPeer(pstartx), Pointer.getPeer(pdelx));
    }

    protected native static int l_dnaGetParameters(@Ptr long da,
            @Ptr long pstartx, @Ptr long pdelx);

    /**
     * Original signature :
     * <code>l_int32 l_dnaSetParameters(L_DNA*, l_float64, l_float64)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:635</i>
     */
    public static int l_dnaSetParameters(Pointer<L_Dna> da, double startx,
            double delx) {
        return l_dnaSetParameters(Pointer.getPeer(da), startx, delx);
    }

    protected native static int l_dnaSetParameters(@Ptr long da, double startx,
            double delx);

    /**
     * Original signature :
     * <code>l_int32 l_dnaCopyParameters(L_DNA*, L_DNA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:636</i>
     */
    public static int l_dnaCopyParameters(Pointer<L_Dna> dad, Pointer<L_Dna> das) {
        return l_dnaCopyParameters(Pointer.getPeer(dad), Pointer.getPeer(das));
    }

    protected native static int l_dnaCopyParameters(@Ptr long dad, @Ptr long das) throws LastError;

    /**
     * Original signature : <code>L_DNA* l_dnaRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:637</i>
     */
    public static Pointer<L_Dna> l_dnaRead(Pointer<Byte> filename) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaRead(Pointer.getPeer(filename)), L_Dna.class);
    }

    @Ptr
    protected native static long l_dnaRead(@Ptr long filename) throws LastError;

    /**
     * Original signature : <code>L_DNA* l_dnaReadStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:638</i>
     */
    public static Pointer<L_Dna> l_dnaReadStream(
            Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaReadStream(Pointer.getPeer(fp)), L_Dna.class);
    }

    @Ptr
    protected native static long l_dnaReadStream(@Ptr long fp) throws LastError;

    /**
     * Original signature : <code>l_int32 l_dnaWrite(const char*, L_DNA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:639</i>
     */
    public static int l_dnaWrite(Pointer<Byte> filename, Pointer<L_Dna> da) {
        return l_dnaWrite(Pointer.getPeer(filename), Pointer.getPeer(da));
    }

    protected native static int l_dnaWrite(@Ptr long filename, @Ptr long da) throws LastError;

    /**
     * Original signature : <code>l_int32 l_dnaWriteStream(FILE*, L_DNA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:640</i>
     */
    public static int l_dnaWriteStream(Pointer<FILE> fp,
            Pointer<L_Dna> da) {
        return l_dnaWriteStream(Pointer.getPeer(fp), Pointer.getPeer(da));
    }

    protected native static int l_dnaWriteStream(@Ptr long fp, @Ptr long da) throws LastError;

    /**
     * Original signature : <code>L_DNAA* l_dnaaCreate(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:641</i>
     */
    public static Pointer<L_Dnaa> l_dnaaCreate(int n) {
        return (Pointer) Pointer.pointerToAddress(l_dnaaCreate$2(n),
                L_Dnaa.class);
    }

    @Ptr
    @Name("l_dnaaCreate")
    protected native static long l_dnaaCreate$2(int n) throws LastError;

    /**
     * Original signature : <code>void l_dnaaDestroy(L_DNAA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:642</i>
     */
    public static void l_dnaaDestroy(Pointer<Pointer<L_Dnaa>> pdaa) {
        l_dnaaDestroy(Pointer.getPeer(pdaa));
    }

    protected native static void l_dnaaDestroy(@Ptr long pdaa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_dnaaAddDna(L_DNAA*, L_DNA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:643</i>
     */
    public static int l_dnaaAddDna(Pointer<L_Dnaa> daa, Pointer<L_Dna> da,
            int copyflag) {
        return l_dnaaAddDna(Pointer.getPeer(daa), Pointer.getPeer(da), copyflag);
    }

    protected native static int l_dnaaAddDna(@Ptr long daa, @Ptr long da,
            int copyflag);

    /**
     * Original signature : <code>l_int32 l_dnaaGetCount(L_DNAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:644</i>
     */
    public static int l_dnaaGetCount(Pointer<L_Dnaa> daa) {
        return l_dnaaGetCount(Pointer.getPeer(daa));
    }

    protected native static int l_dnaaGetCount(@Ptr long daa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_dnaaGetDnaCount(L_DNAA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:645</i>
     */
    public static int l_dnaaGetDnaCount(Pointer<L_Dnaa> daa, int index) {
        return l_dnaaGetDnaCount(Pointer.getPeer(daa), index);
    }

    protected native static int l_dnaaGetDnaCount(@Ptr long daa, int index) throws LastError;

    /**
     * Original signature : <code>l_int32 l_dnaaGetNumberCount(L_DNAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:646</i>
     */
    public static int l_dnaaGetNumberCount(Pointer<L_Dnaa> daa) {
        return l_dnaaGetNumberCount(Pointer.getPeer(daa));
    }

    protected native static int l_dnaaGetNumberCount(@Ptr long daa) throws LastError;

    /**
     * Original signature :
     * <code>L_DNA* l_dnaaGetDna(L_DNAA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:647</i>
     */
    public static Pointer<L_Dna> l_dnaaGetDna(Pointer<L_Dnaa> daa, int index,
            int accessflag) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaaGetDna(Pointer.getPeer(daa), index, accessflag),
                L_Dna.class);
    }

    @Ptr
    protected native static long l_dnaaGetDna(@Ptr long daa, int index,
            int accessflag);

    /**
     * Original signature :
     * <code>l_int32 l_dnaaReplaceDna(L_DNAA*, l_int32, L_DNA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:648</i>
     */
    public static int l_dnaaReplaceDna(Pointer<L_Dnaa> daa, int index,
            Pointer<L_Dna> da) {
        return l_dnaaReplaceDna(Pointer.getPeer(daa), index,
                Pointer.getPeer(da));
    }

    protected native static int l_dnaaReplaceDna(@Ptr long daa, int index,
            @Ptr long da);

    /**
     * Original signature :
     * <code>l_int32 l_dnaaGetValue(L_DNAA*, l_int32, l_int32, l_float64*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:649</i>
     */
    public static int l_dnaaGetValue(Pointer<L_Dnaa> daa, int i, int j,
            Pointer<Double> pval) {
        return l_dnaaGetValue(Pointer.getPeer(daa), i, j, Pointer.getPeer(pval));
    }

    protected native static int l_dnaaGetValue(@Ptr long daa, int i, int j,
            @Ptr long pval);

    /**
     * Original signature :
     * <code>l_int32 l_dnaaAddNumber(L_DNAA*, l_int32, l_float64)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:650</i>
     */
    public static int l_dnaaAddNumber(Pointer<L_Dnaa> daa, int index, double val) {
        return l_dnaaAddNumber(Pointer.getPeer(daa), index, val);
    }

    protected native static int l_dnaaAddNumber(@Ptr long daa, int index,
            double val);

    /**
     * Original signature : <code>L_DNAA* l_dnaaRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:651</i>
     */
    public static Pointer<L_Dnaa> l_dnaaRead(Pointer<Byte> filename) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaaRead(Pointer.getPeer(filename)), L_Dnaa.class);
    }

    @Ptr
    protected native static long l_dnaaRead(@Ptr long filename) throws LastError;

    /**
     * Original signature : <code>L_DNAA* l_dnaaReadStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:652</i>
     */
    public static Pointer<L_Dnaa> l_dnaaReadStream(
            Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaaReadStream(Pointer.getPeer(fp)), L_Dnaa.class);
    }

    @Ptr
    protected native static long l_dnaaReadStream(@Ptr long fp) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_dnaaWrite(const char*, L_DNAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:653</i>
     */
    public static int l_dnaaWrite(Pointer<Byte> filename, Pointer<L_Dnaa> daa) {
        return l_dnaaWrite(Pointer.getPeer(filename), Pointer.getPeer(daa));
    }

    protected native static int l_dnaaWrite(@Ptr long filename, @Ptr long daa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_dnaaWriteStream(FILE*, L_DNAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:654</i>
     */
    public static int l_dnaaWriteStream(Pointer<FILE> fp,
            Pointer<L_Dnaa> daa) {
        return l_dnaaWriteStream(Pointer.getPeer(fp), Pointer.getPeer(daa));
    }

    protected native static int l_dnaaWriteStream(@Ptr long fp, @Ptr long daa) throws LastError;

    /**
     * Original signature : <code>L_DNA* l_dnaMakeDelta(L_DNA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:655</i>
     */
    public static Pointer<L_Dna> l_dnaMakeDelta(Pointer<L_Dna> das) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaMakeDelta(Pointer.getPeer(das)), L_Dna.class);
    }

    @Ptr
    protected native static long l_dnaMakeDelta(@Ptr long das) throws LastError;

    /**
     * Original signature : <code>NUMA* l_dnaConvertToNuma(L_DNA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:656</i>
     */
    public static Pointer<Numa> l_dnaConvertToNuma(Pointer<L_Dna> da) {
        return (Pointer) Pointer.pointerToAddress(
                l_dnaConvertToNuma(Pointer.getPeer(da)), Numa.class);
    }

    @Ptr
    protected native static long l_dnaConvertToNuma(@Ptr long da) throws LastError;

    /**
     * Original signature : <code>L_DNA* numaConvertToDna(NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:657</i>
     */
    public static Pointer<L_Dna> numaConvertToDna(Pointer<Numa> na) {
        return (Pointer) Pointer.pointerToAddress(
                numaConvertToDna(Pointer.getPeer(na)), L_Dna.class);
    }

    @Ptr
    protected native static long numaConvertToDna(@Ptr long na) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 l_dnaJoin(L_DNA*, L_DNA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:658</i>
     */
    public static int l_dnaJoin(Pointer<L_Dna> dad, Pointer<L_Dna> das,
            int istart, int iend) {
        return l_dnaJoin(Pointer.getPeer(dad), Pointer.getPeer(das), istart,
                iend);
    }

    protected native static int l_dnaJoin(@Ptr long dad, @Ptr long das,
            int istart, int iend);

    /**
     * Original signature :
     * <code>PIX* pixMorphDwa_2(PIX*, PIX*, l_int32, char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:659</i>
     */
    public static Pointer<Pix> pixMorphDwa_2(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int operation, Pointer<Byte> selname) {
        return (Pointer) Pointer.pointerToAddress(
                pixMorphDwa_2(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        operation, Pointer.getPeer(selname)), Pix.class);
    }

    @Ptr
    protected native static long pixMorphDwa_2(@Ptr long pixd, @Ptr long pixs,
            int operation, @Ptr long selname);

    /**
     * Original signature :
     * <code>PIX* pixFMorphopGen_2(PIX*, PIX*, l_int32, char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:660</i>
     */
    public static Pointer<Pix> pixFMorphopGen_2(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int operation, Pointer<Byte> selname) {
        return (Pointer) Pointer.pointerToAddress(
                pixFMorphopGen_2(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        operation, Pointer.getPeer(selname)), Pix.class);
    }

    @Ptr
    protected native static long pixFMorphopGen_2(@Ptr long pixd,
            @Ptr long pixs, int operation, @Ptr long selname);

    /**
     * Original signature :
     * <code>l_int32 fmorphopgen_low_2(l_uint32*, l_int32, l_int32, l_int32, l_uint32*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:661</i>
     */
    public static int fmorphopgen_low_2(Pointer<Integer> datad, int w, int h,
            int wpld, Pointer<Integer> datas, int wpls, int index) {
        return fmorphopgen_low_2(Pointer.getPeer(datad), w, h, wpld,
                Pointer.getPeer(datas), wpls, index);
    }

    protected native static int fmorphopgen_low_2(@Ptr long datad, int w,
            int h, int wpld, @Ptr long datas, int wpls, int index);

    /**
     * Original signature : <code>PIX* pixSobelEdgeFilter(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:662</i>
     */
    public static Pointer<Pix> pixSobelEdgeFilter(Pointer<Pix> pixs,
            int orientflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixSobelEdgeFilter(Pointer.getPeer(pixs), orientflag),
                Pix.class);
    }

    @Ptr
    protected native static long pixSobelEdgeFilter(@Ptr long pixs,
            int orientflag);

    /**
     * Original signature :
     * <code>PIX* pixTwoSidedEdgeFilter(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:663</i>
     */
    public static Pointer<Pix> pixTwoSidedEdgeFilter(Pointer<Pix> pixs,
            int orientflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixTwoSidedEdgeFilter(Pointer.getPeer(pixs), orientflag),
                Pix.class);
    }

    @Ptr
    protected native static long pixTwoSidedEdgeFilter(@Ptr long pixs,
            int orientflag);

    /**
     * Original signature :
     * <code>l_int32 pixMeasureEdgeSmoothness(PIX*, l_int32, l_int32, l_int32, l_float32*, l_float32*, l_float32*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:664</i>
     */
    public static int pixMeasureEdgeSmoothness(Pointer<Pix> pixs, int side,
            int minjump, int minreversal, Pointer<Float> pjpl,
            Pointer<Float> pjspl, Pointer<Float> prpl, Pointer<Byte> debugfile) {
        return pixMeasureEdgeSmoothness(Pointer.getPeer(pixs), side, minjump,
                minreversal, Pointer.getPeer(pjpl), Pointer.getPeer(pjspl),
                Pointer.getPeer(prpl), Pointer.getPeer(debugfile));
    }

    protected native static int pixMeasureEdgeSmoothness(@Ptr long pixs,
            int side, int minjump, int minreversal, @Ptr long pjpl,
            @Ptr long pjspl, @Ptr long prpl, @Ptr long debugfile);

    /**
     * Original signature :
     * <code>NUMA* pixGetEdgeProfile(PIX*, l_int32, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:665</i>
     */
    public static Pointer<Numa> pixGetEdgeProfile(Pointer<Pix> pixs, int side,
            Pointer<Byte> debugfile) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetEdgeProfile(Pointer.getPeer(pixs), side,
                        Pointer.getPeer(debugfile)), Numa.class);
    }

    @Ptr
    protected native static long pixGetEdgeProfile(@Ptr long pixs, int side,
            @Ptr long debugfile);

    /**
     * Original signature :
     * <code>l_int32 pixGetLastOffPixelInRun(PIX*, l_int32, l_int32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:666</i>
     */
    public static int pixGetLastOffPixelInRun(Pointer<Pix> pixs, int x, int y,
            int direction, Pointer<Integer> ploc) {
        return pixGetLastOffPixelInRun(Pointer.getPeer(pixs), x, y, direction,
                Pointer.getPeer(ploc));
    }

    protected native static int pixGetLastOffPixelInRun(@Ptr long pixs, int x,
            int y, int direction, @Ptr long ploc);

    /**
     * Original signature :
     * <code>l_int32 pixGetLastOnPixelInRun(PIX*, l_int32, l_int32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:667</i>
     */
    public static int pixGetLastOnPixelInRun(Pointer<Pix> pixs, int x, int y,
            int direction, Pointer<Integer> ploc) {
        return pixGetLastOnPixelInRun(Pointer.getPeer(pixs), x, y, direction,
                Pointer.getPeer(ploc));
    }

    protected native static int pixGetLastOnPixelInRun(@Ptr long pixs, int x,
            int y, int direction, @Ptr long ploc);

    /**
     * Original signature :
     * <code>PIX* pixGammaTRC(PIX*, PIX*, l_float32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:668</i>
     */
    public static Pointer<Pix> pixGammaTRC(Pointer<Pix> pixd,
            Pointer<Pix> pixs, float gamma, int minval, int maxval) {
        return (Pointer) Pointer.pointerToAddress(
                pixGammaTRC(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        gamma, minval, maxval), Pix.class);
    }

    @Ptr
    protected native static long pixGammaTRC(@Ptr long pixd, @Ptr long pixs,
            float gamma, int minval, int maxval);

    /**
     * Original signature :
     * <code>PIX* pixGammaTRCMasked(PIX*, PIX*, PIX*, l_float32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:669</i>
     */
    public static Pointer<Pix> pixGammaTRCMasked(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<Pix> pixm, float gamma, int minval,
            int maxval) {
        return (Pointer) Pointer.pointerToAddress(
                pixGammaTRCMasked(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        Pointer.getPeer(pixm), gamma, minval, maxval),
                Pix.class);
    }

    @Ptr
    protected native static long pixGammaTRCMasked(@Ptr long pixd,
            @Ptr long pixs, @Ptr long pixm, float gamma, int minval, int maxval);

    /**
     * Original signature :
     * <code>PIX* pixGammaTRCWithAlpha(PIX*, PIX*, l_float32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:670</i>
     */
    public static Pointer<Pix> pixGammaTRCWithAlpha(Pointer<Pix> pixd,
            Pointer<Pix> pixs, float gamma, int minval, int maxval) {
        return (Pointer) Pointer.pointerToAddress(
                pixGammaTRCWithAlpha(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), gamma, minval, maxval),
                Pix.class);
    }

    @Ptr
    protected native static long pixGammaTRCWithAlpha(@Ptr long pixd,
            @Ptr long pixs, float gamma, int minval, int maxval);

    /**
     * Original signature :
     * <code>NUMA* numaGammaTRC(l_float32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:671</i>
     */
    public static Pointer<Numa> numaGammaTRC(float gamma, int minval, int maxval) {
        return (Pointer) Pointer.pointerToAddress(
                numaGammaTRC$2(gamma, minval, maxval), Numa.class);
    }

    @Ptr
    @Name("numaGammaTRC")
    protected native static long numaGammaTRC$2(float gamma, int minval,
            int maxval);

    /**
     * Original signature :
     * <code>PIX* pixContrastTRC(PIX*, PIX*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:672</i>
     */
    public static Pointer<Pix> pixContrastTRC(Pointer<Pix> pixd,
            Pointer<Pix> pixs, float factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixContrastTRC(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        factor), Pix.class);
    }

    @Ptr
    protected native static long pixContrastTRC(@Ptr long pixd, @Ptr long pixs,
            float factor);

    /**
     * Original signature :
     * <code>PIX* pixContrastTRCMasked(PIX*, PIX*, PIX*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:673</i>
     */
    public static Pointer<Pix> pixContrastTRCMasked(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<Pix> pixm, float factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixContrastTRCMasked(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), Pointer.getPeer(pixm), factor),
                Pix.class);
    }

    @Ptr
    protected native static long pixContrastTRCMasked(@Ptr long pixd,
            @Ptr long pixs, @Ptr long pixm, float factor);

    /**
     * Original signature : <code>NUMA* numaContrastTRC(l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:674</i>
     */
    public static Pointer<Numa> numaContrastTRC(float factor) {
        return (Pointer) Pointer.pointerToAddress(numaContrastTRC$2(factor),
                Numa.class);
    }

    @Ptr
    @Name("numaContrastTRC")
    protected native static long numaContrastTRC$2(float factor) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixEqualizeTRC(PIX*, PIX*, l_float32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:675</i>
     */
    public static Pointer<Pix> pixEqualizeTRC(Pointer<Pix> pixd,
            Pointer<Pix> pixs, float fract, int factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixEqualizeTRC(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        fract, factor), Pix.class);
    }

    @Ptr
    protected native static long pixEqualizeTRC(@Ptr long pixd, @Ptr long pixs,
            float fract, int factor);

    /**
     * Original signature :
     * <code>NUMA* numaEqualizeTRC(PIX*, l_float32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:676</i>
     */
    public static Pointer<Numa> numaEqualizeTRC(Pointer<Pix> pix, float fract,
            int factor) {
        return (Pointer) Pointer.pointerToAddress(
                numaEqualizeTRC(Pointer.getPeer(pix), fract, factor),
                Numa.class);
    }

    @Ptr
    protected native static long numaEqualizeTRC(@Ptr long pix, float fract,
            int factor);

    /**
     * Original signature : <code>l_int32 pixTRCMap(PIX*, PIX*, NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:677</i>
     */
    public static int pixTRCMap(Pointer<Pix> pixs, Pointer<Pix> pixm,
            Pointer<Numa> na) {
        return pixTRCMap(Pointer.getPeer(pixs), Pointer.getPeer(pixm),
                Pointer.getPeer(na));
    }

    protected native static int pixTRCMap(@Ptr long pixs, @Ptr long pixm,
            @Ptr long na);

    /**
     * Original signature :
     * <code>PIX* pixUnsharpMasking(PIX*, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:678</i>
     */
    public static Pointer<Pix> pixUnsharpMasking(Pointer<Pix> pixs,
            int halfwidth, float fract) {
        return (Pointer) Pointer.pointerToAddress(
                pixUnsharpMasking(Pointer.getPeer(pixs), halfwidth, fract),
                Pix.class);
    }

    @Ptr
    protected native static long pixUnsharpMasking(@Ptr long pixs,
            int halfwidth, float fract);

    /**
     * Original signature :
     * <code>PIX* pixUnsharpMaskingGray(PIX*, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:679</i>
     */
    public static Pointer<Pix> pixUnsharpMaskingGray(Pointer<Pix> pixs,
            int halfwidth, float fract) {
        return (Pointer) Pointer.pointerToAddress(
                pixUnsharpMaskingGray(Pointer.getPeer(pixs), halfwidth, fract),
                Pix.class);
    }

    @Ptr
    protected native static long pixUnsharpMaskingGray(@Ptr long pixs,
            int halfwidth, float fract);

    /**
     * Original signature :
     * <code>PIX* pixUnsharpMaskingFast(PIX*, l_int32, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:680</i>
     */
    public static Pointer<Pix> pixUnsharpMaskingFast(Pointer<Pix> pixs,
            int halfwidth, float fract, int direction) {
        return (Pointer) Pointer.pointerToAddress(
                pixUnsharpMaskingFast(Pointer.getPeer(pixs), halfwidth, fract,
                        direction), Pix.class);
    }

    @Ptr
    protected native static long pixUnsharpMaskingFast(@Ptr long pixs,
            int halfwidth, float fract, int direction);

    /**
     * Original signature :
     * <code>PIX* pixUnsharpMaskingGrayFast(PIX*, l_int32, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:681</i>
     */
    public static Pointer<Pix> pixUnsharpMaskingGrayFast(Pointer<Pix> pixs,
            int halfwidth, float fract, int direction) {
        return (Pointer) Pointer.pointerToAddress(
                pixUnsharpMaskingGrayFast(Pointer.getPeer(pixs), halfwidth,
                        fract, direction), Pix.class);
    }

    @Ptr
    protected native static long pixUnsharpMaskingGrayFast(@Ptr long pixs,
            int halfwidth, float fract, int direction);

    /**
     * Original signature :
     * <code>PIX* pixUnsharpMaskingGray1D(PIX*, l_int32, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:682</i>
     */
    public static Pointer<Pix> pixUnsharpMaskingGray1D(Pointer<Pix> pixs,
            int halfwidth, float fract, int direction) {
        return (Pointer) Pointer.pointerToAddress(
                pixUnsharpMaskingGray1D(Pointer.getPeer(pixs), halfwidth,
                        fract, direction), Pix.class);
    }

    @Ptr
    protected native static long pixUnsharpMaskingGray1D(@Ptr long pixs,
            int halfwidth, float fract, int direction);

    /**
     * Original signature :
     * <code>PIX* pixUnsharpMaskingGray2D(PIX*, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:683</i>
     */
    public static Pointer<Pix> pixUnsharpMaskingGray2D(Pointer<Pix> pixs,
            int halfwidth, float fract) {
        return (Pointer) Pointer.pointerToAddress(
                pixUnsharpMaskingGray2D(Pointer.getPeer(pixs), halfwidth, fract),
                Pix.class);
    }

    @Ptr
    protected native static long pixUnsharpMaskingGray2D(@Ptr long pixs,
            int halfwidth, float fract);

    /**
     * Original signature :
     * <code>PIX* pixModifyHue(PIX*, PIX*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:684</i>
     */
    public static Pointer<Pix> pixModifyHue(Pointer<Pix> pixd,
            Pointer<Pix> pixs, float fract) {
        return (Pointer) Pointer.pointerToAddress(
                pixModifyHue(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        fract), Pix.class);
    }

    @Ptr
    protected native static long pixModifyHue(@Ptr long pixd, @Ptr long pixs,
            float fract);

    /**
     * Original signature :
     * <code>PIX* pixModifySaturation(PIX*, PIX*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:685</i>
     */
    public static Pointer<Pix> pixModifySaturation(Pointer<Pix> pixd,
            Pointer<Pix> pixs, float fract) {
        return (Pointer) Pointer.pointerToAddress(
                pixModifySaturation(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), fract), Pix.class);
    }

    @Ptr
    protected native static long pixModifySaturation(@Ptr long pixd,
            @Ptr long pixs, float fract);

    /**
     * Original signature :
     * <code>l_int32 pixMeasureSaturation(PIX*, l_int32, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:686</i>
     */
    public static int pixMeasureSaturation(Pointer<Pix> pixs, int factor,
            Pointer<Float> psat) {
        return pixMeasureSaturation(Pointer.getPeer(pixs), factor,
                Pointer.getPeer(psat));
    }

    protected native static int pixMeasureSaturation(@Ptr long pixs,
            int factor, @Ptr long psat);

    /**
     * Original signature :
     * <code>PIX* pixModifyBrightness(PIX*, PIX*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:687</i>
     */
    public static Pointer<Pix> pixModifyBrightness(Pointer<Pix> pixd,
            Pointer<Pix> pixs, float fract) {
        return (Pointer) Pointer.pointerToAddress(
                pixModifyBrightness(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), fract), Pix.class);
    }

    @Ptr
    protected native static long pixModifyBrightness(@Ptr long pixd,
            @Ptr long pixs, float fract);

    /**
     * Original signature :
     * <code>PIX* pixColorShiftRGB(PIX*, l_float32, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:688</i>
     */
    public static Pointer<Pix> pixColorShiftRGB(Pointer<Pix> pixs,
            float rfract, float gfract, float bfract) {
        return (Pointer) Pointer.pointerToAddress(
                pixColorShiftRGB(Pointer.getPeer(pixs), rfract, gfract, bfract),
                Pix.class);
    }

    @Ptr
    protected native static long pixColorShiftRGB(@Ptr long pixs, float rfract,
            float gfract, float bfract);

    /**
     * Original signature :
     * <code>PIX* pixMultConstantColor(PIX*, l_float32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:689</i>
     */
    public static Pointer<Pix> pixMultConstantColor(Pointer<Pix> pixs,
            float rfact, float gfact, float bfact) {
        return (Pointer) Pointer.pointerToAddress(
                pixMultConstantColor(Pointer.getPeer(pixs), rfact, gfact, bfact),
                Pix.class);
    }

    @Ptr
    protected native static long pixMultConstantColor(@Ptr long pixs,
            float rfact, float gfact, float bfact);

    /**
     * Original signature :
     * <code>PIX* pixMultMatrixColor(PIX*, L_KERNEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:690</i>
     */
    public static Pointer<Pix> pixMultMatrixColor(Pointer<Pix> pixs,
            Pointer<L_Kernel> kel) {
        return (Pointer) Pointer.pointerToAddress(
                pixMultMatrixColor(Pointer.getPeer(pixs), Pointer.getPeer(kel)),
                Pix.class);
    }

    @Ptr
    protected native static long pixMultMatrixColor(@Ptr long pixs,
            @Ptr long kel);

    /**
     * Original signature :
     * <code>PIX* pixHalfEdgeByBandpass(PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:691</i>
     */
    public static Pointer<Pix> pixHalfEdgeByBandpass(Pointer<Pix> pixs,
            int sm1h, int sm1v, int sm2h, int sm2v) {
        return (Pointer) Pointer.pointerToAddress(
                pixHalfEdgeByBandpass(Pointer.getPeer(pixs), sm1h, sm1v, sm2h,
                        sm2v), Pix.class);
    }

    @Ptr
    protected native static long pixHalfEdgeByBandpass(@Ptr long pixs,
            int sm1h, int sm1v, int sm2h, int sm2v);

    /**
     * Original signature :
     * <code>l_int32 fhmtautogen(SELA*, l_int32, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:692</i>
     */
    public static int fhmtautogen(Pointer<Sela> sela, int fileindex,
            Pointer<Byte> filename) {
        return fhmtautogen(Pointer.getPeer(sela), fileindex,
                Pointer.getPeer(filename));
    }

    protected native static int fhmtautogen(@Ptr long sela, int fileindex,
            @Ptr long filename);

    /**
     * Original signature :
     * <code>l_int32 fhmtautogen1(SELA*, l_int32, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:693</i>
     */
    public static int fhmtautogen1(Pointer<Sela> sela, int fileindex,
            Pointer<Byte> filename) {
        return fhmtautogen1(Pointer.getPeer(sela), fileindex,
                Pointer.getPeer(filename));
    }

    protected native static int fhmtautogen1(@Ptr long sela, int fileindex,
            @Ptr long filename);

    /**
     * Original signature :
     * <code>l_int32 fhmtautogen2(SELA*, l_int32, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:694</i>
     */
    public static int fhmtautogen2(Pointer<Sela> sela, int fileindex,
            Pointer<Byte> filename) {
        return fhmtautogen2(Pointer.getPeer(sela), fileindex,
                Pointer.getPeer(filename));
    }

    protected native static int fhmtautogen2(@Ptr long sela, int fileindex,
            @Ptr long filename);

    /**
     * Original signature : <code>PIX* pixHMTDwa_1(PIX*, PIX*, char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:695</i>
     */
    public static Pointer<Pix> pixHMTDwa_1(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<Byte> selname) {
        return (Pointer) Pointer.pointerToAddress(
                pixHMTDwa_1(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        Pointer.getPeer(selname)), Pix.class);
    }

    @Ptr
    protected native static long pixHMTDwa_1(@Ptr long pixd, @Ptr long pixs,
            @Ptr long selname);

    /**
     * Original signature : <code>PIX* pixFHMTGen_1(PIX*, PIX*, char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:696</i>
     */
    public static Pointer<Pix> pixFHMTGen_1(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<Byte> selname) {
        return (Pointer) Pointer.pointerToAddress(
                pixFHMTGen_1(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        Pointer.getPeer(selname)), Pix.class);
    }

    @Ptr
    protected native static long pixFHMTGen_1(@Ptr long pixd, @Ptr long pixs,
            @Ptr long selname);

    /**
     * Original signature :
     * <code>l_int32 fhmtgen_low_1(l_uint32*, l_int32, l_int32, l_int32, l_uint32*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:697</i>
     */
    public static int fhmtgen_low_1(Pointer<Integer> datad, int w, int h,
            int wpld, Pointer<Integer> datas, int wpls, int index) {
        return fhmtgen_low_1(Pointer.getPeer(datad), w, h, wpld,
                Pointer.getPeer(datas), wpls, index);
    }

    protected native static int fhmtgen_low_1(@Ptr long datad, int w, int h,
            int wpld, @Ptr long datas, int wpls, int index);

    /**
     * Original signature :
     * <code>l_int32 pixItalicWords(PIX*, BOXA*, PIX*, BOXA**, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:698</i>
     */
    public static int pixItalicWords(Pointer<Pix> pixs, Pointer<Boxa> boxaw,
            Pointer<Pix> pixw, Pointer<Pointer<Boxa>> pboxa, int debugflag) {
        return pixItalicWords(Pointer.getPeer(pixs), Pointer.getPeer(boxaw),
                Pointer.getPeer(pixw), Pointer.getPeer(pboxa), debugflag);
    }

    protected native static int pixItalicWords(@Ptr long pixs, @Ptr long boxaw,
            @Ptr long pixw, @Ptr long pboxa, int debugflag);

    /**
     * Original signature :
     * <code>l_int32 pixOrientDetect(PIX*, l_float32*, l_float32*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:699</i>
     */
    public static int pixOrientDetect(Pointer<Pix> pixs,
            Pointer<Float> pupconf, Pointer<Float> pleftconf, int mincount,
            int debug) {
        return pixOrientDetect(Pointer.getPeer(pixs), Pointer.getPeer(pupconf),
                Pointer.getPeer(pleftconf), mincount, debug);
    }

    protected native static int pixOrientDetect(@Ptr long pixs,
            @Ptr long pupconf, @Ptr long pleftconf, int mincount, int debug);

    /**
     * Original signature :
     * <code>l_int32 makeOrientDecision(l_float32, l_float32, l_float32, l_float32, l_int32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:700</i>
     */
    public static int makeOrientDecision(float upconf, float leftconf,
            float minupconf, float minratio, Pointer<Integer> porient, int debug) {
        return makeOrientDecision(upconf, leftconf, minupconf, minratio,
                Pointer.getPeer(porient), debug);
    }

    protected native static int makeOrientDecision(float upconf,
            float leftconf, float minupconf, float minratio, @Ptr long porient,
            int debug);

    /**
     * Original signature :
     * <code>l_int32 pixUpDownDetect(PIX*, l_float32*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:701</i>
     */
    public static int pixUpDownDetect(Pointer<Pix> pixs, Pointer<Float> pconf,
            int mincount, int debug) {
        return pixUpDownDetect(Pointer.getPeer(pixs), Pointer.getPeer(pconf),
                mincount, debug);
    }

    protected native static int pixUpDownDetect(@Ptr long pixs,
            @Ptr long pconf, int mincount, int debug);

    /**
     * Original signature :
     * <code>l_int32 pixUpDownDetectGeneral(PIX*, l_float32*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:702</i>
     */
    public static int pixUpDownDetectGeneral(Pointer<Pix> pixs,
            Pointer<Float> pconf, int mincount, int npixels, int debug) {
        return pixUpDownDetectGeneral(Pointer.getPeer(pixs),
                Pointer.getPeer(pconf), mincount, npixels, debug);
    }

    protected native static int pixUpDownDetectGeneral(@Ptr long pixs,
            @Ptr long pconf, int mincount, int npixels, int debug);

    /**
     * Original signature :
     * <code>l_int32 pixOrientDetectDwa(PIX*, l_float32*, l_float32*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:703</i>
     */
    public static int pixOrientDetectDwa(Pointer<Pix> pixs,
            Pointer<Float> pupconf, Pointer<Float> pleftconf, int mincount,
            int debug) {
        return pixOrientDetectDwa(Pointer.getPeer(pixs),
                Pointer.getPeer(pupconf), Pointer.getPeer(pleftconf), mincount,
                debug);
    }

    protected native static int pixOrientDetectDwa(@Ptr long pixs,
            @Ptr long pupconf, @Ptr long pleftconf, int mincount, int debug);

    /**
     * Original signature :
     * <code>l_int32 pixUpDownDetectDwa(PIX*, l_float32*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:704</i>
     */
    public static int pixUpDownDetectDwa(Pointer<Pix> pixs,
            Pointer<Float> pconf, int mincount, int debug) {
        return pixUpDownDetectDwa(Pointer.getPeer(pixs),
                Pointer.getPeer(pconf), mincount, debug);
    }

    protected native static int pixUpDownDetectDwa(@Ptr long pixs,
            @Ptr long pconf, int mincount, int debug);

    /**
     * Original signature :
     * <code>l_int32 pixUpDownDetectGeneralDwa(PIX*, l_float32*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:705</i>
     */
    public static int pixUpDownDetectGeneralDwa(Pointer<Pix> pixs,
            Pointer<Float> pconf, int mincount, int npixels, int debug) {
        return pixUpDownDetectGeneralDwa(Pointer.getPeer(pixs),
                Pointer.getPeer(pconf), mincount, npixels, debug);
    }

    protected native static int pixUpDownDetectGeneralDwa(@Ptr long pixs,
            @Ptr long pconf, int mincount, int npixels, int debug);

    /**
     * Original signature :
     * <code>l_int32 pixMirrorDetect(PIX*, l_float32*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:706</i>
     */
    public static int pixMirrorDetect(Pointer<Pix> pixs, Pointer<Float> pconf,
            int mincount, int debug) {
        return pixMirrorDetect(Pointer.getPeer(pixs), Pointer.getPeer(pconf),
                mincount, debug);
    }

    protected native static int pixMirrorDetect(@Ptr long pixs,
            @Ptr long pconf, int mincount, int debug);

    /**
     * Original signature :
     * <code>l_int32 pixMirrorDetectDwa(PIX*, l_float32*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:707</i>
     */
    public static int pixMirrorDetectDwa(Pointer<Pix> pixs,
            Pointer<Float> pconf, int mincount, int debug) {
        return pixMirrorDetectDwa(Pointer.getPeer(pixs),
                Pointer.getPeer(pconf), mincount, debug);
    }

    protected native static int pixMirrorDetectDwa(@Ptr long pixs,
            @Ptr long pconf, int mincount, int debug);

    /**
     * Original signature : <code>PIX* pixFlipFHMTGen(PIX*, PIX*, char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:708</i>
     */
    public static Pointer<Pix> pixFlipFHMTGen(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<Byte> selname) {
        return (Pointer) Pointer.pointerToAddress(
                pixFlipFHMTGen(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        Pointer.getPeer(selname)), Pix.class);
    }

    @Ptr
    protected native static long pixFlipFHMTGen(@Ptr long pixd, @Ptr long pixs,
            @Ptr long selname);

    /**
     * Original signature :
     * <code>l_int32 fmorphautogen(SELA*, l_int32, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:709</i>
     */
    public static int fmorphautogen(Pointer<Sela> sela, int fileindex,
            Pointer<Byte> filename) {
        return fmorphautogen(Pointer.getPeer(sela), fileindex,
                Pointer.getPeer(filename));
    }

    protected native static int fmorphautogen(@Ptr long sela, int fileindex,
            @Ptr long filename);

    /**
     * Original signature :
     * <code>l_int32 fmorphautogen1(SELA*, l_int32, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:710</i>
     */
    public static int fmorphautogen1(Pointer<Sela> sela, int fileindex,
            Pointer<Byte> filename) {
        return fmorphautogen1(Pointer.getPeer(sela), fileindex,
                Pointer.getPeer(filename));
    }

    protected native static int fmorphautogen1(@Ptr long sela, int fileindex,
            @Ptr long filename);

    /**
     * Original signature :
     * <code>l_int32 fmorphautogen2(SELA*, l_int32, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:711</i>
     */
    public static int fmorphautogen2(Pointer<Sela> sela, int fileindex,
            Pointer<Byte> filename) {
        return fmorphautogen2(Pointer.getPeer(sela), fileindex,
                Pointer.getPeer(filename));
    }

    protected native static int fmorphautogen2(@Ptr long sela, int fileindex,
            @Ptr long filename);

    /**
     * Original signature :
     * <code>PIX* pixMorphDwa_1(PIX*, PIX*, l_int32, char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:712</i>
     */
    public static Pointer<Pix> pixMorphDwa_1(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int operation, Pointer<Byte> selname) {
        return (Pointer) Pointer.pointerToAddress(
                pixMorphDwa_1(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        operation, Pointer.getPeer(selname)), Pix.class);
    }

    @Ptr
    protected native static long pixMorphDwa_1(@Ptr long pixd, @Ptr long pixs,
            int operation, @Ptr long selname);

    /**
     * Original signature :
     * <code>PIX* pixFMorphopGen_1(PIX*, PIX*, l_int32, char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:713</i>
     */
    public static Pointer<Pix> pixFMorphopGen_1(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int operation, Pointer<Byte> selname) {
        return (Pointer) Pointer.pointerToAddress(
                pixFMorphopGen_1(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        operation, Pointer.getPeer(selname)), Pix.class);
    }

    @Ptr
    protected native static long pixFMorphopGen_1(@Ptr long pixd,
            @Ptr long pixs, int operation, @Ptr long selname);

    /**
     * Original signature :
     * <code>l_int32 fmorphopgen_low_1(l_uint32*, l_int32, l_int32, l_int32, l_uint32*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:714</i>
     */
    public static int fmorphopgen_low_1(Pointer<Integer> datad, int w, int h,
            int wpld, Pointer<Integer> datas, int wpls, int index) {
        return fmorphopgen_low_1(Pointer.getPeer(datad), w, h, wpld,
                Pointer.getPeer(datas), wpls, index);
    }

    protected native static int fmorphopgen_low_1(@Ptr long datad, int w,
            int h, int wpld, @Ptr long datas, int wpls, int index);

    /**
     * Original signature : <code>FPIX* fpixCreate(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:715</i>
     */
    public static Pointer<FPix> fpixCreate(int width, int height) {
        return (Pointer) Pointer.pointerToAddress(fpixCreate$2(width, height),
                FPix.class);
    }

    @Ptr
    @Name("fpixCreate")
    protected native static long fpixCreate$2(int width, int height) throws LastError;

    /**
     * Original signature : <code>FPIX* fpixCreateTemplate(FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:716</i>
     */
    public static Pointer<FPix> fpixCreateTemplate(Pointer<FPix> fpixs) {
        return (Pointer) Pointer.pointerToAddress(
                fpixCreateTemplate(Pointer.getPeer(fpixs)), FPix.class);
    }

    @Ptr
    protected native static long fpixCreateTemplate(@Ptr long fpixs) throws LastError;

    /**
     * Original signature : <code>FPIX* fpixClone(FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:717</i>
     */
    public static Pointer<FPix> fpixClone(Pointer<FPix> fpix) {
        return (Pointer) Pointer.pointerToAddress(
                fpixClone(Pointer.getPeer(fpix)), FPix.class);
    }

    @Ptr
    protected native static long fpixClone(@Ptr long fpix) throws LastError;

    /**
     * Original signature : <code>FPIX* fpixCopy(FPIX*, FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:718</i>
     */
    public static Pointer<FPix> fpixCopy(Pointer<FPix> fpixd,
            Pointer<FPix> fpixs) {
        return (Pointer) Pointer.pointerToAddress(
                fpixCopy(Pointer.getPeer(fpixd), Pointer.getPeer(fpixs)),
                FPix.class);
    }

    @Ptr
    protected native static long fpixCopy(@Ptr long fpixd, @Ptr long fpixs) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 fpixResizeImageData(FPIX*, FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:719</i>
     */
    public static int fpixResizeImageData(Pointer<FPix> fpixd,
            Pointer<FPix> fpixs) {
        return fpixResizeImageData(Pointer.getPeer(fpixd),
                Pointer.getPeer(fpixs));
    }

    protected native static int fpixResizeImageData(@Ptr long fpixd,
            @Ptr long fpixs);

    /**
     * Original signature : <code>void fpixDestroy(FPIX**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:720</i>
     */
    public static void fpixDestroy(Pointer<Pointer<FPix>> pfpix) {
        fpixDestroy(Pointer.getPeer(pfpix));
    }

    protected native static void fpixDestroy(@Ptr long pfpix) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 fpixGetDimensions(FPIX*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:721</i>
     */
    public static int fpixGetDimensions(Pointer<FPix> fpix,
            Pointer<Integer> pw, Pointer<Integer> ph) {
        return fpixGetDimensions(Pointer.getPeer(fpix), Pointer.getPeer(pw),
                Pointer.getPeer(ph));
    }

    protected native static int fpixGetDimensions(@Ptr long fpix, @Ptr long pw,
            @Ptr long ph);

    /**
     * Original signature :
     * <code>l_int32 fpixSetDimensions(FPIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:722</i>
     */
    public static int fpixSetDimensions(Pointer<FPix> fpix, int w, int h) {
        return fpixSetDimensions(Pointer.getPeer(fpix), w, h);
    }

    protected native static int fpixSetDimensions(@Ptr long fpix, int w, int h) throws LastError;

    /**
     * Original signature : <code>l_int32 fpixGetWpl(FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:723</i>
     */
    public static int fpixGetWpl(Pointer<FPix> fpix) {
        return fpixGetWpl(Pointer.getPeer(fpix));
    }

    protected native static int fpixGetWpl(@Ptr long fpix) throws LastError;

    /**
     * Original signature : <code>l_int32 fpixSetWpl(FPIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:724</i>
     */
    public static int fpixSetWpl(Pointer<FPix> fpix, int wpl) {
        return fpixSetWpl(Pointer.getPeer(fpix), wpl);
    }

    protected native static int fpixSetWpl(@Ptr long fpix, int wpl) throws LastError;

    /**
     * Original signature : <code>l_int32 fpixGetRefcount(FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:725</i>
     */
    public static int fpixGetRefcount(Pointer<FPix> fpix) {
        return fpixGetRefcount(Pointer.getPeer(fpix));
    }

    protected native static int fpixGetRefcount(@Ptr long fpix) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 fpixChangeRefcount(FPIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:726</i>
     */
    public static int fpixChangeRefcount(Pointer<FPix> fpix, int delta) {
        return fpixChangeRefcount(Pointer.getPeer(fpix), delta);
    }

    protected native static int fpixChangeRefcount(@Ptr long fpix, int delta) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 fpixGetResolution(FPIX*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:727</i>
     */
    public static int fpixGetResolution(Pointer<FPix> fpix,
            Pointer<Integer> pxres, Pointer<Integer> pyres) {
        return fpixGetResolution(Pointer.getPeer(fpix), Pointer.getPeer(pxres),
                Pointer.getPeer(pyres));
    }

    protected native static int fpixGetResolution(@Ptr long fpix,
            @Ptr long pxres, @Ptr long pyres);

    /**
     * Original signature :
     * <code>l_int32 fpixSetResolution(FPIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:728</i>
     */
    public static int fpixSetResolution(Pointer<FPix> fpix, int xres, int yres) {
        return fpixSetResolution(Pointer.getPeer(fpix), xres, yres);
    }

    protected native static int fpixSetResolution(@Ptr long fpix, int xres,
            int yres);

    /**
     * Original signature :
     * <code>l_int32 fpixCopyResolution(FPIX*, FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:729</i>
     */
    public static int fpixCopyResolution(Pointer<FPix> fpixd,
            Pointer<FPix> fpixs) {
        return fpixCopyResolution(Pointer.getPeer(fpixd),
                Pointer.getPeer(fpixs));
    }

    protected native static int fpixCopyResolution(@Ptr long fpixd,
            @Ptr long fpixs);

    /**
     * Original signature : <code>l_float32* fpixGetData(FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:730</i>
     */
    public static Pointer<Float> fpixGetData(Pointer<FPix> fpix) {
        return (Pointer) Pointer.pointerToAddress(
                fpixGetData(Pointer.getPeer(fpix)), Float.class);
    }

    @Ptr
    protected native static long fpixGetData(@Ptr long fpix) throws LastError;

    /**
     * Original signature : <code>l_int32 fpixSetData(FPIX*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:731</i>
     */
    public static int fpixSetData(Pointer<FPix> fpix, Pointer<Float> data) {
        return fpixSetData(Pointer.getPeer(fpix), Pointer.getPeer(data));
    }

    protected native static int fpixSetData(@Ptr long fpix, @Ptr long data) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 fpixGetPixel(FPIX*, l_int32, l_int32, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:732</i>
     */
    public static int fpixGetPixel(Pointer<FPix> fpix, int x, int y,
            Pointer<Float> pval) {
        return fpixGetPixel(Pointer.getPeer(fpix), x, y, Pointer.getPeer(pval));
    }

    protected native static int fpixGetPixel(@Ptr long fpix, int x, int y,
            @Ptr long pval);

    /**
     * Original signature :
     * <code>l_int32 fpixSetPixel(FPIX*, l_int32, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:733</i>
     */
    public static int fpixSetPixel(Pointer<FPix> fpix, int x, int y, float val) {
        return fpixSetPixel(Pointer.getPeer(fpix), x, y, val);
    }

    protected native static int fpixSetPixel(@Ptr long fpix, int x, int y,
            float val);

    /**
     * Original signature : <code>FPIXA* fpixaCreate(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:734</i>
     */
    public static Pointer<FPixa> fpixaCreate(int n) {
        return (Pointer) Pointer.pointerToAddress(fpixaCreate$2(n), FPixa.class);
    }

    @Ptr
    @Name("fpixaCreate")
    protected native static long fpixaCreate$2(int n) throws LastError;

    /**
     * Original signature : <code>FPIXA* fpixaCopy(FPIXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:735</i>
     */
    public static Pointer<FPixa> fpixaCopy(Pointer<FPixa> fpixa, int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                fpixaCopy(Pointer.getPeer(fpixa), copyflag), FPixa.class);
    }

    @Ptr
    protected native static long fpixaCopy(@Ptr long fpixa, int copyflag) throws LastError;

    /**
     * Original signature : <code>void fpixaDestroy(FPIXA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:736</i>
     */
    public static void fpixaDestroy(Pointer<Pointer<FPixa>> pfpixa) {
        fpixaDestroy(Pointer.getPeer(pfpixa));
    }

    protected native static void fpixaDestroy(@Ptr long pfpixa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 fpixaAddFPix(FPIXA*, FPIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:737</i>
     */
    public static int fpixaAddFPix(Pointer<FPixa> fpixa, Pointer<FPix> fpix,
            int copyflag) {
        return fpixaAddFPix(Pointer.getPeer(fpixa), Pointer.getPeer(fpix),
                copyflag);
    }

    protected native static int fpixaAddFPix(@Ptr long fpixa, @Ptr long fpix,
            int copyflag);

    /**
     * Original signature : <code>l_int32 fpixaGetCount(FPIXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:738</i>
     */
    public static int fpixaGetCount(Pointer<FPixa> fpixa) {
        return fpixaGetCount(Pointer.getPeer(fpixa));
    }

    protected native static int fpixaGetCount(@Ptr long fpixa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 fpixaChangeRefcount(FPIXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:739</i>
     */
    public static int fpixaChangeRefcount(Pointer<FPixa> fpixa, int delta) {
        return fpixaChangeRefcount(Pointer.getPeer(fpixa), delta);
    }

    protected native static int fpixaChangeRefcount(@Ptr long fpixa, int delta) throws LastError;

    /**
     * Original signature :
     * <code>FPIX* fpixaGetFPix(FPIXA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:740</i>
     */
    public static Pointer<FPix> fpixaGetFPix(Pointer<FPixa> fpixa, int index,
            int accesstype) {
        return (Pointer) Pointer.pointerToAddress(
                fpixaGetFPix(Pointer.getPeer(fpixa), index, accesstype),
                FPix.class);
    }

    @Ptr
    protected native static long fpixaGetFPix(@Ptr long fpixa, int index,
            int accesstype);

    /**
     * Original signature :
     * <code>l_int32 fpixaGetFPixDimensions(FPIXA*, l_int32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:741</i>
     */
    public static int fpixaGetFPixDimensions(Pointer<FPixa> fpixa, int index,
            Pointer<Integer> pw, Pointer<Integer> ph) {
        return fpixaGetFPixDimensions(Pointer.getPeer(fpixa), index,
                Pointer.getPeer(pw), Pointer.getPeer(ph));
    }

    protected native static int fpixaGetFPixDimensions(@Ptr long fpixa,
            int index, @Ptr long pw, @Ptr long ph);

    /**
     * Original signature :
     * <code>l_int32 fpixaGetPixel(FPIXA*, l_int32, l_int32, l_int32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:742</i>
     */
    public static int fpixaGetPixel(Pointer<FPixa> fpixa, int index, int x,
            int y, Pointer<Float> pval) {
        return fpixaGetPixel(Pointer.getPeer(fpixa), index, x, y,
                Pointer.getPeer(pval));
    }

    protected native static int fpixaGetPixel(@Ptr long fpixa, int index,
            int x, int y, @Ptr long pval);

    /**
     * Original signature :
     * <code>l_int32 fpixaSetPixel(FPIXA*, l_int32, l_int32, l_int32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:743</i>
     */
    public static int fpixaSetPixel(Pointer<FPixa> fpixa, int index, int x,
            int y, float val) {
        return fpixaSetPixel(Pointer.getPeer(fpixa), index, x, y, val);
    }

    protected native static int fpixaSetPixel(@Ptr long fpixa, int index,
            int x, int y, float val);

    /**
     * Original signature : <code>DPIX* dpixCreate(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:744</i>
     */
    public static Pointer<DPix> dpixCreate(int width, int height) {
        return (Pointer) Pointer.pointerToAddress(dpixCreate$2(width, height),
                DPix.class);
    }

    @Ptr
    @Name("dpixCreate")
    protected native static long dpixCreate$2(int width, int height) throws LastError;

    /**
     * Original signature : <code>DPIX* dpixCreateTemplate(DPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:745</i>
     */
    public static Pointer<DPix> dpixCreateTemplate(Pointer<DPix> dpixs) {
        return (Pointer) Pointer.pointerToAddress(
                dpixCreateTemplate(Pointer.getPeer(dpixs)), DPix.class);
    }

    @Ptr
    protected native static long dpixCreateTemplate(@Ptr long dpixs) throws LastError;

    /**
     * Original signature : <code>DPIX* dpixClone(DPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:746</i>
     */
    public static Pointer<DPix> dpixClone(Pointer<DPix> dpix) {
        return (Pointer) Pointer.pointerToAddress(
                dpixClone(Pointer.getPeer(dpix)), DPix.class);
    }

    @Ptr
    protected native static long dpixClone(@Ptr long dpix) throws LastError;

    /**
     * Original signature : <code>DPIX* dpixCopy(DPIX*, DPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:747</i>
     */
    public static Pointer<DPix> dpixCopy(Pointer<DPix> dpixd,
            Pointer<DPix> dpixs) {
        return (Pointer) Pointer.pointerToAddress(
                dpixCopy(Pointer.getPeer(dpixd), Pointer.getPeer(dpixs)),
                DPix.class);
    }

    @Ptr
    protected native static long dpixCopy(@Ptr long dpixd, @Ptr long dpixs) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dpixResizeImageData(DPIX*, DPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:748</i>
     */
    public static int dpixResizeImageData(Pointer<DPix> dpixd,
            Pointer<DPix> dpixs) {
        return dpixResizeImageData(Pointer.getPeer(dpixd),
                Pointer.getPeer(dpixs));
    }

    protected native static int dpixResizeImageData(@Ptr long dpixd,
            @Ptr long dpixs);

    /**
     * Original signature : <code>void dpixDestroy(DPIX**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:749</i>
     */
    public static void dpixDestroy(Pointer<Pointer<DPix>> pdpix) {
        dpixDestroy(Pointer.getPeer(pdpix));
    }

    protected native static void dpixDestroy(@Ptr long pdpix) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dpixGetDimensions(DPIX*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:750</i>
     */
    public static int dpixGetDimensions(Pointer<DPix> dpix,
            Pointer<Integer> pw, Pointer<Integer> ph) {
        return dpixGetDimensions(Pointer.getPeer(dpix), Pointer.getPeer(pw),
                Pointer.getPeer(ph));
    }

    protected native static int dpixGetDimensions(@Ptr long dpix, @Ptr long pw,
            @Ptr long ph);

    /**
     * Original signature :
     * <code>l_int32 dpixSetDimensions(DPIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:751</i>
     */
    public static int dpixSetDimensions(Pointer<DPix> dpix, int w, int h) {
        return dpixSetDimensions(Pointer.getPeer(dpix), w, h);
    }

    protected native static int dpixSetDimensions(@Ptr long dpix, int w, int h) throws LastError;

    /**
     * Original signature : <code>l_int32 dpixGetWpl(DPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:752</i>
     */
    public static int dpixGetWpl(Pointer<DPix> dpix) {
        return dpixGetWpl(Pointer.getPeer(dpix));
    }

    protected native static int dpixGetWpl(@Ptr long dpix) throws LastError;

    /**
     * Original signature : <code>l_int32 dpixSetWpl(DPIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:753</i>
     */
    public static int dpixSetWpl(Pointer<DPix> dpix, int wpl) {
        return dpixSetWpl(Pointer.getPeer(dpix), wpl);
    }

    protected native static int dpixSetWpl(@Ptr long dpix, int wpl) throws LastError;

    /**
     * Original signature : <code>l_int32 dpixGetRefcount(DPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:754</i>
     */
    public static int dpixGetRefcount(Pointer<DPix> dpix) {
        return dpixGetRefcount(Pointer.getPeer(dpix));
    }

    protected native static int dpixGetRefcount(@Ptr long dpix) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dpixChangeRefcount(DPIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:755</i>
     */
    public static int dpixChangeRefcount(Pointer<DPix> dpix, int delta) {
        return dpixChangeRefcount(Pointer.getPeer(dpix), delta);
    }

    protected native static int dpixChangeRefcount(@Ptr long dpix, int delta) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dpixGetResolution(DPIX*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:756</i>
     */
    public static int dpixGetResolution(Pointer<DPix> dpix,
            Pointer<Integer> pxres, Pointer<Integer> pyres) {
        return dpixGetResolution(Pointer.getPeer(dpix), Pointer.getPeer(pxres),
                Pointer.getPeer(pyres));
    }

    protected native static int dpixGetResolution(@Ptr long dpix,
            @Ptr long pxres, @Ptr long pyres);

    /**
     * Original signature :
     * <code>l_int32 dpixSetResolution(DPIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:757</i>
     */
    public static int dpixSetResolution(Pointer<DPix> dpix, int xres, int yres) {
        return dpixSetResolution(Pointer.getPeer(dpix), xres, yres);
    }

    protected native static int dpixSetResolution(@Ptr long dpix, int xres,
            int yres);

    /**
     * Original signature :
     * <code>l_int32 dpixCopyResolution(DPIX*, DPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:758</i>
     */
    public static int dpixCopyResolution(Pointer<DPix> dpixd,
            Pointer<DPix> dpixs) {
        return dpixCopyResolution(Pointer.getPeer(dpixd),
                Pointer.getPeer(dpixs));
    }

    protected native static int dpixCopyResolution(@Ptr long dpixd,
            @Ptr long dpixs);

    /**
     * Original signature : <code>l_float64* dpixGetData(DPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:759</i>
     */
    public static Pointer<Double> dpixGetData(Pointer<DPix> dpix) {
        return (Pointer) Pointer.pointerToAddress(
                dpixGetData(Pointer.getPeer(dpix)), Double.class);
    }

    @Ptr
    protected native static long dpixGetData(@Ptr long dpix) throws LastError;

    /**
     * Original signature : <code>l_int32 dpixSetData(DPIX*, l_float64*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:760</i>
     */
    public static int dpixSetData(Pointer<DPix> dpix, Pointer<Double> data) {
        return dpixSetData(Pointer.getPeer(dpix), Pointer.getPeer(data));
    }

    protected native static int dpixSetData(@Ptr long dpix, @Ptr long data) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dpixGetPixel(DPIX*, l_int32, l_int32, l_float64*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:761</i>
     */
    public static int dpixGetPixel(Pointer<DPix> dpix, int x, int y,
            Pointer<Double> pval) {
        return dpixGetPixel(Pointer.getPeer(dpix), x, y, Pointer.getPeer(pval));
    }

    protected native static int dpixGetPixel(@Ptr long dpix, int x, int y,
            @Ptr long pval);

    /**
     * Original signature :
     * <code>l_int32 dpixSetPixel(DPIX*, l_int32, l_int32, l_float64)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:762</i>
     */
    public static int dpixSetPixel(Pointer<DPix> dpix, int x, int y, double val) {
        return dpixSetPixel(Pointer.getPeer(dpix), x, y, val);
    }

    protected native static int dpixSetPixel(@Ptr long dpix, int x, int y,
            double val);

    /**
     * Original signature : <code>FPIX* fpixRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:763</i>
     */
    public static Pointer<FPix> fpixRead(Pointer<Byte> filename) {
        return (Pointer) Pointer.pointerToAddress(
                fpixRead(Pointer.getPeer(filename)), FPix.class);
    }

    @Ptr
    protected native static long fpixRead(@Ptr long filename) throws LastError;

    /**
     * Original signature : <code>FPIX* fpixReadStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:764</i>
     */
    public static Pointer<FPix> fpixReadStream(Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                fpixReadStream(Pointer.getPeer(fp)), FPix.class);
    }

    @Ptr
    protected native static long fpixReadStream(@Ptr long fp) throws LastError;

    /**
     * Original signature : <code>l_int32 fpixWrite(const char*, FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:765</i>
     */
    public static int fpixWrite(Pointer<Byte> filename, Pointer<FPix> fpix) {
        return fpixWrite(Pointer.getPeer(filename), Pointer.getPeer(fpix));
    }

    protected native static int fpixWrite(@Ptr long filename, @Ptr long fpix) throws LastError;

    /**
     * Original signature : <code>l_int32 fpixWriteStream(FILE*, FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:766</i>
     */
    public static int fpixWriteStream(Pointer<FILE> fp,
            Pointer<FPix> fpix) {
        return fpixWriteStream(Pointer.getPeer(fp), Pointer.getPeer(fpix));
    }

    protected native static int fpixWriteStream(@Ptr long fp, @Ptr long fpix) throws LastError;

    /**
     * Original signature : <code>FPIX* fpixEndianByteSwap(FPIX*, FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:767</i>
     */
    public static Pointer<FPix> fpixEndianByteSwap(Pointer<FPix> fpixd,
            Pointer<FPix> fpixs) {
        return (Pointer) Pointer.pointerToAddress(
                fpixEndianByteSwap(Pointer.getPeer(fpixd),
                        Pointer.getPeer(fpixs)), FPix.class);
    }

    @Ptr
    protected native static long fpixEndianByteSwap(@Ptr long fpixd,
            @Ptr long fpixs);

    /**
     * Original signature : <code>DPIX* dpixRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:768</i>
     */
    public static Pointer<DPix> dpixRead(Pointer<Byte> filename) {
        return (Pointer) Pointer.pointerToAddress(
                dpixRead(Pointer.getPeer(filename)), DPix.class);
    }

    @Ptr
    protected native static long dpixRead(@Ptr long filename) throws LastError;

    /**
     * Original signature : <code>DPIX* dpixReadStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:769</i>
     */
    public static Pointer<DPix> dpixReadStream(Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                dpixReadStream(Pointer.getPeer(fp)), DPix.class);
    }

    @Ptr
    protected native static long dpixReadStream(@Ptr long fp) throws LastError;

    /**
     * Original signature : <code>l_int32 dpixWrite(const char*, DPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:770</i>
     */
    public static int dpixWrite(Pointer<Byte> filename, Pointer<DPix> dpix) {
        return dpixWrite(Pointer.getPeer(filename), Pointer.getPeer(dpix));
    }

    protected native static int dpixWrite(@Ptr long filename, @Ptr long dpix) throws LastError;

    /**
     * Original signature : <code>l_int32 dpixWriteStream(FILE*, DPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:771</i>
     */
    public static int dpixWriteStream(Pointer<FILE> fp,
            Pointer<DPix> dpix) {
        return dpixWriteStream(Pointer.getPeer(fp), Pointer.getPeer(dpix));
    }

    protected native static int dpixWriteStream(@Ptr long fp, @Ptr long dpix) throws LastError;

    /**
     * Original signature : <code>DPIX* dpixEndianByteSwap(DPIX*, DPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:772</i>
     */
    public static Pointer<DPix> dpixEndianByteSwap(Pointer<DPix> dpixd,
            Pointer<DPix> dpixs) {
        return (Pointer) Pointer.pointerToAddress(
                dpixEndianByteSwap(Pointer.getPeer(dpixd),
                        Pointer.getPeer(dpixs)), DPix.class);
    }

    @Ptr
    protected native static long dpixEndianByteSwap(@Ptr long dpixd,
            @Ptr long dpixs);

    /**
     * Original signature :
     * <code>l_int32 fpixPrintStream(FILE*, FPIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:773</i>
     */
    public static int fpixPrintStream(Pointer<FILE> fp,
            Pointer<FPix> fpix, int factor) {
        return fpixPrintStream(Pointer.getPeer(fp), Pointer.getPeer(fpix),
                factor);
    }

    protected native static int fpixPrintStream(@Ptr long fp, @Ptr long fpix,
            int factor);

    /**
     * Original signature : <code>FPIX* pixConvertToFPix(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:774</i>
     */
    public static Pointer<FPix> pixConvertToFPix(Pointer<Pix> pixs, int ncomps) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvertToFPix(Pointer.getPeer(pixs), ncomps), FPix.class);
    }

    @Ptr
    protected native static long pixConvertToFPix(@Ptr long pixs, int ncomps) throws LastError;

    /**
     * Original signature : <code>DPIX* pixConvertToDPix(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:775</i>
     */
    public static Pointer<DPix> pixConvertToDPix(Pointer<Pix> pixs, int ncomps) {
        return (Pointer) Pointer.pointerToAddress(
                pixConvertToDPix(Pointer.getPeer(pixs), ncomps), DPix.class);
    }

    @Ptr
    protected native static long pixConvertToDPix(@Ptr long pixs, int ncomps) throws LastError;

    /**
     * Original signature :
     * <code>PIX* fpixConvertToPix(FPIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:776</i>
     */
    public static Pointer<Pix> fpixConvertToPix(Pointer<FPix> fpixs,
            int outdepth, int negvals, int errorflag) {
        return (Pointer) Pointer.pointerToAddress(
                fpixConvertToPix(Pointer.getPeer(fpixs), outdepth, negvals,
                        errorflag), Pix.class);
    }

    @Ptr
    protected native static long fpixConvertToPix(@Ptr long fpixs,
            int outdepth, int negvals, int errorflag);

    /**
     * Original signature : <code>PIX* fpixDisplayMaxDynamicRange(FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:777</i>
     */
    public static Pointer<Pix> fpixDisplayMaxDynamicRange(Pointer<FPix> fpixs) {
        return (Pointer) Pointer.pointerToAddress(
                fpixDisplayMaxDynamicRange(Pointer.getPeer(fpixs)), Pix.class);
    }

    @Ptr
    protected native static long fpixDisplayMaxDynamicRange(@Ptr long fpixs) throws LastError;

    /**
     * Original signature : <code>DPIX* fpixConvertToDPix(FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:778</i>
     */
    public static Pointer<DPix> fpixConvertToDPix(Pointer<FPix> fpix) {
        return (Pointer) Pointer.pointerToAddress(
                fpixConvertToDPix(Pointer.getPeer(fpix)), DPix.class);
    }

    @Ptr
    protected native static long fpixConvertToDPix(@Ptr long fpix) throws LastError;

    /**
     * Original signature :
     * <code>PIX* dpixConvertToPix(DPIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:779</i>
     */
    public static Pointer<Pix> dpixConvertToPix(Pointer<DPix> dpixs,
            int outdepth, int negvals, int errorflag) {
        return (Pointer) Pointer.pointerToAddress(
                dpixConvertToPix(Pointer.getPeer(dpixs), outdepth, negvals,
                        errorflag), Pix.class);
    }

    @Ptr
    protected native static long dpixConvertToPix(@Ptr long dpixs,
            int outdepth, int negvals, int errorflag);

    /**
     * Original signature : <code>FPIX* dpixConvertToFPix(DPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:780</i>
     */
    public static Pointer<FPix> dpixConvertToFPix(Pointer<DPix> dpix) {
        return (Pointer) Pointer.pointerToAddress(
                dpixConvertToFPix(Pointer.getPeer(dpix)), FPix.class);
    }

    @Ptr
    protected native static long dpixConvertToFPix(@Ptr long dpix) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 fpixGetMin(FPIX*, l_float32*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:781</i>
     */
    public static int fpixGetMin(Pointer<FPix> fpix, Pointer<Float> pminval,
            Pointer<Integer> pxminloc, Pointer<Integer> pyminloc) {
        return fpixGetMin(Pointer.getPeer(fpix), Pointer.getPeer(pminval),
                Pointer.getPeer(pxminloc), Pointer.getPeer(pyminloc));
    }

    protected native static int fpixGetMin(@Ptr long fpix, @Ptr long pminval,
            @Ptr long pxminloc, @Ptr long pyminloc);

    /**
     * Original signature :
     * <code>l_int32 fpixGetMax(FPIX*, l_float32*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:782</i>
     */
    public static int fpixGetMax(Pointer<FPix> fpix, Pointer<Float> pmaxval,
            Pointer<Integer> pxmaxloc, Pointer<Integer> pymaxloc) {
        return fpixGetMax(Pointer.getPeer(fpix), Pointer.getPeer(pmaxval),
                Pointer.getPeer(pxmaxloc), Pointer.getPeer(pymaxloc));
    }

    protected native static int fpixGetMax(@Ptr long fpix, @Ptr long pmaxval,
            @Ptr long pxmaxloc, @Ptr long pymaxloc);

    /**
     * Original signature :
     * <code>l_int32 dpixGetMin(DPIX*, l_float64*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:783</i>
     */
    public static int dpixGetMin(Pointer<DPix> dpix, Pointer<Double> pminval,
            Pointer<Integer> pxminloc, Pointer<Integer> pyminloc) {
        return dpixGetMin(Pointer.getPeer(dpix), Pointer.getPeer(pminval),
                Pointer.getPeer(pxminloc), Pointer.getPeer(pyminloc));
    }

    protected native static int dpixGetMin(@Ptr long dpix, @Ptr long pminval,
            @Ptr long pxminloc, @Ptr long pyminloc);

    /**
     * Original signature :
     * <code>l_int32 dpixGetMax(DPIX*, l_float64*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:784</i>
     */
    public static int dpixGetMax(Pointer<DPix> dpix, Pointer<Double> pmaxval,
            Pointer<Integer> pxmaxloc, Pointer<Integer> pymaxloc) {
        return dpixGetMax(Pointer.getPeer(dpix), Pointer.getPeer(pmaxval),
                Pointer.getPeer(pxmaxloc), Pointer.getPeer(pymaxloc));
    }

    protected native static int dpixGetMax(@Ptr long dpix, @Ptr long pmaxval,
            @Ptr long pxmaxloc, @Ptr long pymaxloc);

    /**
     * Original signature :
     * <code>FPIX* fpixScaleByInteger(FPIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:785</i>
     */
    public static Pointer<FPix> fpixScaleByInteger(Pointer<FPix> fpixs,
            int factor) {
        return (Pointer) Pointer.pointerToAddress(
                fpixScaleByInteger(Pointer.getPeer(fpixs), factor), FPix.class);
    }

    @Ptr
    protected native static long fpixScaleByInteger(@Ptr long fpixs, int factor) throws LastError;

    /**
     * Original signature :
     * <code>DPIX* dpixScaleByInteger(DPIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:786</i>
     */
    public static Pointer<DPix> dpixScaleByInteger(Pointer<DPix> dpixs,
            int factor) {
        return (Pointer) Pointer.pointerToAddress(
                dpixScaleByInteger(Pointer.getPeer(dpixs), factor), DPix.class);
    }

    @Ptr
    protected native static long dpixScaleByInteger(@Ptr long dpixs, int factor) throws LastError;

    /**
     * Original signature :
     * <code>FPIX* fpixLinearCombination(FPIX*, FPIX*, FPIX*, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:787</i>
     */
    public static Pointer<FPix> fpixLinearCombination(Pointer<FPix> fpixd,
            Pointer<FPix> fpixs1, Pointer<FPix> fpixs2, float a, float b) {
        return (Pointer) Pointer.pointerToAddress(
                fpixLinearCombination(Pointer.getPeer(fpixd),
                        Pointer.getPeer(fpixs1), Pointer.getPeer(fpixs2), a, b),
                FPix.class);
    }

    @Ptr
    protected native static long fpixLinearCombination(@Ptr long fpixd,
            @Ptr long fpixs1, @Ptr long fpixs2, float a, float b);

    /**
     * Original signature :
     * <code>l_int32 fpixAddMultConstant(FPIX*, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:788</i>
     */
    public static int fpixAddMultConstant(Pointer<FPix> fpix, float addc,
            float multc) {
        return fpixAddMultConstant(Pointer.getPeer(fpix), addc, multc);
    }

    protected native static int fpixAddMultConstant(@Ptr long fpix, float addc,
            float multc);

    /**
     * Original signature :
     * <code>DPIX* dpixLinearCombination(DPIX*, DPIX*, DPIX*, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:789</i>
     */
    public static Pointer<DPix> dpixLinearCombination(Pointer<DPix> dpixd,
            Pointer<DPix> dpixs1, Pointer<DPix> dpixs2, float a, float b) {
        return (Pointer) Pointer.pointerToAddress(
                dpixLinearCombination(Pointer.getPeer(dpixd),
                        Pointer.getPeer(dpixs1), Pointer.getPeer(dpixs2), a, b),
                DPix.class);
    }

    @Ptr
    protected native static long dpixLinearCombination(@Ptr long dpixd,
            @Ptr long dpixs1, @Ptr long dpixs2, float a, float b);

    /**
     * Original signature :
     * <code>l_int32 dpixAddMultConstant(DPIX*, l_float64, l_float64)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:790</i>
     */
    public static int dpixAddMultConstant(Pointer<DPix> dpix, double addc,
            double multc) {
        return dpixAddMultConstant(Pointer.getPeer(dpix), addc, multc);
    }

    protected native static int dpixAddMultConstant(@Ptr long dpix,
            double addc, double multc);

    /**
     * Original signature :
     * <code>l_int32 fpixSetAllArbitrary(FPIX*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:791</i>
     */
    public static int fpixSetAllArbitrary(Pointer<FPix> fpix, float inval) {
        return fpixSetAllArbitrary(Pointer.getPeer(fpix), inval);
    }

    protected native static int fpixSetAllArbitrary(@Ptr long fpix, float inval) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 dpixSetAllArbitrary(DPIX*, l_float64)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:792</i>
     */
    public static int dpixSetAllArbitrary(Pointer<DPix> dpix, double inval) {
        return dpixSetAllArbitrary(Pointer.getPeer(dpix), inval);
    }

    protected native static int dpixSetAllArbitrary(@Ptr long dpix, double inval) throws LastError;

    /**
     * Original signature :
     * <code>FPIX* fpixAddBorder(FPIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:793</i>
     */
    public static Pointer<FPix> fpixAddBorder(Pointer<FPix> fpixs, int left,
            int right, int top, int bot) {
        return (Pointer) Pointer.pointerToAddress(
                fpixAddBorder(Pointer.getPeer(fpixs), left, right, top, bot),
                FPix.class);
    }

    @Ptr
    protected native static long fpixAddBorder(@Ptr long fpixs, int left,
            int right, int top, int bot);

    /**
     * Original signature :
     * <code>FPIX* fpixRemoveBorder(FPIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:794</i>
     */
    public static Pointer<FPix> fpixRemoveBorder(Pointer<FPix> fpixs, int left,
            int right, int top, int bot) {
        return (Pointer) Pointer.pointerToAddress(
                fpixRemoveBorder(Pointer.getPeer(fpixs), left, right, top, bot),
                FPix.class);
    }

    @Ptr
    protected native static long fpixRemoveBorder(@Ptr long fpixs, int left,
            int right, int top, int bot);

    /**
     * Original signature :
     * <code>FPIX* fpixAddMirroredBorder(FPIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:795</i>
     */
    public static Pointer<FPix> fpixAddMirroredBorder(Pointer<FPix> fpixs,
            int left, int right, int top, int bot) {
        return (Pointer) Pointer.pointerToAddress(
                fpixAddMirroredBorder(Pointer.getPeer(fpixs), left, right, top,
                        bot), FPix.class);
    }

    @Ptr
    protected native static long fpixAddMirroredBorder(@Ptr long fpixs,
            int left, int right, int top, int bot);

    /**
     * Original signature :
     * <code>FPIX* fpixAddContinuedBorder(FPIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:796</i>
     */
    public static Pointer<FPix> fpixAddContinuedBorder(Pointer<FPix> fpixs,
            int left, int right, int top, int bot) {
        return (Pointer) Pointer.pointerToAddress(
                fpixAddContinuedBorder(Pointer.getPeer(fpixs), left, right,
                        top, bot), FPix.class);
    }

    @Ptr
    protected native static long fpixAddContinuedBorder(@Ptr long fpixs,
            int left, int right, int top, int bot);

    /**
     * Original signature :
     * <code>FPIX* fpixAddSlopeBorder(FPIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:797</i>
     */
    public static Pointer<FPix> fpixAddSlopeBorder(Pointer<FPix> fpixs,
            int left, int right, int top, int bot) {
        return (Pointer) Pointer.pointerToAddress(
                fpixAddSlopeBorder(Pointer.getPeer(fpixs), left, right, top,
                        bot), FPix.class);
    }

    @Ptr
    protected native static long fpixAddSlopeBorder(@Ptr long fpixs, int left,
            int right, int top, int bot);

    /**
     * Original signature :
     * <code>l_int32 fpixRasterop(FPIX*, l_int32, l_int32, l_int32, l_int32, FPIX*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:798</i>
     */
    public static int fpixRasterop(Pointer<FPix> fpixd, int dx, int dy, int dw,
            int dh, Pointer<FPix> fpixs, int sx, int sy) {
        return fpixRasterop(Pointer.getPeer(fpixd), dx, dy, dw, dh,
                Pointer.getPeer(fpixs), sx, sy);
    }

    protected native static int fpixRasterop(@Ptr long fpixd, int dx, int dy,
            int dw, int dh, @Ptr long fpixs, int sx, int sy);

    /**
     * Original signature : <code>FPIX* fpixRotateOrth(FPIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:799</i>
     */
    public static Pointer<FPix> fpixRotateOrth(Pointer<FPix> fpixs, int quads) {
        return (Pointer) Pointer.pointerToAddress(
                fpixRotateOrth(Pointer.getPeer(fpixs), quads), FPix.class);
    }

    @Ptr
    protected native static long fpixRotateOrth(@Ptr long fpixs, int quads) throws LastError;

    /**
     * Original signature : <code>FPIX* fpixRotate180(FPIX*, FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:800</i>
     */
    public static Pointer<FPix> fpixRotate180(Pointer<FPix> fpixd,
            Pointer<FPix> fpixs) {
        return (Pointer) Pointer.pointerToAddress(
                fpixRotate180(Pointer.getPeer(fpixd), Pointer.getPeer(fpixs)),
                FPix.class);
    }

    @Ptr
    protected native static long fpixRotate180(@Ptr long fpixd, @Ptr long fpixs) throws LastError;

    /**
     * Original signature : <code>FPIX* fpixRotate90(FPIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:801</i>
     */
    public static Pointer<FPix> fpixRotate90(Pointer<FPix> fpixs, int direction) {
        return (Pointer) Pointer.pointerToAddress(
                fpixRotate90(Pointer.getPeer(fpixs), direction), FPix.class);
    }

    @Ptr
    protected native static long fpixRotate90(@Ptr long fpixs, int direction) throws LastError;

    /**
     * Original signature : <code>FPIX* fpixFlipLR(FPIX*, FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:802</i>
     */
    public static Pointer<FPix> fpixFlipLR(Pointer<FPix> fpixd,
            Pointer<FPix> fpixs) {
        return (Pointer) Pointer.pointerToAddress(
                fpixFlipLR(Pointer.getPeer(fpixd), Pointer.getPeer(fpixs)),
                FPix.class);
    }

    @Ptr
    protected native static long fpixFlipLR(@Ptr long fpixd, @Ptr long fpixs) throws LastError;

    /**
     * Original signature : <code>FPIX* fpixFlipTB(FPIX*, FPIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:803</i>
     */
    public static Pointer<FPix> fpixFlipTB(Pointer<FPix> fpixd,
            Pointer<FPix> fpixs) {
        return (Pointer) Pointer.pointerToAddress(
                fpixFlipTB(Pointer.getPeer(fpixd), Pointer.getPeer(fpixs)),
                FPix.class);
    }

    @Ptr
    protected native static long fpixFlipTB(@Ptr long fpixd, @Ptr long fpixs) throws LastError;

    /**
     * Original signature :
     * <code>FPIX* fpixAffinePta(FPIX*, PTA*, PTA*, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:804</i>
     */
    public static Pointer<FPix> fpixAffinePta(Pointer<FPix> fpixs,
            Pointer<Pta> ptad, Pointer<Pta> ptas, int border, float inval) {
        return (Pointer) Pointer.pointerToAddress(
                fpixAffinePta(Pointer.getPeer(fpixs), Pointer.getPeer(ptad),
                        Pointer.getPeer(ptas), border, inval), FPix.class);
    }

    @Ptr
    protected native static long fpixAffinePta(@Ptr long fpixs, @Ptr long ptad,
            @Ptr long ptas, int border, float inval);

    /**
     * Original signature :
     * <code>FPIX* fpixAffine(FPIX*, l_float32*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:805</i>
     */
    public static Pointer<FPix> fpixAffine(Pointer<FPix> fpixs,
            Pointer<Float> vc, float inval) {
        return (Pointer) Pointer.pointerToAddress(
                fpixAffine(Pointer.getPeer(fpixs), Pointer.getPeer(vc), inval),
                FPix.class);
    }

    @Ptr
    protected native static long fpixAffine(@Ptr long fpixs, @Ptr long vc,
            float inval);

    /**
     * Original signature :
     * <code>FPIX* fpixProjectivePta(FPIX*, PTA*, PTA*, l_int32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:806</i>
     */
    public static Pointer<FPix> fpixProjectivePta(Pointer<FPix> fpixs,
            Pointer<Pta> ptad, Pointer<Pta> ptas, int border, float inval) {
        return (Pointer) Pointer.pointerToAddress(
                fpixProjectivePta(Pointer.getPeer(fpixs),
                        Pointer.getPeer(ptad), Pointer.getPeer(ptas), border,
                        inval), FPix.class);
    }

    @Ptr
    protected native static long fpixProjectivePta(@Ptr long fpixs,
            @Ptr long ptad, @Ptr long ptas, int border, float inval);

    /**
     * Original signature :
     * <code>FPIX* fpixProjective(FPIX*, l_float32*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:807</i>
     */
    public static Pointer<FPix> fpixProjective(Pointer<FPix> fpixs,
            Pointer<Float> vc, float inval) {
        return (Pointer) Pointer.pointerToAddress(
                fpixProjective(Pointer.getPeer(fpixs), Pointer.getPeer(vc),
                        inval), FPix.class);
    }

    @Ptr
    protected native static long fpixProjective(@Ptr long fpixs, @Ptr long vc,
            float inval);

    /**
     * Original signature :
     * <code>l_int32 linearInterpolatePixelFloat(l_float32*, l_int32, l_int32, l_float32, l_float32, l_float32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:808</i>
     */
    public static int linearInterpolatePixelFloat(Pointer<Float> datas, int w,
            int h, float x, float y, float inval, Pointer<Float> pval) {
        return linearInterpolatePixelFloat(Pointer.getPeer(datas), w, h, x, y,
                inval, Pointer.getPeer(pval));
    }

    protected native static int linearInterpolatePixelFloat(@Ptr long datas,
            int w, int h, float x, float y, float inval, @Ptr long pval);

    /**
     * Original signature :
     * <code>PIX* fpixThresholdToPix(FPIX*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:809</i>
     */
    public static Pointer<Pix> fpixThresholdToPix(Pointer<FPix> fpix,
            float thresh) {
        return (Pointer) Pointer.pointerToAddress(
                fpixThresholdToPix(Pointer.getPeer(fpix), thresh), Pix.class);
    }

    @Ptr
    protected native static long fpixThresholdToPix(@Ptr long fpix, float thresh) throws LastError;

    /**
     * Original signature :
     * <code>FPIX* pixComponentFunction(PIX*, l_float32, l_float32, l_float32, l_float32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:810</i>
     */
    public static Pointer<FPix> pixComponentFunction(Pointer<Pix> pix,
            float rnum, float gnum, float bnum, float rdenom, float gdenom,
            float bdenom) {
        return (Pointer) Pointer.pointerToAddress(
                pixComponentFunction(Pointer.getPeer(pix), rnum, gnum, bnum,
                        rdenom, gdenom, bdenom), FPix.class);
    }

    @Ptr
    protected native static long pixComponentFunction(@Ptr long pix,
            float rnum, float gnum, float bnum, float rdenom, float gdenom,
            float bdenom);

    /**
     * Original signature : <code>PIX* pixReadStreamGif(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:811</i>
     */
    public static Pointer<Pix> pixReadStreamGif(
            Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                pixReadStreamGif(Pointer.getPeer(fp)), Pix.class);
    }

    @Ptr
    protected native static long pixReadStreamGif(@Ptr long fp) throws LastError;

    /**
     * Original signature : <code>l_int32 pixWriteStreamGif(FILE*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:812</i>
     */
    public static int pixWriteStreamGif(Pointer<FILE> fp,
            Pointer<Pix> pix) {
        return pixWriteStreamGif(Pointer.getPeer(fp), Pointer.getPeer(pix));
    }

    protected native static int pixWriteStreamGif(@Ptr long fp, @Ptr long pix) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixReadMemGif(const l_uint8*, size_t)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:813</i>
     */
    public static Pointer<Pix> pixReadMemGif(Pointer<Byte> cdata, @Ptr long size) {
        return (Pointer) Pointer.pointerToAddress(
                pixReadMemGif(Pointer.getPeer(cdata), size), Pix.class);
    }

    @Ptr
    protected native static long pixReadMemGif(@Ptr long cdata, @Ptr long size) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixWriteMemGif(l_uint8**, size_t*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:814</i>
     */
    public static int pixWriteMemGif(Pointer<Pointer<Byte>> pdata,
            Pointer<SizeT> psize, Pointer<Pix> pix) {
        return pixWriteMemGif(Pointer.getPeer(pdata), Pointer.getPeer(psize),
                Pointer.getPeer(pix));
    }

    protected native static int pixWriteMemGif(@Ptr long pdata,
            @Ptr long psize, @Ptr long pix);

    /**
     * Original signature :
     * <code>GPLOT* gplotCreate(const char*, l_int32, const char*, const char*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:815</i>
     */
    public static Pointer<GPlot> gplotCreate(Pointer<Byte> rootname,
            int outformat, Pointer<Byte> title, Pointer<Byte> xlabel,
            Pointer<Byte> ylabel) {
        return (Pointer) Pointer.pointerToAddress(
                gplotCreate(Pointer.getPeer(rootname), outformat,
                        Pointer.getPeer(title), Pointer.getPeer(xlabel),
                        Pointer.getPeer(ylabel)), GPlot.class);
    }

    @Ptr
    protected native static long gplotCreate(@Ptr long rootname, int outformat,
            @Ptr long title, @Ptr long xlabel, @Ptr long ylabel);

    /**
     * Original signature : <code>void gplotDestroy(GPLOT**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:816</i>
     */
    public static void gplotDestroy(Pointer<Pointer<GPlot>> pgplot) {
        gplotDestroy(Pointer.getPeer(pgplot));
    }

    protected native static void gplotDestroy(@Ptr long pgplot) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 gplotAddPlot(GPLOT*, NUMA*, NUMA*, l_int32, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:817</i>
     */
    public static int gplotAddPlot(Pointer<GPlot> gplot, Pointer<Numa> nax,
            Pointer<Numa> nay, int plotstyle, Pointer<Byte> plottitle) {
        return gplotAddPlot(Pointer.getPeer(gplot), Pointer.getPeer(nax),
                Pointer.getPeer(nay), plotstyle, Pointer.getPeer(plottitle));
    }

    protected native static int gplotAddPlot(@Ptr long gplot, @Ptr long nax,
            @Ptr long nay, int plotstyle, @Ptr long plottitle);

    /**
     * Original signature :
     * <code>l_int32 gplotSetScaling(GPLOT*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:818</i>
     */
    public static int gplotSetScaling(Pointer<GPlot> gplot, int scaling) {
        return gplotSetScaling(Pointer.getPeer(gplot), scaling);
    }

    protected native static int gplotSetScaling(@Ptr long gplot, int scaling) throws LastError;

    /**
     * Original signature : <code>l_int32 gplotMakeOutput(GPLOT*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:819</i>
     */
    public static int gplotMakeOutput(Pointer<GPlot> gplot) {
        return gplotMakeOutput(Pointer.getPeer(gplot));
    }

    protected native static int gplotMakeOutput(@Ptr long gplot) throws LastError;

    /**
     * Original signature : <code>l_int32 gplotGenCommandFile(GPLOT*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:820</i>
     */
    public static int gplotGenCommandFile(Pointer<GPlot> gplot) {
        return gplotGenCommandFile(Pointer.getPeer(gplot));
    }

    protected native static int gplotGenCommandFile(@Ptr long gplot) throws LastError;

    /**
     * Original signature : <code>l_int32 gplotGenDataFiles(GPLOT*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:821</i>
     */
    public static int gplotGenDataFiles(Pointer<GPlot> gplot) {
        return gplotGenDataFiles(Pointer.getPeer(gplot));
    }

    protected native static int gplotGenDataFiles(@Ptr long gplot) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 gplotSimple1(NUMA*, l_int32, const char*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:822</i>
     */
    public static int gplotSimple1(Pointer<Numa> na, int outformat,
            Pointer<Byte> outroot, Pointer<Byte> title) {
        return gplotSimple1(Pointer.getPeer(na), outformat,
                Pointer.getPeer(outroot), Pointer.getPeer(title));
    }

    protected native static int gplotSimple1(@Ptr long na, int outformat,
            @Ptr long outroot, @Ptr long title);

    /**
     * Original signature :
     * <code>l_int32 gplotSimple2(NUMA*, NUMA*, l_int32, const char*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:823</i>
     */
    public static int gplotSimple2(Pointer<Numa> na1, Pointer<Numa> na2,
            int outformat, Pointer<Byte> outroot, Pointer<Byte> title) {
        return gplotSimple2(Pointer.getPeer(na1), Pointer.getPeer(na2),
                outformat, Pointer.getPeer(outroot), Pointer.getPeer(title));
    }

    protected native static int gplotSimple2(@Ptr long na1, @Ptr long na2,
            int outformat, @Ptr long outroot, @Ptr long title);

    /**
     * Original signature :
     * <code>l_int32 gplotSimpleN(NUMAA*, l_int32, const char*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:824</i>
     */
    public static int gplotSimpleN(Pointer<Numaa> naa, int outformat,
            Pointer<Byte> outroot, Pointer<Byte> title) {
        return gplotSimpleN(Pointer.getPeer(naa), outformat,
                Pointer.getPeer(outroot), Pointer.getPeer(title));
    }

    protected native static int gplotSimpleN(@Ptr long naa, int outformat,
            @Ptr long outroot, @Ptr long title);

    /**
     * Original signature : <code>GPLOT* gplotRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:825</i>
     */
    public static Pointer<GPlot> gplotRead(Pointer<Byte> filename) {
        return (Pointer) Pointer.pointerToAddress(
                gplotRead(Pointer.getPeer(filename)), GPlot.class);
    }

    @Ptr
    protected native static long gplotRead(@Ptr long filename) throws LastError;

    /**
     * Original signature : <code>l_int32 gplotWrite(const char*, GPLOT*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:826</i>
     */
    public static int gplotWrite(Pointer<Byte> filename, Pointer<GPlot> gplot) {
        return gplotWrite(Pointer.getPeer(filename), Pointer.getPeer(gplot));
    }

    protected native static int gplotWrite(@Ptr long filename, @Ptr long gplot) throws LastError;

    /**
     * Original signature :
     * <code>PTA* generatePtaLine(l_int32, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:827</i>
     */
    public static Pointer<Pta> generatePtaLine(int x1, int y1, int x2, int y2) {
        return (Pointer) Pointer.pointerToAddress(
                generatePtaLine$2(x1, y1, x2, y2), Pta.class);
    }

    @Ptr
    @Name("generatePtaLine")
    protected native static long generatePtaLine$2(int x1, int y1, int x2,
            int y2);

    /**
     * Original signature :
     * <code>PTA* generatePtaWideLine(l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:828</i>
     */
    public static Pointer<Pta> generatePtaWideLine(int x1, int y1, int x2,
            int y2, int width) {
        return (Pointer) Pointer.pointerToAddress(
                generatePtaWideLine$2(x1, y1, x2, y2, width), Pta.class);
    }

    @Ptr
    @Name("generatePtaWideLine")
    protected native static long generatePtaWideLine$2(int x1, int y1, int x2,
            int y2, int width);

    /**
     * Original signature : <code>PTA* generatePtaBox(BOX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:829</i>
     */
    public static Pointer<Pta> generatePtaBox(Pointer<Box> box, int width) {
        return (Pointer) Pointer.pointerToAddress(
                generatePtaBox(Pointer.getPeer(box), width), Pta.class);
    }

    @Ptr
    protected native static long generatePtaBox(@Ptr long box, int width) throws LastError;

    /**
     * Original signature :
     * <code>PTA* generatePtaBoxa(BOXA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:830</i>
     */
    public static Pointer<Pta> generatePtaBoxa(Pointer<Boxa> boxa, int width,
            int removedups) {
        return (Pointer) Pointer.pointerToAddress(
                generatePtaBoxa(Pointer.getPeer(boxa), width, removedups),
                Pta.class);
    }

    @Ptr
    protected native static long generatePtaBoxa(@Ptr long boxa, int width,
            int removedups);

    /**
     * Original signature :
     * <code>PTA* generatePtaHashBox(BOX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:831</i>
     */
    public static Pointer<Pta> generatePtaHashBox(Pointer<Box> box,
            int spacing, int width, int orient, int outline) {
        return (Pointer) Pointer.pointerToAddress(
                generatePtaHashBox(Pointer.getPeer(box), spacing, width,
                        orient, outline), Pta.class);
    }

    @Ptr
    protected native static long generatePtaHashBox(@Ptr long box, int spacing,
            int width, int orient, int outline);

    /**
     * Original signature :
     * <code>PTA* generatePtaHashBoxa(BOXA*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:832</i>
     */
    public static Pointer<Pta> generatePtaHashBoxa(Pointer<Boxa> boxa,
            int spacing, int width, int orient, int outline, int removedups) {
        return (Pointer) Pointer.pointerToAddress(
                generatePtaHashBoxa(Pointer.getPeer(boxa), spacing, width,
                        orient, outline, removedups), Pta.class);
    }

    @Ptr
    protected native static long generatePtaHashBoxa(@Ptr long boxa,
            int spacing, int width, int orient, int outline, int removedups);

    /**
     * Original signature : <code>PTAA* generatePtaaBoxa(BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:833</i>
     */
    public static Pointer<Ptaa> generatePtaaBoxa(Pointer<Boxa> boxa) {
        return (Pointer) Pointer.pointerToAddress(
                generatePtaaBoxa(Pointer.getPeer(boxa)), Ptaa.class);
    }

    @Ptr
    protected native static long generatePtaaBoxa(@Ptr long boxa) throws LastError;

    /**
     * Original signature :
     * <code>PTAA* generatePtaaHashBoxa(BOXA*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:834</i>
     */
    public static Pointer<Ptaa> generatePtaaHashBoxa(Pointer<Boxa> boxa,
            int spacing, int width, int orient, int outline) {
        return (Pointer) Pointer.pointerToAddress(
                generatePtaaHashBoxa(Pointer.getPeer(boxa), spacing, width,
                        orient, outline), Ptaa.class);
    }

    @Ptr
    protected native static long generatePtaaHashBoxa(@Ptr long boxa,
            int spacing, int width, int orient, int outline);

    /**
     * Original signature :
     * <code>PTA* generatePtaPolyline(PTA*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:835</i>
     */
    public static Pointer<Pta> generatePtaPolyline(Pointer<Pta> ptas,
            int width, int closeflag, int removedups) {
        return (Pointer) Pointer.pointerToAddress(
                generatePtaPolyline(Pointer.getPeer(ptas), width, closeflag,
                        removedups), Pta.class);
    }

    @Ptr
    protected native static long generatePtaPolyline(@Ptr long ptas, int width,
            int closeflag, int removedups);

    /**
     * Original signature : <code>PTA* convertPtaLineTo4cc(PTA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:836</i>
     */
    public static Pointer<Pta> convertPtaLineTo4cc(Pointer<Pta> ptas) {
        return (Pointer) Pointer.pointerToAddress(
                convertPtaLineTo4cc(Pointer.getPeer(ptas)), Pta.class);
    }

    @Ptr
    protected native static long convertPtaLineTo4cc(@Ptr long ptas) throws LastError;

    /**
     * Original signature : <code>PTA* generatePtaFilledCircle(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:837</i>
     */
    public static Pointer<Pta> generatePtaFilledCircle(int radius) {
        return (Pointer) Pointer.pointerToAddress(
                generatePtaFilledCircle$2(radius), Pta.class);
    }

    @Ptr
    @Name("generatePtaFilledCircle")
    protected native static long generatePtaFilledCircle$2(int radius) throws LastError;

    /**
     * Original signature : <code>PTA* generatePtaFilledSquare(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:838</i>
     */
    public static Pointer<Pta> generatePtaFilledSquare(int side) {
        return (Pointer) Pointer.pointerToAddress(
                generatePtaFilledSquare$2(side), Pta.class);
    }

    @Ptr
    @Name("generatePtaFilledSquare")
    protected native static long generatePtaFilledSquare$2(int side) throws LastError;

    /**
     * Original signature :
     * <code>PTA* generatePtaLineFromPt(l_int32, l_int32, l_float64, l_float64)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:839</i>
     */
    public static Pointer<Pta> generatePtaLineFromPt(int x, int y,
            double length, double radang) {
        return (Pointer) Pointer.pointerToAddress(
                generatePtaLineFromPt$2(x, y, length, radang), Pta.class);
    }

    @Ptr
    @Name("generatePtaLineFromPt")
    protected native static long generatePtaLineFromPt$2(int x, int y,
            double length, double radang);

    /**
     * Original signature :
     * <code>l_int32 locatePtRadially(l_int32, l_int32, l_float64, l_float64, l_float64*, l_float64*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:840</i>
     */
    public static int locatePtRadially(int xr, int yr, double dist,
            double radang, Pointer<Double> px, Pointer<Double> py) {
        return locatePtRadially(xr, yr, dist, radang, Pointer.getPeer(px),
                Pointer.getPeer(py));
    }

    protected native static int locatePtRadially(int xr, int yr, double dist,
            double radang, @Ptr long px, @Ptr long py);

    /**
     * Original signature :
     * <code>PTA* generatePlotPtaFromNuma(NUMA*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:841</i>
     */
    public static Pointer<Pta> generatePlotPtaFromNuma(Pointer<Numa> na,
            int orient, int width, int refpos, int max, int drawref) {
        return (Pointer) Pointer.pointerToAddress(
                generatePlotPtaFromNuma(Pointer.getPeer(na), orient, width,
                        refpos, max, drawref), Pta.class);
    }

    @Ptr
    protected native static long generatePlotPtaFromNuma(@Ptr long na,
            int orient, int width, int refpos, int max, int drawref);

    /**
     * Original signature :
     * <code>l_int32 pixRenderPta(PIX*, PTA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:842</i>
     */
    public static int pixRenderPta(Pointer<Pix> pix, Pointer<Pta> pta, int op) {
        return pixRenderPta(Pointer.getPeer(pix), Pointer.getPeer(pta), op);
    }

    protected native static int pixRenderPta(@Ptr long pix, @Ptr long pta,
            int op);

    /**
     * Original signature :
     * <code>l_int32 pixRenderPtaArb(PIX*, PTA*, l_uint8, l_uint8, l_uint8)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:843</i>
     */
    public static int pixRenderPtaArb(Pointer<Pix> pix, Pointer<Pta> pta,
            byte rval, byte gval, byte bval) {
        return pixRenderPtaArb(Pointer.getPeer(pix), Pointer.getPeer(pta),
                rval, gval, bval);
    }

    protected native static int pixRenderPtaArb(@Ptr long pix, @Ptr long pta,
            byte rval, byte gval, byte bval);

    /**
     * Original signature :
     * <code>l_int32 pixRenderPtaBlend(PIX*, PTA*, l_uint8, l_uint8, l_uint8, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:844</i>
     */
    public static int pixRenderPtaBlend(Pointer<Pix> pix, Pointer<Pta> pta,
            byte rval, byte gval, byte bval, float fract) {
        return pixRenderPtaBlend(Pointer.getPeer(pix), Pointer.getPeer(pta),
                rval, gval, bval, fract);
    }

    protected native static int pixRenderPtaBlend(@Ptr long pix, @Ptr long pta,
            byte rval, byte gval, byte bval, float fract);

    /**
     * Original signature :
     * <code>l_int32 pixRenderLine(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:845</i>
     */
    public static int pixRenderLine(Pointer<Pix> pix, int x1, int y1, int x2,
            int y2, int width, int op) {
        return pixRenderLine(Pointer.getPeer(pix), x1, y1, x2, y2, width, op);
    }

    protected native static int pixRenderLine(@Ptr long pix, int x1, int y1,
            int x2, int y2, int width, int op);

    /**
     * Original signature :
     * <code>l_int32 pixRenderLineArb(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_uint8, l_uint8, l_uint8)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:846</i>
     */
    public static int pixRenderLineArb(Pointer<Pix> pix, int x1, int y1,
            int x2, int y2, int width, byte rval, byte gval, byte bval) {
        return pixRenderLineArb(Pointer.getPeer(pix), x1, y1, x2, y2, width,
                rval, gval, bval);
    }

    protected native static int pixRenderLineArb(@Ptr long pix, int x1, int y1,
            int x2, int y2, int width, byte rval, byte gval, byte bval);

    /**
     * Original signature :
     * <code>l_int32 pixRenderLineBlend(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_uint8, l_uint8, l_uint8, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:847</i>
     */
    public static int pixRenderLineBlend(Pointer<Pix> pix, int x1, int y1,
            int x2, int y2, int width, byte rval, byte gval, byte bval,
            float fract) {
        return pixRenderLineBlend(Pointer.getPeer(pix), x1, y1, x2, y2, width,
                rval, gval, bval, fract);
    }

    protected native static int pixRenderLineBlend(@Ptr long pix, int x1,
            int y1, int x2, int y2, int width, byte rval, byte gval, byte bval,
            float fract);

    /**
     * Original signature :
     * <code>l_int32 pixRenderBox(PIX*, BOX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:848</i>
     */
    public static int pixRenderBox(Pointer<Pix> pix, Pointer<Box> box,
            int width, int op) {
        return pixRenderBox(Pointer.getPeer(pix), Pointer.getPeer(box), width,
                op);
    }

    protected native static int pixRenderBox(@Ptr long pix, @Ptr long box,
            int width, int op);

    /**
     * Original signature :
     * <code>l_int32 pixRenderBoxArb(PIX*, BOX*, l_int32, l_uint8, l_uint8, l_uint8)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:849</i>
     */
    public static int pixRenderBoxArb(Pointer<Pix> pix, Pointer<Box> box,
            int width, byte rval, byte gval, byte bval) {
        return pixRenderBoxArb(Pointer.getPeer(pix), Pointer.getPeer(box),
                width, rval, gval, bval);
    }

    protected native static int pixRenderBoxArb(@Ptr long pix, @Ptr long box,
            int width, byte rval, byte gval, byte bval);

    /**
     * Original signature :
     * <code>l_int32 pixRenderBoxBlend(PIX*, BOX*, l_int32, l_uint8, l_uint8, l_uint8, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:850</i>
     */
    public static int pixRenderBoxBlend(Pointer<Pix> pix, Pointer<Box> box,
            int width, byte rval, byte gval, byte bval, float fract) {
        return pixRenderBoxBlend(Pointer.getPeer(pix), Pointer.getPeer(box),
                width, rval, gval, bval, fract);
    }

    protected native static int pixRenderBoxBlend(@Ptr long pix, @Ptr long box,
            int width, byte rval, byte gval, byte bval, float fract);

    /**
     * Original signature :
     * <code>l_int32 pixRenderBoxa(PIX*, BOXA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:851</i>
     */
    public static int pixRenderBoxa(Pointer<Pix> pix, Pointer<Boxa> boxa,
            int width, int op) {
        return pixRenderBoxa(Pointer.getPeer(pix), Pointer.getPeer(boxa),
                width, op);
    }

    protected native static int pixRenderBoxa(@Ptr long pix, @Ptr long boxa,
            int width, int op);

    /**
     * Original signature :
     * <code>l_int32 pixRenderBoxaArb(PIX*, BOXA*, l_int32, l_uint8, l_uint8, l_uint8)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:852</i>
     */
    public static int pixRenderBoxaArb(Pointer<Pix> pix, Pointer<Boxa> boxa,
            int width, byte rval, byte gval, byte bval) {
        return pixRenderBoxaArb(Pointer.getPeer(pix), Pointer.getPeer(boxa),
                width, rval, gval, bval);
    }

    protected native static int pixRenderBoxaArb(@Ptr long pix, @Ptr long boxa,
            int width, byte rval, byte gval, byte bval);

    /**
     * Original signature :
     * <code>l_int32 pixRenderBoxaBlend(PIX*, BOXA*, l_int32, l_uint8, l_uint8, l_uint8, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:853</i>
     */
    public static int pixRenderBoxaBlend(Pointer<Pix> pix, Pointer<Boxa> boxa,
            int width, byte rval, byte gval, byte bval, float fract,
            int removedups) {
        return pixRenderBoxaBlend(Pointer.getPeer(pix), Pointer.getPeer(boxa),
                width, rval, gval, bval, fract, removedups);
    }

    protected native static int pixRenderBoxaBlend(@Ptr long pix,
            @Ptr long boxa, int width, byte rval, byte gval, byte bval,
            float fract, int removedups);

    /**
     * Original signature :
     * <code>l_int32 pixRenderHashBox(PIX*, BOX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:854</i>
     */
    public static int pixRenderHashBox(Pointer<Pix> pix, Pointer<Box> box,
            int spacing, int width, int orient, int outline, int op) {
        return pixRenderHashBox(Pointer.getPeer(pix), Pointer.getPeer(box),
                spacing, width, orient, outline, op);
    }

    protected native static int pixRenderHashBox(@Ptr long pix, @Ptr long box,
            int spacing, int width, int orient, int outline, int op);

    /**
     * Original signature :
     * <code>l_int32 pixRenderHashBoxArb(PIX*, BOX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:855</i>
     */
    public static int pixRenderHashBoxArb(Pointer<Pix> pix, Pointer<Box> box,
            int spacing, int width, int orient, int outline, int rval,
            int gval, int bval) {
        return pixRenderHashBoxArb(Pointer.getPeer(pix), Pointer.getPeer(box),
                spacing, width, orient, outline, rval, gval, bval);
    }

    protected native static int pixRenderHashBoxArb(@Ptr long pix,
            @Ptr long box, int spacing, int width, int orient, int outline,
            int rval, int gval, int bval);

    /**
     * Original signature :
     * <code>l_int32 pixRenderHashBoxBlend(PIX*, BOX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:856</i>
     */
    public static int pixRenderHashBoxBlend(Pointer<Pix> pix, Pointer<Box> box,
            int spacing, int width, int orient, int outline, int rval,
            int gval, int bval, float fract) {
        return pixRenderHashBoxBlend(Pointer.getPeer(pix),
                Pointer.getPeer(box), spacing, width, orient, outline, rval,
                gval, bval, fract);
    }

    protected native static int pixRenderHashBoxBlend(@Ptr long pix,
            @Ptr long box, int spacing, int width, int orient, int outline,
            int rval, int gval, int bval, float fract);

    /**
     * Original signature :
     * <code>l_int32 pixRenderHashBoxa(PIX*, BOXA*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:857</i>
     */
    public static int pixRenderHashBoxa(Pointer<Pix> pix, Pointer<Boxa> boxa,
            int spacing, int width, int orient, int outline, int op) {
        return pixRenderHashBoxa(Pointer.getPeer(pix), Pointer.getPeer(boxa),
                spacing, width, orient, outline, op);
    }

    protected native static int pixRenderHashBoxa(@Ptr long pix,
            @Ptr long boxa, int spacing, int width, int orient, int outline,
            int op);

    /**
     * Original signature :
     * <code>l_int32 pixRenderHashBoxaArb(PIX*, BOXA*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:858</i>
     */
    public static int pixRenderHashBoxaArb(Pointer<Pix> pix,
            Pointer<Boxa> boxa, int spacing, int width, int orient,
            int outline, int rval, int gval, int bval) {
        return pixRenderHashBoxaArb(Pointer.getPeer(pix),
                Pointer.getPeer(boxa), spacing, width, orient, outline, rval,
                gval, bval);
    }

    protected native static int pixRenderHashBoxaArb(@Ptr long pix,
            @Ptr long boxa, int spacing, int width, int orient, int outline,
            int rval, int gval, int bval);

    /**
     * Original signature :
     * <code>l_int32 pixRenderHashBoxaBlend(PIX*, BOXA*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:859</i>
     */
    public static int pixRenderHashBoxaBlend(Pointer<Pix> pix,
            Pointer<Boxa> boxa, int spacing, int width, int orient,
            int outline, int rval, int gval, int bval, float fract) {
        return pixRenderHashBoxaBlend(Pointer.getPeer(pix),
                Pointer.getPeer(boxa), spacing, width, orient, outline, rval,
                gval, bval, fract);
    }

    protected native static int pixRenderHashBoxaBlend(@Ptr long pix,
            @Ptr long boxa, int spacing, int width, int orient, int outline,
            int rval, int gval, int bval, float fract);

    /**
     * Original signature :
     * <code>l_int32 pixRenderPolyline(PIX*, PTA*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:860</i>
     */
    public static int pixRenderPolyline(Pointer<Pix> pix, Pointer<Pta> ptas,
            int width, int op, int closeflag) {
        return pixRenderPolyline(Pointer.getPeer(pix), Pointer.getPeer(ptas),
                width, op, closeflag);
    }

    protected native static int pixRenderPolyline(@Ptr long pix,
            @Ptr long ptas, int width, int op, int closeflag);

    /**
     * Original signature :
     * <code>l_int32 pixRenderPolylineArb(PIX*, PTA*, l_int32, l_uint8, l_uint8, l_uint8, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:861</i>
     */
    public static int pixRenderPolylineArb(Pointer<Pix> pix, Pointer<Pta> ptas,
            int width, byte rval, byte gval, byte bval, int closeflag) {
        return pixRenderPolylineArb(Pointer.getPeer(pix),
                Pointer.getPeer(ptas), width, rval, gval, bval, closeflag);
    }

    protected native static int pixRenderPolylineArb(@Ptr long pix,
            @Ptr long ptas, int width, byte rval, byte gval, byte bval,
            int closeflag);

    /**
     * Original signature :
     * <code>l_int32 pixRenderPolylineBlend(PIX*, PTA*, l_int32, l_uint8, l_uint8, l_uint8, l_float32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:862</i>
     */
    public static int pixRenderPolylineBlend(Pointer<Pix> pix,
            Pointer<Pta> ptas, int width, byte rval, byte gval, byte bval,
            float fract, int closeflag, int removedups) {
        return pixRenderPolylineBlend(Pointer.getPeer(pix),
                Pointer.getPeer(ptas), width, rval, gval, bval, fract,
                closeflag, removedups);
    }

    protected native static int pixRenderPolylineBlend(@Ptr long pix,
            @Ptr long ptas, int width, byte rval, byte gval, byte bval,
            float fract, int closeflag, int removedups);

    /**
     * Original signature :
     * <code>PIX* pixRenderRandomCmapPtaa(PIX*, PTAA*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:863</i>
     */
    public static Pointer<Pix> pixRenderRandomCmapPtaa(Pointer<Pix> pix,
            Pointer<Ptaa> ptaa, int polyflag, int width, int closeflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixRenderRandomCmapPtaa(Pointer.getPeer(pix),
                        Pointer.getPeer(ptaa), polyflag, width, closeflag),
                Pix.class);
    }

    @Ptr
    protected native static long pixRenderRandomCmapPtaa(@Ptr long pix,
            @Ptr long ptaa, int polyflag, int width, int closeflag);

    /**
     * Original signature :
     * <code>PIX* pixRenderPolygon(PTA*, l_int32, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:864</i>
     */
    public static Pointer<Pix> pixRenderPolygon(Pointer<Pta> ptas, int width,
            Pointer<Integer> pxmin, Pointer<Integer> pymin) {
        return (Pointer) Pointer.pointerToAddress(
                pixRenderPolygon(Pointer.getPeer(ptas), width,
                        Pointer.getPeer(pxmin), Pointer.getPeer(pymin)),
                Pix.class);
    }

    @Ptr
    protected native static long pixRenderPolygon(@Ptr long ptas, int width,
            @Ptr long pxmin, @Ptr long pymin);

    /**
     * Original signature :
     * <code>PIX* pixFillPolygon(PIX*, PTA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:865</i>
     */
    public static Pointer<Pix> pixFillPolygon(Pointer<Pix> pixs,
            Pointer<Pta> pta, int xmin, int ymin) {
        return (Pointer) Pointer.pointerToAddress(
                pixFillPolygon(Pointer.getPeer(pixs), Pointer.getPeer(pta),
                        xmin, ymin), Pix.class);
    }

    @Ptr
    protected native static long pixFillPolygon(@Ptr long pixs, @Ptr long pta,
            int xmin, int ymin);

    /**
     * Original signature :
     * <code>PIX* pixRenderContours(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:866</i>
     */
    public static Pointer<Pix> pixRenderContours(Pointer<Pix> pixs,
            int startval, int incr, int outdepth) {
        return (Pointer) Pointer.pointerToAddress(
                pixRenderContours(Pointer.getPeer(pixs), startval, incr,
                        outdepth), Pix.class);
    }

    @Ptr
    protected native static long pixRenderContours(@Ptr long pixs,
            int startval, int incr, int outdepth);

    /**
     * Original signature :
     * <code>PIX* fpixAutoRenderContours(FPIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:867</i>
     */
    public static Pointer<Pix> fpixAutoRenderContours(Pointer<FPix> fpix,
            int ncontours) {
        return (Pointer) Pointer.pointerToAddress(
                fpixAutoRenderContours(Pointer.getPeer(fpix), ncontours),
                Pix.class);
    }

    @Ptr
    protected native static long fpixAutoRenderContours(@Ptr long fpix,
            int ncontours);

    /**
     * Original signature :
     * <code>PIX* fpixRenderContours(FPIX*, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:868</i>
     */
    public static Pointer<Pix> fpixRenderContours(Pointer<FPix> fpixs,
            float incr, float proxim) {
        return (Pointer) Pointer.pointerToAddress(
                fpixRenderContours(Pointer.getPeer(fpixs), incr, proxim),
                Pix.class);
    }

    @Ptr
    protected native static long fpixRenderContours(@Ptr long fpixs,
            float incr, float proxim);

    /**
     * Original signature :
     * <code>PIX* pixErodeGray(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:869</i>
     */
    public static Pointer<Pix> pixErodeGray(Pointer<Pix> pixs, int hsize,
            int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixErodeGray(Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixErodeGray(@Ptr long pixs, int hsize,
            int vsize);

    /**
     * Original signature :
     * <code>PIX* pixDilateGray(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:870</i>
     */
    public static Pointer<Pix> pixDilateGray(Pointer<Pix> pixs, int hsize,
            int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixDilateGray(Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixDilateGray(@Ptr long pixs, int hsize,
            int vsize);

    /**
     * Original signature :
     * <code>PIX* pixOpenGray(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:871</i>
     */
    public static Pointer<Pix> pixOpenGray(Pointer<Pix> pixs, int hsize,
            int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixOpenGray(Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixOpenGray(@Ptr long pixs, int hsize,
            int vsize);

    /**
     * Original signature :
     * <code>PIX* pixCloseGray(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:872</i>
     */
    public static Pointer<Pix> pixCloseGray(Pointer<Pix> pixs, int hsize,
            int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixCloseGray(Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixCloseGray(@Ptr long pixs, int hsize,
            int vsize);

    /**
     * Original signature :
     * <code>PIX* pixErodeGray3(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:873</i>
     */
    public static Pointer<Pix> pixErodeGray3(Pointer<Pix> pixs, int hsize,
            int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixErodeGray3(Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixErodeGray3(@Ptr long pixs, int hsize,
            int vsize);

    /**
     * Original signature :
     * <code>PIX* pixDilateGray3(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:874</i>
     */
    public static Pointer<Pix> pixDilateGray3(Pointer<Pix> pixs, int hsize,
            int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixDilateGray3(Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixDilateGray3(@Ptr long pixs, int hsize,
            int vsize);

    /**
     * Original signature :
     * <code>PIX* pixOpenGray3(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:875</i>
     */
    public static Pointer<Pix> pixOpenGray3(Pointer<Pix> pixs, int hsize,
            int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixOpenGray3(Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixOpenGray3(@Ptr long pixs, int hsize,
            int vsize);

    /**
     * Original signature :
     * <code>PIX* pixCloseGray3(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:876</i>
     */
    public static Pointer<Pix> pixCloseGray3(Pointer<Pix> pixs, int hsize,
            int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixCloseGray3(Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixCloseGray3(@Ptr long pixs, int hsize,
            int vsize);

    /**
     * Original signature :
     * <code>void dilateGrayLow(l_uint32*, l_int32, l_int32, l_int32, l_uint32*, l_int32, l_int32, l_int32, l_uint8*, l_uint8*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:877</i>
     */
    public static void dilateGrayLow(Pointer<Integer> datad, int w, int h,
            int wpld, Pointer<Integer> datas, int wpls, int size,
            int direction, Pointer<Byte> buffer, Pointer<Byte> maxarray) {
        dilateGrayLow(Pointer.getPeer(datad), w, h, wpld,
                Pointer.getPeer(datas), wpls, size, direction,
                Pointer.getPeer(buffer), Pointer.getPeer(maxarray));
    }

    protected native static void dilateGrayLow(@Ptr long datad, int w, int h,
            int wpld, @Ptr long datas, int wpls, int size, int direction,
            @Ptr long buffer, @Ptr long maxarray);

    /**
     * Original signature :
     * <code>void erodeGrayLow(l_uint32*, l_int32, l_int32, l_int32, l_uint32*, l_int32, l_int32, l_int32, l_uint8*, l_uint8*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:878</i>
     */
    public static void erodeGrayLow(Pointer<Integer> datad, int w, int h,
            int wpld, Pointer<Integer> datas, int wpls, int size,
            int direction, Pointer<Byte> buffer, Pointer<Byte> minarray) {
        erodeGrayLow(Pointer.getPeer(datad), w, h, wpld,
                Pointer.getPeer(datas), wpls, size, direction,
                Pointer.getPeer(buffer), Pointer.getPeer(minarray));
    }

    protected native static void erodeGrayLow(@Ptr long datad, int w, int h,
            int wpld, @Ptr long datas, int wpls, int size, int direction,
            @Ptr long buffer, @Ptr long minarray);

    /**
     * Original signature : <code>PIX* pixDitherToBinary(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:879</i>
     */
    public static Pointer<Pix> pixDitherToBinary(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixDitherToBinary(Pointer.getPeer(pixs)), Pix.class);
    }

    @Ptr
    protected native static long pixDitherToBinary(@Ptr long pixs) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixDitherToBinarySpec(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:880</i>
     */
    public static Pointer<Pix> pixDitherToBinarySpec(Pointer<Pix> pixs,
            int lowerclip, int upperclip) {
        return (Pointer) Pointer.pointerToAddress(
                pixDitherToBinarySpec(Pointer.getPeer(pixs), lowerclip,
                        upperclip), Pix.class);
    }

    @Ptr
    protected native static long pixDitherToBinarySpec(@Ptr long pixs,
            int lowerclip, int upperclip);

    /**
     * Original signature :
     * <code>PIX* pixThresholdToBinary(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:881</i>
     */
    public static Pointer<Pix> pixThresholdToBinary(Pointer<Pix> pixs,
            int thresh) {
        return (Pointer) Pointer.pointerToAddress(
                pixThresholdToBinary(Pointer.getPeer(pixs), thresh), Pix.class);
    }

    @Ptr
    protected native static long pixThresholdToBinary(@Ptr long pixs, int thresh) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixVarThresholdToBinary(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:882</i>
     */
    public static Pointer<Pix> pixVarThresholdToBinary(Pointer<Pix> pixs,
            Pointer<Pix> pixg) {
        return (Pointer) Pointer.pointerToAddress(
                pixVarThresholdToBinary(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixg)), Pix.class);
    }

    @Ptr
    protected native static long pixVarThresholdToBinary(@Ptr long pixs,
            @Ptr long pixg);

    /**
     * Original signature :
     * <code>PIX* pixDitherToBinaryLUT(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:883</i>
     */
    public static Pointer<Pix> pixDitherToBinaryLUT(Pointer<Pix> pixs,
            int lowerclip, int upperclip) {
        return (Pointer) Pointer.pointerToAddress(
                pixDitherToBinaryLUT(Pointer.getPeer(pixs), lowerclip,
                        upperclip), Pix.class);
    }

    @Ptr
    protected native static long pixDitherToBinaryLUT(@Ptr long pixs,
            int lowerclip, int upperclip);

    /**
     * Original signature :
     * <code>PIX* pixGenerateMaskByValue(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:884</i>
     */
    public static Pointer<Pix> pixGenerateMaskByValue(Pointer<Pix> pixs,
            int val, int usecmap) {
        return (Pointer) Pointer.pointerToAddress(
                pixGenerateMaskByValue(Pointer.getPeer(pixs), val, usecmap),
                Pix.class);
    }

    @Ptr
    protected native static long pixGenerateMaskByValue(@Ptr long pixs,
            int val, int usecmap);

    /**
     * Original signature :
     * <code>PIX* pixGenerateMaskByBand(PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:885</i>
     */
    public static Pointer<Pix> pixGenerateMaskByBand(Pointer<Pix> pixs,
            int lower, int upper, int inband, int usecmap) {
        return (Pointer) Pointer.pointerToAddress(
                pixGenerateMaskByBand(Pointer.getPeer(pixs), lower, upper,
                        inband, usecmap), Pix.class);
    }

    @Ptr
    protected native static long pixGenerateMaskByBand(@Ptr long pixs,
            int lower, int upper, int inband, int usecmap);

    /**
     * Original signature : <code>PIX* pixDitherTo2bpp(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:886</i>
     */
    public static Pointer<Pix> pixDitherTo2bpp(Pointer<Pix> pixs, int cmapflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixDitherTo2bpp(Pointer.getPeer(pixs), cmapflag), Pix.class);
    }

    @Ptr
    protected native static long pixDitherTo2bpp(@Ptr long pixs, int cmapflag) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixDitherTo2bppSpec(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:887</i>
     */
    public static Pointer<Pix> pixDitherTo2bppSpec(Pointer<Pix> pixs,
            int lowerclip, int upperclip, int cmapflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixDitherTo2bppSpec(Pointer.getPeer(pixs), lowerclip,
                        upperclip, cmapflag), Pix.class);
    }

    @Ptr
    protected native static long pixDitherTo2bppSpec(@Ptr long pixs,
            int lowerclip, int upperclip, int cmapflag);

    /**
     * Original signature :
     * <code>PIX* pixThresholdTo2bpp(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:888</i>
     */
    public static Pointer<Pix> pixThresholdTo2bpp(Pointer<Pix> pixs,
            int nlevels, int cmapflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixThresholdTo2bpp(Pointer.getPeer(pixs), nlevels, cmapflag),
                Pix.class);
    }

    @Ptr
    protected native static long pixThresholdTo2bpp(@Ptr long pixs,
            int nlevels, int cmapflag);

    /**
     * Original signature :
     * <code>PIX* pixThresholdTo4bpp(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:889</i>
     */
    public static Pointer<Pix> pixThresholdTo4bpp(Pointer<Pix> pixs,
            int nlevels, int cmapflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixThresholdTo4bpp(Pointer.getPeer(pixs), nlevels, cmapflag),
                Pix.class);
    }

    @Ptr
    protected native static long pixThresholdTo4bpp(@Ptr long pixs,
            int nlevels, int cmapflag);

    /**
     * Original signature :
     * <code>PIX* pixThresholdOn8bpp(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:890</i>
     */
    public static Pointer<Pix> pixThresholdOn8bpp(Pointer<Pix> pixs,
            int nlevels, int cmapflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixThresholdOn8bpp(Pointer.getPeer(pixs), nlevels, cmapflag),
                Pix.class);
    }

    @Ptr
    protected native static long pixThresholdOn8bpp(@Ptr long pixs,
            int nlevels, int cmapflag);

    /**
     * Original signature :
     * <code>PIX* pixThresholdGrayArb(PIX*, const char*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:891</i>
     */
    public static Pointer<Pix> pixThresholdGrayArb(Pointer<Pix> pixs,
            Pointer<Byte> edgevals, int outdepth, int use_average,
            int setblack, int setwhite) {
        return (Pointer) Pointer.pointerToAddress(
                pixThresholdGrayArb(Pointer.getPeer(pixs),
                        Pointer.getPeer(edgevals), outdepth, use_average,
                        setblack, setwhite), Pix.class);
    }

    @Ptr
    protected native static long pixThresholdGrayArb(@Ptr long pixs,
            @Ptr long edgevals, int outdepth, int use_average, int setblack,
            int setwhite);

    /**
     * Original signature :
     * <code>l_int32* makeGrayQuantIndexTable(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:892</i>
     */
    public static Pointer<Integer> makeGrayQuantIndexTable(int nlevels) {
        return (Pointer) Pointer.pointerToAddress(
                makeGrayQuantIndexTable$2(nlevels), Integer.class);
    }

    @Ptr
    @Name("makeGrayQuantIndexTable")
    protected native static long makeGrayQuantIndexTable$2(int nlevels) throws LastError;

    /**
     * Original signature :
     * <code>l_int32* makeGrayQuantTargetTable(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:893</i>
     */
    public static Pointer<Integer> makeGrayQuantTargetTable(int nlevels,
            int depth) {
        return (Pointer) Pointer.pointerToAddress(
                makeGrayQuantTargetTable$2(nlevels, depth), Integer.class);
    }

    @Ptr
    @Name("makeGrayQuantTargetTable")
    protected native static long makeGrayQuantTargetTable$2(int nlevels,
            int depth);

    /**
     * Original signature :
     * <code>l_int32 makeGrayQuantTableArb(NUMA*, l_int32, l_int32**, PIXCMAP**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:894</i>
     */
    public static int makeGrayQuantTableArb(Pointer<Numa> na, int outdepth,
            Pointer<Pointer<Integer>> ptab, Pointer<Pointer<PixColormap>> pcmap) {
        return makeGrayQuantTableArb(Pointer.getPeer(na), outdepth,
                Pointer.getPeer(ptab), Pointer.getPeer(pcmap));
    }

    protected native static int makeGrayQuantTableArb(@Ptr long na,
            int outdepth, @Ptr long ptab, @Ptr long pcmap);

    /**
     * Original signature :
     * <code>l_int32 makeGrayQuantColormapArb(PIX*, l_int32*, l_int32, PIXCMAP**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:895</i>
     */
    public static int makeGrayQuantColormapArb(Pointer<Pix> pixs,
            Pointer<Integer> tab, int outdepth,
            Pointer<Pointer<PixColormap>> pcmap) {
        return makeGrayQuantColormapArb(Pointer.getPeer(pixs),
                Pointer.getPeer(tab), outdepth, Pointer.getPeer(pcmap));
    }

    protected native static int makeGrayQuantColormapArb(@Ptr long pixs,
            @Ptr long tab, int outdepth, @Ptr long pcmap);

    /**
     * Original signature :
     * <code>PIX* pixGenerateMaskByBand32(PIX*, l_uint32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:896</i>
     */
    public static Pointer<Pix> pixGenerateMaskByBand32(Pointer<Pix> pixs,
            int refval, int delm, int delp) {
        return (Pointer) Pointer.pointerToAddress(
                pixGenerateMaskByBand32(Pointer.getPeer(pixs), refval, delm,
                        delp), Pix.class);
    }

    @Ptr
    protected native static long pixGenerateMaskByBand32(@Ptr long pixs,
            int refval, int delm, int delp);

    /**
     * Original signature :
     * <code>PIX* pixGenerateMaskByDiscr32(PIX*, l_uint32, l_uint32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:897</i>
     */
    public static Pointer<Pix> pixGenerateMaskByDiscr32(Pointer<Pix> pixs,
            int refval1, int refval2, int distflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixGenerateMaskByDiscr32(Pointer.getPeer(pixs), refval1,
                        refval2, distflag), Pix.class);
    }

    @Ptr
    protected native static long pixGenerateMaskByDiscr32(@Ptr long pixs,
            int refval1, int refval2, int distflag);

    /**
     * Original signature :
     * <code>PIX* pixGrayQuantFromHisto(PIX*, PIX*, PIX*, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:898</i>
     */
    public static Pointer<Pix> pixGrayQuantFromHisto(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<Pix> pixm, float minfract, int maxsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixGrayQuantFromHisto(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), Pointer.getPeer(pixm), minfract,
                        maxsize), Pix.class);
    }

    @Ptr
    protected native static long pixGrayQuantFromHisto(@Ptr long pixd,
            @Ptr long pixs, @Ptr long pixm, float minfract, int maxsize);

    /**
     * Original signature :
     * <code>PIX* pixGrayQuantFromCmap(PIX*, PIXCMAP*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:899</i>
     */
    public static Pointer<Pix> pixGrayQuantFromCmap(Pointer<Pix> pixs,
            Pointer<PixColormap> cmap, int mindepth) {
        return (Pointer) Pointer.pointerToAddress(
                pixGrayQuantFromCmap(Pointer.getPeer(pixs),
                        Pointer.getPeer(cmap), mindepth), Pix.class);
    }

    @Ptr
    protected native static long pixGrayQuantFromCmap(@Ptr long pixs,
            @Ptr long cmap, int mindepth);

    /**
     * Original signature :
     * <code>void ditherToBinaryLow(l_uint32*, l_int32, l_int32, l_int32, l_uint32*, l_int32, l_uint32*, l_uint32*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:900</i>
     */
    public static void ditherToBinaryLow(Pointer<Integer> datad, int w, int h,
            int wpld, Pointer<Integer> datas, int wpls, Pointer<Integer> bufs1,
            Pointer<Integer> bufs2, int lowerclip, int upperclip) {
        ditherToBinaryLow(Pointer.getPeer(datad), w, h, wpld,
                Pointer.getPeer(datas), wpls, Pointer.getPeer(bufs1),
                Pointer.getPeer(bufs2), lowerclip, upperclip);
    }

    protected native static void ditherToBinaryLow(@Ptr long datad, int w,
            int h, int wpld, @Ptr long datas, int wpls, @Ptr long bufs1,
            @Ptr long bufs2, int lowerclip, int upperclip);

    /**
     * Original signature :
     * <code>void ditherToBinaryLineLow(l_uint32*, l_int32, l_uint32*, l_uint32*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:901</i>
     */
    public static void ditherToBinaryLineLow(Pointer<Integer> lined, int w,
            Pointer<Integer> bufs1, Pointer<Integer> bufs2, int lowerclip,
            int upperclip, int lastlineflag) {
        ditherToBinaryLineLow(Pointer.getPeer(lined), w,
                Pointer.getPeer(bufs1), Pointer.getPeer(bufs2), lowerclip,
                upperclip, lastlineflag);
    }

    protected native static void ditherToBinaryLineLow(@Ptr long lined, int w,
            @Ptr long bufs1, @Ptr long bufs2, int lowerclip, int upperclip,
            int lastlineflag);

    /**
     * Original signature :
     * <code>void thresholdToBinaryLow(l_uint32*, l_int32, l_int32, l_int32, l_uint32*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:902</i>
     */
    public static void thresholdToBinaryLow(Pointer<Integer> datad, int w,
            int h, int wpld, Pointer<Integer> datas, int d, int wpls, int thresh) {
        thresholdToBinaryLow(Pointer.getPeer(datad), w, h, wpld,
                Pointer.getPeer(datas), d, wpls, thresh);
    }

    protected native static void thresholdToBinaryLow(@Ptr long datad, int w,
            int h, int wpld, @Ptr long datas, int d, int wpls, int thresh);

    /**
     * Original signature :
     * <code>void thresholdToBinaryLineLow(l_uint32*, l_int32, l_uint32*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:903</i>
     */
    public static void thresholdToBinaryLineLow(Pointer<Integer> lined, int w,
            Pointer<Integer> lines, int d, int thresh) {
        thresholdToBinaryLineLow(Pointer.getPeer(lined), w,
                Pointer.getPeer(lines), d, thresh);
    }

    protected native static void thresholdToBinaryLineLow(@Ptr long lined,
            int w, @Ptr long lines, int d, int thresh);

    /**
     * Original signature :
     * <code>void ditherToBinaryLUTLow(l_uint32*, l_int32, l_int32, l_int32, l_uint32*, l_int32, l_uint32*, l_uint32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:904</i>
     */
    public static void ditherToBinaryLUTLow(Pointer<Integer> datad, int w,
            int h, int wpld, Pointer<Integer> datas, int wpls,
            Pointer<Integer> bufs1, Pointer<Integer> bufs2,
            Pointer<Integer> tabval, Pointer<Integer> tab38,
            Pointer<Integer> tab14) {
        ditherToBinaryLUTLow(Pointer.getPeer(datad), w, h, wpld,
                Pointer.getPeer(datas), wpls, Pointer.getPeer(bufs1),
                Pointer.getPeer(bufs2), Pointer.getPeer(tabval),
                Pointer.getPeer(tab38), Pointer.getPeer(tab14));
    }

    protected native static void ditherToBinaryLUTLow(@Ptr long datad, int w,
            int h, int wpld, @Ptr long datas, int wpls, @Ptr long bufs1,
            @Ptr long bufs2, @Ptr long tabval, @Ptr long tab38, @Ptr long tab14);

    /**
     * Original signature :
     * <code>void ditherToBinaryLineLUTLow(l_uint32*, l_int32, l_uint32*, l_uint32*, l_int32*, l_int32*, l_int32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:905</i>
     */
    public static void ditherToBinaryLineLUTLow(Pointer<Integer> lined, int w,
            Pointer<Integer> bufs1, Pointer<Integer> bufs2,
            Pointer<Integer> tabval, Pointer<Integer> tab38,
            Pointer<Integer> tab14, int lastlineflag) {
        ditherToBinaryLineLUTLow(Pointer.getPeer(lined), w,
                Pointer.getPeer(bufs1), Pointer.getPeer(bufs2),
                Pointer.getPeer(tabval), Pointer.getPeer(tab38),
                Pointer.getPeer(tab14), lastlineflag);
    }

    protected native static void ditherToBinaryLineLUTLow(@Ptr long lined,
            int w, @Ptr long bufs1, @Ptr long bufs2, @Ptr long tabval,
            @Ptr long tab38, @Ptr long tab14, int lastlineflag);

    /**
     * Original signature :
     * <code>l_int32 make8To1DitherTables(l_int32**, l_int32**, l_int32**, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:906</i>
     */
    public static int make8To1DitherTables(Pointer<Pointer<Integer>> ptabval,
            Pointer<Pointer<Integer>> ptab38, Pointer<Pointer<Integer>> ptab14,
            int lowerclip, int upperclip) {
        return make8To1DitherTables(Pointer.getPeer(ptabval),
                Pointer.getPeer(ptab38), Pointer.getPeer(ptab14), lowerclip,
                upperclip);
    }

    protected native static int make8To1DitherTables(@Ptr long ptabval,
            @Ptr long ptab38, @Ptr long ptab14, int lowerclip, int upperclip);

    /**
     * Original signature :
     * <code>void ditherTo2bppLow(l_uint32*, l_int32, l_int32, l_int32, l_uint32*, l_int32, l_uint32*, l_uint32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:907</i>
     */
    public static void ditherTo2bppLow(Pointer<Integer> datad, int w, int h,
            int wpld, Pointer<Integer> datas, int wpls, Pointer<Integer> bufs1,
            Pointer<Integer> bufs2, Pointer<Integer> tabval,
            Pointer<Integer> tab38, Pointer<Integer> tab14) {
        ditherTo2bppLow(Pointer.getPeer(datad), w, h, wpld,
                Pointer.getPeer(datas), wpls, Pointer.getPeer(bufs1),
                Pointer.getPeer(bufs2), Pointer.getPeer(tabval),
                Pointer.getPeer(tab38), Pointer.getPeer(tab14));
    }

    protected native static void ditherTo2bppLow(@Ptr long datad, int w, int h,
            int wpld, @Ptr long datas, int wpls, @Ptr long bufs1,
            @Ptr long bufs2, @Ptr long tabval, @Ptr long tab38, @Ptr long tab14);

    /**
     * Original signature :
     * <code>void ditherTo2bppLineLow(l_uint32*, l_int32, l_uint32*, l_uint32*, l_int32*, l_int32*, l_int32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:908</i>
     */
    public static void ditherTo2bppLineLow(Pointer<Integer> lined, int w,
            Pointer<Integer> bufs1, Pointer<Integer> bufs2,
            Pointer<Integer> tabval, Pointer<Integer> tab38,
            Pointer<Integer> tab14, int lastlineflag) {
        ditherTo2bppLineLow(Pointer.getPeer(lined), w, Pointer.getPeer(bufs1),
                Pointer.getPeer(bufs2), Pointer.getPeer(tabval),
                Pointer.getPeer(tab38), Pointer.getPeer(tab14), lastlineflag);
    }

    protected native static void ditherTo2bppLineLow(@Ptr long lined, int w,
            @Ptr long bufs1, @Ptr long bufs2, @Ptr long tabval,
            @Ptr long tab38, @Ptr long tab14, int lastlineflag);

    /**
     * Original signature :
     * <code>l_int32 make8To2DitherTables(l_int32**, l_int32**, l_int32**, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:909</i>
     */
    public static int make8To2DitherTables(Pointer<Pointer<Integer>> ptabval,
            Pointer<Pointer<Integer>> ptab38, Pointer<Pointer<Integer>> ptab14,
            int cliptoblack, int cliptowhite) {
        return make8To2DitherTables(Pointer.getPeer(ptabval),
                Pointer.getPeer(ptab38), Pointer.getPeer(ptab14), cliptoblack,
                cliptowhite);
    }

    protected native static int make8To2DitherTables(@Ptr long ptabval,
            @Ptr long ptab38, @Ptr long ptab14, int cliptoblack, int cliptowhite);

    /**
     * Original signature :
     * <code>void thresholdTo2bppLow(l_uint32*, l_int32, l_int32, l_uint32*, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:910</i>
     */
    public static void thresholdTo2bppLow(Pointer<Integer> datad, int h,
            int wpld, Pointer<Integer> datas, int wpls, Pointer<Integer> tab) {
        thresholdTo2bppLow(Pointer.getPeer(datad), h, wpld,
                Pointer.getPeer(datas), wpls, Pointer.getPeer(tab));
    }

    protected native static void thresholdTo2bppLow(@Ptr long datad, int h,
            int wpld, @Ptr long datas, int wpls, @Ptr long tab);

    /**
     * Original signature :
     * <code>void thresholdTo4bppLow(l_uint32*, l_int32, l_int32, l_uint32*, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:911</i>
     */
    public static void thresholdTo4bppLow(Pointer<Integer> datad, int h,
            int wpld, Pointer<Integer> datas, int wpls, Pointer<Integer> tab) {
        thresholdTo4bppLow(Pointer.getPeer(datad), h, wpld,
                Pointer.getPeer(datas), wpls, Pointer.getPeer(tab));
    }

    protected native static void thresholdTo4bppLow(@Ptr long datad, int h,
            int wpld, @Ptr long datas, int wpls, @Ptr long tab);

    /**
     * Original signature : <code>L_HEAP* lheapCreate(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:912</i>
     */
    public static Pointer<L_Heap> lheapCreate(int nalloc, int direction) {
        return (Pointer) Pointer.pointerToAddress(
                lheapCreate$2(nalloc, direction), L_Heap.class);
    }

    @Ptr
    @Name("lheapCreate")
    protected native static long lheapCreate$2(int nalloc, int direction) throws LastError;

    /**
     * Original signature : <code>void lheapDestroy(L_HEAP**, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:913</i>
     */
    public static void lheapDestroy(Pointer<Pointer<L_Heap>> plh, int freeflag) {
        lheapDestroy(Pointer.getPeer(plh), freeflag);
    }

    protected native static void lheapDestroy(@Ptr long plh, int freeflag) throws LastError;

    /**
     * Original signature : <code>l_int32 lheapAdd(L_HEAP*, void*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:914</i>
     */
    public static int lheapAdd(Pointer<L_Heap> lh, Pointer<?> item) {
        return lheapAdd(Pointer.getPeer(lh), Pointer.getPeer(item));
    }

    protected native static int lheapAdd(@Ptr long lh, @Ptr long item) throws LastError;

    /**
     * Original signature : <code>void* lheapRemove(L_HEAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:915</i>
     */
    public static Pointer<?> lheapRemove(Pointer<L_Heap> lh) {
        return Pointer.pointerToAddress(lheapRemove(Pointer.getPeer(lh)));
    }

    @Ptr
    protected native static long lheapRemove(@Ptr long lh) throws LastError;

    /**
     * Original signature : <code>l_int32 lheapGetCount(L_HEAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:916</i>
     */
    public static int lheapGetCount(Pointer<L_Heap> lh) {
        return lheapGetCount(Pointer.getPeer(lh));
    }

    protected native static int lheapGetCount(@Ptr long lh) throws LastError;

    /**
     * Original signature : <code>l_int32 lheapSwapUp(L_HEAP*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:917</i>
     */
    public static int lheapSwapUp(Pointer<L_Heap> lh, int index) {
        return lheapSwapUp(Pointer.getPeer(lh), index);
    }

    protected native static int lheapSwapUp(@Ptr long lh, int index) throws LastError;

    /**
     * Original signature : <code>l_int32 lheapSwapDown(L_HEAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:918</i>
     */
    public static int lheapSwapDown(Pointer<L_Heap> lh) {
        return lheapSwapDown(Pointer.getPeer(lh));
    }

    protected native static int lheapSwapDown(@Ptr long lh) throws LastError;

    /**
     * Original signature : <code>l_int32 lheapSort(L_HEAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:919</i>
     */
    public static int lheapSort(Pointer<L_Heap> lh) {
        return lheapSort(Pointer.getPeer(lh));
    }

    protected native static int lheapSort(@Ptr long lh) throws LastError;

    /**
     * Original signature : <code>l_int32 lheapSortStrictOrder(L_HEAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:920</i>
     */
    public static int lheapSortStrictOrder(Pointer<L_Heap> lh) {
        return lheapSortStrictOrder(Pointer.getPeer(lh));
    }

    protected native static int lheapSortStrictOrder(@Ptr long lh) throws LastError;

    /**
     * Original signature : <code>l_int32 lheapPrint(FILE*, L_HEAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:921</i>
     */
    public static int lheapPrint(Pointer<FILE> fp,
            Pointer<L_Heap> lh) {
        return lheapPrint(Pointer.getPeer(fp), Pointer.getPeer(lh));
    }

    protected native static int lheapPrint(@Ptr long fp, @Ptr long lh) throws LastError;

    /**
     * Original signature :
     * <code>JBCLASSER* jbRankHausInit(l_int32, l_int32, l_int32, l_int32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:922</i>
     */
    public static Pointer<JbClasser> jbRankHausInit(int components,
            int maxwidth, int maxheight, int size, float rank) {
        return (Pointer) Pointer.pointerToAddress(
                jbRankHausInit$2(components, maxwidth, maxheight, size, rank),
                JbClasser.class);
    }

    @Ptr
    @Name("jbRankHausInit")
    protected native static long jbRankHausInit$2(int components, int maxwidth,
            int maxheight, int size, float rank);

    /**
     * Original signature :
     * <code>JBCLASSER* jbCorrelationInit(l_int32, l_int32, l_int32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:923</i>
     */
    public static Pointer<JbClasser> jbCorrelationInit(int components,
            int maxwidth, int maxheight, float thresh, float weightfactor) {
        return (Pointer) Pointer.pointerToAddress(
                jbCorrelationInit$2(components, maxwidth, maxheight, thresh,
                        weightfactor), JbClasser.class);
    }

    @Ptr
    @Name("jbCorrelationInit")
    protected native static long jbCorrelationInit$2(int components,
            int maxwidth, int maxheight, float thresh, float weightfactor);

    /**
     * Original signature :
     * <code>JBCLASSER* jbCorrelationInitWithoutComponents(l_int32, l_int32, l_int32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:924</i>
     */
    public static Pointer<JbClasser> jbCorrelationInitWithoutComponents(
            int components, int maxwidth, int maxheight, float thresh,
            float weightfactor) {
        return (Pointer) Pointer.pointerToAddress(
                jbCorrelationInitWithoutComponents$2(components, maxwidth,
                        maxheight, thresh, weightfactor), JbClasser.class);
    }

    @Ptr
    @Name("jbCorrelationInitWithoutComponents")
    protected native static long jbCorrelationInitWithoutComponents$2(
            int components, int maxwidth, int maxheight, float thresh,
            float weightfactor);

    /**
     * Original signature : <code>l_int32 jbAddPages(JBCLASSER*, SARRAY*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:925</i>
     */
    public static int jbAddPages(Pointer<JbClasser> classer,
            Pointer<Sarray> safiles) {
        return jbAddPages(Pointer.getPeer(classer), Pointer.getPeer(safiles));
    }

    protected native static int jbAddPages(@Ptr long classer, @Ptr long safiles) throws LastError;

    /**
     * Original signature : <code>l_int32 jbAddPage(JBCLASSER*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:926</i>
     */
    public static int jbAddPage(Pointer<JbClasser> classer, Pointer<Pix> pixs) {
        return jbAddPage(Pointer.getPeer(classer), Pointer.getPeer(pixs));
    }

    protected native static int jbAddPage(@Ptr long classer, @Ptr long pixs) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 jbAddPageComponents(JBCLASSER*, PIX*, BOXA*, PIXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:927</i>
     */
    public static int jbAddPageComponents(Pointer<JbClasser> classer,
            Pointer<Pix> pixs, Pointer<Boxa> boxas, Pointer<Pixa> pixas) {
        return jbAddPageComponents(Pointer.getPeer(classer),
                Pointer.getPeer(pixs), Pointer.getPeer(boxas),
                Pointer.getPeer(pixas));
    }

    protected native static int jbAddPageComponents(@Ptr long classer,
            @Ptr long pixs, @Ptr long boxas, @Ptr long pixas);

    /**
     * Original signature :
     * <code>l_int32 jbClassifyRankHaus(JBCLASSER*, BOXA*, PIXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:928</i>
     */
    public static int jbClassifyRankHaus(Pointer<JbClasser> classer,
            Pointer<Boxa> boxa, Pointer<Pixa> pixas) {
        return jbClassifyRankHaus(Pointer.getPeer(classer),
                Pointer.getPeer(boxa), Pointer.getPeer(pixas));
    }

    protected native static int jbClassifyRankHaus(@Ptr long classer,
            @Ptr long boxa, @Ptr long pixas);

    /**
     * Original signature :
     * <code>l_int32 pixHaustest(PIX*, PIX*, PIX*, PIX*, l_float32, l_float32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:929</i>
     */
    public static int pixHaustest(Pointer<Pix> pix1, Pointer<Pix> pix2,
            Pointer<Pix> pix3, Pointer<Pix> pix4, float delx, float dely,
            int maxdiffw, int maxdiffh) {
        return pixHaustest(Pointer.getPeer(pix1), Pointer.getPeer(pix2),
                Pointer.getPeer(pix3), Pointer.getPeer(pix4), delx, dely,
                maxdiffw, maxdiffh);
    }

    protected native static int pixHaustest(@Ptr long pix1, @Ptr long pix2,
            @Ptr long pix3, @Ptr long pix4, float delx, float dely,
            int maxdiffw, int maxdiffh);

    /**
     * Original signature :
     * <code>l_int32 pixRankHaustest(PIX*, PIX*, PIX*, PIX*, l_float32, l_float32, l_int32, l_int32, l_int32, l_int32, l_float32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:930</i>
     */
    public static int pixRankHaustest(Pointer<Pix> pix1, Pointer<Pix> pix2,
            Pointer<Pix> pix3, Pointer<Pix> pix4, float delx, float dely,
            int maxdiffw, int maxdiffh, int area1, int area3, float rank,
            Pointer<Integer> tab8) {
        return pixRankHaustest(Pointer.getPeer(pix1), Pointer.getPeer(pix2),
                Pointer.getPeer(pix3), Pointer.getPeer(pix4), delx, dely,
                maxdiffw, maxdiffh, area1, area3, rank, Pointer.getPeer(tab8));
    }

    protected native static int pixRankHaustest(@Ptr long pix1, @Ptr long pix2,
            @Ptr long pix3, @Ptr long pix4, float delx, float dely,
            int maxdiffw, int maxdiffh, int area1, int area3, float rank,
            @Ptr long tab8);

    /**
     * Original signature :
     * <code>l_int32 jbClassifyCorrelation(JBCLASSER*, BOXA*, PIXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:931</i>
     */
    public static int jbClassifyCorrelation(Pointer<JbClasser> classer,
            Pointer<Boxa> boxa, Pointer<Pixa> pixas) {
        return jbClassifyCorrelation(Pointer.getPeer(classer),
                Pointer.getPeer(boxa), Pointer.getPeer(pixas));
    }

    protected native static int jbClassifyCorrelation(@Ptr long classer,
            @Ptr long boxa, @Ptr long pixas);

    /**
     * Original signature :
     * <code>l_int32 jbGetComponents(PIX*, l_int32, l_int32, l_int32, BOXA**, PIXA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:932</i>
     */
    public static int jbGetComponents(Pointer<Pix> pixs, int components,
            int maxwidth, int maxheight, Pointer<Pointer<Boxa>> pboxad,
            Pointer<Pointer<Pixa>> ppixad) {
        return jbGetComponents(Pointer.getPeer(pixs), components, maxwidth,
                maxheight, Pointer.getPeer(pboxad), Pointer.getPeer(ppixad));
    }

    protected native static int jbGetComponents(@Ptr long pixs, int components,
            int maxwidth, int maxheight, @Ptr long pboxad, @Ptr long ppixad);

    /**
     * Original signature :
     * <code>l_int32 pixWordMaskByDilation(PIX*, l_int32, PIX**, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:933</i>
     */
    public static int pixWordMaskByDilation(Pointer<Pix> pixs, int maxdil,
            Pointer<Pointer<Pix>> ppixm, Pointer<Integer> psize) {
        return pixWordMaskByDilation(Pointer.getPeer(pixs), maxdil,
                Pointer.getPeer(ppixm), Pointer.getPeer(psize));
    }

    protected native static int pixWordMaskByDilation(@Ptr long pixs,
            int maxdil, @Ptr long ppixm, @Ptr long psize);

    /**
     * Original signature :
     * <code>l_int32 pixWordBoxesByDilation(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, BOXA**, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:934</i>
     */
    public static int pixWordBoxesByDilation(Pointer<Pix> pixs, int maxdil,
            int minwidth, int minheight, int maxwidth, int maxheight,
            Pointer<Pointer<Boxa>> pboxa, Pointer<Integer> psize) {
        return pixWordBoxesByDilation(Pointer.getPeer(pixs), maxdil, minwidth,
                minheight, maxwidth, maxheight, Pointer.getPeer(pboxa),
                Pointer.getPeer(psize));
    }

    protected native static int pixWordBoxesByDilation(@Ptr long pixs,
            int maxdil, int minwidth, int minheight, int maxwidth,
            int maxheight, @Ptr long pboxa, @Ptr long psize);

    /**
     * Original signature :
     * <code>PIXA* jbAccumulateComposites(PIXAA*, NUMA**, PTA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:935</i>
     */
    public static Pointer<Pixa> jbAccumulateComposites(Pointer<Pixaa> pixaa,
            Pointer<Pointer<Numa>> pna, Pointer<Pointer<Pta>> pptat) {
        return (Pointer) Pointer.pointerToAddress(
                jbAccumulateComposites(Pointer.getPeer(pixaa),
                        Pointer.getPeer(pna), Pointer.getPeer(pptat)),
                Pixa.class);
    }

    @Ptr
    protected native static long jbAccumulateComposites(@Ptr long pixaa,
            @Ptr long pna, @Ptr long pptat);

    /**
     * Original signature :
     * <code>PIXA* jbTemplatesFromComposites(PIXA*, NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:936</i>
     */
    public static Pointer<Pixa> jbTemplatesFromComposites(Pointer<Pixa> pixac,
            Pointer<Numa> na) {
        return (Pointer) Pointer.pointerToAddress(
                jbTemplatesFromComposites(Pointer.getPeer(pixac),
                        Pointer.getPeer(na)), Pixa.class);
    }

    @Ptr
    protected native static long jbTemplatesFromComposites(@Ptr long pixac,
            @Ptr long na);

    /**
     * Original signature :
     * <code>JBCLASSER* jbClasserCreate(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:937</i>
     */
    public static Pointer<JbClasser> jbClasserCreate(int method, int components) {
        return (Pointer) Pointer.pointerToAddress(
                jbClasserCreate$2(method, components), JbClasser.class);
    }

    @Ptr
    @Name("jbClasserCreate")
    protected native static long jbClasserCreate$2(int method, int components) throws LastError;

    /**
     * Original signature : <code>void jbClasserDestroy(JBCLASSER**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:938</i>
     */
    public static void jbClasserDestroy(Pointer<Pointer<JbClasser>> pclasser) {
        jbClasserDestroy(Pointer.getPeer(pclasser));
    }

    protected native static void jbClasserDestroy(@Ptr long pclasser) throws LastError;

    /**
     * Original signature : <code>JBDATA* jbDataSave(JBCLASSER*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:939</i>
     */
    public static Pointer<JbData> jbDataSave(Pointer<JbClasser> classer) {
        return (Pointer) Pointer.pointerToAddress(
                jbDataSave(Pointer.getPeer(classer)), JbData.class);
    }

    @Ptr
    protected native static long jbDataSave(@Ptr long classer) throws LastError;

    /**
     * Original signature : <code>void jbDataDestroy(JBDATA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:940</i>
     */
    public static void jbDataDestroy(Pointer<Pointer<JbData>> pdata) {
        jbDataDestroy(Pointer.getPeer(pdata));
    }

    protected native static void jbDataDestroy(@Ptr long pdata) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 jbDataWrite(const char*, JBDATA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:941</i>
     */
    public static int jbDataWrite(Pointer<Byte> rootout, Pointer<JbData> jbdata) {
        return jbDataWrite(Pointer.getPeer(rootout), Pointer.getPeer(jbdata));
    }

    protected native static int jbDataWrite(@Ptr long rootout, @Ptr long jbdata) throws LastError;

    /**
     * Original signature : <code>JBDATA* jbDataRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:942</i>
     */
    public static Pointer<JbData> jbDataRead(Pointer<Byte> rootname) {
        return (Pointer) Pointer.pointerToAddress(
                jbDataRead(Pointer.getPeer(rootname)), JbData.class);
    }

    @Ptr
    protected native static long jbDataRead(@Ptr long rootname) throws LastError;

    /**
     * Original signature : <code>PIXA* jbDataRender(JBDATA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:943</i>
     */
    public static Pointer<Pixa> jbDataRender(Pointer<JbData> data, int debugflag) {
        return (Pointer) Pointer.pointerToAddress(
                jbDataRender(Pointer.getPeer(data), debugflag), Pixa.class);
    }

    @Ptr
    protected native static long jbDataRender(@Ptr long data, int debugflag) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 jbGetULCorners(JBCLASSER*, PIX*, BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:944</i>
     */
    public static int jbGetULCorners(Pointer<JbClasser> classer,
            Pointer<Pix> pixs, Pointer<Boxa> boxa) {
        return jbGetULCorners(Pointer.getPeer(classer), Pointer.getPeer(pixs),
                Pointer.getPeer(boxa));
    }

    protected native static int jbGetULCorners(@Ptr long classer,
            @Ptr long pixs, @Ptr long boxa);

    /**
     * Original signature : <code>l_int32 jbGetLLCorners(JBCLASSER*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:945</i>
     */
    public static int jbGetLLCorners(Pointer<JbClasser> classer) {
        return jbGetLLCorners(Pointer.getPeer(classer));
    }

    protected native static int jbGetLLCorners(@Ptr long classer) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 readHeaderJp2k(const char*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:946</i>
     */
    public static int readHeaderJp2k(Pointer<Byte> filename,
            Pointer<Integer> pw, Pointer<Integer> ph, Pointer<Integer> pspp) {
        return readHeaderJp2k(Pointer.getPeer(filename), Pointer.getPeer(pw),
                Pointer.getPeer(ph), Pointer.getPeer(pspp));
    }

    protected native static int readHeaderJp2k(@Ptr long filename,
            @Ptr long pw, @Ptr long ph, @Ptr long pspp);

    /**
     * Original signature :
     * <code>l_int32 freadHeaderJp2k(FILE*, l_int32*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:947</i>
     */
    public static int freadHeaderJp2k(Pointer<FILE> fp,
            Pointer<Integer> pw, Pointer<Integer> ph, Pointer<Integer> pspp) {
        return freadHeaderJp2k(Pointer.getPeer(fp), Pointer.getPeer(pw),
                Pointer.getPeer(ph), Pointer.getPeer(pspp));
    }

    protected native static int freadHeaderJp2k(@Ptr long fp, @Ptr long pw,
            @Ptr long ph, @Ptr long pspp);

    /**
     * Original signature :
     * <code>l_int32 sreadHeaderJp2k(const l_uint8*, size_t, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:948</i>
     */
    public static int sreadHeaderJp2k(Pointer<Byte> data, @Ptr long size,
            Pointer<Integer> pw, Pointer<Integer> ph, Pointer<Integer> pspp) {
        return sreadHeaderJp2k(Pointer.getPeer(data), size,
                Pointer.getPeer(pw), Pointer.getPeer(ph), Pointer.getPeer(pspp));
    }

    protected native static int sreadHeaderJp2k(@Ptr long data, @Ptr long size,
            @Ptr long pw, @Ptr long ph, @Ptr long pspp);

    /**
     * Original signature :
     * <code>PIX* pixReadJpeg(const char*, l_int32, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:949</i>
     */
    public static Pointer<Pix> pixReadJpeg(Pointer<Byte> filename, int cmflag,
            int reduction, Pointer<Integer> pnwarn) {
        return (Pointer) Pointer.pointerToAddress(
                pixReadJpeg(Pointer.getPeer(filename), cmflag, reduction,
                        Pointer.getPeer(pnwarn)), Pix.class);
    }

    @Ptr
    protected native static long pixReadJpeg(@Ptr long filename, int cmflag,
            int reduction, @Ptr long pnwarn);

    /**
     * Original signature :
     * <code>PIX* pixReadStreamJpeg(FILE*, l_int32, l_int32, l_int32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:950</i>
     */
    public static Pointer<Pix> pixReadStreamJpeg(
            Pointer<FILE> fp, int cmflag, int reduction,
            Pointer<Integer> pnwarn, int hint) {
        return (Pointer) Pointer.pointerToAddress(
                pixReadStreamJpeg(Pointer.getPeer(fp), cmflag, reduction,
                        Pointer.getPeer(pnwarn), hint), Pix.class);
    }

    @Ptr
    protected native static long pixReadStreamJpeg(@Ptr long fp, int cmflag,
            int reduction, @Ptr long pnwarn, int hint);

    /**
     * Original signature :
     * <code>l_int32 readHeaderJpeg(const char*, l_int32*, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:951</i>
     */
    public static int readHeaderJpeg(Pointer<Byte> filename,
            Pointer<Integer> pw, Pointer<Integer> ph, Pointer<Integer> pspp,
            Pointer<Integer> pycck, Pointer<Integer> pcmyk) {
        return readHeaderJpeg(Pointer.getPeer(filename), Pointer.getPeer(pw),
                Pointer.getPeer(ph), Pointer.getPeer(pspp),
                Pointer.getPeer(pycck), Pointer.getPeer(pcmyk));
    }

    protected native static int readHeaderJpeg(@Ptr long filename,
            @Ptr long pw, @Ptr long ph, @Ptr long pspp, @Ptr long pycck,
            @Ptr long pcmyk);

    /**
     * Original signature :
     * <code>l_int32 freadHeaderJpeg(FILE*, l_int32*, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:952</i>
     */
    public static int freadHeaderJpeg(Pointer<FILE> fp,
            Pointer<Integer> pw, Pointer<Integer> ph, Pointer<Integer> pspp,
            Pointer<Integer> pycck, Pointer<Integer> pcmyk) {
        return freadHeaderJpeg(Pointer.getPeer(fp), Pointer.getPeer(pw),
                Pointer.getPeer(ph), Pointer.getPeer(pspp),
                Pointer.getPeer(pycck), Pointer.getPeer(pcmyk));
    }

    protected native static int freadHeaderJpeg(@Ptr long fp, @Ptr long pw,
            @Ptr long ph, @Ptr long pspp, @Ptr long pycck, @Ptr long pcmyk);

    /**
     * Original signature :
     * <code>l_int32 fgetJpegResolution(FILE*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:953</i>
     */
    public static int fgetJpegResolution(Pointer<FILE> fp,
            Pointer<Integer> pxres, Pointer<Integer> pyres) {
        return fgetJpegResolution(Pointer.getPeer(fp), Pointer.getPeer(pxres),
                Pointer.getPeer(pyres));
    }

    protected native static int fgetJpegResolution(@Ptr long fp,
            @Ptr long pxres, @Ptr long pyres);

    /**
     * Original signature :
     * <code>l_int32 fgetJpegComment(FILE*, l_uint8**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:954</i>
     */
    public static int fgetJpegComment(Pointer<FILE> fp,
            Pointer<Pointer<Byte>> pcomment) {
        return fgetJpegComment(Pointer.getPeer(fp), Pointer.getPeer(pcomment));
    }

    protected native static int fgetJpegComment(@Ptr long fp, @Ptr long pcomment) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixWriteJpeg(const char*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:955</i>
     */
    public static int pixWriteJpeg(Pointer<Byte> filename, Pointer<Pix> pix,
            int quality, int progressive) {
        return pixWriteJpeg(Pointer.getPeer(filename), Pointer.getPeer(pix),
                quality, progressive);
    }

    protected native static int pixWriteJpeg(@Ptr long filename, @Ptr long pix,
            int quality, int progressive);

    /**
     * Original signature :
     * <code>l_int32 pixWriteStreamJpeg(FILE*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:956</i>
     */
    public static int pixWriteStreamJpeg(Pointer<FILE> fp,
            Pointer<Pix> pix, int quality, int progressive) {
        return pixWriteStreamJpeg(Pointer.getPeer(fp), Pointer.getPeer(pix),
                quality, progressive);
    }

    protected native static int pixWriteStreamJpeg(@Ptr long fp, @Ptr long pix,
            int quality, int progressive);

    /**
     * Original signature :
     * <code>PIX* pixReadMemJpeg(const l_uint8*, size_t, l_int32, l_int32, l_int32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:957</i>
     */
    public static Pointer<Pix> pixReadMemJpeg(Pointer<Byte> cdata,
            @Ptr long size, int cmflag, int reduction, Pointer<Integer> pnwarn,
            int hint) {
        return (Pointer) Pointer.pointerToAddress(
                pixReadMemJpeg(Pointer.getPeer(cdata), size, cmflag, reduction,
                        Pointer.getPeer(pnwarn), hint), Pix.class);
    }

    @Ptr
    protected native static long pixReadMemJpeg(@Ptr long cdata,
            @Ptr long size, int cmflag, int reduction, @Ptr long pnwarn,
            int hint);

    /**
     * Original signature :
     * <code>l_int32 readHeaderMemJpeg(const l_uint8*, size_t, l_int32*, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:958</i>
     */
    public static int readHeaderMemJpeg(Pointer<Byte> cdata, @Ptr long size,
            Pointer<Integer> pw, Pointer<Integer> ph, Pointer<Integer> pspp,
            Pointer<Integer> pycck, Pointer<Integer> pcmyk) {
        return readHeaderMemJpeg(Pointer.getPeer(cdata), size,
                Pointer.getPeer(pw), Pointer.getPeer(ph),
                Pointer.getPeer(pspp), Pointer.getPeer(pycck),
                Pointer.getPeer(pcmyk));
    }

    protected native static int readHeaderMemJpeg(@Ptr long cdata,
            @Ptr long size, @Ptr long pw, @Ptr long ph, @Ptr long pspp,
            @Ptr long pycck, @Ptr long pcmyk);

    /**
     * Original signature :
     * <code>l_int32 pixWriteMemJpeg(l_uint8**, size_t*, PIX*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:959</i>
     */
    public static int pixWriteMemJpeg(Pointer<Pointer<Byte>> pdata,
            Pointer<SizeT> psize, Pointer<Pix> pix, int quality, int progressive) {
        return pixWriteMemJpeg(Pointer.getPeer(pdata), Pointer.getPeer(psize),
                Pointer.getPeer(pix), quality, progressive);
    }

    protected native static int pixWriteMemJpeg(@Ptr long pdata,
            @Ptr long psize, @Ptr long pix, int quality, int progressive);

    /**
     * Original signature :
     * <code>l_int32 pixSetChromaSampling(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:960</i>
     */
    public static int pixSetChromaSampling(Pointer<Pix> pix, int sampling) {
        return pixSetChromaSampling(Pointer.getPeer(pix), sampling);
    }

    protected native static int pixSetChromaSampling(@Ptr long pix, int sampling) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 extractJpegDataFromFile(const char*, l_uint8**, size_t*, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:961</i>
     */
    public static int extractJpegDataFromFile(Pointer<Byte> filein,
            Pointer<Pointer<Byte>> pdata, Pointer<SizeT> pnbytes,
            Pointer<Integer> pw, Pointer<Integer> ph, Pointer<Integer> pbps,
            Pointer<Integer> pspp) {
        return extractJpegDataFromFile(Pointer.getPeer(filein),
                Pointer.getPeer(pdata), Pointer.getPeer(pnbytes),
                Pointer.getPeer(pw), Pointer.getPeer(ph),
                Pointer.getPeer(pbps), Pointer.getPeer(pspp));
    }

    protected native static int extractJpegDataFromFile(@Ptr long filein,
            @Ptr long pdata, @Ptr long pnbytes, @Ptr long pw, @Ptr long ph,
            @Ptr long pbps, @Ptr long pspp);

    /**
     * Original signature :
     * <code>l_int32 extractJpegDataFromArray(const void*, size_t, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:962</i>
     */
    public static int extractJpegDataFromArray(Pointer<?> data,
            @Ptr long nbytes, Pointer<Integer> pw, Pointer<Integer> ph,
            Pointer<Integer> pbps, Pointer<Integer> pspp) {
        return extractJpegDataFromArray(Pointer.getPeer(data), nbytes,
                Pointer.getPeer(pw), Pointer.getPeer(ph),
                Pointer.getPeer(pbps), Pointer.getPeer(pspp));
    }

    protected native static int extractJpegDataFromArray(@Ptr long data,
            @Ptr long nbytes, @Ptr long pw, @Ptr long ph, @Ptr long pbps,
            @Ptr long pspp);

    /**
     * Original signature :
     * <code>L_KERNEL* kernelCreate(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:963</i>
     */
    public static Pointer<L_Kernel> kernelCreate(int height, int width) {
        return (Pointer) Pointer.pointerToAddress(
                kernelCreate$2(height, width), L_Kernel.class);
    }

    @Ptr
    @Name("kernelCreate")
    protected native static long kernelCreate$2(int height, int width) throws LastError;

    /**
     * Original signature : <code>void kernelDestroy(L_KERNEL**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:964</i>
     */
    public static void kernelDestroy(Pointer<Pointer<L_Kernel>> pkel) {
        kernelDestroy(Pointer.getPeer(pkel));
    }

    protected native static void kernelDestroy(@Ptr long pkel) throws LastError;

    /**
     * Original signature : <code>L_KERNEL* kernelCopy(L_KERNEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:965</i>
     */
    public static Pointer<L_Kernel> kernelCopy(Pointer<L_Kernel> kels) {
        return (Pointer) Pointer.pointerToAddress(
                kernelCopy(Pointer.getPeer(kels)), L_Kernel.class);
    }

    @Ptr
    protected native static long kernelCopy(@Ptr long kels) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 kernelGetElement(L_KERNEL*, l_int32, l_int32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:966</i>
     */
    public static int kernelGetElement(Pointer<L_Kernel> kel, int row, int col,
            Pointer<Float> pval) {
        return kernelGetElement(Pointer.getPeer(kel), row, col,
                Pointer.getPeer(pval));
    }

    protected native static int kernelGetElement(@Ptr long kel, int row,
            int col, @Ptr long pval);

    /**
     * Original signature :
     * <code>l_int32 kernelSetElement(L_KERNEL*, l_int32, l_int32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:967</i>
     */
    public static int kernelSetElement(Pointer<L_Kernel> kel, int row, int col,
            float val) {
        return kernelSetElement(Pointer.getPeer(kel), row, col, val);
    }

    protected native static int kernelSetElement(@Ptr long kel, int row,
            int col, float val);

    /**
     * Original signature :
     * <code>l_int32 kernelGetParameters(L_KERNEL*, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:968</i>
     */
    public static int kernelGetParameters(Pointer<L_Kernel> kel,
            Pointer<Integer> psy, Pointer<Integer> psx, Pointer<Integer> pcy,
            Pointer<Integer> pcx) {
        return kernelGetParameters(Pointer.getPeer(kel), Pointer.getPeer(psy),
                Pointer.getPeer(psx), Pointer.getPeer(pcy),
                Pointer.getPeer(pcx));
    }

    protected native static int kernelGetParameters(@Ptr long kel,
            @Ptr long psy, @Ptr long psx, @Ptr long pcy, @Ptr long pcx);

    /**
     * Original signature :
     * <code>l_int32 kernelSetOrigin(L_KERNEL*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:969</i>
     */
    public static int kernelSetOrigin(Pointer<L_Kernel> kel, int cy, int cx) {
        return kernelSetOrigin(Pointer.getPeer(kel), cy, cx);
    }

    protected native static int kernelSetOrigin(@Ptr long kel, int cy, int cx) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 kernelGetSum(L_KERNEL*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:970</i>
     */
    public static int kernelGetSum(Pointer<L_Kernel> kel, Pointer<Float> psum) {
        return kernelGetSum(Pointer.getPeer(kel), Pointer.getPeer(psum));
    }

    protected native static int kernelGetSum(@Ptr long kel, @Ptr long psum) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 kernelGetMinMax(L_KERNEL*, l_float32*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:971</i>
     */
    public static int kernelGetMinMax(Pointer<L_Kernel> kel,
            Pointer<Float> pmin, Pointer<Float> pmax) {
        return kernelGetMinMax(Pointer.getPeer(kel), Pointer.getPeer(pmin),
                Pointer.getPeer(pmax));
    }

    protected native static int kernelGetMinMax(@Ptr long kel, @Ptr long pmin,
            @Ptr long pmax);

    /**
     * Original signature :
     * <code>L_KERNEL* kernelNormalize(L_KERNEL*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:972</i>
     */
    public static Pointer<L_Kernel> kernelNormalize(Pointer<L_Kernel> kels,
            float normsum) {
        return (Pointer) Pointer.pointerToAddress(
                kernelNormalize(Pointer.getPeer(kels), normsum), L_Kernel.class);
    }

    @Ptr
    protected native static long kernelNormalize(@Ptr long kels, float normsum) throws LastError;

    /**
     * Original signature : <code>L_KERNEL* kernelInvert(L_KERNEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:973</i>
     */
    public static Pointer<L_Kernel> kernelInvert(Pointer<L_Kernel> kels) {
        return (Pointer) Pointer.pointerToAddress(
                kernelInvert(Pointer.getPeer(kels)), L_Kernel.class);
    }

    @Ptr
    protected native static long kernelInvert(@Ptr long kels) throws LastError;

    /**
     * Original signature :
     * <code>l_float32** create2dFloatArray(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:974</i>
     */
    public static Pointer<Pointer<Float>> create2dFloatArray(int sy, int sx) {
        return (Pointer) Pointer.pointerToAddress(create2dFloatArray$2(sy, sx),
                DefaultParameterizedType.paramType(Pointer.class, Float.class));
    }

    @Ptr
    @Name("create2dFloatArray")
    protected native static long create2dFloatArray$2(int sy, int sx) throws LastError;

    /**
     * Original signature : <code>L_KERNEL* kernelRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:975</i>
     */
    public static Pointer<L_Kernel> kernelRead(Pointer<Byte> fname) {
        return (Pointer) Pointer.pointerToAddress(
                kernelRead(Pointer.getPeer(fname)), L_Kernel.class);
    }

    @Ptr
    protected native static long kernelRead(@Ptr long fname) throws LastError;

    /**
     * Original signature : <code>L_KERNEL* kernelReadStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:976</i>
     */
    public static Pointer<L_Kernel> kernelReadStream(
            Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                kernelReadStream(Pointer.getPeer(fp)), L_Kernel.class);
    }

    @Ptr
    protected native static long kernelReadStream(@Ptr long fp) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 kernelWrite(const char*, L_KERNEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:977</i>
     */
    public static int kernelWrite(Pointer<Byte> fname, Pointer<L_Kernel> kel) {
        return kernelWrite(Pointer.getPeer(fname), Pointer.getPeer(kel));
    }

    protected native static int kernelWrite(@Ptr long fname, @Ptr long kel) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 kernelWriteStream(FILE*, L_KERNEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:978</i>
     */
    public static int kernelWriteStream(Pointer<FILE> fp,
            Pointer<L_Kernel> kel) {
        return kernelWriteStream(Pointer.getPeer(fp), Pointer.getPeer(kel));
    }

    protected native static int kernelWriteStream(@Ptr long fp, @Ptr long kel) throws LastError;

    /**
     * Original signature :
     * <code>L_KERNEL* kernelCreateFromString(l_int32, l_int32, l_int32, l_int32, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:979</i>
     */
    public static Pointer<L_Kernel> kernelCreateFromString(int h, int w,
            int cy, int cx, Pointer<Byte> kdata) {
        return (Pointer) Pointer.pointerToAddress(
                kernelCreateFromString(h, w, cy, cx, Pointer.getPeer(kdata)),
                L_Kernel.class);
    }

    @Ptr
    protected native static long kernelCreateFromString(int h, int w, int cy,
            int cx, @Ptr long kdata);

    /**
     * Original signature :
     * <code>L_KERNEL* kernelCreateFromFile(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:980</i>
     */
    public static Pointer<L_Kernel> kernelCreateFromFile(Pointer<Byte> filename) {
        return (Pointer) Pointer.pointerToAddress(
                kernelCreateFromFile(Pointer.getPeer(filename)), L_Kernel.class);
    }

    @Ptr
    protected native static long kernelCreateFromFile(@Ptr long filename) throws LastError;

    /**
     * Original signature :
     * <code>L_KERNEL* kernelCreateFromPix(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:981</i>
     */
    public static Pointer<L_Kernel> kernelCreateFromPix(Pointer<Pix> pix,
            int cy, int cx) {
        return (Pointer) Pointer.pointerToAddress(
                kernelCreateFromPix(Pointer.getPeer(pix), cy, cx),
                L_Kernel.class);
    }

    @Ptr
    protected native static long kernelCreateFromPix(@Ptr long pix, int cy,
            int cx);

    /**
     * Original signature :
     * <code>PIX* kernelDisplayInPix(L_KERNEL*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:982</i>
     */
    public static Pointer<Pix> kernelDisplayInPix(Pointer<L_Kernel> kel,
            int size, int gthick) {
        return (Pointer) Pointer.pointerToAddress(
                kernelDisplayInPix(Pointer.getPeer(kel), size, gthick),
                Pix.class);
    }

    @Ptr
    protected native static long kernelDisplayInPix(@Ptr long kel, int size,
            int gthick);

    /**
     * Original signature :
     * <code>NUMA* parseStringForNumbers(const char*, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:983</i>
     */
    public static Pointer<Numa> parseStringForNumbers(Pointer<Byte> str,
            Pointer<Byte> seps) {
        return (Pointer) Pointer.pointerToAddress(
                parseStringForNumbers(Pointer.getPeer(str),
                        Pointer.getPeer(seps)), Numa.class);
    }

    @Ptr
    protected native static long parseStringForNumbers(@Ptr long str,
            @Ptr long seps);

    /**
     * Original signature :
     * <code>L_KERNEL* makeFlatKernel(l_int32, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:984</i>
     */
    public static Pointer<L_Kernel> makeFlatKernel(int height, int width,
            int cy, int cx) {
        return (Pointer) Pointer.pointerToAddress(
                makeFlatKernel$2(height, width, cy, cx), L_Kernel.class);
    }

    @Ptr
    @Name("makeFlatKernel")
    protected native static long makeFlatKernel$2(int height, int width,
            int cy, int cx);

    /**
     * Original signature :
     * <code>L_KERNEL* makeGaussianKernel(l_int32, l_int32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:985</i>
     */
    public static Pointer<L_Kernel> makeGaussianKernel(int halfheight,
            int halfwidth, float stdev, float max) {
        return (Pointer) Pointer.pointerToAddress(
                makeGaussianKernel$2(halfheight, halfwidth, stdev, max),
                L_Kernel.class);
    }

    @Ptr
    @Name("makeGaussianKernel")
    protected native static long makeGaussianKernel$2(int halfheight,
            int halfwidth, float stdev, float max);

    /**
     * Original signature :
     * <code>l_int32 makeGaussianKernelSep(l_int32, l_int32, l_float32, l_float32, L_KERNEL**, L_KERNEL**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:986</i>
     */
    public static int makeGaussianKernelSep(int halfheight, int halfwidth,
            float stdev, float max, Pointer<Pointer<L_Kernel>> pkelx,
            Pointer<Pointer<L_Kernel>> pkely) {
        return makeGaussianKernelSep(halfheight, halfwidth, stdev, max,
                Pointer.getPeer(pkelx), Pointer.getPeer(pkely));
    }

    protected native static int makeGaussianKernelSep(int halfheight,
            int halfwidth, float stdev, float max, @Ptr long pkelx,
            @Ptr long pkely);

    /**
     * Original signature :
     * <code>L_KERNEL* makeDoGKernel(l_int32, l_int32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:987</i>
     */
    public static Pointer<L_Kernel> makeDoGKernel(int halfheight,
            int halfwidth, float stdev, float ratio) {
        return (Pointer) Pointer.pointerToAddress(
                makeDoGKernel$2(halfheight, halfwidth, stdev, ratio),
                L_Kernel.class);
    }

    @Ptr
    @Name("makeDoGKernel")
    protected native static long makeDoGKernel$2(int halfheight, int halfwidth,
            float stdev, float ratio);

    /**
     * Original signature : <code>char* getImagelibVersions()</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:988</i>
     */
    public static Pointer<Byte> getImagelibVersions() {
        return (Pointer) Pointer.pointerToAddress(getImagelibVersions$2(),
                Byte.class);
    }

    @Ptr
    @Name("getImagelibVersions")
    protected native static long getImagelibVersions$2() throws LastError;

    /**
     * Original signature : <code>void listDestroy(DLLIST**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:989</i>
     */
    public static void listDestroy(Pointer<Pointer<DoubleLinkedList>> phead) {
        listDestroy(Pointer.getPeer(phead));
    }

    protected native static void listDestroy(@Ptr long phead) throws LastError;

    /**
     * Original signature : <code>l_int32 listAddToHead(DLLIST**, void*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:990</i>
     */
    public static int listAddToHead(Pointer<Pointer<DoubleLinkedList>> phead,
            Pointer<?> data) {
        return listAddToHead(Pointer.getPeer(phead), Pointer.getPeer(data));
    }

    protected native static int listAddToHead(@Ptr long phead, @Ptr long data) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 listAddToTail(DLLIST**, DLLIST**, void*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:991</i>
     */
    public static int listAddToTail(Pointer<Pointer<DoubleLinkedList>> phead,
            Pointer<Pointer<DoubleLinkedList>> ptail, Pointer<?> data) {
        return listAddToTail(Pointer.getPeer(phead), Pointer.getPeer(ptail),
                Pointer.getPeer(data));
    }

    protected native static int listAddToTail(@Ptr long phead, @Ptr long ptail,
            @Ptr long data);

    /**
     * Original signature :
     * <code>l_int32 listInsertBefore(DLLIST**, DLLIST*, void*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:992</i>
     */
    public static int listInsertBefore(
            Pointer<Pointer<DoubleLinkedList>> phead,
            Pointer<DoubleLinkedList> elem, Pointer<?> data) {
        return listInsertBefore(Pointer.getPeer(phead), Pointer.getPeer(elem),
                Pointer.getPeer(data));
    }

    protected native static int listInsertBefore(@Ptr long phead,
            @Ptr long elem, @Ptr long data);

    /**
     * Original signature :
     * <code>l_int32 listInsertAfter(DLLIST**, DLLIST*, void*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:993</i>
     */
    public static int listInsertAfter(Pointer<Pointer<DoubleLinkedList>> phead,
            Pointer<DoubleLinkedList> elem, Pointer<?> data) {
        return listInsertAfter(Pointer.getPeer(phead), Pointer.getPeer(elem),
                Pointer.getPeer(data));
    }

    protected native static int listInsertAfter(@Ptr long phead,
            @Ptr long elem, @Ptr long data);

    /**
     * Original signature :
     * <code>void* listRemoveElement(DLLIST**, DLLIST*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:994</i>
     */
    public static Pointer<?> listRemoveElement(
            Pointer<Pointer<DoubleLinkedList>> phead,
            Pointer<DoubleLinkedList> elem) {
        return Pointer.pointerToAddress(listRemoveElement(
                Pointer.getPeer(phead), Pointer.getPeer(elem)));
    }

    @Ptr
    protected native static long listRemoveElement(@Ptr long phead,
            @Ptr long elem);

    /**
     * Original signature : <code>void* listRemoveFromHead(DLLIST**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:995</i>
     */
    public static Pointer<?> listRemoveFromHead(
            Pointer<Pointer<DoubleLinkedList>> phead) {
        return Pointer.pointerToAddress(listRemoveFromHead(Pointer.getPeer(phead)));
    }

    @Ptr
    protected native static long listRemoveFromHead(@Ptr long phead) throws LastError;

    /**
     * Original signature :
     * <code>void* listRemoveFromTail(DLLIST**, DLLIST**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:996</i>
     */
    public static Pointer<?> listRemoveFromTail(
            Pointer<Pointer<DoubleLinkedList>> phead,
            Pointer<Pointer<DoubleLinkedList>> ptail) {
        return Pointer.pointerToAddress(listRemoveFromTail(
                Pointer.getPeer(phead), Pointer.getPeer(ptail)));
    }

    @Ptr
    protected native static long listRemoveFromTail(@Ptr long phead,
            @Ptr long ptail);

    /**
     * Original signature : <code>DLLIST* listFindElement(DLLIST*, void*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:997</i>
     */
    public static Pointer<DoubleLinkedList> listFindElement(
            Pointer<DoubleLinkedList> head, Pointer<?> data) {
        return (Pointer) Pointer.pointerToAddress(
                listFindElement(Pointer.getPeer(head), Pointer.getPeer(data)),
                DoubleLinkedList.class);
    }

    @Ptr
    protected native static long listFindElement(@Ptr long head, @Ptr long data) throws LastError;

    /**
     * Original signature : <code>DLLIST* listFindTail(DLLIST*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:998</i>
     */
    public static Pointer<DoubleLinkedList> listFindTail(
            Pointer<DoubleLinkedList> head) {
        return (Pointer) Pointer.pointerToAddress(
                listFindTail(Pointer.getPeer(head)), DoubleLinkedList.class);
    }

    @Ptr
    protected native static long listFindTail(@Ptr long head) throws LastError;

    /**
     * Original signature : <code>l_int32 listGetCount(DLLIST*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:999</i>
     */
    public static int listGetCount(Pointer<DoubleLinkedList> head) {
        return listGetCount(Pointer.getPeer(head));
    }

    protected native static int listGetCount(@Ptr long head) throws LastError;

    /**
     * Original signature : <code>l_int32 listReverse(DLLIST**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1000</i>
     */
    public static int listReverse(Pointer<Pointer<DoubleLinkedList>> phead) {
        return listReverse(Pointer.getPeer(phead));
    }

    protected native static int listReverse(@Ptr long phead) throws LastError;

    /**
     * Original signature : <code>l_int32 listJoin(DLLIST**, DLLIST**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1001</i>
     */
    public static int listJoin(Pointer<Pointer<DoubleLinkedList>> phead1,
            Pointer<Pointer<DoubleLinkedList>> phead2) {
        return listJoin(Pointer.getPeer(phead1), Pointer.getPeer(phead2));
    }

    protected native static int listJoin(@Ptr long phead1, @Ptr long phead2) throws LastError;

    /**
     * Original signature :
     * <code>PIX* generateBinaryMaze(l_int32, l_int32, l_int32, l_int32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1002</i>
     */
    public static Pointer<Pix> generateBinaryMaze(int w, int h, int xi, int yi,
            float wallps, float ranis) {
        return (Pointer) Pointer.pointerToAddress(
                generateBinaryMaze$2(w, h, xi, yi, wallps, ranis), Pix.class);
    }

    @Ptr
    @Name("generateBinaryMaze")
    protected native static long generateBinaryMaze$2(int w, int h, int xi,
            int yi, float wallps, float ranis);

    /**
     * Original signature :
     * <code>PTA* pixSearchBinaryMaze(PIX*, l_int32, l_int32, l_int32, l_int32, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1003</i>
     */
    public static Pointer<Pta> pixSearchBinaryMaze(Pointer<Pix> pixs, int xi,
            int yi, int xf, int yf, Pointer<Pointer<Pix>> ppixd) {
        return (Pointer) Pointer.pointerToAddress(
                pixSearchBinaryMaze(Pointer.getPeer(pixs), xi, yi, xf, yf,
                        Pointer.getPeer(ppixd)), Pta.class);
    }

    @Ptr
    protected native static long pixSearchBinaryMaze(@Ptr long pixs, int xi,
            int yi, int xf, int yf, @Ptr long ppixd);

    /**
     * Original signature :
     * <code>PTA* pixSearchGrayMaze(PIX*, l_int32, l_int32, l_int32, l_int32, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1004</i>
     */
    public static Pointer<Pta> pixSearchGrayMaze(Pointer<Pix> pixs, int xi,
            int yi, int xf, int yf, Pointer<Pointer<Pix>> ppixd) {
        return (Pointer) Pointer.pointerToAddress(
                pixSearchGrayMaze(Pointer.getPeer(pixs), xi, yi, xf, yf,
                        Pointer.getPeer(ppixd)), Pta.class);
    }

    @Ptr
    protected native static long pixSearchGrayMaze(@Ptr long pixs, int xi,
            int yi, int xf, int yf, @Ptr long ppixd);

    /**
     * Original signature :
     * <code>l_int32 pixFindLargestRectangle(PIX*, l_int32, BOX**, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1005</i>
     */
    public static int pixFindLargestRectangle(Pointer<Pix> pixs, int polarity,
            Pointer<Pointer<Box>> pbox, Pointer<Byte> debugfile) {
        return pixFindLargestRectangle(Pointer.getPeer(pixs), polarity,
                Pointer.getPeer(pbox), Pointer.getPeer(debugfile));
    }

    protected native static int pixFindLargestRectangle(@Ptr long pixs,
            int polarity, @Ptr long pbox, @Ptr long debugfile);

    /**
     * Original signature : <code>PIX* pixDilate(PIX*, PIX*, SEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1006</i>
     */
    public static Pointer<Pix> pixDilate(Pointer<Pix> pixd, Pointer<Pix> pixs,
            Pointer<SEL> sel) {
        return (Pointer) Pointer.pointerToAddress(
                pixDilate(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        Pointer.getPeer(sel)), Pix.class);
    }

    @Ptr
    protected native static long pixDilate(@Ptr long pixd, @Ptr long pixs,
            @Ptr long sel);

    /**
     * Original signature : <code>PIX* pixErode(PIX*, PIX*, SEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1007</i>
     */
    public static Pointer<Pix> pixErode(Pointer<Pix> pixd, Pointer<Pix> pixs,
            Pointer<SEL> sel) {
        return (Pointer) Pointer.pointerToAddress(
                pixErode(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        Pointer.getPeer(sel)), Pix.class);
    }

    @Ptr
    protected native static long pixErode(@Ptr long pixd, @Ptr long pixs,
            @Ptr long sel);

    /**
     * Original signature : <code>PIX* pixHMT(PIX*, PIX*, SEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1008</i>
     */
    public static Pointer<Pix> pixHMT(Pointer<Pix> pixd, Pointer<Pix> pixs,
            Pointer<SEL> sel) {
        return (Pointer) Pointer.pointerToAddress(
                pixHMT(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        Pointer.getPeer(sel)), Pix.class);
    }

    @Ptr
    protected native static long pixHMT(@Ptr long pixd, @Ptr long pixs,
            @Ptr long sel);

    /**
     * Original signature : <code>PIX* pixOpen(PIX*, PIX*, SEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1009</i>
     */
    public static Pointer<Pix> pixOpen(Pointer<Pix> pixd, Pointer<Pix> pixs,
            Pointer<SEL> sel) {
        return (Pointer) Pointer.pointerToAddress(
                pixOpen(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        Pointer.getPeer(sel)), Pix.class);
    }

    @Ptr
    protected native static long pixOpen(@Ptr long pixd, @Ptr long pixs,
            @Ptr long sel);

    /**
     * Original signature : <code>PIX* pixClose(PIX*, PIX*, SEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1010</i>
     */
    public static Pointer<Pix> pixClose(Pointer<Pix> pixd, Pointer<Pix> pixs,
            Pointer<SEL> sel) {
        return (Pointer) Pointer.pointerToAddress(
                pixClose(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        Pointer.getPeer(sel)), Pix.class);
    }

    @Ptr
    protected native static long pixClose(@Ptr long pixd, @Ptr long pixs,
            @Ptr long sel);

    /**
     * Original signature : <code>PIX* pixCloseSafe(PIX*, PIX*, SEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1011</i>
     */
    public static Pointer<Pix> pixCloseSafe(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<SEL> sel) {
        return (Pointer) Pointer.pointerToAddress(
                pixCloseSafe(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        Pointer.getPeer(sel)), Pix.class);
    }

    @Ptr
    protected native static long pixCloseSafe(@Ptr long pixd, @Ptr long pixs,
            @Ptr long sel);

    /**
     * Original signature :
     * <code>PIX* pixOpenGeneralized(PIX*, PIX*, SEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1012</i>
     */
    public static Pointer<Pix> pixOpenGeneralized(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<SEL> sel) {
        return (Pointer) Pointer.pointerToAddress(
                pixOpenGeneralized(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), Pointer.getPeer(sel)), Pix.class);
    }

    @Ptr
    protected native static long pixOpenGeneralized(@Ptr long pixd,
            @Ptr long pixs, @Ptr long sel);

    /**
     * Original signature :
     * <code>PIX* pixCloseGeneralized(PIX*, PIX*, SEL*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1013</i>
     */
    public static Pointer<Pix> pixCloseGeneralized(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<SEL> sel) {
        return (Pointer) Pointer.pointerToAddress(
                pixCloseGeneralized(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), Pointer.getPeer(sel)), Pix.class);
    }

    @Ptr
    protected native static long pixCloseGeneralized(@Ptr long pixd,
            @Ptr long pixs, @Ptr long sel);

    /**
     * Original signature :
     * <code>PIX* pixDilateBrick(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1014</i>
     */
    public static Pointer<Pix> pixDilateBrick(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixDilateBrick(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixDilateBrick(@Ptr long pixd, @Ptr long pixs,
            int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixErodeBrick(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1015</i>
     */
    public static Pointer<Pix> pixErodeBrick(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixErodeBrick(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixErodeBrick(@Ptr long pixd, @Ptr long pixs,
            int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixOpenBrick(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1016</i>
     */
    public static Pointer<Pix> pixOpenBrick(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixOpenBrick(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixOpenBrick(@Ptr long pixd, @Ptr long pixs,
            int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixCloseBrick(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1017</i>
     */
    public static Pointer<Pix> pixCloseBrick(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixCloseBrick(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixCloseBrick(@Ptr long pixd, @Ptr long pixs,
            int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixCloseSafeBrick(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1018</i>
     */
    public static Pointer<Pix> pixCloseSafeBrick(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixCloseSafeBrick(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixCloseSafeBrick(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>l_int32 selectComposableSels(l_int32, l_int32, SEL**, SEL**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1019</i>
     */
    public static int selectComposableSels(int size, int direction,
            Pointer<Pointer<SEL>> psel1,
            Pointer<Pointer<SEL>> psel2) {
        return selectComposableSels(size, direction, Pointer.getPeer(psel1),
                Pointer.getPeer(psel2));
    }

    protected native static int selectComposableSels(int size, int direction,
            @Ptr long psel1, @Ptr long psel2);

    /**
     * Original signature :
     * <code>l_int32 selectComposableSizes(l_int32, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1020</i>
     */
    public static int selectComposableSizes(int size,
            Pointer<Integer> pfactor1, Pointer<Integer> pfactor2) {
        return selectComposableSizes(size, Pointer.getPeer(pfactor1),
                Pointer.getPeer(pfactor2));
    }

    protected native static int selectComposableSizes(int size,
            @Ptr long pfactor1, @Ptr long pfactor2);

    /**
     * Original signature :
     * <code>PIX* pixDilateCompBrick(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1021</i>
     */
    public static Pointer<Pix> pixDilateCompBrick(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixDilateCompBrick(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixDilateCompBrick(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixErodeCompBrick(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1022</i>
     */
    public static Pointer<Pix> pixErodeCompBrick(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixErodeCompBrick(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixErodeCompBrick(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixOpenCompBrick(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1023</i>
     */
    public static Pointer<Pix> pixOpenCompBrick(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixOpenCompBrick(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixOpenCompBrick(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixCloseCompBrick(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1024</i>
     */
    public static Pointer<Pix> pixCloseCompBrick(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixCloseCompBrick(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixCloseCompBrick(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixCloseSafeCompBrick(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1025</i>
     */
    public static Pointer<Pix> pixCloseSafeCompBrick(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixCloseSafeCompBrick(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixCloseSafeCompBrick(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>void resetMorphBoundaryCondition(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1026</i>
     */
    public static native void resetMorphBoundaryCondition(int bc) throws LastError;

    /**
     * Original signature :
     * <code>l_uint32 getMorphBorderPixelColor(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1027</i>
     */
    public static native int getMorphBorderPixelColor(int type, int depth) throws LastError;

    /**
     * Original signature : <code>PIX* pixExtractBoundary(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1028</i>
     */
    public static Pointer<Pix> pixExtractBoundary(Pointer<Pix> pixs, int type) {
        return (Pointer) Pointer.pointerToAddress(
                pixExtractBoundary(Pointer.getPeer(pixs), type), Pix.class);
    }

    @Ptr
    protected native static long pixExtractBoundary(@Ptr long pixs, int type) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixMorphSequenceMasked(PIX*, PIX*, const char*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1029</i>
     */
    public static Pointer<Pix> pixMorphSequenceMasked(Pointer<Pix> pixs,
            Pointer<Pix> pixm, Pointer<Byte> sequence, int dispsep) {
        return (Pointer) Pointer.pointerToAddress(
                pixMorphSequenceMasked(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixm), Pointer.getPeer(sequence),
                        dispsep), Pix.class);
    }

    @Ptr
    protected native static long pixMorphSequenceMasked(@Ptr long pixs,
            @Ptr long pixm, @Ptr long sequence, int dispsep);

    /**
     * Original signature :
     * <code>PIX* pixMorphSequenceByComponent(PIX*, const char*, l_int32, l_int32, l_int32, BOXA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1030</i>
     */
    public static Pointer<Pix> pixMorphSequenceByComponent(Pointer<Pix> pixs,
            Pointer<Byte> sequence, int connectivity, int minw, int minh,
            Pointer<Pointer<Boxa>> pboxa) {
        return (Pointer) Pointer.pointerToAddress(
                pixMorphSequenceByComponent(Pointer.getPeer(pixs),
                        Pointer.getPeer(sequence), connectivity, minw, minh,
                        Pointer.getPeer(pboxa)), Pix.class);
    }

    @Ptr
    protected native static long pixMorphSequenceByComponent(@Ptr long pixs,
            @Ptr long sequence, int connectivity, int minw, int minh,
            @Ptr long pboxa);

    /**
     * Original signature :
     * <code>PIXA* pixaMorphSequenceByComponent(PIXA*, const char*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1031</i>
     */
    public static Pointer<Pixa> pixaMorphSequenceByComponent(
            Pointer<Pixa> pixas, Pointer<Byte> sequence, int minw, int minh) {
        return (Pointer) Pointer.pointerToAddress(
                pixaMorphSequenceByComponent(Pointer.getPeer(pixas),
                        Pointer.getPeer(sequence), minw, minh), Pixa.class);
    }

    @Ptr
    protected native static long pixaMorphSequenceByComponent(@Ptr long pixas,
            @Ptr long sequence, int minw, int minh);

    /**
     * Original signature :
     * <code>PIX* pixMorphSequenceByRegion(PIX*, PIX*, const char*, l_int32, l_int32, l_int32, BOXA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1032</i>
     */
    public static Pointer<Pix> pixMorphSequenceByRegion(Pointer<Pix> pixs,
            Pointer<Pix> pixm, Pointer<Byte> sequence, int connectivity,
            int minw, int minh, Pointer<Pointer<Boxa>> pboxa) {
        return (Pointer) Pointer.pointerToAddress(
                pixMorphSequenceByRegion(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixm), Pointer.getPeer(sequence),
                        connectivity, minw, minh, Pointer.getPeer(pboxa)),
                Pix.class);
    }

    @Ptr
    protected native static long pixMorphSequenceByRegion(@Ptr long pixs,
            @Ptr long pixm, @Ptr long sequence, int connectivity, int minw,
            int minh, @Ptr long pboxa);

    /**
     * Original signature :
     * <code>PIXA* pixaMorphSequenceByRegion(PIX*, PIXA*, const char*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1033</i>
     */
    public static Pointer<Pixa> pixaMorphSequenceByRegion(Pointer<Pix> pixs,
            Pointer<Pixa> pixam, Pointer<Byte> sequence, int minw, int minh) {
        return (Pointer) Pointer.pointerToAddress(
                pixaMorphSequenceByRegion(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixam), Pointer.getPeer(sequence),
                        minw, minh), Pixa.class);
    }

    @Ptr
    protected native static long pixaMorphSequenceByRegion(@Ptr long pixs,
            @Ptr long pixam, @Ptr long sequence, int minw, int minh);

    /**
     * Original signature :
     * <code>PIX* pixUnionOfMorphOps(PIX*, SELA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1034</i>
     */
    public static Pointer<Pix> pixUnionOfMorphOps(Pointer<Pix> pixs,
            Pointer<Sela> sela, int type) {
        return (Pointer) Pointer.pointerToAddress(
                pixUnionOfMorphOps(Pointer.getPeer(pixs),
                        Pointer.getPeer(sela), type), Pix.class);
    }

    @Ptr
    protected native static long pixUnionOfMorphOps(@Ptr long pixs,
            @Ptr long sela, int type);

    /**
     * Original signature :
     * <code>PIX* pixIntersectionOfMorphOps(PIX*, SELA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1035</i>
     */
    public static Pointer<Pix> pixIntersectionOfMorphOps(Pointer<Pix> pixs,
            Pointer<Sela> sela, int type) {
        return (Pointer) Pointer.pointerToAddress(
                pixIntersectionOfMorphOps(Pointer.getPeer(pixs),
                        Pointer.getPeer(sela), type), Pix.class);
    }

    @Ptr
    protected native static long pixIntersectionOfMorphOps(@Ptr long pixs,
            @Ptr long sela, int type);

    /**
     * Original signature :
     * <code>PIX* pixSelectiveConnCompFill(PIX*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1036</i>
     */
    public static Pointer<Pix> pixSelectiveConnCompFill(Pointer<Pix> pixs,
            int connectivity, int minw, int minh) {
        return (Pointer) Pointer.pointerToAddress(
                pixSelectiveConnCompFill(Pointer.getPeer(pixs), connectivity,
                        minw, minh), Pix.class);
    }

    @Ptr
    protected native static long pixSelectiveConnCompFill(@Ptr long pixs,
            int connectivity, int minw, int minh);

    /**
     * Original signature :
     * <code>l_int32 pixRemoveMatchedPattern(PIX*, PIX*, PIX*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1037</i>
     */
    public static int pixRemoveMatchedPattern(Pointer<Pix> pixs,
            Pointer<Pix> pixp, Pointer<Pix> pixe, int x0, int y0, int dsize) {
        return pixRemoveMatchedPattern(Pointer.getPeer(pixs),
                Pointer.getPeer(pixp), Pointer.getPeer(pixe), x0, y0, dsize);
    }

    protected native static int pixRemoveMatchedPattern(@Ptr long pixs,
            @Ptr long pixp, @Ptr long pixe, int x0, int y0, int dsize);

    /**
     * Original signature :
     * <code>PIX* pixDisplayMatchedPattern(PIX*, PIX*, PIX*, l_int32, l_int32, l_uint32, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1038</i>
     */
    public static Pointer<Pix> pixDisplayMatchedPattern(Pointer<Pix> pixs,
            Pointer<Pix> pixp, Pointer<Pix> pixe, int x0, int y0, int color,
            float scale, int nlevels) {
        return (Pointer) Pointer.pointerToAddress(
                pixDisplayMatchedPattern(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixp), Pointer.getPeer(pixe), x0, y0,
                        color, scale, nlevels), Pix.class);
    }

    @Ptr
    protected native static long pixDisplayMatchedPattern(@Ptr long pixs,
            @Ptr long pixp, @Ptr long pixe, int x0, int y0, int color,
            float scale, int nlevels);

    /**
     * Original signature :
     * <code>PIX* pixSeedfillMorph(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1039</i>
     */
    public static Pointer<Pix> pixSeedfillMorph(Pointer<Pix> pixs,
            Pointer<Pix> pixm, int maxiters, int connectivity) {
        return (Pointer) Pointer.pointerToAddress(
                pixSeedfillMorph(Pointer.getPeer(pixs), Pointer.getPeer(pixm),
                        maxiters, connectivity), Pix.class);
    }

    @Ptr
    protected native static long pixSeedfillMorph(@Ptr long pixs,
            @Ptr long pixm, int maxiters, int connectivity);

    /**
     * Original signature :
     * <code>NUMA* pixRunHistogramMorph(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1040</i>
     */
    public static Pointer<Numa> pixRunHistogramMorph(Pointer<Pix> pixs,
            int runtype, int direction, int maxsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixRunHistogramMorph(Pointer.getPeer(pixs), runtype, direction,
                        maxsize), Numa.class);
    }

    @Ptr
    protected native static long pixRunHistogramMorph(@Ptr long pixs,
            int runtype, int direction, int maxsize);

    /**
     * Original signature :
     * <code>PIX* pixTophat(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1041</i>
     */
    public static Pointer<Pix> pixTophat(Pointer<Pix> pixs, int hsize,
            int vsize, int type) {
        return (Pointer) Pointer.pointerToAddress(
                pixTophat(Pointer.getPeer(pixs), hsize, vsize, type), Pix.class);
    }

    @Ptr
    protected native static long pixTophat(@Ptr long pixs, int hsize,
            int vsize, int type);

    /**
     * Original signature : <code>PIX* pixHDome(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1042</i>
     */
    public static Pointer<Pix> pixHDome(Pointer<Pix> pixs, int height,
            int connectivity) {
        return (Pointer) Pointer.pointerToAddress(
                pixHDome(Pointer.getPeer(pixs), height, connectivity),
                Pix.class);
    }

    @Ptr
    protected native static long pixHDome(@Ptr long pixs, int height,
            int connectivity);

    /**
     * Original signature :
     * <code>PIX* pixFastTophat(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1043</i>
     */
    public static Pointer<Pix> pixFastTophat(Pointer<Pix> pixs, int xsize,
            int ysize, int type) {
        return (Pointer) Pointer.pointerToAddress(
                pixFastTophat(Pointer.getPeer(pixs), xsize, ysize, type),
                Pix.class);
    }

    @Ptr
    protected native static long pixFastTophat(@Ptr long pixs, int xsize,
            int ysize, int type);

    /**
     * Original signature :
     * <code>PIX* pixMorphGradient(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1044</i>
     */
    public static Pointer<Pix> pixMorphGradient(Pointer<Pix> pixs, int hsize,
            int vsize, int smoothing) {
        return (Pointer) Pointer.pointerToAddress(
                pixMorphGradient(Pointer.getPeer(pixs), hsize, vsize, smoothing),
                Pix.class);
    }

    @Ptr
    protected native static long pixMorphGradient(@Ptr long pixs, int hsize,
            int vsize, int smoothing);

    /**
     * Original signature : <code>PTA* pixaCentroids(PIXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1045</i>
     */
    public static Pointer<Pta> pixaCentroids(Pointer<Pixa> pixa) {
        return (Pointer) Pointer.pointerToAddress(
                pixaCentroids(Pointer.getPeer(pixa)), Pta.class);
    }

    @Ptr
    protected native static long pixaCentroids(@Ptr long pixa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixCentroid(PIX*, l_int32*, l_int32*, l_float32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1046</i>
     */
    public static int pixCentroid(Pointer<Pix> pix, Pointer<Integer> centtab,
            Pointer<Integer> sumtab, Pointer<Float> pxave, Pointer<Float> pyave) {
        return pixCentroid(Pointer.getPeer(pix), Pointer.getPeer(centtab),
                Pointer.getPeer(sumtab), Pointer.getPeer(pxave),
                Pointer.getPeer(pyave));
    }

    protected native static int pixCentroid(@Ptr long pix, @Ptr long centtab,
            @Ptr long sumtab, @Ptr long pxave, @Ptr long pyave);

    /**
     * Original signature :
     * <code>PIX* pixDilateBrickDwa(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1047</i>
     */
    public static Pointer<Pix> pixDilateBrickDwa(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixDilateBrickDwa(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixDilateBrickDwa(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixErodeBrickDwa(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1048</i>
     */
    public static Pointer<Pix> pixErodeBrickDwa(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixErodeBrickDwa(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixErodeBrickDwa(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixOpenBrickDwa(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1049</i>
     */
    public static Pointer<Pix> pixOpenBrickDwa(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixOpenBrickDwa(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixOpenBrickDwa(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixCloseBrickDwa(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1050</i>
     */
    public static Pointer<Pix> pixCloseBrickDwa(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixCloseBrickDwa(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixCloseBrickDwa(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixDilateCompBrickDwa(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1051</i>
     */
    public static Pointer<Pix> pixDilateCompBrickDwa(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixDilateCompBrickDwa(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixDilateCompBrickDwa(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixErodeCompBrickDwa(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1052</i>
     */
    public static Pointer<Pix> pixErodeCompBrickDwa(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixErodeCompBrickDwa(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixErodeCompBrickDwa(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixOpenCompBrickDwa(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1053</i>
     */
    public static Pointer<Pix> pixOpenCompBrickDwa(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixOpenCompBrickDwa(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixOpenCompBrickDwa(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixCloseCompBrickDwa(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1054</i>
     */
    public static Pointer<Pix> pixCloseCompBrickDwa(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixCloseCompBrickDwa(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixCloseCompBrickDwa(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixDilateCompBrickExtendDwa(PIX*, PIX*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1055</i>
     */
    public static Pointer<Pix> pixDilateCompBrickExtendDwa(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixDilateCompBrickExtendDwa(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixDilateCompBrickExtendDwa(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixErodeCompBrickExtendDwa(PIX*, PIX*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1056</i>
     */
    public static Pointer<Pix> pixErodeCompBrickExtendDwa(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixErodeCompBrickExtendDwa(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixErodeCompBrickExtendDwa(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixOpenCompBrickExtendDwa(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1057</i>
     */
    public static Pointer<Pix> pixOpenCompBrickExtendDwa(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixOpenCompBrickExtendDwa(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixOpenCompBrickExtendDwa(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>PIX* pixCloseCompBrickExtendDwa(PIX*, PIX*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1058</i>
     */
    public static Pointer<Pix> pixCloseCompBrickExtendDwa(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int hsize, int vsize) {
        return (Pointer) Pointer.pointerToAddress(
                pixCloseCompBrickExtendDwa(Pointer.getPeer(pixd),
                        Pointer.getPeer(pixs), hsize, vsize), Pix.class);
    }

    @Ptr
    protected native static long pixCloseCompBrickExtendDwa(@Ptr long pixd,
            @Ptr long pixs, int hsize, int vsize);

    /**
     * Original signature :
     * <code>l_int32 getExtendedCompositeParameters(l_int32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1059</i>
     */
    public static int getExtendedCompositeParameters(int size,
            Pointer<Integer> pn, Pointer<Integer> pextra,
            Pointer<Integer> pactualsize) {
        return getExtendedCompositeParameters(size, Pointer.getPeer(pn),
                Pointer.getPeer(pextra), Pointer.getPeer(pactualsize));
    }

    protected native static int getExtendedCompositeParameters(int size,
            @Ptr long pn, @Ptr long pextra, @Ptr long pactualsize);

    /**
     * Original signature :
     * <code>PIX* pixMorphSequence(PIX*, const char*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1060</i>
     */
    public static Pointer<Pix> pixMorphSequence(Pointer<Pix> pixs,
            Pointer<Byte> sequence, int dispsep) {
        return (Pointer) Pointer.pointerToAddress(
                pixMorphSequence(Pointer.getPeer(pixs),
                        Pointer.getPeer(sequence), dispsep), Pix.class);
    }

    @Ptr
    protected native static long pixMorphSequence(@Ptr long pixs,
            @Ptr long sequence, int dispsep);

    /**
     * Original signature :
     * <code>PIX* pixMorphCompSequence(PIX*, const char*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1061</i>
     */
    public static Pointer<Pix> pixMorphCompSequence(Pointer<Pix> pixs,
            Pointer<Byte> sequence, int dispsep) {
        return (Pointer) Pointer.pointerToAddress(
                pixMorphCompSequence(Pointer.getPeer(pixs),
                        Pointer.getPeer(sequence), dispsep), Pix.class);
    }

    @Ptr
    protected native static long pixMorphCompSequence(@Ptr long pixs,
            @Ptr long sequence, int dispsep);

    /**
     * Original signature :
     * <code>PIX* pixMorphSequenceDwa(PIX*, const char*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1062</i>
     */
    public static Pointer<Pix> pixMorphSequenceDwa(Pointer<Pix> pixs,
            Pointer<Byte> sequence, int dispsep) {
        return (Pointer) Pointer.pointerToAddress(
                pixMorphSequenceDwa(Pointer.getPeer(pixs),
                        Pointer.getPeer(sequence), dispsep), Pix.class);
    }

    @Ptr
    protected native static long pixMorphSequenceDwa(@Ptr long pixs,
            @Ptr long sequence, int dispsep);

    /**
     * Original signature :
     * <code>PIX* pixMorphCompSequenceDwa(PIX*, const char*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1063</i>
     */
    public static Pointer<Pix> pixMorphCompSequenceDwa(Pointer<Pix> pixs,
            Pointer<Byte> sequence, int dispsep) {
        return (Pointer) Pointer.pointerToAddress(
                pixMorphCompSequenceDwa(Pointer.getPeer(pixs),
                        Pointer.getPeer(sequence), dispsep), Pix.class);
    }

    @Ptr
    protected native static long pixMorphCompSequenceDwa(@Ptr long pixs,
            @Ptr long sequence, int dispsep);

    /**
     * Original signature : <code>l_int32 morphSequenceVerify(SARRAY*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1064</i>
     */
    public static int morphSequenceVerify(Pointer<Sarray> sa) {
        return morphSequenceVerify(Pointer.getPeer(sa));
    }

    protected native static int morphSequenceVerify(@Ptr long sa) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixGrayMorphSequence(PIX*, const char*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1065</i>
     */
    public static Pointer<Pix> pixGrayMorphSequence(Pointer<Pix> pixs,
            Pointer<Byte> sequence, int dispsep, int dispy) {
        return (Pointer) Pointer.pointerToAddress(
                pixGrayMorphSequence(Pointer.getPeer(pixs),
                        Pointer.getPeer(sequence), dispsep, dispy), Pix.class);
    }

    @Ptr
    protected native static long pixGrayMorphSequence(@Ptr long pixs,
            @Ptr long sequence, int dispsep, int dispy);

    /**
     * Original signature :
     * <code>PIX* pixColorMorphSequence(PIX*, const char*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1066</i>
     */
    public static Pointer<Pix> pixColorMorphSequence(Pointer<Pix> pixs,
            Pointer<Byte> sequence, int dispsep, int dispy) {
        return (Pointer) Pointer.pointerToAddress(
                pixColorMorphSequence(Pointer.getPeer(pixs),
                        Pointer.getPeer(sequence), dispsep, dispy), Pix.class);
    }

    @Ptr
    protected native static long pixColorMorphSequence(@Ptr long pixs,
            @Ptr long sequence, int dispsep, int dispy);

    /**
     * Original signature : <code>NUMA* numaCreate(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1067</i>
     */
    public static Pointer<Numa> numaCreate(int n) {
        return (Pointer) Pointer.pointerToAddress(numaCreate$2(n), Numa.class);
    }

    @Ptr
    @Name("numaCreate")
    protected native static long numaCreate$2(int n) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaCreateFromIArray(l_int32*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1068</i>
     */
    public static Pointer<Numa> numaCreateFromIArray(Pointer<Integer> iarray,
            int size) {
        return (Pointer) Pointer.pointerToAddress(
                numaCreateFromIArray(Pointer.getPeer(iarray), size), Numa.class);
    }

    @Ptr
    protected native static long numaCreateFromIArray(@Ptr long iarray, int size) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaCreateFromFArray(l_float32*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1069</i>
     */
    public static Pointer<Numa> numaCreateFromFArray(Pointer<Float> farray,
            int size, int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                numaCreateFromFArray(Pointer.getPeer(farray), size, copyflag),
                Numa.class);
    }

    @Ptr
    protected native static long numaCreateFromFArray(@Ptr long farray,
            int size, int copyflag);

    /**
     * Original signature : <code>void numaDestroy(NUMA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1070</i>
     */
    public static void numaDestroy(Pointer<Pointer<Numa>> pna) {
        numaDestroy(Pointer.getPeer(pna));
    }

    protected native static void numaDestroy(@Ptr long pna) throws LastError;

    /**
     * Original signature : <code>NUMA* numaCopy(NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1071</i>
     */
    public static Pointer<Numa> numaCopy(Pointer<Numa> na) {
        return (Pointer) Pointer.pointerToAddress(
                numaCopy(Pointer.getPeer(na)), Numa.class);
    }

    @Ptr
    protected native static long numaCopy(@Ptr long na) throws LastError;

    /**
     * Original signature : <code>NUMA* numaClone(NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1072</i>
     */
    public static Pointer<Numa> numaClone(Pointer<Numa> na) {
        return (Pointer) Pointer.pointerToAddress(
                numaClone(Pointer.getPeer(na)), Numa.class);
    }

    @Ptr
    protected native static long numaClone(@Ptr long na) throws LastError;

    /**
     * Original signature : <code>l_int32 numaEmpty(NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1073</i>
     */
    public static int numaEmpty(Pointer<Numa> na) {
        return numaEmpty(Pointer.getPeer(na));
    }

    protected native static int numaEmpty(@Ptr long na) throws LastError;

    /**
     * Original signature : <code>l_int32 numaAddNumber(NUMA*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1074</i>
     */
    public static int numaAddNumber(Pointer<Numa> na, float val) {
        return numaAddNumber(Pointer.getPeer(na), val);
    }

    protected native static int numaAddNumber(@Ptr long na, float val) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaInsertNumber(NUMA*, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1075</i>
     */
    public static int numaInsertNumber(Pointer<Numa> na, int index, float val) {
        return numaInsertNumber(Pointer.getPeer(na), index, val);
    }

    protected native static int numaInsertNumber(@Ptr long na, int index,
            float val);

    /**
     * Original signature :
     * <code>l_int32 numaRemoveNumber(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1076</i>
     */
    public static int numaRemoveNumber(Pointer<Numa> na, int index) {
        return numaRemoveNumber(Pointer.getPeer(na), index);
    }

    protected native static int numaRemoveNumber(@Ptr long na, int index) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaReplaceNumber(NUMA*, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1077</i>
     */
    public static int numaReplaceNumber(Pointer<Numa> na, int index, float val) {
        return numaReplaceNumber(Pointer.getPeer(na), index, val);
    }

    protected native static int numaReplaceNumber(@Ptr long na, int index,
            float val);

    /**
     * Original signature : <code>l_int32 numaGetCount(NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1078</i>
     */
    public static int numaGetCount(Pointer<Numa> na) {
        return numaGetCount(Pointer.getPeer(na));
    }

    protected native static int numaGetCount(@Ptr long na) throws LastError;

    /**
     * Original signature : <code>l_int32 numaSetCount(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1079</i>
     */
    public static int numaSetCount(Pointer<Numa> na, int newcount) {
        return numaSetCount(Pointer.getPeer(na), newcount);
    }

    protected native static int numaSetCount(@Ptr long na, int newcount) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaGetFValue(NUMA*, l_int32, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1080</i>
     */
    public static int numaGetFValue(Pointer<Numa> na, int index,
            Pointer<Float> pval) {
        return numaGetFValue(Pointer.getPeer(na), index, Pointer.getPeer(pval));
    }

    protected native static int numaGetFValue(@Ptr long na, int index,
            @Ptr long pval);

    /**
     * Original signature :
     * <code>l_int32 numaGetIValue(NUMA*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1081</i>
     */
    public static int numaGetIValue(Pointer<Numa> na, int index,
            Pointer<Integer> pival) {
        return numaGetIValue(Pointer.getPeer(na), index, Pointer.getPeer(pival));
    }

    protected native static int numaGetIValue(@Ptr long na, int index,
            @Ptr long pival);

    /**
     * Original signature :
     * <code>l_int32 numaSetValue(NUMA*, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1082</i>
     */
    public static int numaSetValue(Pointer<Numa> na, int index, float val) {
        return numaSetValue(Pointer.getPeer(na), index, val);
    }

    protected native static int numaSetValue(@Ptr long na, int index, float val) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaShiftValue(NUMA*, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1083</i>
     */
    public static int numaShiftValue(Pointer<Numa> na, int index, float diff) {
        return numaShiftValue(Pointer.getPeer(na), index, diff);
    }

    protected native static int numaShiftValue(@Ptr long na, int index,
            float diff);

    /**
     * Original signature : <code>l_int32* numaGetIArray(NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1084</i>
     */
    public static Pointer<Integer> numaGetIArray(Pointer<Numa> na) {
        return (Pointer) Pointer.pointerToAddress(
                numaGetIArray(Pointer.getPeer(na)), Integer.class);
    }

    @Ptr
    protected native static long numaGetIArray(@Ptr long na) throws LastError;

    /**
     * Original signature :
     * <code>l_float32* numaGetFArray(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1085</i>
     */
    public static Pointer<Float> numaGetFArray(Pointer<Numa> na, int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                numaGetFArray(Pointer.getPeer(na), copyflag), Float.class);
    }

    @Ptr
    protected native static long numaGetFArray(@Ptr long na, int copyflag) throws LastError;

    /**
     * Original signature : <code>l_int32 numaGetRefcount(NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1086</i>
     */
    public static int numaGetRefcount(Pointer<Numa> na) {
        return numaGetRefcount(Pointer.getPeer(na));
    }

    protected native static int numaGetRefcount(@Ptr long na) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaChangeRefcount(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1087</i>
     */
    public static int numaChangeRefcount(Pointer<Numa> na, int delta) {
        return numaChangeRefcount(Pointer.getPeer(na), delta);
    }

    protected native static int numaChangeRefcount(@Ptr long na, int delta) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaGetParameters(NUMA*, l_float32*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1088</i>
     */
    public static int numaGetParameters(Pointer<Numa> na,
            Pointer<Float> pstartx, Pointer<Float> pdelx) {
        return numaGetParameters(Pointer.getPeer(na), Pointer.getPeer(pstartx),
                Pointer.getPeer(pdelx));
    }

    protected native static int numaGetParameters(@Ptr long na,
            @Ptr long pstartx, @Ptr long pdelx);

    /**
     * Original signature :
     * <code>l_int32 numaSetParameters(NUMA*, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1089</i>
     */
    public static int numaSetParameters(Pointer<Numa> na, float startx,
            float delx) {
        return numaSetParameters(Pointer.getPeer(na), startx, delx);
    }

    protected native static int numaSetParameters(@Ptr long na, float startx,
            float delx);

    /**
     * Original signature :
     * <code>l_int32 numaCopyParameters(NUMA*, NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1090</i>
     */
    public static int numaCopyParameters(Pointer<Numa> nad, Pointer<Numa> nas) {
        return numaCopyParameters(Pointer.getPeer(nad), Pointer.getPeer(nas));
    }

    protected native static int numaCopyParameters(@Ptr long nad, @Ptr long nas) throws LastError;

    /**
     * Original signature :
     * <code>SARRAY* numaConvertToSarray(NUMA*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1091</i>
     */
    public static Pointer<Sarray> numaConvertToSarray(Pointer<Numa> na,
            int size1, int size2, int addzeros, int type) {
        return (Pointer) Pointer.pointerToAddress(
                numaConvertToSarray(Pointer.getPeer(na), size1, size2,
                        addzeros, type), Sarray.class);
    }

    @Ptr
    protected native static long numaConvertToSarray(@Ptr long na, int size1,
            int size2, int addzeros, int type);

    /**
     * Original signature : <code>NUMA* numaRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1092</i>
     */
    public static Pointer<Numa> numaRead(Pointer<Byte> filename) {
        return (Pointer) Pointer.pointerToAddress(
                numaRead(Pointer.getPeer(filename)), Numa.class);
    }

    @Ptr
    protected native static long numaRead(@Ptr long filename) throws LastError;

    /**
     * Original signature : <code>NUMA* numaReadStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1093</i>
     */
    public static Pointer<Numa> numaReadStream(Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                numaReadStream(Pointer.getPeer(fp)), Numa.class);
    }

    @Ptr
    protected native static long numaReadStream(@Ptr long fp) throws LastError;

    /**
     * Original signature : <code>l_int32 numaWrite(const char*, NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1094</i>
     */
    public static int numaWrite(Pointer<Byte> filename, Pointer<Numa> na) {
        return numaWrite(Pointer.getPeer(filename), Pointer.getPeer(na));
    }

    protected native static int numaWrite(@Ptr long filename, @Ptr long na) throws LastError;

    /**
     * Original signature : <code>l_int32 numaWriteStream(FILE*, NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1095</i>
     */
    public static int numaWriteStream(Pointer<FILE> fp,
            Pointer<Numa> na) {
        return numaWriteStream(Pointer.getPeer(fp), Pointer.getPeer(na));
    }

    protected native static int numaWriteStream(@Ptr long fp, @Ptr long na) throws LastError;

    /**
     * Original signature : <code>NUMAA* numaaCreate(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1096</i>
     */
    public static Pointer<Numaa> numaaCreate(int n) {
        return (Pointer) Pointer.pointerToAddress(numaaCreate$2(n), Numaa.class);
    }

    @Ptr
    @Name("numaaCreate")
    protected native static long numaaCreate$2(int n) throws LastError;

    /**
     * Original signature :
     * <code>NUMAA* numaaCreateFull(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1097</i>
     */
    public static Pointer<Numaa> numaaCreateFull(int ntop, int n) {
        return (Pointer) Pointer.pointerToAddress(numaaCreateFull$2(ntop, n),
                Numaa.class);
    }

    @Ptr
    @Name("numaaCreateFull")
    protected native static long numaaCreateFull$2(int ntop, int n) throws LastError;

    /**
     * Original signature : <code>l_int32 numaaTruncate(NUMAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1098</i>
     */
    public static int numaaTruncate(Pointer<Numaa> naa) {
        return numaaTruncate(Pointer.getPeer(naa));
    }

    protected native static int numaaTruncate(@Ptr long naa) throws LastError;

    /**
     * Original signature : <code>void numaaDestroy(NUMAA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1099</i>
     */
    public static void numaaDestroy(Pointer<Pointer<Numaa>> pnaa) {
        numaaDestroy(Pointer.getPeer(pnaa));
    }

    protected native static void numaaDestroy(@Ptr long pnaa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaaAddNuma(NUMAA*, NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1100</i>
     */
    public static int numaaAddNuma(Pointer<Numaa> naa, Pointer<Numa> na,
            int copyflag) {
        return numaaAddNuma(Pointer.getPeer(naa), Pointer.getPeer(na), copyflag);
    }

    protected native static int numaaAddNuma(@Ptr long naa, @Ptr long na,
            int copyflag);

    /**
     * Original signature : <code>l_int32 numaaExtendArray(NUMAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1101</i>
     */
    public static int numaaExtendArray(Pointer<Numaa> naa) {
        return numaaExtendArray(Pointer.getPeer(naa));
    }

    protected native static int numaaExtendArray(@Ptr long naa) throws LastError;

    /**
     * Original signature : <code>l_int32 numaaGetCount(NUMAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1102</i>
     */
    public static int numaaGetCount(Pointer<Numaa> naa) {
        return numaaGetCount(Pointer.getPeer(naa));
    }

    protected native static int numaaGetCount(@Ptr long naa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaaGetNumaCount(NUMAA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1103</i>
     */
    public static int numaaGetNumaCount(Pointer<Numaa> naa, int index) {
        return numaaGetNumaCount(Pointer.getPeer(naa), index);
    }

    protected native static int numaaGetNumaCount(@Ptr long naa, int index) throws LastError;

    /**
     * Original signature : <code>l_int32 numaaGetNumberCount(NUMAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1104</i>
     */
    public static int numaaGetNumberCount(Pointer<Numaa> naa) {
        return numaaGetNumberCount(Pointer.getPeer(naa));
    }

    protected native static int numaaGetNumberCount(@Ptr long naa) throws LastError;

    /**
     * Original signature : <code>NUMA** numaaGetPtrArray(NUMAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1105</i>
     */
    public static Pointer<Pointer<Numa>> numaaGetPtrArray(Pointer<Numaa> naa) {
        return (Pointer) Pointer.pointerToAddress(
                numaaGetPtrArray(Pointer.getPeer(naa)),
                DefaultParameterizedType.paramType(Pointer.class, Numa.class));
    }

    @Ptr
    protected native static long numaaGetPtrArray(@Ptr long naa) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaaGetNuma(NUMAA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1106</i>
     */
    public static Pointer<Numa> numaaGetNuma(Pointer<Numaa> naa, int index,
            int accessflag) {
        return (Pointer) Pointer.pointerToAddress(
                numaaGetNuma(Pointer.getPeer(naa), index, accessflag),
                Numa.class);
    }

    @Ptr
    protected native static long numaaGetNuma(@Ptr long naa, int index,
            int accessflag);

    /**
     * Original signature :
     * <code>l_int32 numaaReplaceNuma(NUMAA*, l_int32, NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1107</i>
     */
    public static int numaaReplaceNuma(Pointer<Numaa> naa, int index,
            Pointer<Numa> na) {
        return numaaReplaceNuma(Pointer.getPeer(naa), index,
                Pointer.getPeer(na));
    }

    protected native static int numaaReplaceNuma(@Ptr long naa, int index,
            @Ptr long na);

    /**
     * Original signature :
     * <code>l_int32 numaaGetValue(NUMAA*, l_int32, l_int32, l_float32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1108</i>
     */
    public static int numaaGetValue(Pointer<Numaa> naa, int i, int j,
            Pointer<Float> pfval, Pointer<Integer> pival) {
        return numaaGetValue(Pointer.getPeer(naa), i, j,
                Pointer.getPeer(pfval), Pointer.getPeer(pival));
    }

    protected native static int numaaGetValue(@Ptr long naa, int i, int j,
            @Ptr long pfval, @Ptr long pival);

    /**
     * Original signature :
     * <code>l_int32 numaaAddNumber(NUMAA*, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1109</i>
     */
    public static int numaaAddNumber(Pointer<Numaa> naa, int index, float val) {
        return numaaAddNumber(Pointer.getPeer(naa), index, val);
    }

    protected native static int numaaAddNumber(@Ptr long naa, int index,
            float val);

    /**
     * Original signature : <code>NUMAA* numaaRead(const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1110</i>
     */
    public static Pointer<Numaa> numaaRead(Pointer<Byte> filename) {
        return (Pointer) Pointer.pointerToAddress(
                numaaRead(Pointer.getPeer(filename)), Numaa.class);
    }

    @Ptr
    protected native static long numaaRead(@Ptr long filename) throws LastError;

    /**
     * Original signature : <code>NUMAA* numaaReadStream(FILE*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1111</i>
     */
    public static Pointer<Numaa> numaaReadStream(
            Pointer<FILE> fp) {
        return (Pointer) Pointer.pointerToAddress(
                numaaReadStream(Pointer.getPeer(fp)), Numaa.class);
    }

    @Ptr
    protected native static long numaaReadStream(@Ptr long fp) throws LastError;

    /**
     * Original signature : <code>l_int32 numaaWrite(const char*, NUMAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1112</i>
     */
    public static int numaaWrite(Pointer<Byte> filename, Pointer<Numaa> naa) {
        return numaaWrite(Pointer.getPeer(filename), Pointer.getPeer(naa));
    }

    protected native static int numaaWrite(@Ptr long filename, @Ptr long naa) throws LastError;

    /**
     * Original signature : <code>l_int32 numaaWriteStream(FILE*, NUMAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1113</i>
     */
    public static int numaaWriteStream(Pointer<FILE> fp,
            Pointer<Numaa> naa) {
        return numaaWriteStream(Pointer.getPeer(fp), Pointer.getPeer(naa));
    }

    protected native static int numaaWriteStream(@Ptr long fp, @Ptr long naa) throws LastError;

    /**
     * Original signature :
     * <code>NUMA2D* numa2dCreate(l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1114</i>
     */
    public static Pointer<Numa2d> numa2dCreate(int nrows, int ncols,
            int initsize) {
        return (Pointer) Pointer.pointerToAddress(
                numa2dCreate$2(nrows, ncols, initsize), Numa2d.class);
    }

    @Ptr
    @Name("numa2dCreate")
    protected native static long numa2dCreate$2(int nrows, int ncols,
            int initsize);

    /**
     * Original signature : <code>void numa2dDestroy(NUMA2D**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1115</i>
     */
    public static void numa2dDestroy(Pointer<Pointer<Numa2d>> pna2d) {
        numa2dDestroy(Pointer.getPeer(pna2d));
    }

    protected native static void numa2dDestroy(@Ptr long pna2d) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numa2dAddNumber(NUMA2D*, l_int32, l_int32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1116</i>
     */
    public static int numa2dAddNumber(Pointer<Numa2d> na2d, int row, int col,
            float val) {
        return numa2dAddNumber(Pointer.getPeer(na2d), row, col, val);
    }

    protected native static int numa2dAddNumber(@Ptr long na2d, int row,
            int col, float val);

    /**
     * Original signature :
     * <code>l_int32 numa2dGetCount(NUMA2D*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1117</i>
     */
    public static int numa2dGetCount(Pointer<Numa2d> na2d, int row, int col) {
        return numa2dGetCount(Pointer.getPeer(na2d), row, col);
    }

    protected native static int numa2dGetCount(@Ptr long na2d, int row, int col) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numa2dGetNuma(NUMA2D*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1118</i>
     */
    public static Pointer<Numa> numa2dGetNuma(Pointer<Numa2d> na2d, int row,
            int col) {
        return (Pointer) Pointer.pointerToAddress(
                numa2dGetNuma(Pointer.getPeer(na2d), row, col), Numa.class);
    }

    @Ptr
    protected native static long numa2dGetNuma(@Ptr long na2d, int row, int col) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numa2dGetFValue(NUMA2D*, l_int32, l_int32, l_int32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1119</i>
     */
    public static int numa2dGetFValue(Pointer<Numa2d> na2d, int row, int col,
            int index, Pointer<Float> pval) {
        return numa2dGetFValue(Pointer.getPeer(na2d), row, col, index,
                Pointer.getPeer(pval));
    }

    protected native static int numa2dGetFValue(@Ptr long na2d, int row,
            int col, int index, @Ptr long pval);

    /**
     * Original signature :
     * <code>l_int32 numa2dGetIValue(NUMA2D*, l_int32, l_int32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1120</i>
     */
    public static int numa2dGetIValue(Pointer<Numa2d> na2d, int row, int col,
            int index, Pointer<Integer> pval) {
        return numa2dGetIValue(Pointer.getPeer(na2d), row, col, index,
                Pointer.getPeer(pval));
    }

    protected native static int numa2dGetIValue(@Ptr long na2d, int row,
            int col, int index, @Ptr long pval);

    /**
     * Original signature :
     * <code>NUMAHASH* numaHashCreate(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1121</i>
     */
    public static Pointer<NumaHash> numaHashCreate(int nbuckets, int initsize) {
        return (Pointer) Pointer.pointerToAddress(
                numaHashCreate$2(nbuckets, initsize), NumaHash.class);
    }

    @Ptr
    @Name("numaHashCreate")
    protected native static long numaHashCreate$2(int nbuckets, int initsize) throws LastError;

    /**
     * Original signature : <code>void numaHashDestroy(NUMAHASH**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1122</i>
     */
    public static void numaHashDestroy(Pointer<Pointer<NumaHash>> pnahash) {
        numaHashDestroy(Pointer.getPeer(pnahash));
    }

    protected native static void numaHashDestroy(@Ptr long pnahash) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaHashGetNuma(NUMAHASH*, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1123</i>
     */
    public static Pointer<Numa> numaHashGetNuma(Pointer<NumaHash> nahash,
            int key) {
        return (Pointer) Pointer.pointerToAddress(
                numaHashGetNuma(Pointer.getPeer(nahash), key), Numa.class);
    }

    @Ptr
    protected native static long numaHashGetNuma(@Ptr long nahash, int key) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaHashAdd(NUMAHASH*, l_uint32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1124</i>
     */
    public static int numaHashAdd(Pointer<NumaHash> nahash, int key, float value) {
        return numaHashAdd(Pointer.getPeer(nahash), key, value);
    }

    protected native static int numaHashAdd(@Ptr long nahash, int key,
            float value);

    /**
     * Original signature :
     * <code>NUMA* numaArithOp(NUMA*, NUMA*, NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1125</i>
     */
    public static Pointer<Numa> numaArithOp(Pointer<Numa> nad,
            Pointer<Numa> na1, Pointer<Numa> na2, int op) {
        return (Pointer) Pointer.pointerToAddress(
                numaArithOp(Pointer.getPeer(nad), Pointer.getPeer(na1),
                        Pointer.getPeer(na2), op), Numa.class);
    }

    @Ptr
    protected native static long numaArithOp(@Ptr long nad, @Ptr long na1,
            @Ptr long na2, int op);

    /**
     * Original signature :
     * <code>NUMA* numaLogicalOp(NUMA*, NUMA*, NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1126</i>
     */
    public static Pointer<Numa> numaLogicalOp(Pointer<Numa> nad,
            Pointer<Numa> na1, Pointer<Numa> na2, int op) {
        return (Pointer) Pointer.pointerToAddress(
                numaLogicalOp(Pointer.getPeer(nad), Pointer.getPeer(na1),
                        Pointer.getPeer(na2), op), Numa.class);
    }

    @Ptr
    protected native static long numaLogicalOp(@Ptr long nad, @Ptr long na1,
            @Ptr long na2, int op);

    /**
     * Original signature : <code>NUMA* numaInvert(NUMA*, NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1127</i>
     */
    public static Pointer<Numa> numaInvert(Pointer<Numa> nad, Pointer<Numa> nas) {
        return (Pointer) Pointer.pointerToAddress(
                numaInvert(Pointer.getPeer(nad), Pointer.getPeer(nas)),
                Numa.class);
    }

    @Ptr
    protected native static long numaInvert(@Ptr long nad, @Ptr long nas) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaSimilar(NUMA*, NUMA*, l_float32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1128</i>
     */
    public static int numaSimilar(Pointer<Numa> na1, Pointer<Numa> na2,
            float maxdiff, Pointer<Integer> psimilar) {
        return numaSimilar(Pointer.getPeer(na1), Pointer.getPeer(na2), maxdiff,
                Pointer.getPeer(psimilar));
    }

    protected native static int numaSimilar(@Ptr long na1, @Ptr long na2,
            float maxdiff, @Ptr long psimilar);

    /**
     * Original signature :
     * <code>l_int32 numaAddToNumber(NUMA*, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1129</i>
     */
    public static int numaAddToNumber(Pointer<Numa> na, int index, float val) {
        return numaAddToNumber(Pointer.getPeer(na), index, val);
    }

    protected native static int numaAddToNumber(@Ptr long na, int index,
            float val);

    /**
     * Original signature :
     * <code>l_int32 numaGetMin(NUMA*, l_float32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1130</i>
     */
    public static int numaGetMin(Pointer<Numa> na, Pointer<Float> pminval,
            Pointer<Integer> piminloc) {
        return numaGetMin(Pointer.getPeer(na), Pointer.getPeer(pminval),
                Pointer.getPeer(piminloc));
    }

    protected native static int numaGetMin(@Ptr long na, @Ptr long pminval,
            @Ptr long piminloc);

    /**
     * Original signature :
     * <code>l_int32 numaGetMax(NUMA*, l_float32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1131</i>
     */
    public static int numaGetMax(Pointer<Numa> na, Pointer<Float> pmaxval,
            Pointer<Integer> pimaxloc) {
        return numaGetMax(Pointer.getPeer(na), Pointer.getPeer(pmaxval),
                Pointer.getPeer(pimaxloc));
    }

    protected native static int numaGetMax(@Ptr long na, @Ptr long pmaxval,
            @Ptr long pimaxloc);

    /**
     * Original signature : <code>l_int32 numaGetSum(NUMA*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1132</i>
     */
    public static int numaGetSum(Pointer<Numa> na, Pointer<Float> psum) {
        return numaGetSum(Pointer.getPeer(na), Pointer.getPeer(psum));
    }

    protected native static int numaGetSum(@Ptr long na, @Ptr long psum) throws LastError;

    /**
     * Original signature : <code>NUMA* numaGetPartialSums(NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1133</i>
     */
    public static Pointer<Numa> numaGetPartialSums(Pointer<Numa> na) {
        return (Pointer) Pointer.pointerToAddress(
                numaGetPartialSums(Pointer.getPeer(na)), Numa.class);
    }

    @Ptr
    protected native static long numaGetPartialSums(@Ptr long na) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaGetSumOnInterval(NUMA*, l_int32, l_int32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1134</i>
     */
    public static int numaGetSumOnInterval(Pointer<Numa> na, int first,
            int last, Pointer<Float> psum) {
        return numaGetSumOnInterval(Pointer.getPeer(na), first, last,
                Pointer.getPeer(psum));
    }

    protected native static int numaGetSumOnInterval(@Ptr long na, int first,
            int last, @Ptr long psum);

    /**
     * Original signature :
     * <code>l_int32 numaHasOnlyIntegers(NUMA*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1135</i>
     */
    public static int numaHasOnlyIntegers(Pointer<Numa> na, int maxsamples,
            Pointer<Integer> pallints) {
        return numaHasOnlyIntegers(Pointer.getPeer(na), maxsamples,
                Pointer.getPeer(pallints));
    }

    protected native static int numaHasOnlyIntegers(@Ptr long na,
            int maxsamples, @Ptr long pallints);

    /**
     * Original signature : <code>NUMA* numaSubsample(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1136</i>
     */
    public static Pointer<Numa> numaSubsample(Pointer<Numa> nas, int subfactor) {
        return (Pointer) Pointer.pointerToAddress(
                numaSubsample(Pointer.getPeer(nas), subfactor), Numa.class);
    }

    @Ptr
    protected native static long numaSubsample(@Ptr long nas, int subfactor) throws LastError;

    /**
     * Original signature : <code>NUMA* numaMakeDelta(NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1137</i>
     */
    public static Pointer<Numa> numaMakeDelta(Pointer<Numa> nas) {
        return (Pointer) Pointer.pointerToAddress(
                numaMakeDelta(Pointer.getPeer(nas)), Numa.class);
    }

    @Ptr
    protected native static long numaMakeDelta(@Ptr long nas) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaMakeSequence(l_float32, l_float32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1138</i>
     */
    public static Pointer<Numa> numaMakeSequence(float startval,
            float increment, int size) {
        return (Pointer) Pointer.pointerToAddress(
                numaMakeSequence$2(startval, increment, size), Numa.class);
    }

    @Ptr
    @Name("numaMakeSequence")
    protected native static long numaMakeSequence$2(float startval,
            float increment, int size);

    /**
     * Original signature :
     * <code>NUMA* numaMakeConstant(l_float32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1139</i>
     */
    public static Pointer<Numa> numaMakeConstant(float val, int size) {
        return (Pointer) Pointer.pointerToAddress(
                numaMakeConstant$2(val, size), Numa.class);
    }

    @Ptr
    @Name("numaMakeConstant")
    protected native static long numaMakeConstant$2(float val, int size) throws LastError;

    /**
     * Original signature : <code>NUMA* numaMakeAbsValue(NUMA*, NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1140</i>
     */
    public static Pointer<Numa> numaMakeAbsValue(Pointer<Numa> nad,
            Pointer<Numa> nas) {
        return (Pointer) Pointer.pointerToAddress(
                numaMakeAbsValue(Pointer.getPeer(nad), Pointer.getPeer(nas)),
                Numa.class);
    }

    @Ptr
    protected native static long numaMakeAbsValue(@Ptr long nad, @Ptr long nas) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaAddBorder(NUMA*, l_int32, l_int32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1141</i>
     */
    public static Pointer<Numa> numaAddBorder(Pointer<Numa> nas, int left,
            int right, float val) {
        return (Pointer) Pointer.pointerToAddress(
                numaAddBorder(Pointer.getPeer(nas), left, right, val),
                Numa.class);
    }

    @Ptr
    protected native static long numaAddBorder(@Ptr long nas, int left,
            int right, float val);

    /**
     * Original signature :
     * <code>NUMA* numaAddSpecifiedBorder(NUMA*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1142</i>
     */
    public static Pointer<Numa> numaAddSpecifiedBorder(Pointer<Numa> nas,
            int left, int right, int type) {
        return (Pointer) Pointer.pointerToAddress(
                numaAddSpecifiedBorder(Pointer.getPeer(nas), left, right, type),
                Numa.class);
    }

    @Ptr
    protected native static long numaAddSpecifiedBorder(@Ptr long nas,
            int left, int right, int type);

    /**
     * Original signature :
     * <code>NUMA* numaRemoveBorder(NUMA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1143</i>
     */
    public static Pointer<Numa> numaRemoveBorder(Pointer<Numa> nas, int left,
            int right) {
        return (Pointer) Pointer.pointerToAddress(
                numaRemoveBorder(Pointer.getPeer(nas), left, right), Numa.class);
    }

    @Ptr
    protected native static long numaRemoveBorder(@Ptr long nas, int left,
            int right);

    /**
     * Original signature :
     * <code>l_int32 numaGetNonzeroRange(NUMA*, l_float32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1144</i>
     */
    public static int numaGetNonzeroRange(Pointer<Numa> na, float eps,
            Pointer<Integer> pfirst, Pointer<Integer> plast) {
        return numaGetNonzeroRange(Pointer.getPeer(na), eps,
                Pointer.getPeer(pfirst), Pointer.getPeer(plast));
    }

    protected native static int numaGetNonzeroRange(@Ptr long na, float eps,
            @Ptr long pfirst, @Ptr long plast);

    /**
     * Original signature :
     * <code>l_int32 numaGetCountRelativeToZero(NUMA*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1145</i>
     */
    public static int numaGetCountRelativeToZero(Pointer<Numa> na, int type,
            Pointer<Integer> pcount) {
        return numaGetCountRelativeToZero(Pointer.getPeer(na), type,
                Pointer.getPeer(pcount));
    }

    protected native static int numaGetCountRelativeToZero(@Ptr long na,
            int type, @Ptr long pcount);

    /**
     * Original signature :
     * <code>NUMA* numaClipToInterval(NUMA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1146</i>
     */
    public static Pointer<Numa> numaClipToInterval(Pointer<Numa> nas,
            int first, int last) {
        return (Pointer) Pointer.pointerToAddress(
                numaClipToInterval(Pointer.getPeer(nas), first, last),
                Numa.class);
    }

    @Ptr
    protected native static long numaClipToInterval(@Ptr long nas, int first,
            int last);

    /**
     * Original signature :
     * <code>NUMA* numaMakeThresholdIndicator(NUMA*, l_float32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1147</i>
     */
    public static Pointer<Numa> numaMakeThresholdIndicator(Pointer<Numa> nas,
            float thresh, int type) {
        return (Pointer) Pointer.pointerToAddress(
                numaMakeThresholdIndicator(Pointer.getPeer(nas), thresh, type),
                Numa.class);
    }

    @Ptr
    protected native static long numaMakeThresholdIndicator(@Ptr long nas,
            float thresh, int type);

    /**
     * Original signature :
     * <code>NUMA* numaUniformSampling(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1148</i>
     */
    public static Pointer<Numa> numaUniformSampling(Pointer<Numa> nas, int nsamp) {
        return (Pointer) Pointer.pointerToAddress(
                numaUniformSampling(Pointer.getPeer(nas), nsamp), Numa.class);
    }

    @Ptr
    protected native static long numaUniformSampling(@Ptr long nas, int nsamp) throws LastError;

    /**
     * Original signature : <code>NUMA* numaReverse(NUMA*, NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1149</i>
     */
    public static Pointer<Numa> numaReverse(Pointer<Numa> nad, Pointer<Numa> nas) {
        return (Pointer) Pointer.pointerToAddress(
                numaReverse(Pointer.getPeer(nad), Pointer.getPeer(nas)),
                Numa.class);
    }

    @Ptr
    protected native static long numaReverse(@Ptr long nad, @Ptr long nas) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaLowPassIntervals(NUMA*, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1150</i>
     */
    public static Pointer<Numa> numaLowPassIntervals(Pointer<Numa> nas,
            float thresh, float maxn) {
        return (Pointer) Pointer.pointerToAddress(
                numaLowPassIntervals(Pointer.getPeer(nas), thresh, maxn),
                Numa.class);
    }

    @Ptr
    protected native static long numaLowPassIntervals(@Ptr long nas,
            float thresh, float maxn);

    /**
     * Original signature :
     * <code>NUMA* numaThresholdEdges(NUMA*, l_float32, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1151</i>
     */
    public static Pointer<Numa> numaThresholdEdges(Pointer<Numa> nas,
            float thresh1, float thresh2, float maxn) {
        return (Pointer) Pointer.pointerToAddress(
                numaThresholdEdges(Pointer.getPeer(nas), thresh1, thresh2, maxn),
                Numa.class);
    }

    @Ptr
    protected native static long numaThresholdEdges(@Ptr long nas,
            float thresh1, float thresh2, float maxn);

    /**
     * Original signature :
     * <code>l_int32 numaGetSpanValues(NUMA*, l_int32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1152</i>
     */
    public static int numaGetSpanValues(Pointer<Numa> na, int span,
            Pointer<Integer> pstart, Pointer<Integer> pend) {
        return numaGetSpanValues(Pointer.getPeer(na), span,
                Pointer.getPeer(pstart), Pointer.getPeer(pend));
    }

    protected native static int numaGetSpanValues(@Ptr long na, int span,
            @Ptr long pstart, @Ptr long pend);

    /**
     * Original signature :
     * <code>l_int32 numaGetEdgeValues(NUMA*, l_int32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1153</i>
     */
    public static int numaGetEdgeValues(Pointer<Numa> na, int edge,
            Pointer<Integer> pstart, Pointer<Integer> pend,
            Pointer<Integer> psign) {
        return numaGetEdgeValues(Pointer.getPeer(na), edge,
                Pointer.getPeer(pstart), Pointer.getPeer(pend),
                Pointer.getPeer(psign));
    }

    protected native static int numaGetEdgeValues(@Ptr long na, int edge,
            @Ptr long pstart, @Ptr long pend, @Ptr long psign);

    /**
     * Original signature :
     * <code>l_int32 numaInterpolateEqxVal(l_float32, l_float32, NUMA*, l_int32, l_float32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1154</i>
     */
    public static int numaInterpolateEqxVal(float startx, float deltax,
            Pointer<Numa> nay, int type, float xval, Pointer<Float> pyval) {
        return numaInterpolateEqxVal(startx, deltax, Pointer.getPeer(nay),
                type, xval, Pointer.getPeer(pyval));
    }

    protected native static int numaInterpolateEqxVal(float startx,
            float deltax, @Ptr long nay, int type, float xval, @Ptr long pyval);

    /**
     * Original signature :
     * <code>l_int32 numaInterpolateArbxVal(NUMA*, NUMA*, l_int32, l_float32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1155</i>
     */
    public static int numaInterpolateArbxVal(Pointer<Numa> nax,
            Pointer<Numa> nay, int type, float xval, Pointer<Float> pyval) {
        return numaInterpolateArbxVal(Pointer.getPeer(nax),
                Pointer.getPeer(nay), type, xval, Pointer.getPeer(pyval));
    }

    protected native static int numaInterpolateArbxVal(@Ptr long nax,
            @Ptr long nay, int type, float xval, @Ptr long pyval);

    /**
     * Original signature :
     * <code>l_int32 numaInterpolateEqxInterval(l_float32, l_float32, NUMA*, l_int32, l_float32, l_float32, l_int32, NUMA**, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1156</i>
     */
    public static int numaInterpolateEqxInterval(float startx, float deltax,
            Pointer<Numa> nasy, int type, float x0, float x1, int npts,
            Pointer<Pointer<Numa>> pnax, Pointer<Pointer<Numa>> pnay) {
        return numaInterpolateEqxInterval(startx, deltax,
                Pointer.getPeer(nasy), type, x0, x1, npts,
                Pointer.getPeer(pnax), Pointer.getPeer(pnay));
    }

    protected native static int numaInterpolateEqxInterval(float startx,
            float deltax, @Ptr long nasy, int type, float x0, float x1,
            int npts, @Ptr long pnax, @Ptr long pnay);

    /**
     * Original signature :
     * <code>l_int32 numaInterpolateArbxInterval(NUMA*, NUMA*, l_int32, l_float32, l_float32, l_int32, NUMA**, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1157</i>
     */
    public static int numaInterpolateArbxInterval(Pointer<Numa> nax,
            Pointer<Numa> nay, int type, float x0, float x1, int npts,
            Pointer<Pointer<Numa>> pnadx, Pointer<Pointer<Numa>> pnady) {
        return numaInterpolateArbxInterval(Pointer.getPeer(nax),
                Pointer.getPeer(nay), type, x0, x1, npts,
                Pointer.getPeer(pnadx), Pointer.getPeer(pnady));
    }

    protected native static int numaInterpolateArbxInterval(@Ptr long nax,
            @Ptr long nay, int type, float x0, float x1, int npts,
            @Ptr long pnadx, @Ptr long pnady);

    /**
     * Original signature :
     * <code>l_int32 numaFitMax(NUMA*, l_float32*, NUMA*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1158</i>
     */
    public static int numaFitMax(Pointer<Numa> na, Pointer<Float> pmaxval,
            Pointer<Numa> naloc, Pointer<Float> pmaxloc) {
        return numaFitMax(Pointer.getPeer(na), Pointer.getPeer(pmaxval),
                Pointer.getPeer(naloc), Pointer.getPeer(pmaxloc));
    }

    protected native static int numaFitMax(@Ptr long na, @Ptr long pmaxval,
            @Ptr long naloc, @Ptr long pmaxloc);

    /**
     * Original signature :
     * <code>l_int32 numaDifferentiateInterval(NUMA*, NUMA*, l_float32, l_float32, l_int32, NUMA**, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1159</i>
     */
    public static int numaDifferentiateInterval(Pointer<Numa> nax,
            Pointer<Numa> nay, float x0, float x1, int npts,
            Pointer<Pointer<Numa>> pnadx, Pointer<Pointer<Numa>> pnady) {
        return numaDifferentiateInterval(Pointer.getPeer(nax),
                Pointer.getPeer(nay), x0, x1, npts, Pointer.getPeer(pnadx),
                Pointer.getPeer(pnady));
    }

    protected native static int numaDifferentiateInterval(@Ptr long nax,
            @Ptr long nay, float x0, float x1, int npts, @Ptr long pnadx,
            @Ptr long pnady);

    /**
     * Original signature :
     * <code>l_int32 numaIntegrateInterval(NUMA*, NUMA*, l_float32, l_float32, l_int32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1160</i>
     */
    public static int numaIntegrateInterval(Pointer<Numa> nax,
            Pointer<Numa> nay, float x0, float x1, int npts, Pointer<Float> psum) {
        return numaIntegrateInterval(Pointer.getPeer(nax),
                Pointer.getPeer(nay), x0, x1, npts, Pointer.getPeer(psum));
    }

    protected native static int numaIntegrateInterval(@Ptr long nax,
            @Ptr long nay, float x0, float x1, int npts, @Ptr long psum);

    /**
     * Original signature :
     * <code>l_int32 numaSortGeneral(NUMA*, NUMA**, NUMA**, NUMA**, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1161</i>
     */
    public static int numaSortGeneral(Pointer<Numa> na,
            Pointer<Pointer<Numa>> pnasort, Pointer<Pointer<Numa>> pnaindex,
            Pointer<Pointer<Numa>> pnainvert, int sortorder, int sorttype) {
        return numaSortGeneral(Pointer.getPeer(na), Pointer.getPeer(pnasort),
                Pointer.getPeer(pnaindex), Pointer.getPeer(pnainvert),
                sortorder, sorttype);
    }

    protected native static int numaSortGeneral(@Ptr long na,
            @Ptr long pnasort, @Ptr long pnaindex, @Ptr long pnainvert,
            int sortorder, int sorttype);

    /**
     * Original signature :
     * <code>NUMA* numaSortAutoSelect(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1162</i>
     */
    public static Pointer<Numa> numaSortAutoSelect(Pointer<Numa> nas,
            int sortorder) {
        return (Pointer) Pointer.pointerToAddress(
                numaSortAutoSelect(Pointer.getPeer(nas), sortorder), Numa.class);
    }

    @Ptr
    protected native static long numaSortAutoSelect(@Ptr long nas, int sortorder) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaSortIndexAutoSelect(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1163</i>
     */
    public static Pointer<Numa> numaSortIndexAutoSelect(Pointer<Numa> nas,
            int sortorder) {
        return (Pointer) Pointer.pointerToAddress(
                numaSortIndexAutoSelect(Pointer.getPeer(nas), sortorder),
                Numa.class);
    }

    @Ptr
    protected native static long numaSortIndexAutoSelect(@Ptr long nas,
            int sortorder);

    /**
     * Original signature : <code>l_int32 numaChooseSortType(NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1164</i>
     */
    public static int numaChooseSortType(Pointer<Numa> nas) {
        return numaChooseSortType(Pointer.getPeer(nas));
    }

    protected native static int numaChooseSortType(@Ptr long nas) throws LastError;

    /**
     * Original signature : <code>NUMA* numaSort(NUMA*, NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1165</i>
     */
    public static Pointer<Numa> numaSort(Pointer<Numa> naout,
            Pointer<Numa> nain, int sortorder) {
        return (Pointer) Pointer.pointerToAddress(
                numaSort(Pointer.getPeer(naout), Pointer.getPeer(nain),
                        sortorder), Numa.class);
    }

    @Ptr
    protected native static long numaSort(@Ptr long naout, @Ptr long nain,
            int sortorder);

    /**
     * Original signature : <code>NUMA* numaBinSort(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1166</i>
     */
    public static Pointer<Numa> numaBinSort(Pointer<Numa> nas, int sortorder) {
        return (Pointer) Pointer.pointerToAddress(
                numaBinSort(Pointer.getPeer(nas), sortorder), Numa.class);
    }

    @Ptr
    protected native static long numaBinSort(@Ptr long nas, int sortorder) throws LastError;

    /**
     * Original signature : <code>NUMA* numaGetSortIndex(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1167</i>
     */
    public static Pointer<Numa> numaGetSortIndex(Pointer<Numa> na, int sortorder) {
        return (Pointer) Pointer.pointerToAddress(
                numaGetSortIndex(Pointer.getPeer(na), sortorder), Numa.class);
    }

    @Ptr
    protected native static long numaGetSortIndex(@Ptr long na, int sortorder) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaGetBinSortIndex(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1168</i>
     */
    public static Pointer<Numa> numaGetBinSortIndex(Pointer<Numa> nas,
            int sortorder) {
        return (Pointer) Pointer.pointerToAddress(
                numaGetBinSortIndex(Pointer.getPeer(nas), sortorder),
                Numa.class);
    }

    @Ptr
    protected native static long numaGetBinSortIndex(@Ptr long nas,
            int sortorder);

    /**
     * Original signature : <code>NUMA* numaSortByIndex(NUMA*, NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1169</i>
     */
    public static Pointer<Numa> numaSortByIndex(Pointer<Numa> nas,
            Pointer<Numa> naindex) {
        return (Pointer) Pointer.pointerToAddress(
                numaSortByIndex(Pointer.getPeer(nas), Pointer.getPeer(naindex)),
                Numa.class);
    }

    @Ptr
    protected native static long numaSortByIndex(@Ptr long nas,
            @Ptr long naindex);

    /**
     * Original signature :
     * <code>l_int32 numaIsSorted(NUMA*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1170</i>
     */
    public static int numaIsSorted(Pointer<Numa> nas, int sortorder,
            Pointer<Integer> psorted) {
        return numaIsSorted(Pointer.getPeer(nas), sortorder,
                Pointer.getPeer(psorted));
    }

    protected native static int numaIsSorted(@Ptr long nas, int sortorder,
            @Ptr long psorted);

    /**
     * Original signature :
     * <code>l_int32 numaSortPair(NUMA*, NUMA*, l_int32, NUMA**, NUMA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1171</i>
     */
    public static int numaSortPair(Pointer<Numa> nax, Pointer<Numa> nay,
            int sortorder, Pointer<Pointer<Numa>> pnasx,
            Pointer<Pointer<Numa>> pnasy) {
        return numaSortPair(Pointer.getPeer(nax), Pointer.getPeer(nay),
                sortorder, Pointer.getPeer(pnasx), Pointer.getPeer(pnasy));
    }

    protected native static int numaSortPair(@Ptr long nax, @Ptr long nay,
            int sortorder, @Ptr long pnasx, @Ptr long pnasy);

    /**
     * Original signature : <code>NUMA* numaInvertMap(NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1172</i>
     */
    public static Pointer<Numa> numaInvertMap(Pointer<Numa> nas) {
        return (Pointer) Pointer.pointerToAddress(
                numaInvertMap(Pointer.getPeer(nas)), Numa.class);
    }

    @Ptr
    protected native static long numaInvertMap(@Ptr long nas) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaPseudorandomSequence(l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1173</i>
     */
    public static Pointer<Numa> numaPseudorandomSequence(int size, int seed) {
        return (Pointer) Pointer.pointerToAddress(
                numaPseudorandomSequence$2(size, seed), Numa.class);
    }

    @Ptr
    @Name("numaPseudorandomSequence")
    protected native static long numaPseudorandomSequence$2(int size, int seed) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaRandomPermutation(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1174</i>
     */
    public static Pointer<Numa> numaRandomPermutation(Pointer<Numa> nas,
            int seed) {
        return (Pointer) Pointer.pointerToAddress(
                numaRandomPermutation(Pointer.getPeer(nas), seed), Numa.class);
    }

    @Ptr
    protected native static long numaRandomPermutation(@Ptr long nas, int seed) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaGetRankValue(NUMA*, l_float32, NUMA*, l_int32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1175</i>
     */
    public static int numaGetRankValue(Pointer<Numa> na, float fract,
            Pointer<Numa> nasort, int usebins, Pointer<Float> pval) {
        return numaGetRankValue(Pointer.getPeer(na), fract,
                Pointer.getPeer(nasort), usebins, Pointer.getPeer(pval));
    }

    protected native static int numaGetRankValue(@Ptr long na, float fract,
            @Ptr long nasort, int usebins, @Ptr long pval);

    /**
     * Original signature :
     * <code>l_int32 numaGetMedian(NUMA*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1176</i>
     */
    public static int numaGetMedian(Pointer<Numa> na, Pointer<Float> pval) {
        return numaGetMedian(Pointer.getPeer(na), Pointer.getPeer(pval));
    }

    protected native static int numaGetMedian(@Ptr long na, @Ptr long pval) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaGetBinnedMedian(NUMA*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1177</i>
     */
    public static int numaGetBinnedMedian(Pointer<Numa> na,
            Pointer<Integer> pval) {
        return numaGetBinnedMedian(Pointer.getPeer(na), Pointer.getPeer(pval));
    }

    protected native static int numaGetBinnedMedian(@Ptr long na, @Ptr long pval) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaGetMode(NUMA*, l_float32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1178</i>
     */
    public static int numaGetMode(Pointer<Numa> na, Pointer<Float> pval,
            Pointer<Integer> pcount) {
        return numaGetMode(Pointer.getPeer(na), Pointer.getPeer(pval),
                Pointer.getPeer(pcount));
    }

    protected native static int numaGetMode(@Ptr long na, @Ptr long pval,
            @Ptr long pcount);

    /**
     * Original signature :
     * <code>l_int32 numaGetMedianVariation(NUMA*, l_float32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1179</i>
     */
    public static int numaGetMedianVariation(Pointer<Numa> na,
            Pointer<Float> pmedval, Pointer<Float> pmedvar) {
        return numaGetMedianVariation(Pointer.getPeer(na),
                Pointer.getPeer(pmedval), Pointer.getPeer(pmedvar));
    }

    protected native static int numaGetMedianVariation(@Ptr long na,
            @Ptr long pmedval, @Ptr long pmedvar);

    /**
     * Original signature :
     * <code>l_int32 numaJoin(NUMA*, NUMA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1180</i>
     */
    public static int numaJoin(Pointer<Numa> nad, Pointer<Numa> nas,
            int istart, int iend) {
        return numaJoin(Pointer.getPeer(nad), Pointer.getPeer(nas), istart,
                iend);
    }

    protected native static int numaJoin(@Ptr long nad, @Ptr long nas,
            int istart, int iend);

    /**
     * Original signature :
     * <code>l_int32 numaaJoin(NUMAA*, NUMAA*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1181</i>
     */
    public static int numaaJoin(Pointer<Numaa> naad, Pointer<Numaa> naas,
            int istart, int iend) {
        return numaaJoin(Pointer.getPeer(naad), Pointer.getPeer(naas), istart,
                iend);
    }

    protected native static int numaaJoin(@Ptr long naad, @Ptr long naas,
            int istart, int iend);

    /**
     * Original signature : <code>NUMA* numaaFlattenToNuma(NUMAA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1182</i>
     */
    public static Pointer<Numa> numaaFlattenToNuma(Pointer<Numaa> naa) {
        return (Pointer) Pointer.pointerToAddress(
                numaaFlattenToNuma(Pointer.getPeer(naa)), Numa.class);
    }

    @Ptr
    protected native static long numaaFlattenToNuma(@Ptr long naa) throws LastError;

    /**
     * Original signature : <code>NUMA* numaErode(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1183</i>
     */
    public static Pointer<Numa> numaErode(Pointer<Numa> nas, int size) {
        return (Pointer) Pointer.pointerToAddress(
                numaErode(Pointer.getPeer(nas), size), Numa.class);
    }

    @Ptr
    protected native static long numaErode(@Ptr long nas, int size) throws LastError;

    /**
     * Original signature : <code>NUMA* numaDilate(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1184</i>
     */
    public static Pointer<Numa> numaDilate(Pointer<Numa> nas, int size) {
        return (Pointer) Pointer.pointerToAddress(
                numaDilate(Pointer.getPeer(nas), size), Numa.class);
    }

    @Ptr
    protected native static long numaDilate(@Ptr long nas, int size) throws LastError;

    /**
     * Original signature : <code>NUMA* numaOpen(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1185</i>
     */
    public static Pointer<Numa> numaOpen(Pointer<Numa> nas, int size) {
        return (Pointer) Pointer.pointerToAddress(
                numaOpen(Pointer.getPeer(nas), size), Numa.class);
    }

    @Ptr
    protected native static long numaOpen(@Ptr long nas, int size) throws LastError;

    /**
     * Original signature : <code>NUMA* numaClose(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1186</i>
     */
    public static Pointer<Numa> numaClose(Pointer<Numa> nas, int size) {
        return (Pointer) Pointer.pointerToAddress(
                numaClose(Pointer.getPeer(nas), size), Numa.class);
    }

    @Ptr
    protected native static long numaClose(@Ptr long nas, int size) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaTransform(NUMA*, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1187</i>
     */
    public static Pointer<Numa> numaTransform(Pointer<Numa> nas, float shift,
            float scale) {
        return (Pointer) Pointer.pointerToAddress(
                numaTransform(Pointer.getPeer(nas), shift, scale), Numa.class);
    }

    @Ptr
    protected native static long numaTransform(@Ptr long nas, float shift,
            float scale);

    /**
     * Original signature :
     * <code>l_int32 numaWindowedStats(NUMA*, l_int32, NUMA**, NUMA**, NUMA**, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1188</i>
     */
    public static int numaWindowedStats(Pointer<Numa> nas, int wc,
            Pointer<Pointer<Numa>> pnam, Pointer<Pointer<Numa>> pnams,
            Pointer<Pointer<Numa>> pnav, Pointer<Pointer<Numa>> pnarv) {
        return numaWindowedStats(Pointer.getPeer(nas), wc,
                Pointer.getPeer(pnam), Pointer.getPeer(pnams),
                Pointer.getPeer(pnav), Pointer.getPeer(pnarv));
    }

    protected native static int numaWindowedStats(@Ptr long nas, int wc,
            @Ptr long pnam, @Ptr long pnams, @Ptr long pnav, @Ptr long pnarv);

    /**
     * Original signature : <code>NUMA* numaWindowedMean(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1189</i>
     */
    public static Pointer<Numa> numaWindowedMean(Pointer<Numa> nas, int wc) {
        return (Pointer) Pointer.pointerToAddress(
                numaWindowedMean(Pointer.getPeer(nas), wc), Numa.class);
    }

    @Ptr
    protected native static long numaWindowedMean(@Ptr long nas, int wc) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaWindowedMeanSquare(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1190</i>
     */
    public static Pointer<Numa> numaWindowedMeanSquare(Pointer<Numa> nas, int wc) {
        return (Pointer) Pointer.pointerToAddress(
                numaWindowedMeanSquare(Pointer.getPeer(nas), wc), Numa.class);
    }

    @Ptr
    protected native static long numaWindowedMeanSquare(@Ptr long nas, int wc) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaWindowedVariance(NUMA*, NUMA*, NUMA**, NUMA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1191</i>
     */
    public static int numaWindowedVariance(Pointer<Numa> nam,
            Pointer<Numa> nams, Pointer<Pointer<Numa>> pnav,
            Pointer<Pointer<Numa>> pnarv) {
        return numaWindowedVariance(Pointer.getPeer(nam),
                Pointer.getPeer(nams), Pointer.getPeer(pnav),
                Pointer.getPeer(pnarv));
    }

    protected native static int numaWindowedVariance(@Ptr long nam,
            @Ptr long nams, @Ptr long pnav, @Ptr long pnarv);

    /**
     * Original signature : <code>NUMA* numaConvertToInt(NUMA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1192</i>
     */
    public static Pointer<Numa> numaConvertToInt(Pointer<Numa> nas) {
        return (Pointer) Pointer.pointerToAddress(
                numaConvertToInt(Pointer.getPeer(nas)), Numa.class);
    }

    @Ptr
    protected native static long numaConvertToInt(@Ptr long nas) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaMakeHistogram(NUMA*, l_int32, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1193</i>
     */
    public static Pointer<Numa> numaMakeHistogram(Pointer<Numa> na,
            int maxbins, Pointer<Integer> pbinsize, Pointer<Integer> pbinstart) {
        return (Pointer) Pointer.pointerToAddress(
                numaMakeHistogram(Pointer.getPeer(na), maxbins,
                        Pointer.getPeer(pbinsize), Pointer.getPeer(pbinstart)),
                Numa.class);
    }

    @Ptr
    protected native static long numaMakeHistogram(@Ptr long na, int maxbins,
            @Ptr long pbinsize, @Ptr long pbinstart);

    /**
     * Original signature :
     * <code>NUMA* numaMakeHistogramAuto(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1194</i>
     */
    public static Pointer<Numa> numaMakeHistogramAuto(Pointer<Numa> na,
            int maxbins) {
        return (Pointer) Pointer.pointerToAddress(
                numaMakeHistogramAuto(Pointer.getPeer(na), maxbins), Numa.class);
    }

    @Ptr
    protected native static long numaMakeHistogramAuto(@Ptr long na, int maxbins) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaMakeHistogramClipped(NUMA*, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1195</i>
     */
    public static Pointer<Numa> numaMakeHistogramClipped(Pointer<Numa> na,
            float binsize, float maxsize) {
        return (Pointer) Pointer.pointerToAddress(
                numaMakeHistogramClipped(Pointer.getPeer(na), binsize, maxsize),
                Numa.class);
    }

    @Ptr
    protected native static long numaMakeHistogramClipped(@Ptr long na,
            float binsize, float maxsize);

    /**
     * Original signature :
     * <code>NUMA* numaRebinHistogram(NUMA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1196</i>
     */
    public static Pointer<Numa> numaRebinHistogram(Pointer<Numa> nas,
            int newsize) {
        return (Pointer) Pointer.pointerToAddress(
                numaRebinHistogram(Pointer.getPeer(nas), newsize), Numa.class);
    }

    @Ptr
    protected native static long numaRebinHistogram(@Ptr long nas, int newsize) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* numaNormalizeHistogram(NUMA*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1197</i>
     */
    public static Pointer<Numa> numaNormalizeHistogram(Pointer<Numa> nas,
            float tsum) {
        return (Pointer) Pointer.pointerToAddress(
                numaNormalizeHistogram(Pointer.getPeer(nas), tsum), Numa.class);
    }

    @Ptr
    protected native static long numaNormalizeHistogram(@Ptr long nas,
            float tsum);

    /**
     * Original signature :
     * <code>l_int32 numaGetStatsUsingHistogram(NUMA*, l_int32, l_float32*, l_float32*, l_float32*, l_float32*, l_float32*, l_float32, l_float32*, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1198</i>
     */
    public static int numaGetStatsUsingHistogram(Pointer<Numa> na, int maxbins,
            Pointer<Float> pmin, Pointer<Float> pmax, Pointer<Float> pmean,
            Pointer<Float> pvariance, Pointer<Float> pmedian, float rank,
            Pointer<Float> prval, Pointer<Pointer<Numa>> phisto) {
        return numaGetStatsUsingHistogram(Pointer.getPeer(na), maxbins,
                Pointer.getPeer(pmin), Pointer.getPeer(pmax),
                Pointer.getPeer(pmean), Pointer.getPeer(pvariance),
                Pointer.getPeer(pmedian), rank, Pointer.getPeer(prval),
                Pointer.getPeer(phisto));
    }

    protected native static int numaGetStatsUsingHistogram(@Ptr long na,
            int maxbins, @Ptr long pmin, @Ptr long pmax, @Ptr long pmean,
            @Ptr long pvariance, @Ptr long pmedian, float rank,
            @Ptr long prval, @Ptr long phisto);

    /**
     * Original signature :
     * <code>l_int32 numaGetHistogramStats(NUMA*, l_float32, l_float32, l_float32*, l_float32*, l_float32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1199</i>
     */
    public static int numaGetHistogramStats(Pointer<Numa> nahisto,
            float startx, float deltax, Pointer<Float> pxmean,
            Pointer<Float> pxmedian, Pointer<Float> pxmode,
            Pointer<Float> pxvariance) {
        return numaGetHistogramStats(Pointer.getPeer(nahisto), startx, deltax,
                Pointer.getPeer(pxmean), Pointer.getPeer(pxmedian),
                Pointer.getPeer(pxmode), Pointer.getPeer(pxvariance));
    }

    protected native static int numaGetHistogramStats(@Ptr long nahisto,
            float startx, float deltax, @Ptr long pxmean, @Ptr long pxmedian,
            @Ptr long pxmode, @Ptr long pxvariance);

    /**
     * Original signature :
     * <code>l_int32 numaGetHistogramStatsOnInterval(NUMA*, l_float32, l_float32, l_int32, l_int32, l_float32*, l_float32*, l_float32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1200</i>
     */
    public static int numaGetHistogramStatsOnInterval(Pointer<Numa> nahisto,
            float startx, float deltax, int ifirst, int ilast,
            Pointer<Float> pxmean, Pointer<Float> pxmedian,
            Pointer<Float> pxmode, Pointer<Float> pxvariance) {
        return numaGetHistogramStatsOnInterval(Pointer.getPeer(nahisto),
                startx, deltax, ifirst, ilast, Pointer.getPeer(pxmean),
                Pointer.getPeer(pxmedian), Pointer.getPeer(pxmode),
                Pointer.getPeer(pxvariance));
    }

    protected native static int numaGetHistogramStatsOnInterval(
            @Ptr long nahisto, float startx, float deltax, int ifirst,
            int ilast, @Ptr long pxmean, @Ptr long pxmedian, @Ptr long pxmode,
            @Ptr long pxvariance);

    /**
     * Original signature :
     * <code>l_int32 numaMakeRankFromHistogram(l_float32, l_float32, NUMA*, l_int32, NUMA**, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1201</i>
     */
    public static int numaMakeRankFromHistogram(float startx, float deltax,
            Pointer<Numa> nasy, int npts, Pointer<Pointer<Numa>> pnax,
            Pointer<Pointer<Numa>> pnay) {
        return numaMakeRankFromHistogram(startx, deltax, Pointer.getPeer(nasy),
                npts, Pointer.getPeer(pnax), Pointer.getPeer(pnay));
    }

    protected native static int numaMakeRankFromHistogram(float startx,
            float deltax, @Ptr long nasy, int npts, @Ptr long pnax,
            @Ptr long pnay);

    /**
     * Original signature :
     * <code>l_int32 numaHistogramGetRankFromVal(NUMA*, l_float32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1202</i>
     */
    public static int numaHistogramGetRankFromVal(Pointer<Numa> na, float rval,
            Pointer<Float> prank) {
        return numaHistogramGetRankFromVal(Pointer.getPeer(na), rval,
                Pointer.getPeer(prank));
    }

    protected native static int numaHistogramGetRankFromVal(@Ptr long na,
            float rval, @Ptr long prank);

    /**
     * Original signature :
     * <code>l_int32 numaHistogramGetValFromRank(NUMA*, l_float32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1203</i>
     */
    public static int numaHistogramGetValFromRank(Pointer<Numa> na, float rank,
            Pointer<Float> prval) {
        return numaHistogramGetValFromRank(Pointer.getPeer(na), rank,
                Pointer.getPeer(prval));
    }

    protected native static int numaHistogramGetValFromRank(@Ptr long na,
            float rank, @Ptr long prval);

    /**
     * Original signature :
     * <code>l_int32 numaDiscretizeRankAndIntensity(NUMA*, l_int32, NUMA**, NUMA**, NUMA**, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1204</i>
     */
    public static int numaDiscretizeRankAndIntensity(Pointer<Numa> na,
            int nbins, Pointer<Pointer<Numa>> pnarbin,
            Pointer<Pointer<Numa>> pnam, Pointer<Pointer<Numa>> pnar,
            Pointer<Pointer<Numa>> pnabb) {
        return numaDiscretizeRankAndIntensity(Pointer.getPeer(na), nbins,
                Pointer.getPeer(pnarbin), Pointer.getPeer(pnam),
                Pointer.getPeer(pnar), Pointer.getPeer(pnabb));
    }

    protected native static int numaDiscretizeRankAndIntensity(@Ptr long na,
            int nbins, @Ptr long pnarbin, @Ptr long pnam, @Ptr long pnar,
            @Ptr long pnabb);

    /**
     * Original signature :
     * <code>l_int32 numaGetRankBinValues(NUMA*, l_int32, NUMA**, NUMA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1205</i>
     */
    public static int numaGetRankBinValues(Pointer<Numa> na, int nbins,
            Pointer<Pointer<Numa>> pnarbin, Pointer<Pointer<Numa>> pnam) {
        return numaGetRankBinValues(Pointer.getPeer(na), nbins,
                Pointer.getPeer(pnarbin), Pointer.getPeer(pnam));
    }

    protected native static int numaGetRankBinValues(@Ptr long na, int nbins,
            @Ptr long pnarbin, @Ptr long pnam);

    /**
     * Original signature :
     * <code>l_int32 numaSplitDistribution(NUMA*, l_float32, l_int32*, l_float32*, l_float32*, l_float32*, l_float32*, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1206</i>
     */
    public static int numaSplitDistribution(Pointer<Numa> na, float scorefract,
            Pointer<Integer> psplitindex, Pointer<Float> pave1,
            Pointer<Float> pave2, Pointer<Float> pnum1, Pointer<Float> pnum2,
            Pointer<Pointer<Numa>> pnascore) {
        return numaSplitDistribution(Pointer.getPeer(na), scorefract,
                Pointer.getPeer(psplitindex), Pointer.getPeer(pave1),
                Pointer.getPeer(pave2), Pointer.getPeer(pnum1),
                Pointer.getPeer(pnum2), Pointer.getPeer(pnascore));
    }

    protected native static int numaSplitDistribution(@Ptr long na,
            float scorefract, @Ptr long psplitindex, @Ptr long pave1,
            @Ptr long pave2, @Ptr long pnum1, @Ptr long pnum2,
            @Ptr long pnascore);

    /**
     * Original signature :
     * <code>l_int32 numaEarthMoverDistance(NUMA*, NUMA*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1207</i>
     */
    public static int numaEarthMoverDistance(Pointer<Numa> na1,
            Pointer<Numa> na2, Pointer<Float> pdist) {
        return numaEarthMoverDistance(Pointer.getPeer(na1),
                Pointer.getPeer(na2), Pointer.getPeer(pdist));
    }

    protected native static int numaEarthMoverDistance(@Ptr long na1,
            @Ptr long na2, @Ptr long pdist);

    /**
     * Original signature :
     * <code>NUMA* numaFindPeaks(NUMA*, l_int32, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1208</i>
     */
    public static Pointer<Numa> numaFindPeaks(Pointer<Numa> nas, int nmax,
            float fract1, float fract2) {
        return (Pointer) Pointer.pointerToAddress(
                numaFindPeaks(Pointer.getPeer(nas), nmax, fract1, fract2),
                Numa.class);
    }

    @Ptr
    protected native static long numaFindPeaks(@Ptr long nas, int nmax,
            float fract1, float fract2);

    /**
     * Original signature : <code>NUMA* numaFindExtrema(NUMA*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1209</i>
     */
    public static Pointer<Numa> numaFindExtrema(Pointer<Numa> nas, float delta) {
        return (Pointer) Pointer.pointerToAddress(
                numaFindExtrema(Pointer.getPeer(nas), delta), Numa.class);
    }

    @Ptr
    protected native static long numaFindExtrema(@Ptr long nas, float delta) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 numaCountReversals(NUMA*, l_float32, l_int32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1210</i>
     */
    public static int numaCountReversals(Pointer<Numa> nas, float minreversal,
            Pointer<Integer> pnr, Pointer<Float> pnrpl) {
        return numaCountReversals(Pointer.getPeer(nas), minreversal,
                Pointer.getPeer(pnr), Pointer.getPeer(pnrpl));
    }

    protected native static int numaCountReversals(@Ptr long nas,
            float minreversal, @Ptr long pnr, @Ptr long pnrpl);

    /**
     * Original signature :
     * <code>l_int32 numaSelectCrossingThreshold(NUMA*, NUMA*, l_float32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1211</i>
     */
    public static int numaSelectCrossingThreshold(Pointer<Numa> nax,
            Pointer<Numa> nay, float estthresh, Pointer<Float> pbestthresh) {
        return numaSelectCrossingThreshold(Pointer.getPeer(nax),
                Pointer.getPeer(nay), estthresh, Pointer.getPeer(pbestthresh));
    }

    protected native static int numaSelectCrossingThreshold(@Ptr long nax,
            @Ptr long nay, float estthresh, @Ptr long pbestthresh);

    /**
     * Original signature :
     * <code>NUMA* numaCrossingsByThreshold(NUMA*, NUMA*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1212</i>
     */
    public static Pointer<Numa> numaCrossingsByThreshold(Pointer<Numa> nax,
            Pointer<Numa> nay, float thresh) {
        return (Pointer) Pointer.pointerToAddress(
                numaCrossingsByThreshold(Pointer.getPeer(nax),
                        Pointer.getPeer(nay), thresh), Numa.class);
    }

    @Ptr
    protected native static long numaCrossingsByThreshold(@Ptr long nax,
            @Ptr long nay, float thresh);

    /**
     * Original signature :
     * <code>NUMA* numaCrossingsByPeaks(NUMA*, NUMA*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1213</i>
     */
    public static Pointer<Numa> numaCrossingsByPeaks(Pointer<Numa> nax,
            Pointer<Numa> nay, float delta) {
        return (Pointer) Pointer.pointerToAddress(
                numaCrossingsByPeaks(Pointer.getPeer(nax),
                        Pointer.getPeer(nay), delta), Numa.class);
    }

    @Ptr
    protected native static long numaCrossingsByPeaks(@Ptr long nax,
            @Ptr long nay, float delta);

    /**
     * Original signature :
     * <code>l_int32 numaEvalBestHaarParameters(NUMA*, l_float32, l_int32, l_int32, l_float32, l_float32, l_float32*, l_float32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1214</i>
     */
    public static int numaEvalBestHaarParameters(Pointer<Numa> nas,
            float relweight, int nwidth, int nshift, float minwidth,
            float maxwidth, Pointer<Float> pbestwidth,
            Pointer<Float> pbestshift, Pointer<Float> pbestscore) {
        return numaEvalBestHaarParameters(Pointer.getPeer(nas), relweight,
                nwidth, nshift, minwidth, maxwidth,
                Pointer.getPeer(pbestwidth), Pointer.getPeer(pbestshift),
                Pointer.getPeer(pbestscore));
    }

    protected native static int numaEvalBestHaarParameters(@Ptr long nas,
            float relweight, int nwidth, int nshift, float minwidth,
            float maxwidth, @Ptr long pbestwidth, @Ptr long pbestshift,
            @Ptr long pbestscore);

    /**
     * Original signature :
     * <code>l_int32 numaEvalHaarSum(NUMA*, l_float32, l_float32, l_float32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1215</i>
     */
    public static int numaEvalHaarSum(Pointer<Numa> nas, float width,
            float shift, float relweight, Pointer<Float> pscore) {
        return numaEvalHaarSum(Pointer.getPeer(nas), width, shift, relweight,
                Pointer.getPeer(pscore));
    }

    protected native static int numaEvalHaarSum(@Ptr long nas, float width,
            float shift, float relweight, @Ptr long pscore);

    /**
     * Original signature :
     * <code>l_int32 pixGetRegionsBinary(PIX*, PIX**, PIX**, PIX**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1216</i>
     */
    public static int pixGetRegionsBinary(Pointer<Pix> pixs,
            Pointer<Pointer<Pix>> ppixhm, Pointer<Pointer<Pix>> ppixtm,
            Pointer<Pointer<Pix>> ppixtb, int debug) {
        return pixGetRegionsBinary(Pointer.getPeer(pixs),
                Pointer.getPeer(ppixhm), Pointer.getPeer(ppixtm),
                Pointer.getPeer(ppixtb), debug);
    }

    protected native static int pixGetRegionsBinary(@Ptr long pixs,
            @Ptr long ppixhm, @Ptr long ppixtm, @Ptr long ppixtb, int debug);

    /**
     * Original signature :
     * <code>PIX* pixGenHalftoneMask(PIX*, PIX**, l_int32*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1217</i>
     */
    public static Pointer<Pix> pixGenHalftoneMask(Pointer<Pix> pixs,
            Pointer<Pointer<Pix>> ppixtext, Pointer<Integer> phtfound, int debug) {
        return (Pointer) Pointer.pointerToAddress(
                pixGenHalftoneMask(Pointer.getPeer(pixs),
                        Pointer.getPeer(ppixtext), Pointer.getPeer(phtfound),
                        debug), Pix.class);
    }

    @Ptr
    protected native static long pixGenHalftoneMask(@Ptr long pixs,
            @Ptr long ppixtext, @Ptr long phtfound, int debug);

    /**
     * Original signature :
     * <code>PIX* pixGenTextlineMask(PIX*, PIX**, l_int32*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1218</i>
     */
    public static Pointer<Pix> pixGenTextlineMask(Pointer<Pix> pixs,
            Pointer<Pointer<Pix>> ppixvws, Pointer<Integer> ptlfound, int debug) {
        return (Pointer) Pointer.pointerToAddress(
                pixGenTextlineMask(Pointer.getPeer(pixs),
                        Pointer.getPeer(ppixvws), Pointer.getPeer(ptlfound),
                        debug), Pix.class);
    }

    @Ptr
    protected native static long pixGenTextlineMask(@Ptr long pixs,
            @Ptr long ppixvws, @Ptr long ptlfound, int debug);

    /**
     * Original signature :
     * <code>PIX* pixGenTextblockMask(PIX*, PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1219</i>
     */
    public static Pointer<Pix> pixGenTextblockMask(Pointer<Pix> pixs,
            Pointer<Pix> pixvws, int debug) {
        return (Pointer) Pointer.pointerToAddress(
                pixGenTextblockMask(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixvws), debug), Pix.class);
    }

    @Ptr
    protected native static long pixGenTextblockMask(@Ptr long pixs,
            @Ptr long pixvws, int debug);

    /**
     * Original signature :
     * <code>BOX* pixFindPageForeground(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1220</i>
     */
    public static Pointer<Box> pixFindPageForeground(Pointer<Pix> pixs,
            int threshold, int mindist, int erasedist, int pagenum,
            int showmorph, int display, Pointer<Byte> pdfdir) {
        return (Pointer) Pointer.pointerToAddress(
                pixFindPageForeground(Pointer.getPeer(pixs), threshold,
                        mindist, erasedist, pagenum, showmorph, display,
                        Pointer.getPeer(pdfdir)), Box.class);
    }

    @Ptr
    protected native static long pixFindPageForeground(@Ptr long pixs,
            int threshold, int mindist, int erasedist, int pagenum,
            int showmorph, int display, @Ptr long pdfdir);

    /**
     * Original signature :
     * <code>l_int32 pixSplitIntoCharacters(PIX*, l_int32, l_int32, BOXA**, PIXA**, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1221</i>
     */
    public static int pixSplitIntoCharacters(Pointer<Pix> pixs, int minw,
            int minh, Pointer<Pointer<Boxa>> pboxa,
            Pointer<Pointer<Pixa>> ppixa, Pointer<Pointer<Pix>> ppixdebug) {
        return pixSplitIntoCharacters(Pointer.getPeer(pixs), minw, minh,
                Pointer.getPeer(pboxa), Pointer.getPeer(ppixa),
                Pointer.getPeer(ppixdebug));
    }

    protected native static int pixSplitIntoCharacters(@Ptr long pixs,
            int minw, int minh, @Ptr long pboxa, @Ptr long ppixa,
            @Ptr long ppixdebug);

    /**
     * Original signature :
     * <code>BOXA* pixSplitComponentWithProfile(PIX*, l_int32, l_int32, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1222</i>
     */
    public static Pointer<Boxa> pixSplitComponentWithProfile(Pointer<Pix> pixs,
            int delta, int mindel, Pointer<Pointer<Pix>> ppixdebug) {
        return (Pointer) Pointer.pointerToAddress(
                pixSplitComponentWithProfile(Pointer.getPeer(pixs), delta,
                        mindel, Pointer.getPeer(ppixdebug)), Boxa.class);
    }

    @Ptr
    protected native static long pixSplitComponentWithProfile(@Ptr long pixs,
            int delta, int mindel, @Ptr long ppixdebug);

    /**
     * Original signature :
     * <code>l_int32 pixSetSelectCmap(PIX*, BOX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1223</i>
     */
    public static int pixSetSelectCmap(Pointer<Pix> pixs, Pointer<Box> box,
            int sindex, int rval, int gval, int bval) {
        return pixSetSelectCmap(Pointer.getPeer(pixs), Pointer.getPeer(box),
                sindex, rval, gval, bval);
    }

    protected native static int pixSetSelectCmap(@Ptr long pixs, @Ptr long box,
            int sindex, int rval, int gval, int bval);

    /**
     * Original signature :
     * <code>l_int32 pixColorGrayRegionsCmap(PIX*, BOXA*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1224</i>
     */
    public static int pixColorGrayRegionsCmap(Pointer<Pix> pixs,
            Pointer<Boxa> boxa, int type, int rval, int gval, int bval) {
        return pixColorGrayRegionsCmap(Pointer.getPeer(pixs),
                Pointer.getPeer(boxa), type, rval, gval, bval);
    }

    protected native static int pixColorGrayRegionsCmap(@Ptr long pixs,
            @Ptr long boxa, int type, int rval, int gval, int bval);

    /**
     * Original signature :
     * <code>l_int32 pixColorGrayCmap(PIX*, BOX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1225</i>
     */
    public static int pixColorGrayCmap(Pointer<Pix> pixs, Pointer<Box> box,
            int type, int rval, int gval, int bval) {
        return pixColorGrayCmap(Pointer.getPeer(pixs), Pointer.getPeer(box),
                type, rval, gval, bval);
    }

    protected native static int pixColorGrayCmap(@Ptr long pixs, @Ptr long box,
            int type, int rval, int gval, int bval);

    /**
     * Original signature :
     * <code>l_int32 addColorizedGrayToCmap(PIXCMAP*, l_int32, l_int32, l_int32, l_int32, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1226</i>
     */
    public static int addColorizedGrayToCmap(Pointer<PixColormap> cmap,
            int type, int rval, int gval, int bval, Pointer<Pointer<Numa>> pna) {
        return addColorizedGrayToCmap(Pointer.getPeer(cmap), type, rval, gval,
                bval, Pointer.getPeer(pna));
    }

    protected native static int addColorizedGrayToCmap(@Ptr long cmap,
            int type, int rval, int gval, int bval, @Ptr long pna);

    /**
     * Original signature :
     * <code>l_int32 pixSetSelectMaskedCmap(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1227</i>
     */
    public static int pixSetSelectMaskedCmap(Pointer<Pix> pixs,
            Pointer<Pix> pixm, int x, int y, int sindex, int rval, int gval,
            int bval) {
        return pixSetSelectMaskedCmap(Pointer.getPeer(pixs),
                Pointer.getPeer(pixm), x, y, sindex, rval, gval, bval);
    }

    protected native static int pixSetSelectMaskedCmap(@Ptr long pixs,
            @Ptr long pixm, int x, int y, int sindex, int rval, int gval,
            int bval);

    /**
     * Original signature :
     * <code>l_int32 pixSetMaskedCmap(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1228</i>
     */
    public static int pixSetMaskedCmap(Pointer<Pix> pixs, Pointer<Pix> pixm,
            int x, int y, int rval, int gval, int bval) {
        return pixSetMaskedCmap(Pointer.getPeer(pixs), Pointer.getPeer(pixm),
                x, y, rval, gval, bval);
    }

    protected native static int pixSetMaskedCmap(@Ptr long pixs,
            @Ptr long pixm, int x, int y, int rval, int gval, int bval);

    /**
     * Original signature :
     * <code>char* parseForProtos(const char*, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1229</i>
     */
    public static Pointer<Byte> parseForProtos(Pointer<Byte> filein,
            Pointer<Byte> prestring) {
        return (Pointer) Pointer.pointerToAddress(
                parseForProtos(Pointer.getPeer(filein),
                        Pointer.getPeer(prestring)), Byte.class);
    }

    @Ptr
    protected native static long parseForProtos(@Ptr long filein,
            @Ptr long prestring);

    /**
     * Original signature :
     * <code>BOXA* boxaGetWhiteblocks(BOXA*, BOX*, l_int32, l_int32, l_float32, l_int32, l_float32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1230</i>
     */
    public static Pointer<Boxa> boxaGetWhiteblocks(Pointer<Boxa> boxas,
            Pointer<Box> box, int sortflag, int maxboxes, float maxoverlap,
            int maxperim, float fract, int maxpops) {
        return (Pointer) Pointer.pointerToAddress(
                boxaGetWhiteblocks(Pointer.getPeer(boxas),
                        Pointer.getPeer(box), sortflag, maxboxes, maxoverlap,
                        maxperim, fract, maxpops), Boxa.class);
    }

    @Ptr
    protected native static long boxaGetWhiteblocks(@Ptr long boxas,
            @Ptr long box, int sortflag, int maxboxes, float maxoverlap,
            int maxperim, float fract, int maxpops);

    /**
     * Original signature :
     * <code>BOXA* boxaPruneSortedOnOverlap(BOXA*, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1231</i>
     */
    public static Pointer<Boxa> boxaPruneSortedOnOverlap(Pointer<Boxa> boxas,
            float maxoverlap) {
        return (Pointer) Pointer.pointerToAddress(
                boxaPruneSortedOnOverlap(Pointer.getPeer(boxas), maxoverlap),
                Boxa.class);
    }

    @Ptr
    protected native static long boxaPruneSortedOnOverlap(@Ptr long boxas,
            float maxoverlap);

    /**
     * Original signature :
     * <code>l_int32 convertFilesToPdf(const char*, const char*, l_int32, l_float32, l_int32, l_int32, const char*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1232</i>
     */
    public static int convertFilesToPdf(Pointer<Byte> dirname,
            Pointer<Byte> substr, int res, float scalefactor, int type,
            int quality, Pointer<Byte> title, Pointer<Byte> fileout) {
        return convertFilesToPdf(Pointer.getPeer(dirname),
                Pointer.getPeer(substr), res, scalefactor, type, quality,
                Pointer.getPeer(title), Pointer.getPeer(fileout));
    }

    protected native static int convertFilesToPdf(@Ptr long dirname,
            @Ptr long substr, int res, float scalefactor, int type,
            int quality, @Ptr long title, @Ptr long fileout);

    /**
     * Original signature :
     * <code>l_int32 saConvertFilesToPdf(SARRAY*, l_int32, l_float32, l_int32, l_int32, const char*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1233</i>
     */
    public static int saConvertFilesToPdf(Pointer<Sarray> sa, int res,
            float scalefactor, int type, int quality, Pointer<Byte> title,
            Pointer<Byte> fileout) {
        return saConvertFilesToPdf(Pointer.getPeer(sa), res, scalefactor, type,
                quality, Pointer.getPeer(title), Pointer.getPeer(fileout));
    }

    protected native static int saConvertFilesToPdf(@Ptr long sa, int res,
            float scalefactor, int type, int quality, @Ptr long title,
            @Ptr long fileout);

    /**
     * Original signature :
     * <code>l_int32 saConvertFilesToPdfData(SARRAY*, l_int32, l_float32, l_int32, l_int32, const char*, l_uint8**, size_t*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1234</i>
     */
    public static int saConvertFilesToPdfData(Pointer<Sarray> sa, int res,
            float scalefactor, int type, int quality, Pointer<Byte> title,
            Pointer<Pointer<Byte>> pdata, Pointer<SizeT> pnbytes) {
        return saConvertFilesToPdfData(Pointer.getPeer(sa), res, scalefactor,
                type, quality, Pointer.getPeer(title), Pointer.getPeer(pdata),
                Pointer.getPeer(pnbytes));
    }

    protected native static int saConvertFilesToPdfData(@Ptr long sa, int res,
            float scalefactor, int type, int quality, @Ptr long title,
            @Ptr long pdata, @Ptr long pnbytes);

    /**
     * Original signature :
     * <code>l_int32 selectDefaultPdfEncoding(PIX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1235</i>
     */
    public static int selectDefaultPdfEncoding(Pointer<Pix> pix,
            Pointer<Integer> ptype) {
        return selectDefaultPdfEncoding(Pointer.getPeer(pix),
                Pointer.getPeer(ptype));
    }

    protected native static int selectDefaultPdfEncoding(@Ptr long pix,
            @Ptr long ptype);

    /**
     * Original signature :
     * <code>l_int32 convertUnscaledFilesToPdf(const char*, const char*, const char*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1236</i>
     */
    public static int convertUnscaledFilesToPdf(Pointer<Byte> dirname,
            Pointer<Byte> substr, Pointer<Byte> title, Pointer<Byte> fileout) {
        return convertUnscaledFilesToPdf(Pointer.getPeer(dirname),
                Pointer.getPeer(substr), Pointer.getPeer(title),
                Pointer.getPeer(fileout));
    }

    protected native static int convertUnscaledFilesToPdf(@Ptr long dirname,
            @Ptr long substr, @Ptr long title, @Ptr long fileout);

    /**
     * Original signature :
     * <code>l_int32 saConvertUnscaledFilesToPdf(SARRAY*, const char*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1237</i>
     */
    public static int saConvertUnscaledFilesToPdf(Pointer<Sarray> sa,
            Pointer<Byte> title, Pointer<Byte> fileout) {
        return saConvertUnscaledFilesToPdf(Pointer.getPeer(sa),
                Pointer.getPeer(title), Pointer.getPeer(fileout));
    }

    protected native static int saConvertUnscaledFilesToPdf(@Ptr long sa,
            @Ptr long title, @Ptr long fileout);

    /**
     * Original signature :
     * <code>l_int32 saConvertUnscaledFilesToPdfData(SARRAY*, const char*, l_uint8**, size_t*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1238</i>
     */
    public static int saConvertUnscaledFilesToPdfData(Pointer<Sarray> sa,
            Pointer<Byte> title, Pointer<Pointer<Byte>> pdata,
            Pointer<SizeT> pnbytes) {
        return saConvertUnscaledFilesToPdfData(Pointer.getPeer(sa),
                Pointer.getPeer(title), Pointer.getPeer(pdata),
                Pointer.getPeer(pnbytes));
    }

    protected native static int saConvertUnscaledFilesToPdfData(@Ptr long sa,
            @Ptr long title, @Ptr long pdata, @Ptr long pnbytes);

    /**
     * Original signature :
     * <code>l_int32 convertUnscaledToPdfData(const char*, const char*, l_uint8**, size_t*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1239</i>
     */
    public static int convertUnscaledToPdfData(Pointer<Byte> fname,
            Pointer<Byte> title, Pointer<Pointer<Byte>> pdata,
            Pointer<SizeT> pnbytes) {
        return convertUnscaledToPdfData(Pointer.getPeer(fname),
                Pointer.getPeer(title), Pointer.getPeer(pdata),
                Pointer.getPeer(pnbytes));
    }

    protected native static int convertUnscaledToPdfData(@Ptr long fname,
            @Ptr long title, @Ptr long pdata, @Ptr long pnbytes);

    /**
     * Original signature :
     * <code>l_int32 pixaConvertToPdf(PIXA*, l_int32, l_float32, l_int32, l_int32, const char*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1240</i>
     */
    public static int pixaConvertToPdf(Pointer<Pixa> pixa, int res,
            float scalefactor, int type, int quality, Pointer<Byte> title,
            Pointer<Byte> fileout) {
        return pixaConvertToPdf(Pointer.getPeer(pixa), res, scalefactor, type,
                quality, Pointer.getPeer(title), Pointer.getPeer(fileout));
    }

    protected native static int pixaConvertToPdf(@Ptr long pixa, int res,
            float scalefactor, int type, int quality, @Ptr long title,
            @Ptr long fileout);

    /**
     * Original signature :
     * <code>l_int32 pixaConvertToPdfData(PIXA*, l_int32, l_float32, l_int32, l_int32, const char*, l_uint8**, size_t*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1241</i>
     */
    public static int pixaConvertToPdfData(Pointer<Pixa> pixa, int res,
            float scalefactor, int type, int quality, Pointer<Byte> title,
            Pointer<Pointer<Byte>> pdata, Pointer<SizeT> pnbytes) {
        return pixaConvertToPdfData(Pointer.getPeer(pixa), res, scalefactor,
                type, quality, Pointer.getPeer(title), Pointer.getPeer(pdata),
                Pointer.getPeer(pnbytes));
    }

    protected native static int pixaConvertToPdfData(@Ptr long pixa, int res,
            float scalefactor, int type, int quality, @Ptr long title,
            @Ptr long pdata, @Ptr long pnbytes);

    /**
     * Original signature :
     * <code>l_int32 convertToPdf(const char*, l_int32, l_int32, const char*, l_int32, l_int32, l_int32, const char*, L_PDF_DATA**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1242</i>
     */
    public static int convertToPdf(Pointer<Byte> filein, int type, int quality,
            Pointer<Byte> fileout, int x, int y, int res, Pointer<Byte> title,
            Pointer<Pointer<L_Pdf_Data>> plpd, int position) {
        return convertToPdf(Pointer.getPeer(filein), type, quality,
                Pointer.getPeer(fileout), x, y, res, Pointer.getPeer(title),
                Pointer.getPeer(plpd), position);
    }

    protected native static int convertToPdf(@Ptr long filein, int type,
            int quality, @Ptr long fileout, int x, int y, int res,
            @Ptr long title, @Ptr long plpd, int position);

    /**
     * Original signature :
     * <code>l_int32 convertImageDataToPdf(l_uint8*, size_t, l_int32, l_int32, const char*, l_int32, l_int32, l_int32, const char*, L_PDF_DATA**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1243</i>
     */
    public static int convertImageDataToPdf(Pointer<Byte> imdata,
            @Ptr long size, int type, int quality, Pointer<Byte> fileout,
            int x, int y, int res, Pointer<Byte> title,
            Pointer<Pointer<L_Pdf_Data>> plpd, int position) {
        return convertImageDataToPdf(Pointer.getPeer(imdata), size, type,
                quality, Pointer.getPeer(fileout), x, y, res,
                Pointer.getPeer(title), Pointer.getPeer(plpd), position);
    }

    protected native static int convertImageDataToPdf(@Ptr long imdata,
            @Ptr long size, int type, int quality, @Ptr long fileout, int x,
            int y, int res, @Ptr long title, @Ptr long plpd, int position);

    /**
     * Original signature :
     * <code>l_int32 convertToPdfData(const char*, l_int32, l_int32, l_uint8**, size_t*, l_int32, l_int32, l_int32, const char*, L_PDF_DATA**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1244</i>
     */
    public static int convertToPdfData(Pointer<Byte> filein, int type,
            int quality, Pointer<Pointer<Byte>> pdata, Pointer<SizeT> pnbytes,
            int x, int y, int res, Pointer<Byte> title,
            Pointer<Pointer<L_Pdf_Data>> plpd, int position) {
        return convertToPdfData(Pointer.getPeer(filein), type, quality,
                Pointer.getPeer(pdata), Pointer.getPeer(pnbytes), x, y, res,
                Pointer.getPeer(title), Pointer.getPeer(plpd), position);
    }

    protected native static int convertToPdfData(@Ptr long filein, int type,
            int quality, @Ptr long pdata, @Ptr long pnbytes, int x, int y,
            int res, @Ptr long title, @Ptr long plpd, int position);

    /**
     * Original signature :
     * <code>l_int32 convertImageDataToPdfData(l_uint8*, size_t, l_int32, l_int32, l_uint8**, size_t*, l_int32, l_int32, l_int32, const char*, L_PDF_DATA**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1245</i>
     */
    public static int convertImageDataToPdfData(Pointer<Byte> imdata,
            @Ptr long size, int type, int quality,
            Pointer<Pointer<Byte>> pdata, Pointer<SizeT> pnbytes, int x, int y,
            int res, Pointer<Byte> title, Pointer<Pointer<L_Pdf_Data>> plpd,
            int position) {
        return convertImageDataToPdfData(Pointer.getPeer(imdata), size, type,
                quality, Pointer.getPeer(pdata), Pointer.getPeer(pnbytes), x,
                y, res, Pointer.getPeer(title), Pointer.getPeer(plpd), position);
    }

    protected native static int convertImageDataToPdfData(@Ptr long imdata,
            @Ptr long size, int type, int quality, @Ptr long pdata,
            @Ptr long pnbytes, int x, int y, int res, @Ptr long title,
            @Ptr long plpd, int position);

    /**
     * Original signature :
     * <code>l_int32 pixConvertToPdf(PIX*, l_int32, l_int32, const char*, l_int32, l_int32, l_int32, const char*, L_PDF_DATA**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1246</i>
     */
    public static int pixConvertToPdf(Pointer<Pix> pix, int type, int quality,
            Pointer<Byte> fileout, int x, int y, int res, Pointer<Byte> title,
            Pointer<Pointer<L_Pdf_Data>> plpd, int position) {
        return pixConvertToPdf(Pointer.getPeer(pix), type, quality,
                Pointer.getPeer(fileout), x, y, res, Pointer.getPeer(title),
                Pointer.getPeer(plpd), position);
    }

    protected native static int pixConvertToPdf(@Ptr long pix, int type,
            int quality, @Ptr long fileout, int x, int y, int res,
            @Ptr long title, @Ptr long plpd, int position);

    /**
     * Original signature :
     * <code>l_int32 pixConvertToPdfData(PIX*, l_int32, l_int32, l_uint8**, size_t*, l_int32, l_int32, l_int32, const char*, L_PDF_DATA**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1247</i>
     */
    public static int pixConvertToPdfData(Pointer<Pix> pix, int type,
            int quality, Pointer<Pointer<Byte>> pdata, Pointer<SizeT> pnbytes,
            int x, int y, int res, Pointer<Byte> title,
            Pointer<Pointer<L_Pdf_Data>> plpd, int position) {
        return pixConvertToPdfData(Pointer.getPeer(pix), type, quality,
                Pointer.getPeer(pdata), Pointer.getPeer(pnbytes), x, y, res,
                Pointer.getPeer(title), Pointer.getPeer(plpd), position);
    }

    protected native static int pixConvertToPdfData(@Ptr long pix, int type,
            int quality, @Ptr long pdata, @Ptr long pnbytes, int x, int y,
            int res, @Ptr long title, @Ptr long plpd, int position);

    /**
     * Original signature :
     * <code>l_int32 pixWriteStreamPdf(FILE*, PIX*, l_int32, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1248</i>
     */
    public static int pixWriteStreamPdf(Pointer<FILE> fp,
            Pointer<Pix> pix, int res, Pointer<Byte> title) {
        return pixWriteStreamPdf(Pointer.getPeer(fp), Pointer.getPeer(pix),
                res, Pointer.getPeer(title));
    }

    protected native static int pixWriteStreamPdf(@Ptr long fp, @Ptr long pix,
            int res, @Ptr long title);

    /**
     * Original signature :
     * <code>l_int32 convertSegmentedFilesToPdf(const char*, const char*, l_int32, l_int32, l_int32, BOXAA*, l_int32, l_float32, const char*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1249</i>
     */
    public static int convertSegmentedFilesToPdf(Pointer<Byte> dirname,
            Pointer<Byte> substr, int res, int type, int thresh,
            Pointer<Boxaa> baa, int quality, float scalefactor,
            Pointer<Byte> title, Pointer<Byte> fileout) {
        return convertSegmentedFilesToPdf(Pointer.getPeer(dirname),
                Pointer.getPeer(substr), res, type, thresh,
                Pointer.getPeer(baa), quality, scalefactor,
                Pointer.getPeer(title), Pointer.getPeer(fileout));
    }

    protected native static int convertSegmentedFilesToPdf(@Ptr long dirname,
            @Ptr long substr, int res, int type, int thresh, @Ptr long baa,
            int quality, float scalefactor, @Ptr long title, @Ptr long fileout);

    /**
     * Original signature :
     * <code>BOXAA* convertNumberedMasksToBoxaa(const char*, const char*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1250</i>
     */
    public static Pointer<Boxaa> convertNumberedMasksToBoxaa(
            Pointer<Byte> dirname, Pointer<Byte> substr, int numpre, int numpost) {
        return (Pointer) Pointer.pointerToAddress(
                convertNumberedMasksToBoxaa(Pointer.getPeer(dirname),
                        Pointer.getPeer(substr), numpre, numpost), Boxaa.class);
    }

    @Ptr
    protected native static long convertNumberedMasksToBoxaa(@Ptr long dirname,
            @Ptr long substr, int numpre, int numpost);

    /**
     * Original signature :
     * <code>l_int32 convertToPdfSegmented(const char*, l_int32, l_int32, l_int32, BOXA*, l_int32, l_float32, const char*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1251</i>
     */
    public static int convertToPdfSegmented(Pointer<Byte> filein, int res,
            int type, int thresh, Pointer<Boxa> boxa, int quality,
            float scalefactor, Pointer<Byte> title, Pointer<Byte> fileout) {
        return convertToPdfSegmented(Pointer.getPeer(filein), res, type,
                thresh, Pointer.getPeer(boxa), quality, scalefactor,
                Pointer.getPeer(title), Pointer.getPeer(fileout));
    }

    protected native static int convertToPdfSegmented(@Ptr long filein,
            int res, int type, int thresh, @Ptr long boxa, int quality,
            float scalefactor, @Ptr long title, @Ptr long fileout);

    /**
     * Original signature :
     * <code>l_int32 pixConvertToPdfSegmented(PIX*, l_int32, l_int32, l_int32, BOXA*, l_int32, l_float32, const char*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1252</i>
     */
    public static int pixConvertToPdfSegmented(Pointer<Pix> pixs, int res,
            int type, int thresh, Pointer<Boxa> boxa, int quality,
            float scalefactor, Pointer<Byte> title, Pointer<Byte> fileout) {
        return pixConvertToPdfSegmented(Pointer.getPeer(pixs), res, type,
                thresh, Pointer.getPeer(boxa), quality, scalefactor,
                Pointer.getPeer(title), Pointer.getPeer(fileout));
    }

    protected native static int pixConvertToPdfSegmented(@Ptr long pixs,
            int res, int type, int thresh, @Ptr long boxa, int quality,
            float scalefactor, @Ptr long title, @Ptr long fileout);

    /**
     * Original signature :
     * <code>l_int32 convertToPdfDataSegmented(const char*, l_int32, l_int32, l_int32, BOXA*, l_int32, l_float32, const char*, l_uint8**, size_t*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1253</i>
     */
    public static int convertToPdfDataSegmented(Pointer<Byte> filein, int res,
            int type, int thresh, Pointer<Boxa> boxa, int quality,
            float scalefactor, Pointer<Byte> title,
            Pointer<Pointer<Byte>> pdata, Pointer<SizeT> pnbytes) {
        return convertToPdfDataSegmented(Pointer.getPeer(filein), res, type,
                thresh, Pointer.getPeer(boxa), quality, scalefactor,
                Pointer.getPeer(title), Pointer.getPeer(pdata),
                Pointer.getPeer(pnbytes));
    }

    protected native static int convertToPdfDataSegmented(@Ptr long filein,
            int res, int type, int thresh, @Ptr long boxa, int quality,
            float scalefactor, @Ptr long title, @Ptr long pdata,
            @Ptr long pnbytes);

    /**
     * Original signature :
     * <code>l_int32 pixConvertToPdfDataSegmented(PIX*, l_int32, l_int32, l_int32, BOXA*, l_int32, l_float32, const char*, l_uint8**, size_t*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1254</i>
     */
    public static int pixConvertToPdfDataSegmented(Pointer<Pix> pixs, int res,
            int type, int thresh, Pointer<Boxa> boxa, int quality,
            float scalefactor, Pointer<Byte> title,
            Pointer<Pointer<Byte>> pdata, Pointer<SizeT> pnbytes) {
        return pixConvertToPdfDataSegmented(Pointer.getPeer(pixs), res, type,
                thresh, Pointer.getPeer(boxa), quality, scalefactor,
                Pointer.getPeer(title), Pointer.getPeer(pdata),
                Pointer.getPeer(pnbytes));
    }

    protected native static int pixConvertToPdfDataSegmented(@Ptr long pixs,
            int res, int type, int thresh, @Ptr long boxa, int quality,
            float scalefactor, @Ptr long title, @Ptr long pdata,
            @Ptr long pnbytes);

    /**
     * Original signature :
     * <code>l_int32 concatenatePdf(const char*, const char*, const char*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1255</i>
     */
    public static int concatenatePdf(Pointer<Byte> dirname,
            Pointer<Byte> substr, Pointer<Byte> fileout) {
        return concatenatePdf(Pointer.getPeer(dirname),
                Pointer.getPeer(substr), Pointer.getPeer(fileout));
    }

    protected native static int concatenatePdf(@Ptr long dirname,
            @Ptr long substr, @Ptr long fileout);

    /**
     * Original signature :
     * <code>l_int32 saConcatenatePdf(SARRAY*, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1256</i>
     */
    public static int saConcatenatePdf(Pointer<Sarray> sa, Pointer<Byte> fileout) {
        return saConcatenatePdf(Pointer.getPeer(sa), Pointer.getPeer(fileout));
    }

    protected native static int saConcatenatePdf(@Ptr long sa, @Ptr long fileout) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 ptraConcatenatePdf(L_PTRA*, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1257</i>
     */
    public static int ptraConcatenatePdf(Pointer<L_Ptra> pa,
            Pointer<Byte> fileout) {
        return ptraConcatenatePdf(Pointer.getPeer(pa), Pointer.getPeer(fileout));
    }

    protected native static int ptraConcatenatePdf(@Ptr long pa,
            @Ptr long fileout);

    /**
     * Original signature :
     * <code>l_int32 concatenatePdfToData(const char*, const char*, l_uint8**, size_t*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1258</i>
     */
    public static int concatenatePdfToData(Pointer<Byte> dirname,
            Pointer<Byte> substr, Pointer<Pointer<Byte>> pdata,
            Pointer<SizeT> pnbytes) {
        return concatenatePdfToData(Pointer.getPeer(dirname),
                Pointer.getPeer(substr), Pointer.getPeer(pdata),
                Pointer.getPeer(pnbytes));
    }

    protected native static int concatenatePdfToData(@Ptr long dirname,
            @Ptr long substr, @Ptr long pdata, @Ptr long pnbytes);

    /**
     * Original signature :
     * <code>l_int32 saConcatenatePdfToData(SARRAY*, l_uint8**, size_t*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1259</i>
     */
    public static int saConcatenatePdfToData(Pointer<Sarray> sa,
            Pointer<Pointer<Byte>> pdata, Pointer<SizeT> pnbytes) {
        return saConcatenatePdfToData(Pointer.getPeer(sa),
                Pointer.getPeer(pdata), Pointer.getPeer(pnbytes));
    }

    protected native static int saConcatenatePdfToData(@Ptr long sa,
            @Ptr long pdata, @Ptr long pnbytes);

    /**
     * Original signature :
     * <code>l_int32 ptraConcatenatePdfToData(L_PTRA*, SARRAY*, l_uint8**, size_t*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1260</i>
     */
    public static int ptraConcatenatePdfToData(Pointer<L_Ptra> pa_data,
            Pointer<Sarray> sa, Pointer<Pointer<Byte>> pdata,
            Pointer<SizeT> pnbytes) {
        return ptraConcatenatePdfToData(Pointer.getPeer(pa_data),
                Pointer.getPeer(sa), Pointer.getPeer(pdata),
                Pointer.getPeer(pnbytes));
    }

    protected native static int ptraConcatenatePdfToData(@Ptr long pa_data,
            @Ptr long sa, @Ptr long pdata, @Ptr long pnbytes);

    /**
     * Original signature : <code>void l_pdfSetG4ImageMask(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1261</i>
     */
    public static native void l_pdfSetG4ImageMask(int flag) throws LastError;

    /**
     * Original signature : <code>void l_pdfSetDateAndVersion(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1262</i>
     */
    public static native void l_pdfSetDateAndVersion(int flag) throws LastError;

    protected native static void setPixMemoryManager(@Ptr long allocator,
            @Ptr long deallocator);

    /**
     * Original signature :
     * <code>PIX* pixCreate(l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1264</i>
     */
    public static Pointer<Pix> pixCreate(int width, int height, int depth) {
        return (Pointer) Pointer.pointerToAddress(
                pixCreate$2(width, height, depth), Pix.class);
    }

    @Ptr
    @Name("pixCreate")
    protected native static long pixCreate$2(int width, int height, int depth) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixCreateNoInit(l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1265</i>
     */
    public static Pointer<Pix> pixCreateNoInit(int width, int height, int depth) {
        return (Pointer) Pointer.pointerToAddress(
                pixCreateNoInit$2(width, height, depth), Pix.class);
    }

    @Ptr
    @Name("pixCreateNoInit")
    protected native static long pixCreateNoInit$2(int width, int height,
            int depth);

    /**
     * Original signature : <code>PIX* pixCreateTemplate(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1266</i>
     */
    public static Pointer<Pix> pixCreateTemplate(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixCreateTemplate(Pointer.getPeer(pixs)), Pix.class);
    }

    @Ptr
    protected native static long pixCreateTemplate(@Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>PIX* pixCreateTemplateNoInit(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1267</i>
     */
    public static Pointer<Pix> pixCreateTemplateNoInit(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixCreateTemplateNoInit(Pointer.getPeer(pixs)), Pix.class);
    }

    @Ptr
    protected native static long pixCreateTemplateNoInit(@Ptr long pixs) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixCreateHeader(l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1268</i>
     */
    public static Pointer<Pix> pixCreateHeader(int width, int height, int depth) {
        return (Pointer) Pointer.pointerToAddress(
                pixCreateHeader$2(width, height, depth), Pix.class);
    }

    @Ptr
    @Name("pixCreateHeader")
    protected native static long pixCreateHeader$2(int width, int height,
            int depth);

    /**
     * Original signature : <code>PIX* pixClone(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1269</i>
     */
    public static Pointer<Pix> pixClone(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixClone(Pointer.getPeer(pixs)), Pix.class);
    }

    @Ptr
    protected native static long pixClone(@Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>void pixDestroy(PIX**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1270</i>
     */
    public static void pixDestroy(Pointer<Pointer<Pix>> ppix) {
        pixDestroy(Pointer.getPeer(ppix));
    }

    protected native static void pixDestroy(@Ptr long ppix) throws LastError;

    /**
     * Original signature : <code>PIX* pixCopy(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1271</i>
     */
    public static Pointer<Pix> pixCopy(Pointer<Pix> pixd, Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixCopy(Pointer.getPeer(pixd), Pointer.getPeer(pixs)),
                Pix.class);
    }

    @Ptr
    protected native static long pixCopy(@Ptr long pixd, @Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>l_int32 pixResizeImageData(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1272</i>
     */
    public static int pixResizeImageData(Pointer<Pix> pixd, Pointer<Pix> pixs) {
        return pixResizeImageData(Pointer.getPeer(pixd), Pointer.getPeer(pixs));
    }

    protected native static int pixResizeImageData(@Ptr long pixd,
            @Ptr long pixs);

    /**
     * Original signature : <code>l_int32 pixCopyColormap(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1273</i>
     */
    public static int pixCopyColormap(Pointer<Pix> pixd, Pointer<Pix> pixs) {
        return pixCopyColormap(Pointer.getPeer(pixd), Pointer.getPeer(pixs));
    }

    protected native static int pixCopyColormap(@Ptr long pixd, @Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSizesEqual(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1274</i>
     */
    public static int pixSizesEqual(Pointer<Pix> pix1, Pointer<Pix> pix2) {
        return pixSizesEqual(Pointer.getPeer(pix1), Pointer.getPeer(pix2));
    }

    protected native static int pixSizesEqual(@Ptr long pix1, @Ptr long pix2) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixTransferAllData(PIX*, PIX**, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1275</i>
     */
    public static int pixTransferAllData(Pointer<Pix> pixd,
            Pointer<Pointer<Pix>> ppixs, int copytext, int copyformat) {
        return pixTransferAllData(Pointer.getPeer(pixd),
                Pointer.getPeer(ppixs), copytext, copyformat);
    }

    protected native static int pixTransferAllData(@Ptr long pixd,
            @Ptr long ppixs, int copytext, int copyformat);

    /**
     * Original signature : <code>l_int32 pixSwapAndDestroy(PIX**, PIX**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1276</i>
     */
    public static int pixSwapAndDestroy(Pointer<Pointer<Pix>> ppixd,
            Pointer<Pointer<Pix>> ppixs) {
        return pixSwapAndDestroy(Pointer.getPeer(ppixd), Pointer.getPeer(ppixs));
    }

    protected native static int pixSwapAndDestroy(@Ptr long ppixd,
            @Ptr long ppixs);

    /**
     * Original signature : <code>l_int32 pixGetWidth(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1277</i>
     */
    public static int pixGetWidth(Pointer<Pix> pix) {
        return pixGetWidth(Pointer.getPeer(pix));
    }

    protected native static int pixGetWidth(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSetWidth(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1278</i>
     */
    public static int pixSetWidth(Pointer<Pix> pix, int width) {
        return pixSetWidth(Pointer.getPeer(pix), width);
    }

    protected native static int pixSetWidth(@Ptr long pix, int width) throws LastError;

    /**
     * Original signature : <code>l_int32 pixGetHeight(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1279</i>
     */
    public static int pixGetHeight(Pointer<Pix> pix) {
        return pixGetHeight(Pointer.getPeer(pix));
    }

    protected native static int pixGetHeight(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSetHeight(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1280</i>
     */
    public static int pixSetHeight(Pointer<Pix> pix, int height) {
        return pixSetHeight(Pointer.getPeer(pix), height);
    }

    protected native static int pixSetHeight(@Ptr long pix, int height) throws LastError;

    /**
     * Original signature : <code>l_int32 pixGetDepth(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1281</i>
     */
    public static int pixGetDepth(Pointer<Pix> pix) {
        return pixGetDepth(Pointer.getPeer(pix));
    }

    protected native static int pixGetDepth(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSetDepth(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1282</i>
     */
    public static int pixSetDepth(Pointer<Pix> pix, int depth) {
        return pixSetDepth(Pointer.getPeer(pix), depth);
    }

    protected native static int pixSetDepth(@Ptr long pix, int depth) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixGetDimensions(PIX*, l_int32*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1283</i>
     */
    public static int pixGetDimensions(Pointer<Pix> pix, Pointer<Integer> pw,
            Pointer<Integer> ph, Pointer<Integer> pd) {
        return pixGetDimensions(Pointer.getPeer(pix), Pointer.getPeer(pw),
                Pointer.getPeer(ph), Pointer.getPeer(pd));
    }

    protected native static int pixGetDimensions(@Ptr long pix, @Ptr long pw,
            @Ptr long ph, @Ptr long pd);

    /**
     * Original signature :
     * <code>l_int32 pixSetDimensions(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1284</i>
     */
    public static int pixSetDimensions(Pointer<Pix> pix, int w, int h, int d) {
        return pixSetDimensions(Pointer.getPeer(pix), w, h, d);
    }

    protected native static int pixSetDimensions(@Ptr long pix, int w, int h,
            int d);

    /**
     * Original signature : <code>l_int32 pixCopyDimensions(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1285</i>
     */
    public static int pixCopyDimensions(Pointer<Pix> pixd, Pointer<Pix> pixs) {
        return pixCopyDimensions(Pointer.getPeer(pixd), Pointer.getPeer(pixs));
    }

    protected native static int pixCopyDimensions(@Ptr long pixd, @Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>l_int32 pixGetSpp(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1286</i>
     */
    public static int pixGetSpp(Pointer<Pix> pix) {
        return pixGetSpp(Pointer.getPeer(pix));
    }

    protected native static int pixGetSpp(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSetSpp(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1287</i>
     */
    public static int pixSetSpp(Pointer<Pix> pix, int spp) {
        return pixSetSpp(Pointer.getPeer(pix), spp);
    }

    protected native static int pixSetSpp(@Ptr long pix, int spp) throws LastError;

    /**
     * Original signature : <code>l_int32 pixCopySpp(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1288</i>
     */
    public static int pixCopySpp(Pointer<Pix> pixd, Pointer<Pix> pixs) {
        return pixCopySpp(Pointer.getPeer(pixd), Pointer.getPeer(pixs));
    }

    protected native static int pixCopySpp(@Ptr long pixd, @Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>l_int32 pixGetWpl(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1289</i>
     */
    public static int pixGetWpl(Pointer<Pix> pix) {
        return pixGetWpl(Pointer.getPeer(pix));
    }

    protected native static int pixGetWpl(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSetWpl(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1290</i>
     */
    public static int pixSetWpl(Pointer<Pix> pix, int wpl) {
        return pixSetWpl(Pointer.getPeer(pix), wpl);
    }

    protected native static int pixSetWpl(@Ptr long pix, int wpl) throws LastError;

    /**
     * Original signature : <code>l_int32 pixGetRefcount(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1291</i>
     */
    public static int pixGetRefcount(Pointer<Pix> pix) {
        return pixGetRefcount(Pointer.getPeer(pix));
    }

    protected native static int pixGetRefcount(@Ptr long pix) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixChangeRefcount(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1292</i>
     */
    public static int pixChangeRefcount(Pointer<Pix> pix, int delta) {
        return pixChangeRefcount(Pointer.getPeer(pix), delta);
    }

    protected native static int pixChangeRefcount(@Ptr long pix, int delta) throws LastError;

    /**
     * Original signature : <code>l_int32 pixGetXRes(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1293</i>
     */
    public static int pixGetXRes(Pointer<Pix> pix) {
        return pixGetXRes(Pointer.getPeer(pix));
    }

    protected native static int pixGetXRes(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSetXRes(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1294</i>
     */
    public static int pixSetXRes(Pointer<Pix> pix, int res) {
        return pixSetXRes(Pointer.getPeer(pix), res);
    }

    protected native static int pixSetXRes(@Ptr long pix, int res) throws LastError;

    /**
     * Original signature : <code>l_int32 pixGetYRes(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1295</i>
     */
    public static int pixGetYRes(Pointer<Pix> pix) {
        return pixGetYRes(Pointer.getPeer(pix));
    }

    protected native static int pixGetYRes(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSetYRes(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1296</i>
     */
    public static int pixSetYRes(Pointer<Pix> pix, int res) {
        return pixSetYRes(Pointer.getPeer(pix), res);
    }

    protected native static int pixSetYRes(@Ptr long pix, int res) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixGetResolution(PIX*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1297</i>
     */
    public static int pixGetResolution(Pointer<Pix> pix,
            Pointer<Integer> pxres, Pointer<Integer> pyres) {
        return pixGetResolution(Pointer.getPeer(pix), Pointer.getPeer(pxres),
                Pointer.getPeer(pyres));
    }

    protected native static int pixGetResolution(@Ptr long pix,
            @Ptr long pxres, @Ptr long pyres);

    /**
     * Original signature :
     * <code>l_int32 pixSetResolution(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1298</i>
     */
    public static int pixSetResolution(Pointer<Pix> pix, int xres, int yres) {
        return pixSetResolution(Pointer.getPeer(pix), xres, yres);
    }

    protected native static int pixSetResolution(@Ptr long pix, int xres,
            int yres);

    /**
     * Original signature : <code>l_int32 pixCopyResolution(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1299</i>
     */
    public static int pixCopyResolution(Pointer<Pix> pixd, Pointer<Pix> pixs) {
        return pixCopyResolution(Pointer.getPeer(pixd), Pointer.getPeer(pixs));
    }

    protected native static int pixCopyResolution(@Ptr long pixd, @Ptr long pixs) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixScaleResolution(PIX*, l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1300</i>
     */
    public static int pixScaleResolution(Pointer<Pix> pix, float xscale,
            float yscale) {
        return pixScaleResolution(Pointer.getPeer(pix), xscale, yscale);
    }

    protected native static int pixScaleResolution(@Ptr long pix, float xscale,
            float yscale);

    /**
     * Original signature : <code>l_int32 pixGetInputFormat(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1301</i>
     */
    public static int pixGetInputFormat(Pointer<Pix> pix) {
        return pixGetInputFormat(Pointer.getPeer(pix));
    }

    protected native static int pixGetInputFormat(@Ptr long pix) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixSetInputFormat(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1302</i>
     */
    public static int pixSetInputFormat(Pointer<Pix> pix, int informat) {
        return pixSetInputFormat(Pointer.getPeer(pix), informat);
    }

    protected native static int pixSetInputFormat(@Ptr long pix, int informat) throws LastError;

    /**
     * Original signature : <code>l_int32 pixCopyInputFormat(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1303</i>
     */
    public static int pixCopyInputFormat(Pointer<Pix> pixd, Pointer<Pix> pixs) {
        return pixCopyInputFormat(Pointer.getPeer(pixd), Pointer.getPeer(pixs));
    }

    protected native static int pixCopyInputFormat(@Ptr long pixd,
            @Ptr long pixs);

    /**
     * Original signature : <code>char* pixGetText(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1304</i>
     */
    public static Pointer<Byte> pixGetText(Pointer<Pix> pix) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetText(Pointer.getPeer(pix)), Byte.class);
    }

    @Ptr
    protected native static long pixGetText(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSetText(PIX*, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1305</i>
     */
    public static int pixSetText(Pointer<Pix> pix, Pointer<Byte> textstring) {
        return pixSetText(Pointer.getPeer(pix), Pointer.getPeer(textstring));
    }

    protected native static int pixSetText(@Ptr long pix, @Ptr long textstring) throws LastError;

    /**
     * Original signature : <code>l_int32 pixAddText(PIX*, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1306</i>
     */
    public static int pixAddText(Pointer<Pix> pix, Pointer<Byte> textstring) {
        return pixAddText(Pointer.getPeer(pix), Pointer.getPeer(textstring));
    }

    protected native static int pixAddText(@Ptr long pix, @Ptr long textstring) throws LastError;

    /**
     * Original signature : <code>l_int32 pixCopyText(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1307</i>
     */
    public static int pixCopyText(Pointer<Pix> pixd, Pointer<Pix> pixs) {
        return pixCopyText(Pointer.getPeer(pixd), Pointer.getPeer(pixs));
    }

    protected native static int pixCopyText(@Ptr long pixd, @Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>PIXCMAP* pixGetColormap(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1308</i>
     */
    public static Pointer<PixColormap> pixGetColormap(Pointer<Pix> pix) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetColormap(Pointer.getPeer(pix)), PixColormap.class);
    }

    @Ptr
    protected native static long pixGetColormap(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSetColormap(PIX*, PIXCMAP*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1309</i>
     */
    public static int pixSetColormap(Pointer<Pix> pix,
            Pointer<PixColormap> colormap) {
        return pixSetColormap(Pointer.getPeer(pix), Pointer.getPeer(colormap));
    }

    protected native static int pixSetColormap(@Ptr long pix, @Ptr long colormap) throws LastError;

    /**
     * Original signature : <code>l_int32 pixDestroyColormap(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1310</i>
     */
    public static int pixDestroyColormap(Pointer<Pix> pix) {
        return pixDestroyColormap(Pointer.getPeer(pix));
    }

    protected native static int pixDestroyColormap(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>l_uint32* pixGetData(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1311</i>
     */
    public static Pointer<Integer> pixGetData(Pointer<Pix> pix) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetData(Pointer.getPeer(pix)), Integer.class);
    }

    @Ptr
    protected native static long pixGetData(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSetData(PIX*, l_uint32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1312</i>
     */
    public static int pixSetData(Pointer<Pix> pix, Pointer<Integer> data) {
        return pixSetData(Pointer.getPeer(pix), Pointer.getPeer(data));
    }

    protected native static int pixSetData(@Ptr long pix, @Ptr long data) throws LastError;

    /**
     * Original signature : <code>l_uint32* pixExtractData(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1313</i>
     */
    public static Pointer<Integer> pixExtractData(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixExtractData(Pointer.getPeer(pixs)), Integer.class);
    }

    @Ptr
    protected native static long pixExtractData(@Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>l_int32 pixFreeData(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1314</i>
     */
    public static int pixFreeData(Pointer<Pix> pix) {
        return pixFreeData(Pointer.getPeer(pix));
    }

    protected native static int pixFreeData(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>void** pixGetLinePtrs(PIX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1315</i>
     */
    public static Pointer<Pointer<?>> pixGetLinePtrs(Pointer<Pix> pix,
            Pointer<Integer> psize) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetLinePtrs(Pointer.getPeer(pix), Pointer.getPeer(psize)),
                DefaultParameterizedType.paramType(Pointer.class, null));
    }

    @Ptr
    protected native static long pixGetLinePtrs(@Ptr long pix, @Ptr long psize) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixPrintStreamInfo(FILE*, PIX*, const char*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1316</i>
     */
    public static int pixPrintStreamInfo(Pointer<FILE> fp,
            Pointer<Pix> pix, Pointer<Byte> text) {
        return pixPrintStreamInfo(Pointer.getPeer(fp), Pointer.getPeer(pix),
                Pointer.getPeer(text));
    }

    protected native static int pixPrintStreamInfo(@Ptr long fp, @Ptr long pix,
            @Ptr long text);

    /**
     * Original signature :
     * <code>l_int32 pixGetPixel(PIX*, l_int32, l_int32, l_uint32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1317</i>
     */
    public static int pixGetPixel(Pointer<Pix> pix, int x, int y,
            Pointer<Integer> pval) {
        return pixGetPixel(Pointer.getPeer(pix), x, y, Pointer.getPeer(pval));
    }

    protected native static int pixGetPixel(@Ptr long pix, int x, int y,
            @Ptr long pval);

    /**
     * Original signature :
     * <code>l_int32 pixSetPixel(PIX*, l_int32, l_int32, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1318</i>
     */
    public static int pixSetPixel(Pointer<Pix> pix, int x, int y, int val) {
        return pixSetPixel(Pointer.getPeer(pix), x, y, val);
    }

    protected native static int pixSetPixel(@Ptr long pix, int x, int y, int val) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixGetRGBPixel(PIX*, l_int32, l_int32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1319</i>
     */
    public static int pixGetRGBPixel(Pointer<Pix> pix, int x, int y,
            Pointer<Integer> prval, Pointer<Integer> pgval,
            Pointer<Integer> pbval) {
        return pixGetRGBPixel(Pointer.getPeer(pix), x, y,
                Pointer.getPeer(prval), Pointer.getPeer(pgval),
                Pointer.getPeer(pbval));
    }

    protected native static int pixGetRGBPixel(@Ptr long pix, int x, int y,
            @Ptr long prval, @Ptr long pgval, @Ptr long pbval);

    /**
     * Original signature :
     * <code>l_int32 pixSetRGBPixel(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1320</i>
     */
    public static int pixSetRGBPixel(Pointer<Pix> pix, int x, int y, int rval,
            int gval, int bval) {
        return pixSetRGBPixel(Pointer.getPeer(pix), x, y, rval, gval, bval);
    }

    protected native static int pixSetRGBPixel(@Ptr long pix, int x, int y,
            int rval, int gval, int bval);

    /**
     * Original signature :
     * <code>l_int32 pixGetRandomPixel(PIX*, l_uint32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1321</i>
     */
    public static int pixGetRandomPixel(Pointer<Pix> pix,
            Pointer<Integer> pval, Pointer<Integer> px, Pointer<Integer> py) {
        return pixGetRandomPixel(Pointer.getPeer(pix), Pointer.getPeer(pval),
                Pointer.getPeer(px), Pointer.getPeer(py));
    }

    protected native static int pixGetRandomPixel(@Ptr long pix,
            @Ptr long pval, @Ptr long px, @Ptr long py);

    /**
     * Original signature :
     * <code>l_int32 pixClearPixel(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1322</i>
     */
    public static int pixClearPixel(Pointer<Pix> pix, int x, int y) {
        return pixClearPixel(Pointer.getPeer(pix), x, y);
    }

    protected native static int pixClearPixel(@Ptr long pix, int x, int y) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixFlipPixel(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1323</i>
     */
    public static int pixFlipPixel(Pointer<Pix> pix, int x, int y) {
        return pixFlipPixel(Pointer.getPeer(pix), x, y);
    }

    protected native static int pixFlipPixel(@Ptr long pix, int x, int y) throws LastError;

    /**
     * Original signature :
     * <code>void setPixelLow(l_uint32*, l_int32, l_int32, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1324</i>
     */
    public static void setPixelLow(Pointer<Integer> line, int x, int depth,
            int val) {
        setPixelLow(Pointer.getPeer(line), x, depth, val);
    }

    protected native static void setPixelLow(@Ptr long line, int x, int depth,
            int val);

    /**
     * Original signature :
     * <code>l_int32 pixGetBlackOrWhiteVal(PIX*, l_int32, l_uint32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1325</i>
     */
    public static int pixGetBlackOrWhiteVal(Pointer<Pix> pixs, int op,
            Pointer<Integer> pval) {
        return pixGetBlackOrWhiteVal(Pointer.getPeer(pixs), op,
                Pointer.getPeer(pval));
    }

    protected native static int pixGetBlackOrWhiteVal(@Ptr long pixs, int op,
            @Ptr long pval);

    /**
     * Original signature : <code>l_int32 pixClearAll(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1326</i>
     */
    public static int pixClearAll(Pointer<Pix> pix) {
        return pixClearAll(Pointer.getPeer(pix));
    }

    protected native static int pixClearAll(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSetAll(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1327</i>
     */
    public static int pixSetAll(Pointer<Pix> pix) {
        return pixSetAll(Pointer.getPeer(pix));
    }

    protected native static int pixSetAll(@Ptr long pix) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSetAllGray(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1328</i>
     */
    public static int pixSetAllGray(Pointer<Pix> pix, int grayval) {
        return pixSetAllGray(Pointer.getPeer(pix), grayval);
    }

    protected native static int pixSetAllGray(@Ptr long pix, int grayval) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixSetAllArbitrary(PIX*, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1329</i>
     */
    public static int pixSetAllArbitrary(Pointer<Pix> pix, int val) {
        return pixSetAllArbitrary(Pointer.getPeer(pix), val);
    }

    protected native static int pixSetAllArbitrary(@Ptr long pix, int val) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixSetBlackOrWhite(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1330</i>
     */
    public static int pixSetBlackOrWhite(Pointer<Pix> pixs, int op) {
        return pixSetBlackOrWhite(Pointer.getPeer(pixs), op);
    }

    protected native static int pixSetBlackOrWhite(@Ptr long pixs, int op) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixSetComponentArbitrary(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1331</i>
     */
    public static int pixSetComponentArbitrary(Pointer<Pix> pix, int comp,
            int val) {
        return pixSetComponentArbitrary(Pointer.getPeer(pix), comp, val);
    }

    protected native static int pixSetComponentArbitrary(@Ptr long pix,
            int comp, int val);

    /**
     * Original signature : <code>l_int32 pixClearInRect(PIX*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1332</i>
     */
    public static int pixClearInRect(Pointer<Pix> pix, Pointer<Box> box) {
        return pixClearInRect(Pointer.getPeer(pix), Pointer.getPeer(box));
    }

    protected native static int pixClearInRect(@Ptr long pix, @Ptr long box) throws LastError;

    /**
     * Original signature : <code>l_int32 pixSetInRect(PIX*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1333</i>
     */
    public static int pixSetInRect(Pointer<Pix> pix, Pointer<Box> box) {
        return pixSetInRect(Pointer.getPeer(pix), Pointer.getPeer(box));
    }

    protected native static int pixSetInRect(@Ptr long pix, @Ptr long box) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixSetInRectArbitrary(PIX*, BOX*, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1334</i>
     */
    public static int pixSetInRectArbitrary(Pointer<Pix> pix, Pointer<Box> box,
            int val) {
        return pixSetInRectArbitrary(Pointer.getPeer(pix),
                Pointer.getPeer(box), val);
    }

    protected native static int pixSetInRectArbitrary(@Ptr long pix,
            @Ptr long box, int val);

    /**
     * Original signature :
     * <code>l_int32 pixBlendInRect(PIX*, BOX*, l_uint32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1335</i>
     */
    public static int pixBlendInRect(Pointer<Pix> pixs, Pointer<Box> box,
            int val, float fract) {
        return pixBlendInRect(Pointer.getPeer(pixs), Pointer.getPeer(box), val,
                fract);
    }

    protected native static int pixBlendInRect(@Ptr long pixs, @Ptr long box,
            int val, float fract);

    /**
     * Original signature : <code>l_int32 pixSetPadBits(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1336</i>
     */
    public static int pixSetPadBits(Pointer<Pix> pix, int val) {
        return pixSetPadBits(Pointer.getPeer(pix), val);
    }

    protected native static int pixSetPadBits(@Ptr long pix, int val) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixSetPadBitsBand(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1337</i>
     */
    public static int pixSetPadBitsBand(Pointer<Pix> pix, int by, int bh,
            int val) {
        return pixSetPadBitsBand(Pointer.getPeer(pix), by, bh, val);
    }

    protected native static int pixSetPadBitsBand(@Ptr long pix, int by,
            int bh, int val);

    /**
     * Original signature :
     * <code>l_int32 pixSetOrClearBorder(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1338</i>
     */
    public static int pixSetOrClearBorder(Pointer<Pix> pixs, int left,
            int right, int top, int bot, int op) {
        return pixSetOrClearBorder(Pointer.getPeer(pixs), left, right, top,
                bot, op);
    }

    protected native static int pixSetOrClearBorder(@Ptr long pixs, int left,
            int right, int top, int bot, int op);

    /**
     * Original signature :
     * <code>l_int32 pixSetBorderVal(PIX*, l_int32, l_int32, l_int32, l_int32, l_uint32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1339</i>
     */
    public static int pixSetBorderVal(Pointer<Pix> pixs, int left, int right,
            int top, int bot, int val) {
        return pixSetBorderVal(Pointer.getPeer(pixs), left, right, top, bot,
                val);
    }

    protected native static int pixSetBorderVal(@Ptr long pixs, int left,
            int right, int top, int bot, int val);

    /**
     * Original signature :
     * <code>l_int32 pixSetBorderRingVal(PIX*, l_int32, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1340</i>
     */
    public static int pixSetBorderRingVal(Pointer<Pix> pixs, int dist, int val) {
        return pixSetBorderRingVal(Pointer.getPeer(pixs), dist, val);
    }

    protected native static int pixSetBorderRingVal(@Ptr long pixs, int dist,
            int val);

    /**
     * Original signature :
     * <code>l_int32 pixSetMirroredBorder(PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1341</i>
     */
    public static int pixSetMirroredBorder(Pointer<Pix> pixs, int left,
            int right, int top, int bot) {
        return pixSetMirroredBorder(Pointer.getPeer(pixs), left, right, top,
                bot);
    }

    protected native static int pixSetMirroredBorder(@Ptr long pixs, int left,
            int right, int top, int bot);

    /**
     * Original signature :
     * <code>PIX* pixCopyBorder(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1342</i>
     */
    public static Pointer<Pix> pixCopyBorder(Pointer<Pix> pixd,
            Pointer<Pix> pixs, int left, int right, int top, int bot) {
        return (Pointer) Pointer.pointerToAddress(
                pixCopyBorder(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                        left, right, top, bot), Pix.class);
    }

    @Ptr
    protected native static long pixCopyBorder(@Ptr long pixd, @Ptr long pixs,
            int left, int right, int top, int bot);

    /**
     * Original signature :
     * <code>PIX* pixAddBorder(PIX*, l_int32, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1343</i>
     */
    public static Pointer<Pix> pixAddBorder(Pointer<Pix> pixs, int npix, int val) {
        return (Pointer) Pointer.pointerToAddress(
                pixAddBorder(Pointer.getPeer(pixs), npix, val), Pix.class);
    }

    @Ptr
    protected native static long pixAddBorder(@Ptr long pixs, int npix, int val) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixAddBlackOrWhiteBorder(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1344</i>
     */
    public static Pointer<Pix> pixAddBlackOrWhiteBorder(Pointer<Pix> pixs,
            int left, int right, int top, int bot, int op) {
        return (Pointer) Pointer.pointerToAddress(
                pixAddBlackOrWhiteBorder(Pointer.getPeer(pixs), left, right,
                        top, bot, op), Pix.class);
    }

    @Ptr
    protected native static long pixAddBlackOrWhiteBorder(@Ptr long pixs,
            int left, int right, int top, int bot, int op);

    /**
     * Original signature :
     * <code>PIX* pixAddBorderGeneral(PIX*, l_int32, l_int32, l_int32, l_int32, l_uint32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1345</i>
     */
    public static Pointer<Pix> pixAddBorderGeneral(Pointer<Pix> pixs, int left,
            int right, int top, int bot, int val) {
        return (Pointer) Pointer.pointerToAddress(
                pixAddBorderGeneral(Pointer.getPeer(pixs), left, right, top,
                        bot, val), Pix.class);
    }

    @Ptr
    protected native static long pixAddBorderGeneral(@Ptr long pixs, int left,
            int right, int top, int bot, int val);

    /**
     * Original signature : <code>PIX* pixRemoveBorder(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1346</i>
     */
    public static Pointer<Pix> pixRemoveBorder(Pointer<Pix> pixs, int npix) {
        return (Pointer) Pointer.pointerToAddress(
                pixRemoveBorder(Pointer.getPeer(pixs), npix), Pix.class);
    }

    @Ptr
    protected native static long pixRemoveBorder(@Ptr long pixs, int npix) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixRemoveBorderGeneral(PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1347</i>
     */
    public static Pointer<Pix> pixRemoveBorderGeneral(Pointer<Pix> pixs,
            int left, int right, int top, int bot) {
        return (Pointer) Pointer.pointerToAddress(
                pixRemoveBorderGeneral(Pointer.getPeer(pixs), left, right, top,
                        bot), Pix.class);
    }

    @Ptr
    protected native static long pixRemoveBorderGeneral(@Ptr long pixs,
            int left, int right, int top, int bot);

    /**
     * Original signature :
     * <code>PIX* pixRemoveBorderToSize(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1348</i>
     */
    public static Pointer<Pix> pixRemoveBorderToSize(Pointer<Pix> pixs, int wd,
            int hd) {
        return (Pointer) Pointer.pointerToAddress(
                pixRemoveBorderToSize(Pointer.getPeer(pixs), wd, hd), Pix.class);
    }

    @Ptr
    protected native static long pixRemoveBorderToSize(@Ptr long pixs, int wd,
            int hd);

    /**
     * Original signature :
     * <code>PIX* pixAddMirroredBorder(PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1349</i>
     */
    public static Pointer<Pix> pixAddMirroredBorder(Pointer<Pix> pixs,
            int left, int right, int top, int bot) {
        return (Pointer) Pointer.pointerToAddress(
                pixAddMirroredBorder(Pointer.getPeer(pixs), left, right, top,
                        bot), Pix.class);
    }

    @Ptr
    protected native static long pixAddMirroredBorder(@Ptr long pixs, int left,
            int right, int top, int bot);

    /**
     * Original signature :
     * <code>PIX* pixAddRepeatedBorder(PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1350</i>
     */
    public static Pointer<Pix> pixAddRepeatedBorder(Pointer<Pix> pixs,
            int left, int right, int top, int bot) {
        return (Pointer) Pointer.pointerToAddress(
                pixAddRepeatedBorder(Pointer.getPeer(pixs), left, right, top,
                        bot), Pix.class);
    }

    @Ptr
    protected native static long pixAddRepeatedBorder(@Ptr long pixs, int left,
            int right, int top, int bot);

    /**
     * Original signature :
     * <code>PIX* pixAddMixedBorder(PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1351</i>
     */
    public static Pointer<Pix> pixAddMixedBorder(Pointer<Pix> pixs, int left,
            int right, int top, int bot) {
        return (Pointer) Pointer.pointerToAddress(
                pixAddMixedBorder(Pointer.getPeer(pixs), left, right, top, bot),
                Pix.class);
    }

    @Ptr
    protected native static long pixAddMixedBorder(@Ptr long pixs, int left,
            int right, int top, int bot);

    /**
     * Original signature :
     * <code>PIX* pixAddContinuedBorder(PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1352</i>
     */
    public static Pointer<Pix> pixAddContinuedBorder(Pointer<Pix> pixs,
            int left, int right, int top, int bot) {
        return (Pointer) Pointer.pointerToAddress(
                pixAddContinuedBorder(Pointer.getPeer(pixs), left, right, top,
                        bot), Pix.class);
    }

    @Ptr
    protected native static long pixAddContinuedBorder(@Ptr long pixs,
            int left, int right, int top, int bot);

    /**
     * Original signature :
     * <code>l_int32 pixShiftAndTransferAlpha(PIX*, PIX*, l_float32, l_float32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1353</i>
     */
    public static int pixShiftAndTransferAlpha(Pointer<Pix> pixd,
            Pointer<Pix> pixs, float shiftx, float shifty) {
        return pixShiftAndTransferAlpha(Pointer.getPeer(pixd),
                Pointer.getPeer(pixs), shiftx, shifty);
    }

    protected native static int pixShiftAndTransferAlpha(@Ptr long pixd,
            @Ptr long pixs, float shiftx, float shifty);

    /**
     * Original signature :
     * <code>PIX* pixDisplayLayersRGBA(PIX*, l_uint32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1354</i>
     */
    public static Pointer<Pix> pixDisplayLayersRGBA(Pointer<Pix> pixs, int val,
            int maxw) {
        return (Pointer) Pointer.pointerToAddress(
                pixDisplayLayersRGBA(Pointer.getPeer(pixs), val, maxw),
                Pix.class);
    }

    @Ptr
    protected native static long pixDisplayLayersRGBA(@Ptr long pixs, int val,
            int maxw);

    /**
     * Original signature :
     * <code>PIX* pixCreateRGBImage(PIX*, PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1355</i>
     */
    public static Pointer<Pix> pixCreateRGBImage(Pointer<Pix> pixr,
            Pointer<Pix> pixg, Pointer<Pix> pixb) {
        return (Pointer) Pointer.pointerToAddress(
                pixCreateRGBImage(Pointer.getPeer(pixr), Pointer.getPeer(pixg),
                        Pointer.getPeer(pixb)), Pix.class);
    }

    @Ptr
    protected native static long pixCreateRGBImage(@Ptr long pixr,
            @Ptr long pixg, @Ptr long pixb);

    /**
     * Original signature : <code>PIX* pixGetRGBComponent(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1356</i>
     */
    public static Pointer<Pix> pixGetRGBComponent(Pointer<Pix> pixs, int comp) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetRGBComponent(Pointer.getPeer(pixs), comp), Pix.class);
    }

    @Ptr
    protected native static long pixGetRGBComponent(@Ptr long pixs, int comp) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixSetRGBComponent(PIX*, PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1357</i>
     */
    public static int pixSetRGBComponent(Pointer<Pix> pixd, Pointer<Pix> pixs,
            int comp) {
        return pixSetRGBComponent(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                comp);
    }

    protected native static int pixSetRGBComponent(@Ptr long pixd,
            @Ptr long pixs, int comp);

    /**
     * Original signature :
     * <code>PIX* pixGetRGBComponentCmap(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1358</i>
     */
    public static Pointer<Pix> pixGetRGBComponentCmap(Pointer<Pix> pixs,
            int comp) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetRGBComponentCmap(Pointer.getPeer(pixs), comp), Pix.class);
    }

    @Ptr
    protected native static long pixGetRGBComponentCmap(@Ptr long pixs, int comp) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixCopyRGBComponent(PIX*, PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1359</i>
     */
    public static int pixCopyRGBComponent(Pointer<Pix> pixd, Pointer<Pix> pixs,
            int comp) {
        return pixCopyRGBComponent(Pointer.getPeer(pixd),
                Pointer.getPeer(pixs), comp);
    }

    protected native static int pixCopyRGBComponent(@Ptr long pixd,
            @Ptr long pixs, int comp);

    /**
     * Original signature :
     * <code>l_int32 composeRGBPixel(l_int32, l_int32, l_int32, l_uint32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1360</i>
     */
    public static int composeRGBPixel(int rval, int gval, int bval,
            Pointer<Integer> ppixel) {
        return composeRGBPixel(rval, gval, bval, Pointer.getPeer(ppixel));
    }

    protected native static int composeRGBPixel(int rval, int gval, int bval,
            @Ptr long ppixel);

    /**
     * Original signature :
     * <code>l_int32 composeRGBAPixel(l_int32, l_int32, l_int32, l_int32, l_uint32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1361</i>
     */
    public static int composeRGBAPixel(int rval, int gval, int bval, int aval,
            Pointer<Integer> ppixel) {
        return composeRGBAPixel(rval, gval, bval, aval, Pointer.getPeer(ppixel));
    }

    protected native static int composeRGBAPixel(int rval, int gval, int bval,
            int aval, @Ptr long ppixel);

    /**
     * Original signature :
     * <code>void extractRGBValues(l_uint32, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1362</i>
     */
    public static void extractRGBValues(int pixel, Pointer<Integer> prval,
            Pointer<Integer> pgval, Pointer<Integer> pbval) {
        extractRGBValues(pixel, Pointer.getPeer(prval), Pointer.getPeer(pgval),
                Pointer.getPeer(pbval));
    }

    protected native static void extractRGBValues(int pixel, @Ptr long prval,
            @Ptr long pgval, @Ptr long pbval);

    /**
     * Original signature :
     * <code>void extractRGBAValues(l_uint32, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1363</i>
     */
    public static void extractRGBAValues(int pixel, Pointer<Integer> prval,
            Pointer<Integer> pgval, Pointer<Integer> pbval,
            Pointer<Integer> paval) {
        extractRGBAValues(pixel, Pointer.getPeer(prval),
                Pointer.getPeer(pgval), Pointer.getPeer(pbval),
                Pointer.getPeer(paval));
    }

    protected native static void extractRGBAValues(int pixel, @Ptr long prval,
            @Ptr long pgval, @Ptr long pbval, @Ptr long paval);

    /**
     * Original signature :
     * <code>l_int32 extractMinMaxComponent(l_uint32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1364</i>
     */
    public static native int extractMinMaxComponent(int pixel, int type) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixGetRGBLine(PIX*, l_int32, l_uint8*, l_uint8*, l_uint8*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1365</i>
     */
    public static int pixGetRGBLine(Pointer<Pix> pixs, int row,
            Pointer<Byte> bufr, Pointer<Byte> bufg, Pointer<Byte> bufb) {
        return pixGetRGBLine(Pointer.getPeer(pixs), row, Pointer.getPeer(bufr),
                Pointer.getPeer(bufg), Pointer.getPeer(bufb));
    }

    protected native static int pixGetRGBLine(@Ptr long pixs, int row,
            @Ptr long bufr, @Ptr long bufg, @Ptr long bufb);

    /**
     * Original signature : <code>PIX* pixEndianByteSwapNew(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1366</i>
     */
    public static Pointer<Pix> pixEndianByteSwapNew(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixEndianByteSwapNew(Pointer.getPeer(pixs)), Pix.class);
    }

    @Ptr
    protected native static long pixEndianByteSwapNew(@Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>l_int32 pixEndianByteSwap(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1367</i>
     */
    public static int pixEndianByteSwap(Pointer<Pix> pixs) {
        return pixEndianByteSwap(Pointer.getPeer(pixs));
    }

    protected native static int pixEndianByteSwap(@Ptr long pixs) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 lineEndianByteSwap(l_uint32*, l_uint32*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1368</i>
     */
    public static int lineEndianByteSwap(Pointer<Integer> datad,
            Pointer<Integer> datas, int wpl) {
        return lineEndianByteSwap(Pointer.getPeer(datad),
                Pointer.getPeer(datas), wpl);
    }

    protected native static int lineEndianByteSwap(@Ptr long datad,
            @Ptr long datas, int wpl);

    /**
     * Original signature : <code>PIX* pixEndianTwoByteSwapNew(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1369</i>
     */
    public static Pointer<Pix> pixEndianTwoByteSwapNew(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixEndianTwoByteSwapNew(Pointer.getPeer(pixs)), Pix.class);
    }

    @Ptr
    protected native static long pixEndianTwoByteSwapNew(@Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>l_int32 pixEndianTwoByteSwap(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1370</i>
     */
    public static int pixEndianTwoByteSwap(Pointer<Pix> pixs) {
        return pixEndianTwoByteSwap(Pointer.getPeer(pixs));
    }

    protected native static int pixEndianTwoByteSwap(@Ptr long pixs) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixGetRasterData(PIX*, l_uint8**, size_t*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1371</i>
     */
    public static int pixGetRasterData(Pointer<Pix> pixs,
            Pointer<Pointer<Byte>> pdata, Pointer<SizeT> pnbytes) {
        return pixGetRasterData(Pointer.getPeer(pixs), Pointer.getPeer(pdata),
                Pointer.getPeer(pnbytes));
    }

    protected native static int pixGetRasterData(@Ptr long pixs,
            @Ptr long pdata, @Ptr long pnbytes);

    /**
     * Original signature :
     * <code>l_int32 pixAlphaIsOpaque(PIX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1372</i>
     */
    public static int pixAlphaIsOpaque(Pointer<Pix> pix,
            Pointer<Integer> popaque) {
        return pixAlphaIsOpaque(Pointer.getPeer(pix), Pointer.getPeer(popaque));
    }

    protected native static int pixAlphaIsOpaque(@Ptr long pix,
            @Ptr long popaque);

    /**
     * Original signature :
     * <code>l_uint8** pixSetupByteProcessing(PIX*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1373</i>
     */
    public static Pointer<Pointer<Byte>> pixSetupByteProcessing(
            Pointer<Pix> pix, Pointer<Integer> pw, Pointer<Integer> ph) {
        return (Pointer) Pointer.pointerToAddress(
                pixSetupByteProcessing(Pointer.getPeer(pix),
                        Pointer.getPeer(pw), Pointer.getPeer(ph)),
                DefaultParameterizedType.paramType(Pointer.class, Byte.class));
    }

    @Ptr
    protected native static long pixSetupByteProcessing(@Ptr long pix,
            @Ptr long pw, @Ptr long ph);

    /**
     * Original signature :
     * <code>l_int32 pixCleanupByteProcessing(PIX*, l_uint8**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1374</i>
     */
    public static int pixCleanupByteProcessing(Pointer<Pix> pix,
            Pointer<Pointer<Byte>> lineptrs) {
        return pixCleanupByteProcessing(Pointer.getPeer(pix),
                Pointer.getPeer(lineptrs));
    }

    protected native static int pixCleanupByteProcessing(@Ptr long pix,
            @Ptr long lineptrs);

    /**
     * Original signature :
     * <code>void l_setAlphaMaskBorder(l_float32, l_float32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1375</i>
     */
    public static native void l_setAlphaMaskBorder(float val1, float val2) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixSetMasked(PIX*, PIX*, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1376</i>
     */
    public static int pixSetMasked(Pointer<Pix> pixd, Pointer<Pix> pixm, int val) {
        return pixSetMasked(Pointer.getPeer(pixd), Pointer.getPeer(pixm), val);
    }

    protected native static int pixSetMasked(@Ptr long pixd, @Ptr long pixm,
            int val);

    /**
     * Original signature :
     * <code>l_int32 pixSetMaskedGeneral(PIX*, PIX*, l_uint32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1377</i>
     */
    public static int pixSetMaskedGeneral(Pointer<Pix> pixd, Pointer<Pix> pixm,
            int val, int x, int y) {
        return pixSetMaskedGeneral(Pointer.getPeer(pixd),
                Pointer.getPeer(pixm), val, x, y);
    }

    protected native static int pixSetMaskedGeneral(@Ptr long pixd,
            @Ptr long pixm, int val, int x, int y);

    /**
     * Original signature :
     * <code>l_int32 pixCombineMasked(PIX*, PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1378</i>
     */
    public static int pixCombineMasked(Pointer<Pix> pixd, Pointer<Pix> pixs,
            Pointer<Pix> pixm) {
        return pixCombineMasked(Pointer.getPeer(pixd), Pointer.getPeer(pixs),
                Pointer.getPeer(pixm));
    }

    protected native static int pixCombineMasked(@Ptr long pixd,
            @Ptr long pixs, @Ptr long pixm);

    /**
     * Original signature :
     * <code>l_int32 pixCombineMaskedGeneral(PIX*, PIX*, PIX*, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1379</i>
     */
    public static int pixCombineMaskedGeneral(Pointer<Pix> pixd,
            Pointer<Pix> pixs, Pointer<Pix> pixm, int x, int y) {
        return pixCombineMaskedGeneral(Pointer.getPeer(pixd),
                Pointer.getPeer(pixs), Pointer.getPeer(pixm), x, y);
    }

    protected native static int pixCombineMaskedGeneral(@Ptr long pixd,
            @Ptr long pixs, @Ptr long pixm, int x, int y);

    /**
     * Original signature :
     * <code>l_int32 pixPaintThroughMask(PIX*, PIX*, l_int32, l_int32, l_uint32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1380</i>
     */
    public static int pixPaintThroughMask(Pointer<Pix> pixd, Pointer<Pix> pixm,
            int x, int y, int val) {
        return pixPaintThroughMask(Pointer.getPeer(pixd),
                Pointer.getPeer(pixm), x, y, val);
    }

    protected native static int pixPaintThroughMask(@Ptr long pixd,
            @Ptr long pixm, int x, int y, int val);

    /**
     * Original signature :
     * <code>l_int32 pixPaintSelfThroughMask(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1381</i>
     */
    public static int pixPaintSelfThroughMask(Pointer<Pix> pixd,
            Pointer<Pix> pixm, int x, int y, int tilesize, int searchdir) {
        return pixPaintSelfThroughMask(Pointer.getPeer(pixd),
                Pointer.getPeer(pixm), x, y, tilesize, searchdir);
    }

    protected native static int pixPaintSelfThroughMask(@Ptr long pixd,
            @Ptr long pixm, int x, int y, int tilesize, int searchdir);

    /**
     * Original signature : <code>PIX* pixMakeMaskFromLUT(PIX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1382</i>
     */
    public static Pointer<Pix> pixMakeMaskFromLUT(Pointer<Pix> pixs,
            Pointer<Integer> tab) {
        return (Pointer) Pointer.pointerToAddress(
                pixMakeMaskFromLUT(Pointer.getPeer(pixs), Pointer.getPeer(tab)),
                Pix.class);
    }

    @Ptr
    protected native static long pixMakeMaskFromLUT(@Ptr long pixs,
            @Ptr long tab);

    /**
     * Original signature :
     * <code>PIX* pixSetUnderTransparency(PIX*, l_uint32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1383</i>
     */
    public static Pointer<Pix> pixSetUnderTransparency(Pointer<Pix> pixs,
            int val, int debug) {
        return (Pointer) Pointer.pointerToAddress(
                pixSetUnderTransparency(Pointer.getPeer(pixs), val, debug),
                Pix.class);
    }

    @Ptr
    protected native static long pixSetUnderTransparency(@Ptr long pixs,
            int val, int debug);

    /**
     * Original signature : <code>PIX* pixInvert(PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1384</i>
     */
    public static Pointer<Pix> pixInvert(Pointer<Pix> pixd, Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixInvert(Pointer.getPeer(pixd), Pointer.getPeer(pixs)),
                Pix.class);
    }

    @Ptr
    protected native static long pixInvert(@Ptr long pixd, @Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>PIX* pixOr(PIX*, PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1385</i>
     */
    public static Pointer<Pix> pixOr(Pointer<Pix> pixd, Pointer<Pix> pixs1,
            Pointer<Pix> pixs2) {
        return (Pointer) Pointer.pointerToAddress(
                pixOr(Pointer.getPeer(pixd), Pointer.getPeer(pixs1),
                        Pointer.getPeer(pixs2)), Pix.class);
    }

    @Ptr
    protected native static long pixOr(@Ptr long pixd, @Ptr long pixs1,
            @Ptr long pixs2);

    /**
     * Original signature : <code>PIX* pixAnd(PIX*, PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1386</i>
     */
    public static Pointer<Pix> pixAnd(Pointer<Pix> pixd, Pointer<Pix> pixs1,
            Pointer<Pix> pixs2) {
        return (Pointer) Pointer.pointerToAddress(
                pixAnd(Pointer.getPeer(pixd), Pointer.getPeer(pixs1),
                        Pointer.getPeer(pixs2)), Pix.class);
    }

    @Ptr
    protected native static long pixAnd(@Ptr long pixd, @Ptr long pixs1,
            @Ptr long pixs2);

    /**
     * Original signature : <code>PIX* pixXor(PIX*, PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1387</i>
     */
    public static Pointer<Pix> pixXor(Pointer<Pix> pixd, Pointer<Pix> pixs1,
            Pointer<Pix> pixs2) {
        return (Pointer) Pointer.pointerToAddress(
                pixXor(Pointer.getPeer(pixd), Pointer.getPeer(pixs1),
                        Pointer.getPeer(pixs2)), Pix.class);
    }

    @Ptr
    protected native static long pixXor(@Ptr long pixd, @Ptr long pixs1,
            @Ptr long pixs2);

    /**
     * Original signature : <code>PIX* pixSubtract(PIX*, PIX*, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1388</i>
     */
    public static Pointer<Pix> pixSubtract(Pointer<Pix> pixd,
            Pointer<Pix> pixs1, Pointer<Pix> pixs2) {
        return (Pointer) Pointer.pointerToAddress(
                pixSubtract(Pointer.getPeer(pixd), Pointer.getPeer(pixs1),
                        Pointer.getPeer(pixs2)), Pix.class);
    }

    @Ptr
    protected native static long pixSubtract(@Ptr long pixd, @Ptr long pixs1,
            @Ptr long pixs2);

    /**
     * Original signature : <code>l_int32 pixZero(PIX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1389</i>
     */
    public static int pixZero(Pointer<Pix> pix, Pointer<Integer> pempty) {
        return pixZero(Pointer.getPeer(pix), Pointer.getPeer(pempty));
    }

    protected native static int pixZero(@Ptr long pix, @Ptr long pempty) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixForegroundFraction(PIX*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1390</i>
     */
    public static int pixForegroundFraction(Pointer<Pix> pix,
            Pointer<Float> pfract) {
        return pixForegroundFraction(Pointer.getPeer(pix),
                Pointer.getPeer(pfract));
    }

    protected native static int pixForegroundFraction(@Ptr long pix,
            @Ptr long pfract);

    /**
     * Original signature : <code>NUMA* pixaCountPixels(PIXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1391</i>
     */
    public static Pointer<Numa> pixaCountPixels(Pointer<Pixa> pixa) {
        return (Pointer) Pointer.pointerToAddress(
                pixaCountPixels(Pointer.getPeer(pixa)), Numa.class);
    }

    @Ptr
    protected native static long pixaCountPixels(@Ptr long pixa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixCountPixels(PIX*, l_int32*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1392</i>
     */
    public static int pixCountPixels(Pointer<Pix> pix, Pointer<Integer> pcount,
            Pointer<Integer> tab8) {
        return pixCountPixels(Pointer.getPeer(pix), Pointer.getPeer(pcount),
                Pointer.getPeer(tab8));
    }

    protected native static int pixCountPixels(@Ptr long pix, @Ptr long pcount,
            @Ptr long tab8);

    /**
     * Original signature : <code>NUMA* pixCountByRow(PIX*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1393</i>
     */
    public static Pointer<Numa> pixCountByRow(Pointer<Pix> pix, Pointer<Box> box) {
        return (Pointer) Pointer.pointerToAddress(
                pixCountByRow(Pointer.getPeer(pix), Pointer.getPeer(box)),
                Numa.class);
    }

    @Ptr
    protected native static long pixCountByRow(@Ptr long pix, @Ptr long box) throws LastError;

    /**
     * Original signature : <code>NUMA* pixCountByColumn(PIX*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1394</i>
     */
    public static Pointer<Numa> pixCountByColumn(Pointer<Pix> pix,
            Pointer<Box> box) {
        return (Pointer) Pointer.pointerToAddress(
                pixCountByColumn(Pointer.getPeer(pix), Pointer.getPeer(box)),
                Numa.class);
    }

    @Ptr
    protected native static long pixCountByColumn(@Ptr long pix, @Ptr long box) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* pixCountPixelsByRow(PIX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1395</i>
     */
    public static Pointer<Numa> pixCountPixelsByRow(Pointer<Pix> pix,
            Pointer<Integer> tab8) {
        return (Pointer) Pointer.pointerToAddress(
                pixCountPixelsByRow(Pointer.getPeer(pix), Pointer.getPeer(tab8)),
                Numa.class);
    }

    @Ptr
    protected native static long pixCountPixelsByRow(@Ptr long pix,
            @Ptr long tab8);

    /**
     * Original signature : <code>NUMA* pixCountPixelsByColumn(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1396</i>
     */
    public static Pointer<Numa> pixCountPixelsByColumn(Pointer<Pix> pix) {
        return (Pointer) Pointer.pointerToAddress(
                pixCountPixelsByColumn(Pointer.getPeer(pix)), Numa.class);
    }

    @Ptr
    protected native static long pixCountPixelsByColumn(@Ptr long pix) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixCountPixelsInRow(PIX*, l_int32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1397</i>
     */
    public static int pixCountPixelsInRow(Pointer<Pix> pix, int row,
            Pointer<Integer> pcount, Pointer<Integer> tab8) {
        return pixCountPixelsInRow(Pointer.getPeer(pix), row,
                Pointer.getPeer(pcount), Pointer.getPeer(tab8));
    }

    protected native static int pixCountPixelsInRow(@Ptr long pix, int row,
            @Ptr long pcount, @Ptr long tab8);

    /**
     * Original signature :
     * <code>NUMA* pixGetMomentByColumn(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1398</i>
     */
    public static Pointer<Numa> pixGetMomentByColumn(Pointer<Pix> pix, int order) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetMomentByColumn(Pointer.getPeer(pix), order), Numa.class);
    }

    @Ptr
    protected native static long pixGetMomentByColumn(@Ptr long pix, int order) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixThresholdPixelSum(PIX*, l_int32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1399</i>
     */
    public static int pixThresholdPixelSum(Pointer<Pix> pix, int thresh,
            Pointer<Integer> pabove, Pointer<Integer> tab8) {
        return pixThresholdPixelSum(Pointer.getPeer(pix), thresh,
                Pointer.getPeer(pabove), Pointer.getPeer(tab8));
    }

    protected native static int pixThresholdPixelSum(@Ptr long pix, int thresh,
            @Ptr long pabove, @Ptr long tab8);

    /**
     * Original signature : <code>l_int32* makePixelSumTab8()</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1400</i>
     */
    public static Pointer<Integer> makePixelSumTab8() {
        return (Pointer) Pointer.pointerToAddress(makePixelSumTab8$2(),
                Integer.class);
    }

    @Ptr
    @Name("makePixelSumTab8")
    protected native static long makePixelSumTab8$2() throws LastError;

    /**
     * Original signature : <code>l_int32* makePixelCentroidTab8()</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1401</i>
     */
    public static Pointer<Integer> makePixelCentroidTab8() {
        return (Pointer) Pointer.pointerToAddress(makePixelCentroidTab8$2(),
                Integer.class);
    }

    @Ptr
    @Name("makePixelCentroidTab8")
    protected native static long makePixelCentroidTab8$2() throws LastError;

    /**
     * Original signature :
     * <code>NUMA* pixAverageByRow(PIX*, BOX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1402</i>
     */
    public static Pointer<Numa> pixAverageByRow(Pointer<Pix> pix,
            Pointer<Box> box, int type) {
        return (Pointer) Pointer.pointerToAddress(
                pixAverageByRow(Pointer.getPeer(pix), Pointer.getPeer(box),
                        type), Numa.class);
    }

    @Ptr
    protected native static long pixAverageByRow(@Ptr long pix, @Ptr long box,
            int type);

    /**
     * Original signature :
     * <code>NUMA* pixAverageByColumn(PIX*, BOX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1403</i>
     */
    public static Pointer<Numa> pixAverageByColumn(Pointer<Pix> pix,
            Pointer<Box> box, int type) {
        return (Pointer) Pointer.pointerToAddress(
                pixAverageByColumn(Pointer.getPeer(pix), Pointer.getPeer(box),
                        type), Numa.class);
    }

    @Ptr
    protected native static long pixAverageByColumn(@Ptr long pix,
            @Ptr long box, int type);

    /**
     * Original signature :
     * <code>l_int32 pixAverageInRect(PIX*, BOX*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1404</i>
     */
    public static int pixAverageInRect(Pointer<Pix> pix, Pointer<Box> box,
            Pointer<Float> pave) {
        return pixAverageInRect(Pointer.getPeer(pix), Pointer.getPeer(box),
                Pointer.getPeer(pave));
    }

    protected native static int pixAverageInRect(@Ptr long pix, @Ptr long box,
            @Ptr long pave);

    /**
     * Original signature : <code>NUMA* pixVarianceByRow(PIX*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1405</i>
     */
    public static Pointer<Numa> pixVarianceByRow(Pointer<Pix> pix,
            Pointer<Box> box) {
        return (Pointer) Pointer.pointerToAddress(
                pixVarianceByRow(Pointer.getPeer(pix), Pointer.getPeer(box)),
                Numa.class);
    }

    @Ptr
    protected native static long pixVarianceByRow(@Ptr long pix, @Ptr long box) throws LastError;

    /**
     * Original signature : <code>NUMA* pixVarianceByColumn(PIX*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1406</i>
     */
    public static Pointer<Numa> pixVarianceByColumn(Pointer<Pix> pix,
            Pointer<Box> box) {
        return (Pointer) Pointer.pointerToAddress(
                pixVarianceByColumn(Pointer.getPeer(pix), Pointer.getPeer(box)),
                Numa.class);
    }

    @Ptr
    protected native static long pixVarianceByColumn(@Ptr long pix,
            @Ptr long box);

    /**
     * Original signature :
     * <code>l_int32 pixVarianceInRect(PIX*, BOX*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1407</i>
     */
    public static int pixVarianceInRect(Pointer<Pix> pix, Pointer<Box> box,
            Pointer<Float> prootvar) {
        return pixVarianceInRect(Pointer.getPeer(pix), Pointer.getPeer(box),
                Pointer.getPeer(prootvar));
    }

    protected native static int pixVarianceInRect(@Ptr long pix, @Ptr long box,
            @Ptr long prootvar);

    /**
     * Original signature : <code>NUMA* pixAbsDiffByRow(PIX*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1408</i>
     */
    public static Pointer<Numa> pixAbsDiffByRow(Pointer<Pix> pix,
            Pointer<Box> box) {
        return (Pointer) Pointer.pointerToAddress(
                pixAbsDiffByRow(Pointer.getPeer(pix), Pointer.getPeer(box)),
                Numa.class);
    }

    @Ptr
    protected native static long pixAbsDiffByRow(@Ptr long pix, @Ptr long box) throws LastError;

    /**
     * Original signature : <code>NUMA* pixAbsDiffByColumn(PIX*, BOX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1409</i>
     */
    public static Pointer<Numa> pixAbsDiffByColumn(Pointer<Pix> pix,
            Pointer<Box> box) {
        return (Pointer) Pointer.pointerToAddress(
                pixAbsDiffByColumn(Pointer.getPeer(pix), Pointer.getPeer(box)),
                Numa.class);
    }

    @Ptr
    protected native static long pixAbsDiffByColumn(@Ptr long pix, @Ptr long box) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixAbsDiffInRect(PIX*, BOX*, l_int32, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1410</i>
     */
    public static int pixAbsDiffInRect(Pointer<Pix> pix, Pointer<Box> box,
            int dir, Pointer<Float> pabsdiff) {
        return pixAbsDiffInRect(Pointer.getPeer(pix), Pointer.getPeer(box),
                dir, Pointer.getPeer(pabsdiff));
    }

    protected native static int pixAbsDiffInRect(@Ptr long pix, @Ptr long box,
            int dir, @Ptr long pabsdiff);

    /**
     * Original signature :
     * <code>l_int32 pixAbsDiffOnLine(PIX*, l_int32, l_int32, l_int32, l_int32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1411</i>
     */
    public static int pixAbsDiffOnLine(Pointer<Pix> pix, int x1, int y1,
            int x2, int y2, Pointer<Float> pabsdiff) {
        return pixAbsDiffOnLine(Pointer.getPeer(pix), x1, y1, x2, y2,
                Pointer.getPeer(pabsdiff));
    }

    protected native static int pixAbsDiffOnLine(@Ptr long pix, int x1, int y1,
            int x2, int y2, @Ptr long pabsdiff);

    /**
     * Original signature :
     * <code>l_int32 pixCountArbInRect(PIX*, BOX*, l_int32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1412</i>
     */
    public static int pixCountArbInRect(Pointer<Pix> pixs, Pointer<Box> box,
            int val, int factor, Pointer<Integer> pcount) {
        return pixCountArbInRect(Pointer.getPeer(pixs), Pointer.getPeer(box),
                val, factor, Pointer.getPeer(pcount));
    }

    protected native static int pixCountArbInRect(@Ptr long pixs,
            @Ptr long box, int val, int factor, @Ptr long pcount);

    /**
     * Original signature :
     * <code>PIX* pixMirroredTiling(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1413</i>
     */
    public static Pointer<Pix> pixMirroredTiling(Pointer<Pix> pixs, int w, int h) {
        return (Pointer) Pointer.pointerToAddress(
                pixMirroredTiling(Pointer.getPeer(pixs), w, h), Pix.class);
    }

    @Ptr
    protected native static long pixMirroredTiling(@Ptr long pixs, int w, int h) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* pixGetGrayHistogram(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1414</i>
     */
    public static Pointer<Numa> pixGetGrayHistogram(Pointer<Pix> pixs,
            int factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetGrayHistogram(Pointer.getPeer(pixs), factor), Numa.class);
    }

    @Ptr
    protected native static long pixGetGrayHistogram(@Ptr long pixs, int factor) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* pixGetGrayHistogramMasked(PIX*, PIX*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1415</i>
     */
    public static Pointer<Numa> pixGetGrayHistogramMasked(Pointer<Pix> pixs,
            Pointer<Pix> pixm, int x, int y, int factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetGrayHistogramMasked(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixm), x, y, factor), Numa.class);
    }

    @Ptr
    protected native static long pixGetGrayHistogramMasked(@Ptr long pixs,
            @Ptr long pixm, int x, int y, int factor);

    /**
     * Original signature :
     * <code>NUMA* pixGetGrayHistogramInRect(PIX*, BOX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1416</i>
     */
    public static Pointer<Numa> pixGetGrayHistogramInRect(Pointer<Pix> pixs,
            Pointer<Box> box, int factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetGrayHistogramInRect(Pointer.getPeer(pixs),
                        Pointer.getPeer(box), factor), Numa.class);
    }

    @Ptr
    protected native static long pixGetGrayHistogramInRect(@Ptr long pixs,
            @Ptr long box, int factor);

    /**
     * Original signature :
     * <code>l_int32 pixGetColorHistogram(PIX*, l_int32, NUMA**, NUMA**, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1417</i>
     */
    public static int pixGetColorHistogram(Pointer<Pix> pixs, int factor,
            Pointer<Pointer<Numa>> pnar, Pointer<Pointer<Numa>> pnag,
            Pointer<Pointer<Numa>> pnab) {
        return pixGetColorHistogram(Pointer.getPeer(pixs), factor,
                Pointer.getPeer(pnar), Pointer.getPeer(pnag),
                Pointer.getPeer(pnab));
    }

    protected native static int pixGetColorHistogram(@Ptr long pixs,
            int factor, @Ptr long pnar, @Ptr long pnag, @Ptr long pnab);

    /**
     * Original signature :
     * <code>l_int32 pixGetColorHistogramMasked(PIX*, PIX*, l_int32, l_int32, l_int32, NUMA**, NUMA**, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1418</i>
     */
    public static int pixGetColorHistogramMasked(Pointer<Pix> pixs,
            Pointer<Pix> pixm, int x, int y, int factor,
            Pointer<Pointer<Numa>> pnar, Pointer<Pointer<Numa>> pnag,
            Pointer<Pointer<Numa>> pnab) {
        return pixGetColorHistogramMasked(Pointer.getPeer(pixs),
                Pointer.getPeer(pixm), x, y, factor, Pointer.getPeer(pnar),
                Pointer.getPeer(pnag), Pointer.getPeer(pnab));
    }

    protected native static int pixGetColorHistogramMasked(@Ptr long pixs,
            @Ptr long pixm, int x, int y, int factor, @Ptr long pnar,
            @Ptr long pnag, @Ptr long pnab);

    /**
     * Original signature :
     * <code>NUMA* pixGetCmapHistogram(PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1419</i>
     */
    public static Pointer<Numa> pixGetCmapHistogram(Pointer<Pix> pixs,
            int factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetCmapHistogram(Pointer.getPeer(pixs), factor), Numa.class);
    }

    @Ptr
    protected native static long pixGetCmapHistogram(@Ptr long pixs, int factor) throws LastError;

    /**
     * Original signature :
     * <code>NUMA* pixGetCmapHistogramMasked(PIX*, PIX*, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1420</i>
     */
    public static Pointer<Numa> pixGetCmapHistogramMasked(Pointer<Pix> pixs,
            Pointer<Pix> pixm, int x, int y, int factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetCmapHistogramMasked(Pointer.getPeer(pixs),
                        Pointer.getPeer(pixm), x, y, factor), Numa.class);
    }

    @Ptr
    protected native static long pixGetCmapHistogramMasked(@Ptr long pixs,
            @Ptr long pixm, int x, int y, int factor);

    /**
     * Original signature :
     * <code>NUMA* pixGetCmapHistogramInRect(PIX*, BOX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1421</i>
     */
    public static Pointer<Numa> pixGetCmapHistogramInRect(Pointer<Pix> pixs,
            Pointer<Box> box, int factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetCmapHistogramInRect(Pointer.getPeer(pixs),
                        Pointer.getPeer(box), factor), Numa.class);
    }

    @Ptr
    protected native static long pixGetCmapHistogramInRect(@Ptr long pixs,
            @Ptr long box, int factor);

    /**
     * Original signature :
     * <code>l_int32 pixGetRankValue(PIX*, l_int32, l_float32, l_uint32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1422</i>
     */
    public static int pixGetRankValue(Pointer<Pix> pixs, int factor,
            float rank, Pointer<Integer> pvalue) {
        return pixGetRankValue(Pointer.getPeer(pixs), factor, rank,
                Pointer.getPeer(pvalue));
    }

    protected native static int pixGetRankValue(@Ptr long pixs, int factor,
            float rank, @Ptr long pvalue);

    /**
     * Original signature :
     * <code>l_int32 pixGetRankValueMaskedRGB(PIX*, PIX*, l_int32, l_int32, l_int32, l_float32, l_float32*, l_float32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1423</i>
     */
    public static int pixGetRankValueMaskedRGB(Pointer<Pix> pixs,
            Pointer<Pix> pixm, int x, int y, int factor, float rank,
            Pointer<Float> prval, Pointer<Float> pgval, Pointer<Float> pbval) {
        return pixGetRankValueMaskedRGB(Pointer.getPeer(pixs),
                Pointer.getPeer(pixm), x, y, factor, rank,
                Pointer.getPeer(prval), Pointer.getPeer(pgval),
                Pointer.getPeer(pbval));
    }

    protected native static int pixGetRankValueMaskedRGB(@Ptr long pixs,
            @Ptr long pixm, int x, int y, int factor, float rank,
            @Ptr long prval, @Ptr long pgval, @Ptr long pbval);

    /**
     * Original signature :
     * <code>l_int32 pixGetRankValueMasked(PIX*, PIX*, l_int32, l_int32, l_int32, l_float32, l_float32*, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1424</i>
     */
    public static int pixGetRankValueMasked(Pointer<Pix> pixs,
            Pointer<Pix> pixm, int x, int y, int factor, float rank,
            Pointer<Float> pval, Pointer<Pointer<Numa>> pna) {
        return pixGetRankValueMasked(Pointer.getPeer(pixs),
                Pointer.getPeer(pixm), x, y, factor, rank,
                Pointer.getPeer(pval), Pointer.getPeer(pna));
    }

    protected native static int pixGetRankValueMasked(@Ptr long pixs,
            @Ptr long pixm, int x, int y, int factor, float rank,
            @Ptr long pval, @Ptr long pna);

    /**
     * Original signature :
     * <code>l_int32 pixGetAverageValue(PIX*, l_int32, l_int32, l_uint32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1425</i>
     */
    public static int pixGetAverageValue(Pointer<Pix> pixs, int factor,
            int type, Pointer<Integer> pvalue) {
        return pixGetAverageValue(Pointer.getPeer(pixs), factor, type,
                Pointer.getPeer(pvalue));
    }

    protected native static int pixGetAverageValue(@Ptr long pixs, int factor,
            int type, @Ptr long pvalue);

    /**
     * Original signature :
     * <code>l_int32 pixGetAverageMaskedRGB(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, l_float32*, l_float32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1426</i>
     */
    public static int pixGetAverageMaskedRGB(Pointer<Pix> pixs,
            Pointer<Pix> pixm, int x, int y, int factor, int type,
            Pointer<Float> prval, Pointer<Float> pgval, Pointer<Float> pbval) {
        return pixGetAverageMaskedRGB(Pointer.getPeer(pixs),
                Pointer.getPeer(pixm), x, y, factor, type,
                Pointer.getPeer(prval), Pointer.getPeer(pgval),
                Pointer.getPeer(pbval));
    }

    protected native static int pixGetAverageMaskedRGB(@Ptr long pixs,
            @Ptr long pixm, int x, int y, int factor, int type,
            @Ptr long prval, @Ptr long pgval, @Ptr long pbval);

    /**
     * Original signature :
     * <code>l_int32 pixGetAverageMasked(PIX*, PIX*, l_int32, l_int32, l_int32, l_int32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1427</i>
     */
    public static int pixGetAverageMasked(Pointer<Pix> pixs, Pointer<Pix> pixm,
            int x, int y, int factor, int type, Pointer<Float> pval) {
        return pixGetAverageMasked(Pointer.getPeer(pixs),
                Pointer.getPeer(pixm), x, y, factor, type,
                Pointer.getPeer(pval));
    }

    protected native static int pixGetAverageMasked(@Ptr long pixs,
            @Ptr long pixm, int x, int y, int factor, int type, @Ptr long pval);

    /**
     * Original signature :
     * <code>l_int32 pixGetAverageTiledRGB(PIX*, l_int32, l_int32, l_int32, PIX**, PIX**, PIX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1428</i>
     */
    public static int pixGetAverageTiledRGB(Pointer<Pix> pixs, int sx, int sy,
            int type, Pointer<Pointer<Pix>> ppixr, Pointer<Pointer<Pix>> ppixg,
            Pointer<Pointer<Pix>> ppixb) {
        return pixGetAverageTiledRGB(Pointer.getPeer(pixs), sx, sy, type,
                Pointer.getPeer(ppixr), Pointer.getPeer(ppixg),
                Pointer.getPeer(ppixb));
    }

    protected native static int pixGetAverageTiledRGB(@Ptr long pixs, int sx,
            int sy, int type, @Ptr long ppixr, @Ptr long ppixg, @Ptr long ppixb);

    /**
     * Original signature :
     * <code>PIX* pixGetAverageTiled(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1429</i>
     */
    public static Pointer<Pix> pixGetAverageTiled(Pointer<Pix> pixs, int sx,
            int sy, int type) {
        return (Pointer) Pointer.pointerToAddress(
                pixGetAverageTiled(Pointer.getPeer(pixs), sx, sy, type),
                Pix.class);
    }

    @Ptr
    protected native static long pixGetAverageTiled(@Ptr long pixs, int sx,
            int sy, int type);

    /**
     * Original signature :
     * <code>l_int32 pixRowStats(PIX*, BOX*, NUMA**, NUMA**, NUMA**, NUMA**, NUMA**, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1430</i>
     */
    public static int pixRowStats(Pointer<Pix> pixs, Pointer<Box> box,
            Pointer<Pointer<Numa>> pnamean, Pointer<Pointer<Numa>> pnamedian,
            Pointer<Pointer<Numa>> pnamode,
            Pointer<Pointer<Numa>> pnamodecount, Pointer<Pointer<Numa>> pnavar,
            Pointer<Pointer<Numa>> pnarootvar) {
        return pixRowStats(Pointer.getPeer(pixs), Pointer.getPeer(box),
                Pointer.getPeer(pnamean), Pointer.getPeer(pnamedian),
                Pointer.getPeer(pnamode), Pointer.getPeer(pnamodecount),
                Pointer.getPeer(pnavar), Pointer.getPeer(pnarootvar));
    }

    protected native static int pixRowStats(@Ptr long pixs, @Ptr long box,
            @Ptr long pnamean, @Ptr long pnamedian, @Ptr long pnamode,
            @Ptr long pnamodecount, @Ptr long pnavar, @Ptr long pnarootvar);

    /**
     * Original signature :
     * <code>l_int32 pixColumnStats(PIX*, BOX*, NUMA**, NUMA**, NUMA**, NUMA**, NUMA**, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1431</i>
     */
    public static int pixColumnStats(Pointer<Pix> pixs, Pointer<Box> box,
            Pointer<Pointer<Numa>> pnamean, Pointer<Pointer<Numa>> pnamedian,
            Pointer<Pointer<Numa>> pnamode,
            Pointer<Pointer<Numa>> pnamodecount, Pointer<Pointer<Numa>> pnavar,
            Pointer<Pointer<Numa>> pnarootvar) {
        return pixColumnStats(Pointer.getPeer(pixs), Pointer.getPeer(box),
                Pointer.getPeer(pnamean), Pointer.getPeer(pnamedian),
                Pointer.getPeer(pnamode), Pointer.getPeer(pnamodecount),
                Pointer.getPeer(pnavar), Pointer.getPeer(pnarootvar));
    }

    protected native static int pixColumnStats(@Ptr long pixs, @Ptr long box,
            @Ptr long pnamean, @Ptr long pnamedian, @Ptr long pnamode,
            @Ptr long pnamodecount, @Ptr long pnavar, @Ptr long pnarootvar);

    /**
     * Original signature :
     * <code>l_int32 pixGetComponentRange(PIX*, l_int32, l_int32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1432</i>
     */
    public static int pixGetComponentRange(Pointer<Pix> pixs, int factor,
            int color, Pointer<Integer> pminval, Pointer<Integer> pmaxval) {
        return pixGetComponentRange(Pointer.getPeer(pixs), factor, color,
                Pointer.getPeer(pminval), Pointer.getPeer(pmaxval));
    }

    protected native static int pixGetComponentRange(@Ptr long pixs,
            int factor, int color, @Ptr long pminval, @Ptr long pmaxval);

    /**
     * Original signature :
     * <code>l_int32 pixGetExtremeValue(PIX*, l_int32, l_int32, l_int32*, l_int32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1433</i>
     */
    public static int pixGetExtremeValue(Pointer<Pix> pixs, int factor,
            int type, Pointer<Integer> prval, Pointer<Integer> pgval,
            Pointer<Integer> pbval, Pointer<Integer> pgrayval) {
        return pixGetExtremeValue(Pointer.getPeer(pixs), factor, type,
                Pointer.getPeer(prval), Pointer.getPeer(pgval),
                Pointer.getPeer(pbval), Pointer.getPeer(pgrayval));
    }

    protected native static int pixGetExtremeValue(@Ptr long pixs, int factor,
            int type, @Ptr long prval, @Ptr long pgval, @Ptr long pbval,
            @Ptr long pgrayval);

    /**
     * Original signature :
     * <code>l_int32 pixGetMaxValueInRect(PIX*, BOX*, l_uint32*, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1434</i>
     */
    public static int pixGetMaxValueInRect(Pointer<Pix> pixs, Pointer<Box> box,
            Pointer<Integer> pmaxval, Pointer<Integer> pxmax,
            Pointer<Integer> pymax) {
        return pixGetMaxValueInRect(Pointer.getPeer(pixs),
                Pointer.getPeer(box), Pointer.getPeer(pmaxval),
                Pointer.getPeer(pxmax), Pointer.getPeer(pymax));
    }

    protected native static int pixGetMaxValueInRect(@Ptr long pixs,
            @Ptr long box, @Ptr long pmaxval, @Ptr long pxmax, @Ptr long pymax);

    /**
     * Original signature :
     * <code>l_int32 pixGetBinnedComponentRange(PIX*, l_int32, l_int32, l_int32, l_int32*, l_int32*, l_uint32**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1435</i>
     */
    public static int pixGetBinnedComponentRange(Pointer<Pix> pixs, int nbins,
            int factor, int color, Pointer<Integer> pminval,
            Pointer<Integer> pmaxval, Pointer<Pointer<Integer>> pcarray,
            int debugflag) {
        return pixGetBinnedComponentRange(Pointer.getPeer(pixs), nbins, factor,
                color, Pointer.getPeer(pminval), Pointer.getPeer(pmaxval),
                Pointer.getPeer(pcarray), debugflag);
    }

    protected native static int pixGetBinnedComponentRange(@Ptr long pixs,
            int nbins, int factor, int color, @Ptr long pminval,
            @Ptr long pmaxval, @Ptr long pcarray, int debugflag);

    /**
     * Original signature :
     * <code>l_int32 pixGetRankColorArray(PIX*, l_int32, l_int32, l_int32, l_uint32**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1436</i>
     */
    public static int pixGetRankColorArray(Pointer<Pix> pixs, int nbins,
            int type, int factor, Pointer<Pointer<Integer>> pcarray,
            int debugflag) {
        return pixGetRankColorArray(Pointer.getPeer(pixs), nbins, type, factor,
                Pointer.getPeer(pcarray), debugflag);
    }

    protected native static int pixGetRankColorArray(@Ptr long pixs, int nbins,
            int type, int factor, @Ptr long pcarray, int debugflag);

    /**
     * Original signature :
     * <code>l_int32 pixGetBinnedColor(PIX*, PIX*, l_int32, l_int32, NUMA*, l_uint32**, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1437</i>
     */
    public static int pixGetBinnedColor(Pointer<Pix> pixs, Pointer<Pix> pixg,
            int factor, int nbins, Pointer<Numa> nalut,
            Pointer<Pointer<Integer>> pcarray, int debugflag) {
        return pixGetBinnedColor(Pointer.getPeer(pixs), Pointer.getPeer(pixg),
                factor, nbins, Pointer.getPeer(nalut),
                Pointer.getPeer(pcarray), debugflag);
    }

    protected native static int pixGetBinnedColor(@Ptr long pixs,
            @Ptr long pixg, int factor, int nbins, @Ptr long nalut,
            @Ptr long pcarray, int debugflag);

    /**
     * Original signature :
     * <code>PIX* pixDisplayColorArray(l_uint32*, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1438</i>
     */
    public static Pointer<Pix> pixDisplayColorArray(Pointer<Integer> carray,
            int ncolors, int side, int ncols, int textflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixDisplayColorArray(Pointer.getPeer(carray), ncolors, side,
                        ncols, textflag), Pix.class);
    }

    @Ptr
    protected native static long pixDisplayColorArray(@Ptr long carray,
            int ncolors, int side, int ncols, int textflag);

    /**
     * Original signature :
     * <code>PIX* pixaGetAlignedStats(PIXA*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1439</i>
     */
    public static Pointer<Pix> pixaGetAlignedStats(Pointer<Pixa> pixa,
            int type, int nbins, int thresh) {
        return (Pointer) Pointer.pointerToAddress(
                pixaGetAlignedStats(Pointer.getPeer(pixa), type, nbins, thresh),
                Pix.class);
    }

    @Ptr
    protected native static long pixaGetAlignedStats(@Ptr long pixa, int type,
            int nbins, int thresh);

    /**
     * Original signature :
     * <code>l_int32 pixaExtractColumnFromEachPix(PIXA*, l_int32, PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1440</i>
     */
    public static int pixaExtractColumnFromEachPix(Pointer<Pixa> pixa, int col,
            Pointer<Pix> pixd) {
        return pixaExtractColumnFromEachPix(Pointer.getPeer(pixa), col,
                Pointer.getPeer(pixd));
    }

    protected native static int pixaExtractColumnFromEachPix(@Ptr long pixa,
            int col, @Ptr long pixd);

    /**
     * Original signature :
     * <code>l_int32 pixGetRowStats(PIX*, l_int32, l_int32, l_int32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1441</i>
     */
    public static int pixGetRowStats(Pointer<Pix> pixs, int type, int nbins,
            int thresh, Pointer<Float> colvect) {
        return pixGetRowStats(Pointer.getPeer(pixs), type, nbins, thresh,
                Pointer.getPeer(colvect));
    }

    protected native static int pixGetRowStats(@Ptr long pixs, int type,
            int nbins, int thresh, @Ptr long colvect);

    /**
     * Original signature :
     * <code>l_int32 pixGetColumnStats(PIX*, l_int32, l_int32, l_int32, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1442</i>
     */
    public static int pixGetColumnStats(Pointer<Pix> pixs, int type, int nbins,
            int thresh, Pointer<Float> rowvect) {
        return pixGetColumnStats(Pointer.getPeer(pixs), type, nbins, thresh,
                Pointer.getPeer(rowvect));
    }

    protected native static int pixGetColumnStats(@Ptr long pixs, int type,
            int nbins, int thresh, @Ptr long rowvect);

    /**
     * Original signature :
     * <code>l_int32 pixSetPixelColumn(PIX*, l_int32, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1443</i>
     */
    public static int pixSetPixelColumn(Pointer<Pix> pix, int col,
            Pointer<Float> colvect) {
        return pixSetPixelColumn(Pointer.getPeer(pix), col,
                Pointer.getPeer(colvect));
    }

    protected native static int pixSetPixelColumn(@Ptr long pix, int col,
            @Ptr long colvect);

    /**
     * Original signature :
     * <code>l_int32 pixThresholdForFgBg(PIX*, l_int32, l_int32, l_int32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1444</i>
     */
    public static int pixThresholdForFgBg(Pointer<Pix> pixs, int factor,
            int thresh, Pointer<Integer> pfgval, Pointer<Integer> pbgval) {
        return pixThresholdForFgBg(Pointer.getPeer(pixs), factor, thresh,
                Pointer.getPeer(pfgval), Pointer.getPeer(pbgval));
    }

    protected native static int pixThresholdForFgBg(@Ptr long pixs, int factor,
            int thresh, @Ptr long pfgval, @Ptr long pbgval);

    /**
     * Original signature :
     * <code>l_int32 pixSplitDistributionFgBg(PIX*, l_float32, l_int32, l_int32*, l_int32*, l_int32*, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1445</i>
     */
    public static int pixSplitDistributionFgBg(Pointer<Pix> pixs,
            float scorefract, int factor, Pointer<Integer> pthresh,
            Pointer<Integer> pfgval, Pointer<Integer> pbgval, int debugflag) {
        return pixSplitDistributionFgBg(Pointer.getPeer(pixs), scorefract,
                factor, Pointer.getPeer(pthresh), Pointer.getPeer(pfgval),
                Pointer.getPeer(pbgval), debugflag);
    }

    protected native static int pixSplitDistributionFgBg(@Ptr long pixs,
            float scorefract, int factor, @Ptr long pthresh, @Ptr long pfgval,
            @Ptr long pbgval, int debugflag);

    /**
     * Original signature :
     * <code>l_int32 pixaFindDimensions(PIXA*, NUMA**, NUMA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1446</i>
     */
    public static int pixaFindDimensions(Pointer<Pixa> pixa,
            Pointer<Pointer<Numa>> pnaw, Pointer<Pointer<Numa>> pnah) {
        return pixaFindDimensions(Pointer.getPeer(pixa), Pointer.getPeer(pnaw),
                Pointer.getPeer(pnah));
    }

    protected native static int pixaFindDimensions(@Ptr long pixa,
            @Ptr long pnaw, @Ptr long pnah);

    /**
     * Original signature :
     * <code>l_int32 pixFindAreaPerimRatio(PIX*, l_int32*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1447</i>
     */
    public static int pixFindAreaPerimRatio(Pointer<Pix> pixs,
            Pointer<Integer> tab, Pointer<Float> pfract) {
        return pixFindAreaPerimRatio(Pointer.getPeer(pixs),
                Pointer.getPeer(tab), Pointer.getPeer(pfract));
    }

    protected native static int pixFindAreaPerimRatio(@Ptr long pixs,
            @Ptr long tab, @Ptr long pfract);

    /**
     * Original signature : <code>NUMA* pixaFindPerimToAreaRatio(PIXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1448</i>
     */
    public static Pointer<Numa> pixaFindPerimToAreaRatio(Pointer<Pixa> pixa) {
        return (Pointer) Pointer.pointerToAddress(
                pixaFindPerimToAreaRatio(Pointer.getPeer(pixa)), Numa.class);
    }

    @Ptr
    protected native static long pixaFindPerimToAreaRatio(@Ptr long pixa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixFindPerimToAreaRatio(PIX*, l_int32*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1449</i>
     */
    public static int pixFindPerimToAreaRatio(Pointer<Pix> pixs,
            Pointer<Integer> tab, Pointer<Float> pfract) {
        return pixFindPerimToAreaRatio(Pointer.getPeer(pixs),
                Pointer.getPeer(tab), Pointer.getPeer(pfract));
    }

    protected native static int pixFindPerimToAreaRatio(@Ptr long pixs,
            @Ptr long tab, @Ptr long pfract);

    /**
     * Original signature : <code>NUMA* pixaFindPerimSizeRatio(PIXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1450</i>
     */
    public static Pointer<Numa> pixaFindPerimSizeRatio(Pointer<Pixa> pixa) {
        return (Pointer) Pointer.pointerToAddress(
                pixaFindPerimSizeRatio(Pointer.getPeer(pixa)), Numa.class);
    }

    @Ptr
    protected native static long pixaFindPerimSizeRatio(@Ptr long pixa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixFindPerimSizeRatio(PIX*, l_int32*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1451</i>
     */
    public static int pixFindPerimSizeRatio(Pointer<Pix> pixs,
            Pointer<Integer> tab, Pointer<Float> pratio) {
        return pixFindPerimSizeRatio(Pointer.getPeer(pixs),
                Pointer.getPeer(tab), Pointer.getPeer(pratio));
    }

    protected native static int pixFindPerimSizeRatio(@Ptr long pixs,
            @Ptr long tab, @Ptr long pratio);

    /**
     * Original signature : <code>NUMA* pixaFindAreaFraction(PIXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1452</i>
     */
    public static Pointer<Numa> pixaFindAreaFraction(Pointer<Pixa> pixa) {
        return (Pointer) Pointer.pointerToAddress(
                pixaFindAreaFraction(Pointer.getPeer(pixa)), Numa.class);
    }

    @Ptr
    protected native static long pixaFindAreaFraction(@Ptr long pixa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixFindAreaFraction(PIX*, l_int32*, l_float32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1453</i>
     */
    public static int pixFindAreaFraction(Pointer<Pix> pixs,
            Pointer<Integer> tab, Pointer<Float> pfract) {
        return pixFindAreaFraction(Pointer.getPeer(pixs), Pointer.getPeer(tab),
                Pointer.getPeer(pfract));
    }

    protected native static int pixFindAreaFraction(@Ptr long pixs,
            @Ptr long tab, @Ptr long pfract);

    /**
     * Original signature :
     * <code>NUMA* pixaFindAreaFractionMasked(PIXA*, PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1454</i>
     */
    public static Pointer<Numa> pixaFindAreaFractionMasked(Pointer<Pixa> pixa,
            Pointer<Pix> pixm, int debug) {
        return (Pointer) Pointer.pointerToAddress(
                pixaFindAreaFractionMasked(Pointer.getPeer(pixa),
                        Pointer.getPeer(pixm), debug), Numa.class);
    }

    @Ptr
    protected native static long pixaFindAreaFractionMasked(@Ptr long pixa,
            @Ptr long pixm, int debug);

    /**
     * Original signature :
     * <code>l_int32 pixFindAreaFractionMasked(PIX*, BOX*, PIX*, l_int32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1455</i>
     */
    public static int pixFindAreaFractionMasked(Pointer<Pix> pixs,
            Pointer<Box> box, Pointer<Pix> pixm, Pointer<Integer> tab,
            Pointer<Float> pfract) {
        return pixFindAreaFractionMasked(Pointer.getPeer(pixs),
                Pointer.getPeer(box), Pointer.getPeer(pixm),
                Pointer.getPeer(tab), Pointer.getPeer(pfract));
    }

    protected native static int pixFindAreaFractionMasked(@Ptr long pixs,
            @Ptr long box, @Ptr long pixm, @Ptr long tab, @Ptr long pfract);

    /**
     * Original signature : <code>NUMA* pixaFindWidthHeightRatio(PIXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1456</i>
     */
    public static Pointer<Numa> pixaFindWidthHeightRatio(Pointer<Pixa> pixa) {
        return (Pointer) Pointer.pointerToAddress(
                pixaFindWidthHeightRatio(Pointer.getPeer(pixa)), Numa.class);
    }

    @Ptr
    protected native static long pixaFindWidthHeightRatio(@Ptr long pixa) throws LastError;

    /**
     * Original signature : <code>NUMA* pixaFindWidthHeightProduct(PIXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1457</i>
     */
    public static Pointer<Numa> pixaFindWidthHeightProduct(Pointer<Pixa> pixa) {
        return (Pointer) Pointer.pointerToAddress(
                pixaFindWidthHeightProduct(Pointer.getPeer(pixa)), Numa.class);
    }

    @Ptr
    protected native static long pixaFindWidthHeightProduct(@Ptr long pixa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixFindOverlapFraction(PIX*, PIX*, l_int32, l_int32, l_int32*, l_float32*, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1458</i>
     */
    public static int pixFindOverlapFraction(Pointer<Pix> pixs1,
            Pointer<Pix> pixs2, int x2, int y2, Pointer<Integer> tab,
            Pointer<Float> pratio, Pointer<Integer> pnoverlap) {
        return pixFindOverlapFraction(Pointer.getPeer(pixs1),
                Pointer.getPeer(pixs2), x2, y2, Pointer.getPeer(tab),
                Pointer.getPeer(pratio), Pointer.getPeer(pnoverlap));
    }

    protected native static int pixFindOverlapFraction(@Ptr long pixs1,
            @Ptr long pixs2, int x2, int y2, @Ptr long tab, @Ptr long pratio,
            @Ptr long pnoverlap);

    /**
     * Original signature :
     * <code>BOXA* pixFindRectangleComps(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1459</i>
     */
    public static Pointer<Boxa> pixFindRectangleComps(Pointer<Pix> pixs,
            int dist, int minw, int minh) {
        return (Pointer) Pointer.pointerToAddress(
                pixFindRectangleComps(Pointer.getPeer(pixs), dist, minw, minh),
                Boxa.class);
    }

    @Ptr
    protected native static long pixFindRectangleComps(@Ptr long pixs,
            int dist, int minw, int minh);

    /**
     * Original signature :
     * <code>l_int32 pixConformsToRectangle(PIX*, BOX*, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1460</i>
     */
    public static int pixConformsToRectangle(Pointer<Pix> pixs,
            Pointer<Box> box, int dist, Pointer<Integer> pconforms) {
        return pixConformsToRectangle(Pointer.getPeer(pixs),
                Pointer.getPeer(box), dist, Pointer.getPeer(pconforms));
    }

    protected native static int pixConformsToRectangle(@Ptr long pixs,
            @Ptr long box, int dist, @Ptr long pconforms);

    /**
     * Original signature : <code>PIXA* pixClipRectangles(PIX*, BOXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1461</i>
     */
    public static Pointer<Pixa> pixClipRectangles(Pointer<Pix> pixs,
            Pointer<Boxa> boxa) {
        return (Pointer) Pointer.pointerToAddress(
                pixClipRectangles(Pointer.getPeer(pixs), Pointer.getPeer(boxa)),
                Pixa.class);
    }

    @Ptr
    protected native static long pixClipRectangles(@Ptr long pixs,
            @Ptr long boxa);

    /**
     * Original signature :
     * <code>PIX* pixClipRectangle(PIX*, BOX*, BOX**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1462</i>
     */
    public static Pointer<Pix> pixClipRectangle(Pointer<Pix> pixs,
            Pointer<Box> box, Pointer<Pointer<Box>> pboxc) {
        return (Pointer) Pointer.pointerToAddress(
                pixClipRectangle(Pointer.getPeer(pixs), Pointer.getPeer(box),
                        Pointer.getPeer(pboxc)), Pix.class);
    }

    @Ptr
    protected native static long pixClipRectangle(@Ptr long pixs,
            @Ptr long box, @Ptr long pboxc);

    /**
     * Original signature :
     * <code>PIX* pixClipMasked(PIX*, PIX*, l_int32, l_int32, l_uint32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1463</i>
     */
    public static Pointer<Pix> pixClipMasked(Pointer<Pix> pixs,
            Pointer<Pix> pixm, int x, int y, int outval) {
        return (Pointer) Pointer.pointerToAddress(
                pixClipMasked(Pointer.getPeer(pixs), Pointer.getPeer(pixm), x,
                        y, outval), Pix.class);
    }

    @Ptr
    protected native static long pixClipMasked(@Ptr long pixs, @Ptr long pixm,
            int x, int y, int outval);

    /**
     * Original signature :
     * <code>l_int32 pixCropToMatch(PIX*, PIX*, PIX**, PIX**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1464</i>
     */
    public static int pixCropToMatch(Pointer<Pix> pixs1, Pointer<Pix> pixs2,
            Pointer<Pointer<Pix>> ppixd1, Pointer<Pointer<Pix>> ppixd2) {
        return pixCropToMatch(Pointer.getPeer(pixs1), Pointer.getPeer(pixs2),
                Pointer.getPeer(ppixd1), Pointer.getPeer(ppixd2));
    }

    protected native static int pixCropToMatch(@Ptr long pixs1,
            @Ptr long pixs2, @Ptr long ppixd1, @Ptr long ppixd2);

    /**
     * Original signature :
     * <code>PIX* pixCropToSize(PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1465</i>
     */
    public static Pointer<Pix> pixCropToSize(Pointer<Pix> pixs, int w, int h) {
        return (Pointer) Pointer.pointerToAddress(
                pixCropToSize(Pointer.getPeer(pixs), w, h), Pix.class);
    }

    @Ptr
    protected native static long pixCropToSize(@Ptr long pixs, int w, int h) throws LastError;

    /**
     * Original signature :
     * <code>PIX* pixResizeToMatch(PIX*, PIX*, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1466</i>
     */
    public static Pointer<Pix> pixResizeToMatch(Pointer<Pix> pixs,
            Pointer<Pix> pixt, int w, int h) {
        return (Pointer) Pointer.pointerToAddress(
                pixResizeToMatch(Pointer.getPeer(pixs), Pointer.getPeer(pixt),
                        w, h), Pix.class);
    }

    @Ptr
    protected native static long pixResizeToMatch(@Ptr long pixs,
            @Ptr long pixt, int w, int h);

    /**
     * Original signature :
     * <code>l_int32 pixClipToForeground(PIX*, PIX**, BOX**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1467</i>
     */
    public static int pixClipToForeground(Pointer<Pix> pixs,
            Pointer<Pointer<Pix>> ppixd, Pointer<Pointer<Box>> pbox) {
        return pixClipToForeground(Pointer.getPeer(pixs),
                Pointer.getPeer(ppixd), Pointer.getPeer(pbox));
    }

    protected native static int pixClipToForeground(@Ptr long pixs,
            @Ptr long ppixd, @Ptr long pbox);

    /**
     * Original signature :
     * <code>l_int32 pixTestClipToForeground(PIX*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1468</i>
     */
    public static int pixTestClipToForeground(Pointer<Pix> pixs,
            Pointer<Integer> pcanclip) {
        return pixTestClipToForeground(Pointer.getPeer(pixs),
                Pointer.getPeer(pcanclip));
    }

    protected native static int pixTestClipToForeground(@Ptr long pixs,
            @Ptr long pcanclip);

    /**
     * Original signature :
     * <code>l_int32 pixClipBoxToForeground(PIX*, BOX*, PIX**, BOX**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1469</i>
     */
    public static int pixClipBoxToForeground(Pointer<Pix> pixs,
            Pointer<Box> boxs, Pointer<Pointer<Pix>> ppixd,
            Pointer<Pointer<Box>> pboxd) {
        return pixClipBoxToForeground(Pointer.getPeer(pixs),
                Pointer.getPeer(boxs), Pointer.getPeer(ppixd),
                Pointer.getPeer(pboxd));
    }

    protected native static int pixClipBoxToForeground(@Ptr long pixs,
            @Ptr long boxs, @Ptr long ppixd, @Ptr long pboxd);

    /**
     * Original signature :
     * <code>l_int32 pixScanForForeground(PIX*, BOX*, l_int32, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1470</i>
     */
    public static int pixScanForForeground(Pointer<Pix> pixs, Pointer<Box> box,
            int scanflag, Pointer<Integer> ploc) {
        return pixScanForForeground(Pointer.getPeer(pixs),
                Pointer.getPeer(box), scanflag, Pointer.getPeer(ploc));
    }

    protected native static int pixScanForForeground(@Ptr long pixs,
            @Ptr long box, int scanflag, @Ptr long ploc);

    /**
     * Original signature :
     * <code>l_int32 pixClipBoxToEdges(PIX*, BOX*, l_int32, l_int32, l_int32, l_int32, PIX**, BOX**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1471</i>
     */
    public static int pixClipBoxToEdges(Pointer<Pix> pixs, Pointer<Box> boxs,
            int lowthresh, int highthresh, int maxwidth, int factor,
            Pointer<Pointer<Pix>> ppixd, Pointer<Pointer<Box>> pboxd) {
        return pixClipBoxToEdges(Pointer.getPeer(pixs), Pointer.getPeer(boxs),
                lowthresh, highthresh, maxwidth, factor,
                Pointer.getPeer(ppixd), Pointer.getPeer(pboxd));
    }

    protected native static int pixClipBoxToEdges(@Ptr long pixs,
            @Ptr long boxs, int lowthresh, int highthresh, int maxwidth,
            int factor, @Ptr long ppixd, @Ptr long pboxd);

    /**
     * Original signature :
     * <code>l_int32 pixScanForEdge(PIX*, BOX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1472</i>
     */
    public static int pixScanForEdge(Pointer<Pix> pixs, Pointer<Box> box,
            int lowthresh, int highthresh, int maxwidth, int factor,
            int scanflag, Pointer<Integer> ploc) {
        return pixScanForEdge(Pointer.getPeer(pixs), Pointer.getPeer(box),
                lowthresh, highthresh, maxwidth, factor, scanflag,
                Pointer.getPeer(ploc));
    }

    protected native static int pixScanForEdge(@Ptr long pixs, @Ptr long box,
            int lowthresh, int highthresh, int maxwidth, int factor,
            int scanflag, @Ptr long ploc);

    /**
     * Original signature :
     * <code>NUMA* pixExtractOnLine(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1473</i>
     */
    public static Pointer<Numa> pixExtractOnLine(Pointer<Pix> pixs, int x1,
            int y1, int x2, int y2, int factor) {
        return (Pointer) Pointer.pointerToAddress(
                pixExtractOnLine(Pointer.getPeer(pixs), x1, y1, x2, y2, factor),
                Numa.class);
    }

    @Ptr
    protected native static long pixExtractOnLine(@Ptr long pixs, int x1,
            int y1, int x2, int y2, int factor);

    /**
     * Original signature :
     * <code>l_float32 pixAverageOnLine(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1474</i>
     */
    public static float pixAverageOnLine(Pointer<Pix> pixs, int x1, int y1,
            int x2, int y2, int factor) {
        return pixAverageOnLine(Pointer.getPeer(pixs), x1, y1, x2, y2, factor);
    }

    protected native static float pixAverageOnLine(@Ptr long pixs, int x1,
            int y1, int x2, int y2, int factor);

    /**
     * Original signature :
     * <code>NUMA* pixAverageIntensityProfile(PIX*, l_float32, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1475</i>
     */
    public static Pointer<Numa> pixAverageIntensityProfile(Pointer<Pix> pixs,
            float fract, int dir, int first, int last, int factor1, int factor2) {
        return (Pointer) Pointer.pointerToAddress(
                pixAverageIntensityProfile(Pointer.getPeer(pixs), fract, dir,
                        first, last, factor1, factor2), Numa.class);
    }

    @Ptr
    protected native static long pixAverageIntensityProfile(@Ptr long pixs,
            float fract, int dir, int first, int last, int factor1, int factor2);

    /**
     * Original signature :
     * <code>NUMA* pixReversalProfile(PIX*, l_float32, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1476</i>
     */
    public static Pointer<Numa> pixReversalProfile(Pointer<Pix> pixs,
            float fract, int dir, int first, int last, int minreversal,
            int factor1, int factor2) {
        return (Pointer) Pointer.pointerToAddress(
                pixReversalProfile(Pointer.getPeer(pixs), fract, dir, first,
                        last, minreversal, factor1, factor2), Numa.class);
    }

    @Ptr
    protected native static long pixReversalProfile(@Ptr long pixs,
            float fract, int dir, int first, int last, int minreversal,
            int factor1, int factor2);

    /**
     * Original signature :
     * <code>l_int32 pixWindowedVarianceOnLine(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, NUMA**)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1477</i>
     */
    public static int pixWindowedVarianceOnLine(Pointer<Pix> pixs, int dir,
            int loc, int c1, int c2, int size, Pointer<Pointer<Numa>> pnad) {
        return pixWindowedVarianceOnLine(Pointer.getPeer(pixs), dir, loc, c1,
                c2, size, Pointer.getPeer(pnad));
    }

    protected native static int pixWindowedVarianceOnLine(@Ptr long pixs,
            int dir, int loc, int c1, int c2, int size, @Ptr long pnad);

    /**
     * Original signature :
     * <code>l_int32 pixMinMaxNearLine(PIX*, l_int32, l_int32, l_int32, l_int32, l_int32, l_int32, NUMA**, NUMA**, l_float32*, l_float32*)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1478</i>
     */
    public static int pixMinMaxNearLine(Pointer<Pix> pixs, int x1, int y1,
            int x2, int y2, int dist, int direction,
            Pointer<Pointer<Numa>> pnamin, Pointer<Pointer<Numa>> pnamax,
            Pointer<Float> pminave, Pointer<Float> pmaxave) {
        return pixMinMaxNearLine(Pointer.getPeer(pixs), x1, y1, x2, y2, dist,
                direction, Pointer.getPeer(pnamin), Pointer.getPeer(pnamax),
                Pointer.getPeer(pminave), Pointer.getPeer(pmaxave));
    }

    protected native static int pixMinMaxNearLine(@Ptr long pixs, int x1,
            int y1, int x2, int y2, int dist, int direction, @Ptr long pnamin,
            @Ptr long pnamax, @Ptr long pminave, @Ptr long pmaxave);

    /**
     * Original signature : <code>PIX* pixRankRowTransform(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1479</i>
     */
    public static Pointer<Pix> pixRankRowTransform(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixRankRowTransform(Pointer.getPeer(pixs)), Pix.class);
    }

    @Ptr
    protected native static long pixRankRowTransform(@Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>PIX* pixRankColumnTransform(PIX*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1480</i>
     */
    public static Pointer<Pix> pixRankColumnTransform(Pointer<Pix> pixs) {
        return (Pointer) Pointer.pointerToAddress(
                pixRankColumnTransform(Pointer.getPeer(pixs)), Pix.class);
    }

    @Ptr
    protected native static long pixRankColumnTransform(@Ptr long pixs) throws LastError;

    /**
     * Original signature : <code>PIXA* pixaCreate(l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1481</i>
     */
    public static Pointer<Pixa> pixaCreate(int n) {
        return (Pointer) Pointer.pointerToAddress(pixaCreate$2(n), Pixa.class);
    }

    @Ptr
    @Name("pixaCreate")
    protected native static long pixaCreate$2(int n) throws LastError;

    /**
     * Original signature :
     * <code>PIXA* pixaCreateFromPix(PIX*, l_int32, l_int32, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1482</i>
     */
    public static Pointer<Pixa> pixaCreateFromPix(Pointer<Pix> pixs, int n,
            int cellw, int cellh) {
        return (Pointer) Pointer.pointerToAddress(
                pixaCreateFromPix(Pointer.getPeer(pixs), n, cellw, cellh),
                Pixa.class);
    }

    @Ptr
    protected native static long pixaCreateFromPix(@Ptr long pixs, int n,
            int cellw, int cellh);

    /**
     * Original signature :
     * <code>PIXA* pixaCreateFromBoxa(PIX*, BOXA*, l_int32*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1483</i>
     */
    public static Pointer<Pixa> pixaCreateFromBoxa(Pointer<Pix> pixs,
            Pointer<Boxa> boxa, Pointer<Integer> pcropwarn) {
        return (Pointer) Pointer.pointerToAddress(
                pixaCreateFromBoxa(Pointer.getPeer(pixs),
                        Pointer.getPeer(boxa), Pointer.getPeer(pcropwarn)),
                Pixa.class);
    }

    @Ptr
    protected native static long pixaCreateFromBoxa(@Ptr long pixs,
            @Ptr long boxa, @Ptr long pcropwarn);

    /**
     * Original signature :
     * <code>PIXA* pixaSplitPix(PIX*, l_int32, l_int32, l_int32, l_uint32)</code>
     * <br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1484</i>
     */
    public static Pointer<Pixa> pixaSplitPix(Pointer<Pix> pixs, int nx, int ny,
            int borderwidth, int bordercolor) {
        return (Pointer) Pointer.pointerToAddress(
                pixaSplitPix(Pointer.getPeer(pixs), nx, ny, borderwidth,
                        bordercolor), Pixa.class);
    }

    @Ptr
    protected native static long pixaSplitPix(@Ptr long pixs, int nx, int ny,
            int borderwidth, int bordercolor);

    /**
     * Original signature : <code>void pixaDestroy(PIXA**)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1485</i>
     */
    public static void pixaDestroy(Pointer<Pointer<Pixa>> ppixa) {
        pixaDestroy(Pointer.getPeer(ppixa));
    }

    protected native static void pixaDestroy(@Ptr long ppixa) throws LastError;

    /**
     * Original signature : <code>PIXA* pixaCopy(PIXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1486</i>
     */
    public static Pointer<Pixa> pixaCopy(Pointer<Pixa> pixa, int copyflag) {
        return (Pointer) Pointer.pointerToAddress(
                pixaCopy(Pointer.getPeer(pixa), copyflag), Pixa.class);
    }

    @Ptr
    protected native static long pixaCopy(@Ptr long pixa, int copyflag) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixaAddPix(PIXA*, PIX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1487</i>
     */
    public static int pixaAddPix(Pointer<Pixa> pixa, Pointer<Pix> pix,
            int copyflag) {
        return pixaAddPix(Pointer.getPeer(pixa), Pointer.getPeer(pix), copyflag);
    }

    protected native static int pixaAddPix(@Ptr long pixa, @Ptr long pix,
            int copyflag);

    /**
     * Original signature :
     * <code>l_int32 pixaAddBox(PIXA*, BOX*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1488</i>
     */
    public static int pixaAddBox(Pointer<Pixa> pixa, Pointer<Box> box,
            int copyflag) {
        return pixaAddBox(Pointer.getPeer(pixa), Pointer.getPeer(box), copyflag);
    }

    protected native static int pixaAddBox(@Ptr long pixa, @Ptr long box,
            int copyflag);

    /**
     * Original signature :
     * <code>l_int32 pixaExtendArrayToSize(PIXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1489</i>
     */
    public static int pixaExtendArrayToSize(Pointer<Pixa> pixa, int size) {
        return pixaExtendArrayToSize(Pointer.getPeer(pixa), size);
    }

    protected native static int pixaExtendArrayToSize(@Ptr long pixa, int size) throws LastError;

    /**
     * Original signature : <code>l_int32 pixaGetCount(PIXA*)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1490</i>
     */
    public static int pixaGetCount(Pointer<Pixa> pixa) {
        return pixaGetCount(Pointer.getPeer(pixa));
    }

    protected native static int pixaGetCount(@Ptr long pixa) throws LastError;

    /**
     * Original signature :
     * <code>l_int32 pixaChangeRefcount(PIXA*, l_int32)</code><br>
     * <i>native declaration :
     * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013
     * \tesseract-vs2013\liblept\include\allheaders.h:1491</i>
     */
    public static int pixaChangeRefcount(Pointer<Pixa> pixa, int delta) {
        return pixaChangeRefcount(Pointer.getPeer(pixa), 