package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * Data used for decoding a line of characters.<br>
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\recog.h:201</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class L_Rdid extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * clone of pix to be decoded<br>
     * C type : Pix*
     */
    @Field(0)
    public Pointer<Pix> pixs() {
        return this.io.getPointerField(this, 0);
    }

    /**
     * clone of pix to be decoded<br>
     * C type : Pix*
     */
    @Field(0)
    public L_Rdid pixs(Pointer<Pix> pixs) {
        this.io.setPointerField(this, 0, pixs);
        return this;
    }

    /**
     * count array for each averaged template<br>
     * C type : l_int32**
     */
    @Field(1)
    public Pointer<Pointer<Integer>> counta() {
        return this.io.getPointerField(this, 1);
    }

    /**
     * count array for each averaged template<br>
     * C type : l_int32**
     */
    @Field(1)
    public L_Rdid counta(Pointer<Pointer<Integer>> counta) {
        this.io.setPointerField(this, 1, counta);
        return this;
    }

    /**
     * best y-shift array per averaged template<br>
     * C type : l_int32**
     */
    @Field(2)
    public Pointer<Pointer<Integer>> delya() {
        return this.io.getPointerField(this, 2);
    }

    /**
     * best y-shift array per averaged template<br>
     * C type : l_int32**
     */
    @Field(2)
    public L_Rdid delya(Pointer<Pointer<Integer>> delya) {
        this.io.setPointerField(this, 2, delya);
        return this;
    }

    /**
     * number of averaged templates<br>
     * C type : l_int32
     */
    @Field(3)
    public int narray() {
        return this.io.getIntField(this, 3);
    }

    /**
     * number of averaged templates<br>
     * C type : l_int32
     */
    @Field(3)
    public L_Rdid narray(int narray) {
        this.io.setIntField(this, 3, narray);
        return this;
    }

    /**
     * size of count array (width of pixs)<br>
     * C type : l_int32
     */
    @Field(4)
    public int size() {
        return this.io.getIntField(this, 4);
    }

    /**
     * size of count array (width of pixs)<br>
     * C type : l_int32
     */
    @Field(4)
    public L_Rdid size(int size) {
        this.io.setIntField(this, 4, size);
        return this;
    }

    /**
     * setwidths for each template<br>
     * C type : l_int32*
     */
    @Field(5)
    public Pointer<Integer> setwidth() {
        return this.io.getPointerField(this, 5);
    }

    /**
     * setwidths for each template<br>
     * C type : l_int32*
     */
    @Field(5)
    public L_Rdid setwidth(Pointer<Integer> setwidth) {
        this.io.setPointerField(this, 5, setwidth);
        return this;
    }

    /**
     * pixel count in pixs by column<br>
     * C type : Numa*
     */
    @Field(6)
    public Pointer<Numa> nasum() {
        return this.io.getPointerField(this, 6);
    }

    /**
     * pixel count in pixs by column<br>
     * C type : Numa*
     */
    @Field(6)
    public L_Rdid nasum(Pointer<Numa> nasum) {
        this.io.setPointerField(this, 6, nasum);
        return this;
    }

    /**
     * first moment of pixels in pixs by column<br>
     * C type : Numa*
     */
    @Field(7)
    public Pointer<Numa> namoment() {
        return this.io.getPointerField(this, 7);
    }

    /**
     * first moment of pixels in pixs by column<br>
     * C type : Numa*
     */
    @Field(7)
    public L_Rdid namoment(Pointer<Numa> namoment) {
        this.io.setPointerField(this, 7, namoment);
        return this;
    }

    /**
     * 1 if full arrays are made; 0 otherwise<br>
     * C type : l_int32
     */
    @Field(8)
    public int fullarrays() {
        return this.io.getIntField(this, 8);
    }

    /**
     * 1 if full arrays are made; 0 otherwise<br>
     * C type : l_int32
     */
    @Field(8)
    public L_Rdid fullarrays(int fullarrays) {
        this.io.setIntField(this, 8, fullarrays);
        return this;
    }

    /**
     * channel coeffs for template fg term<br>
     * C type : l_float32*
     */
    @Field(9)
    public Pointer<Float> beta() {
        return this.io.getPointerField(this, 9);
    }

    /**
     * channel coeffs for template fg term<br>
     * C type : l_float32*
     */
    @Field(9)
    public L_Rdid beta(Pointer<Float> beta) {
        this.io.setPointerField(this, 9, beta);
        return this;
    }

    /**
     * channel coeffs for bit-and term<br>
     * C type : l_float32*
     */
    @Field(10)
    public Pointer<Float> gamma() {
        return this.io.getPointerField(this, 10);
    }

    /**
     * channel coeffs for bit-and term<br>
     * C type : l_float32*
     */
    @Field(10)
    public L_Rdid gamma(Pointer<Float> gamma) {
        this.io.setPointerField(this, 10, gamma);
        return this;
    }

    /**
     * score on trellis<br>
     * C type : l_float32*
     */
    @Field(11)
    public Pointer<Float> trellisscore() {
        return this.io.getPointerField(this, 11);
    }

    /**
     * score on trellis<br>
     * C type : l_float32*
     */
    @Field(11)
    public L_Rdid trellisscore(Pointer<Float> trellisscore) {
        this.io.setPointerField(this, 11, trellisscore);
        return this;
    }

    /**
     * template on trellis (for backtrack)<br>
     * C type : l_int32*
     */
    @Field(12)
    public Pointer<Integer> trellistempl() {
        return this.io.getPointerField(this, 12);
    }

    /**
     * template on trellis (for backtrack)<br>
     * C type : l_int32*
     */
    @Field(12)
    public L_Rdid trellistempl(Pointer<Integer> trellistempl) {
        this.io.setPointerField(this, 12, trellistempl);
        return this;
    }

    /**
     * indices of best path templates<br>
     * C type : Numa*
     */
    @Field(13)
    public Pointer<Numa> natempl() {
        return this.io.getPointerField(this, 13);
    }

    /**
     * indices of best path templates<br>
     * C type : Numa*
     */
    @Field(13)
    public L_Rdid natempl(Pointer<Numa> natempl) {
        this.io.setPointerField(this, 13, natempl);
        return this;
    }

    /**
     * x locations of best path templates<br>
     * C type : Numa*
     */
    @Field(14)
    public Pointer<Numa> naxloc() {
        return this.io.getPointerField(this, 14);
    }

    /**
     * x locations of best path templates<br>
     * C type : Numa*
     */
    @Field(14)
    public L_Rdid naxloc(Pointer<Numa> naxloc) {
        this.io.setPointerField(this, 14, naxloc);
        return this;
    }

    /**
     * y locations of best path templates<br>
     * C type : Numa*
     */
    @Field(15)
    public Pointer<Numa> nadely() {
        return this.io.getPointerField(this, 15);
    }

    /**
     * y locations of best path templates<br>
     * C type : Numa*
     */
    @Field(15)
    public L_Rdid nadely(Pointer<Numa> nadely) {
        this.io.setPointerField(this, 15, nadely);
        return this;
    }

    /**
     * widths of best path templates<br>
     * C type : Numa*
     */
    @Field(16)
    public Pointer<Numa> nawidth() {
        return this.io.getPointerField(this, 16);
    }

    /**
     * widths of best path templates<br>
     * C type : Numa*
     */
    @Field(16)
    public L_Rdid nawidth(Pointer<Numa> nawidth) {
        this.io.setPointerField(this, 16, nawidth);
        return this;
    }

    /**
     * correlation scores: best path templates<br>
     * C type : Numa*
     */
    @Field(17)
    public Pointer<Numa> nascore() {
        return this.io.getPointerField(this, 17);
    }

    /**
     * correlation scores: best path templates<br>
     * C type : Numa*
     */
    @Field(17)
    public L_Rdid nascore(Pointer<Numa> nascore) {
        this.io.setPointerField(this, 17, nascore);
        return this;
    }

    /**
     * indices of best rescored templates<br>
     * C type : Numa*
     */
    @Field(18)
    public Pointer<Numa> natempl_r() {
        return this.io.getPointerField(this, 18);
    }

    /**
     * indices of best rescored templates<br>
     * C type : Numa*
     */
    @Field(18)
    public L_Rdid natempl_r(Pointer<Numa> natempl_r) {
        this.io.setPointerField(this, 18, natempl_r);
        return this;
    }

    /**
     * x locations of best rescoredtemplates<br>
     * C type : Numa*
     */
    @Field(19)
    public Pointer<Numa> naxloc_r() {
        return this.io.getPointerField(this, 19);
    }

    /**
     * x locations of best rescoredtemplates<br>
     * C type : Numa*
     */
    @Field(19)
    public L_Rdid naxloc_r(Pointer<Numa> naxloc_r) {
        this.io.setPointerField(this, 19, naxloc_r);
        return this;
    }

    /**
     * y locations of best rescoredtemplates<br>
     * C type : Numa*
     */
    @Field(20)
    public Pointer<Numa> nadely_r() {
        return this.io.getPointerField(this, 20);
    }

    /**
     * y locations of best rescoredtemplates<br>
     * C type : Numa*
     */
    @Field(20)
    public L_Rdid nadely_r(Pointer<Numa> nadely_r) {
        this.io.setPointerField(this, 20, nadely_r);
        return this;
    }

    /**
     * widths of best rescoredtemplates<br>
     * C type : Numa*
     */
    @Field(21)
    public Pointer<Numa> nawidth_r() {
        return this.io.getPointerField(this, 21);
    }

    /**
     * widths of best rescoredtemplates<br>
     * C type : Numa*
     */
    @Field(21)
    public L_Rdid nawidth_r(Pointer<Numa> nawidth_r) {
        this.io.setPointerField(this, 21, nawidth_r);
        return this;
    }

    /**
     * correlation scores: rescored templates<br>
     * C type : Numa*
     */
    @Field(22)
    public Pointer<Numa> nascore_r() {
        return this.io.getPointerField(this, 22);
    }

    /**
     * correlation scores: rescored templates<br>
     * C type : Numa*
     */
    @Field(22)
    public L_Rdid nascore_r(Pointer<Numa> nascore_r) {
        this.io.setPointerField(this, 22, nascore_r);
        return this;
    }

    public L_Rdid() {
        super();
    }

    public L_Rdid(Pointer pointer) {
        super(pointer);
    }
}
