package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * Data returned from correlation matching on an array of characters<br>
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\recog.h:187</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class L_Rcha extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * indices of best templates<br>
     * C type : Numa*
     */
    @Field(0)
    public Pointer<Numa> naindex() {
        return this.io.getPointerField(this, 0);
    }

    /**
     * indices of best templates<br>
     * C type : Numa*
     */
    @Field(0)
    public L_Rcha naindex(Pointer<Numa> naindex) {
        this.io.setPointerField(this, 0, naindex);
        return this;
    }

    /**
     * correlation scores of best templates<br>
     * C type : Numa*
     */
    @Field(1)
    public Pointer<Numa> nascore() {
        return this.io.getPointerField(this, 1);
    }

    /**
     * correlation scores of best templates<br>
     * C type : Numa*
     */
    @Field(1)
    public L_Rcha nascore(Pointer<Numa> nascore) {
        this.io.setPointerField(this, 1, nascore);
        return this;
    }

    /**
     * character strings of best templates<br>
     * C type : Sarray*
     */
    @Field(2)
    public Pointer<Sarray> satext() {
        return this.io.getPointerField(this, 2);
    }

    /**
     * character strings of best templates<br>
     * C type : Sarray*
     */
    @Field(2)
    public L_Rcha satext(Pointer<Sarray> satext) {
        this.io.setPointerField(this, 2, satext);
        return this;
    }

    /**
     * indices of best samples<br>
     * C type : Numa*
     */
    @Field(3)
    public Pointer<Numa> nasample() {
        return this.io.getPointerField(this, 3);
    }

    /**
     * indices of best samples<br>
     * C type : Numa*
     */
    @Field(3)
    public L_Rcha nasample(Pointer<Numa> nasample) {
        this.io.setPointerField(this, 3, nasample);
        return this;
    }

    /**
     * x-locations of templates (delx + shiftx)<br>
     * C type : Numa*
     */
    @Field(4)
    public Pointer<Numa> naxloc() {
        return this.io.getPointerField(this, 4);
    }

    /**
     * x-locations of templates (delx + shiftx)<br>
     * C type : Numa*
     */
    @Field(4)
    public L_Rcha naxloc(Pointer<Numa> naxloc) {
        this.io.setPointerField(this, 4, naxloc);
        return this;
    }

    /**
     * y-locations of templates (dely + shifty)<br>
     * C type : Numa*
     */
    @Field(5)
    public Pointer<Numa> nayloc() {
        return this.io.getPointerField(this, 5);
    }

    /**
     * y-locations of templates (dely + shifty)<br>
     * C type : Numa*
     */
    @Field(5)
    public L_Rcha nayloc(Pointer<Numa> nayloc) {
        this.io.setPointerField(this, 5, nayloc);
        return this;
    }

    /**
     * widths of best templates<br>
     * C type : Numa*
     */
    @Field(6)
    public Pointer<Numa> nawidth() {
        return this.io.getPointerField(this, 6);
    }

    /**
     * widths of best templates<br>
     * C type : Numa*
     */
    @Field(6)
    public L_Rcha nawidth(Pointer<Numa> nawidth) {
        this.io.setPointerField(this, 6, nawidth);
        return this;
    }

    public L_Rcha() {
        super();
    }

    public L_Rcha(Pointer pointer) {
        super(pointer);
    }
}
