package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * Data returned from correlation matching on a single character<br>
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\recog.h:172</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class L_Rch extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * index of best template<br>
     * C type : l_int32
     */
    @Field(0)
    public int index() {
        return this.io.getIntField(this, 0);
    }

    /**
     * index of best template<br>
     * C type : l_int32
     */
    @Field(0)
    public L_Rch index(int index) {
        this.io.setIntField(this, 0, index);
        return this;
    }

    /**
     * correlation score of best template<br>
     * C type : l_float32
     */
    @Field(1)
    public float score() {
        return this.io.getFloatField(this, 1);
    }

    /**
     * correlation score of best template<br>
     * C type : l_float32
     */
    @Field(1)
    public L_Rch score(float score) {
        this.io.setFloatField(this, 1, score);
        return this;
    }

    /**
     * character string of best template<br>
     * C type : char*
     */
    @Field(2)
    public Pointer<Byte> text() {
        return this.io.getPointerField(this, 2);
    }

    /**
     * character string of best template<br>
     * C type : char*
     */
    @Field(2)
    public L_Rch text(Pointer<Byte> text) {
        this.io.setPointerField(this, 2, text);
        return this;
    }

    /**
     * index of best sample (within the best<br>
     * C type : l_int32
     */
    @Field(3)
    public int sample() {
        return this.io.getIntField(this, 3);
    }

    /**
     * index of best sample (within the best<br>
     * C type : l_int32
     */
    @Field(3)
    public L_Rch sample(int sample) {
        this.io.setIntField(this, 3, sample);
        return this;
    }

    /**
     * x-location of template (delx + shiftx)<br>
     * C type : l_int32
     */
    @Field(4)
    public int xloc() {
        return this.io.getIntField(this, 4);
    }

    /**
     * x-location of template (delx + shiftx)<br>
     * C type : l_int32
     */
    @Field(4)
    public L_Rch xloc(int xloc) {
        this.io.setIntField(this, 4, xloc);
        return this;
    }

    /**
     * y-location of template (dely + shifty)<br>
     * C type : l_int32
     */
    @Field(5)
    public int yloc() {
        return this.io.getIntField(this, 5);
    }

    /**
     * y-location of template (dely + shifty)<br>
     * C type : l_int32
     */
    @Field(5)
    public L_Rch yloc(int yloc) {
        this.io.setIntField(this, 5, yloc);
        return this;
    }

    /**
     * width of best template<br>
     * C type : l_int32
     */
    @Field(6)
    public int width() {
        return this.io.getIntField(this, 6);
    }

    /**
     * width of best template<br>
     * C type : l_int32
     */
    @Field(6)
    public L_Rch width(int width) {
        this.io.setIntField(this, 6, width);
        return this;
    }

    public L_Rch() {
        super();
    }

    public L_Rch(Pointer pointer) {
        super(pointer);
    }
}
