package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * -------------------------------------------------------------------------*<br>
 * DPix: pix with double array *<br>
 * -------------------------------------------------------------------------<br>
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\pix.h:552</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class DPix extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * width in pixels<br>
     * C type : l_int32
     */
    @Field(0)
    public int w() {
        return this.io.getIntField(this, 0);
    }

    /**
     * width in pixels<br>
     * C type : l_int32
     */
    @Field(0)
    public DPix w(int w) {
        this.io.setIntField(this, 0, w);
        return this;
    }

    /**
     * height in pixels<br>
     * C type : l_int32
     */
    @Field(1)
    public int h() {
        return this.io.getIntField(this, 1);
    }

    /**
     * height in pixels<br>
     * C type : l_int32
     */
    @Field(1)
    public DPix h(int h) {
        this.io.setIntField(this, 1, h);
        return this;
    }

    /**
     * 32-bit words/line<br>
     * C type : l_int32
     */
    @Field(2)
    public int wpl() {
        return this.io.getIntField(this, 2);
    }

    /**
     * 32-bit words/line<br>
     * C type : l_int32
     */
    @Field(2)
    public DPix wpl(int wpl) {
        this.io.setIntField(this, 2, wpl);
        return this;
    }

    /**
     * reference count (1 if no clones)<br>
     * C type : l_uint32
     */
    @Field(3)
    public int refcount() {
        return this.io.getIntField(this, 3);
    }

    /**
     * reference count (1 if no clones)<br>
     * C type : l_uint32
     */
    @Field(3)
    public DPix refcount(int refcount) {
        this.io.setIntField(this, 3, refcount);
        return this;
    }

    /**
     * image res (ppi) in x direction<br>
     * C type : l_int32
     */
    @Field(4)
    public int xres() {
        return this.io.getIntField(this, 4);
    }

    /**
     * image res (ppi) in x direction<br>
     * C type : l_int32
     */
    @Field(4)
    public DPix xres(int xres) {
        this.io.setIntField(this, 4, xres);
        return this;
    }

    /**
     * image res (ppi) in y direction<br>
     * C type : l_int32
     */
    @Field(5)
    public int yres() {
        return this.io.getIntField(this, 5);
    }

    /**
     * image res (ppi) in y direction<br>
     * C type : l_int32
     */
    @Field(5)
    public DPix yres(int yres) {
        this.io.setIntField(this, 5, yres);
        return this;
    }

    /**
     * the double image data<br>
     * C type : l_float64*
     */
    @Field(6)
    public Pointer<Double> data() {
        return this.io.getPointerField(this, 6);
    }

    /**
     * the double image data<br>
     * C type : l_float64*
     */
    @Field(6)
    public DPix data(Pointer<Double> data) {
        this.io.setPointerField(this, 6, data);
        return this;
    }

    public DPix() {
        super();
    }

    public DPix(Pointer pointer) {
        super(pointer);
    }
}
