/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.boot.secrets;

import java.util.HashMap;
import java.util.Map;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SecretPropertiesPropertySource
extends MapPropertySource {
    public static final String NAME = "secretProperties";

    public SecretPropertiesPropertySource(Map<String, Object> source) {
        super(NAME, source);
    }

    public static void merge(Map<String, Object> source, MutablePropertySources sources) {
        Assert.notNull(source, (String)"Property sources must not be null");
        Assert.notNull((Object)sources, (String)"Property sources must not be null");
        if (CollectionUtils.isEmpty(source)) {
            return;
        }
        HashMap<String, Object> resultingSource = new HashMap<String, Object>();
        SecretPropertiesPropertySource propertySource = new SecretPropertiesPropertySource(resultingSource);
        if (sources.contains(NAME)) {
            SecretPropertiesPropertySource.mergeIfPossible(source, sources, resultingSource);
            sources.replace(NAME, (PropertySource)propertySource);
        } else {
            resultingSource.putAll(source);
            sources.addAfter("systemEnvironment", (PropertySource)propertySource);
        }
    }

    private static void mergeIfPossible(Map<String, Object> source, MutablePropertySources sources, Map<String, Object> resultingSource) {
        PropertySource existingSource = sources.get(NAME);
        if (null == existingSource) {
            return;
        }
        Object underlyingSource = existingSource.getSource();
        if (underlyingSource instanceof Map) {
            resultingSource.putAll((Map)underlyingSource);
        }
        resultingSource.putAll(source);
    }
}

