/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.boot.secrets;

import de.vinado.boot.secrets.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@FunctionalInterface
public interface PropertyIndexSupplier
extends Supplier<Map<String, String>> {
    default public PropertyIndexSupplier substituteValues(PropertyResolver resolver) {
        Assert.notNull((Object)resolver, (String)"Property resolver must not be null");
        Predicate<String> wherePropertyHasText = value -> StringUtils.hasText((String)resolver.getProperty(value));
        return () -> ((Map)this.get()).entrySet().stream().filter(Utils.value(wherePropertyHasText)).collect(Collectors.toMap(Map.Entry::getKey, this.substituteValue(resolver)));
    }

    default public Function<Map.Entry<?, String>, String> substituteValue(PropertyResolver resolver) {
        Assert.notNull((Object)resolver, (String)"Property resolver must not be null");
        return this.substitute(resolver).andThen(String::trim).compose(Map.Entry::getValue);
    }

    default public UnaryOperator<String> substitute(PropertyResolver resolver) {
        Assert.notNull((Object)resolver, (String)"Property resolver must not be null");
        return arg_0 -> ((PropertyResolver)resolver).getProperty(arg_0);
    }

    public static PropertyIndexSupplier from(Map<String, String> properties) {
        Assert.notNull(properties, (String)"Properties must not be null");
        return () -> new HashMap(properties);
    }
}

