/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.model.graph;

import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.Anomaly;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.graph.Edge;
import de.viadee.bpm.vPAV.processing.model.graph.Path;
import de.viadee.bpm.vPAV.processing.model.graph.VertexInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Graph {
    private String processId;
    private LinkedHashMap<BpmnElement, List<Edge>> adjacencyListSuccessor;
    private LinkedHashMap<BpmnElement, List<Edge>> adjacencyListPredecessor;
    private LinkedHashMap<BpmnElement, VertexInfo> vertexInfo;
    private Collection<BpmnElement> startNodes = new ArrayList<BpmnElement>();
    private Collection<BpmnElement> endNodes = new ArrayList<BpmnElement>();

    public Graph(String processId) {
        this.processId = processId;
        this.adjacencyListSuccessor = new LinkedHashMap();
        this.adjacencyListPredecessor = new LinkedHashMap();
        this.vertexInfo = new LinkedHashMap();
    }

    public String getProcessId() {
        return this.processId;
    }

    public void addStartNode(BpmnElement node) {
        this.startNodes.add(node);
    }

    public Collection<BpmnElement> getStartNodes() {
        return this.startNodes;
    }

    public void addEndNode(BpmnElement node) {
        this.endNodes.add(node);
    }

    public Collection<BpmnElement> getEndNodes() {
        return this.endNodes;
    }

    public void addVertex(BpmnElement v) {
        if (v == null) {
            throw new IllegalArgumentException("null");
        }
        this.adjacencyListSuccessor.put(v, new ArrayList());
        this.adjacencyListPredecessor.put(v, new ArrayList());
        this.vertexInfo.put(v, new VertexInfo(v));
    }

    public LinkedHashMap<BpmnElement, VertexInfo> getVertexInfo() {
        return this.vertexInfo;
    }

    public Collection<BpmnElement> getVertices() {
        return this.vertexInfo.keySet();
    }

    public Collection<List<Edge>> getEdges() {
        return this.adjacencyListSuccessor.values();
    }

    public List<BpmnElement> getAdjacencyListPredecessor(BpmnElement element) {
        return this.adjacencyListPredecessor.get(element).stream().map(Edge::getTo).collect(Collectors.toList());
    }

    public List<BpmnElement> getAdjacencyListSuccessor(BpmnElement element) {
        return this.adjacencyListSuccessor.get(element).stream().map(Edge::getTo).collect(Collectors.toList());
    }

    public void addEdge(BpmnElement from, BpmnElement to, int weight) {
        List<Edge> edgeSuccessorList = this.adjacencyListSuccessor.get(from);
        if (edgeSuccessorList == null) {
            throw new IllegalArgumentException("source vertex not in graph");
        }
        Edge newSuccessorEdge = new Edge(from, to, weight);
        edgeSuccessorList.add(newSuccessorEdge);
        List<Edge> edgePredecessorList = this.adjacencyListPredecessor.get(to);
        if (edgePredecessorList == null) {
            throw new IllegalArgumentException("source vertex not in graph");
        }
        Edge newPredecessorEdge = new Edge(to, from, weight);
        edgePredecessorList.add(newPredecessorEdge);
    }

    public void removeEdge(BpmnElement from, BpmnElement to) {
        List<Edge> edgeSuccessorList = this.adjacencyListSuccessor.get(from);
        Edge foundEdge = null;
        for (Edge e : edgeSuccessorList) {
            if (!e.getFrom().toString().equals(from.toString()) || !e.getTo().toString().equals(to.toString())) continue;
            foundEdge = e;
        }
        edgeSuccessorList.remove(foundEdge);
        List<Edge> edgePredecessorList = this.adjacencyListPredecessor.get(to);
        foundEdge = null;
        for (Edge e : edgePredecessorList) {
            if (!e.getTo().toString().equals(from.toString()) || !e.getFrom().toString().equals(to.toString())) continue;
            foundEdge = e;
        }
        edgePredecessorList.remove(foundEdge);
    }

    public boolean hasEdge(BpmnElement from, BpmnElement to) {
        return this.getEdge(from, to) != null;
    }

    public Edge getEdge(BpmnElement from, BpmnElement to) {
        List<Edge> edgeList = this.adjacencyListSuccessor.get(from);
        if (edgeList == null) {
            throw new IllegalArgumentException("source vertex not in graph");
        }
        for (Edge e : edgeList) {
            if (!e.getTo().equals(to)) continue;
            return e;
        }
        return null;
    }

    public Map<BpmnElement, List<AnomalyContainer>> getNodesWithAnomalies() {
        HashMap<BpmnElement, List<AnomalyContainer>> anomalies = new HashMap<BpmnElement, List<AnomalyContainer>>();
        this.adjacencyListPredecessor.keySet().forEach(bpmnElement -> {
            if (!bpmnElement.getAnomalies().isEmpty()) {
                anomalies.putAll(bpmnElement.getAnomalies());
            }
        });
        return anomalies;
    }

    public List<Path> getAllInvalidPaths(BpmnElement source, AnomalyContainer anomaly) {
        return this.getAllInvalidPathsRecursive(source, anomaly, new LinkedList<BpmnElement>());
    }

    private List<Path> getAllInvalidPathsRecursive(BpmnElement startNode, AnomalyContainer anomaly, LinkedList<BpmnElement> currentPath) {
        ArrayList<Path> invalidPaths = new ArrayList<Path>();
        currentPath.add(startNode);
        List<Edge> edges = this.adjacencyListPredecessor.get(startNode);
        List<Path> returnPathsUrAnomaly = this.exitConditionUrAnomaly(startNode, anomaly, currentPath, invalidPaths);
        List<Path> returnPathsDdDuAnomaly = this.exitConditionDdDuAnomaly(startNode, anomaly, currentPath, invalidPaths);
        if (returnPathsUrAnomaly != null) {
            return returnPathsUrAnomaly;
        }
        if (returnPathsDdDuAnomaly != null) {
            return returnPathsDdDuAnomaly;
        }
        for (Edge t : edges) {
            if (currentPath.contains(t.getTo()) && t.getTo() != anomaly.getVariable().getElement()) continue;
            invalidPaths.addAll(this.getAllInvalidPathsRecursive(t.getTo(), anomaly, currentPath));
        }
        currentPath.remove(startNode);
        return invalidPaths;
    }

    private List<Path> exitConditionUrAnomaly(BpmnElement startNode, AnomalyContainer anomaly, LinkedList<BpmnElement> currentPath, List<Path> invalidPaths) {
        if (anomaly.getAnomaly() == Anomaly.UR || startNode.getBaseElement().getElementType().getTypeName().equals("startEvent") && startNode.getBaseElement().getParentElement().getElementType().getTypeName().equals("process")) {
            ArrayList<BpmnElement> newPath = new ArrayList<BpmnElement>(currentPath);
            invalidPaths.add(new Path(newPath));
            currentPath.remove(startNode);
            return invalidPaths;
        }
        return null;
    }

    private List<Path> exitConditionDdDuAnomaly(BpmnElement startNode, AnomalyContainer anomaly, LinkedList<BpmnElement> currentPath, List<Path> invalidPaths) {
        if ((anomaly.getAnomaly() == Anomaly.DD || anomaly.getAnomaly() == Anomaly.DU) && currentPath.size() > 1 && this.containsAnomaly(startNode, anomaly)) {
            ArrayList<BpmnElement> newPath = new ArrayList<BpmnElement>(currentPath);
            invalidPaths.add(new Path(newPath));
            currentPath.remove(startNode);
            return invalidPaths;
        }
        return null;
    }

    private boolean containsAnomaly(BpmnElement bpmnElement, AnomalyContainer anomaly) {
        boolean containsAnomaly = false;
        for (ProcessVariableOperation processVariableOperation : bpmnElement.getDefined().values()) {
            if (!processVariableOperation.getName().equals(anomaly.getName())) continue;
            containsAnomaly = true;
        }
        return containsAnomaly;
    }

    public String toString() {
        Set<BpmnElement> keys = this.adjacencyListSuccessor.keySet();
        StringBuilder str = new StringBuilder("digraph G {\n");
        for (BpmnElement v : keys) {
            str.append(" ");
            List<Edge> edgeList = this.adjacencyListSuccessor.get(v);
            for (Edge edge : edgeList) {
                str.append(edge);
                str.append("\n");
            }
        }
        str.append("}");
        return str.toString();
    }
}

