/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.model.data;

import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.model.data.CheckerIssue;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import de.viadee.bpm.vPAV.processing.model.data.KnownElementFieldType;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;

public class ProcessVariableOperation {
    private String id;
    private String name;
    private VariableOperation operation;
    private String scopeId;
    private BpmnElement element;
    private String resourceFilePath;
    private ElementChapter chapter;
    private KnownElementFieldType fieldType;
    private int index;
    private boolean operationType;
    private int flowOperationIndex;

    public ProcessVariableOperation(String name, ElementChapter chapter, KnownElementFieldType fieldType, VariableOperation operation, String scopeId) {
        this.name = name;
        this.chapter = chapter;
        this.fieldType = fieldType;
        this.operation = operation;
        this.scopeId = scopeId;
        this.id = this.createId();
    }

    public ProcessVariableOperation(String name, BpmnElement element, ElementChapter chapter, KnownElementFieldType fieldType, String resourceFilePath, VariableOperation operation, String scopeId, int index) {
        this.name = name;
        this.element = element;
        this.resourceFilePath = resourceFilePath;
        this.chapter = chapter;
        this.fieldType = fieldType;
        this.operation = operation;
        this.scopeId = scopeId;
        this.index = index;
        this.id = this.createId();
        element.getFlowAnalysis().incrementOperationCounter();
        this.flowOperationIndex = element.getFlowAnalysis().getOperationCounter();
    }

    private String createId() {
        return CheckerIssue.getMD5(this.name + "_" + (Object)((Object)this.chapter) + "_" + (Object)((Object)this.fieldType) + "_" + this.resourceFilePath + "_" + (Object)((Object)this.operation) + "_" + this.scopeId + "_" + System.nanoTime());
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getResourceFilePath() {
        return this.resourceFilePath;
    }

    public BpmnElement getElement() {
        return this.element;
    }

    public ElementChapter getChapter() {
        return this.chapter;
    }

    public KnownElementFieldType getFieldType() {
        return this.fieldType;
    }

    public VariableOperation getOperation() {
        return this.operation;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public void setOperationType(boolean type) {
        this.operationType = type;
    }

    public boolean getOperationType() {
        return this.operationType;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.name + " [" + this.element.getProcessDefinition() + ", " + this.element.getBaseElement().getId() + ", Scope: " + this.scopeId + ", " + this.chapter.name() + ", " + this.fieldType.getDescription() + ", " + this.resourceFilePath + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof ProcessVariableOperation) {
            ProcessVariableOperation p = (ProcessVariableOperation)o;
            return this.name.equals(p.getName());
        }
        return false;
    }

    public int getFlowOperationIndex() {
        return this.flowOperationIndex;
    }

    public void initializeOperation(BpmnElement element) {
        this.element = element;
        element.getFlowAnalysis().incrementOperationCounter();
        this.flowOperationIndex = element.getFlowAnalysis().getOperationCounter();
    }
}

