/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.dataflow;

import de.viadee.bpm.vPAV.processing.dataflow.DescribedPredicateEvaluator;
import de.viadee.bpm.vPAV.processing.dataflow.EvaluationResult;
import de.viadee.bpm.vPAV.processing.dataflow.OperationBasedPredicateBuilder;
import de.viadee.bpm.vPAV.processing.dataflow.OperationBasedPredicateBuilderImpl;
import de.viadee.bpm.vPAV.processing.dataflow.ProcessVariablePredicateBuilder;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import java.util.function.Function;

class ProcessVariablePredicateBuilderImpl<T>
implements ProcessVariablePredicateBuilder<T> {
    private final Function<DescribedPredicateEvaluator<ProcessVariable>, T> constraintSetter;

    ProcessVariablePredicateBuilderImpl(Function<DescribedPredicateEvaluator<ProcessVariable>, T> constraintSetter) {
        this.constraintSetter = constraintSetter;
    }

    @Override
    public ProcessVariablePredicateBuilder<T> not() {
        return new ProcessVariablePredicateBuilderImpl<Object>(predicate -> this.constraintSetter.apply(predicate.inverse()));
    }

    @Override
    public OperationBasedPredicateBuilder<T> deleted() {
        return new OperationBasedPredicateBuilderImpl<T>(this.constraintSetter, ProcessVariable::getDeletes, "deleted");
    }

    @Override
    public OperationBasedPredicateBuilder<T> read() {
        return new OperationBasedPredicateBuilderImpl<T>(this.constraintSetter, ProcessVariable::getReads, "read");
    }

    @Override
    public OperationBasedPredicateBuilder<T> written() {
        return new OperationBasedPredicateBuilderImpl<T>(this.constraintSetter, ProcessVariable::getWrites, "written");
    }

    @Override
    public OperationBasedPredicateBuilder<T> accessed() {
        return new OperationBasedPredicateBuilderImpl<T>(this.constraintSetter, ProcessVariable::getOperations, "accessed");
    }

    @Override
    public T prefixed(String prefix) {
        Function<ProcessVariable, EvaluationResult> evaluator = p -> new EvaluationResult<ProcessVariable>(p.getName().startsWith(prefix), (ProcessVariable)p);
        String description = String.format("prefixed with '%s'", prefix);
        return this.constraintSetter.apply(new DescribedPredicateEvaluator<ProcessVariable>(evaluator, description));
    }

    @Override
    public T postfixed(String postfix) {
        Function<ProcessVariable, EvaluationResult> evaluator = p -> new EvaluationResult<ProcessVariable>(p.getName().endsWith(postfix), (ProcessVariable)p);
        String description = String.format("postfixed with '%s'", postfix);
        return this.constraintSetter.apply(new DescribedPredicateEvaluator<ProcessVariable>(evaluator, description));
    }

    @Override
    public T matching(String regex) {
        Function<ProcessVariable, EvaluationResult> evaluator = p -> new EvaluationResult<ProcessVariable>(p.getName().matches(regex), (ProcessVariable)p);
        String description = String.format("matching with '%s'", regex);
        return this.constraintSetter.apply(new DescribedPredicateEvaluator<ProcessVariable>(evaluator, description));
    }
}

