/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.dataflow;

import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.dataflow.DescribedPredicateEvaluator;
import de.viadee.bpm.vPAV.processing.dataflow.ElementBasedPredicateBuilder;
import de.viadee.bpm.vPAV.processing.dataflow.ElementBasedPredicateBuilderImpl;
import de.viadee.bpm.vPAV.processing.dataflow.EvaluationResult;
import de.viadee.bpm.vPAV.processing.dataflow.OperationBasedPredicateBuilder;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

class OperationBasedPredicateBuilderImpl<T>
implements OperationBasedPredicateBuilder<T> {
    private final Function<DescribedPredicateEvaluator<ProcessVariable>, T> conditionSetter;
    private final Function<ProcessVariable, List<ProcessVariableOperation>> operationProvider;
    private final String operationDescription;

    OperationBasedPredicateBuilderImpl(Function<DescribedPredicateEvaluator<ProcessVariable>, T> conditionSetter, Function<ProcessVariable, List<ProcessVariableOperation>> operationProvider, String operationDescription) {
        this.conditionSetter = conditionSetter;
        this.operationProvider = operationProvider;
        this.operationDescription = operationDescription;
    }

    @Override
    public T exactly(int n) {
        String times = n == 1 ? "time" : "times";
        Function<ProcessVariable, EvaluationResult> evaluator = p -> {
            Integer operationsCount = this.operationProvider.apply((ProcessVariable)p).size();
            return new EvaluationResult<ProcessVariable>(operationsCount == n, (ProcessVariable)p, operationsCount.toString());
        };
        String description = String.format("%s exactly %s %s", this.operationDescription, n, times);
        return this.conditionSetter.apply(new DescribedPredicateEvaluator<ProcessVariable>(evaluator, description));
    }

    @Override
    public T atLeast(int n) {
        String times = n == 1 ? "time" : "times";
        Function<ProcessVariable, EvaluationResult> evaluator = p -> {
            Integer operationsCount = this.operationProvider.apply((ProcessVariable)p).size();
            return new EvaluationResult<ProcessVariable>(operationsCount >= n, (ProcessVariable)p, operationsCount.toString());
        };
        String description = String.format("%s at least %s %s", this.operationDescription, n, times);
        return this.conditionSetter.apply(new DescribedPredicateEvaluator<ProcessVariable>(evaluator, description));
    }

    @Override
    public T atMost(int n) {
        String times = n == 1 ? "time" : "times";
        Function<ProcessVariable, EvaluationResult> evaluator = p -> {
            Integer operationsCount = this.operationProvider.apply((ProcessVariable)p).size();
            return new EvaluationResult<ProcessVariable>(operationsCount <= n, (ProcessVariable)p, operationsCount.toString());
        };
        String description = String.format("%s at most %s %s", this.operationDescription, n, times);
        return this.conditionSetter.apply(new DescribedPredicateEvaluator<ProcessVariable>(evaluator, description));
    }

    @Override
    public ElementBasedPredicateBuilder<T> byModelElements() {
        Function<ProcessVariable, List<BpmnElement>> elementProvider = this.createElementProvider();
        return new ElementBasedPredicateBuilderImpl<T>(this.conditionSetter, elementProvider, false, this.operationDescription + " by model elements");
    }

    @Override
    public ElementBasedPredicateBuilder<T> onlyByModelElements() {
        Function<ProcessVariable, List<BpmnElement>> elementProvider = this.createElementProvider();
        return new ElementBasedPredicateBuilderImpl<T>(this.conditionSetter, elementProvider, true, this.operationDescription + " by model elements");
    }

    private Function<ProcessVariable, List<BpmnElement>> createElementProvider() {
        return p -> this.operationProvider.apply((ProcessVariable)p).stream().map(ProcessVariableOperation::getElement).collect(Collectors.toList());
    }
}

