/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.dataflow;

import java.util.Optional;

public class EvaluationResult<T> {
    private String message;
    private boolean result;
    private T evaluatedVariable;

    static <T> EvaluationResult<T> forViolation(String message, T evaluatedVariable) {
        return new EvaluationResult<T>(false, evaluatedVariable, message.isEmpty() ? null : message);
    }

    static <T> EvaluationResult<T> forViolation(T evaluatedVariable) {
        return new EvaluationResult<T>(false, evaluatedVariable, null);
    }

    static <T> EvaluationResult<T> forSuccess(T evaluatedVariable) {
        return new EvaluationResult<T>(true, evaluatedVariable);
    }

    static <T> EvaluationResult<T> forSuccess(String message, T evaluatedVariable) {
        return new EvaluationResult<T>(true, evaluatedVariable, message.isEmpty() ? null : message);
    }

    public EvaluationResult(boolean result, T evaluatedVariable, String message) {
        this.message = message;
        this.result = result;
        this.evaluatedVariable = evaluatedVariable;
    }

    public EvaluationResult(boolean result, T evaluatedVariable) {
        this.result = result;
        this.evaluatedVariable = evaluatedVariable;
    }

    public boolean isFulfilled() {
        return this.result;
    }

    public T getEvaluatedVariable() {
        return this.evaluatedVariable;
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public EvaluationResult<T> inverse() {
        return new EvaluationResult<T>(!this.result, this.evaluatedVariable, this.message);
    }
}

