/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.dataflow;

import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.dataflow.DescribedPredicateEvaluator;
import de.viadee.bpm.vPAV.processing.dataflow.ElementBasedPredicateBuilder;
import de.viadee.bpm.vPAV.processing.dataflow.EvaluationResult;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariable;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.camunda.bpm.model.bpmn.Query;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperties;

public class ElementBasedPredicateBuilderImpl<T>
implements ElementBasedPredicateBuilder<T> {
    private final Function<DescribedPredicateEvaluator<ProcessVariable>, T> conditionSetter;
    private final Function<ProcessVariable, List<BpmnElement>> elementProvider;
    private final String elementDescription;
    private boolean onlyFlag = false;

    public ElementBasedPredicateBuilderImpl(Function<DescribedPredicateEvaluator<ProcessVariable>, T> conditionSetter, Function<ProcessVariable, List<BpmnElement>> elementProvider, boolean onlyFlag, String elementDescription) {
        this.conditionSetter = conditionSetter;
        this.elementProvider = elementProvider;
        this.onlyFlag = onlyFlag;
        this.elementDescription = elementDescription;
    }

    @Override
    public T ofType(Class<?> clazz) {
        Function<BpmnElement, EvaluationResult> evaluator = element -> new EvaluationResult<BpmnElement>(clazz.isInstance(element.getBaseElement()), (BpmnElement)element, element.getBaseElement().getClass().getSimpleName());
        String description = String.format("of type '%s'", clazz.getSimpleName());
        return this.thatFulfill(new DescribedPredicateEvaluator<BpmnElement>(evaluator, description));
    }

    @Override
    public T withProperty(String propertyName) {
        Function<BpmnElement, EvaluationResult> evaluator = element -> {
            boolean hasProperty = this.hasProperty(propertyName, (BpmnElement)element);
            String elementName = element.getBaseElement().getAttributeValue("name");
            return new EvaluationResult<BpmnElement>(hasProperty, (BpmnElement)element, hasProperty ? "present at '" + elementName + "'" : "not present at '" + elementName + "'");
        };
        String description = String.format("with property '%s'", propertyName);
        return this.thatFulfill(new DescribedPredicateEvaluator<BpmnElement>(evaluator, description));
    }

    @Override
    public T withPrefix(String prefix) {
        Function<BpmnElement, EvaluationResult> evaluator = element -> {
            String elementName = element.getBaseElement().getAttributeValue("name");
            return new EvaluationResult<BpmnElement>(elementName.startsWith(prefix), (BpmnElement)element, elementName);
        };
        String description = String.format("with prefix '%s'", prefix);
        return this.thatFulfill(new DescribedPredicateEvaluator<BpmnElement>(evaluator, description));
    }

    @Override
    public T withPostfix(String postfix) {
        Function<BpmnElement, EvaluationResult> evaluator = element -> {
            String elementName = element.getBaseElement().getAttributeValue("name");
            return new EvaluationResult<BpmnElement>(elementName.endsWith(postfix), (BpmnElement)element, elementName);
        };
        String description = String.format("with postfix '%s'", postfix);
        return this.thatFulfill(new DescribedPredicateEvaluator<BpmnElement>(evaluator, description));
    }

    @Override
    public T withNameMatching(String regex) {
        Function<BpmnElement, EvaluationResult> evaluator = element -> {
            String elementName = element.getBaseElement().getAttributeValue("name");
            return new EvaluationResult<BpmnElement>(Pattern.matches(regex, elementName), (BpmnElement)element, elementName);
        };
        String description = String.format("with name matching '%s'", regex);
        return this.thatFulfill(new DescribedPredicateEvaluator<BpmnElement>(evaluator, description));
    }

    @Override
    public T thatFulfill(DescribedPredicateEvaluator<BpmnElement> predicate) {
        Function<ProcessVariable, EvaluationResult> evaluator = p -> {
            List<EvaluationResult<BpmnElement>> results = this.elementProvider.apply((ProcessVariable)p).stream().map(predicate::evaluate).collect(Collectors.toList());
            return this.isSuccess(results) ? EvaluationResult.forSuccess(results.stream().filter(EvaluationResult::isFulfilled).filter(r -> r.getMessage().isPresent()).map(r -> r.getMessage().get()).collect(Collectors.joining(", ")), p) : EvaluationResult.forViolation(results.stream().filter(r -> !r.isFulfilled()).filter(r -> r.getMessage().isPresent()).map(r -> r.getMessage().get()).collect(Collectors.joining(", ")), p);
        };
        String description = String.format("%s %s", this.elementDescription, predicate.getDescription());
        return this.conditionSetter.apply(new DescribedPredicateEvaluator<ProcessVariable>(evaluator, description));
    }

    private boolean isSuccess(List<EvaluationResult<BpmnElement>> results) {
        int numberOfSuccesses = results.stream().filter(EvaluationResult::isFulfilled).collect(Collectors.toList()).size();
        return this.onlyFlag ? numberOfSuccesses == results.size() : numberOfSuccesses > 0;
    }

    private boolean hasProperty(String propertyName, BpmnElement element) {
        ExtensionElements elements = element.getBaseElement().getExtensionElements();
        if (elements == null) {
            return false;
        }
        Query query = elements.getElementsQuery().filterByType(CamundaProperties.class);
        if (query.count() == 0) {
            return false;
        }
        Collection properties = ((CamundaProperties)query.singleResult()).getCamundaProperties();
        return properties.stream().anyMatch(p -> p.getCamundaName() != null && p.getCamundaName().equals(propertyName));
    }
}

