/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.dataflow;

import de.viadee.bpm.vPAV.processing.dataflow.EvaluationResult;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DescribedPredicateEvaluator<T> {
    private final Function<T, EvaluationResult<T>> predicateEvaluator;
    private final String description;

    public DescribedPredicateEvaluator(Function<T, EvaluationResult<T>> predicateEvaluator, String description) {
        this.predicateEvaluator = predicateEvaluator;
        this.description = description;
    }

    public EvaluationResult<T> evaluate(T value) {
        return this.predicateEvaluator.apply(value);
    }

    public String getDescription() {
        return this.description;
    }

    public DescribedPredicateEvaluator<T> or(DescribedPredicateEvaluator<T> other) {
        Function<Object, EvaluationResult> orPredicateEvaluator = T -> {
            EvaluationResult<Object> result1 = this.evaluate(T);
            EvaluationResult<Object> result2 = other.evaluate(T);
            boolean isCombinedViolation = !result1.isFulfilled() && !result2.isFulfilled();
            return this.createEvaluationResult(result1, result2, isCombinedViolation);
        };
        return new DescribedPredicateEvaluator<Object>(orPredicateEvaluator, this.description + " or " + other.description);
    }

    public DescribedPredicateEvaluator<T> and(DescribedPredicateEvaluator<T> other) {
        Function<Object, EvaluationResult> andPredicateEvaluator = T -> {
            EvaluationResult<Object> result1 = this.evaluate(T);
            EvaluationResult<Object> result2 = other.evaluate(T);
            boolean isCombinedViolation = !result1.isFulfilled() || !result2.isFulfilled();
            return this.createEvaluationResult(result1, result2, isCombinedViolation);
        };
        return new DescribedPredicateEvaluator<Object>(andPredicateEvaluator, this.description + " and " + other.description);
    }

    public DescribedPredicateEvaluator<T> inverse() {
        return new DescribedPredicateEvaluator<Object>(T -> this.predicateEvaluator.apply(T).inverse(), "not " + this.description);
    }

    private EvaluationResult<T> createEvaluationResult(EvaluationResult<T> result1, EvaluationResult<T> result2, boolean isCombinedViolation) {
        if (isCombinedViolation) {
            String violationMessage = Stream.of(result1, result2).filter(r -> !r.isFulfilled()).filter(r -> r.getMessage().isPresent()).map(r -> r.getMessage().get()).collect(Collectors.joining(" and "));
            return EvaluationResult.forViolation(violationMessage, result1.getEvaluatedVariable());
        }
        String successMessage = Stream.of(result1, result2).filter(EvaluationResult::isFulfilled).filter(r -> r.getMessage().isPresent()).map(r -> r.getMessage().get()).collect(Collectors.joining(" and "));
        return EvaluationResult.forSuccess(successMessage, result1.getEvaluatedVariable());
    }
}

