/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.code.flow;

import de.viadee.bpm.vPAV.processing.code.flow.AbstractNode;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.code.flow.ControlFlowGraph;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soot.toolkits.graph.Block;

public class Node
extends AbstractNode
implements Cloneable {
    private Block block;

    public Node(ControlFlowGraph controlFlowGraph, BpmnElement parentElement, Block block, ElementChapter elementChapter) {
        super(controlFlowGraph, parentElement, elementChapter);
        this.block = block;
    }

    @Override
    public void setPreds() {
        Pattern blockPattern = Pattern.compile("(Block\\s#)(\\d)");
        Pattern idPattern = Pattern.compile(this.getParentElement().getBaseElement().getId() + "__(\\d\\.)*(\\d)");
        for (Block block : this.block.getPreds()) {
            Matcher blockMatcher = blockPattern.matcher(block.toShortString());
            this.createIds(idPattern, blockMatcher, true);
        }
    }

    @Override
    public void setSuccs() {
        Pattern blockPattern = Pattern.compile("(Block\\s#)(\\d)");
        Pattern idPattern = Pattern.compile(this.getParentElement().getBaseElement().getId() + "__(\\d\\.)*(\\d)");
        for (Block block : this.block.getSuccs()) {
            Matcher blockMatcher = blockPattern.matcher(block.toShortString());
            this.createIds(idPattern, blockMatcher, false);
        }
    }

    public Block getBlock() {
        return this.block;
    }

    public Object clone() throws CloneNotSupportedException {
        Node myClone = (Node)super.clone();
        myClone.block = this.block;
        myClone.controlFlowGraph = this.controlFlowGraph;
        myClone.parentElement = this.parentElement;
        myClone.elementChapter = this.elementChapter;
        myClone.operations = new LinkedHashMap();
        myClone.defined = new LinkedHashMap();
        myClone.used = new LinkedHashMap();
        myClone.outUnused = new LinkedHashMap();
        myClone.outUsed = new LinkedHashMap();
        myClone.inUnused = new LinkedHashMap();
        myClone.inUsed = new LinkedHashMap();
        myClone.predecessors = new LinkedHashMap();
        myClone.successors = new LinkedHashMap();
        return myClone;
    }
}

