/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.bpm.vPAV.processing.code.flow;

import de.viadee.bpm.vPAV.processing.code.flow.AbstractNode;
import de.viadee.bpm.vPAV.processing.code.flow.AnalysisElement;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElement;
import de.viadee.bpm.vPAV.processing.code.flow.BpmnElementDecorator;
import de.viadee.bpm.vPAV.processing.code.flow.Node;
import de.viadee.bpm.vPAV.processing.code.flow.NodeDecorator;
import de.viadee.bpm.vPAV.processing.model.data.Anomaly;
import de.viadee.bpm.vPAV.processing.model.data.AnomalyContainer;
import de.viadee.bpm.vPAV.processing.model.data.ElementChapter;
import de.viadee.bpm.vPAV.processing.model.data.KnownElementFieldType;
import de.viadee.bpm.vPAV.processing.model.data.ProcessVariableOperation;
import de.viadee.bpm.vPAV.processing.model.data.VariableOperation;
import de.viadee.bpm.vPAV.processing.model.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.camunda.bpm.model.bpmn.instance.CallActivity;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.StartEvent;

public class FlowAnalysis {
    public static final Logger LOGGER = Logger.getLogger(FlowAnalysis.class.getName());
    private LinkedHashMap<String, AnalysisElement> nodes = new LinkedHashMap();
    private LinkedHashMap<String, ProcessVariableOperation> scopedOperations = new LinkedHashMap();
    private int operationCounter = 0;

    public void analyze(Collection<Graph> graphCollection) {
        for (Graph graph : graphCollection) {
            this.embedControlFlowGraph(graph);
            this.computeReachingDefinitions();
            this.computeLineByLine();
            this.extractAnomalies();
        }
    }

    private void embedControlFlowGraph(Graph graph) {
        graph.getVertexInfo().keySet().forEach(element -> {
            BpmnElementDecorator analysisElement = new BpmnElementDecorator((AnalysisElement)element);
            analysisElement.clearPredecessors();
            graph.getAdjacencyListPredecessor((BpmnElement)element).forEach(value -> analysisElement.addPredecessor(new BpmnElementDecorator((AnalysisElement)value)));
            graph.getAdjacencyListSuccessor((BpmnElement)element).forEach(value -> analysisElement.addSuccessor(new BpmnElementDecorator((AnalysisElement)value)));
            this.nodes.put(analysisElement.getId(), analysisElement);
        });
        LinkedHashMap<String, AnalysisElement> temp = new LinkedHashMap<String, AnalysisElement>(this.nodes);
        LinkedHashMap cfgNodes = new LinkedHashMap();
        ArrayList<String> ids = new ArrayList<String>();
        temp.values().forEach(analysisElement -> {
            boolean hasNodesBefore;
            boolean bl = hasNodesBefore = !(analysisElement.getBaseElement() instanceof CallActivity);
            if (analysisElement.getControlFlowGraph().hasNodes()) {
                analysisElement.getControlFlowGraph().computePredecessorRelations();
                AbstractNode firstNode = analysisElement.getControlFlowGraph().firstNode();
                AbstractNode lastNode = analysisElement.getControlFlowGraph().lastNode();
                boolean hasNodesAfter = false;
                if (analysisElement.getBaseElement() instanceof CallActivity) {
                    Object lastNodeBefore = null;
                    AbstractNode firstNodeAfter = null;
                    AbstractNode predecessor = null;
                    ElementChapter chapter = firstNode.getElementChapter();
                    boolean isFirstHalf = !chapter.equals((Object)ElementChapter.OutputImplementation) && !chapter.equals((Object)ElementChapter.ExecutionListenerEnd);
                    for (AbstractNode curNode : analysisElement.getControlFlowGraph().getNodes().values()) {
                        if (predecessor != null) {
                            chapter = curNode.getElementChapter();
                            if (chapter.equals((Object)ElementChapter.OutputImplementation) || chapter.equals((Object)ElementChapter.ExecutionListenerEnd) && isFirstHalf) {
                                isFirstHalf = false;
                                lastNodeBefore = predecessor;
                                firstNodeAfter = curNode;
                            } else {
                                curNode.clearPredecessors();
                                predecessor.clearSuccessors();
                                curNode.addPredecessor(predecessor);
                                predecessor.addSuccessor(curNode);
                            }
                        }
                        predecessor = curNode;
                    }
                    hasNodesBefore = isFirstHalf || lastNodeBefore != null;
                    boolean bl2 = hasNodesAfter = !isFirstHalf;
                    if (hasNodesBefore && !hasNodesAfter) {
                        lastNodeBefore = lastNode;
                    }
                    if (!hasNodesBefore && hasNodesAfter) {
                        firstNodeAfter = firstNode;
                    }
                    for (AnalysisElement succ2 : analysisElement.getSuccessors()) {
                        if (succ2.getBaseElement() instanceof StartEvent) {
                            if (hasNodesBefore) {
                                succ2.clearPredecessors();
                                succ2.addPredecessor(new NodeDecorator((AnalysisElement)lastNodeBefore));
                                lastNodeBefore.clearSuccessors();
                                lastNodeBefore.addSuccessor(succ2);
                                firstNode.clearPredecessors();
                                for (AnalysisElement preds2 : analysisElement.getPredecessors()) {
                                    preds2.removeSuccessor(analysisElement.getId());
                                    preds2.addSuccessor(new NodeDecorator(firstNode));
                                    firstNode.addPredecessor(preds2);
                                }
                                continue;
                            }
                            succ2.clearPredecessors();
                            analysisElement.getPredecessors().forEach(preds -> {
                                preds.removeSuccessor(analysisElement.getId());
                                preds.addSuccessor(succ2);
                                succ2.addPredecessor((AnalysisElement)preds);
                            });
                            continue;
                        }
                        if (!(succ2.getBaseElement() instanceof SequenceFlow)) continue;
                        AnalysisElement endEvent = succ2;
                        for (AnalysisElement nestedPreds : succ2.getPredecessors()) {
                            if (!(nestedPreds.getBaseElement() instanceof EndEvent)) continue;
                            endEvent = nestedPreds;
                        }
                        if (endEvent.equals(succ2)) {
                            LOGGER.severe("End event in child process was not found.");
                        }
                        for (ProcessVariableOperation operation2 : analysisElement.getOperations().values()) {
                            if (!operation2.getFieldType().equals((Object)KnownElementFieldType.CamundaOut)) continue;
                            if (operation2.getOperation().equals((Object)VariableOperation.READ)) {
                                endEvent.getOperations().put(operation2.getId(), operation2);
                                continue;
                            }
                            endEvent.getDefined().put(operation2.getId(), operation2);
                        }
                        succ2.clearPredecessors();
                        endEvent.clearSuccessors();
                        if (hasNodesAfter) {
                            endEvent.addSuccessor(new NodeDecorator(firstNodeAfter));
                            firstNodeAfter.addPredecessor(endEvent);
                            succ2.addPredecessor(new NodeDecorator(lastNode));
                            lastNode.addSuccessor(succ2);
                            continue;
                        }
                        succ2.addPredecessor(endEvent);
                        endEvent.addSuccessor(succ2);
                    }
                } else {
                    for (AnalysisElement pred : analysisElement.getPredecessors()) {
                        pred.removeSuccessor(analysisElement.getId());
                        pred.addSuccessor(new NodeDecorator(firstNode));
                        firstNode.addPredecessor(pred);
                    }
                    for (AnalysisElement succ3 : analysisElement.getSuccessors()) {
                        succ3.removePredecessor(analysisElement.getId());
                        succ3.addPredecessor(new NodeDecorator(lastNode));
                    }
                }
                boolean del = analysisElement.getControlFlowGraph().hasImplementedDelegate();
                Iterator<AbstractNode> iterator = analysisElement.getControlFlowGraph().getNodes().values().iterator();
                AbstractNode prevNode = null;
                while (iterator.hasNext()) {
                    AbstractNode currNode = iterator.next();
                    if (prevNode == null) {
                        prevNode = currNode;
                        continue;
                    }
                    if (currNode.getElementChapter().equals((Object)ElementChapter.ExecutionListenerEnd) && prevNode.getElementChapter().equals((Object)ElementChapter.ExecutionListenerStart)) {
                        if (!del) continue;
                        prevNode = currNode;
                        continue;
                    }
                    currNode.setPredsInterProcedural(prevNode.getId());
                    prevNode = currNode;
                }
                LinkedHashMap<String, ProcessVariableOperation> inputVariables = new LinkedHashMap<String, ProcessVariableOperation>();
                LinkedHashMap<String, ProcessVariableOperation> outputVariables = new LinkedHashMap<String, ProcessVariableOperation>();
                LinkedHashMap<String, ProcessVariableOperation> initialVariables = new LinkedHashMap<String, ProcessVariableOperation>();
                analysisElement.getOperations().values().forEach(operation -> {
                    if (operation.getFieldType().equals((Object)KnownElementFieldType.InputParameter)) {
                        inputVariables.put(operation.getId(), (ProcessVariableOperation)operation);
                    } else if (operation.getFieldType().equals((Object)KnownElementFieldType.OutputParameter)) {
                        outputVariables.put(operation.getId(), (ProcessVariableOperation)operation);
                    } else if (operation.getFieldType().equals((Object)KnownElementFieldType.Initial)) {
                        initialVariables.put(operation.getId(), (ProcessVariableOperation)operation);
                    }
                });
                if (!(analysisElement.getBaseElement() instanceof CallActivity) || hasNodesBefore) {
                    firstNode.addDefined(inputVariables);
                }
                if (analysisElement.getBaseElement() instanceof CallActivity && !hasNodesAfter) {
                    lastNode.getSuccessors().forEach(element -> element.setDefined(outputVariables));
                } else {
                    lastNode.addDefined(outputVariables);
                }
                if (!initialVariables.isEmpty() && hasNodesBefore) {
                    firstNode.addDefined(initialVariables);
                }
                analysisElement.getControlFlowGraph().getNodes().values().forEach(node -> {
                    AnalysisElement cfr_ignored_0 = cfgNodes.put(node.getId(), node);
                });
                ids.add(firstNode.getParentElement().getBaseElement().getId());
            } else {
                if (analysisElement.getBaseElement() instanceof CallActivity) {
                    analysisElement.getSuccessors().forEach(succ -> {
                        if (succ.getBaseElement() instanceof StartEvent) {
                            succ.clearPredecessors();
                            LinkedHashMap<String, AnalysisElement> preds = new LinkedHashMap<String, AnalysisElement>(analysisElement.getPredecessors().stream().collect(Collectors.toMap(AnalysisElement::getId, Function.identity())));
                            succ.setPredecessors(preds);
                        } else if (succ.getBaseElement() instanceof SequenceFlow) {
                            AnalysisElement endEvent = null;
                            for (AnalysisElement nestedPred : succ.getPredecessors()) {
                                if (!(nestedPred.getBaseElement() instanceof EndEvent)) continue;
                                endEvent = nestedPred;
                            }
                            LinkedHashMap<String, ProcessVariableOperation> camundaOutput = new LinkedHashMap<String, ProcessVariableOperation>();
                            for (ProcessVariableOperation operation : analysisElement.getOperations().values()) {
                                if (endEvent != null && operation.getFieldType().equals((Object)KnownElementFieldType.CamundaOut)) {
                                    if (operation.getOperation().equals((Object)VariableOperation.READ)) {
                                        endEvent.getOperations().put(operation.getId(), operation);
                                        continue;
                                    }
                                    endEvent.getDefined().put(operation.getId(), operation);
                                    continue;
                                }
                                if (!operation.getFieldType().equals((Object)KnownElementFieldType.OutputParameter)) continue;
                                camundaOutput.put(operation.getId(), operation);
                            }
                            succ.addDefined(camundaOutput);
                            succ.getPredecessors().forEach(pred -> {
                                if (pred.getBaseElement() instanceof CallActivity) {
                                    succ.removePredecessor(pred.getId());
                                }
                            });
                        }
                    });
                    ids.add(analysisElement.getId());
                }
                LinkedHashMap<String, ProcessVariableOperation> initialOperations = new LinkedHashMap<String, ProcessVariableOperation>();
                analysisElement.getOperations().values().forEach(operation -> {
                    if (operation.getFieldType().equals((Object)KnownElementFieldType.Initial)) {
                        initialOperations.put(operation.getId(), (ProcessVariableOperation)operation);
                    }
                });
                analysisElement.addDefined(initialOperations);
            }
            this.embedCallActivities((AnalysisElement)analysisElement, hasNodesBefore);
        });
        temp.putAll(cfgNodes);
        this.nodes.putAll(temp);
        ids.forEach(id -> {
            AnalysisElement cfr_ignored_0 = (AnalysisElement)this.nodes.remove(id);
        });
    }

    private void embedCallActivities(AnalysisElement analysisElement, boolean hasNodesBefore) {
        LinkedHashMap camundaIn = new LinkedHashMap();
        ArrayList<ProcessVariableOperation> operationList = new ArrayList<ProcessVariableOperation>();
        if (analysisElement.getBaseElement() instanceof CallActivity) {
            analysisElement.getSuccessors().forEach(succ -> {
                if (succ.getBaseElement() instanceof StartEvent) {
                    analysisElement.getOperations().values().forEach(operation -> {
                        if (operation.getFieldType().equals((Object)KnownElementFieldType.CamundaIn)) {
                            if (operation.getOperation().equals((Object)VariableOperation.READ)) {
                                succ.getOperations().put(operation.getId(), (ProcessVariableOperation)operation);
                            } else {
                                succ.getDefined().put(operation.getId(), (ProcessVariableOperation)operation);
                            }
                            operationList.add((ProcessVariableOperation)operation);
                        } else if (operation.getFieldType().equals((Object)KnownElementFieldType.InputParameter)) {
                            camundaIn.put(operation.getId(), operation);
                            operationList.add((ProcessVariableOperation)operation);
                        }
                    });
                    if (!hasNodesBefore) {
                        succ.addDefined(camundaIn);
                    }
                } else if (succ.getBaseElement() instanceof SequenceFlow) {
                    analysisElement.removeSuccessor(succ.getId());
                } else {
                    analysisElement.removeSuccessor(succ.getId());
                    succ.removePredecessor(analysisElement.getId());
                }
            });
        }
        operationList.forEach(analysisElement::removeOperation);
        if (analysisElement.getBaseElement() instanceof StartEvent) {
            analysisElement.getPredecessors().forEach(pred -> {
                if (pred.getBaseElement() instanceof EndEvent) {
                    analysisElement.removePredecessor(pred.getId());
                }
            });
        }
        if (analysisElement.getBaseElement() instanceof EndEvent) {
            analysisElement.getSuccessors().forEach(succ -> {
                if (succ.getBaseElement() instanceof StartEvent) {
                    analysisElement.removeSuccessor(succ.getId());
                }
            });
        }
    }

    private void computeReachingDefinitions() {
        boolean change = true;
        while (change) {
            change = false;
            for (AnalysisElement analysisElement : this.nodes.values()) {
                LinkedHashMap<String, ProcessVariableOperation> inUsed = new LinkedHashMap<String, ProcessVariableOperation>();
                LinkedHashMap<String, ProcessVariableOperation> inUnused = new LinkedHashMap<String, ProcessVariableOperation>();
                HashSet inUsedT = new HashSet(inUsed.values());
                HashSet inUnusedT = new HashSet(inUnused.values());
                List<AnalysisElement> predecessors = analysisElement.getPredecessors();
                if (predecessors.size() > 1) {
                    for (int i = 0; i < predecessors.size(); ++i) {
                        if (i == 0) {
                            inUsedT.addAll(predecessors.get(i).getOutUsed().values());
                            inUnusedT.addAll(predecessors.get(i).getOutUnused().values());
                            continue;
                        }
                        inUsedT.retainAll(predecessors.get(i).getOutUsed().values());
                        inUnusedT.retainAll(predecessors.get(i).getOutUnused().values());
                    }
                    inUsedT.forEach(pvo -> inUsed.put(pvo.getId(), (ProcessVariableOperation)pvo));
                    inUnusedT.forEach(pvo -> inUnused.put(pvo.getId(), (ProcessVariableOperation)pvo));
                } else {
                    for (AnalysisElement pred : predecessors) {
                        LinkedHashMap<String, ProcessVariableOperation>[] inSets = this.filterInputVariables(pred, analysisElement);
                        inUsed.putAll(inSets[0]);
                        inUnused.putAll(inSets[1]);
                    }
                }
                analysisElement.setInUsed(inUsed);
                analysisElement.setInUnused(inUnused);
                LinkedHashMap<String, ProcessVariableOperation> oldOutUnused = analysisElement.getOutUnused();
                LinkedHashMap<String, ProcessVariableOperation> oldOutUsed = analysisElement.getOutUsed();
                LinkedHashMap<String, ProcessVariableOperation> inUsedTemp = new LinkedHashMap<String, ProcessVariableOperation>(analysisElement.getInUsed());
                LinkedHashMap<String, ProcessVariableOperation> internalUnion = new LinkedHashMap<String, ProcessVariableOperation>();
                internalUnion.putAll(analysisElement.getInUnused());
                LinkedHashMap<String, ProcessVariableOperation> tempUsed = new LinkedHashMap<String, ProcessVariableOperation>();
                tempUsed.putAll(analysisElement.getUsed());
                for (Map.Entry<String, ProcessVariableOperation> operation : analysisElement.getDefined().entrySet()) {
                    Optional<Map.Entry> oldOperation = internalUnion.entrySet().stream().filter(entry -> ((ProcessVariableOperation)entry.getValue()).getName().equals(((ProcessVariableOperation)operation.getValue()).getName())).findFirst();
                    oldOperation.ifPresent(stringProcessVariableOperationEntry -> {
                        ProcessVariableOperation cfr_ignored_0 = (ProcessVariableOperation)internalUnion.remove(stringProcessVariableOperationEntry.getKey());
                    });
                    internalUnion.put(operation.getKey(), operation.getValue());
                    oldOperation = inUsed.entrySet().stream().filter(entry -> ((ProcessVariableOperation)entry.getValue()).getName().equals(((ProcessVariableOperation)operation.getValue()).getName())).findFirst();
                    oldOperation.ifPresent(o -> {
                        ProcessVariableOperation cfr_ignored_0 = (ProcessVariableOperation)tempUsed.put((String)o.getKey(), (ProcessVariableOperation)o.getValue());
                    });
                }
                LinkedHashMap<String, ProcessVariableOperation> internalIntersection = new LinkedHashMap<String, ProcessVariableOperation>(this.getIntersection(internalUnion, analysisElement.getUsed()));
                inUsedTemp.putAll(internalIntersection);
                LinkedHashMap<String, ProcessVariableOperation> outUsed = new LinkedHashMap<String, ProcessVariableOperation>(this.getSetDifference(inUsedTemp, analysisElement.getKilled()));
                LinkedHashMap<String, ProcessVariableOperation> tempKillSet = new LinkedHashMap<String, ProcessVariableOperation>();
                tempKillSet.putAll(analysisElement.getKilled());
                tempKillSet.putAll(tempUsed);
                LinkedHashMap<String, ProcessVariableOperation> outUnused = new LinkedHashMap<String, ProcessVariableOperation>(this.getSetDifference(internalUnion, tempKillSet));
                analysisElement.setOutUsed(outUsed);
                analysisElement.setOutUnused(outUnused);
                if (oldOutUnused.equals(outUnused) && oldOutUsed.equals(outUsed)) continue;
                change = true;
            }
        }
    }

    private LinkedHashMap<String, ProcessVariableOperation>[] filterInputVariables(AnalysisElement predecessor, AnalysisElement analysisElement) {
        String scopePredecessor = predecessor.getBaseElement().getScope().getAttributeValue("id");
        String scopeElement = analysisElement.getBaseElement().getScope().getAttributeValue("id");
        LinkedHashMap<String, ProcessVariableOperation> tempInUsed = new LinkedHashMap<String, ProcessVariableOperation>(predecessor.getOutUsed());
        LinkedHashMap<String, ProcessVariableOperation> tempInUnused = new LinkedHashMap<String, ProcessVariableOperation>(predecessor.getOutUnused());
        if (!scopeElement.equals(scopePredecessor)) {
            if (predecessor.getBaseElement() instanceof EndEvent) {
                predecessor.getOutUnused().forEach((key, value) -> {
                    if (value.getScopeId().equals(scopePredecessor)) {
                        tempInUnused.remove(key);
                    }
                });
                predecessor.getOutUsed().forEach((key, value) -> {
                    if (value.getScopeId().equals(scopePredecessor)) {
                        tempInUsed.remove(key);
                    }
                });
            }
        } else if (!predecessor.getParentElement().getId().equals(analysisElement.getParentElement().getId())) {
            predecessor.getOutUnused().forEach((key, value) -> {
                if (value.getScopeId().equals(predecessor.getParentElement().getId())) {
                    tempInUnused.remove(key);
                }
            });
            predecessor.getOutUsed().forEach((key, value) -> {
                if (value.getScopeId().equals(predecessor.getParentElement().getId())) {
                    tempInUsed.remove(key);
                }
            });
        }
        return new LinkedHashMap[]{tempInUsed, tempInUnused};
    }

    private void computeLineByLine() {
        this.nodes.values().forEach(analysisElement -> {
            Node tmpNode;
            LinkedHashMap<String, ProcessVariableOperation> operations = new LinkedHashMap<String, ProcessVariableOperation>(analysisElement.getOperations());
            if (analysisElement.getParentElement().getBaseElement() instanceof CallActivity && analysisElement instanceof Node && ((tmpNode = (Node)analysisElement).getElementChapter().equals((Object)ElementChapter.InputImplementation) || tmpNode.getElementChapter().equals((Object)ElementChapter.OutputImplementation))) {
                String childProcessId = ((CallActivity)analysisElement.getParentElement().getBaseElement()).getCalledElement();
                analysisElement.getOperations().forEach((key, value) -> {
                    if (value.getScopeId().equals(childProcessId)) {
                        operations.remove(key);
                    }
                });
            }
            if (operations.size() >= 2) {
                ProcessVariableOperation prev = null;
                for (ProcessVariableOperation operation : operations.values()) {
                    if (prev == null) {
                        prev = operation;
                        continue;
                    }
                    this.checkAnomaly(operation.getElement(), operation, prev, analysisElement.getId());
                    prev = operation;
                }
            }
        });
    }

    private void extractAnomalies() {
        this.nodes.values().forEach(node -> {
            if (node.getParentElement().getBaseElement() instanceof CallActivity && node instanceof Node) {
                Node tmpNode = (Node)node;
                if (tmpNode.getElementChapter().equals((Object)ElementChapter.InputImplementation) || tmpNode.getElementChapter().equals((Object)ElementChapter.OutputImplementation)) {
                    String childProcessId = ((CallActivity)node.getParentElement().getBaseElement()).getCalledElement();
                    this.handleDelegateVariableMapping((AnalysisElement)node, childProcessId);
                }
            } else {
                this.ddAnomalies((AnalysisElement)node);
                this.duAnomalies((AnalysisElement)node);
                this.urAnomalies((AnalysisElement)node);
                this.uuAnomalies((AnalysisElement)node);
            }
        });
    }

    private void handleDelegateVariableMapping(AnalysisElement element, String childProcessId) {
        LinkedHashMap<String, ProcessVariableOperation> originalOperations = new LinkedHashMap<String, ProcessVariableOperation>(element.getOperations());
        LinkedHashMap<String, ProcessVariableOperation> originalDefined = new LinkedHashMap<String, ProcessVariableOperation>(element.getDefined());
        LinkedHashMap<String, ProcessVariableOperation> originalUsed = new LinkedHashMap<String, ProcessVariableOperation>(element.getUsed());
        LinkedHashMap<String, ProcessVariableOperation> originalInUnused = new LinkedHashMap<String, ProcessVariableOperation>(element.getInUnused());
        LinkedHashMap<String, ProcessVariableOperation> originalInUsed = new LinkedHashMap<String, ProcessVariableOperation>(element.getInUsed());
        this.filterDelegateVariables(originalOperations, element.getOperations(), childProcessId);
        this.filterDelegateVariables(originalDefined, element.getDefined(), childProcessId);
        this.filterDelegateVariables(originalUsed, element.getUsed(), childProcessId);
        this.filterDelegateVariables(originalInUnused, element.getInUnused(), childProcessId);
        this.filterDelegateVariables(originalInUsed, element.getInUsed(), childProcessId);
        this.ddAnomalies(element);
        this.duAnomalies(element);
        this.urAnomalies(element);
        this.uuAnomalies(element);
        element.setOperations(originalOperations);
        element.setDefined(originalDefined);
        element.setUsed(originalUsed);
        element.setInUnused(originalInUnused);
        element.setInUsed(originalInUsed);
    }

    private void filterDelegateVariables(LinkedHashMap<String, ProcessVariableOperation> in, LinkedHashMap<String, ProcessVariableOperation> out, String childProcessId) {
        in.forEach((key, value) -> {
            if (value.getScopeId().equals(childProcessId)) {
                out.remove(key);
            }
        });
    }

    private void ddAnomalies(AnalysisElement node) {
        LinkedHashMap<String, ProcessVariableOperation> ddAnomalies = new LinkedHashMap<String, ProcessVariableOperation>(this.getIntersection(node.getInUnused(), node.getDefined()));
        if (!ddAnomalies.isEmpty()) {
            ddAnomalies.forEach((k, v) -> node.addSourceCodeAnomaly(new AnomalyContainer(v.getName(), Anomaly.DD, node.getId(), node.getBaseElement().getId(), node.getBaseElement().getAttributeValue("name"), (ProcessVariableOperation)v)));
        }
    }

    private void duAnomalies(AnalysisElement node) {
        LinkedHashMap<String, ProcessVariableOperation> duAnomalies = new LinkedHashMap<String, ProcessVariableOperation>(this.getIntersection(node.getInUnused(), node.getKilled()));
        if (!duAnomalies.isEmpty()) {
            duAnomalies.forEach((k, v) -> node.addSourceCodeAnomaly(new AnomalyContainer(v.getName(), Anomaly.DU, node.getId(), node.getBaseElement().getId(), node.getBaseElement().getAttributeValue("name"), (ProcessVariableOperation)v)));
        }
    }

    private void urAnomalies(AnalysisElement node) {
        LinkedHashMap<String, ProcessVariableOperation> urAnomaliesTemp = new LinkedHashMap<String, ProcessVariableOperation>(node.getUsed());
        LinkedHashMap<String, ProcessVariableOperation> urAnomalies = new LinkedHashMap<String, ProcessVariableOperation>(urAnomaliesTemp);
        urAnomaliesTemp.forEach((key, value) -> node.getInUnused().forEach((key2, value2) -> {
            if (value.getName().equals(value2.getName())) {
                urAnomalies.remove(key);
            }
        }));
        urAnomaliesTemp.forEach((key, value) -> node.getInUsed().forEach((key2, value2) -> {
            if (value.getName().equals(value2.getName())) {
                urAnomalies.remove(key);
            }
        }));
        urAnomaliesTemp.forEach((key, value) -> node.getDefined().forEach((key2, value2) -> {
            if (value.getName().equals(value2.getName()) && value.getIndex() > value2.getIndex()) {
                urAnomalies.remove(key);
            }
        }));
        if (!urAnomalies.isEmpty()) {
            urAnomalies.forEach((k, v) -> node.addSourceCodeAnomaly(new AnomalyContainer(v.getName(), Anomaly.UR, node.getId(), node.getBaseElement().getId(), node.getBaseElement().getAttributeValue("name"), (ProcessVariableOperation)v)));
        }
    }

    private void uuAnomalies(AnalysisElement node) {
        LinkedHashMap<String, ProcessVariableOperation> uuAnomaliesTemp = new LinkedHashMap<String, ProcessVariableOperation>(node.getKilled());
        LinkedHashMap<String, ProcessVariableOperation> uuAnomalies = new LinkedHashMap<String, ProcessVariableOperation>(uuAnomaliesTemp);
        uuAnomaliesTemp.forEach((key, value) -> node.getInUnused().forEach((key2, value2) -> {
            if (value.getName().equals(value2.getName())) {
                uuAnomalies.remove(key);
            }
        }));
        uuAnomaliesTemp.forEach((key, value) -> node.getInUsed().forEach((key2, value2) -> {
            if (value.getName().equals(value2.getName())) {
                uuAnomalies.remove(key);
            }
        }));
        uuAnomaliesTemp.forEach((key, value) -> node.getDefined().forEach((key2, value2) -> {
            if (value.getName().equals(value2.getName()) && value.getIndex() > value2.getIndex()) {
                uuAnomalies.remove(key);
            }
        }));
        if (!uuAnomalies.isEmpty()) {
            uuAnomalies.forEach((k, v) -> node.addSourceCodeAnomaly(new AnomalyContainer(v.getName(), Anomaly.UU, node.getId(), node.getBaseElement().getId(), node.getBaseElement().getAttributeValue("name"), (ProcessVariableOperation)v)));
        }
    }

    private void checkAnomaly(BpmnElement element, ProcessVariableOperation curr, ProcessVariableOperation prev, String nodeId) {
        if (this.urSourceCode(prev, curr)) {
            element.addSourceCodeAnomaly(new AnomalyContainer(curr.getName(), Anomaly.UR, nodeId, element.getBaseElement().getId(), element.getBaseElement().getAttributeValue("name"), curr));
        }
        if (this.ddSourceCode(prev, curr)) {
            element.addSourceCodeAnomaly(new AnomalyContainer(curr.getName(), Anomaly.DD, nodeId, element.getBaseElement().getId(), element.getBaseElement().getAttributeValue("name"), curr));
        }
        if (this.duSourceCode(prev, curr)) {
            element.addSourceCodeAnomaly(new AnomalyContainer(curr.getName(), Anomaly.DU, nodeId, element.getBaseElement().getId(), element.getBaseElement().getAttributeValue("name"), curr));
        }
        if (this.uuSourceCode(prev, curr)) {
            element.addSourceCodeAnomaly(new AnomalyContainer(curr.getName(), Anomaly.UU, nodeId, element.getBaseElement().getId(), element.getBaseElement().getAttributeValue("name"), curr));
        }
    }

    private boolean uuSourceCode(ProcessVariableOperation prev, ProcessVariableOperation curr) {
        return curr.getOperation().equals((Object)VariableOperation.DELETE) && prev.getOperation().equals((Object)VariableOperation.DELETE);
    }

    private boolean urSourceCode(ProcessVariableOperation prev, ProcessVariableOperation curr) {
        return curr.getOperation().equals((Object)VariableOperation.READ) && prev.getOperation().equals((Object)VariableOperation.DELETE);
    }

    private boolean ddSourceCode(ProcessVariableOperation prev, ProcessVariableOperation curr) {
        return curr.getOperation().equals((Object)VariableOperation.WRITE) && prev.getOperation().equals((Object)VariableOperation.WRITE) && curr.getName().equals(prev.getName());
    }

    private boolean duSourceCode(ProcessVariableOperation prev, ProcessVariableOperation curr) {
        return curr.getOperation().equals((Object)VariableOperation.DELETE) && prev.getOperation().equals((Object)VariableOperation.WRITE);
    }

    private LinkedHashMap<String, ProcessVariableOperation> getSetDifference(LinkedHashMap<String, ProcessVariableOperation> mapOne, LinkedHashMap<String, ProcessVariableOperation> mapTwo) {
        LinkedHashMap<String, ProcessVariableOperation> setDifference = new LinkedHashMap<String, ProcessVariableOperation>(mapOne);
        mapOne.forEach((key, value) -> mapTwo.forEach((key2, value2) -> {
            if (value.getName().equals(value2.getName()) && this.isDelegateVariable((ProcessVariableOperation)value) == this.isDelegateVariable((ProcessVariableOperation)value2)) {
                setDifference.remove(key);
            }
        }));
        return setDifference;
    }

    private LinkedHashMap<String, ProcessVariableOperation> getIntersection(LinkedHashMap<String, ProcessVariableOperation> mapOne, LinkedHashMap<String, ProcessVariableOperation> mapTwo) {
        LinkedHashMap<String, ProcessVariableOperation> intersection = new LinkedHashMap<String, ProcessVariableOperation>();
        mapOne.forEach((key, value) -> mapTwo.forEach((key2, value2) -> {
            if (value.getName().equals(value2.getName()) && this.isDelegateVariable((ProcessVariableOperation)value) == this.isDelegateVariable((ProcessVariableOperation)value2)) {
                intersection.put((String)key, (ProcessVariableOperation)value);
            }
        }));
        return intersection;
    }

    public LinkedHashMap<String, AnalysisElement> getNodes() {
        return this.nodes;
    }

    public int getOperationCounter() {
        return this.operationCounter;
    }

    public void incrementOperationCounter() {
        ++this.operationCounter;
    }

    private boolean isDelegateVariable(ProcessVariableOperation value) {
        return (value.getChapter().equals((Object)ElementChapter.InputImplementation) || value.getChapter().equals((Object)ElementChapter.OutputImplementation)) && value.getScopeId().equals(((CallActivity)value.getElement().getBaseElement()).getCalledElement());
    }
}

